/* Mapbox GL JS is Copyright © 2020 Mapbox and subject to the Mapbox Terms of Service ((https://www.mapbox.com/legal/tos/). */
(function (global, factory) {
typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :
typeof define === 'function' && define.amd ? define(factory) :
(global = typeof globalThis !== 'undefined' ? globalThis : global || self, global.mapboxgl = factory());
}(this, (function () { 'use strict';

/* eslint-disable */

var shared, worker, mapboxgl;
// define gets called three times: one for each chunk. we rely on the order
// they're imported to know which is which
function define(_, chunk) {
if (!shared) {
    shared = chunk;
} else if (!worker) {
    worker = chunk;
} else {
    var workerBundleString = "self.onerror = function() { console.error('An error occurred while parsing the WebWorker bundle. This is most likely due to improper transpilation by Babel; please see https://docs.mapbox.com/mapbox-gl-js/guides/install/#transpiling'); }; var sharedChunk = {}; (" + shared + ")(sharedChunk); (" + worker + ")(sharedChunk); self.onerror = null;"

    var sharedChunk = {};
    shared(sharedChunk);
    mapboxgl = chunk(sharedChunk);
    if (typeof window !== 'undefined' && window && window.URL && window.URL.createObjectURL) {
        mapboxgl.workerUrl = window.URL.createObjectURL(new Blob([workerBundleString], { type: 'text/javascript' }));
    }
}
}


define(["exports"],(function(t){"use strict";var e="2.7.0",r=n;function n(t,e,r,n){this.cx=3*t,this.bx=3*(r-t)-this.cx,this.ax=1-this.cx-this.bx,this.cy=3*e,this.by=3*(n-e)-this.cy,this.ay=1-this.cy-this.by,this.p1x=t,this.p1y=n,this.p2x=r,this.p2y=n;}n.prototype.sampleCurveX=function(t){return ((this.ax*t+this.bx)*t+this.cx)*t},n.prototype.sampleCurveY=function(t){return ((this.ay*t+this.by)*t+this.cy)*t},n.prototype.sampleCurveDerivativeX=function(t){return (3*this.ax*t+2*this.bx)*t+this.cx},n.prototype.solveCurveX=function(t,e){var r,n,i,s,a;for(void 0===e&&(e=1e-6),i=t,a=0;a<8;a++){if(s=this.sampleCurveX(i)-t,Math.abs(s)<e)return i;var o=this.sampleCurveDerivativeX(i);if(Math.abs(o)<1e-6)break;i-=s/o;}if((i=t)<(r=0))return r;if(i>(n=1))return n;for(;r<n;){if(s=this.sampleCurveX(i),Math.abs(s-t)<e)return i;t>s?r=i:n=i,i=.5*(n-r)+r;}return i},n.prototype.solve=function(t,e){return this.sampleCurveY(this.solveCurveX(t,e))};var i=s;function s(t,e){this.x=t,this.y=e;}s.prototype={clone:function(){return new s(this.x,this.y)},add:function(t){return this.clone()._add(t)},sub:function(t){return this.clone()._sub(t)},multByPoint:function(t){return this.clone()._multByPoint(t)},divByPoint:function(t){return this.clone()._divByPoint(t)},mult:function(t){return this.clone()._mult(t)},div:function(t){return this.clone()._div(t)},rotate:function(t){return this.clone()._rotate(t)},rotateAround:function(t,e){return this.clone()._rotateAround(t,e)},matMult:function(t){return this.clone()._matMult(t)},unit:function(){return this.clone()._unit()},perp:function(){return this.clone()._perp()},round:function(){return this.clone()._round()},mag:function(){return Math.sqrt(this.x*this.x+this.y*this.y)},equals:function(t){return this.x===t.x&&this.y===t.y},dist:function(t){return Math.sqrt(this.distSqr(t))},distSqr:function(t){var e=t.x-this.x,r=t.y-this.y;return e*e+r*r},angle:function(){return Math.atan2(this.y,this.x)},angleTo:function(t){return Math.atan2(this.y-t.y,this.x-t.x)},angleWith:function(t){return this.angleWithSep(t.x,t.y)},angleWithSep:function(t,e){return Math.atan2(this.x*e-this.y*t,this.x*t+this.y*e)},_matMult:function(t){var e=t[2]*this.x+t[3]*this.y;return this.x=t[0]*this.x+t[1]*this.y,this.y=e,this},_add:function(t){return this.x+=t.x,this.y+=t.y,this},_sub:function(t){return this.x-=t.x,this.y-=t.y,this},_mult:function(t){return this.x*=t,this.y*=t,this},_div:function(t){return this.x/=t,this.y/=t,this},_multByPoint:function(t){return this.x*=t.x,this.y*=t.y,this},_divByPoint:function(t){return this.x/=t.x,this.y/=t.y,this},_unit:function(){return this._div(this.mag()),this},_perp:function(){var t=this.y;return this.y=this.x,this.x=-t,this},_rotate:function(t){var e=Math.cos(t),r=Math.sin(t),n=r*this.x+e*this.y;return this.x=e*this.x-r*this.y,this.y=n,this},_rotateAround:function(t,e){var r=Math.cos(t),n=Math.sin(t),i=e.y+n*(this.x-e.x)+r*(this.y-e.y);return this.x=e.x+r*(this.x-e.x)-n*(this.y-e.y),this.y=i,this},_round:function(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this}},s.convert=function(t){return t instanceof s?t:Array.isArray(t)?new s(t[0],t[1]):t};var a="undefined"!=typeof self?self:{},o=1e-6,l="undefined"!=typeof Float32Array?Float32Array:Array;function u(){var t=new l(9);return l!=Float32Array&&(t[1]=0,t[2]=0,t[3]=0,t[5]=0,t[6]=0,t[7]=0),t[0]=1,t[4]=1,t[8]=1,t}function c(t){return t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=1,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=1,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t}function h(t,e,r){var n=e[0],i=e[1],s=e[2],a=e[3],o=e[4],l=e[5],u=e[6],c=e[7],h=e[8],p=e[9],d=e[10],f=e[11],y=e[12],m=e[13],g=e[14],x=e[15],v=r[0],b=r[1],w=r[2],_=r[3];return t[0]=v*n+b*o+w*h+_*y,t[1]=v*i+b*l+w*p+_*m,t[2]=v*s+b*u+w*d+_*g,t[3]=v*a+b*c+w*f+_*x,t[4]=(v=r[4])*n+(b=r[5])*o+(w=r[6])*h+(_=r[7])*y,t[5]=v*i+b*l+w*p+_*m,t[6]=v*s+b*u+w*d+_*g,t[7]=v*a+b*c+w*f+_*x,t[8]=(v=r[8])*n+(b=r[9])*o+(w=r[10])*h+(_=r[11])*y,t[9]=v*i+b*l+w*p+_*m,t[10]=v*s+b*u+w*d+_*g,t[11]=v*a+b*c+w*f+_*x,t[12]=(v=r[12])*n+(b=r[13])*o+(w=r[14])*h+(_=r[15])*y,t[13]=v*i+b*l+w*p+_*m,t[14]=v*s+b*u+w*d+_*g,t[15]=v*a+b*c+w*f+_*x,t}function p(t,e,r){var n,i,s,a,o,l,u,c,h,p,d,f,y=r[0],m=r[1],g=r[2];return e===t?(t[12]=e[0]*y+e[4]*m+e[8]*g+e[12],t[13]=e[1]*y+e[5]*m+e[9]*g+e[13],t[14]=e[2]*y+e[6]*m+e[10]*g+e[14],t[15]=e[3]*y+e[7]*m+e[11]*g+e[15]):(i=e[1],s=e[2],a=e[3],o=e[4],l=e[5],u=e[6],c=e[7],h=e[8],p=e[9],d=e[10],f=e[11],t[0]=n=e[0],t[1]=i,t[2]=s,t[3]=a,t[4]=o,t[5]=l,t[6]=u,t[7]=c,t[8]=h,t[9]=p,t[10]=d,t[11]=f,t[12]=n*y+o*m+h*g+e[12],t[13]=i*y+l*m+p*g+e[13],t[14]=s*y+u*m+d*g+e[14],t[15]=a*y+c*m+f*g+e[15]),t}function d(t,e,r){var n=r[0],i=r[1],s=r[2];return t[0]=e[0]*n,t[1]=e[1]*n,t[2]=e[2]*n,t[3]=e[3]*n,t[4]=e[4]*i,t[5]=e[5]*i,t[6]=e[6]*i,t[7]=e[7]*i,t[8]=e[8]*s,t[9]=e[9]*s,t[10]=e[10]*s,t[11]=e[11]*s,t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t}function f(t,e,r){var n=Math.sin(r),i=Math.cos(r),s=e[4],a=e[5],o=e[6],l=e[7],u=e[8],c=e[9],h=e[10],p=e[11];return e!==t&&(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]),t[4]=s*i+u*n,t[5]=a*i+c*n,t[6]=o*i+h*n,t[7]=l*i+p*n,t[8]=u*i-s*n,t[9]=c*i-a*n,t[10]=h*i-o*n,t[11]=p*i-l*n,t}function y(t,e,r){var n=Math.sin(r),i=Math.cos(r),s=e[0],a=e[1],o=e[2],l=e[3],u=e[8],c=e[9],h=e[10],p=e[11];return e!==t&&(t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]),t[0]=s*i-u*n,t[1]=a*i-c*n,t[2]=o*i-h*n,t[3]=l*i-p*n,t[8]=s*n+u*i,t[9]=a*n+c*i,t[10]=o*n+h*i,t[11]=l*n+p*i,t}Math.hypot||(Math.hypot=function(){for(var t=0,e=arguments.length;e--;)t+=arguments[e]*arguments[e];return Math.sqrt(t)});var m=h;function g(){var t=new l(3);return l!=Float32Array&&(t[0]=0,t[1]=0,t[2]=0),t}function x(t){var e=new l(3);return e[0]=t[0],e[1]=t[1],e[2]=t[2],e}function v(t){return Math.hypot(t[0],t[1],t[2])}function b(t,e,r){var n=new l(3);return n[0]=t,n[1]=e,n[2]=r,n}function w(t,e,r){return t[0]=e[0]+r[0],t[1]=e[1]+r[1],t[2]=e[2]+r[2],t}function _(t,e,r){return t[0]=e[0]-r[0],t[1]=e[1]-r[1],t[2]=e[2]-r[2],t}function A(t,e,r){return t[0]=e[0]*r[0],t[1]=e[1]*r[1],t[2]=e[2]*r[2],t}function k(t,e,r){return t[0]=Math.max(e[0],r[0]),t[1]=Math.max(e[1],r[1]),t[2]=Math.max(e[2],r[2]),t}function S(t,e,r){return t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t}function I(t,e,r,n){return t[0]=e[0]+r[0]*n,t[1]=e[1]+r[1]*n,t[2]=e[2]+r[2]*n,t}function z(t,e){var r=e[0],n=e[1],i=e[2],s=r*r+n*n+i*i;return s>0&&(s=1/Math.sqrt(s)),t[0]=e[0]*s,t[1]=e[1]*s,t[2]=e[2]*s,t}function M(t,e){return t[0]*e[0]+t[1]*e[1]+t[2]*e[2]}function T(t,e,r){var n=e[0],i=e[1],s=e[2],a=r[0],o=r[1],l=r[2];return t[0]=i*l-s*o,t[1]=s*a-n*l,t[2]=n*o-i*a,t}function B(t,e,r){var n=e[0],i=e[1],s=e[2],a=r[3]*n+r[7]*i+r[11]*s+r[15];return t[0]=(r[0]*n+r[4]*i+r[8]*s+r[12])/(a=a||1),t[1]=(r[1]*n+r[5]*i+r[9]*s+r[13])/a,t[2]=(r[2]*n+r[6]*i+r[10]*s+r[14])/a,t}function C(t,e,r){var n=r[0],i=r[1],s=r[2],a=e[0],o=e[1],l=e[2],u=i*l-s*o,c=s*a-n*l,h=n*o-i*a,p=i*h-s*c,d=s*u-n*h,f=n*c-i*u,y=2*r[3];return c*=y,h*=y,d*=2,f*=2,t[0]=a+(u*=y)+(p*=2),t[1]=o+c+d,t[2]=l+h+f,t}var P,E=_,D=A,V=v;function F(t,e,r){var n=e[0],i=e[1],s=e[2],a=e[3];return t[0]=r[0]*n+r[4]*i+r[8]*s+r[12]*a,t[1]=r[1]*n+r[5]*i+r[9]*s+r[13]*a,t[2]=r[2]*n+r[6]*i+r[10]*s+r[14]*a,t[3]=r[3]*n+r[7]*i+r[11]*s+r[15]*a,t}function L(){var t=new l(4);return l!=Float32Array&&(t[0]=0,t[1]=0,t[2]=0),t[3]=1,t}function R(t){return t[0]=0,t[1]=0,t[2]=0,t[3]=1,t}function U(t,e,r){r*=.5;var n=e[0],i=e[1],s=e[2],a=e[3],o=Math.sin(r),l=Math.cos(r);return t[0]=n*l+a*o,t[1]=i*l+s*o,t[2]=s*l-i*o,t[3]=a*l-n*o,t}function $(t,e){return t[0]===e[0]&&t[1]===e[1]}g(),P=new l(4),l!=Float32Array&&(P[0]=0,P[1]=0,P[2]=0,P[3]=0),g(),b(1,0,0),b(0,1,0),L(),L(),u(),function(){var t;t=new l(2),l!=Float32Array&&(t[0]=0,t[1]=0);}();const O=Math.PI/180,j=180/Math.PI;function q(t){return t*O}function N(t){return t*j}const G=[[0,0],[1,0],[1,1],[0,1]];function Z(t){if(t<=0)return 0;if(t>=1)return 1;const e=t*t,r=e*t;return 4*(t<.5?r:3*(t-e)+r-.75)}function X(t,e,n,i){const s=new r(t,e,n,i);return function(t){return s.solve(t)}}const K=X(.25,.1,.25,1);function Y(t,e,r){return Math.min(r,Math.max(e,t))}function H(t,e,r){return (r=Y((r-t)/(e-t),0,1))*r*(3-2*r)}function J(t,e,r){const n=r-e,i=((t-e)%n+n)%n+e;return i===e?r:i}function W(t,e,r){if(!t.length)return r(null,[]);let n=t.length;const i=new Array(t.length);let s=null;t.forEach(((t,a)=>{e(t,((t,e)=>{t&&(s=t),i[a]=e,0==--n&&r(s,i);}));}));}function Q(t){const e=[];for(const r in t)e.push(t[r]);return e}function tt(t,...e){for(const r of e)for(const e in r)t[e]=r[e];return t}let et=1;function rt(){return et++}function nt(){return function t(e){return e?(e^16*Math.random()>>e/4).toString(16):([1e7]+-[1e3]+-4e3+-8e3+-1e11).replace(/[018]/g,t)}()}function it(t){return t<=1?1:Math.pow(2,Math.ceil(Math.log(t)/Math.LN2))}function st(t){return !!t&&/^[0-9a-f]{8}-[0-9a-f]{4}-[4][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}$/i.test(t)}function at(t,e){t.forEach((t=>{e[t]&&(e[t]=e[t].bind(e));}));}function ot(t,e){return -1!==t.indexOf(e,t.length-e.length)}function lt(t,e,r){const n={};for(const i in t)n[i]=e.call(r||this,t[i],i,t);return n}function ut(t,e,r){const n={};for(const i in t)e.call(r||this,t[i],i,t)&&(n[i]=t[i]);return n}function ct(t){return Array.isArray(t)?t.map(ct):"object"==typeof t&&t?lt(t,ct):t}const ht={};function pt(t){ht[t]||("undefined"!=typeof console&&console.warn(t),ht[t]=!0);}function dt(t,e,r){return (r.y-t.y)*(e.x-t.x)>(e.y-t.y)*(r.x-t.x)}function ft(t){let e=0;for(let r,n,i=0,s=t.length,a=s-1;i<s;a=i++)r=t[i],n=t[a],e+=(n.x-r.x)*(r.y+n.y);return e}function yt(){return "undefined"!=typeof WorkerGlobalScope&&"undefined"!=typeof self&&self instanceof WorkerGlobalScope}function mt(t){const e={};if(t.replace(/(?:^|(?:\s*\,\s*))([^\x00-\x20\(\)<>@\,;\:\\"\/\[\]\?\=\{\}\x7F]+)(?:\=(?:([^\x00-\x20\(\)<>@\,;\:\\"\/\[\]\?\=\{\}\x7F]+)|(?:\"((?:[^"\\]|\\.)*)\")))?/g,((t,r,n,i)=>{const s=n||i;return e[r]=!s||s.toLowerCase(),""})),e["max-age"]){const t=parseInt(e["max-age"],10);isNaN(t)?delete e["max-age"]:e["max-age"]=t;}return e}let gt,xt,vt,bt=null;function wt(t){if(null==bt){const e=t.navigator?t.navigator.userAgent:null;bt=!!t.safari||!(!e||!(/\b(iPad|iPhone|iPod)\b/.test(e)||e.match("Safari")&&!e.match("Chrome")));}return bt}function _t(t){try{const e=a[t];return e.setItem("_mapbox_test_",1),e.removeItem("_mapbox_test_"),!0}catch(t){return !1}}const At={now:()=>void 0!==vt?vt:a.performance.now(),setNow(t){vt=t;},restoreNow(){vt=void 0;},frame(t){const e=a.requestAnimationFrame(t);return {cancel:()=>a.cancelAnimationFrame(e)}},getImageData(t,e=0){const r=a.document.createElement("canvas"),n=r.getContext("2d");if(!n)throw new Error("failed to create canvas 2d context");return r.width=t.width,r.height=t.height,n.drawImage(t,0,0,t.width,t.height),n.getImageData(-e,-e,t.width+2*e,t.height+2*e)},resolveURL:t=>(gt||(gt=a.document.createElement("a")),gt.href=t,gt.href),get devicePixelRatio(){return a.devicePixelRatio},get prefersReducedMotion(){return !!a.matchMedia&&(null==xt&&(xt=a.matchMedia("(prefers-reduced-motion: reduce)")),xt.matches)}};let kt;const St={API_URL:"https://api.mapbox.com",get API_URL_REGEX(){if(null==kt){const t=/^((https?:)?\/\/)?([^\/]+\.)?mapbox\.c(n|om)(\/|\?|$)/i;try{kt=null!=process.env.API_URL_REGEX?new RegExp(process.env.API_URL_REGEX):t;}catch(e){kt=t;}}return kt},get EVENTS_URL(){return this.API_URL?0===this.API_URL.indexOf("https://api.mapbox.cn")?"https://events.mapbox.cn/events/v2":0===this.API_URL.indexOf("https://api.mapbox.com")?"https://events.mapbox.com/events/v2":null:null},SESSION_PATH:"/map-sessions/v1",FEEDBACK_URL:"https://apps.mapbox.com/feedback",TILE_URL_VERSION:"v4",RASTER_URL_PREFIX:"raster/v1",REQUIRE_ACCESS_TOKEN:!0,ACCESS_TOKEN:null,MAX_PARALLEL_IMAGE_REQUESTS:16},It={supported:!1,testSupport:function(t){!Tt&&Mt&&(Bt?Ct(t):zt=t);}};let zt,Mt,Tt=!1,Bt=!1;function Ct(t){const e=t.createTexture();t.bindTexture(t.TEXTURE_2D,e);try{if(t.texImage2D(t.TEXTURE_2D,0,t.RGBA,t.RGBA,t.UNSIGNED_BYTE,Mt),t.isContextLost())return;It.supported=!0;}catch(t){}t.deleteTexture(e),Tt=!0;}a.document&&(Mt=a.document.createElement("img"),Mt.onload=function(){zt&&Ct(zt),zt=null,Bt=!0;},Mt.onerror=function(){Tt=!0,zt=null;},Mt.src="data:image/webp;base64,UklGRh4AAABXRUJQVlA4TBEAAAAvAQAAAAfQ//73v/+BiOh/AAA=");const Pt="01",Et="NO_ACCESS_TOKEN";function Dt(t){return 0===t.indexOf("mapbox:")}function Vt(t){return St.API_URL_REGEX.test(t)}const Ft=/^(\w+):\/\/([^/?]*)(\/[^?]+)?\??(.+)?/;function Lt(t){const e=t.match(Ft);if(!e)throw new Error("Unable to parse URL object");return {protocol:e[1],authority:e[2],path:e[3]||"/",params:e[4]?e[4].split("&"):[]}}function Rt(t){const e=t.params.length?`?${t.params.join("&")}`:"";return `${t.protocol}://${t.authority}${t.path}${e}`}function Ut(t){if(!t)return null;const e=t.split(".");if(!e||3!==e.length)return null;try{return JSON.parse(decodeURIComponent(a.atob(e[1]).split("").map((t=>"%"+("00"+t.charCodeAt(0).toString(16)).slice(-2))).join("")))}catch(t){return null}}class $t{constructor(t){this.type=t,this.anonId=null,this.eventData={},this.queue=[],this.pendingRequest=null;}getStorageKey(t){const e=Ut(St.ACCESS_TOKEN);let r="";return r=e&&e.u?a.btoa(encodeURIComponent(e.u).replace(/%([0-9A-F]{2})/g,((t,e)=>String.fromCharCode(Number("0x"+e))))):St.ACCESS_TOKEN||"",t?`mapbox.eventData.${t}:${r}`:`mapbox.eventData:${r}`}fetchEventData(){const t=_t("localStorage"),e=this.getStorageKey(),r=this.getStorageKey("uuid");if(t)try{const t=a.localStorage.getItem(e);t&&(this.eventData=JSON.parse(t));const n=a.localStorage.getItem(r);n&&(this.anonId=n);}catch(t){pt("Unable to read from LocalStorage");}}saveEventData(){const t=_t("localStorage"),e=this.getStorageKey(),r=this.getStorageKey("uuid");if(t)try{a.localStorage.setItem(r,this.anonId),Object.keys(this.eventData).length>=1&&a.localStorage.setItem(e,JSON.stringify(this.eventData));}catch(t){pt("Unable to write to LocalStorage");}}processRequests(t){}postEvent(t,r,n,i){if(!St.EVENTS_URL)return;const s=Lt(St.EVENTS_URL);s.params.push(`access_token=${i||St.ACCESS_TOKEN||""}`);const a={event:this.type,created:new Date(t).toISOString(),sdkIdentifier:"mapbox-gl-js",sdkVersion:e,skuId:Pt,userId:this.anonId},o=r?tt(a,r):a,l={url:Rt(s),headers:{"Content-Type":"text/plain"},body:JSON.stringify([o])};this.pendingRequest=oe(l,(t=>{this.pendingRequest=null,n(t),this.saveEventData(),this.processRequests(i);}));}queueRequest(t,e){this.queue.push(t),this.processRequests(e);}}const Ot=new class extends $t{constructor(t){super("appUserTurnstile"),this._customAccessToken=t;}postTurnstileEvent(t,e){St.EVENTS_URL&&St.ACCESS_TOKEN&&Array.isArray(t)&&t.some((t=>Dt(t)||Vt(t)))&&this.queueRequest(Date.now(),e);}processRequests(t){if(this.pendingRequest||0===this.queue.length)return;this.anonId&&this.eventData.lastSuccess&&this.eventData.tokenU||this.fetchEventData();const e=Ut(St.ACCESS_TOKEN),r=e?e.u:St.ACCESS_TOKEN;let n=r!==this.eventData.tokenU;st(this.anonId)||(this.anonId=nt(),n=!0);const i=this.queue.shift();if(this.eventData.lastSuccess){const t=new Date(this.eventData.lastSuccess),e=new Date(i),r=(i-this.eventData.lastSuccess)/864e5;n=n||r>=1||r<-1||t.getDate()!==e.getDate();}else n=!0;if(!n)return this.processRequests();this.postEvent(i,{"enabled.telemetry":!1},(t=>{t||(this.eventData.lastSuccess=i,this.eventData.tokenU=r);}),t);}},jt=Ot.postTurnstileEvent.bind(Ot),qt=new class extends $t{constructor(){super("map.load"),this.success={},this.skuToken="";}postMapLoadEvent(t,e,r,n){this.skuToken=e,this.errorCb=n,St.EVENTS_URL&&(r||St.ACCESS_TOKEN?this.queueRequest({id:t,timestamp:Date.now()},r):this.errorCb(new Error(Et)));}processRequests(t){if(this.pendingRequest||0===this.queue.length)return;const{id:e,timestamp:r}=this.queue.shift();e&&this.success[e]||(this.anonId||this.fetchEventData(),st(this.anonId)||(this.anonId=nt()),this.postEvent(r,{skuToken:this.skuToken},(t=>{t?this.errorCb(t):e&&(this.success[e]=!0);}),t));}},Nt=qt.postMapLoadEvent.bind(qt),Gt=new class extends $t{constructor(){super("map.auth"),this.success={},this.skuToken="";}getSession(t,e,r,n){if(!St.API_URL||!St.SESSION_PATH)return;const i=Lt(St.API_URL+St.SESSION_PATH);i.params.push(`sku=${e||""}`),i.params.push(`access_token=${n||St.ACCESS_TOKEN||""}`);const s={url:Rt(i),headers:{"Content-Type":"text/plain"}};this.pendingRequest=le(s,(t=>{this.pendingRequest=null,r(t),this.saveEventData(),this.processRequests(n);}));}getSessionAPI(t,e,r,n){this.skuToken=e,this.errorCb=n,St.SESSION_PATH&&St.API_URL&&(r||St.ACCESS_TOKEN?this.queueRequest({id:t,timestamp:Date.now()},r):this.errorCb(new Error(Et)));}processRequests(t){if(this.pendingRequest||0===this.queue.length)return;const{id:e,timestamp:r}=this.queue.shift();e&&this.success[e]||this.getSession(r,this.skuToken,(t=>{t?this.errorCb(t):e&&(this.success[e]=!0);}),t);}},Zt=Gt.getSessionAPI.bind(Gt),Xt=new Set,Kt="mapbox-tiles";let Yt,Ht,Jt=500,Wt=50;function Qt(){a.caches&&!Yt&&(Yt=a.caches.open(Kt));}function te(t){const e=t.indexOf("?");return e<0?t:t.slice(0,e)}let ee=1/0;const re={Unknown:"Unknown",Style:"Style",Source:"Source",Tile:"Tile",Glyphs:"Glyphs",SpriteImage:"SpriteImage",SpriteJSON:"SpriteJSON",Image:"Image"};"function"==typeof Object.freeze&&Object.freeze(re);class ne extends Error{constructor(t,e,r){401===e&&Vt(r)&&(t+=": you may have provided an invalid Mapbox access token. See https://www.mapbox.com/api-documentation/#access-tokens-and-token-scopes"),super(t),this.status=e,this.url=r;}toString(){return `${this.name}: ${this.message} (${this.status}): ${this.url}`}}const ie=yt()?()=>self.worker&&self.worker.referrer:()=>("blob:"===a.location.protocol?a.parent:a).location.href;const se=function(t,e){if(!(/^file:/.test(r=t.url)||/^file:/.test(ie())&&!/^\w+:/.test(r))){if(a.fetch&&a.Request&&a.AbortController&&a.Request.prototype.hasOwnProperty("signal"))return function(t,e){const r=new a.AbortController,n=new a.Request(t.url,{method:t.method||"GET",body:t.body,credentials:t.credentials,headers:t.headers,referrer:ie(),signal:r.signal});let i=!1,s=!1;const o=(l=n.url).indexOf("sku=")>0&&Vt(l);var l;"json"===t.type&&n.headers.set("Accept","application/json");const u=(r,i,l)=>{if(s)return;if(r&&"SecurityError"!==r.message&&pt(r),i&&l)return c(i);const u=Date.now();a.fetch(n).then((r=>{if(r.ok){const t=o?r.clone():null;return c(r,t,u)}return e(new ne(r.statusText,r.status,t.url))})).catch((t=>{20!==t.code&&e(new Error(t.message));}));},c=(r,o,l)=>{("arrayBuffer"===t.type?r.arrayBuffer():"json"===t.type?r.json():r.text()).then((t=>{s||(o&&l&&function(t,e,r){if(Qt(),!Yt)return;const n={status:e.status,statusText:e.statusText,headers:new a.Headers};e.headers.forEach(((t,e)=>n.headers.set(e,t)));const i=mt(e.headers.get("Cache-Control")||"");i["no-store"]||(i["max-age"]&&n.headers.set("Expires",new Date(r+1e3*i["max-age"]).toUTCString()),new Date(n.headers.get("Expires")).getTime()-r<42e4||function(t,e){if(void 0===Ht)try{new Response(new ReadableStream),Ht=!0;}catch(t){Ht=!1;}Ht?e(t.body):t.blob().then(e);}(e,(e=>{const r=new a.Response(e,n);Qt(),Yt&&Yt.then((e=>e.put(te(t.url),r))).catch((t=>pt(t.message)));})));}(n,o,l),i=!0,e(null,t,r.headers.get("Cache-Control"),r.headers.get("Expires")));})).catch((t=>{s||e(new Error(t.message));}));};return o?function(t,e){if(Qt(),!Yt)return e(null);const r=te(t.url);Yt.then((t=>{t.match(r).then((n=>{const i=function(t){if(!t)return !1;const e=new Date(t.headers.get("Expires")||0),r=mt(t.headers.get("Cache-Control")||"");return e>Date.now()&&!r["no-cache"]}(n);t.delete(r),i&&t.put(r,n.clone()),e(null,n,i);})).catch(e);})).catch(e);}(n,u):u(null,null),{cancel:()=>{s=!0,i||r.abort();}}}(t,e);if(yt()&&self.worker&&self.worker.actor)return self.worker.actor.send("getResource",t,e,void 0,!0)}var r;return function(t,e){const r=new a.XMLHttpRequest;r.open(t.method||"GET",t.url,!0),"arrayBuffer"===t.type&&(r.responseType="arraybuffer");for(const e in t.headers)r.setRequestHeader(e,t.headers[e]);return "json"===t.type&&(r.responseType="text",r.setRequestHeader("Accept","application/json")),r.withCredentials="include"===t.credentials,r.onerror=()=>{e(new Error(r.statusText));},r.onload=()=>{if((r.status>=200&&r.status<300||0===r.status)&&null!==r.response){let n=r.response;if("json"===t.type)try{n=JSON.parse(r.response);}catch(t){return e(t)}e(null,n,r.getResponseHeader("Cache-Control"),r.getResponseHeader("Expires"));}else e(new ne(r.statusText,r.status,t.url));},r.send(t.body),{cancel:()=>r.abort()}}(t,e)},ae=function(t,e){return se(tt(t,{type:"arrayBuffer"}),e)},oe=function(t,e){return se(tt(t,{method:"POST"}),e)},le=function(t,e){return se(tt(t,{method:"GET"}),e)};function ue(t){const e=a.document.createElement("a");return e.href=t,e.protocol===a.document.location.protocol&&e.host===a.document.location.host}const ce="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAAC0lEQVQYV2NgAAIAAAUAAarVyFEAAAAASUVORK5CYII=";let he,pe;he=[],pe=0;const de=function(t,e){if(It.supported&&(t.headers||(t.headers={}),t.headers.accept="image/webp,*/*"),pe>=St.MAX_PARALLEL_IMAGE_REQUESTS){const r={requestParameters:t,callback:e,cancelled:!1,cancel(){this.cancelled=!0;}};return he.push(r),r}pe++;let r=!1;const n=()=>{if(!r)for(r=!0,pe--;he.length&&pe<St.MAX_PARALLEL_IMAGE_REQUESTS;){const t=he.shift(),{requestParameters:e,callback:r,cancelled:n}=t;n||(t.cancel=de(e,r).cancel);}},i=ae(t,((t,r,i,s)=>{n(),t?e(t):r&&(a.createImageBitmap?function(t,e){const r=new a.Blob([new Uint8Array(t)],{type:"image/png"});a.createImageBitmap(r).then((t=>{e(null,t);})).catch((t=>{e(new Error(`Could not load image because of ${t.message}. Please make sure to use a supported image type such as PNG or JPEG. Note that SVGs are not supported.`));}));}(r,((t,r)=>e(t,r,i,s))):function(t,e){const r=new a.Image,n=a.URL;r.onload=()=>{e(null,r),n.revokeObjectURL(r.src),r.onload=null,a.requestAnimationFrame((()=>{r.src=ce;}));},r.onerror=()=>e(new Error("Could not load image. Please make sure to use a supported image type such as PNG or JPEG. Note that SVGs are not supported."));const i=new a.Blob([new Uint8Array(t)],{type:"image/png"});r.src=t.byteLength?n.createObjectURL(i):ce;}(r,((t,r)=>e(t,r,i,s))));}));return {cancel:()=>{i.cancel(),n();}}};function fe(t,e,r){r[t]&&-1!==r[t].indexOf(e)||(r[t]=r[t]||[],r[t].push(e));}function ye(t,e,r){if(r&&r[t]){const n=r[t].indexOf(e);-1!==n&&r[t].splice(n,1);}}class me{constructor(t,e={}){tt(this,e),this.type=t;}}class ge extends me{constructor(t,e={}){super("error",tt({error:t},e));}}class xe{on(t,e){return this._listeners=this._listeners||{},fe(t,e,this._listeners),this}off(t,e){return ye(t,e,this._listeners),ye(t,e,this._oneTimeListeners),this}once(t,e){return e?(this._oneTimeListeners=this._oneTimeListeners||{},fe(t,e,this._oneTimeListeners),this):new Promise((e=>this.once(t,e)))}fire(t,e){"string"==typeof t&&(t=new me(t,e||{}));const r=t.type;if(this.listens(r)){t.target=this;const e=this._listeners&&this._listeners[r]?this._listeners[r].slice():[];for(const r of e)r.call(this,t);const n=this._oneTimeListeners&&this._oneTimeListeners[r]?this._oneTimeListeners[r].slice():[];for(const e of n)ye(r,e,this._oneTimeListeners),e.call(this,t);const i=this._eventedParent;i&&(tt(t,"function"==typeof this._eventedParentData?this._eventedParentData():this._eventedParentData),i.fire(t));}else t instanceof ge&&console.error(t.error);return this}listens(t){return !!(this._listeners&&this._listeners[t]&&this._listeners[t].length>0||this._oneTimeListeners&&this._oneTimeListeners[t]&&this._oneTimeListeners[t].length>0||this._eventedParent&&this._eventedParent.listens(t))}setEventedParent(t,e){return this._eventedParent=t,this._eventedParentData=e,this}}var ve=JSON.parse('{"$version":8,"$root":{"version":{"required":true,"type":"enum","values":[8]},"name":{"type":"string"},"metadata":{"type":"*"},"center":{"type":"array","value":"number"},"zoom":{"type":"number"},"bearing":{"type":"number","default":0,"period":360,"units":"degrees"},"pitch":{"type":"number","default":0,"units":"degrees"},"light":{"type":"light"},"terrain":{"type":"terrain"},"fog":{"type":"fog"},"sources":{"required":true,"type":"sources"},"sprite":{"type":"string"},"glyphs":{"type":"string"},"transition":{"type":"transition"},"projection":{"type":"projection"},"layers":{"required":true,"type":"array","value":"layer"}},"sources":{"*":{"type":"source"}},"source":["source_vector","source_raster","source_raster_dem","source_geojson","source_video","source_image"],"source_vector":{"type":{"required":true,"type":"enum","values":{"vector":{}}},"url":{"type":"string"},"tiles":{"type":"array","value":"string"},"bounds":{"type":"array","value":"number","length":4,"default":[-180,-85.051129,180,85.051129]},"scheme":{"type":"enum","values":{"xyz":{},"tms":{}},"default":"xyz"},"minzoom":{"type":"number","default":0},"maxzoom":{"type":"number","default":22},"attribution":{"type":"string"},"promoteId":{"type":"promoteId"},"volatile":{"type":"boolean","default":false},"*":{"type":"*"}},"source_raster":{"type":{"required":true,"type":"enum","values":{"raster":{}}},"url":{"type":"string"},"tiles":{"type":"array","value":"string"},"bounds":{"type":"array","value":"number","length":4,"default":[-180,-85.051129,180,85.051129]},"minzoom":{"type":"number","default":0},"maxzoom":{"type":"number","default":22},"tileSize":{"type":"number","default":512,"units":"pixels"},"scheme":{"type":"enum","values":{"xyz":{},"tms":{}},"default":"xyz"},"attribution":{"type":"string"},"volatile":{"type":"boolean","default":false},"*":{"type":"*"}},"source_raster_dem":{"type":{"required":true,"type":"enum","values":{"raster-dem":{}}},"url":{"type":"string"},"tiles":{"type":"array","value":"string"},"bounds":{"type":"array","value":"number","length":4,"default":[-180,-85.051129,180,85.051129]},"minzoom":{"type":"number","default":0},"maxzoom":{"type":"number","default":22},"tileSize":{"type":"number","default":512,"units":"pixels"},"attribution":{"type":"string"},"encoding":{"type":"enum","values":{"terrarium":{},"mapbox":{}},"default":"mapbox"},"volatile":{"type":"boolean","default":false},"*":{"type":"*"}},"source_geojson":{"type":{"required":true,"type":"enum","values":{"geojson":{}}},"data":{"type":"*"},"maxzoom":{"type":"number","default":18},"attribution":{"type":"string"},"buffer":{"type":"number","default":128,"maximum":512,"minimum":0},"filter":{"type":"*"},"tolerance":{"type":"number","default":0.375},"cluster":{"type":"boolean","default":false},"clusterRadius":{"type":"number","default":50,"minimum":0},"clusterMaxZoom":{"type":"number"},"clusterMinPoints":{"type":"number"},"clusterProperties":{"type":"*"},"lineMetrics":{"type":"boolean","default":false},"generateId":{"type":"boolean","default":false},"promoteId":{"type":"promoteId"}},"source_video":{"type":{"required":true,"type":"enum","values":{"video":{}}},"urls":{"required":true,"type":"array","value":"string"},"coordinates":{"required":true,"type":"array","length":4,"value":{"type":"array","length":2,"value":"number"}}},"source_image":{"type":{"required":true,"type":"enum","values":{"image":{}}},"url":{"required":true,"type":"string"},"coordinates":{"required":true,"type":"array","length":4,"value":{"type":"array","length":2,"value":"number"}}},"layer":{"id":{"type":"string","required":true},"type":{"type":"enum","values":{"fill":{},"line":{},"symbol":{},"circle":{},"heatmap":{},"fill-extrusion":{},"raster":{},"hillshade":{},"background":{},"sky":{}},"required":true},"metadata":{"type":"*"},"source":{"type":"string"},"source-layer":{"type":"string"},"minzoom":{"type":"number","minimum":0,"maximum":24},"maxzoom":{"type":"number","minimum":0,"maximum":24},"filter":{"type":"filter"},"layout":{"type":"layout"},"paint":{"type":"paint"}},"layout":["layout_fill","layout_line","layout_circle","layout_heatmap","layout_fill-extrusion","layout_symbol","layout_raster","layout_hillshade","layout_background","layout_sky"],"layout_background":{"visibility":{"type":"enum","values":{"visible":{},"none":{}},"default":"visible","property-type":"constant"}},"layout_sky":{"visibility":{"type":"enum","values":{"visible":{},"none":{}},"default":"visible","property-type":"constant"}},"layout_fill":{"fill-sort-key":{"type":"number","expression":{"interpolated":false,"parameters":["zoom","feature"]},"property-type":"data-driven"},"visibility":{"type":"enum","values":{"visible":{},"none":{}},"default":"visible","property-type":"constant"}},"layout_circle":{"circle-sort-key":{"type":"number","expression":{"interpolated":false,"parameters":["zoom","feature"]},"property-type":"data-driven"},"visibility":{"type":"enum","values":{"visible":{},"none":{}},"default":"visible","property-type":"constant"}},"layout_heatmap":{"visibility":{"type":"enum","values":{"visible":{},"none":{}},"default":"visible","property-type":"constant"}},"layout_fill-extrusion":{"visibility":{"type":"enum","values":{"visible":{},"none":{}},"default":"visible","property-type":"constant"}},"layout_line":{"line-cap":{"type":"enum","values":{"butt":{},"round":{},"square":{}},"default":"butt","expression":{"interpolated":false,"parameters":["zoom","feature"]},"property-type":"data-driven"},"line-join":{"type":"enum","values":{"bevel":{},"round":{},"miter":{}},"default":"miter","expression":{"interpolated":false,"parameters":["zoom","feature"]},"property-type":"data-driven"},"line-miter-limit":{"type":"number","default":2,"requires":[{"line-join":"miter"}],"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"line-round-limit":{"type":"number","default":1.05,"requires":[{"line-join":"round"}],"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"line-sort-key":{"type":"number","expression":{"interpolated":false,"parameters":["zoom","feature"]},"property-type":"data-driven"},"visibility":{"type":"enum","values":{"visible":{},"none":{}},"default":"visible","property-type":"constant"}},"layout_symbol":{"symbol-placement":{"type":"enum","values":{"point":{},"line":{},"line-center":{}},"default":"point","expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"symbol-spacing":{"type":"number","default":250,"minimum":1,"units":"pixels","requires":[{"symbol-placement":"line"}],"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"symbol-avoid-edges":{"type":"boolean","default":false,"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"symbol-sort-key":{"type":"number","expression":{"interpolated":false,"parameters":["zoom","feature"]},"property-type":"data-driven"},"symbol-z-order":{"type":"enum","values":{"auto":{},"viewport-y":{},"source":{}},"default":"auto","expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"icon-allow-overlap":{"type":"boolean","default":false,"requires":["icon-image"],"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"icon-ignore-placement":{"type":"boolean","default":false,"requires":["icon-image"],"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"icon-optional":{"type":"boolean","default":false,"requires":["icon-image","text-field"],"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"icon-rotation-alignment":{"type":"enum","values":{"map":{},"viewport":{},"auto":{}},"default":"auto","requires":["icon-image"],"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"icon-size":{"type":"number","default":1,"minimum":0,"units":"factor of the original icon size","requires":["icon-image"],"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-text-fit":{"type":"enum","values":{"none":{},"width":{},"height":{},"both":{}},"default":"none","requires":["icon-image","text-field"],"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"icon-text-fit-padding":{"type":"array","value":"number","length":4,"default":[0,0,0,0],"units":"pixels","requires":["icon-image","text-field",{"icon-text-fit":["both","width","height"]}],"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"icon-image":{"type":"resolvedImage","tokens":true,"expression":{"interpolated":false,"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-rotate":{"type":"number","default":0,"period":360,"units":"degrees","requires":["icon-image"],"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-padding":{"type":"number","default":2,"minimum":0,"units":"pixels","requires":["icon-image"],"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"icon-keep-upright":{"type":"boolean","default":false,"requires":["icon-image",{"icon-rotation-alignment":"map"},{"symbol-placement":["line","line-center"]}],"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"icon-offset":{"type":"array","value":"number","length":2,"default":[0,0],"requires":["icon-image"],"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-anchor":{"type":"enum","values":{"center":{},"left":{},"right":{},"top":{},"bottom":{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},"default":"center","requires":["icon-image"],"expression":{"interpolated":false,"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-pitch-alignment":{"type":"enum","values":{"map":{},"viewport":{},"auto":{}},"default":"auto","requires":["icon-image"],"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"text-pitch-alignment":{"type":"enum","values":{"map":{},"viewport":{},"auto":{}},"default":"auto","requires":["text-field"],"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"text-rotation-alignment":{"type":"enum","values":{"map":{},"viewport":{},"auto":{}},"default":"auto","requires":["text-field"],"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"text-field":{"type":"formatted","default":"","tokens":true,"expression":{"interpolated":false,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-font":{"type":"array","value":"string","default":["Open Sans Regular","Arial Unicode MS Regular"],"requires":["text-field"],"expression":{"interpolated":false,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-size":{"type":"number","default":16,"minimum":0,"units":"pixels","requires":["text-field"],"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-max-width":{"type":"number","default":10,"minimum":0,"units":"ems","requires":["text-field",{"symbol-placement":["point"]}],"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-line-height":{"type":"number","default":1.2,"units":"ems","requires":["text-field"],"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-letter-spacing":{"type":"number","default":0,"units":"ems","requires":["text-field"],"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-justify":{"type":"enum","values":{"auto":{},"left":{},"center":{},"right":{}},"default":"center","requires":["text-field"],"expression":{"interpolated":false,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-radial-offset":{"type":"number","units":"ems","default":0,"requires":["text-field"],"property-type":"data-driven","expression":{"interpolated":true,"parameters":["zoom","feature"]}},"text-variable-anchor":{"type":"array","value":"enum","values":{"center":{},"left":{},"right":{},"top":{},"bottom":{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},"requires":["text-field",{"symbol-placement":["point"]}],"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"text-anchor":{"type":"enum","values":{"center":{},"left":{},"right":{},"top":{},"bottom":{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},"default":"center","requires":["text-field",{"!":"text-variable-anchor"}],"expression":{"interpolated":false,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-max-angle":{"type":"number","default":45,"units":"degrees","requires":["text-field",{"symbol-placement":["line","line-center"]}],"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"text-writing-mode":{"type":"array","value":"enum","values":{"horizontal":{},"vertical":{}},"requires":["text-field"],"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"text-rotate":{"type":"number","default":0,"period":360,"units":"degrees","requires":["text-field"],"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-padding":{"type":"number","default":2,"minimum":0,"units":"pixels","requires":["text-field"],"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"text-keep-upright":{"type":"boolean","default":true,"requires":["text-field",{"text-rotation-alignment":"map"},{"symbol-placement":["line","line-center"]}],"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"text-transform":{"type":"enum","values":{"none":{},"uppercase":{},"lowercase":{}},"default":"none","requires":["text-field"],"expression":{"interpolated":false,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-offset":{"type":"array","value":"number","units":"ems","length":2,"default":[0,0],"requires":["text-field",{"!":"text-radial-offset"}],"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-allow-overlap":{"type":"boolean","default":false,"requires":["text-field"],"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"text-ignore-placement":{"type":"boolean","default":false,"requires":["text-field"],"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"text-optional":{"type":"boolean","default":false,"requires":["text-field","icon-image"],"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"visibility":{"type":"enum","values":{"visible":{},"none":{}},"default":"visible","property-type":"constant"}},"layout_raster":{"visibility":{"type":"enum","values":{"visible":{},"none":{}},"default":"visible","property-type":"constant"}},"layout_hillshade":{"visibility":{"type":"enum","values":{"visible":{},"none":{}},"default":"visible","property-type":"constant"}},"filter":{"type":"array","value":"*"},"filter_symbol":{"type":"boolean","default":false,"transition":false,"property-type":"data-driven","expression":{"interpolated":false,"parameters":["zoom","feature","pitch","distance-from-center"]}},"filter_fill":{"type":"boolean","default":false,"transition":false,"property-type":"data-driven","expression":{"interpolated":false,"parameters":["zoom","feature"]}},"filter_line":{"type":"boolean","default":false,"transition":false,"property-type":"data-driven","expression":{"interpolated":false,"parameters":["zoom","feature"]}},"filter_circle":{"type":"boolean","default":false,"transition":false,"property-type":"data-driven","expression":{"interpolated":false,"parameters":["zoom","feature"]}},"filter_fill-extrusion":{"type":"boolean","default":false,"transition":false,"property-type":"data-driven","expression":{"interpolated":false,"parameters":["zoom","feature"]}},"filter_heatmap":{"type":"boolean","default":false,"transition":false,"property-type":"data-driven","expression":{"interpolated":false,"parameters":["zoom","feature"]}},"filter_operator":{"type":"enum","values":{"==":{},"!=":{},">":{},">=":{},"<":{},"<=":{},"in":{},"!in":{},"all":{},"any":{},"none":{},"has":{},"!has":{},"within":{}}},"geometry_type":{"type":"enum","values":{"Point":{},"LineString":{},"Polygon":{}}},"function":{"expression":{"type":"expression"},"stops":{"type":"array","value":"function_stop"},"base":{"type":"number","default":1,"minimum":0},"property":{"type":"string","default":"$zoom"},"type":{"type":"enum","values":{"identity":{},"exponential":{},"interval":{},"categorical":{}},"default":"exponential"},"colorSpace":{"type":"enum","values":{"rgb":{},"lab":{},"hcl":{}},"default":"rgb"},"default":{"type":"*","required":false}},"function_stop":{"type":"array","minimum":0,"maximum":24,"value":["number","color"],"length":2},"expression":{"type":"array","value":"*","minimum":1},"fog":{"range":{"type":"array","default":[0.5,10],"minimum":-20,"maximum":20,"length":2,"value":"number","property-type":"data-constant","transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"color":{"type":"color","property-type":"data-constant","default":"#ffffff","expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"horizon-blend":{"type":"number","property-type":"data-constant","default":0.1,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true}},"light":{"anchor":{"type":"enum","default":"viewport","values":{"map":{},"viewport":{}},"property-type":"data-constant","transition":false,"expression":{"interpolated":false,"parameters":["zoom"]}},"position":{"type":"array","default":[1.15,210,30],"length":3,"value":"number","property-type":"data-constant","transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"color":{"type":"color","property-type":"data-constant","default":"#ffffff","expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"intensity":{"type":"number","property-type":"data-constant","default":0.5,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true}},"projection":{"name":{"type":"enum","values":{"albers":{},"equalEarth":{},"equirectangular":{},"lambertConformalConic":{},"mercator":{},"naturalEarth":{},"winkelTripel":{}},"default":"mercator","required":true},"center":{"type":"array","length":2,"value":"number","property-type":"data-constant","transition":false,"requires":[{"name":["albers","lambertConformalConic"]}]},"parallels":{"type":"array","length":2,"value":"number","property-type":"data-constant","transition":false,"requires":[{"name":["albers","lambertConformalConic"]}]}},"terrain":{"source":{"type":"string","required":true},"exaggeration":{"type":"number","property-type":"data-constant","default":1,"minimum":0,"maximum":1000,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true}},"paint":["paint_fill","paint_line","paint_circle","paint_heatmap","paint_fill-extrusion","paint_symbol","paint_raster","paint_hillshade","paint_background","paint_sky"],"paint_fill":{"fill-antialias":{"type":"boolean","default":true,"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"fill-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-color":{"type":"color","default":"#000000","transition":true,"requires":[{"!":"fill-pattern"}],"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-outline-color":{"type":"color","transition":true,"requires":[{"!":"fill-pattern"},{"fill-antialias":true}],"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-translate":{"type":"array","value":"number","length":2,"default":[0,0],"transition":true,"units":"pixels","expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"fill-translate-anchor":{"type":"enum","values":{"map":{},"viewport":{}},"default":"map","requires":["fill-translate"],"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"fill-pattern":{"type":"resolvedImage","transition":true,"expression":{"interpolated":false,"parameters":["zoom","feature"]},"property-type":"cross-faded-data-driven"}},"paint_fill-extrusion":{"fill-extrusion-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"fill-extrusion-color":{"type":"color","default":"#000000","transition":true,"requires":[{"!":"fill-extrusion-pattern"}],"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-translate":{"type":"array","value":"number","length":2,"default":[0,0],"transition":true,"units":"pixels","expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"fill-extrusion-translate-anchor":{"type":"enum","values":{"map":{},"viewport":{}},"default":"map","requires":["fill-extrusion-translate"],"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"fill-extrusion-pattern":{"type":"resolvedImage","transition":true,"expression":{"interpolated":false,"parameters":["zoom","feature"]},"property-type":"cross-faded-data-driven"},"fill-extrusion-height":{"type":"number","default":0,"minimum":0,"units":"meters","transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-base":{"type":"number","default":0,"minimum":0,"units":"meters","transition":true,"requires":["fill-extrusion-height"],"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-vertical-gradient":{"type":"boolean","default":true,"transition":false,"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"}},"paint_line":{"line-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-color":{"type":"color","default":"#000000","transition":true,"requires":[{"!":"line-pattern"}],"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-translate":{"type":"array","value":"number","length":2,"default":[0,0],"transition":true,"units":"pixels","expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"line-translate-anchor":{"type":"enum","values":{"map":{},"viewport":{}},"default":"map","requires":["line-translate"],"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"line-width":{"type":"number","default":1,"minimum":0,"transition":true,"units":"pixels","expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-gap-width":{"type":"number","default":0,"minimum":0,"transition":true,"units":"pixels","expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-offset":{"type":"number","default":0,"transition":true,"units":"pixels","expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-blur":{"type":"number","default":0,"minimum":0,"transition":true,"units":"pixels","expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-dasharray":{"type":"array","value":"number","minimum":0,"transition":true,"units":"line widths","requires":[{"!":"line-pattern"}],"expression":{"interpolated":false,"parameters":["zoom","feature"]},"property-type":"cross-faded-data-driven"},"line-pattern":{"type":"resolvedImage","transition":true,"expression":{"interpolated":false,"parameters":["zoom","feature"]},"property-type":"cross-faded-data-driven"},"line-gradient":{"type":"color","transition":false,"requires":[{"!":"line-pattern"},{"source":"geojson","has":{"lineMetrics":true}}],"expression":{"interpolated":true,"parameters":["line-progress"]},"property-type":"color-ramp"}},"paint_circle":{"circle-radius":{"type":"number","default":5,"minimum":0,"transition":true,"units":"pixels","expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-color":{"type":"color","default":"#000000","transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-blur":{"type":"number","default":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-translate":{"type":"array","value":"number","length":2,"default":[0,0],"transition":true,"units":"pixels","expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"circle-translate-anchor":{"type":"enum","values":{"map":{},"viewport":{}},"default":"map","requires":["circle-translate"],"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"circle-pitch-scale":{"type":"enum","values":{"map":{},"viewport":{}},"default":"map","expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"circle-pitch-alignment":{"type":"enum","values":{"map":{},"viewport":{}},"default":"viewport","expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"circle-stroke-width":{"type":"number","default":0,"minimum":0,"transition":true,"units":"pixels","expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-stroke-color":{"type":"color","default":"#000000","transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-stroke-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"}},"paint_heatmap":{"heatmap-radius":{"type":"number","default":30,"minimum":1,"transition":true,"units":"pixels","expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"heatmap-weight":{"type":"number","default":1,"minimum":0,"transition":false,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"heatmap-intensity":{"type":"number","default":1,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"heatmap-color":{"type":"color","default":["interpolate",["linear"],["heatmap-density"],0,"rgba(0, 0, 255, 0)",0.1,"royalblue",0.3,"cyan",0.5,"lime",0.7,"yellow",1,"red"],"transition":false,"expression":{"interpolated":true,"parameters":["heatmap-density"]},"property-type":"color-ramp"},"heatmap-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"}},"paint_symbol":{"icon-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"requires":["icon-image"],"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-color":{"type":"color","default":"#000000","transition":true,"requires":["icon-image"],"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-color":{"type":"color","default":"rgba(0, 0, 0, 0)","transition":true,"requires":["icon-image"],"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-width":{"type":"number","default":0,"minimum":0,"transition":true,"units":"pixels","requires":["icon-image"],"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-blur":{"type":"number","default":0,"minimum":0,"transition":true,"units":"pixels","requires":["icon-image"],"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-translate":{"type":"array","value":"number","length":2,"default":[0,0],"transition":true,"units":"pixels","requires":["icon-image"],"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"icon-translate-anchor":{"type":"enum","values":{"map":{},"viewport":{}},"default":"map","requires":["icon-image","icon-translate"],"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"text-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"requires":["text-field"],"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-color":{"type":"color","default":"#000000","transition":true,"overridable":true,"requires":["text-field"],"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-color":{"type":"color","default":"rgba(0, 0, 0, 0)","transition":true,"requires":["text-field"],"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-width":{"type":"number","default":0,"minimum":0,"transition":true,"units":"pixels","requires":["text-field"],"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-blur":{"type":"number","default":0,"minimum":0,"transition":true,"units":"pixels","requires":["text-field"],"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-translate":{"type":"array","value":"number","length":2,"default":[0,0],"transition":true,"units":"pixels","requires":["text-field"],"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"text-translate-anchor":{"type":"enum","values":{"map":{},"viewport":{}},"default":"map","requires":["text-field","text-translate"],"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"}},"paint_raster":{"raster-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"raster-hue-rotate":{"type":"number","default":0,"period":360,"transition":true,"units":"degrees","expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"raster-brightness-min":{"type":"number","default":0,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"raster-brightness-max":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"raster-saturation":{"type":"number","default":0,"minimum":-1,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"raster-contrast":{"type":"number","default":0,"minimum":-1,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"raster-resampling":{"type":"enum","values":{"linear":{},"nearest":{}},"default":"linear","expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"raster-fade-duration":{"type":"number","default":300,"minimum":0,"transition":false,"units":"milliseconds","expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"}},"paint_hillshade":{"hillshade-illumination-direction":{"type":"number","default":335,"minimum":0,"maximum":359,"transition":false,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"hillshade-illumination-anchor":{"type":"enum","values":{"map":{},"viewport":{}},"default":"viewport","expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"hillshade-exaggeration":{"type":"number","default":0.5,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"hillshade-shadow-color":{"type":"color","default":"#000000","transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"hillshade-highlight-color":{"type":"color","default":"#FFFFFF","transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"hillshade-accent-color":{"type":"color","default":"#000000","transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"}},"paint_background":{"background-color":{"type":"color","default":"#000000","transition":true,"requires":[{"!":"background-pattern"}],"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"background-pattern":{"type":"resolvedImage","transition":true,"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"cross-faded"},"background-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"}},"paint_sky":{"sky-type":{"type":"enum","values":{"gradient":{},"atmosphere":{}},"default":"atmosphere","expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"sky-atmosphere-sun":{"type":"array","value":"number","length":2,"units":"degrees","minimum":[0,0],"maximum":[360,180],"transition":false,"requires":[{"sky-type":"atmosphere"}],"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"sky-atmosphere-sun-intensity":{"type":"number","requires":[{"sky-type":"atmosphere"}],"default":10,"minimum":0,"maximum":100,"transition":false,"property-type":"data-constant"},"sky-gradient-center":{"type":"array","requires":[{"sky-type":"gradient"}],"value":"number","default":[0,0],"length":2,"units":"degrees","minimum":[0,0],"maximum":[360,180],"transition":false,"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"sky-gradient-radius":{"type":"number","requires":[{"sky-type":"gradient"}],"default":90,"minimum":0,"maximum":180,"transition":false,"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"sky-gradient":{"type":"color","default":["interpolate",["linear"],["sky-radial-progress"],0.8,"#87ceeb",1,"white"],"transition":false,"requires":[{"sky-type":"gradient"}],"expression":{"interpolated":true,"parameters":["sky-radial-progress"]},"property-type":"color-ramp"},"sky-atmosphere-halo-color":{"type":"color","default":"white","transition":false,"requires":[{"sky-type":"atmosphere"}],"property-type":"data-constant"},"sky-atmosphere-color":{"type":"color","default":"white","transition":false,"requires":[{"sky-type":"atmosphere"}],"property-type":"data-constant"},"sky-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"}},"transition":{"duration":{"type":"number","default":300,"minimum":0,"units":"milliseconds"},"delay":{"type":"number","default":0,"minimum":0,"units":"milliseconds"}},"property-type":{"data-driven":{"type":"property-type"},"cross-faded":{"type":"property-type"},"cross-faded-data-driven":{"type":"property-type"},"color-ramp":{"type":"property-type"},"data-constant":{"type":"property-type"},"constant":{"type":"property-type"}},"promoteId":{"*":{"type":"string"}}}');class be{constructor(t,e,r,n){this.message=(t?`${t}: `:"")+r,n&&(this.identifier=n),null!=e&&e.__line__&&(this.line=e.__line__);}}function we(t){const e=t.value;return e?[new be(t.key,e,"constants have been deprecated as of v8")]:[]}function _e(t,...e){for(const r of e)for(const e in r)t[e]=r[e];return t}function Ae(t){return t instanceof Number||t instanceof String||t instanceof Boolean?t.valueOf():t}function ke(t){if(Array.isArray(t))return t.map(ke);if(t instanceof Object&&!(t instanceof Number||t instanceof String||t instanceof Boolean)){const e={};for(const r in t)e[r]=ke(t[r]);return e}return Ae(t)}class Se extends Error{constructor(t,e){super(e),this.message=e,this.key=t;}}class Ie{constructor(t,e=[]){this.parent=t,this.bindings={};for(const[t,r]of e)this.bindings[t]=r;}concat(t){return new Ie(this,t)}get(t){if(this.bindings[t])return this.bindings[t];if(this.parent)return this.parent.get(t);throw new Error(`${t} not found in scope.`)}has(t){return !!this.bindings[t]||!!this.parent&&this.parent.has(t)}}const ze={kind:"null"},Me={kind:"number"},Te={kind:"string"},Be={kind:"boolean"},Ce={kind:"color"},Pe={kind:"object"},Ee={kind:"value"},De={kind:"collator"},Ve={kind:"formatted"},Fe={kind:"resolvedImage"};function Le(t,e){return {kind:"array",itemType:t,N:e}}function Re(t){if("array"===t.kind){const e=Re(t.itemType);return "number"==typeof t.N?`array<${e}, ${t.N}>`:"value"===t.itemType.kind?"array":`array<${e}>`}return t.kind}const Ue=[ze,Me,Te,Be,Ce,Ve,Pe,Le(Ee),Fe];function $e(t,e){if("error"===e.kind)return null;if("array"===t.kind){if("array"===e.kind&&(0===e.N&&"value"===e.itemType.kind||!$e(t.itemType,e.itemType))&&("number"!=typeof t.N||t.N===e.N))return null}else {if(t.kind===e.kind)return null;if("value"===t.kind)for(const t of Ue)if(!$e(t,e))return null}return `Expected ${Re(t)} but found ${Re(e)} instead.`}function Oe(t,e){return e.some((e=>e.kind===t.kind))}function je(t,e){return e.some((e=>"null"===e?null===t:"array"===e?Array.isArray(t):"object"===e?t&&!Array.isArray(t)&&"object"==typeof t:e===typeof t))}function qe(t){var e={exports:{}};return t(e,e.exports),e.exports}var Ne=qe((function(t,e){var r={transparent:[0,0,0,0],aliceblue:[240,248,255,1],antiquewhite:[250,235,215,1],aqua:[0,255,255,1],aquamarine:[127,255,212,1],azure:[240,255,255,1],beige:[245,245,220,1],bisque:[255,228,196,1],black:[0,0,0,1],blanchedalmond:[255,235,205,1],blue:[0,0,255,1],blueviolet:[138,43,226,1],brown:[165,42,42,1],burlywood:[222,184,135,1],cadetblue:[95,158,160,1],chartreuse:[127,255,0,1],chocolate:[210,105,30,1],coral:[255,127,80,1],cornflowerblue:[100,149,237,1],cornsilk:[255,248,220,1],crimson:[220,20,60,1],cyan:[0,255,255,1],darkblue:[0,0,139,1],darkcyan:[0,139,139,1],darkgoldenrod:[184,134,11,1],darkgray:[169,169,169,1],darkgreen:[0,100,0,1],darkgrey:[169,169,169,1],darkkhaki:[189,183,107,1],darkmagenta:[139,0,139,1],darkolivegreen:[85,107,47,1],darkorange:[255,140,0,1],darkorchid:[153,50,204,1],darkred:[139,0,0,1],darksalmon:[233,150,122,1],darkseagreen:[143,188,143,1],darkslateblue:[72,61,139,1],darkslategray:[47,79,79,1],darkslategrey:[47,79,79,1],darkturquoise:[0,206,209,1],darkviolet:[148,0,211,1],deeppink:[255,20,147,1],deepskyblue:[0,191,255,1],dimgray:[105,105,105,1],dimgrey:[105,105,105,1],dodgerblue:[30,144,255,1],firebrick:[178,34,34,1],floralwhite:[255,250,240,1],forestgreen:[34,139,34,1],fuchsia:[255,0,255,1],gainsboro:[220,220,220,1],ghostwhite:[248,248,255,1],gold:[255,215,0,1],goldenrod:[218,165,32,1],gray:[128,128,128,1],green:[0,128,0,1],greenyellow:[173,255,47,1],grey:[128,128,128,1],honeydew:[240,255,240,1],hotpink:[255,105,180,1],indianred:[205,92,92,1],indigo:[75,0,130,1],ivory:[255,255,240,1],khaki:[240,230,140,1],lavender:[230,230,250,1],lavenderblush:[255,240,245,1],lawngreen:[124,252,0,1],lemonchiffon:[255,250,205,1],lightblue:[173,216,230,1],lightcoral:[240,128,128,1],lightcyan:[224,255,255,1],lightgoldenrodyellow:[250,250,210,1],lightgray:[211,211,211,1],lightgreen:[144,238,144,1],lightgrey:[211,211,211,1],lightpink:[255,182,193,1],lightsalmon:[255,160,122,1],lightseagreen:[32,178,170,1],lightskyblue:[135,206,250,1],lightslategray:[119,136,153,1],lightslategrey:[119,136,153,1],lightsteelblue:[176,196,222,1],lightyellow:[255,255,224,1],lime:[0,255,0,1],limegreen:[50,205,50,1],linen:[250,240,230,1],magenta:[255,0,255,1],maroon:[128,0,0,1],mediumaquamarine:[102,205,170,1],mediumblue:[0,0,205,1],mediumorchid:[186,85,211,1],mediumpurple:[147,112,219,1],mediumseagreen:[60,179,113,1],mediumslateblue:[123,104,238,1],mediumspringgreen:[0,250,154,1],mediumturquoise:[72,209,204,1],mediumvioletred:[199,21,133,1],midnightblue:[25,25,112,1],mintcream:[245,255,250,1],mistyrose:[255,228,225,1],moccasin:[255,228,181,1],navajowhite:[255,222,173,1],navy:[0,0,128,1],oldlace:[253,245,230,1],olive:[128,128,0,1],olivedrab:[107,142,35,1],orange:[255,165,0,1],orangered:[255,69,0,1],orchid:[218,112,214,1],palegoldenrod:[238,232,170,1],palegreen:[152,251,152,1],paleturquoise:[175,238,238,1],palevioletred:[219,112,147,1],papayawhip:[255,239,213,1],peachpuff:[255,218,185,1],peru:[205,133,63,1],pink:[255,192,203,1],plum:[221,160,221,1],powderblue:[176,224,230,1],purple:[128,0,128,1],rebeccapurple:[102,51,153,1],red:[255,0,0,1],rosybrown:[188,143,143,1],royalblue:[65,105,225,1],saddlebrown:[139,69,19,1],salmon:[250,128,114,1],sandybrown:[244,164,96,1],seagreen:[46,139,87,1],seashell:[255,245,238,1],sienna:[160,82,45,1],silver:[192,192,192,1],skyblue:[135,206,235,1],slateblue:[106,90,205,1],slategray:[112,128,144,1],slategrey:[112,128,144,1],snow:[255,250,250,1],springgreen:[0,255,127,1],steelblue:[70,130,180,1],tan:[210,180,140,1],teal:[0,128,128,1],thistle:[216,191,216,1],tomato:[255,99,71,1],turquoise:[64,224,208,1],violet:[238,130,238,1],wheat:[245,222,179,1],white:[255,255,255,1],whitesmoke:[245,245,245,1],yellow:[255,255,0,1],yellowgreen:[154,205,50,1]};function n(t){return (t=Math.round(t))<0?0:t>255?255:t}function i(t){return n("%"===t[t.length-1]?parseFloat(t)/100*255:parseInt(t))}function s(t){return (e="%"===t[t.length-1]?parseFloat(t)/100:parseFloat(t))<0?0:e>1?1:e;var e;}function a(t,e,r){return r<0?r+=1:r>1&&(r-=1),6*r<1?t+(e-t)*r*6:2*r<1?e:3*r<2?t+(e-t)*(2/3-r)*6:t}try{e.parseCSSColor=function(t){var e,o=t.replace(/ /g,"").toLowerCase();if(o in r)return r[o].slice();if("#"===o[0])return 4===o.length?(e=parseInt(o.substr(1),16))>=0&&e<=4095?[(3840&e)>>4|(3840&e)>>8,240&e|(240&e)>>4,15&e|(15&e)<<4,1]:null:7===o.length&&(e=parseInt(o.substr(1),16))>=0&&e<=16777215?[(16711680&e)>>16,(65280&e)>>8,255&e,1]:null;var l=o.indexOf("("),u=o.indexOf(")");if(-1!==l&&u+1===o.length){var c=o.substr(0,l),h=o.substr(l+1,u-(l+1)).split(","),p=1;switch(c){case"rgba":if(4!==h.length)return null;p=s(h.pop());case"rgb":return 3!==h.length?null:[i(h[0]),i(h[1]),i(h[2]),p];case"hsla":if(4!==h.length)return null;p=s(h.pop());case"hsl":if(3!==h.length)return null;var d=(parseFloat(h[0])%360+360)%360/360,f=s(h[1]),y=s(h[2]),m=y<=.5?y*(f+1):y+f-y*f,g=2*y-m;return [n(255*a(g,m,d+1/3)),n(255*a(g,m,d)),n(255*a(g,m,d-1/3)),p];default:return null}}return null};}catch(t){}}));class Ge{constructor(t,e,r,n=1){this.r=t,this.g=e,this.b=r,this.a=n;}static parse(t){if(!t)return;if(t instanceof Ge)return t;if("string"!=typeof t)return;const e=Ne.parseCSSColor(t);return e?new Ge(e[0]/255*e[3],e[1]/255*e[3],e[2]/255*e[3],e[3]):void 0}toString(){const[t,e,r,n]=this.toArray();return `rgba(${Math.round(t)},${Math.round(e)},${Math.round(r)},${n})`}toArray(){const{r:t,g:e,b:r,a:n}=this;return 0===n?[0,0,0,0]:[255*t/n,255*e/n,255*r/n,n]}}Ge.black=new Ge(0,0,0,1),Ge.white=new Ge(1,1,1,1),Ge.transparent=new Ge(0,0,0,0),Ge.red=new Ge(1,0,0,1),Ge.blue=new Ge(0,0,1,1);class Ze{constructor(t,e,r){this.sensitivity=t?e?"variant":"case":e?"accent":"base",this.locale=r,this.collator=new Intl.Collator(this.locale?this.locale:[],{sensitivity:this.sensitivity,usage:"search"});}compare(t,e){return this.collator.compare(t,e)}resolvedLocale(){return new Intl.Collator(this.locale?this.locale:[]).resolvedOptions().locale}}class Xe{constructor(t,e,r,n,i){this.text=t.normalize?t.normalize():t,this.image=e,this.scale=r,this.fontStack=n,this.textColor=i;}}class Ke{constructor(t){this.sections=t;}static fromString(t){return new Ke([new Xe(t,null,null,null,null)])}isEmpty(){return 0===this.sections.length||!this.sections.some((t=>0!==t.text.length||t.image&&0!==t.image.name.length))}static factory(t){return t instanceof Ke?t:Ke.fromString(t)}toString(){return 0===this.sections.length?"":this.sections.map((t=>t.text)).join("")}serialize(){const t=["format"];for(const e of this.sections){if(e.image){t.push(["image",e.image.name]);continue}t.push(e.text);const r={};e.fontStack&&(r["text-font"]=["literal",e.fontStack.split(",")]),e.scale&&(r["font-scale"]=e.scale),e.textColor&&(r["text-color"]=["rgba"].concat(e.textColor.toArray())),t.push(r);}return t}}class Ye{constructor(t){this.name=t.name,this.available=t.available;}toString(){return this.name}static fromString(t){return t?new Ye({name:t,available:!1}):null}serialize(){return ["image",this.name]}}function He(t,e,r,n){return "number"==typeof t&&t>=0&&t<=255&&"number"==typeof e&&e>=0&&e<=255&&"number"==typeof r&&r>=0&&r<=255?void 0===n||"number"==typeof n&&n>=0&&n<=1?null:`Invalid rgba value [${[t,e,r,n].join(", ")}]: 'a' must be between 0 and 1.`:`Invalid rgba value [${("number"==typeof n?[t,e,r,n]:[t,e,r]).join(", ")}]: 'r', 'g', and 'b' must be between 0 and 255.`}function Je(t){if(null===t)return !0;if("string"==typeof t)return !0;if("boolean"==typeof t)return !0;if("number"==typeof t)return !0;if(t instanceof Ge)return !0;if(t instanceof Ze)return !0;if(t instanceof Ke)return !0;if(t instanceof Ye)return !0;if(Array.isArray(t)){for(const e of t)if(!Je(e))return !1;return !0}if("object"==typeof t){for(const e in t)if(!Je(t[e]))return !1;return !0}return !1}function We(t){if(null===t)return ze;if("string"==typeof t)return Te;if("boolean"==typeof t)return Be;if("number"==typeof t)return Me;if(t instanceof Ge)return Ce;if(t instanceof Ze)return De;if(t instanceof Ke)return Ve;if(t instanceof Ye)return Fe;if(Array.isArray(t)){const e=t.length;let r;for(const e of t){const t=We(e);if(r){if(r===t)continue;r=Ee;break}r=t;}return Le(r||Ee,e)}return Pe}function Qe(t){const e=typeof t;return null===t?"":"string"===e||"number"===e||"boolean"===e?String(t):t instanceof Ge||t instanceof Ke||t instanceof Ye?t.toString():JSON.stringify(t)}class tr{constructor(t,e){this.type=t,this.value=e;}static parse(t,e){if(2!==t.length)return e.error(`'literal' expression requires exactly one argument, but found ${t.length-1} instead.`);if(!Je(t[1]))return e.error("invalid value");const r=t[1];let n=We(r);const i=e.expectedType;return "array"!==n.kind||0!==n.N||!i||"array"!==i.kind||"number"==typeof i.N&&0!==i.N||(n=i),new tr(n,r)}evaluate(){return this.value}eachChild(){}outputDefined(){return !0}serialize(){return "array"===this.type.kind||"object"===this.type.kind?["literal",this.value]:this.value instanceof Ge?["rgba"].concat(this.value.toArray()):this.value instanceof Ke?this.value.serialize():this.value}}class er{constructor(t){this.name="ExpressionEvaluationError",this.message=t;}toJSON(){return this.message}}const rr={string:Te,number:Me,boolean:Be,object:Pe};class nr{constructor(t,e){this.type=t,this.args=e;}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");let r,n=1;const i=t[0];if("array"===i){let i,s;if(t.length>2){const r=t[1];if("string"!=typeof r||!(r in rr)||"object"===r)return e.error('The item type argument of "array" must be one of string, number, boolean',1);i=rr[r],n++;}else i=Ee;if(t.length>3){if(null!==t[2]&&("number"!=typeof t[2]||t[2]<0||t[2]!==Math.floor(t[2])))return e.error('The length argument to "array" must be a positive integer literal',2);s=t[2],n++;}r=Le(i,s);}else r=rr[i];const s=[];for(;n<t.length;n++){const r=e.parse(t[n],n,Ee);if(!r)return null;s.push(r);}return new nr(r,s)}evaluate(t){for(let e=0;e<this.args.length;e++){const r=this.args[e].evaluate(t);if(!$e(this.type,We(r)))return r;if(e===this.args.length-1)throw new er(`Expected value to be of type ${Re(this.type)}, but found ${Re(We(r))} instead.`)}return null}eachChild(t){this.args.forEach(t);}outputDefined(){return this.args.every((t=>t.outputDefined()))}serialize(){const t=this.type,e=[t.kind];if("array"===t.kind){const r=t.itemType;if("string"===r.kind||"number"===r.kind||"boolean"===r.kind){e.push(r.kind);const n=t.N;("number"==typeof n||this.args.length>1)&&e.push(n);}}return e.concat(this.args.map((t=>t.serialize())))}}class ir{constructor(t){this.type=Ve,this.sections=t;}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");const r=t[1];if(!Array.isArray(r)&&"object"==typeof r)return e.error("First argument must be an image or text section.");const n=[];let i=!1;for(let r=1;r<=t.length-1;++r){const s=t[r];if(i&&"object"==typeof s&&!Array.isArray(s)){i=!1;let t=null;if(s["font-scale"]&&(t=e.parse(s["font-scale"],1,Me),!t))return null;let r=null;if(s["text-font"]&&(r=e.parse(s["text-font"],1,Le(Te)),!r))return null;let a=null;if(s["text-color"]&&(a=e.parse(s["text-color"],1,Ce),!a))return null;const o=n[n.length-1];o.scale=t,o.font=r,o.textColor=a;}else {const s=e.parse(t[r],1,Ee);if(!s)return null;const a=s.type.kind;if("string"!==a&&"value"!==a&&"null"!==a&&"resolvedImage"!==a)return e.error("Formatted text type must be 'string', 'value', 'image' or 'null'.");i=!0,n.push({content:s,scale:null,font:null,textColor:null});}}return new ir(n)}evaluate(t){return new Ke(this.sections.map((e=>{const r=e.content.evaluate(t);return We(r)===Fe?new Xe("",r,null,null,null):new Xe(Qe(r),null,e.scale?e.scale.evaluate(t):null,e.font?e.font.evaluate(t).join(","):null,e.textColor?e.textColor.evaluate(t):null)})))}eachChild(t){for(const e of this.sections)t(e.content),e.scale&&t(e.scale),e.font&&t(e.font),e.textColor&&t(e.textColor);}outputDefined(){return !1}serialize(){const t=["format"];for(const e of this.sections){t.push(e.content.serialize());const r={};e.scale&&(r["font-scale"]=e.scale.serialize()),e.font&&(r["text-font"]=e.font.serialize()),e.textColor&&(r["text-color"]=e.textColor.serialize()),t.push(r);}return t}}class sr{constructor(t){this.type=Fe,this.input=t;}static parse(t,e){if(2!==t.length)return e.error("Expected two arguments.");const r=e.parse(t[1],1,Te);return r?new sr(r):e.error("No image name provided.")}evaluate(t){const e=this.input.evaluate(t),r=Ye.fromString(e);return r&&t.availableImages&&(r.available=t.availableImages.indexOf(e)>-1),r}eachChild(t){t(this.input);}outputDefined(){return !1}serialize(){return ["image",this.input.serialize()]}}const ar={"to-boolean":Be,"to-color":Ce,"to-number":Me,"to-string":Te};class or{constructor(t,e){this.type=t,this.args=e;}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");const r=t[0];if(("to-boolean"===r||"to-string"===r)&&2!==t.length)return e.error("Expected one argument.");const n=ar[r],i=[];for(let r=1;r<t.length;r++){const n=e.parse(t[r],r,Ee);if(!n)return null;i.push(n);}return new or(n,i)}evaluate(t){if("boolean"===this.type.kind)return Boolean(this.args[0].evaluate(t));if("color"===this.type.kind){let e,r;for(const n of this.args){if(e=n.evaluate(t),r=null,e instanceof Ge)return e;if("string"==typeof e){const r=t.parseColor(e);if(r)return r}else if(Array.isArray(e)&&(r=e.length<3||e.length>4?`Invalid rbga value ${JSON.stringify(e)}: expected an array containing either three or four numeric values.`:He(e[0],e[1],e[2],e[3]),!r))return new Ge(e[0]/255,e[1]/255,e[2]/255,e[3])}throw new er(r||`Could not parse color from value '${"string"==typeof e?e:String(JSON.stringify(e))}'`)}if("number"===this.type.kind){let e=null;for(const r of this.args){if(e=r.evaluate(t),null===e)return 0;const n=Number(e);if(!isNaN(n))return n}throw new er(`Could not convert ${JSON.stringify(e)} to number.`)}return "formatted"===this.type.kind?Ke.fromString(Qe(this.args[0].evaluate(t))):"resolvedImage"===this.type.kind?Ye.fromString(Qe(this.args[0].evaluate(t))):Qe(this.args[0].evaluate(t))}eachChild(t){this.args.forEach(t);}outputDefined(){return this.args.every((t=>t.outputDefined()))}serialize(){if("formatted"===this.type.kind)return new ir([{content:this.args[0],scale:null,font:null,textColor:null}]).serialize();if("resolvedImage"===this.type.kind)return new sr(this.args[0]).serialize();const t=[`to-${this.type.kind}`];return this.eachChild((e=>{t.push(e.serialize());})),t}}const lr=["Unknown","Point","LineString","Polygon"];class ur{constructor(){this.globals=null,this.feature=null,this.featureState=null,this.formattedSection=null,this._parseColorCache={},this.availableImages=null,this.canonical=null,this.featureTileCoord=null,this.featureDistanceData=null;}id(){return this.feature&&"id"in this.feature?this.feature.id:null}geometryType(){return this.feature?"number"==typeof this.feature.type?lr[this.feature.type]:this.feature.type:null}geometry(){return this.feature&&"geometry"in this.feature?this.feature.geometry:null}canonicalID(){return this.canonical}properties(){return this.feature&&this.feature.properties||{}}distanceFromCenter(){if(this.featureTileCoord&&this.featureDistanceData){const t=this.featureDistanceData.center,e=this.featureDistanceData.scale,{x:r,y:n}=this.featureTileCoord;return this.featureDistanceData.bearing[0]*(r*e-t[0])+this.featureDistanceData.bearing[1]*(n*e-t[1])}return 0}parseColor(t){let e=this._parseColorCache[t];return e||(e=this._parseColorCache[t]=Ge.parse(t)),e}}class cr{constructor(t,e,r,n){this.name=t,this.type=e,this._evaluate=r,this.args=n;}evaluate(t){return this._evaluate(t,this.args)}eachChild(t){this.args.forEach(t);}outputDefined(){return !1}serialize(){return [this.name].concat(this.args.map((t=>t.serialize())))}static parse(t,e){const r=t[0],n=cr.definitions[r];if(!n)return e.error(`Unknown expression "${r}". If you wanted a literal array, use ["literal", [...]].`,0);const i=Array.isArray(n)?n[0]:n.type,s=Array.isArray(n)?[[n[1],n[2]]]:n.overloads,a=s.filter((([e])=>!Array.isArray(e)||e.length===t.length-1));let o=null;for(const[n,s]of a){o=new Er(e.registry,e.path,null,e.scope);const a=[];let l=!1;for(let e=1;e<t.length;e++){const r=t[e],i=Array.isArray(n)?n[e-1]:n.type,s=o.parse(r,1+a.length,i);if(!s){l=!0;break}a.push(s);}if(!l)if(Array.isArray(n)&&n.length!==a.length)o.error(`Expected ${n.length} arguments, but found ${a.length} instead.`);else {for(let t=0;t<a.length;t++){const e=Array.isArray(n)?n[t]:n.type,r=a[t];o.concat(t+1).checkSubtype(e,r.type);}if(0===o.errors.length)return new cr(r,i,s,a)}}if(1===a.length)e.errors.push(...o.errors);else {const r=(a.length?a:s).map((([t])=>{return e=t,Array.isArray(e)?`(${e.map(Re).join(", ")})`:`(${Re(e.type)}...)`;var e;})).join(" | "),n=[];for(let r=1;r<t.length;r++){const i=e.parse(t[r],1+n.length);if(!i)return null;n.push(Re(i.type));}e.error(`Expected arguments of type ${r}, but found (${n.join(", ")}) instead.`);}return null}static register(t,e){cr.definitions=e;for(const r in e)t[r]=cr;}}class hr{constructor(t,e,r){this.type=De,this.locale=r,this.caseSensitive=t,this.diacriticSensitive=e;}static parse(t,e){if(2!==t.length)return e.error("Expected one argument.");const r=t[1];if("object"!=typeof r||Array.isArray(r))return e.error("Collator options argument must be an object.");const n=e.parse(void 0!==r["case-sensitive"]&&r["case-sensitive"],1,Be);if(!n)return null;const i=e.parse(void 0!==r["diacritic-sensitive"]&&r["diacritic-sensitive"],1,Be);if(!i)return null;let s=null;return r.locale&&(s=e.parse(r.locale,1,Te),!s)?null:new hr(n,i,s)}evaluate(t){return new Ze(this.caseSensitive.evaluate(t),this.diacriticSensitive.evaluate(t),this.locale?this.locale.evaluate(t):null)}eachChild(t){t(this.caseSensitive),t(this.diacriticSensitive),this.locale&&t(this.locale);}outputDefined(){return !1}serialize(){const t={};return t["case-sensitive"]=this.caseSensitive.serialize(),t["diacritic-sensitive"]=this.diacriticSensitive.serialize(),this.locale&&(t.locale=this.locale.serialize()),["collator",t]}}const pr=8192;function dr(t,e){t[0]=Math.min(t[0],e[0]),t[1]=Math.min(t[1],e[1]),t[2]=Math.max(t[2],e[0]),t[3]=Math.max(t[3],e[1]);}function fr(t,e){return !(t[0]<=e[0]||t[2]>=e[2]||t[1]<=e[1]||t[3]>=e[3])}function yr(t,e){const r=(180+t[0])/360,n=(180-180/Math.PI*Math.log(Math.tan(Math.PI/4+t[1]*Math.PI/360)))/360,i=Math.pow(2,e.z);return [Math.round(r*i*pr),Math.round(n*i*pr)]}function mr(t,e,r){const n=t[0]-e[0],i=t[1]-e[1],s=t[0]-r[0],a=t[1]-r[1];return n*a-s*i==0&&n*s<=0&&i*a<=0}function gr(t,e){let r=!1;for(let a=0,o=e.length;a<o;a++){const o=e[a];for(let e=0,a=o.length;e<a-1;e++){if(mr(t,o[e],o[e+1]))return !1;(i=o[e])[1]>(n=t)[1]!=(s=o[e+1])[1]>n[1]&&n[0]<(s[0]-i[0])*(n[1]-i[1])/(s[1]-i[1])+i[0]&&(r=!r);}}var n,i,s;return r}function xr(t,e){for(let r=0;r<e.length;r++)if(gr(t,e[r]))return !0;return !1}function vr(t,e,r,n){const i=n[0]-r[0],s=n[1]-r[1],a=(t[0]-r[0])*s-i*(t[1]-r[1]),o=(e[0]-r[0])*s-i*(e[1]-r[1]);return a>0&&o<0||a<0&&o>0}function br(t,e,r){for(const u of r)for(let r=0;r<u.length-1;++r)if(0!=(o=[(a=u[r+1])[0]-(s=u[r])[0],a[1]-s[1]])[0]*(l=[(i=e)[0]-(n=t)[0],i[1]-n[1]])[1]-o[1]*l[0]&&vr(n,i,s,a)&&vr(s,a,n,i))return !0;var n,i,s,a,o,l;return !1}function wr(t,e){for(let r=0;r<t.length;++r)if(!gr(t[r],e))return !1;for(let r=0;r<t.length-1;++r)if(br(t[r],t[r+1],e))return !1;return !0}function _r(t,e){for(let r=0;r<e.length;r++)if(wr(t,e[r]))return !0;return !1}function Ar(t,e,r){const n=[];for(let i=0;i<t.length;i++){const s=[];for(let n=0;n<t[i].length;n++){const a=yr(t[i][n],r);dr(e,a),s.push(a);}n.push(s);}return n}function kr(t,e,r){const n=[];for(let i=0;i<t.length;i++){const s=Ar(t[i],e,r);n.push(s);}return n}function Sr(t,e,r,n){if(t[0]<r[0]||t[0]>r[2]){const e=.5*n;let i=t[0]-r[0]>e?-n:r[0]-t[0]>e?n:0;0===i&&(i=t[0]-r[2]>e?-n:r[2]-t[0]>e?n:0),t[0]+=i;}dr(e,t);}function Ir(t,e,r,n){const i=Math.pow(2,n.z)*pr,s=[n.x*pr,n.y*pr],a=[];for(const n of t)for(const t of n){const n=[t.x+s[0],t.y+s[1]];Sr(n,e,r,i),a.push(n);}return a}function zr(t,e,r,n){const i=Math.pow(2,n.z)*pr,s=[n.x*pr,n.y*pr],a=[];for(const r of t){const t=[];for(const n of r){const r=[n.x+s[0],n.y+s[1]];dr(e,r),t.push(r);}a.push(t);}if(e[2]-e[0]<=i/2){(o=e)[0]=o[1]=1/0,o[2]=o[3]=-1/0;for(const t of a)for(const n of t)Sr(n,e,r,i);}var o;return a}class Mr{constructor(t,e){this.type=Be,this.geojson=t,this.geometries=e;}static parse(t,e){if(2!==t.length)return e.error(`'within' expression requires exactly one argument, but found ${t.length-1} instead.`);if(Je(t[1])){const e=t[1];if("FeatureCollection"===e.type)for(let t=0;t<e.features.length;++t){const r=e.features[t].geometry.type;if("Polygon"===r||"MultiPolygon"===r)return new Mr(e,e.features[t].geometry)}else if("Feature"===e.type){const t=e.geometry.type;if("Polygon"===t||"MultiPolygon"===t)return new Mr(e,e.geometry)}else if("Polygon"===e.type||"MultiPolygon"===e.type)return new Mr(e,e)}return e.error("'within' expression requires valid geojson object that contains polygon geometry type.")}evaluate(t){if(null!=t.geometry()&&null!=t.canonicalID()){if("Point"===t.geometryType())return function(t,e){const r=[1/0,1/0,-1/0,-1/0],n=[1/0,1/0,-1/0,-1/0],i=t.canonicalID();if("Polygon"===e.type){const s=Ar(e.coordinates,n,i),a=Ir(t.geometry(),r,n,i);if(!fr(r,n))return !1;for(const t of a)if(!gr(t,s))return !1}if("MultiPolygon"===e.type){const s=kr(e.coordinates,n,i),a=Ir(t.geometry(),r,n,i);if(!fr(r,n))return !1;for(const t of a)if(!xr(t,s))return !1}return !0}(t,this.geometries);if("LineString"===t.geometryType())return function(t,e){const r=[1/0,1/0,-1/0,-1/0],n=[1/0,1/0,-1/0,-1/0],i=t.canonicalID();if("Polygon"===e.type){const s=Ar(e.coordinates,n,i),a=zr(t.geometry(),r,n,i);if(!fr(r,n))return !1;for(const t of a)if(!wr(t,s))return !1}if("MultiPolygon"===e.type){const s=kr(e.coordinates,n,i),a=zr(t.geometry(),r,n,i);if(!fr(r,n))return !1;for(const t of a)if(!_r(t,s))return !1}return !0}(t,this.geometries)}return !1}eachChild(){}outputDefined(){return !0}serialize(){return ["within",this.geojson]}}function Tr(t){if(t instanceof cr){if("get"===t.name&&1===t.args.length)return !1;if("feature-state"===t.name)return !1;if("has"===t.name&&1===t.args.length)return !1;if("properties"===t.name||"geometry-type"===t.name||"id"===t.name)return !1;if(/^filter-/.test(t.name))return !1}if(t instanceof Mr)return !1;let e=!0;return t.eachChild((t=>{e&&!Tr(t)&&(e=!1);})),e}function Br(t){if(t instanceof cr&&"feature-state"===t.name)return !1;let e=!0;return t.eachChild((t=>{e&&!Br(t)&&(e=!1);})),e}function Cr(t,e){if(t instanceof cr&&e.indexOf(t.name)>=0)return !1;let r=!0;return t.eachChild((t=>{r&&!Cr(t,e)&&(r=!1);})),r}class Pr{constructor(t,e){this.type=e.type,this.name=t,this.boundExpression=e;}static parse(t,e){if(2!==t.length||"string"!=typeof t[1])return e.error("'var' expression requires exactly one string literal argument.");const r=t[1];return e.scope.has(r)?new Pr(r,e.scope.get(r)):e.error(`Unknown variable "${r}". Make sure "${r}" has been bound in an enclosing "let" expression before using it.`,1)}evaluate(t){return this.boundExpression.evaluate(t)}eachChild(){}outputDefined(){return !1}serialize(){return ["var",this.name]}}class Er{constructor(t,e=[],r,n=new Ie,i=[]){this.registry=t,this.path=e,this.key=e.map((t=>`[${t}]`)).join(""),this.scope=n,this.errors=i,this.expectedType=r;}parse(t,e,r,n,i={}){return e?this.concat(e,r,n)._parse(t,i):this._parse(t,i)}_parse(t,e){function r(t,e,r){return "assert"===r?new nr(e,[t]):"coerce"===r?new or(e,[t]):t}if(null!==t&&"string"!=typeof t&&"boolean"!=typeof t&&"number"!=typeof t||(t=["literal",t]),Array.isArray(t)){if(0===t.length)return this.error('Expected an array with at least one element. If you wanted a literal array, use ["literal", []].');const n=t[0];if("string"!=typeof n)return this.error(`Expression name must be a string, but found ${typeof n} instead. If you wanted a literal array, use ["literal", [...]].`,0),null;const i=this.registry[n];if(i){let n=i.parse(t,this);if(!n)return null;if(this.expectedType){const t=this.expectedType,i=n.type;if("string"!==t.kind&&"number"!==t.kind&&"boolean"!==t.kind&&"object"!==t.kind&&"array"!==t.kind||"value"!==i.kind)if("color"!==t.kind&&"formatted"!==t.kind&&"resolvedImage"!==t.kind||"value"!==i.kind&&"string"!==i.kind){if(this.checkSubtype(t,i))return null}else n=r(n,t,e.typeAnnotation||"coerce");else n=r(n,t,e.typeAnnotation||"assert");}if(!(n instanceof tr)&&"resolvedImage"!==n.type.kind&&Dr(n)){const t=new ur;try{n=new tr(n.type,n.evaluate(t));}catch(t){return this.error(t.message),null}}return n}return this.error(`Unknown expression "${n}". If you wanted a literal array, use ["literal", [...]].`,0)}return this.error(void 0===t?"'undefined' value invalid. Use null instead.":"object"==typeof t?'Bare objects invalid. Use ["literal", {...}] instead.':`Expected an array, but found ${typeof t} instead.`)}concat(t,e,r){const n="number"==typeof t?this.path.concat(t):this.path,i=r?this.scope.concat(r):this.scope;return new Er(this.registry,n,e||null,i,this.errors)}error(t,...e){const r=`${this.key}${e.map((t=>`[${t}]`)).join("")}`;this.errors.push(new Se(r,t));}checkSubtype(t,e){const r=$e(t,e);return r&&this.error(r),r}}function Dr(t){if(t instanceof Pr)return Dr(t.boundExpression);if(t instanceof cr&&"error"===t.name)return !1;if(t instanceof hr)return !1;if(t instanceof Mr)return !1;const e=t instanceof or||t instanceof nr;let r=!0;return t.eachChild((t=>{r=e?r&&Dr(t):r&&t instanceof tr;})),!!r&&Tr(t)&&Cr(t,["zoom","heatmap-density","line-progress","sky-radial-progress","accumulated","is-supported-script","pitch","distance-from-center"])}function Vr(t,e){const r=t.length-1;let n,i,s=0,a=r,o=0;for(;s<=a;)if(o=Math.floor((s+a)/2),n=t[o],i=t[o+1],n<=e){if(o===r||e<i)return o;s=o+1;}else {if(!(n>e))throw new er("Input is not a number.");a=o-1;}return 0}class Fr{constructor(t,e,r){this.type=t,this.input=e,this.labels=[],this.outputs=[];for(const[t,e]of r)this.labels.push(t),this.outputs.push(e);}static parse(t,e){if(t.length-1<4)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if((t.length-1)%2!=0)return e.error("Expected an even number of arguments.");const r=e.parse(t[1],1,Me);if(!r)return null;const n=[];let i=null;e.expectedType&&"value"!==e.expectedType.kind&&(i=e.expectedType);for(let r=1;r<t.length;r+=2){const s=1===r?-1/0:t[r],a=t[r+1],o=r,l=r+1;if("number"!=typeof s)return e.error('Input/output pairs for "step" expressions must be defined using literal numeric values (not computed expressions) for the input values.',o);if(n.length&&n[n.length-1][0]>=s)return e.error('Input/output pairs for "step" expressions must be arranged with input values in strictly ascending order.',o);const u=e.parse(a,l,i);if(!u)return null;i=i||u.type,n.push([s,u]);}return new Fr(i,r,n)}evaluate(t){const e=this.labels,r=this.outputs;if(1===e.length)return r[0].evaluate(t);const n=this.input.evaluate(t);if(n<=e[0])return r[0].evaluate(t);const i=e.length;return n>=e[i-1]?r[i-1].evaluate(t):r[Vr(e,n)].evaluate(t)}eachChild(t){t(this.input);for(const e of this.outputs)t(e);}outputDefined(){return this.outputs.every((t=>t.outputDefined()))}serialize(){const t=["step",this.input.serialize()];for(let e=0;e<this.labels.length;e++)e>0&&t.push(this.labels[e]),t.push(this.outputs[e].serialize());return t}}function Lr(t,e,r){return t*(1-r)+e*r}var Rr=Object.freeze({__proto__:null,number:Lr,color:function(t,e,r){return new Ge(Lr(t.r,e.r,r),Lr(t.g,e.g,r),Lr(t.b,e.b,r),Lr(t.a,e.a,r))},array:function(t,e,r){return t.map(((t,n)=>Lr(t,e[n],r)))}});const Ur=.95047,$r=1.08883,Or=4/29,jr=6/29,qr=3*jr*jr,Nr=Math.PI/180,Gr=180/Math.PI;function Zr(t){return t>.008856451679035631?Math.pow(t,1/3):t/qr+Or}function Xr(t){return t>jr?t*t*t:qr*(t-Or)}function Kr(t){return 255*(t<=.0031308?12.92*t:1.055*Math.pow(t,1/2.4)-.055)}function Yr(t){return (t/=255)<=.04045?t/12.92:Math.pow((t+.055)/1.055,2.4)}function Hr(t){const e=Yr(t.r),r=Yr(t.g),n=Yr(t.b),i=Zr((.4124564*e+.3575761*r+.1804375*n)/Ur),s=Zr((.2126729*e+.7151522*r+.072175*n)/1);return {l:116*s-16,a:500*(i-s),b:200*(s-Zr((.0193339*e+.119192*r+.9503041*n)/$r)),alpha:t.a}}function Jr(t){let e=(t.l+16)/116,r=isNaN(t.a)?e:e+t.a/500,n=isNaN(t.b)?e:e-t.b/200;return e=1*Xr(e),r=Ur*Xr(r),n=$r*Xr(n),new Ge(Kr(3.2404542*r-1.5371385*e-.4985314*n),Kr(-.969266*r+1.8760108*e+.041556*n),Kr(.0556434*r-.2040259*e+1.0572252*n),t.alpha)}function Wr(t,e,r){const n=e-t;return t+r*(n>180||n<-180?n-360*Math.round(n/360):n)}const Qr={forward:Hr,reverse:Jr,interpolate:function(t,e,r){return {l:Lr(t.l,e.l,r),a:Lr(t.a,e.a,r),b:Lr(t.b,e.b,r),alpha:Lr(t.alpha,e.alpha,r)}}},tn={forward:function(t){const{l:e,a:r,b:n}=Hr(t),i=Math.atan2(n,r)*Gr;return {h:i<0?i+360:i,c:Math.sqrt(r*r+n*n),l:e,alpha:t.a}},reverse:function(t){const e=t.h*Nr,r=t.c;return Jr({l:t.l,a:Math.cos(e)*r,b:Math.sin(e)*r,alpha:t.alpha})},interpolate:function(t,e,r){return {h:Wr(t.h,e.h,r),c:Lr(t.c,e.c,r),l:Lr(t.l,e.l,r),alpha:Lr(t.alpha,e.alpha,r)}}};var en=Object.freeze({__proto__:null,lab:Qr,hcl:tn});class rn{constructor(t,e,r,n,i){this.type=t,this.operator=e,this.interpolation=r,this.input=n,this.labels=[],this.outputs=[];for(const[t,e]of i)this.labels.push(t),this.outputs.push(e);}static interpolationFactor(t,e,n,i){let s=0;if("exponential"===t.name)s=nn(e,t.base,n,i);else if("linear"===t.name)s=nn(e,1,n,i);else if("cubic-bezier"===t.name){const a=t.controlPoints;s=new r(a[0],a[1],a[2],a[3]).solve(nn(e,1,n,i));}return s}static parse(t,e){let[r,n,i,...s]=t;if(!Array.isArray(n)||0===n.length)return e.error("Expected an interpolation type expression.",1);if("linear"===n[0])n={name:"linear"};else if("exponential"===n[0]){const t=n[1];if("number"!=typeof t)return e.error("Exponential interpolation requires a numeric base.",1,1);n={name:"exponential",base:t};}else {if("cubic-bezier"!==n[0])return e.error(`Unknown interpolation type ${String(n[0])}`,1,0);{const t=n.slice(1);if(4!==t.length||t.some((t=>"number"!=typeof t||t<0||t>1)))return e.error("Cubic bezier interpolation requires four numeric arguments with values between 0 and 1.",1);n={name:"cubic-bezier",controlPoints:t};}}if(t.length-1<4)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if((t.length-1)%2!=0)return e.error("Expected an even number of arguments.");if(i=e.parse(i,2,Me),!i)return null;const a=[];let o=null;"interpolate-hcl"===r||"interpolate-lab"===r?o=Ce:e.expectedType&&"value"!==e.expectedType.kind&&(o=e.expectedType);for(let t=0;t<s.length;t+=2){const r=s[t],n=s[t+1],i=t+3,l=t+4;if("number"!=typeof r)return e.error('Input/output pairs for "interpolate" expressions must be defined using literal numeric values (not computed expressions) for the input values.',i);if(a.length&&a[a.length-1][0]>=r)return e.error('Input/output pairs for "interpolate" expressions must be arranged with input values in strictly ascending order.',i);const u=e.parse(n,l,o);if(!u)return null;o=o||u.type,a.push([r,u]);}return "number"===o.kind||"color"===o.kind||"array"===o.kind&&"number"===o.itemType.kind&&"number"==typeof o.N?new rn(o,r,n,i,a):e.error(`Type ${Re(o)} is not interpolatable.`)}evaluate(t){const e=this.labels,r=this.outputs;if(1===e.length)return r[0].evaluate(t);const n=this.input.evaluate(t);if(n<=e[0])return r[0].evaluate(t);const i=e.length;if(n>=e[i-1])return r[i-1].evaluate(t);const s=Vr(e,n),a=rn.interpolationFactor(this.interpolation,n,e[s],e[s+1]),o=r[s].evaluate(t),l=r[s+1].evaluate(t);return "interpolate"===this.operator?Rr[this.type.kind.toLowerCase()](o,l,a):"interpolate-hcl"===this.operator?tn.reverse(tn.interpolate(tn.forward(o),tn.forward(l),a)):Qr.reverse(Qr.interpolate(Qr.forward(o),Qr.forward(l),a))}eachChild(t){t(this.input);for(const e of this.outputs)t(e);}outputDefined(){return this.outputs.every((t=>t.outputDefined()))}serialize(){let t;t="linear"===this.interpolation.name?["linear"]:"exponential"===this.interpolation.name?1===this.interpolation.base?["linear"]:["exponential",this.interpolation.base]:["cubic-bezier"].concat(this.interpolation.controlPoints);const e=[this.operator,t,this.input.serialize()];for(let t=0;t<this.labels.length;t++)e.push(this.labels[t],this.outputs[t].serialize());return e}}function nn(t,e,r,n){const i=n-r,s=t-r;return 0===i?0:1===e?s/i:(Math.pow(e,s)-1)/(Math.pow(e,i)-1)}class sn{constructor(t,e){this.type=t,this.args=e;}static parse(t,e){if(t.length<2)return e.error("Expectected at least one argument.");let r=null;const n=e.expectedType;n&&"value"!==n.kind&&(r=n);const i=[];for(const n of t.slice(1)){const t=e.parse(n,1+i.length,r,void 0,{typeAnnotation:"omit"});if(!t)return null;r=r||t.type,i.push(t);}const s=n&&i.some((t=>$e(n,t.type)));return new sn(s?Ee:r,i)}evaluate(t){let e,r=null,n=0;for(const i of this.args){if(n++,r=i.evaluate(t),r&&r instanceof Ye&&!r.available&&(e||(e=r),r=null,n===this.args.length))return e;if(null!==r)break}return r}eachChild(t){this.args.forEach(t);}outputDefined(){return this.args.every((t=>t.outputDefined()))}serialize(){const t=["coalesce"];return this.eachChild((e=>{t.push(e.serialize());})),t}}class an{constructor(t,e){this.type=e.type,this.bindings=[].concat(t),this.result=e;}evaluate(t){return this.result.evaluate(t)}eachChild(t){for(const e of this.bindings)t(e[1]);t(this.result);}static parse(t,e){if(t.length<4)return e.error(`Expected at least 3 arguments, but found ${t.length-1} instead.`);const r=[];for(let n=1;n<t.length-1;n+=2){const i=t[n];if("string"!=typeof i)return e.error(`Expected string, but found ${typeof i} instead.`,n);if(/[^a-zA-Z0-9_]/.test(i))return e.error("Variable names must contain only alphanumeric characters or '_'.",n);const s=e.parse(t[n+1],n+1);if(!s)return null;r.push([i,s]);}const n=e.parse(t[t.length-1],t.length-1,e.expectedType,r);return n?new an(r,n):null}outputDefined(){return this.result.outputDefined()}serialize(){const t=["let"];for(const[e,r]of this.bindings)t.push(e,r.serialize());return t.push(this.result.serialize()),t}}class on{constructor(t,e,r){this.type=t,this.index=e,this.input=r;}static parse(t,e){if(3!==t.length)return e.error(`Expected 2 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,Me),n=e.parse(t[2],2,Le(e.expectedType||Ee));return r&&n?new on(n.type.itemType,r,n):null}evaluate(t){const e=this.index.evaluate(t),r=this.input.evaluate(t);if(e<0)throw new er(`Array index out of bounds: ${e} < 0.`);if(e>=r.length)throw new er(`Array index out of bounds: ${e} > ${r.length-1}.`);if(e!==Math.floor(e))throw new er(`Array index must be an integer, but found ${e} instead.`);return r[e]}eachChild(t){t(this.index),t(this.input);}outputDefined(){return !1}serialize(){return ["at",this.index.serialize(),this.input.serialize()]}}class ln{constructor(t,e){this.type=Be,this.needle=t,this.haystack=e;}static parse(t,e){if(3!==t.length)return e.error(`Expected 2 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,Ee),n=e.parse(t[2],2,Ee);return r&&n?Oe(r.type,[Be,Te,Me,ze,Ee])?new ln(r,n):e.error(`Expected first argument to be of type boolean, string, number or null, but found ${Re(r.type)} instead`):null}evaluate(t){const e=this.needle.evaluate(t),r=this.haystack.evaluate(t);if(!r)return !1;if(!je(e,["boolean","string","number","null"]))throw new er(`Expected first argument to be of type boolean, string, number or null, but found ${Re(We(e))} instead.`);if(!je(r,["string","array"]))throw new er(`Expected second argument to be of type array or string, but found ${Re(We(r))} instead.`);return r.indexOf(e)>=0}eachChild(t){t(this.needle),t(this.haystack);}outputDefined(){return !0}serialize(){return ["in",this.needle.serialize(),this.haystack.serialize()]}}class un{constructor(t,e,r){this.type=Me,this.needle=t,this.haystack=e,this.fromIndex=r;}static parse(t,e){if(t.length<=2||t.length>=5)return e.error(`Expected 3 or 4 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,Ee),n=e.parse(t[2],2,Ee);if(!r||!n)return null;if(!Oe(r.type,[Be,Te,Me,ze,Ee]))return e.error(`Expected first argument to be of type boolean, string, number or null, but found ${Re(r.type)} instead`);if(4===t.length){const i=e.parse(t[3],3,Me);return i?new un(r,n,i):null}return new un(r,n)}evaluate(t){const e=this.needle.evaluate(t),r=this.haystack.evaluate(t);if(!je(e,["boolean","string","number","null"]))throw new er(`Expected first argument to be of type boolean, string, number or null, but found ${Re(We(e))} instead.`);if(!je(r,["string","array"]))throw new er(`Expected second argument to be of type array or string, but found ${Re(We(r))} instead.`);if(this.fromIndex){const n=this.fromIndex.evaluate(t);return r.indexOf(e,n)}return r.indexOf(e)}eachChild(t){t(this.needle),t(this.haystack),this.fromIndex&&t(this.fromIndex);}outputDefined(){return !1}serialize(){if(null!=this.fromIndex&&void 0!==this.fromIndex){const t=this.fromIndex.serialize();return ["index-of",this.needle.serialize(),this.haystack.serialize(),t]}return ["index-of",this.needle.serialize(),this.haystack.serialize()]}}class cn{constructor(t,e,r,n,i,s){this.inputType=t,this.type=e,this.input=r,this.cases=n,this.outputs=i,this.otherwise=s;}static parse(t,e){if(t.length<5)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if(t.length%2!=1)return e.error("Expected an even number of arguments.");let r,n;e.expectedType&&"value"!==e.expectedType.kind&&(n=e.expectedType);const i={},s=[];for(let a=2;a<t.length-1;a+=2){let o=t[a];const l=t[a+1];Array.isArray(o)||(o=[o]);const u=e.concat(a);if(0===o.length)return u.error("Expected at least one branch label.");for(const t of o){if("number"!=typeof t&&"string"!=typeof t)return u.error("Branch labels must be numbers or strings.");if("number"==typeof t&&Math.abs(t)>Number.MAX_SAFE_INTEGER)return u.error(`Branch labels must be integers no larger than ${Number.MAX_SAFE_INTEGER}.`);if("number"==typeof t&&Math.floor(t)!==t)return u.error("Numeric branch labels must be integer values.");if(r){if(u.checkSubtype(r,We(t)))return null}else r=We(t);if(void 0!==i[String(t)])return u.error("Branch labels must be unique.");i[String(t)]=s.length;}const c=e.parse(l,a,n);if(!c)return null;n=n||c.type,s.push(c);}const a=e.parse(t[1],1,Ee);if(!a)return null;const o=e.parse(t[t.length-1],t.length-1,n);return o?"value"!==a.type.kind&&e.concat(1).checkSubtype(r,a.type)?null:new cn(r,n,a,i,s,o):null}evaluate(t){const e=this.input.evaluate(t);return (We(e)===this.inputType&&this.outputs[this.cases[e]]||this.otherwise).evaluate(t)}eachChild(t){t(this.input),this.outputs.forEach(t),t(this.otherwise);}outputDefined(){return this.outputs.every((t=>t.outputDefined()))&&this.otherwise.outputDefined()}serialize(){const t=["match",this.input.serialize()],e=Object.keys(this.cases).sort(),r=[],n={};for(const t of e){const e=n[this.cases[t]];void 0===e?(n[this.cases[t]]=r.length,r.push([this.cases[t],[t]])):r[e][1].push(t);}const i=t=>"number"===this.inputType.kind?Number(t):t;for(const[e,n]of r)t.push(1===n.length?i(n[0]):n.map(i)),t.push(this.outputs[e].serialize());return t.push(this.otherwise.serialize()),t}}class hn{constructor(t,e,r){this.type=t,this.branches=e,this.otherwise=r;}static parse(t,e){if(t.length<4)return e.error(`Expected at least 3 arguments, but found only ${t.length-1}.`);if(t.length%2!=0)return e.error("Expected an odd number of arguments.");let r;e.expectedType&&"value"!==e.expectedType.kind&&(r=e.expectedType);const n=[];for(let i=1;i<t.length-1;i+=2){const s=e.parse(t[i],i,Be);if(!s)return null;const a=e.parse(t[i+1],i+1,r);if(!a)return null;n.push([s,a]),r=r||a.type;}const i=e.parse(t[t.length-1],t.length-1,r);return i?new hn(r,n,i):null}evaluate(t){for(const[e,r]of this.branches)if(e.evaluate(t))return r.evaluate(t);return this.otherwise.evaluate(t)}eachChild(t){for(const[e,r]of this.branches)t(e),t(r);t(this.otherwise);}outputDefined(){return this.branches.every((([t,e])=>e.outputDefined()))&&this.otherwise.outputDefined()}serialize(){const t=["case"];return this.eachChild((e=>{t.push(e.serialize());})),t}}class pn{constructor(t,e,r,n){this.type=t,this.input=e,this.beginIndex=r,this.endIndex=n;}static parse(t,e){if(t.length<=2||t.length>=5)return e.error(`Expected 3 or 4 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,Ee),n=e.parse(t[2],2,Me);if(!r||!n)return null;if(!Oe(r.type,[Le(Ee),Te,Ee]))return e.error(`Expected first argument to be of type array or string, but found ${Re(r.type)} instead`);if(4===t.length){const i=e.parse(t[3],3,Me);return i?new pn(r.type,r,n,i):null}return new pn(r.type,r,n)}evaluate(t){const e=this.input.evaluate(t),r=this.beginIndex.evaluate(t);if(!je(e,["string","array"]))throw new er(`Expected first argument to be of type array or string, but found ${Re(We(e))} instead.`);if(this.endIndex){const n=this.endIndex.evaluate(t);return e.slice(r,n)}return e.slice(r)}eachChild(t){t(this.input),t(this.beginIndex),this.endIndex&&t(this.endIndex);}outputDefined(){return !1}serialize(){if(null!=this.endIndex&&void 0!==this.endIndex){const t=this.endIndex.serialize();return ["slice",this.input.serialize(),this.beginIndex.serialize(),t]}return ["slice",this.input.serialize(),this.beginIndex.serialize()]}}function dn(t,e){return "=="===t||"!="===t?"boolean"===e.kind||"string"===e.kind||"number"===e.kind||"null"===e.kind||"value"===e.kind:"string"===e.kind||"number"===e.kind||"value"===e.kind}function fn(t,e,r,n){return 0===n.compare(e,r)}function yn(t,e,r){const n="=="!==t&&"!="!==t;return class i{constructor(t,e,r){this.type=Be,this.lhs=t,this.rhs=e,this.collator=r,this.hasUntypedArgument="value"===t.type.kind||"value"===e.type.kind;}static parse(t,e){if(3!==t.length&&4!==t.length)return e.error("Expected two or three arguments.");const r=t[0];let s=e.parse(t[1],1,Ee);if(!s)return null;if(!dn(r,s.type))return e.concat(1).error(`"${r}" comparisons are not supported for type '${Re(s.type)}'.`);let a=e.parse(t[2],2,Ee);if(!a)return null;if(!dn(r,a.type))return e.concat(2).error(`"${r}" comparisons are not supported for type '${Re(a.type)}'.`);if(s.type.kind!==a.type.kind&&"value"!==s.type.kind&&"value"!==a.type.kind)return e.error(`Cannot compare types '${Re(s.type)}' and '${Re(a.type)}'.`);n&&("value"===s.type.kind&&"value"!==a.type.kind?s=new nr(a.type,[s]):"value"!==s.type.kind&&"value"===a.type.kind&&(a=new nr(s.type,[a])));let o=null;if(4===t.length){if("string"!==s.type.kind&&"string"!==a.type.kind&&"value"!==s.type.kind&&"value"!==a.type.kind)return e.error("Cannot use collator to compare non-string types.");if(o=e.parse(t[3],3,De),!o)return null}return new i(s,a,o)}evaluate(i){const s=this.lhs.evaluate(i),a=this.rhs.evaluate(i);if(n&&this.hasUntypedArgument){const e=We(s),r=We(a);if(e.kind!==r.kind||"string"!==e.kind&&"number"!==e.kind)throw new er(`Expected arguments for "${t}" to be (string, string) or (number, number), but found (${e.kind}, ${r.kind}) instead.`)}if(this.collator&&!n&&this.hasUntypedArgument){const t=We(s),r=We(a);if("string"!==t.kind||"string"!==r.kind)return e(i,s,a)}return this.collator?r(i,s,a,this.collator.evaluate(i)):e(i,s,a)}eachChild(t){t(this.lhs),t(this.rhs),this.collator&&t(this.collator);}outputDefined(){return !0}serialize(){const e=[t];return this.eachChild((t=>{e.push(t.serialize());})),e}}}const mn=yn("==",(function(t,e,r){return e===r}),fn),gn=yn("!=",(function(t,e,r){return e!==r}),(function(t,e,r,n){return !fn(0,e,r,n)})),xn=yn("<",(function(t,e,r){return e<r}),(function(t,e,r,n){return n.compare(e,r)<0})),vn=yn(">",(function(t,e,r){return e>r}),(function(t,e,r,n){return n.compare(e,r)>0})),bn=yn("<=",(function(t,e,r){return e<=r}),(function(t,e,r,n){return n.compare(e,r)<=0})),wn=yn(">=",(function(t,e,r){return e>=r}),(function(t,e,r,n){return n.compare(e,r)>=0}));class _n{constructor(t,e,r,n,i){this.type=Te,this.number=t,this.locale=e,this.currency=r,this.minFractionDigits=n,this.maxFractionDigits=i;}static parse(t,e){if(3!==t.length)return e.error("Expected two arguments.");const r=e.parse(t[1],1,Me);if(!r)return null;const n=t[2];if("object"!=typeof n||Array.isArray(n))return e.error("NumberFormat options argument must be an object.");let i=null;if(n.locale&&(i=e.parse(n.locale,1,Te),!i))return null;let s=null;if(n.currency&&(s=e.parse(n.currency,1,Te),!s))return null;let a=null;if(n["min-fraction-digits"]&&(a=e.parse(n["min-fraction-digits"],1,Me),!a))return null;let o=null;return n["max-fraction-digits"]&&(o=e.parse(n["max-fraction-digits"],1,Me),!o)?null:new _n(r,i,s,a,o)}evaluate(t){return new Intl.NumberFormat(this.locale?this.locale.evaluate(t):[],{style:this.currency?"currency":"decimal",currency:this.currency?this.currency.evaluate(t):void 0,minimumFractionDigits:this.minFractionDigits?this.minFractionDigits.evaluate(t):void 0,maximumFractionDigits:this.maxFractionDigits?this.maxFractionDigits.evaluate(t):void 0}).format(this.number.evaluate(t))}eachChild(t){t(this.number),this.locale&&t(this.locale),this.currency&&t(this.currency),this.minFractionDigits&&t(this.minFractionDigits),this.maxFractionDigits&&t(this.maxFractionDigits);}outputDefined(){return !1}serialize(){const t={};return this.locale&&(t.locale=this.locale.serialize()),this.currency&&(t.currency=this.currency.serialize()),this.minFractionDigits&&(t["min-fraction-digits"]=this.minFractionDigits.serialize()),this.maxFractionDigits&&(t["max-fraction-digits"]=this.maxFractionDigits.serialize()),["number-format",this.number.serialize(),t]}}class An{constructor(t){this.type=Me,this.input=t;}static parse(t,e){if(2!==t.length)return e.error(`Expected 1 argument, but found ${t.length-1} instead.`);const r=e.parse(t[1],1);return r?"array"!==r.type.kind&&"string"!==r.type.kind&&"value"!==r.type.kind?e.error(`Expected argument of type string or array, but found ${Re(r.type)} instead.`):new An(r):null}evaluate(t){const e=this.input.evaluate(t);if("string"==typeof e)return e.length;if(Array.isArray(e))return e.length;throw new er(`Expected value to be of type string or array, but found ${Re(We(e))} instead.`)}eachChild(t){t(this.input);}outputDefined(){return !1}serialize(){const t=["length"];return this.eachChild((e=>{t.push(e.serialize());})),t}}const kn={"==":mn,"!=":gn,">":vn,"<":xn,">=":wn,"<=":bn,array:nr,at:on,boolean:nr,case:hn,coalesce:sn,collator:hr,format:ir,image:sr,in:ln,"index-of":un,interpolate:rn,"interpolate-hcl":rn,"interpolate-lab":rn,length:An,let:an,literal:tr,match:cn,number:nr,"number-format":_n,object:nr,slice:pn,step:Fr,string:nr,"to-boolean":or,"to-color":or,"to-number":or,"to-string":or,var:Pr,within:Mr};function Sn(t,[e,r,n,i]){e=e.evaluate(t),r=r.evaluate(t),n=n.evaluate(t);const s=i?i.evaluate(t):1,a=He(e,r,n,s);if(a)throw new er(a);return new Ge(e/255*s,r/255*s,n/255*s,s)}function In(t,e){return t in e}function zn(t,e){const r=e[t];return void 0===r?null:r}function Mn(t){return {type:t}}function Tn(t){return {result:"success",value:t}}function Bn(t){return {result:"error",value:t}}function Cn(t){return "data-driven"===t["property-type"]||"cross-faded-data-driven"===t["property-type"]}function Pn(t){return !!t.expression&&t.expression.parameters.indexOf("zoom")>-1}function En(t){return !!t.expression&&t.expression.interpolated}function Dn(t){return t instanceof Number?"number":t instanceof String?"string":t instanceof Boolean?"boolean":Array.isArray(t)?"array":null===t?"null":typeof t}function Vn(t){return "object"==typeof t&&null!==t&&!Array.isArray(t)}function Fn(t){return t}function Ln(t,e){const r="color"===e.type,n=t.stops&&"object"==typeof t.stops[0][0],i=n||!(n||void 0!==t.property),s=t.type||(En(e)?"exponential":"interval");if(r&&((t=_e({},t)).stops&&(t.stops=t.stops.map((t=>[t[0],Ge.parse(t[1])]))),t.default=Ge.parse(t.default?t.default:e.default)),t.colorSpace&&"rgb"!==t.colorSpace&&!en[t.colorSpace])throw new Error(`Unknown color space: ${t.colorSpace}`);let a,o,l;if("exponential"===s)a=On;else if("interval"===s)a=$n;else if("categorical"===s){a=Un,o=Object.create(null);for(const e of t.stops)o[e[0]]=e[1];l=typeof t.stops[0][0];}else {if("identity"!==s)throw new Error(`Unknown function type "${s}"`);a=jn;}if(n){const r={},n=[];for(let e=0;e<t.stops.length;e++){const i=t.stops[e],s=i[0].zoom;void 0===r[s]&&(r[s]={zoom:s,type:t.type,property:t.property,default:t.default,stops:[]},n.push(s)),r[s].stops.push([i[0].value,i[1]]);}const i=[];for(const t of n)i.push([r[t].zoom,Ln(r[t],e)]);const s={name:"linear"};return {kind:"composite",interpolationType:s,interpolationFactor:rn.interpolationFactor.bind(void 0,s),zoomStops:i.map((t=>t[0])),evaluate:({zoom:r},n)=>On({stops:i,base:t.base},e,r).evaluate(r,n)}}if(i){const r="exponential"===s?{name:"exponential",base:void 0!==t.base?t.base:1}:null;return {kind:"camera",interpolationType:r,interpolationFactor:rn.interpolationFactor.bind(void 0,r),zoomStops:t.stops.map((t=>t[0])),evaluate:({zoom:r})=>a(t,e,r,o,l)}}return {kind:"source",evaluate(r,n){const i=n&&n.properties?n.properties[t.property]:void 0;return void 0===i?Rn(t.default,e.default):a(t,e,i,o,l)}}}function Rn(t,e,r){return void 0!==t?t:void 0!==e?e:void 0!==r?r:void 0}function Un(t,e,r,n,i){return Rn(typeof r===i?n[r]:void 0,t.default,e.default)}function $n(t,e,r){if("number"!==Dn(r))return Rn(t.default,e.default);const n=t.stops.length;if(1===n)return t.stops[0][1];if(r<=t.stops[0][0])return t.stops[0][1];if(r>=t.stops[n-1][0])return t.stops[n-1][1];const i=Vr(t.stops.map((t=>t[0])),r);return t.stops[i][1]}function On(t,e,r){const n=void 0!==t.base?t.base:1;if("number"!==Dn(r))return Rn(t.default,e.default);const i=t.stops.length;if(1===i)return t.stops[0][1];if(r<=t.stops[0][0])return t.stops[0][1];if(r>=t.stops[i-1][0])return t.stops[i-1][1];const s=Vr(t.stops.map((t=>t[0])),r),a=function(t,e,r,n){const i=n-r,s=t-r;return 0===i?0:1===e?s/i:(Math.pow(e,s)-1)/(Math.pow(e,i)-1)}(r,n,t.stops[s][0],t.stops[s+1][0]),o=t.stops[s][1],l=t.stops[s+1][1];let u=Rr[e.type]||Fn;if(t.colorSpace&&"rgb"!==t.colorSpace){const e=en[t.colorSpace];u=(t,r)=>e.reverse(e.interpolate(e.forward(t),e.forward(r),a));}return "function"==typeof o.evaluate?{evaluate(...t){const e=o.evaluate.apply(void 0,t),r=l.evaluate.apply(void 0,t);if(void 0!==e&&void 0!==r)return u(e,r,a)}}:u(o,l,a)}function jn(t,e,r){return "color"===e.type?r=Ge.parse(r):"formatted"===e.type?r=Ke.fromString(r.toString()):"resolvedImage"===e.type?r=Ye.fromString(r.toString()):Dn(r)===e.type||"enum"===e.type&&e.values[r]||(r=void 0),Rn(r,t.default,e.default)}cr.register(kn,{error:[{kind:"error"},[Te],(t,[e])=>{throw new er(e.evaluate(t))}],typeof:[Te,[Ee],(t,[e])=>Re(We(e.evaluate(t)))],"to-rgba":[Le(Me,4),[Ce],(t,[e])=>e.evaluate(t).toArray()],rgb:[Ce,[Me,Me,Me],Sn],rgba:[Ce,[Me,Me,Me,Me],Sn],has:{type:Be,overloads:[[[Te],(t,[e])=>In(e.evaluate(t),t.properties())],[[Te,Pe],(t,[e,r])=>In(e.evaluate(t),r.evaluate(t))]]},get:{type:Ee,overloads:[[[Te],(t,[e])=>zn(e.evaluate(t),t.properties())],[[Te,Pe],(t,[e,r])=>zn(e.evaluate(t),r.evaluate(t))]]},"feature-state":[Ee,[Te],(t,[e])=>zn(e.evaluate(t),t.featureState||{})],properties:[Pe,[],t=>t.properties()],"geometry-type":[Te,[],t=>t.geometryType()],id:[Ee,[],t=>t.id()],zoom:[Me,[],t=>t.globals.zoom],pitch:[Me,[],t=>t.globals.pitch||0],"distance-from-center":[Me,[],t=>t.distanceFromCenter()],"heatmap-density":[Me,[],t=>t.globals.heatmapDensity||0],"line-progress":[Me,[],t=>t.globals.lineProgress||0],"sky-radial-progress":[Me,[],t=>t.globals.skyRadialProgress||0],accumulated:[Ee,[],t=>void 0===t.globals.accumulated?null:t.globals.accumulated],"+":[Me,Mn(Me),(t,e)=>{let r=0;for(const n of e)r+=n.evaluate(t);return r}],"*":[Me,Mn(Me),(t,e)=>{let r=1;for(const n of e)r*=n.evaluate(t);return r}],"-":{type:Me,overloads:[[[Me,Me],(t,[e,r])=>e.evaluate(t)-r.evaluate(t)],[[Me],(t,[e])=>-e.evaluate(t)]]},"/":[Me,[Me,Me],(t,[e,r])=>e.evaluate(t)/r.evaluate(t)],"%":[Me,[Me,Me],(t,[e,r])=>e.evaluate(t)%r.evaluate(t)],ln2:[Me,[],()=>Math.LN2],pi:[Me,[],()=>Math.PI],e:[Me,[],()=>Math.E],"^":[Me,[Me,Me],(t,[e,r])=>Math.pow(e.evaluate(t),r.evaluate(t))],sqrt:[Me,[Me],(t,[e])=>Math.sqrt(e.evaluate(t))],log10:[Me,[Me],(t,[e])=>Math.log(e.evaluate(t))/Math.LN10],ln:[Me,[Me],(t,[e])=>Math.log(e.evaluate(t))],log2:[Me,[Me],(t,[e])=>Math.log(e.evaluate(t))/Math.LN2],sin:[Me,[Me],(t,[e])=>Math.sin(e.evaluate(t))],cos:[Me,[Me],(t,[e])=>Math.cos(e.evaluate(t))],tan:[Me,[Me],(t,[e])=>Math.tan(e.evaluate(t))],asin:[Me,[Me],(t,[e])=>Math.asin(e.evaluate(t))],acos:[Me,[Me],(t,[e])=>Math.acos(e.evaluate(t))],atan:[Me,[Me],(t,[e])=>Math.atan(e.evaluate(t))],min:[Me,Mn(Me),(t,e)=>Math.min(...e.map((e=>e.evaluate(t))))],max:[Me,Mn(Me),(t,e)=>Math.max(...e.map((e=>e.evaluate(t))))],abs:[Me,[Me],(t,[e])=>Math.abs(e.evaluate(t))],round:[Me,[Me],(t,[e])=>{const r=e.evaluate(t);return r<0?-Math.round(-r):Math.round(r)}],floor:[Me,[Me],(t,[e])=>Math.floor(e.evaluate(t))],ceil:[Me,[Me],(t,[e])=>Math.ceil(e.evaluate(t))],"filter-==":[Be,[Te,Ee],(t,[e,r])=>t.properties()[e.value]===r.value],"filter-id-==":[Be,[Ee],(t,[e])=>t.id()===e.value],"filter-type-==":[Be,[Te],(t,[e])=>t.geometryType()===e.value],"filter-<":[Be,[Te,Ee],(t,[e,r])=>{const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n<i}],"filter-id-<":[Be,[Ee],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r<n}],"filter->":[Be,[Te,Ee],(t,[e,r])=>{const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n>i}],"filter-id->":[Be,[Ee],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r>n}],"filter-<=":[Be,[Te,Ee],(t,[e,r])=>{const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n<=i}],"filter-id-<=":[Be,[Ee],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r<=n}],"filter->=":[Be,[Te,Ee],(t,[e,r])=>{const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n>=i}],"filter-id->=":[Be,[Ee],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r>=n}],"filter-has":[Be,[Ee],(t,[e])=>e.value in t.properties()],"filter-has-id":[Be,[],t=>null!==t.id()&&void 0!==t.id()],"filter-type-in":[Be,[Le(Te)],(t,[e])=>e.value.indexOf(t.geometryType())>=0],"filter-id-in":[Be,[Le(Ee)],(t,[e])=>e.value.indexOf(t.id())>=0],"filter-in-small":[Be,[Te,Le(Ee)],(t,[e,r])=>r.value.indexOf(t.properties()[e.value])>=0],"filter-in-large":[Be,[Te,Le(Ee)],(t,[e,r])=>function(t,e,r,n){for(;r<=n;){const i=r+n>>1;if(e[i]===t)return !0;e[i]>t?n=i-1:r=i+1;}return !1}(t.properties()[e.value],r.value,0,r.value.length-1)],all:{type:Be,overloads:[[[Be,Be],(t,[e,r])=>e.evaluate(t)&&r.evaluate(t)],[Mn(Be),(t,e)=>{for(const r of e)if(!r.evaluate(t))return !1;return !0}]]},any:{type:Be,overloads:[[[Be,Be],(t,[e,r])=>e.evaluate(t)||r.evaluate(t)],[Mn(Be),(t,e)=>{for(const r of e)if(r.evaluate(t))return !0;return !1}]]},"!":[Be,[Be],(t,[e])=>!e.evaluate(t)],"is-supported-script":[Be,[Te],(t,[e])=>{const r=t.globals&&t.globals.isSupportedScript;return !r||r(e.evaluate(t))}],upcase:[Te,[Te],(t,[e])=>e.evaluate(t).toUpperCase()],downcase:[Te,[Te],(t,[e])=>e.evaluate(t).toLowerCase()],concat:[Te,Mn(Ee),(t,e)=>e.map((e=>Qe(e.evaluate(t)))).join("")],"resolved-locale":[Te,[De],(t,[e])=>e.evaluate(t).resolvedLocale()]});class qn{constructor(t,e){this.expression=t,this._warningHistory={},this._evaluator=new ur,this._defaultValue=e?function(t){return "color"===t.type&&Vn(t.default)?new Ge(0,0,0,0):"color"===t.type?Ge.parse(t.default)||null:void 0===t.default?null:t.default}(e):null,this._enumValues=e&&"enum"===e.type?e.values:null;}evaluateWithoutErrorHandling(t,e,r,n,i,s,a,o){return this._evaluator.globals=t,this._evaluator.feature=e,this._evaluator.featureState=r,this._evaluator.canonical=n,this._evaluator.availableImages=i||null,this._evaluator.formattedSection=s,this._evaluator.featureTileCoord=a||null,this._evaluator.featureDistanceData=o||null,this.expression.evaluate(this._evaluator)}evaluate(t,e,r,n,i,s,a,o){this._evaluator.globals=t,this._evaluator.feature=e||null,this._evaluator.featureState=r||null,this._evaluator.canonical=n,this._evaluator.availableImages=i||null,this._evaluator.formattedSection=s||null,this._evaluator.featureTileCoord=a||null,this._evaluator.featureDistanceData=o||null;try{const t=this.expression.evaluate(this._evaluator);if(null==t||"number"==typeof t&&t!=t)return this._defaultValue;if(this._enumValues&&!(t in this._enumValues))throw new er(`Expected value to be one of ${Object.keys(this._enumValues).map((t=>JSON.stringify(t))).join(", ")}, but found ${JSON.stringify(t)} instead.`);return t}catch(t){return this._warningHistory[t.message]||(this._warningHistory[t.message]=!0,"undefined"!=typeof console&&console.warn(t.message)),this._defaultValue}}}function Nn(t){return Array.isArray(t)&&t.length>0&&"string"==typeof t[0]&&t[0]in kn}function Gn(t,e){const r=new Er(kn,[],e?function(t){const e={color:Ce,string:Te,number:Me,enum:Te,boolean:Be,formatted:Ve,resolvedImage:Fe};return "array"===t.type?Le(e[t.value]||Ee,t.length):e[t.type]}(e):void 0),n=r.parse(t,void 0,void 0,void 0,e&&"string"===e.type?{typeAnnotation:"coerce"}:void 0);return n?Tn(new qn(n,e)):Bn(r.errors)}class Zn{constructor(t,e){this.kind=t,this._styleExpression=e,this.isStateDependent="constant"!==t&&!Br(e.expression);}evaluateWithoutErrorHandling(t,e,r,n,i,s){return this._styleExpression.evaluateWithoutErrorHandling(t,e,r,n,i,s)}evaluate(t,e,r,n,i,s){return this._styleExpression.evaluate(t,e,r,n,i,s)}}class Xn{constructor(t,e,r,n){this.kind=t,this.zoomStops=r,this._styleExpression=e,this.isStateDependent="camera"!==t&&!Br(e.expression),this.interpolationType=n;}evaluateWithoutErrorHandling(t,e,r,n,i,s){return this._styleExpression.evaluateWithoutErrorHandling(t,e,r,n,i,s)}evaluate(t,e,r,n,i,s){return this._styleExpression.evaluate(t,e,r,n,i,s)}interpolationFactor(t,e,r){return this.interpolationType?rn.interpolationFactor(this.interpolationType,t,e,r):0}}function Kn(t,e){if("error"===(t=Gn(t,e)).result)return t;const r=t.value.expression,n=Tr(r);if(!n&&!Cn(e))return Bn([new Se("","data expressions not supported")]);const i=Cr(r,["zoom","pitch","distance-from-center"]);if(!i&&!Pn(e))return Bn([new Se("","zoom expressions not supported")]);const s=Hn(r);return s||i?s instanceof Se?Bn([s]):s instanceof rn&&!En(e)?Bn([new Se("",'"interpolate" expressions cannot be used with this property')]):Tn(s?new Xn(n?"camera":"composite",t.value,s.labels,s instanceof rn?s.interpolation:void 0):new Zn(n?"constant":"source",t.value)):Bn([new Se("",'"zoom" expression may only be used as input to a top-level "step" or "interpolate" expression.')])}class Yn{constructor(t,e){this._parameters=t,this._specification=e,_e(this,Ln(this._parameters,this._specification));}static deserialize(t){return new Yn(t._parameters,t._specification)}static serialize(t){return {_parameters:t._parameters,_specification:t._specification}}}function Hn(t){let e=null;if(t instanceof an)e=Hn(t.result);else if(t instanceof sn){for(const r of t.args)if(e=Hn(r),e)break}else (t instanceof Fr||t instanceof rn)&&t.input instanceof cr&&"zoom"===t.input.name&&(e=t);return e instanceof Se||t.eachChild((t=>{const r=Hn(t);r instanceof Se?e=r:!e&&r?e=new Se("",'"zoom" expression may only be used as input to a top-level "step" or "interpolate" expression.'):e&&r&&e!==r&&(e=new Se("",'Only one zoom-based "step" or "interpolate" subexpression may be used in an expression.'));})),e}function Jn(t){const e=t.key,r=t.value,n=t.valueSpec||{},i=t.objectElementValidators||{},s=t.style,a=t.styleSpec;let o=[];const l=Dn(r);if("object"!==l)return [new be(e,r,`object expected, ${l} found`)];for(const t in r){const l=t.split(".")[0],u=n[l]||n["*"];let c;if(i[l])c=i[l];else if(n[l])c=Bi;else if(i["*"])c=i["*"];else {if(!n["*"]){o.push(new be(e,r[t],`unknown property "${t}"`));continue}c=Bi;}o=o.concat(c({key:(e?`${e}.`:e)+t,value:r[t],valueSpec:u,style:s,styleSpec:a,object:r,objectKey:t},r));}for(const t in n)i[t]||n[t].required&&void 0===n[t].default&&void 0===r[t]&&o.push(new be(e,r,`missing required property "${t}"`));return o}function Wn(t){const e=t.value,r=t.valueSpec,n=t.style,i=t.styleSpec,s=t.key,a=t.arrayElementValidator||Bi;if("array"!==Dn(e))return [new be(s,e,`array expected, ${Dn(e)} found`)];if(r.length&&e.length!==r.length)return [new be(s,e,`array length ${r.length} expected, length ${e.length} found`)];if(r["min-length"]&&e.length<r["min-length"])return [new be(s,e,`array length at least ${r["min-length"]} expected, length ${e.length} found`)];let o={type:r.value,values:r.values,minimum:r.minimum,maximum:r.maximum};i.$version<7&&(o.function=r.function),"object"===Dn(r.value)&&(o=r.value);let l=[];for(let t=0;t<e.length;t++)l=l.concat(a({array:e,arrayIndex:t,value:e[t],valueSpec:o,style:n,styleSpec:i,key:`${s}[${t}]`}));return l}function Qn(t){const e=t.key,r=t.value,n=t.valueSpec;let i=Dn(r);if("number"===i&&r!=r&&(i="NaN"),"number"!==i)return [new be(e,r,`number expected, ${i} found`)];if("minimum"in n){let i=n.minimum;if("array"===Dn(n.minimum)&&(i=n.minimum[t.arrayIndex]),r<i)return [new be(e,r,`${r} is less than the minimum value ${i}`)]}if("maximum"in n){let i=n.maximum;if("array"===Dn(n.maximum)&&(i=n.maximum[t.arrayIndex]),r>i)return [new be(e,r,`${r} is greater than the maximum value ${i}`)]}return []}function ti(t){const e=t.valueSpec,r=Ae(t.value.type);let n,i,s,a={};const o="categorical"!==r&&void 0===t.value.property,l=!o,u="array"===Dn(t.value.stops)&&"array"===Dn(t.value.stops[0])&&"object"===Dn(t.value.stops[0][0]),c=Jn({key:t.key,value:t.value,valueSpec:t.styleSpec.function,style:t.style,styleSpec:t.styleSpec,objectElementValidators:{stops:function(t){if("identity"===r)return [new be(t.key,t.value,'identity function may not have a "stops" property')];let e=[];const n=t.value;return e=e.concat(Wn({key:t.key,value:n,valueSpec:t.valueSpec,style:t.style,styleSpec:t.styleSpec,arrayElementValidator:h})),"array"===Dn(n)&&0===n.length&&e.push(new be(t.key,n,"array must have at least one stop")),e},default:function(t){return Bi({key:t.key,value:t.value,valueSpec:e,style:t.style,styleSpec:t.styleSpec})}}});return "identity"===r&&o&&c.push(new be(t.key,t.value,'missing required property "property"')),"identity"===r||t.value.stops||c.push(new be(t.key,t.value,'missing required property "stops"')),"exponential"===r&&t.valueSpec.expression&&!En(t.valueSpec)&&c.push(new be(t.key,t.value,"exponential functions not supported")),t.styleSpec.$version>=8&&(l&&!Cn(t.valueSpec)?c.push(new be(t.key,t.value,"property functions not supported")):o&&!Pn(t.valueSpec)&&c.push(new be(t.key,t.value,"zoom functions not supported"))),"categorical"!==r&&!u||void 0!==t.value.property||c.push(new be(t.key,t.value,'"property" property is required')),c;function h(t){let r=[];const n=t.value,o=t.key;if("array"!==Dn(n))return [new be(o,n,`array expected, ${Dn(n)} found`)];if(2!==n.length)return [new be(o,n,`array length 2 expected, length ${n.length} found`)];if(u){if("object"!==Dn(n[0]))return [new be(o,n,`object expected, ${Dn(n[0])} found`)];if(void 0===n[0].zoom)return [new be(o,n,"object stop key must have zoom")];if(void 0===n[0].value)return [new be(o,n,"object stop key must have value")];if(s&&s>Ae(n[0].zoom))return [new be(o,n[0].zoom,"stop zoom values must appear in ascending order")];Ae(n[0].zoom)!==s&&(s=Ae(n[0].zoom),i=void 0,a={}),r=r.concat(Jn({key:`${o}[0]`,value:n[0],valueSpec:{zoom:{}},style:t.style,styleSpec:t.styleSpec,objectElementValidators:{zoom:Qn,value:p}}));}else r=r.concat(p({key:`${o}[0]`,value:n[0],valueSpec:{},style:t.style,styleSpec:t.styleSpec},n));return Nn(ke(n[1]))?r.concat([new be(`${o}[1]`,n[1],"expressions are not allowed in function stops.")]):r.concat(Bi({key:`${o}[1]`,value:n[1],valueSpec:e,style:t.style,styleSpec:t.styleSpec}))}function p(t,s){const o=Dn(t.value),l=Ae(t.value),u=null!==t.value?t.value:s;if(n){if(o!==n)return [new be(t.key,u,`${o} stop domain type must match previous stop domain type ${n}`)]}else n=o;if("number"!==o&&"string"!==o&&"boolean"!==o)return [new be(t.key,u,"stop domain value must be a number, string, or boolean")];if("number"!==o&&"categorical"!==r){let n=`number expected, ${o} found`;return Cn(e)&&void 0===r&&(n+='\nIf you intended to use a categorical function, specify `"type": "categorical"`.'),[new be(t.key,u,n)]}return "categorical"!==r||"number"!==o||isFinite(l)&&Math.floor(l)===l?"categorical"!==r&&"number"===o&&void 0!==i&&l<i?[new be(t.key,u,"stop domain values must appear in ascending order")]:(i=l,"categorical"===r&&l in a?[new be(t.key,u,"stop domain values must be unique")]:(a[l]=!0,[])):[new be(t.key,u,`integer expected, found ${l}`)]}}function ei(t){const e=("property"===t.expressionContext?Kn:Gn)(ke(t.value),t.valueSpec);if("error"===e.result)return e.value.map((e=>new be(`${t.key}${e.key}`,t.value,e.message)));const r=e.value.expression||e.value._styleExpression.expression;if("property"===t.expressionContext&&"text-font"===t.propertyKey&&!r.outputDefined())return [new be(t.key,t.value,`Invalid data expression for "${t.propertyKey}". Output values must be contained as literals within the expression.`)];if("property"===t.expressionContext&&"layout"===t.propertyType&&!Br(r))return [new be(t.key,t.value,'"feature-state" data expressions are not supported with layout properties.')];if("filter"===t.expressionContext)return ri(r,t);if(t.expressionContext&&0===t.expressionContext.indexOf("cluster")){if(!Cr(r,["zoom","feature-state"]))return [new be(t.key,t.value,'"zoom" and "feature-state" expressions are not supported with cluster properties.')];if("cluster-initial"===t.expressionContext&&!Tr(r))return [new be(t.key,t.value,"Feature data expressions are not supported with initial expression part of cluster properties.")]}return []}function ri(t,e){const r=new Set(["zoom","feature-state","pitch","distance-from-center"]);for(const t of e.valueSpec.expression.parameters)r.delete(t);if(0===r.size)return [];const n=[];return t instanceof cr&&r.has(t.name)?[new be(e.key,e.value,`["${t.name}"] expression is not supported in a filter for a ${e.object.type} layer with id: ${e.object.id}`)]:(t.eachChild((t=>{n.push(...ri(t,e));})),n)}function ni(t){const e=t.key,r=t.value,n=t.valueSpec,i=[];return Array.isArray(n.values)?-1===n.values.indexOf(Ae(r))&&i.push(new be(e,r,`expected one of [${n.values.join(", ")}], ${JSON.stringify(r)} found`)):-1===Object.keys(n.values).indexOf(Ae(r))&&i.push(new be(e,r,`expected one of [${Object.keys(n.values).join(", ")}], ${JSON.stringify(r)} found`)),i}function ii(t){if(!0===t||!1===t)return !0;if(!Array.isArray(t)||0===t.length)return !1;switch(t[0]){case"has":return t.length>=2&&"$id"!==t[1]&&"$type"!==t[1];case"in":return t.length>=3&&("string"!=typeof t[1]||Array.isArray(t[2]));case"!in":case"!has":case"none":return !1;case"==":case"!=":case">":case">=":case"<":case"<=":return 3!==t.length||Array.isArray(t[1])||Array.isArray(t[2]);case"any":case"all":for(const e of t.slice(1))if(!ii(e)&&"boolean"!=typeof e)return !1;return !0;default:return !0}}function si(t,e="fill"){if(null==t)return {filter:()=>!0,needGeometry:!1,needFeature:!1};ii(t)||(t=pi(t));const r=t;let n=!0;try{n=function(t){if(!li(t))return t;let e=ke(t);return oi(e),e=ai(e),e}(r);}catch(t){console.warn(`Failed to extract static filter. Filter will continue working, but at higher memory usage and slower framerate.\nThis is most likely a bug, please report this via https://github.com/mapbox/mapbox-gl-js/issues/new?assignees=&labels=&template=Bug_report.md\nand paste the contents of this message in the report.\nThank you!\nFilter Expression:\n${JSON.stringify(r,null,2)}\n        `);}const i=ve[`filter_${e}`],s=Gn(n,i);let a=null;if("error"===s.result)throw new Error(s.value.map((t=>`${t.key}: ${t.message}`)).join(", "));a=(t,e,r)=>s.value.evaluate(t,e,{},r);let o=null,l=null;if(n!==r){const t=Gn(r,i);if("error"===t.result)throw new Error(t.value.map((t=>`${t.key}: ${t.message}`)).join(", "));o=(e,r,n,i,s)=>t.value.evaluate(e,r,{},n,void 0,void 0,i,s),l=!Tr(t.value.expression);}return a=a,{filter:a,dynamicFilter:o||void 0,needGeometry:hi(n),needFeature:!!l}}function ai(t){if(!Array.isArray(t))return t;const e=function(t){if(ui.has(t[0]))for(let e=1;e<t.length;e++)if(li(t[e]))return !0;return t}(t);return !0===e?e:e.map((t=>ai(t)))}function oi(t){let e=!1;const r=[];if("case"===t[0]){for(let n=1;n<t.length-1;n+=2)e=e||li(t[n]),r.push(t[n+1]);r.push(t[t.length-1]);}else if("match"===t[0]){e=e||li(t[1]);for(let e=2;e<t.length-1;e+=2)r.push(t[e+1]);r.push(t[t.length-1]);}else if("step"===t[0]){e=e||li(t[1]);for(let e=1;e<t.length-1;e+=2)r.push(t[e+1]);}e&&(t.length=0,t.push("any",...r));for(let e=1;e<t.length;e++)oi(t[e]);}function li(t){if(!Array.isArray(t))return !1;if("pitch"===(e=t[0])||"distance-from-center"===e)return !0;var e;for(let e=1;e<t.length;e++)if(li(t[e]))return !0;return !1}const ui=new Set(["in","==","!=",">",">=","<","<=","to-boolean"]);function ci(t,e){return t<e?-1:t>e?1:0}function hi(t){if(!Array.isArray(t))return !1;if("within"===t[0])return !0;for(let e=1;e<t.length;e++)if(hi(t[e]))return !0;return !1}function pi(t){if(!t)return !0;const e=t[0];return t.length<=1?"any"!==e:"=="===e?di(t[1],t[2],"=="):"!="===e?mi(di(t[1],t[2],"==")):"<"===e||">"===e||"<="===e||">="===e?di(t[1],t[2],e):"any"===e?(r=t.slice(1),["any"].concat(r.map(pi))):"all"===e?["all"].concat(t.slice(1).map(pi)):"none"===e?["all"].concat(t.slice(1).map(pi).map(mi)):"in"===e?fi(t[1],t.slice(2)):"!in"===e?mi(fi(t[1],t.slice(2))):"has"===e?yi(t[1]):"!has"===e?mi(yi(t[1])):"within"!==e||t;var r;}function di(t,e,r){switch(t){case"$type":return [`filter-type-${r}`,e];case"$id":return [`filter-id-${r}`,e];default:return [`filter-${r}`,t,e]}}function fi(t,e){if(0===e.length)return !1;switch(t){case"$type":return ["filter-type-in",["literal",e]];case"$id":return ["filter-id-in",["literal",e]];default:return e.length>200&&!e.some((t=>typeof t!=typeof e[0]))?["filter-in-large",t,["literal",e.sort(ci)]]:["filter-in-small",t,["literal",e]]}}function yi(t){switch(t){case"$type":return !0;case"$id":return ["filter-has-id"];default:return ["filter-has",t]}}function mi(t){return ["!",t]}function gi(t){if(ii(ke(t.value))){const e=ke(t.layerType);return ei(_e({},t,{expressionContext:"filter",valueSpec:t.styleSpec[`filter_${e||"fill"}`]}))}return xi(t)}function xi(t){const e=t.value,r=t.key;if("array"!==Dn(e))return [new be(r,e,`array expected, ${Dn(e)} found`)];const n=t.styleSpec;let i,s=[];if(e.length<1)return [new be(r,e,"filter array must have at least 1 element")];switch(s=s.concat(ni({key:`${r}[0]`,value:e[0],valueSpec:n.filter_operator,style:t.style,styleSpec:t.styleSpec})),Ae(e[0])){case"<":case"<=":case">":case">=":e.length>=2&&"$type"===Ae(e[1])&&s.push(new be(r,e,`"$type" cannot be use with operator "${e[0]}"`));case"==":case"!=":3!==e.length&&s.push(new be(r,e,`filter array for operator "${e[0]}" must have 3 elements`));case"in":case"!in":e.length>=2&&(i=Dn(e[1]),"string"!==i&&s.push(new be(`${r}[1]`,e[1],`string expected, ${i} found`)));for(let a=2;a<e.length;a++)i=Dn(e[a]),"$type"===Ae(e[1])?s=s.concat(ni({key:`${r}[${a}]`,value:e[a],valueSpec:n.geometry_type,style:t.style,styleSpec:t.styleSpec})):"string"!==i&&"number"!==i&&"boolean"!==i&&s.push(new be(`${r}[${a}]`,e[a],`string, number, or boolean expected, ${i} found`));break;case"any":case"all":case"none":for(let n=1;n<e.length;n++)s=s.concat(xi({key:`${r}[${n}]`,value:e[n],style:t.style,styleSpec:t.styleSpec}));break;case"has":case"!has":i=Dn(e[1]),2!==e.length?s.push(new be(r,e,`filter array for "${e[0]}" operator must have 2 elements`)):"string"!==i&&s.push(new be(`${r}[1]`,e[1],`string expected, ${i} found`));break;case"within":i=Dn(e[1]),2!==e.length?s.push(new be(r,e,`filter array for "${e[0]}" operator must have 2 elements`)):"object"!==i&&s.push(new be(`${r}[1]`,e[1],`object expected, ${i} found`));}return s}function vi(t,e){const r=t.key,n=t.style,i=t.styleSpec,s=t.value,a=t.objectKey,o=i[`${e}_${t.layerType}`];if(!o)return [];const l=a.match(/^(.*)-transition$/);if("paint"===e&&l&&o[l[1]]&&o[l[1]].transition)return Bi({key:r,value:s,valueSpec:i.transition,style:n,styleSpec:i});const u=t.valueSpec||o[a];if(!u)return [new be(r,s,`unknown property "${a}"`)];let c;if("string"===Dn(s)&&Cn(u)&&!u.tokens&&(c=/^{([^}]+)}$/.exec(s)))return [new be(r,s,`"${a}" does not support interpolation syntax\nUse an identity property function instead: \`{ "type": "identity", "property": ${JSON.stringify(c[1])} }\`.`)];const h=[];return "symbol"===t.layerType&&("text-field"===a&&n&&!n.glyphs&&h.push(new be(r,s,'use of "text-field" requires a style "glyphs" property')),"text-font"===a&&Vn(ke(s))&&"identity"===Ae(s.type)&&h.push(new be(r,s,'"text-font" does not support identity functions'))),h.concat(Bi({key:t.key,value:s,valueSpec:u,style:n,styleSpec:i,expressionContext:"property",propertyType:e,propertyKey:a}))}function bi(t){return vi(t,"paint")}function wi(t){return vi(t,"layout")}function _i(t){let e=[];const r=t.value,n=t.key,i=t.style,s=t.styleSpec;r.type||r.ref||e.push(new be(n,r,'either "type" or "ref" is required'));let a=Ae(r.type);const o=Ae(r.ref);if(r.id){const s=Ae(r.id);for(let a=0;a<t.arrayIndex;a++){const t=i.layers[a];Ae(t.id)===s&&e.push(new be(n,r.id,`duplicate layer id "${r.id}", previously used at line ${t.id.__line__}`));}}if("ref"in r){let t;["type","source","source-layer","filter","layout"].forEach((t=>{t in r&&e.push(new be(n,r[t],`"${t}" is prohibited for ref layers`));})),i.layers.forEach((e=>{Ae(e.id)===o&&(t=e);})),t?t.ref?e.push(new be(n,r.ref,"ref cannot reference another ref layer")):a=Ae(t.type):e.push(new be(n,r.ref,`ref layer "${o}" not found`));}else if("background"!==a&&"sky"!==a)if(r.source){const t=i.sources&&i.sources[r.source],s=t&&Ae(t.type);t?"vector"===s&&"raster"===a?e.push(new be(n,r.source,`layer "${r.id}" requires a raster source`)):"raster"===s&&"raster"!==a?e.push(new be(n,r.source,`layer "${r.id}" requires a vector source`)):"vector"!==s||r["source-layer"]?"raster-dem"===s&&"hillshade"!==a?e.push(new be(n,r.source,"raster-dem source can only be used with layer type 'hillshade'.")):"line"!==a||!r.paint||!r.paint["line-gradient"]||"geojson"===s&&t.lineMetrics||e.push(new be(n,r,`layer "${r.id}" specifies a line-gradient, which requires a GeoJSON source with \`lineMetrics\` enabled.`)):e.push(new be(n,r,`layer "${r.id}" must specify a "source-layer"`)):e.push(new be(n,r.source,`source "${r.source}" not found`));}else e.push(new be(n,r,'missing required property "source"'));return e=e.concat(Jn({key:n,value:r,valueSpec:s.layer,style:t.style,styleSpec:t.styleSpec,objectElementValidators:{"*":()=>[],type:()=>Bi({key:`${n}.type`,value:r.type,valueSpec:s.layer.type,style:t.style,styleSpec:t.styleSpec,object:r,objectKey:"type"}),filter:t=>gi(_e({layerType:a},t)),layout:t=>Jn({layer:r,key:t.key,value:t.value,style:t.style,styleSpec:t.styleSpec,objectElementValidators:{"*":t=>wi(_e({layerType:a},t))}}),paint:t=>Jn({layer:r,key:t.key,value:t.value,style:t.style,styleSpec:t.styleSpec,objectElementValidators:{"*":t=>bi(_e({layerType:a},t))}})}})),e}function Ai(t){const e=t.value,r=t.key,n=Dn(e);return "string"!==n?[new be(r,e,`string expected, ${n} found`)]:[]}const ki={promoteId:function({key:t,value:e}){if("string"===Dn(e))return Ai({key:t,value:e});{const r=[];for(const n in e)r.push(...Ai({key:`${t}.${n}`,value:e[n]}));return r}}};function Si(t){const e=t.value,r=t.key,n=t.styleSpec,i=t.style;if(!e.type)return [new be(r,e,'"type" is required')];const s=Ae(e.type);let a;switch(s){case"vector":case"raster":case"raster-dem":return a=Jn({key:r,value:e,valueSpec:n[`source_${s.replace("-","_")}`],style:t.style,styleSpec:n,objectElementValidators:ki}),a;case"geojson":if(a=Jn({key:r,value:e,valueSpec:n.source_geojson,style:i,styleSpec:n,objectElementValidators:ki}),e.cluster)for(const t in e.clusterProperties){const[n,i]=e.clusterProperties[t],s="string"==typeof n?[n,["accumulated"],["get",t]]:n;a.push(...ei({key:`${r}.${t}.map`,value:i,expressionContext:"cluster-map"})),a.push(...ei({key:`${r}.${t}.reduce`,value:s,expressionContext:"cluster-reduce"}));}return a;case"video":return Jn({key:r,value:e,valueSpec:n.source_video,style:i,styleSpec:n});case"image":return Jn({key:r,value:e,valueSpec:n.source_image,style:i,styleSpec:n});case"canvas":return [new be(r,null,"Please use runtime APIs to add canvas sources, rather than including them in stylesheets.","source.canvas")];default:return ni({key:`${r}.type`,value:e.type,valueSpec:{values:["vector","raster","raster-dem","geojson","video","image"]},style:i,styleSpec:n})}}function Ii(t){const e=t.value,r=t.styleSpec,n=r.light,i=t.style;let s=[];const a=Dn(e);if(void 0===e)return s;if("object"!==a)return s=s.concat([new be("light",e,`object expected, ${a} found`)]),s;for(const t in e){const a=t.match(/^(.*)-transition$/);s=s.concat(a&&n[a[1]]&&n[a[1]].transition?Bi({key:t,value:e[t],valueSpec:r.transition,style:i,styleSpec:r}):n[t]?Bi({key:t,value:e[t],valueSpec:n[t],style:i,styleSpec:r}):[new be(t,e[t],`unknown property "${t}"`)]);}return s}function zi(t){const e=t.value,r=t.key,n=t.style,i=t.styleSpec,s=i.terrain;let a=[];const o=Dn(e);if(void 0===e)return a;if("object"!==o)return a=a.concat([new be("terrain",e,`object expected, ${o} found`)]),a;for(const t in e){const r=t.match(/^(.*)-transition$/);a=a.concat(r&&s[r[1]]&&s[r[1]].transition?Bi({key:t,value:e[t],valueSpec:i.transition,style:n,styleSpec:i}):s[t]?Bi({key:t,value:e[t],valueSpec:s[t],style:n,styleSpec:i}):[new be(t,e[t],`unknown property "${t}"`)]);}if(e.source){const t=n.sources&&n.sources[e.source],i=t&&Ae(t.type);t?"raster-dem"!==i&&a.push(new be(r,e.source,`terrain cannot be used with a source of type ${i}, it only be used with a "raster-dem" source type`)):a.push(new be(r,e.source,`source "${e.source}" not found`));}else a.push(new be(r,e,'terrain is missing required property "source"'));return a}function Mi(t){const e=t.value,r=t.style,n=t.styleSpec,i=n.fog;let s=[];const a=Dn(e);if(void 0===e)return s;if("object"!==a)return s=s.concat([new be("fog",e,`object expected, ${a} found`)]),s;for(const t in e){const a=t.match(/^(.*)-transition$/);s=s.concat(a&&i[a[1]]&&i[a[1]].transition?Bi({key:t,value:e[t],valueSpec:n.transition,style:r,styleSpec:n}):i[t]?Bi({key:t,value:e[t],valueSpec:i[t],style:r,styleSpec:n}):[new be(t,e[t],`unknown property "${t}"`)]);}return s}const Ti={"*":()=>[],array:Wn,boolean:function(t){const e=t.value,r=t.key,n=Dn(e);return "boolean"!==n?[new be(r,e,`boolean expected, ${n} found`)]:[]},number:Qn,color:function(t){const e=t.key,r=t.value,n=Dn(r);return "string"!==n?[new be(e,r,`color expected, ${n} found`)]:null===Ne.parseCSSColor(r)?[new be(e,r,`color expected, "${r}" found`)]:[]},constants:we,enum:ni,filter:gi,function:ti,layer:_i,object:Jn,source:Si,light:Ii,terrain:zi,fog:Mi,string:Ai,formatted:function(t){return 0===Ai(t).length?[]:ei(t)},resolvedImage:function(t){return 0===Ai(t).length?[]:ei(t)},projection:function(t){const e=t.value,r=t.styleSpec,n=r.projection,i=t.style;let s=[];const a=Dn(e);if("object"===a)for(const t in e)s=s.concat(Bi({key:t,value:e[t],valueSpec:n[t],style:i,styleSpec:r}));else "string"!==a&&(s=s.concat([new be("projection",e,`object or string expected, ${a} found`)]));return s}};function Bi(t){const e=t.value,r=t.valueSpec,n=t.styleSpec;return r.expression&&Vn(Ae(e))?ti(t):r.expression&&Nn(ke(e))?ei(t):r.type&&Ti[r.type]?Ti[r.type](t):Jn(_e({},t,{valueSpec:r.type?n[r.type]:r}))}function Ci(t){const e=t.value,r=t.key,n=Ai(t);return n.length||(-1===e.indexOf("{fontstack}")&&n.push(new be(r,e,'"glyphs" url must include a "{fontstack}" token')),-1===e.indexOf("{range}")&&n.push(new be(r,e,'"glyphs" url must include a "{range}" token'))),n}function Pi(t,e=ve){let r=[];return r=r.concat(Bi({key:"",value:t,valueSpec:e.$root,styleSpec:e,style:t,objectElementValidators:{glyphs:Ci,"*":()=>[]}})),t.constants&&(r=r.concat(we({key:"constants",value:t.constants,style:t,styleSpec:e}))),Ei(r)}function Ei(t){return [].concat(t).sort(((t,e)=>t.line-e.line))}function Di(t){return function(...e){return Ei(t.apply(this,e))}}Pi.source=Di(Si),Pi.light=Di(Ii),Pi.terrain=Di(zi),Pi.fog=Di(Mi),Pi.layer=Di(_i),Pi.filter=Di(gi),Pi.paintProperty=Di(bi),Pi.layoutProperty=Di(wi);const Vi=Pi,Fi=Vi.light,Li=Vi.fog,Ri=Vi.paintProperty,Ui=Vi.layoutProperty;function $i(t,e){let r=!1;if(e&&e.length)for(const n of e)t.fire(new ge(new Error(n.message))),r=!0;return r}var Oi=ji;function ji(t,e,r){var n=this.cells=[];if(t instanceof ArrayBuffer){this.arrayBuffer=t;var i=new Int32Array(this.arrayBuffer);t=i[0],this.d=(e=i[1])+2*(r=i[2]);for(var s=0;s<this.d*this.d;s++){var a=i[3+s],o=i[3+s+1];n.push(a===o?null:i.subarray(a,o));}var l=i[3+n.length+1];this.keys=i.subarray(i[3+n.length],l),this.bboxes=i.subarray(l),this.insert=this._insertReadonly;}else {this.d=e+2*r;for(var u=0;u<this.d*this.d;u++)n.push([]);this.keys=[],this.bboxes=[];}this.n=e,this.extent=t,this.padding=r,this.scale=e/t,this.uid=0;var c=r/e*t;this.min=-c,this.max=t+c;}ji.prototype.insert=function(t,e,r,n,i){this._forEachCell(e,r,n,i,this._insertCell,this.uid++),this.keys.push(t),this.bboxes.push(e),this.bboxes.push(r),this.bboxes.push(n),this.bboxes.push(i);},ji.prototype._insertReadonly=function(){throw "Cannot insert into a GridIndex created from an ArrayBuffer."},ji.prototype._insertCell=function(t,e,r,n,i,s){this.cells[i].push(s);},ji.prototype.query=function(t,e,r,n,i){var s=this.min,a=this.max;if(t<=s&&e<=s&&a<=r&&a<=n&&!i)return Array.prototype.slice.call(this.keys);var o=[];return this._forEachCell(t,e,r,n,this._queryCell,o,{},i),o},ji.prototype._queryCell=function(t,e,r,n,i,s,a,o){var l=this.cells[i];if(null!==l)for(var u=this.keys,c=this.bboxes,h=0;h<l.length;h++){var p=l[h];if(void 0===a[p]){var d=4*p;(o?o(c[d+0],c[d+1],c[d+2],c[d+3]):t<=c[d+2]&&e<=c[d+3]&&r>=c[d+0]&&n>=c[d+1])?(a[p]=!0,s.push(u[p])):a[p]=!1;}}},ji.prototype._forEachCell=function(t,e,r,n,i,s,a,o){for(var l=this._convertToCellCoord(t),u=this._convertToCellCoord(e),c=this._convertToCellCoord(r),h=this._convertToCellCoord(n),p=l;p<=c;p++)for(var d=u;d<=h;d++){var f=this.d*d+p;if((!o||o(this._convertFromCellCoord(p),this._convertFromCellCoord(d),this._convertFromCellCoord(p+1),this._convertFromCellCoord(d+1)))&&i.call(this,t,e,r,n,f,s,a,o))return}},ji.prototype._convertFromCellCoord=function(t){return (t-this.padding)/this.scale},ji.prototype._convertToCellCoord=function(t){return Math.max(0,Math.min(this.d-1,Math.floor(t*this.scale)+this.padding))},ji.prototype.toArrayBuffer=function(){if(this.arrayBuffer)return this.arrayBuffer;for(var t=this.cells,e=3+this.cells.length+1+1,r=0,n=0;n<this.cells.length;n++)r+=this.cells[n].length;var i=new Int32Array(e+r+this.keys.length+this.bboxes.length);i[0]=this.extent,i[1]=this.n,i[2]=this.padding;for(var s=e,a=0;a<t.length;a++){var o=t[a];i[3+a]=s,i.set(o,s),s+=o.length;}return i[3+t.length]=s,i.set(this.keys,s),i[3+t.length+1]=s+=this.keys.length,i.set(this.bboxes,s),s+=this.bboxes.length,i.buffer};const{ImageData:qi,ImageBitmap:Ni}=a,Gi={};function Zi(t,e,r={}){Object.defineProperty(e,"_classRegistryKey",{value:t,writeable:!1}),Gi[t]={klass:e,omit:r.omit||[],shallow:r.shallow||[]};}Zi("Object",Object),Oi.serialize=function(t,e){const r=t.toArrayBuffer();return e&&e.push(r),{buffer:r}},Oi.deserialize=function(t){return new Oi(t.buffer)},Zi("Grid",Oi),Zi("Color",Ge),Zi("Error",Error),Zi("ResolvedImage",Ye),Zi("StylePropertyFunction",Yn),Zi("StyleExpression",qn,{omit:["_evaluator"]}),Zi("ZoomDependentExpression",Xn),Zi("ZoomConstantExpression",Zn),Zi("CompoundExpression",cr,{omit:["_evaluate"]});for(const t in kn)kn[t]._classRegistryKey||Zi(`Expression_${t}`,kn[t]);function Xi(t){return t&&"undefined"!=typeof ArrayBuffer&&(t instanceof ArrayBuffer||t.constructor&&"ArrayBuffer"===t.constructor.name)}function Ki(t){return Ni&&t instanceof Ni}function Yi(t,e){if(null==t||"boolean"==typeof t||"number"==typeof t||"string"==typeof t||t instanceof Boolean||t instanceof Number||t instanceof String||t instanceof Date||t instanceof RegExp)return t;if(Xi(t)||Ki(t))return e&&e.push(t),t;if(ArrayBuffer.isView(t)){const r=t;return e&&e.push(r.buffer),r}if(t instanceof qi)return e&&e.push(t.data.buffer),t;if(Array.isArray(t)){const r=[];for(const n of t)r.push(Yi(n,e));return r}if("object"==typeof t){const r=t.constructor,n=r._classRegistryKey;if(!n)throw new Error("can't serialize object of unregistered class");const i=r.serialize?r.serialize(t,e):{};if(!r.serialize){for(const r in t){if(!t.hasOwnProperty(r))continue;if(Gi[n].omit.indexOf(r)>=0)continue;const s=t[r];i[r]=Gi[n].shallow.indexOf(r)>=0?s:Yi(s,e);}t instanceof Error&&(i.message=t.message);}if(i.$name)throw new Error("$name property is reserved for worker serialization logic.");return "Object"!==n&&(i.$name=n),i}throw new Error("can't serialize object of type "+typeof t)}function Hi(t){if(null==t||"boolean"==typeof t||"number"==typeof t||"string"==typeof t||t instanceof Boolean||t instanceof Number||t instanceof String||t instanceof Date||t instanceof RegExp||Xi(t)||Ki(t)||ArrayBuffer.isView(t)||t instanceof qi)return t;if(Array.isArray(t))return t.map(Hi);if("object"==typeof t){const e=t.$name||"Object",{klass:r}=Gi[e];if(!r)throw new Error(`can't deserialize unregistered class ${e}`);if(r.deserialize)return r.deserialize(t);const n=Object.create(r.prototype);for(const r of Object.keys(t)){if("$name"===r)continue;const i=t[r];n[r]=Gi[e].shallow.indexOf(r)>=0?i:Hi(i);}return n}throw new Error("can't deserialize object of type "+typeof t)}class Ji{constructor(){this.first=!0;}update(t,e){const r=Math.floor(t);return this.first?(this.first=!1,this.lastIntegerZoom=r,this.lastIntegerZoomTime=0,this.lastZoom=t,this.lastFloorZoom=r,!0):(this.lastFloorZoom>r?(this.lastIntegerZoom=r+1,this.lastIntegerZoomTime=e):this.lastFloorZoom<r&&(this.lastIntegerZoom=r,this.lastIntegerZoomTime=e),t!==this.lastZoom&&(this.lastZoom=t,this.lastFloorZoom=r,!0))}}const Wi=t=>t>=1536&&t<=1791,Qi=t=>t>=1872&&t<=1919,ts=t=>t>=2208&&t<=2303,es=t=>t>=11904&&t<=12031,rs=t=>t>=12032&&t<=12255,ns=t=>t>=12272&&t<=12287,is=t=>t>=12288&&t<=12351,ss=t=>t>=12352&&t<=12447,as=t=>t>=12448&&t<=12543,os=t=>t>=12544&&t<=12591,ls=t=>t>=12704&&t<=12735,us=t=>t>=12736&&t<=12783,cs=t=>t>=12784&&t<=12799,hs=t=>t>=12800&&t<=13055,ps=t=>t>=13056&&t<=13311,ds=t=>t>=13312&&t<=19903,fs=t=>t>=19968&&t<=40959,ys=t=>t>=40960&&t<=42127,ms=t=>t>=42128&&t<=42191,gs=t=>t>=44032&&t<=55215,xs=t=>t>=63744&&t<=64255,vs=t=>t>=64336&&t<=65023,bs=t=>t>=65040&&t<=65055,ws=t=>t>=65072&&t<=65103,_s=t=>t>=65104&&t<=65135,As=t=>t>=65136&&t<=65279,ks=t=>t>=65280&&t<=65519;function Ss(t){for(const e of t)if(Ms(e.charCodeAt(0)))return !0;return !1}function Is(t){for(const e of t)if(!zs(e.charCodeAt(0)))return !1;return !0}function zs(t){return !(Wi(t)||Qi(t)||ts(t)||vs(t)||As(t))}function Ms(t){return !(746!==t&&747!==t&&(t<4352||!(ls(t)||os(t)||ws(t)&&!(t>=65097&&t<=65103)||xs(t)||ps(t)||es(t)||us(t)||!(!is(t)||t>=12296&&t<=12305||t>=12308&&t<=12319||12336===t)||ds(t)||fs(t)||hs(t)||(t=>t>=12592&&t<=12687)(t)||(t=>t>=43360&&t<=43391)(t)||(t=>t>=55216&&t<=55295)(t)||(t=>t>=4352&&t<=4607)(t)||gs(t)||ss(t)||ns(t)||(t=>t>=12688&&t<=12703)(t)||rs(t)||cs(t)||as(t)&&12540!==t||!(!ks(t)||65288===t||65289===t||65293===t||t>=65306&&t<=65310||65339===t||65341===t||65343===t||t>=65371&&t<=65503||65507===t||t>=65512&&t<=65519)||!(!_s(t)||t>=65112&&t<=65118||t>=65123&&t<=65126)||(t=>t>=5120&&t<=5759)(t)||(t=>t>=6320&&t<=6399)(t)||bs(t)||(t=>t>=19904&&t<=19967)(t)||ys(t)||ms(t))))}function Ts(t){return !(Ms(t)||function(t){return !!((t=>t>=128&&t<=255)(t)&&(167===t||169===t||174===t||177===t||188===t||189===t||190===t||215===t||247===t)||(t=>t>=8192&&t<=8303)(t)&&(8214===t||8224===t||8225===t||8240===t||8241===t||8251===t||8252===t||8258===t||8263===t||8264===t||8265===t||8273===t)||(t=>t>=8448&&t<=8527)(t)||(t=>t>=8528&&t<=8591)(t)||(t=>t>=8960&&t<=9215)(t)&&(t>=8960&&t<=8967||t>=8972&&t<=8991||t>=8996&&t<=9e3||9003===t||t>=9085&&t<=9114||t>=9150&&t<=9165||9167===t||t>=9169&&t<=9179||t>=9186&&t<=9215)||(t=>t>=9216&&t<=9279)(t)&&9251!==t||(t=>t>=9280&&t<=9311)(t)||(t=>t>=9312&&t<=9471)(t)||(t=>t>=9632&&t<=9727)(t)||(t=>t>=9728&&t<=9983)(t)&&!(t>=9754&&t<=9759)||(t=>t>=11008&&t<=11263)(t)&&(t>=11026&&t<=11055||t>=11088&&t<=11097||t>=11192&&t<=11243)||is(t)||as(t)||(t=>t>=57344&&t<=63743)(t)||ws(t)||_s(t)||ks(t)||8734===t||8756===t||8757===t||t>=9984&&t<=10087||t>=10102&&t<=10131||65532===t||65533===t)}(t))}function Bs(t){return t>=1424&&t<=2303||vs(t)||As(t)}function Cs(t,e){return !(!e&&Bs(t)||t>=2304&&t<=3583||t>=3840&&t<=4255||(t=>t>=6016&&t<=6143)(t))}function Ps(t){for(const e of t)if(Bs(e.charCodeAt(0)))return !0;return !1}const Es="deferred",Ds="loading",Vs="loaded";let Fs=null,Ls="unavailable",Rs=null;const Us=function(t){t&&"string"==typeof t&&t.indexOf("NetworkError")>-1&&(Ls="error"),Fs&&Fs(t);};function $s(){Os.fire(new me("pluginStateChange",{pluginStatus:Ls,pluginURL:Rs}));}const Os=new xe,js=function(){return Ls},qs=function(){if(Ls!==Es||!Rs)throw new Error("rtl-text-plugin cannot be downloaded unless a pluginURL is specified");Ls=Ds,$s(),Rs&&ae({url:Rs},(t=>{t?Us(t):(Ls=Vs,$s());}));},Ns={applyArabicShaping:null,processBidirectionalText:null,processStyledBidirectionalText:null,isLoaded:()=>Ls===Vs||null!=Ns.applyArabicShaping,isLoading:()=>Ls===Ds,setState(t){Ls=t.pluginStatus,Rs=t.pluginURL;},isParsed:()=>null!=Ns.applyArabicShaping&&null!=Ns.processBidirectionalText&&null!=Ns.processStyledBidirectionalText,getPluginURL:()=>Rs};class Gs{constructor(t,e){this.zoom=t,e?(this.now=e.now,this.fadeDuration=e.fadeDuration,this.zoomHistory=e.zoomHistory,this.transition=e.transition,this.pitch=e.pitch):(this.now=0,this.fadeDuration=0,this.zoomHistory=new Ji,this.transition={},this.pitch=0);}isSupportedScript(t){return function(t,e){for(const r of t)if(!Cs(r.charCodeAt(0),e))return !1;return !0}(t,Ns.isLoaded())}crossFadingFactor(){return 0===this.fadeDuration?1:Math.min((this.now-this.zoomHistory.lastIntegerZoomTime)/this.fadeDuration,1)}getCrossfadeParameters(){const t=this.zoom,e=t-Math.floor(t),r=this.crossFadingFactor();return t>this.zoomHistory.lastIntegerZoom?{fromScale:2,toScale:1,t:e+(1-e)*r}:{fromScale:.5,toScale:1,t:1-(1-r)*e}}}class Zs{constructor(t,e){this.property=t,this.value=e,this.expression=function(t,e){if(Vn(t))return new Yn(t,e);if(Nn(t)){const r=Kn(t,e);if("error"===r.result)throw new Error(r.value.map((t=>`${t.key}: ${t.message}`)).join(", "));return r.value}{let r=t;return "string"==typeof t&&"color"===e.type&&(r=Ge.parse(t)),{kind:"constant",evaluate:()=>r}}}(void 0===e?t.specification.default:e,t.specification);}isDataDriven(){return "source"===this.expression.kind||"composite"===this.expression.kind}possiblyEvaluate(t,e,r){return this.property.possiblyEvaluate(this,t,e,r)}}class Xs{constructor(t){this.property=t,this.value=new Zs(t,void 0);}transitioned(t,e){return new Ys(this.property,this.value,e,tt({},t.transition,this.transition),t.now)}untransitioned(){return new Ys(this.property,this.value,null,{},0)}}class Ks{constructor(t){this._properties=t,this._values=Object.create(t.defaultTransitionablePropertyValues);}getValue(t){return ct(this._values[t].value.value)}setValue(t,e){this._values.hasOwnProperty(t)||(this._values[t]=new Xs(this._values[t].property)),this._values[t].value=new Zs(this._values[t].property,null===e?void 0:ct(e));}getTransition(t){return ct(this._values[t].transition)}setTransition(t,e){this._values.hasOwnProperty(t)||(this._values[t]=new Xs(this._values[t].property)),this._values[t].transition=ct(e)||void 0;}serialize(){const t={};for(const e of Object.keys(this._values)){const r=this.getValue(e);void 0!==r&&(t[e]=r);const n=this.getTransition(e);void 0!==n&&(t[`${e}-transition`]=n);}return t}transitioned(t,e){const r=new Hs(this._properties);for(const n of Object.keys(this._values))r._values[n]=this._values[n].transitioned(t,e._values[n]);return r}untransitioned(){const t=new Hs(this._properties);for(const e of Object.keys(this._values))t._values[e]=this._values[e].untransitioned();return t}}class Ys{constructor(t,e,r,n,i){const s=n.delay||0,a=n.duration||0;i=i||0,this.property=t,this.value=e,this.begin=i+s,this.end=this.begin+a,t.specification.transition&&(n.delay||n.duration)&&(this.prior=r);}possiblyEvaluate(t,e,r){const n=t.now||0,i=this.value.possiblyEvaluate(t,e,r),s=this.prior;if(s){if(n>this.end)return this.prior=null,i;if(this.value.isDataDriven())return this.prior=null,i;if(n<this.begin)return s.possiblyEvaluate(t,e,r);{const a=(n-this.begin)/(this.end-this.begin);return this.property.interpolate(s.possiblyEvaluate(t,e,r),i,Z(a))}}return i}}class Hs{constructor(t){this._properties=t,this._values=Object.create(t.defaultTransitioningPropertyValues);}possiblyEvaluate(t,e,r){const n=new Qs(this._properties);for(const i of Object.keys(this._values))n._values[i]=this._values[i].possiblyEvaluate(t,e,r);return n}hasTransition(){for(const t of Object.keys(this._values))if(this._values[t].prior)return !0;return !1}}class Js{constructor(t){this._properties=t,this._values=Object.create(t.defaultPropertyValues);}getValue(t){return ct(this._values[t].value)}setValue(t,e){this._values[t]=new Zs(this._values[t].property,null===e?void 0:ct(e));}serialize(){const t={};for(const e of Object.keys(this._values)){const r=this.getValue(e);void 0!==r&&(t[e]=r);}return t}possiblyEvaluate(t,e,r){const n=new Qs(this._properties);for(const i of Object.keys(this._values))n._values[i]=this._values[i].possiblyEvaluate(t,e,r);return n}}class Ws{constructor(t,e,r){this.property=t,this.value=e,this.parameters=r;}isConstant(){return "constant"===this.value.kind}constantOr(t){return "constant"===this.value.kind?this.value.value:t}evaluate(t,e,r,n){return this.property.evaluate(this.value,this.parameters,t,e,r,n)}}class Qs{constructor(t){this._properties=t,this._values=Object.create(t.defaultPossiblyEvaluatedValues);}get(t){return this._values[t]}}class ta{constructor(t){this.specification=t;}possiblyEvaluate(t,e){return t.expression.evaluate(e)}interpolate(t,e,r){const n=Rr[this.specification.type];return n?n(t,e,r):t}}class ea{constructor(t,e){this.specification=t,this.overrides=e;}possiblyEvaluate(t,e,r,n){return new Ws(this,"constant"===t.expression.kind||"camera"===t.expression.kind?{kind:"constant",value:t.expression.evaluate(e,null,{},r,n)}:t.expression,e)}interpolate(t,e,r){if("constant"!==t.value.kind||"constant"!==e.value.kind)return t;if(void 0===t.value.value||void 0===e.value.value)return new Ws(this,{kind:"constant",value:void 0},t.parameters);const n=Rr[this.specification.type];return n?new Ws(this,{kind:"constant",value:n(t.value.value,e.value.value,r)},t.parameters):t}evaluate(t,e,r,n,i,s){return "constant"===t.kind?t.value:t.evaluate(e,r,n,i,s)}}class ra extends ea{possiblyEvaluate(t,e,r,n){if(void 0===t.value)return new Ws(this,{kind:"constant",value:void 0},e);if("constant"===t.expression.kind){const i=t.expression.evaluate(e,null,{},r,n),s="resolvedImage"===t.property.specification.type&&"string"!=typeof i?i.name:i,a=this._calculate(s,s,s,e);return new Ws(this,{kind:"constant",value:a},e)}if("camera"===t.expression.kind){const r=this._calculate(t.expression.evaluate({zoom:e.zoom-1}),t.expression.evaluate({zoom:e.zoom}),t.expression.evaluate({zoom:e.zoom+1}),e);return new Ws(this,{kind:"constant",value:r},e)}return new Ws(this,t.expression,e)}evaluate(t,e,r,n,i,s){if("source"===t.kind){const a=t.evaluate(e,r,n,i,s);return this._calculate(a,a,a,e)}return "composite"===t.kind?this._calculate(t.evaluate({zoom:Math.floor(e.zoom)-1},r,n),t.evaluate({zoom:Math.floor(e.zoom)},r,n),t.evaluate({zoom:Math.floor(e.zoom)+1},r,n),e):t.value}_calculate(t,e,r,n){return n.zoom>n.zoomHistory.lastIntegerZoom?{from:t,to:e,other:r}:{from:r,to:e,other:t}}interpolate(t){return t}}class na{constructor(t){this.specification=t;}possiblyEvaluate(t,e,r,n){if(void 0!==t.value){if("constant"===t.expression.kind){const i=t.expression.evaluate(e,null,{},r,n);return this._calculate(i,i,i,e)}return this._calculate(t.expression.evaluate(new Gs(Math.floor(e.zoom-1),e)),t.expression.evaluate(new Gs(Math.floor(e.zoom),e)),t.expression.evaluate(new Gs(Math.floor(e.zoom+1),e)),e)}}_calculate(t,e,r,n){return n.zoom>n.zoomHistory.lastIntegerZoom?{from:t,to:e}:{from:r,to:e}}interpolate(t){return t}}class ia{constructor(t){this.specification=t;}possiblyEvaluate(t,e,r,n){return !!t.expression.evaluate(e,null,{},r,n)}interpolate(){return !1}}class sa{constructor(t){this.properties=t,this.defaultPropertyValues={},this.defaultTransitionablePropertyValues={},this.defaultTransitioningPropertyValues={},this.defaultPossiblyEvaluatedValues={},this.overridableProperties=[];for(const e in t){const r=t[e];r.specification.overridable&&this.overridableProperties.push(e);const n=this.defaultPropertyValues[e]=new Zs(r,void 0),i=this.defaultTransitionablePropertyValues[e]=new Xs(r);this.defaultTransitioningPropertyValues[e]=i.untransitioned(),this.defaultPossiblyEvaluatedValues[e]=n.possiblyEvaluate({});}}}function aa(t,e){return 256*(t=Y(Math.floor(t),0,255))+Y(Math.floor(e),0,255)}Zi("DataDrivenProperty",ea),Zi("DataConstantProperty",ta),Zi("CrossFadedDataDrivenProperty",ra),Zi("CrossFadedProperty",na),Zi("ColorRampProperty",ia);const oa={Int8:Int8Array,Uint8:Uint8Array,Int16:Int16Array,Uint16:Uint16Array,Int32:Int32Array,Uint32:Uint32Array,Float32:Float32Array};class la{constructor(t,e){this._structArray=t,this._pos1=e*this.size,this._pos2=this._pos1/2,this._pos4=this._pos1/4,this._pos8=this._pos1/8;}}class ua{constructor(){this.isTransferred=!1,this.capacity=-1,this.resize(0);}static serialize(t,e){return t._trim(),e&&(t.isTransferred=!0,e.push(t.arrayBuffer)),{length:t.length,arrayBuffer:t.arrayBuffer}}static deserialize(t){const e=Object.create(this.prototype);return e.arrayBuffer=t.arrayBuffer,e.length=t.length,e.capacity=t.arrayBuffer.byteLength/e.bytesPerElement,e._refreshViews(),e}_trim(){this.length!==this.capacity&&(this.capacity=this.length,this.arrayBuffer=this.arrayBuffer.slice(0,this.length*this.bytesPerElement),this._refreshViews());}clear(){this.length=0;}resize(t){this.reserve(t),this.length=t;}reserve(t){if(t>this.capacity){this.capacity=Math.max(t,Math.floor(5*this.capacity),128),this.arrayBuffer=new ArrayBuffer(this.capacity*this.bytesPerElement);const e=this.uint8;this._refreshViews(),e&&this.uint8.set(e);}}_refreshViews(){throw new Error("_refreshViews() must be implemented by each concrete StructArray layout")}}function ca(t,e=1){let r=0,n=0;return {members:t.map((t=>{const i=oa[t.type].BYTES_PER_ELEMENT,s=r=ha(r,Math.max(e,i)),a=t.components||1;return n=Math.max(n,i),r+=i*a,{name:t.name,type:t.type,components:a,offset:s}})),size:ha(r,Math.max(n,e)),alignment:e}}function ha(t,e){return Math.ceil(t/e)*e}class pa extends ua{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e){const r=this.length;return this.resize(r+1),this.emplace(r,t,e)}emplace(t,e,r){const n=2*t;return this.int16[n+0]=e,this.int16[n+1]=r,t}}pa.prototype.bytesPerElement=4,Zi("StructArrayLayout2i4",pa);class da extends ua{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n){const i=this.length;return this.resize(i+1),this.emplace(i,t,e,r,n)}emplace(t,e,r,n,i){const s=4*t;return this.int16[s+0]=e,this.int16[s+1]=r,this.int16[s+2]=n,this.int16[s+3]=i,t}}da.prototype.bytesPerElement=8,Zi("StructArrayLayout4i8",da);class fa extends ua{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a){const o=this.length;return this.resize(o+1),this.emplace(o,t,e,r,n,i,s,a)}emplace(t,e,r,n,i,s,a,o){const l=6*t,u=12*t,c=3*t;return this.int16[l+0]=e,this.int16[l+1]=r,this.uint8[u+4]=n,this.uint8[u+5]=i,this.uint8[u+6]=s,this.uint8[u+7]=a,this.float32[c+2]=o,t}}fa.prototype.bytesPerElement=12,Zi("StructArrayLayout2i4ub1f12",fa);class ya extends ua{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=3*t;return this.float32[i+0]=e,this.float32[i+1]=r,this.float32[i+2]=n,t}}ya.prototype.bytesPerElement=12,Zi("StructArrayLayout3f12",ya);class ma extends ua{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a,o,l,u){const c=this.length;return this.resize(c+1),this.emplace(c,t,e,r,n,i,s,a,o,l,u)}emplace(t,e,r,n,i,s,a,o,l,u,c){const h=10*t;return this.uint16[h+0]=e,this.uint16[h+1]=r,this.uint16[h+2]=n,this.uint16[h+3]=i,this.uint16[h+4]=s,this.uint16[h+5]=a,this.uint16[h+6]=o,this.uint16[h+7]=l,this.uint16[h+8]=u,this.uint16[h+9]=c,t}}ma.prototype.bytesPerElement=20,Zi("StructArrayLayout10ui20",ma);class ga extends ua{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a,o){const l=this.length;return this.resize(l+1),this.emplace(l,t,e,r,n,i,s,a,o)}emplace(t,e,r,n,i,s,a,o,l){const u=8*t;return this.uint16[u+0]=e,this.uint16[u+1]=r,this.uint16[u+2]=n,this.uint16[u+3]=i,this.uint16[u+4]=s,this.uint16[u+5]=a,this.uint16[u+6]=o,this.uint16[u+7]=l,t}}ga.prototype.bytesPerElement=16,Zi("StructArrayLayout8ui16",ga);class xa extends ua{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a,o,l,u,c,h,p,d,f,y){const m=this.length;return this.resize(m+1),this.emplace(m,t,e,r,n,i,s,a,o,l,u,c,h,p,d,f,y)}emplace(t,e,r,n,i,s,a,o,l,u,c,h,p,d,f,y,m){const g=16*t;return this.int16[g+0]=e,this.int16[g+1]=r,this.int16[g+2]=n,this.int16[g+3]=i,this.uint16[g+4]=s,this.uint16[g+5]=a,this.uint16[g+6]=o,this.uint16[g+7]=l,this.int16[g+8]=u,this.int16[g+9]=c,this.int16[g+10]=h,this.int16[g+11]=p,this.int16[g+12]=d,this.int16[g+13]=f,this.int16[g+14]=y,this.int16[g+15]=m,t}}xa.prototype.bytesPerElement=32,Zi("StructArrayLayout4i4ui4i4i32",xa);class va extends ua{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer);}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.uint32[1*t+0]=e,t}}va.prototype.bytesPerElement=4,Zi("StructArrayLayout1ul4",va);class ba extends ua{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a,o,l,u,c,h,p){const d=this.length;return this.resize(d+1),this.emplace(d,t,e,r,n,i,s,a,o,l,u,c,h,p)}emplace(t,e,r,n,i,s,a,o,l,u,c,h,p,d){const f=20*t,y=10*t;return this.int16[f+0]=e,this.int16[f+1]=r,this.int16[f+2]=n,this.int16[f+3]=i,this.int16[f+4]=s,this.float32[y+3]=a,this.float32[y+4]=o,this.float32[y+5]=l,this.float32[y+6]=u,this.int16[f+14]=c,this.uint32[y+8]=h,this.uint16[f+18]=p,this.uint16[f+19]=d,t}}ba.prototype.bytesPerElement=40,Zi("StructArrayLayout5i4f1i1ul2ui40",ba);class wa extends ua{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a){const o=this.length;return this.resize(o+1),this.emplace(o,t,e,r,n,i,s,a)}emplace(t,e,r,n,i,s,a,o){const l=8*t;return this.int16[l+0]=e,this.int16[l+1]=r,this.int16[l+2]=n,this.int16[l+4]=i,this.int16[l+5]=s,this.int16[l+6]=a,this.int16[l+7]=o,t}}wa.prototype.bytesPerElement=16,Zi("StructArrayLayout3i2i2i16",wa);class _a extends ua{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i){const s=this.length;return this.resize(s+1),this.emplace(s,t,e,r,n,i)}emplace(t,e,r,n,i,s){const a=4*t,o=8*t;return this.float32[a+0]=e,this.float32[a+1]=r,this.float32[a+2]=n,this.int16[o+6]=i,this.int16[o+7]=s,t}}_a.prototype.bytesPerElement=16,Zi("StructArrayLayout2f1f2i16",_a);class Aa extends ua{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n){const i=this.length;return this.resize(i+1),this.emplace(i,t,e,r,n)}emplace(t,e,r,n,i){const s=12*t,a=3*t;return this.uint8[s+0]=e,this.uint8[s+1]=r,this.float32[a+1]=n,this.float32[a+2]=i,t}}Aa.prototype.bytesPerElement=12,Zi("StructArrayLayout2ub2f12",Aa);class ka extends ua{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=3*t;return this.uint16[i+0]=e,this.uint16[i+1]=r,this.uint16[i+2]=n,t}}ka.prototype.bytesPerElement=6,Zi("StructArrayLayout3ui6",ka);class Sa extends ua{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a,o,l,u,c,h,p,d,f,y,m,g,x,v,b){const w=this.length;return this.resize(w+1),this.emplace(w,t,e,r,n,i,s,a,o,l,u,c,h,p,d,f,y,m,g,x,v,b)}emplace(t,e,r,n,i,s,a,o,l,u,c,h,p,d,f,y,m,g,x,v,b,w){const _=30*t,A=15*t,k=60*t;return this.int16[_+0]=e,this.int16[_+1]=r,this.int16[_+2]=n,this.float32[A+2]=i,this.float32[A+3]=s,this.uint16[_+8]=a,this.uint16[_+9]=o,this.uint32[A+5]=l,this.uint32[A+6]=u,this.uint32[A+7]=c,this.uint16[_+16]=h,this.uint16[_+17]=p,this.uint16[_+18]=d,this.float32[A+10]=f,this.float32[A+11]=y,this.uint8[k+48]=m,this.uint8[k+49]=g,this.uint8[k+50]=x,this.uint32[A+13]=v,this.int16[_+28]=b,this.uint8[k+58]=w,t}}Sa.prototype.bytesPerElement=60,Zi("StructArrayLayout3i2f2ui3ul3ui2f3ub1ul1i1ub60",Sa);class Ia extends ua{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a,o,l,u,c,h,p,d,f,y,m,g,x,v,b,w,_,A,k,S,I,z,M,T){const B=this.length;return this.resize(B+1),this.emplace(B,t,e,r,n,i,s,a,o,l,u,c,h,p,d,f,y,m,g,x,v,b,w,_,A,k,S,I,z,M,T)}emplace(t,e,r,n,i,s,a,o,l,u,c,h,p,d,f,y,m,g,x,v,b,w,_,A,k,S,I,z,M,T,B){const C=38*t,P=19*t;return this.int16[C+0]=e,this.int16[C+1]=r,this.int16[C+2]=n,this.float32[P+2]=i,this.float32[P+3]=s,this.int16[C+8]=a,this.int16[C+9]=o,this.int16[C+10]=l,this.int16[C+11]=u,this.int16[C+12]=c,this.int16[C+13]=h,this.uint16[C+14]=p,this.uint16[C+15]=d,this.uint16[C+16]=f,this.uint16[C+17]=y,this.uint16[C+18]=m,this.uint16[C+19]=g,this.uint16[C+20]=x,this.uint16[C+21]=v,this.uint16[C+22]=b,this.uint16[C+23]=w,this.uint16[C+24]=_,this.uint16[C+25]=A,this.uint16[C+26]=k,this.uint16[C+27]=S,this.uint16[C+28]=I,this.uint32[P+15]=z,this.float32[P+16]=M,this.float32[P+17]=T,this.float32[P+18]=B,t}}Ia.prototype.bytesPerElement=76,Zi("StructArrayLayout3i2f6i15ui1ul3f76",Ia);class za extends ua{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.float32[1*t+0]=e,t}}za.prototype.bytesPerElement=4,Zi("StructArrayLayout1f4",za);class Ma extends ua{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=3*t;return this.int16[i+0]=e,this.int16[i+1]=r,this.int16[i+2]=n,t}}Ma.prototype.bytesPerElement=6,Zi("StructArrayLayout3i6",Ma);class Ta extends ua{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a){const o=this.length;return this.resize(o+1),this.emplace(o,t,e,r,n,i,s,a)}emplace(t,e,r,n,i,s,a,o){const l=7*t;return this.float32[l+0]=e,this.float32[l+1]=r,this.float32[l+2]=n,this.float32[l+3]=i,this.float32[l+4]=s,this.float32[l+5]=a,this.float32[l+6]=o,t}}Ta.prototype.bytesPerElement=28,Zi("StructArrayLayout7f28",Ta);class Ba extends ua{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r,n){const i=this.length;return this.resize(i+1),this.emplace(i,t,e,r,n)}emplace(t,e,r,n,i){const s=6*t;return this.uint32[3*t+0]=e,this.uint16[s+2]=r,this.uint16[s+3]=n,this.uint16[s+4]=i,t}}Ba.prototype.bytesPerElement=12,Zi("StructArrayLayout1ul3ui12",Ba);class Ca extends ua{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e){const r=this.length;return this.resize(r+1),this.emplace(r,t,e)}emplace(t,e,r){const n=2*t;return this.uint16[n+0]=e,this.uint16[n+1]=r,t}}Ca.prototype.bytesPerElement=4,Zi("StructArrayLayout2ui4",Ca);class Pa extends ua{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.uint16[1*t+0]=e,t}}Pa.prototype.bytesPerElement=2,Zi("StructArrayLayout1ui2",Pa);class Ea extends ua{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e){const r=this.length;return this.resize(r+1),this.emplace(r,t,e)}emplace(t,e,r){const n=2*t;return this.float32[n+0]=e,this.float32[n+1]=r,t}}Ea.prototype.bytesPerElement=8,Zi("StructArrayLayout2f8",Ea);class Da extends ua{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n){const i=this.length;return this.resize(i+1),this.emplace(i,t,e,r,n)}emplace(t,e,r,n,i){const s=4*t;return this.float32[s+0]=e,this.float32[s+1]=r,this.float32[s+2]=n,this.float32[s+3]=i,t}}Da.prototype.bytesPerElement=16,Zi("StructArrayLayout4f16",Da);class Va extends la{get projectedAnchorX(){return this._structArray.int16[this._pos2+0]}get projectedAnchorY(){return this._structArray.int16[this._pos2+1]}get projectedAnchorZ(){return this._structArray.int16[this._pos2+2]}get tileAnchorX(){return this._structArray.int16[this._pos2+3]}get tileAnchorY(){return this._structArray.int16[this._pos2+4]}get x1(){return this._structArray.float32[this._pos4+3]}get y1(){return this._structArray.float32[this._pos4+4]}get x2(){return this._structArray.float32[this._pos4+5]}get y2(){return this._structArray.float32[this._pos4+6]}get padding(){return this._structArray.int16[this._pos2+14]}get featureIndex(){return this._structArray.uint32[this._pos4+8]}get sourceLayerIndex(){return this._structArray.uint16[this._pos2+18]}get bucketIndex(){return this._structArray.uint16[this._pos2+19]}}Va.prototype.size=40;class Fa extends ba{get(t){return new Va(this,t)}}Zi("CollisionBoxArray",Fa);class La extends la{get projectedAnchorX(){return this._structArray.int16[this._pos2+0]}get projectedAnchorY(){return this._structArray.int16[this._pos2+1]}get projectedAnchorZ(){return this._structArray.int16[this._pos2+2]}get tileAnchorX(){return this._structArray.float32[this._pos4+2]}get tileAnchorY(){return this._structArray.float32[this._pos4+3]}get glyphStartIndex(){return this._structArray.uint16[this._pos2+8]}get numGlyphs(){return this._structArray.uint16[this._pos2+9]}get vertexStartIndex(){return this._structArray.uint32[this._pos4+5]}get lineStartIndex(){return this._structArray.uint32[this._pos4+6]}get lineLength(){return this._structArray.uint32[this._pos4+7]}get segment(){return this._structArray.uint16[this._pos2+16]}get lowerSize(){return this._structArray.uint16[this._pos2+17]}get upperSize(){return this._structArray.uint16[this._pos2+18]}get lineOffsetX(){return this._structArray.float32[this._pos4+10]}get lineOffsetY(){return this._structArray.float32[this._pos4+11]}get writingMode(){return this._structArray.uint8[this._pos1+48]}get placedOrientation(){return this._structArray.uint8[this._pos1+49]}set placedOrientation(t){this._structArray.uint8[this._pos1+49]=t;}get hidden(){return this._structArray.uint8[this._pos1+50]}set hidden(t){this._structArray.uint8[this._pos1+50]=t;}get crossTileID(){return this._structArray.uint32[this._pos4+13]}set crossTileID(t){this._structArray.uint32[this._pos4+13]=t;}get associatedIconIndex(){return this._structArray.int16[this._pos2+28]}get flipState(){return this._structArray.uint8[this._pos1+58]}set flipState(t){this._structArray.uint8[this._pos1+58]=t;}}La.prototype.size=60;class Ra extends Sa{get(t){return new La(this,t)}}Zi("PlacedSymbolArray",Ra);class Ua extends la{get projectedAnchorX(){return this._structArray.int16[this._pos2+0]}get projectedAnchorY(){return this._structArray.int16[this._pos2+1]}get projectedAnchorZ(){return this._structArray.int16[this._pos2+2]}get tileAnchorX(){return this._structArray.float32[this._pos4+2]}get tileAnchorY(){return this._structArray.float32[this._pos4+3]}get rightJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+8]}get centerJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+9]}get leftJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+10]}get verticalPlacedTextSymbolIndex(){return this._structArray.int16[this._pos2+11]}get placedIconSymbolIndex(){return this._structArray.int16[this._pos2+12]}get verticalPlacedIconSymbolIndex(){return this._structArray.int16[this._pos2+13]}get key(){return this._structArray.uint16[this._pos2+14]}get textBoxStartIndex(){return this._structArray.uint16[this._pos2+15]}get textBoxEndIndex(){return this._structArray.uint16[this._pos2+16]}get verticalTextBoxStartIndex(){return this._structArray.uint16[this._pos2+17]}get verticalTextBoxEndIndex(){return this._structArray.uint16[this._pos2+18]}get iconBoxStartIndex(){return this._structArray.uint16[this._pos2+19]}get iconBoxEndIndex(){return this._structArray.uint16[this._pos2+20]}get verticalIconBoxStartIndex(){return this._structArray.uint16[this._pos2+21]}get verticalIconBoxEndIndex(){return this._structArray.uint16[this._pos2+22]}get featureIndex(){return this._structArray.uint16[this._pos2+23]}get numHorizontalGlyphVertices(){return this._structArray.uint16[this._pos2+24]}get numVerticalGlyphVertices(){return this._structArray.uint16[this._pos2+25]}get numIconVertices(){return this._structArray.uint16[this._pos2+26]}get numVerticalIconVertices(){return this._structArray.uint16[this._pos2+27]}get useRuntimeCollisionCircles(){return this._structArray.uint16[this._pos2+28]}get crossTileID(){return this._structArray.uint32[this._pos4+15]}set crossTileID(t){this._structArray.uint32[this._pos4+15]=t;}get textOffset0(){return this._structArray.float32[this._pos4+16]}get textOffset1(){return this._structArray.float32[this._pos4+17]}get collisionCircleDiameter(){return this._structArray.float32[this._pos4+18]}}Ua.prototype.size=76;class $a extends Ia{get(t){return new Ua(this,t)}}Zi("SymbolInstanceArray",$a);class Oa extends za{getoffsetX(t){return this.float32[1*t+0]}}Zi("GlyphOffsetArray",Oa);class ja extends Ma{getx(t){return this.int16[3*t+0]}gety(t){return this.int16[3*t+1]}gettileUnitDistanceFromAnchor(t){return this.int16[3*t+2]}}Zi("SymbolLineVertexArray",ja);class qa extends la{get featureIndex(){return this._structArray.uint32[this._pos4+0]}get sourceLayerIndex(){return this._structArray.uint16[this._pos2+2]}get bucketIndex(){return this._structArray.uint16[this._pos2+3]}get layoutVertexArrayOffset(){return this._structArray.uint16[this._pos2+4]}}qa.prototype.size=12;class Na extends Ba{get(t){return new qa(this,t)}}Zi("FeatureIndexArray",Na);class Ga extends la{get a_centroid_pos0(){return this._structArray.uint16[this._pos2+0]}get a_centroid_pos1(){return this._structArray.uint16[this._pos2+1]}}Ga.prototype.size=4;class Za extends Ca{get(t){return new Ga(this,t)}}Zi("FillExtrusionCentroidArray",Za);const Xa=ca([{name:"a_pattern_to",components:4,type:"Uint16"},{name:"a_pattern_from",components:4,type:"Uint16"},{name:"a_pixel_ratio_to",components:1,type:"Uint16"},{name:"a_pixel_ratio_from",components:1,type:"Uint16"}]),Ka=ca([{name:"a_dash_to",components:4,type:"Uint16"},{name:"a_dash_from",components:4,type:"Uint16"}]);var Ya=qe((function(t){t.exports=function(t,e){var r,n,i,s,a,o,l,u;for(n=t.length-(r=3&t.length),i=e,a=3432918353,o=461845907,u=0;u<n;)l=255&t.charCodeAt(u)|(255&t.charCodeAt(++u))<<8|(255&t.charCodeAt(++u))<<16|(255&t.charCodeAt(++u))<<24,++u,i=27492+(65535&(s=5*(65535&(i=(i^=l=(65535&(l=(l=(65535&l)*a+(((l>>>16)*a&65535)<<16)&4294967295)<<15|l>>>17))*o+(((l>>>16)*o&65535)<<16)&4294967295)<<13|i>>>19))+((5*(i>>>16)&65535)<<16)&4294967295))+((58964+(s>>>16)&65535)<<16);switch(l=0,r){case 3:l^=(255&t.charCodeAt(u+2))<<16;case 2:l^=(255&t.charCodeAt(u+1))<<8;case 1:i^=l=(65535&(l=(l=(65535&(l^=255&t.charCodeAt(u)))*a+(((l>>>16)*a&65535)<<16)&4294967295)<<15|l>>>17))*o+(((l>>>16)*o&65535)<<16)&4294967295;}return i^=t.length,i=2246822507*(65535&(i^=i>>>16))+((2246822507*(i>>>16)&65535)<<16)&4294967295,i=3266489909*(65535&(i^=i>>>13))+((3266489909*(i>>>16)&65535)<<16)&4294967295,(i^=i>>>16)>>>0};})),Ha=qe((function(t){t.exports=function(t,e){for(var r,n=t.length,i=e^n,s=0;n>=4;)r=1540483477*(65535&(r=255&t.charCodeAt(s)|(255&t.charCodeAt(++s))<<8|(255&t.charCodeAt(++s))<<16|(255&t.charCodeAt(++s))<<24))+((1540483477*(r>>>16)&65535)<<16),i=1540483477*(65535&i)+((1540483477*(i>>>16)&65535)<<16)^(r=1540483477*(65535&(r^=r>>>24))+((1540483477*(r>>>16)&65535)<<16)),n-=4,++s;switch(n){case 3:i^=(255&t.charCodeAt(s+2))<<16;case 2:i^=(255&t.charCodeAt(s+1))<<8;case 1:i=1540483477*(65535&(i^=255&t.charCodeAt(s)))+((1540483477*(i>>>16)&65535)<<16);}return i=1540483477*(65535&(i^=i>>>13))+((1540483477*(i>>>16)&65535)<<16),(i^=i>>>15)>>>0};})),Ja=Ya,Wa=Ha;Ja.murmur3=Ya,Ja.murmur2=Wa;class Qa{constructor(){this.ids=[],this.positions=[],this.indexed=!1;}add(t,e,r,n){this.ids.push(to(t)),this.positions.push(e,r,n);}getPositions(t){const e=to(t);let r=0,n=this.ids.length-1;for(;r<n;){const t=r+n>>1;this.ids[t]>=e?n=t:r=t+1;}const i=[];for(;this.ids[r]===e;)i.push({index:this.positions[3*r],start:this.positions[3*r+1],end:this.positions[3*r+2]}),r++;return i}static serialize(t,e){const r=new Float64Array(t.ids),n=new Uint32Array(t.positions);return eo(r,n,0,r.length-1),e&&e.push(r.buffer,n.buffer),{ids:r,positions:n}}static deserialize(t){const e=new Qa;return e.ids=t.ids,e.positions=t.positions,e.indexed=!0,e}}function to(t){const e=+t;return !isNaN(e)&&Number.MIN_SAFE_INTEGER<=e&&e<=Number.MAX_SAFE_INTEGER?e:Ja(String(t))}function eo(t,e,r,n){for(;r<n;){const i=t[r+n>>1];let s=r-1,a=n+1;for(;;){do{s++;}while(t[s]<i);do{a--;}while(t[a]>i);if(s>=a)break;ro(t,s,a),ro(e,3*s,3*a),ro(e,3*s+1,3*a+1),ro(e,3*s+2,3*a+2);}a-r<n-a?(eo(t,e,r,a),r=a+1):(eo(t,e,a+1,n),n=a);}}function ro(t,e,r){const n=t[e];t[e]=t[r],t[r]=n;}Zi("FeaturePositionMap",Qa);class no{constructor(t,e){this.gl=t.gl,this.location=e;}}class io extends no{constructor(t,e){super(t,e),this.current=0;}set(t){this.current!==t&&(this.current=t,this.gl.uniform1f(this.location,t));}}class so extends no{constructor(t,e){super(t,e),this.current=[0,0,0,0];}set(t){t[0]===this.current[0]&&t[1]===this.current[1]&&t[2]===this.current[2]&&t[3]===this.current[3]||(this.current=t,this.gl.uniform4f(this.location,t[0],t[1],t[2],t[3]));}}class ao extends no{constructor(t,e){super(t,e),this.current=Ge.transparent;}set(t){t.r===this.current.r&&t.g===this.current.g&&t.b===this.current.b&&t.a===this.current.a||(this.current=t,this.gl.uniform4f(this.location,t.r,t.g,t.b,t.a));}}const oo=new Float32Array(16),lo=new Float32Array(9),uo=new Float32Array(4);function co(t){return [aa(255*t.r,255*t.g),aa(255*t.b,255*t.a)]}class ho{constructor(t,e,r){this.value=t,this.uniformNames=e.map((t=>`u_${t}`)),this.type=r;}setUniform(t,e,r){t.set(r.constantOr(this.value));}getBinding(t,e,r){return "color"===this.type?new ao(t,e):new io(t,e)}}class po{constructor(t,e){this.uniformNames=e.map((t=>`u_${t}`)),this.patternFrom=null,this.patternTo=null,this.pixelRatioFrom=1,this.pixelRatioTo=1;}setConstantPatternPositions(t,e){this.pixelRatioFrom=e.pixelRatio,this.pixelRatioTo=t.pixelRatio,this.patternFrom=e.tl.concat(e.br),this.patternTo=t.tl.concat(t.br);}setUniform(t,e,r,n){const i="u_pattern_to"===n||"u_dash_to"===n?this.patternTo:"u_pattern_from"===n||"u_dash_from"===n?this.patternFrom:"u_pixel_ratio_to"===n?this.pixelRatioTo:"u_pixel_ratio_from"===n?this.pixelRatioFrom:null;i&&t.set(i);}getBinding(t,e,r){return "u_pattern_from"===r||"u_pattern_to"===r||"u_dash_from"===r||"u_dash_to"===r?new so(t,e):new io(t,e)}}class fo{constructor(t,e,r,n){this.expression=t,this.type=r,this.maxValue=0,this.paintVertexAttributes=e.map((t=>({name:`a_${t}`,type:"Float32",components:"color"===r?2:1,offset:0}))),this.paintVertexArray=new n;}populatePaintArray(t,e,r,n,i,s){const a=this.paintVertexArray.length,o=this.expression.evaluate(new Gs(0),e,{},i,n,s);this.paintVertexArray.resize(t),this._setPaintValue(a,t,o);}updatePaintArray(t,e,r,n,i){const s=this.expression.evaluate({zoom:0},r,n,void 0,i);this._setPaintValue(t,e,s);}_setPaintValue(t,e,r){if("color"===this.type){const n=co(r);for(let r=t;r<e;r++)this.paintVertexArray.emplace(r,n[0],n[1]);}else {for(let n=t;n<e;n++)this.paintVertexArray.emplace(n,r);this.maxValue=Math.max(this.maxValue,Math.abs(r));}}upload(t){this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer&&this.paintVertexBuffer.buffer?this.paintVertexBuffer.updateData(this.paintVertexArray):this.paintVertexBuffer=t.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,this.expression.isStateDependent));}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy();}}class yo{constructor(t,e,r,n,i,s){this.expression=t,this.uniformNames=e.map((t=>`u_${t}_t`)),this.type=r,this.useIntegerZoom=n,this.zoom=i,this.maxValue=0,this.paintVertexAttributes=e.map((t=>({name:`a_${t}`,type:"Float32",components:"color"===r?4:2,offset:0}))),this.paintVertexArray=new s;}populatePaintArray(t,e,r,n,i,s){const a=this.expression.evaluate(new Gs(this.zoom),e,{},i,n,s),o=this.expression.evaluate(new Gs(this.zoom+1),e,{},i,n,s),l=this.paintVertexArray.length;this.paintVertexArray.resize(t),this._setPaintValue(l,t,a,o);}updatePaintArray(t,e,r,n,i){const s=this.expression.evaluate({zoom:this.zoom},r,n,void 0,i),a=this.expression.evaluate({zoom:this.zoom+1},r,n,void 0,i);this._setPaintValue(t,e,s,a);}_setPaintValue(t,e,r,n){if("color"===this.type){const i=co(r),s=co(n);for(let r=t;r<e;r++)this.paintVertexArray.emplace(r,i[0],i[1],s[0],s[1]);}else {for(let i=t;i<e;i++)this.paintVertexArray.emplace(i,r,n);this.maxValue=Math.max(this.maxValue,Math.abs(r),Math.abs(n));}}upload(t){this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer&&this.paintVertexBuffer.buffer?this.paintVertexBuffer.updateData(this.paintVertexArray):this.paintVertexBuffer=t.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,this.expression.isStateDependent));}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy();}setUniform(t,e){const r=this.useIntegerZoom?Math.floor(e.zoom):e.zoom,n=Y(this.expression.interpolationFactor(r,this.zoom,this.zoom+1),0,1);t.set(n);}getBinding(t,e,r){return new io(t,e)}}class mo{constructor(t,e,r,n,i,s,a){this.expression=t,this.type=r,this.useIntegerZoom=n,this.zoom=i,this.layerId=a,this.paintVertexAttributes=("array"===r?Ka:Xa).members;for(let t=0;t<e.length;++t);this.zoomInPaintVertexArray=new s,this.zoomOutPaintVertexArray=new s;}populatePaintArray(t,e,r){const n=this.zoomInPaintVertexArray.length;this.zoomInPaintVertexArray.resize(t),this.zoomOutPaintVertexArray.resize(t),this._setPaintValues(n,t,e.patterns&&e.patterns[this.layerId],r);}updatePaintArray(t,e,r,n,i,s){this._setPaintValues(t,e,r.patterns&&r.patterns[this.layerId],s);}_setPaintValues(t,e,r,n){if(!n||!r)return;const{min:i,mid:s,max:a}=r,o=n[i],l=n[s],u=n[a];if(o&&l&&u)for(let r=t;r<e;r++)this._setPaintValue(this.zoomInPaintVertexArray,r,l,o),this._setPaintValue(this.zoomOutPaintVertexArray,r,l,u);}_setPaintValue(t,e,r,n){t.emplace(e,r.tl[0],r.tl[1],r.br[0],r.br[1],n.tl[0],n.tl[1],n.br[0],n.br[1],r.pixelRatio,n.pixelRatio);}upload(t){this.zoomInPaintVertexArray&&this.zoomInPaintVertexArray.arrayBuffer&&this.zoomOutPaintVertexArray&&this.zoomOutPaintVertexArray.arrayBuffer&&(this.zoomInPaintVertexBuffer=t.createVertexBuffer(this.zoomInPaintVertexArray,this.paintVertexAttributes,this.expression.isStateDependent),this.zoomOutPaintVertexBuffer=t.createVertexBuffer(this.zoomOutPaintVertexArray,this.paintVertexAttributes,this.expression.isStateDependent));}destroy(){this.zoomOutPaintVertexBuffer&&this.zoomOutPaintVertexBuffer.destroy(),this.zoomInPaintVertexBuffer&&this.zoomInPaintVertexBuffer.destroy();}}class go{constructor(t,e,r=(()=>!0)){this.binders={},this._buffers=[];const n=[];for(const i in t.paint._values){if(!r(i))continue;const s=t.paint.get(i);if(!(s instanceof Ws&&Cn(s.property.specification)))continue;const a=bo(i,t.type),o=s.value,l=s.property.specification.type,u=s.property.useIntegerZoom,c=s.property.specification["property-type"],h="cross-faded"===c||"cross-faded-data-driven"===c,p="line-dasharray"===String(i)&&"constant"!==t.layout.get("line-cap").value.kind;if("constant"!==o.kind||p)if("source"===o.kind||p||h){const r=Ao(i,l,"source");this.binders[i]=h?new mo(o,a,l,u,e,r,t.id):new fo(o,a,l,r),n.push(`/a_${i}`);}else {const t=Ao(i,l,"composite");this.binders[i]=new yo(o,a,l,u,e,t),n.push(`/z_${i}`);}else this.binders[i]=h?new po(o.value,a):new ho(o.value,a,l),n.push(`/u_${i}`);}this.cacheKey=n.sort().join("");}getMaxValue(t){const e=this.binders[t];return e instanceof fo||e instanceof yo?e.maxValue:0}populatePaintArrays(t,e,r,n,i,s){for(const a in this.binders){const o=this.binders[a];(o instanceof fo||o instanceof yo||o instanceof mo)&&o.populatePaintArray(t,e,r,n,i,s);}}setConstantPatternPositions(t,e){for(const r in this.binders){const n=this.binders[r];n instanceof po&&n.setConstantPatternPositions(t,e);}}updatePaintArrays(t,e,r,n,i,s){let a=!1;for(const o in t){const l=e.getPositions(o);for(const e of l){const l=r.feature(e.index);for(const r in this.binders){const u=this.binders[r];if((u instanceof fo||u instanceof yo||u instanceof mo)&&!0===u.expression.isStateDependent){const c=n.paint.get(r);u.expression=c.value,u.updatePaintArray(e.start,e.end,l,t[o],i,s),a=!0;}}}}return a}defines(){const t=[];for(const e in this.binders){const r=this.binders[e];(r instanceof ho||r instanceof po)&&t.push(...r.uniformNames.map((t=>`#define HAS_UNIFORM_${t}`)));}return t}getBinderAttributes(){const t=[];for(const e in this.binders){const r=this.binders[e];if(r instanceof fo||r instanceof yo||r instanceof mo)for(let e=0;e<r.paintVertexAttributes.length;e++)t.push(r.paintVertexAttributes[e].name);}return t}getBinderUniforms(){const t=[];for(const e in this.binders){const r=this.binders[e];if(r instanceof ho||r instanceof po||r instanceof yo)for(const e of r.uniformNames)t.push(e);}return t}getPaintVertexBuffers(){return this._buffers}getUniforms(t,e){const r=[];for(const n in this.binders){const i=this.binders[n];if(i instanceof ho||i instanceof po||i instanceof yo)for(const s of i.uniformNames)if(e[s]){const a=i.getBinding(t,e[s],s);r.push({name:s,property:n,binding:a});}}return r}setUniforms(t,e,r,n){for(const{name:t,property:i,binding:s}of e)this.binders[i].setUniform(s,n,r.get(i),t);}updatePaintBuffers(t){this._buffers=[];for(const e in this.binders){const r=this.binders[e];if(t&&r instanceof mo){const e=2===t.fromScale?r.zoomInPaintVertexBuffer:r.zoomOutPaintVertexBuffer;e&&this._buffers.push(e);}else (r instanceof fo||r instanceof yo)&&r.paintVertexBuffer&&this._buffers.push(r.paintVertexBuffer);}}upload(t){for(const e in this.binders){const r=this.binders[e];(r instanceof fo||r instanceof yo||r instanceof mo)&&r.upload(t);}this.updatePaintBuffers();}destroy(){for(const t in this.binders){const e=this.binders[t];(e instanceof fo||e instanceof yo||e instanceof mo)&&e.destroy();}}}class xo{constructor(t,e,r=(()=>!0)){this.programConfigurations={};for(const n of t)this.programConfigurations[n.id]=new go(n,e,r);this.needsUpload=!1,this._featureMap=new Qa,this._bufferOffset=0;}populatePaintArrays(t,e,r,n,i,s,a){for(const r in this.programConfigurations)this.programConfigurations[r].populatePaintArrays(t,e,n,i,s,a);void 0!==e.id&&this._featureMap.add(e.id,r,this._bufferOffset,t),this._bufferOffset=t,this.needsUpload=!0;}updatePaintArrays(t,e,r,n,i){for(const s of r)this.needsUpload=this.programConfigurations[s.id].updatePaintArrays(t,this._featureMap,e,s,n,i)||this.needsUpload;}get(t){return this.programConfigurations[t]}upload(t){if(this.needsUpload){for(const e in this.programConfigurations)this.programConfigurations[e].upload(t);this.needsUpload=!1;}}destroy(){for(const t in this.programConfigurations)this.programConfigurations[t].destroy();}}const vo={"text-opacity":["opacity"],"icon-opacity":["opacity"],"text-color":["fill_color"],"icon-color":["fill_color"],"text-halo-color":["halo_color"],"icon-halo-color":["halo_color"],"text-halo-blur":["halo_blur"],"icon-halo-blur":["halo_blur"],"text-halo-width":["halo_width"],"icon-halo-width":["halo_width"],"line-gap-width":["gapwidth"],"line-pattern":["pattern_to","pattern_from","pixel_ratio_to","pixel_ratio_from"],"fill-pattern":["pattern_to","pattern_from","pixel_ratio_to","pixel_ratio_from"],"fill-extrusion-pattern":["pattern_to","pattern_from","pixel_ratio_to","pixel_ratio_from"],"line-dasharray":["dash_to","dash_from"]};function bo(t,e){return vo[t]||[t.replace(`${e}-`,"").replace(/-/g,"_")]}const wo={"line-pattern":{source:ma,composite:ma},"fill-pattern":{source:ma,composite:ma},"fill-extrusion-pattern":{source:ma,composite:ma},"line-dasharray":{source:ga,composite:ga}},_o={color:{source:Ea,composite:Da},number:{source:za,composite:Ea}};function Ao(t,e,r){const n=wo[t];return n&&n[r]||_o[e][r]}Zi("ConstantBinder",ho),Zi("CrossFadedConstantBinder",po),Zi("SourceExpressionBinder",fo),Zi("CrossFadedCompositeBinder",mo),Zi("CompositeExpressionBinder",yo),Zi("ProgramConfiguration",go,{omit:["_buffers"]}),Zi("ProgramConfigurationSet",xo);const ko="-transition";class So extends xe{constructor(t,e){if(super(),this.id=t.id,this.type=t.type,this._featureFilter={filter:()=>!0,needGeometry:!1,needFeature:!1},this._filterCompiled=!1,"custom"!==t.type&&(this.metadata=(t=t).metadata,this.minzoom=t.minzoom,this.maxzoom=t.maxzoom,"background"!==t.type&&"sky"!==t.type&&(this.source=t.source,this.sourceLayer=t["source-layer"],this.filter=t.filter),e.layout&&(this._unevaluatedLayout=new Js(e.layout)),e.paint)){this._transitionablePaint=new Ks(e.paint);for(const e in t.paint)this.setPaintProperty(e,t.paint[e],{validate:!1});for(const e in t.layout)this.setLayoutProperty(e,t.layout[e],{validate:!1});this._transitioningPaint=this._transitionablePaint.untransitioned(),this.paint=new Qs(e.paint);}}getCrossfadeParameters(){return this._crossfadeParameters}getLayoutProperty(t){return "visibility"===t?this.visibility:this._unevaluatedLayout.getValue(t)}setLayoutProperty(t,e,r={}){null!=e&&this._validate(Ui,`layers.${this.id}.layout.${t}`,t,e,r)||("visibility"!==t?this._unevaluatedLayout.setValue(t,e):this.visibility=e);}getPaintProperty(t){return ot(t,ko)?this._transitionablePaint.getTransition(t.slice(0,-ko.length)):this._transitionablePaint.getValue(t)}setPaintProperty(t,e,r={}){if(null!=e&&this._validate(Ri,`layers.${this.id}.paint.${t}`,t,e,r))return !1;if(ot(t,ko))return this._transitionablePaint.setTransition(t.slice(0,-ko.length),e||void 0),!1;{const r=this._transitionablePaint._values[t],n="cross-faded-data-driven"===r.property.specification["property-type"],i=r.value.isDataDriven(),s=r.value;this._transitionablePaint.setValue(t,e),this._handleSpecialPaintPropertyUpdate(t);const a=this._transitionablePaint._values[t].value;return a.isDataDriven()||i||n||this._handleOverridablePaintPropertyUpdate(t,s,a)}}_handleSpecialPaintPropertyUpdate(t){}getProgramIds(){return null}getProgramConfiguration(t){return null}_handleOverridablePaintPropertyUpdate(t,e,r){return !1}isHidden(t){return !!(this.minzoom&&t<this.minzoom)||!!(this.maxzoom&&t>=this.maxzoom)||"none"===this.visibility}updateTransitions(t){this._transitioningPaint=this._transitionablePaint.transitioned(t,this._transitioningPaint);}hasTransition(){return this._transitioningPaint.hasTransition()}recalculate(t,e){t.getCrossfadeParameters&&(this._crossfadeParameters=t.getCrossfadeParameters()),this._unevaluatedLayout&&(this.layout=this._unevaluatedLayout.possiblyEvaluate(t,void 0,e)),this.paint=this._transitioningPaint.possiblyEvaluate(t,void 0,e);}serialize(){const t={id:this.id,type:this.type,source:this.source,"source-layer":this.sourceLayer,metadata:this.metadata,minzoom:this.minzoom,maxzoom:this.maxzoom,filter:this.filter,layout:this._unevaluatedLayout&&this._unevaluatedLayout.serialize(),paint:this._transitionablePaint&&this._transitionablePaint.serialize()};return this.visibility&&(t.layout=t.layout||{},t.layout.visibility=this.visibility),ut(t,((t,e)=>!(void 0===t||"layout"===e&&!Object.keys(t).length||"paint"===e&&!Object.keys(t).length)))}_validate(t,e,r,n,i={}){return (!i||!1!==i.validate)&&$i(this,t.call(Vi,{key:e,layerType:this.type,objectKey:r,value:n,styleSpec:ve,style:{glyphs:!0,sprite:!0}}))}is3D(){return !1}isSky(){return !1}isTileClipped(){return !1}hasOffscreenPass(){return !1}resize(){}isStateDependent(){for(const t in this.paint._values){const e=this.paint.get(t);if(e instanceof Ws&&Cn(e.property.specification)&&("source"===e.value.kind||"composite"===e.value.kind)&&e.value.isStateDependent)return !0}return !1}compileFilter(){this._filterCompiled||(this._featureFilter=si(this.filter),this._filterCompiled=!0);}invalidateCompiledFilter(){this._filterCompiled=!1;}dynamicFilter(){return this._featureFilter.dynamicFilter}dynamicFilterNeedsFeature(){return this._featureFilter.needFeature}}const Io=ca([{name:"a_pos",components:2,type:"Int16"}],4),{members:zo}=Io;class Mo{constructor(t=[]){this.segments=t;}prepareSegment(t,e,r,n){let i=this.segments[this.segments.length-1];return t>Mo.MAX_VERTEX_ARRAY_LENGTH&&pt(`Max vertices per segment is ${Mo.MAX_VERTEX_ARRAY_LENGTH}: bucket requested ${t}`),(!i||i.vertexLength+t>Mo.MAX_VERTEX_ARRAY_LENGTH||i.sortKey!==n)&&(i={vertexOffset:e.length,primitiveOffset:r.length,vertexLength:0,primitiveLength:0},void 0!==n&&(i.sortKey=n),this.segments.push(i)),i}get(){return this.segments}destroy(){for(const t of this.segments)for(const e in t.vaos)t.vaos[e].destroy();}static simpleSegment(t,e,r,n){return new Mo([{vertexOffset:t,primitiveOffset:e,vertexLength:r,primitiveLength:n,vaos:{},sortKey:0}])}}Mo.MAX_VERTEX_ARRAY_LENGTH=Math.pow(2,16)-1,Zi("SegmentVector",Mo);var To=8192;class Bo{constructor(t,e){t&&(e?this.setSouthWest(t).setNorthEast(e):4===t.length?this.setSouthWest([t[0],t[1]]).setNorthEast([t[2],t[3]]):this.setSouthWest(t[0]).setNorthEast(t[1]));}setNorthEast(t){return this._ne=t instanceof Po?new Po(t.lng,t.lat):Po.convert(t),this}setSouthWest(t){return this._sw=t instanceof Po?new Po(t.lng,t.lat):Po.convert(t),this}extend(t){const e=this._sw,r=this._ne;let n,i;if(t instanceof Po)n=t,i=t;else {if(!(t instanceof Bo))return Array.isArray(t)?4===t.length||t.every(Array.isArray)?this.extend(Bo.convert(t)):this.extend(Po.convert(t)):this;if(n=t._sw,i=t._ne,!n||!i)return this}return e||r?(e.lng=Math.min(n.lng,e.lng),e.lat=Math.min(n.lat,e.lat),r.lng=Math.max(i.lng,r.lng),r.lat=Math.max(i.lat,r.lat)):(this._sw=new Po(n.lng,n.lat),this._ne=new Po(i.lng,i.lat)),this}getCenter(){return new Po((this._sw.lng+this._ne.lng)/2,(this._sw.lat+this._ne.lat)/2)}getSouthWest(){return this._sw}getNorthEast(){return this._ne}getNorthWest(){return new Po(this.getWest(),this.getNorth())}getSouthEast(){return new Po(this.getEast(),this.getSouth())}getWest(){return this._sw.lng}getSouth(){return this._sw.lat}getEast(){return this._ne.lng}getNorth(){return this._ne.lat}toArray(){return [this._sw.toArray(),this._ne.toArray()]}toString(){return `LngLatBounds(${this._sw.toString()}, ${this._ne.toString()})`}isEmpty(){return !(this._sw&&this._ne)}contains(t){const{lng:e,lat:r}=Po.convert(t);let n=this._sw.lng<=e&&e<=this._ne.lng;return this._sw.lng>this._ne.lng&&(n=this._sw.lng>=e&&e>=this._ne.lng),this._sw.lat<=r&&r<=this._ne.lat&&n}static convert(t){return !t||t instanceof Bo?t:new Bo(t)}}const Co=6371008.8;class Po{constructor(t,e){if(isNaN(t)||isNaN(e))throw new Error(`Invalid LngLat object: (${t}, ${e})`);if(this.lng=+t,this.lat=+e,this.lat>90||this.lat<-90)throw new Error("Invalid LngLat latitude value: must be between -90 and 90")}wrap(){return new Po(J(this.lng,-180,180),this.lat)}toArray(){return [this.lng,this.lat]}toString(){return `LngLat(${this.lng}, ${this.lat})`}distanceTo(t){const e=Math.PI/180,r=this.lat*e,n=t.lat*e,i=Math.sin(r)*Math.sin(n)+Math.cos(r)*Math.cos(n)*Math.cos((t.lng-this.lng)*e);return Co*Math.acos(Math.min(i,1))}toBounds(t=0){const e=360*t/40075017,r=e/Math.cos(Math.PI/180*this.lat);return new Bo(new Po(this.lng-r,this.lat-e),new Po(this.lng+r,this.lat+e))}static convert(t){if(t instanceof Po)return t;if(Array.isArray(t)&&(2===t.length||3===t.length))return new Po(Number(t[0]),Number(t[1]));if(!Array.isArray(t)&&"object"==typeof t&&null!==t)return new Po(Number("lng"in t?t.lng:t.lon),Number(t.lat));throw new Error("`LngLatLike` argument must be specified as a LngLat instance, an object {lng: <lng>, lat: <lat>}, an object {lon: <lng>, lat: <lat>}, or an array of [<lng>, <lat>]")}}const Eo=2*Math.PI*Co;function Do(t){return Eo*Math.cos(t*Math.PI/180)}function Vo(t){return (180+t)/360}function Fo(t){return (180-180/Math.PI*Math.log(Math.tan(Math.PI/4+t*Math.PI/360)))/360}function Lo(t,e){return t/Do(e)}function Ro(t){return 360*t-180}function Uo(t){return 360/Math.PI*Math.atan(Math.exp((180-360*t)*Math.PI/180))-90}function $o(t,e){return t*Do(Uo(e))}const Oo=85.051129;class jo{constructor(t,e,r=0){this.x=+t,this.y=+e,this.z=+r;}static fromLngLat(t,e=0){const r=Po.convert(t);return new jo(Vo(r.lng),Fo(r.lat),Lo(e,r.lat))}toLngLat(){return new Po(Ro(this.x),Uo(this.y))}toAltitude(){return $o(this.z,this.y)}meterInMercatorCoordinateUnits(){return 1/Eo*(t=Uo(this.y),1/Math.cos(t*Math.PI/180));var t;}}function qo(t,e,r,n,s,a,o,l,u){const c=(e+n)/2,h=(r+s)/2,p=new i(c,h);l(p),function(t,e,r,n,i,s){const a=r-i,o=n-s;return Math.abs((n-e)*a-(r-t)*o)/Math.hypot(a,o)}(p.x,p.y,a.x,a.y,o.x,o.y)>=u?(qo(t,e,r,c,h,a,p,l,u),qo(t,c,h,n,s,p,o,l,u)):t.push(o);}function No(t,e,r){const n=[];let i,s,a;for(const o of t){const{x:t,y:l}=o;e(o),a?qo(n,i,s,t,l,a,o,e,r):n.push(o),i=t,s=l,a=o;}return n}const Go=Math.pow(2,14)-1,Zo=-Go-1;function Xo(t,e){const r=Math.round(t.x*e),n=Math.round(t.y*e);return t.x=Y(r,Zo,Go),t.y=Y(n,Zo,Go),(r<t.x||r>t.x+1||n<t.y||n>t.y+1)&&pt("Geometry exceeds allowed extent, reduce your vector tile buffer size"),t}function Ko(t,e,r){const n=t.loadGeometry(),i=t.extent,s=To/i;if(e&&r&&r.projection.isReprojectedInTileSpace){const s=1<<e.z,{scale:a,x:o,y:l,projection:u}=r,c=t=>{const r=Ro((e.x+t.x/i)/s),n=Uo((e.y+t.y/i)/s),c=u.project(r,n);t.x=(c.x*a-o)*i,t.y=(c.y*a-l)*i;};for(let e=0;e<n.length;e++)if(1!==t.type)n[e]=No(n[e],c,1);else {const t=[];for(const r of n[e])r.x<0||r.x>=i||r.y<0||r.y>=i||(c(r),t.push(r));n[e]=t;}}for(const t of n)for(const e of t)Xo(e,s);return n}function Yo(t,e){return {type:t.type,id:t.id,properties:t.properties,geometry:e?Ko(t):[]}}function Ho(t,e,r,n,i){t.emplaceBack(2*e+(n+1)/2,2*r+(i+1)/2);}class Jo{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.hasPattern=!1,this.layoutVertexArray=new pa,this.indexArray=new ka,this.segments=new Mo,this.programConfigurations=new xo(t.layers,t.zoom),this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id));}populate(t,e,r,n){const i=this.layers[0],s=[];let a=null;"circle"===i.type&&(a=i.layout.get("circle-sort-key"));for(const{feature:e,id:i,index:o,sourceLayerIndex:l}of t){const t=this.layers[0]._featureFilter.needGeometry,u=Yo(e,t);if(!this.layers[0]._featureFilter.filter(new Gs(this.zoom),u,r))continue;const c=a?a.evaluate(u,{},r):void 0,h={id:i,properties:e.properties,type:e.type,sourceLayerIndex:l,index:o,geometry:t?u.geometry:Ko(e,r,n),patterns:{},sortKey:c};s.push(h);}a&&s.sort(((t,e)=>t.sortKey-e.sortKey));for(const n of s){const{geometry:i,index:s,sourceLayerIndex:a}=n,o=t[s].feature;this.addFeature(n,i,s,e.availableImages,r),e.featureIndex.insert(o,i,s,a,this.index);}}update(t,e,r,n){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,r,n);}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return !this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,zo),this.indexBuffer=t.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(t),this.uploaded=!0;}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy());}addFeature(t,e,r,n,i){for(const r of e)for(const e of r){const r=e.x,n=e.y;if(r<0||r>=To||n<0||n>=To)continue;const i=this.segments.prepareSegment(4,this.layoutVertexArray,this.indexArray,t.sortKey),s=i.vertexLength;Ho(this.layoutVertexArray,r,n,-1,-1),Ho(this.layoutVertexArray,r,n,1,-1),Ho(this.layoutVertexArray,r,n,1,1),Ho(this.layoutVertexArray,r,n,-1,1),this.indexArray.emplaceBack(s,s+1,s+2),this.indexArray.emplaceBack(s,s+3,s+2),i.vertexLength+=4,i.primitiveLength+=2;}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,{},n,i);}}function Wo(t,e){for(let r=0;r<t.length;r++)if(ol(e,t[r]))return !0;for(let r=0;r<e.length;r++)if(ol(t,e[r]))return !0;return !!rl(t,e)}function Qo(t,e,r){return !!ol(t,e)||!!il(e,t,r)}function tl(t,e){if(1===t.length)return al(e,t[0]);for(let r=0;r<e.length;r++){const n=e[r];for(let e=0;e<n.length;e++)if(ol(t,n[e]))return !0}for(let r=0;r<t.length;r++)if(al(e,t[r]))return !0;for(let r=0;r<e.length;r++)if(rl(t,e[r]))return !0;return !1}function el(t,e,r){if(t.length>1){if(rl(t,e))return !0;for(let n=0;n<e.length;n++)if(il(e[n],t,r))return !0}for(let n=0;n<t.length;n++)if(il(t[n],e,r))return !0;return !1}function rl(t,e){if(0===t.length||0===e.length)return !1;for(let r=0;r<t.length-1;r++){const n=t[r],i=t[r+1];for(let t=0;t<e.length-1;t++)if(nl(n,i,e[t],e[t+1]))return !0}return !1}function nl(t,e,r,n){return dt(t,r,n)!==dt(e,r,n)&&dt(t,e,r)!==dt(t,e,n)}function il(t,e,r){const n=r*r;if(1===e.length)return t.distSqr(e[0])<n;for(let r=1;r<e.length;r++)if(sl(t,e[r-1],e[r])<n)return !0;return !1}function sl(t,e,r){const n=e.distSqr(r);if(0===n)return t.distSqr(e);const i=((t.x-e.x)*(r.x-e.x)+(t.y-e.y)*(r.y-e.y))/n;return t.distSqr(i<0?e:i>1?r:r.sub(e)._mult(i)._add(e))}function al(t,e){let r,n,i,s=!1;for(let a=0;a<t.length;a++){r=t[a];for(let t=0,a=r.length-1;t<r.length;a=t++)n=r[t],i=r[a],n.y>e.y!=i.y>e.y&&e.x<(i.x-n.x)*(e.y-n.y)/(i.y-n.y)+n.x&&(s=!s);}return s}function ol(t,e){let r=!1;for(let n=0,i=t.length-1;n<t.length;i=n++){const s=t[n],a=t[i];s.y>e.y!=a.y>e.y&&e.x<(a.x-s.x)*(e.y-s.y)/(a.y-s.y)+s.x&&(r=!r);}return r}function ll(t,e,r,n,s){for(const i of t)if(e<=i.x&&r<=i.y&&n>=i.x&&s>=i.y)return !0;const a=[new i(e,r),new i(e,s),new i(n,s),new i(n,r)];if(t.length>2)for(const e of a)if(ol(t,e))return !0;for(let e=0;e<t.length-1;e++)if(ul(t[e],t[e+1],a))return !0;return !1}function ul(t,e,r){const n=r[0],i=r[2];if(t.x<n.x&&e.x<n.x||t.x>i.x&&e.x>i.x||t.y<n.y&&e.y<n.y||t.y>i.y&&e.y>i.y)return !1;const s=dt(t,e,r[0]);return s!==dt(t,e,r[1])||s!==dt(t,e,r[2])||s!==dt(t,e,r[3])}function cl(t,e,r){const n=e.paint.get(t).value;return "constant"===n.kind?n.value:r.programConfigurations.get(e.id).getMaxValue(t)}function hl(t){return Math.sqrt(t[0]*t[0]+t[1]*t[1])}function pl(t,e,r,n,s){if(!e[0]&&!e[1])return t;const a=i.convert(e)._mult(s);"viewport"===r&&a._rotate(-n);const o=[];for(let e=0;e<t.length;e++)o.push(t[e].sub(a));return o}function dl(t,e,r,n){const s=i.convert(t)._mult(n);return "viewport"===e&&s._rotate(-r),s}Zi("CircleBucket",Jo,{omit:["layers"]});const fl=new sa({"circle-sort-key":new ea(ve.layout_circle["circle-sort-key"])});var yl={paint:new sa({"circle-radius":new ea(ve.paint_circle["circle-radius"]),"circle-color":new ea(ve.paint_circle["circle-color"]),"circle-blur":new ea(ve.paint_circle["circle-blur"]),"circle-opacity":new ea(ve.paint_circle["circle-opacity"]),"circle-translate":new ta(ve.paint_circle["circle-translate"]),"circle-translate-anchor":new ta(ve.paint_circle["circle-translate-anchor"]),"circle-pitch-scale":new ta(ve.paint_circle["circle-pitch-scale"]),"circle-pitch-alignment":new ta(ve.paint_circle["circle-pitch-alignment"]),"circle-stroke-width":new ea(ve.paint_circle["circle-stroke-width"]),"circle-stroke-color":new ea(ve.paint_circle["circle-stroke-color"]),"circle-stroke-opacity":new ea(ve.paint_circle["circle-stroke-opacity"])}),layout:fl};class ml{constructor(t,e){this.points=t,this.planes=e;}static fromInvProjectionMatrix(t,e,r,n){const i=Math.pow(2,r),s=[[-1,1,-1,1],[1,1,-1,1],[1,-1,-1,1],[-1,-1,-1,1],[-1,1,1,1],[1,1,1,1],[1,-1,1,1],[-1,-1,1,1]].map((r=>{const s=F([],r,t),a=1/s[3]/e*i;return function(t,e,r){return t[0]=e[0]*r[0],t[1]=e[1]*r[1],t[2]=e[2]*r[2],t[3]=e[3]*r[3],t}(s,s,[a,a,n?1/s[3]:a,a])})),a=[[0,1,2],[6,5,4],[0,3,7],[2,1,5],[3,2,6],[0,4,5]].map((t=>{const e=z([],T([],E([],s[t[0]],s[t[1]]),E([],s[t[2]],s[t[1]]))),r=-M(e,s[t[1]]);return e.concat(r)}));return new ml(s,a)}}class gl{constructor(t,e){this.min=t,this.max=e,this.center=S([],w([],this.min,this.max),.5);}quadrant(t){const e=[t%2==0,t<2],r=x(this.min),n=x(this.max);for(let t=0;t<e.length;t++)r[t]=e[t]?this.min[t]:this.center[t],n[t]=e[t]?this.center[t]:this.max[t];return n[2]=this.max[2],new gl(r,n)}distanceX(t){return Math.max(Math.min(this.max[0],t[0]),this.min[0])-t[0]}distanceY(t){return Math.max(Math.min(this.max[1],t[1]),this.min[1])-t[1]}distanceZ(t){return Math.max(Math.min(this.max[2],t[2]),this.min[2])-t[2]}getCorners(){const t=this.min,e=this.max;return [[t[0],t[1],t[2]],[e[0],t[1],t[2]],[e[0],e[1],t[2]],[t[0],e[1],t[2]],[t[0],t[1],e[2]],[e[0],t[1],e[2]],[e[0],e[1],e[2]],[t[0],e[1],e[2]]]}intersects(t){const e=this.getCorners();let r=!0;for(let n=0;n<t.planes.length;n++){const i=t.planes[n];let s=0;for(let t=0;t<e.length;t++)s+=M(i,e[t])+i[3]>=0;if(0===s)return 0;s!==e.length&&(r=!1);}if(r)return 2;for(let e=0;e<3;e++){let r=Number.MAX_VALUE,n=-Number.MAX_VALUE;for(let i=0;i<t.points.length;i++){const s=t.points[i][e]-this.min[e];r=Math.min(r,s),n=Math.max(n,s);}if(n<0||r>this.max[e]-this.min[e])return 0}return 1}}function xl(t,e,r,n,i,s,a,o,l){if(s&&t.queryGeometry.isAboveHorizon)return !1;s&&(l*=t.pixelToTileUnitsFactor);for(const u of e)for(const e of u){const u=e.add(o),c=i&&r.elevation?r.elevation.exaggeration()*i.getElevationAt(u.x,u.y,!0):0,h=s?u:vl(u,c,n),p=s?t.tilespaceRays.map((t=>_l(t,c))):t.queryGeometry.screenGeometry,d=F([],[e.x,e.y,c,1],n);if(!a&&s?l*=d[3]/r.cameraToCenterDistance:a&&!s&&(l*=r.cameraToCenterDistance/d[3]),Qo(p,h,l))return !0}return !1}function vl(t,e,r){const n=F([],[t.x,t.y,e,1],r);return new i(n[0]/n[3],n[1]/n[3])}const bl=b(0,0,0),wl=b(0,0,1);function _l(t,e){const r=g();return bl[2]=e,t.intersectsPlane(bl,wl,r),new i(r[0],r[1])}class Al extends Jo{}function kl(t,{width:e,height:r},n,i){if(i){if(i instanceof Uint8ClampedArray)i=new Uint8Array(i.buffer);else if(i.length!==e*r*n)throw new RangeError("mismatched image size")}else i=new Uint8Array(e*r*n);return t.width=e,t.height=r,t.data=i,t}function Sl(t,{width:e,height:r},n){if(e===t.width&&r===t.height)return;const i=kl({},{width:e,height:r},n);Il(t,i,{x:0,y:0},{x:0,y:0},{width:Math.min(t.width,e),height:Math.min(t.height,r)},n),t.width=e,t.height=r,t.data=i.data;}function Il(t,e,r,n,i,s){if(0===i.width||0===i.height)return e;if(i.width>t.width||i.height>t.height||r.x>t.width-i.width||r.y>t.height-i.height)throw new RangeError("out of range source coordinates for image copy");if(i.width>e.width||i.height>e.height||n.x>e.width-i.width||n.y>e.height-i.height)throw new RangeError("out of range destination coordinates for image copy");const a=t.data,o=e.data;for(let l=0;l<i.height;l++){const u=((r.y+l)*t.width+r.x)*s,c=((n.y+l)*e.width+n.x)*s;for(let t=0;t<i.width*s;t++)o[c+t]=a[u+t];}return e}Zi("HeatmapBucket",Al,{omit:["layers"]});class zl{constructor(t,e){kl(this,t,1,e);}resize(t){Sl(this,t,1);}clone(){return new zl({width:this.width,height:this.height},new Uint8Array(this.data))}static copy(t,e,r,n,i){Il(t,e,r,n,i,1);}}class Ml{constructor(t,e){kl(this,t,4,e);}resize(t){Sl(this,t,4);}replace(t,e){e?this.data.set(t):this.data=t instanceof Uint8ClampedArray?new Uint8Array(t.buffer):t;}clone(){return new Ml({width:this.width,height:this.height},new Uint8Array(this.data))}static copy(t,e,r,n,i){Il(t,e,r,n,i,4);}}Zi("AlphaImage",zl),Zi("RGBAImage",Ml);var Tl={paint:new sa({"heatmap-radius":new ea(ve.paint_heatmap["heatmap-radius"]),"heatmap-weight":new ea(ve.paint_heatmap["heatmap-weight"]),"heatmap-intensity":new ta(ve.paint_heatmap["heatmap-intensity"]),"heatmap-color":new ia(ve.paint_heatmap["heatmap-color"]),"heatmap-opacity":new ta(ve.paint_heatmap["heatmap-opacity"])})};function Bl(t){const e={},r=t.resolution||256,n=t.clips?t.clips.length:1,i=t.image||new Ml({width:r,height:n}),s=(r,n,s)=>{e[t.evaluationKey]=s;const a=t.expression.evaluate(e);i.data[r+n+0]=Math.floor(255*a.r/a.a),i.data[r+n+1]=Math.floor(255*a.g/a.a),i.data[r+n+2]=Math.floor(255*a.b/a.a),i.data[r+n+3]=Math.floor(255*a.a);};if(t.clips)for(let e=0,i=0;e<n;++e,i+=4*r)for(let n=0,a=0;n<r;n++,a+=4){const o=n/(r-1),{start:l,end:u}=t.clips[e];s(i,a,l*(1-o)+u*o);}else for(let t=0,e=0;t<r;t++,e+=4)s(0,e,t/(r-1));return i}var Cl={paint:new sa({"hillshade-illumination-direction":new ta(ve.paint_hillshade["hillshade-illumination-direction"]),"hillshade-illumination-anchor":new ta(ve.paint_hillshade["hillshade-illumination-anchor"]),"hillshade-exaggeration":new ta(ve.paint_hillshade["hillshade-exaggeration"]),"hillshade-shadow-color":new ta(ve.paint_hillshade["hillshade-shadow-color"]),"hillshade-highlight-color":new ta(ve.paint_hillshade["hillshade-highlight-color"]),"hillshade-accent-color":new ta(ve.paint_hillshade["hillshade-accent-color"])})};const Pl=ca([{name:"a_pos",components:2,type:"Int16"}],4),{members:El}=Pl;var Dl=Fl,Vl=Fl;function Fl(t,e,r){r=r||2;var n,i,s,a,o,l,u,c=e&&e.length,h=c?e[0]*r:t.length,p=Ll(t,0,h,r,!0),d=[];if(!p||p.next===p.prev)return d;if(c&&(p=function(t,e,r,n){var i,s,a,o=[];for(i=0,s=e.length;i<s;i++)(a=Ll(t,e[i]*n,i<s-1?e[i+1]*n:t.length,n,!1))===a.next&&(a.steiner=!0),o.push(Kl(a));for(o.sort(Nl),i=0;i<o.length;i++)r=Rl(r=Gl(o[i],r),r.next);return r}(t,e,p,r)),t.length>80*r){n=s=t[0],i=a=t[1];for(var f=r;f<h;f+=r)(o=t[f])<n&&(n=o),(l=t[f+1])<i&&(i=l),o>s&&(s=o),l>a&&(a=l);u=0!==(u=Math.max(s-n,a-i))?1/u:0;}return Ul(p,d,r,n,i,u),d}function Ll(t,e,r,n,i){var s,a;if(i===ou(t,e,r,n)>0)for(s=e;s<r;s+=n)a=iu(s,t[s],t[s+1],a);else for(s=r-n;s>=e;s-=n)a=iu(s,t[s],t[s+1],a);return a&&Wl(a,a.next)&&(su(a),a=a.next),a}function Rl(t,e){if(!t)return t;e||(e=t);var r,n=t;do{if(r=!1,n.steiner||!Wl(n,n.next)&&0!==Jl(n.prev,n,n.next))n=n.next;else {if(su(n),(n=e=n.prev)===n.next)break;r=!0;}}while(r||n!==e);return e}function Ul(t,e,r,n,i,s,a){if(t){!a&&s&&function(t,e,r,n){var i=t;do{null===i.z&&(i.z=Xl(i.x,i.y,e,r,n)),i.prevZ=i.prev,i.nextZ=i.next,i=i.next;}while(i!==t);i.prevZ.nextZ=null,i.prevZ=null,function(t){var e,r,n,i,s,a,o,l,u=1;do{for(r=t,t=null,s=null,a=0;r;){for(a++,n=r,o=0,e=0;e<u&&(o++,n=n.nextZ);e++);for(l=u;o>0||l>0&&n;)0!==o&&(0===l||!n||r.z<=n.z)?(i=r,r=r.nextZ,o--):(i=n,n=n.nextZ,l--),s?s.nextZ=i:t=i,i.prevZ=s,s=i;r=n;}s.nextZ=null,u*=2;}while(a>1)}(i);}(t,n,i,s);for(var o,l,u=t;t.prev!==t.next;)if(o=t.prev,l=t.next,s?Ol(t,n,i,s):$l(t))e.push(o.i/r),e.push(t.i/r),e.push(l.i/r),su(t),t=l.next,u=l.next;else if((t=l)===u){a?1===a?Ul(t=jl(Rl(t),e,r),e,r,n,i,s,2):2===a&&ql(t,e,r,n,i,s):Ul(Rl(t),e,r,n,i,s,1);break}}}function $l(t){var e=t.prev,r=t,n=t.next;if(Jl(e,r,n)>=0)return !1;for(var i=t.next.next;i!==t.prev;){if(Yl(e.x,e.y,r.x,r.y,n.x,n.y,i.x,i.y)&&Jl(i.prev,i,i.next)>=0)return !1;i=i.next;}return !0}function Ol(t,e,r,n){var i=t.prev,s=t,a=t.next;if(Jl(i,s,a)>=0)return !1;for(var o=i.x>s.x?i.x>a.x?i.x:a.x:s.x>a.x?s.x:a.x,l=i.y>s.y?i.y>a.y?i.y:a.y:s.y>a.y?s.y:a.y,u=Xl(i.x<s.x?i.x<a.x?i.x:a.x:s.x<a.x?s.x:a.x,i.y<s.y?i.y<a.y?i.y:a.y:s.y<a.y?s.y:a.y,e,r,n),c=Xl(o,l,e,r,n),h=t.prevZ,p=t.nextZ;h&&h.z>=u&&p&&p.z<=c;){if(h!==t.prev&&h!==t.next&&Yl(i.x,i.y,s.x,s.y,a.x,a.y,h.x,h.y)&&Jl(h.prev,h,h.next)>=0)return !1;if(h=h.prevZ,p!==t.prev&&p!==t.next&&Yl(i.x,i.y,s.x,s.y,a.x,a.y,p.x,p.y)&&Jl(p.prev,p,p.next)>=0)return !1;p=p.nextZ;}for(;h&&h.z>=u;){if(h!==t.prev&&h!==t.next&&Yl(i.x,i.y,s.x,s.y,a.x,a.y,h.x,h.y)&&Jl(h.prev,h,h.next)>=0)return !1;h=h.prevZ;}for(;p&&p.z<=c;){if(p!==t.prev&&p!==t.next&&Yl(i.x,i.y,s.x,s.y,a.x,a.y,p.x,p.y)&&Jl(p.prev,p,p.next)>=0)return !1;p=p.nextZ;}return !0}function jl(t,e,r){var n=t;do{var i=n.prev,s=n.next.next;!Wl(i,s)&&Ql(i,n,n.next,s)&&ru(i,s)&&ru(s,i)&&(e.push(i.i/r),e.push(n.i/r),e.push(s.i/r),su(n),su(n.next),n=t=s),n=n.next;}while(n!==t);return Rl(n)}function ql(t,e,r,n,i,s){var a=t;do{for(var o=a.next.next;o!==a.prev;){if(a.i!==o.i&&Hl(a,o)){var l=nu(a,o);return a=Rl(a,a.next),l=Rl(l,l.next),Ul(a,e,r,n,i,s),void Ul(l,e,r,n,i,s)}o=o.next;}a=a.next;}while(a!==t)}function Nl(t,e){return t.x-e.x}function Gl(t,e){var r=function(t,e){var r,n=e,i=t.x,s=t.y,a=-1/0;do{if(s<=n.y&&s>=n.next.y&&n.next.y!==n.y){var o=n.x+(s-n.y)*(n.next.x-n.x)/(n.next.y-n.y);if(o<=i&&o>a){if(a=o,o===i){if(s===n.y)return n;if(s===n.next.y)return n.next}r=n.x<n.next.x?n:n.next;}}n=n.next;}while(n!==e);if(!r)return null;if(i===a)return r;var l,u=r,c=r.x,h=r.y,p=1/0;n=r;do{i>=n.x&&n.x>=c&&i!==n.x&&Yl(s<h?i:a,s,c,h,s<h?a:i,s,n.x,n.y)&&(l=Math.abs(s-n.y)/(i-n.x),ru(n,t)&&(l<p||l===p&&(n.x>r.x||n.x===r.x&&Zl(r,n)))&&(r=n,p=l)),n=n.next;}while(n!==u);return r}(t,e);if(!r)return e;var n=nu(r,t),i=Rl(r,r.next);return Rl(n,n.next),e===r?i:e}function Zl(t,e){return Jl(t.prev,t,e.prev)<0&&Jl(e.next,t,t.next)<0}function Xl(t,e,r,n,i){return (t=1431655765&((t=858993459&((t=252645135&((t=16711935&((t=32767*(t-r)*i)|t<<8))|t<<4))|t<<2))|t<<1))|(e=1431655765&((e=858993459&((e=252645135&((e=16711935&((e=32767*(e-n)*i)|e<<8))|e<<4))|e<<2))|e<<1))<<1}function Kl(t){var e=t,r=t;do{(e.x<r.x||e.x===r.x&&e.y<r.y)&&(r=e),e=e.next;}while(e!==t);return r}function Yl(t,e,r,n,i,s,a,o){return (i-a)*(e-o)-(t-a)*(s-o)>=0&&(t-a)*(n-o)-(r-a)*(e-o)>=0&&(r-a)*(s-o)-(i-a)*(n-o)>=0}function Hl(t,e){return t.next.i!==e.i&&t.prev.i!==e.i&&!function(t,e){var r=t;do{if(r.i!==t.i&&r.next.i!==t.i&&r.i!==e.i&&r.next.i!==e.i&&Ql(r,r.next,t,e))return !0;r=r.next;}while(r!==t);return !1}(t,e)&&(ru(t,e)&&ru(e,t)&&function(t,e){var r=t,n=!1,i=(t.x+e.x)/2,s=(t.y+e.y)/2;do{r.y>s!=r.next.y>s&&r.next.y!==r.y&&i<(r.next.x-r.x)*(s-r.y)/(r.next.y-r.y)+r.x&&(n=!n),r=r.next;}while(r!==t);return n}(t,e)&&(Jl(t.prev,t,e.prev)||Jl(t,e.prev,e))||Wl(t,e)&&Jl(t.prev,t,t.next)>0&&Jl(e.prev,e,e.next)>0)}function Jl(t,e,r){return (e.y-t.y)*(r.x-e.x)-(e.x-t.x)*(r.y-e.y)}function Wl(t,e){return t.x===e.x&&t.y===e.y}function Ql(t,e,r,n){var i=eu(Jl(t,e,r)),s=eu(Jl(t,e,n)),a=eu(Jl(r,n,t)),o=eu(Jl(r,n,e));return i!==s&&a!==o||!(0!==i||!tu(t,r,e))||!(0!==s||!tu(t,n,e))||!(0!==a||!tu(r,t,n))||!(0!==o||!tu(r,e,n))}function tu(t,e,r){return e.x<=Math.max(t.x,r.x)&&e.x>=Math.min(t.x,r.x)&&e.y<=Math.max(t.y,r.y)&&e.y>=Math.min(t.y,r.y)}function eu(t){return t>0?1:t<0?-1:0}function ru(t,e){return Jl(t.prev,t,t.next)<0?Jl(t,e,t.next)>=0&&Jl(t,t.prev,e)>=0:Jl(t,e,t.prev)<0||Jl(t,t.next,e)<0}function nu(t,e){var r=new au(t.i,t.x,t.y),n=new au(e.i,e.x,e.y),i=t.next,s=e.prev;return t.next=e,e.prev=t,r.next=i,i.prev=r,n.next=r,r.prev=n,s.next=n,n.prev=s,n}function iu(t,e,r,n){var i=new au(t,e,r);return n?(i.next=n.next,i.prev=n,n.next.prev=i,n.next=i):(i.prev=i,i.next=i),i}function su(t){t.next.prev=t.prev,t.prev.next=t.next,t.prevZ&&(t.prevZ.nextZ=t.nextZ),t.nextZ&&(t.nextZ.prevZ=t.prevZ);}function au(t,e,r){this.i=t,this.x=e,this.y=r,this.prev=null,this.next=null,this.z=null,this.prevZ=null,this.nextZ=null,this.steiner=!1;}function ou(t,e,r,n){for(var i=0,s=e,a=r-n;s<r;s+=n)i+=(t[a]-t[s])*(t[s+1]+t[a+1]),a=s;return i}function lu(t,e,r,n,i){uu(t,e,r||0,n||t.length-1,i||hu);}function uu(t,e,r,n,i){for(;n>r;){if(n-r>600){var s=n-r+1,a=e-r+1,o=Math.log(s),l=.5*Math.exp(2*o/3),u=.5*Math.sqrt(o*l*(s-l)/s)*(a-s/2<0?-1:1);uu(t,e,Math.max(r,Math.floor(e-a*l/s+u)),Math.min(n,Math.floor(e+(s-a)*l/s+u)),i);}var c=t[e],h=r,p=n;for(cu(t,r,e),i(t[n],c)>0&&cu(t,r,n);h<p;){for(cu(t,h,p),h++,p--;i(t[h],c)<0;)h++;for(;i(t[p],c)>0;)p--;}0===i(t[r],c)?cu(t,r,p):cu(t,++p,n),p<=e&&(r=p+1),e<=p&&(n=p-1);}}function cu(t,e,r){var n=t[e];t[e]=t[r],t[r]=n;}function hu(t,e){return t<e?-1:t>e?1:0}function pu(t,e){const r=t.length;if(r<=1)return [t];const n=[];let i,s;for(let e=0;e<r;e++){const r=ft(t[e]);0!==r&&(t[e].area=Math.abs(r),void 0===s&&(s=r<0),s===r<0?(i&&n.push(i),i=[t[e]]):i.push(t[e]));}if(i&&n.push(i),e>1)for(let t=0;t<n.length;t++)n[t].length<=e||(lu(n[t],e,1,n[t].length-1,du),n[t]=n[t].slice(0,e));return n}function du(t,e){return e.area-t.area}function fu(t,e,r){const n=r.patternDependencies;let i=!1;for(const r of e){const e=r.paint.get(`${t}-pattern`);e.isConstant()||(i=!0);const s=e.constantOr(null);s&&(i=!0,n[s.to]=!0,n[s.from]=!0);}return i}function yu(t,e,r,n,i){const s=i.patternDependencies;for(const a of e){const e=a.paint.get(`${t}-pattern`).value;if("constant"!==e.kind){let t=e.evaluate({zoom:n-1},r,{},i.availableImages),o=e.evaluate({zoom:n},r,{},i.availableImages),l=e.evaluate({zoom:n+1},r,{},i.availableImages);t=t&&t.name?t.name:t,o=o&&o.name?o.name:o,l=l&&l.name?l.name:l,s[t]=!0,s[o]=!0,s[l]=!0,r.patterns[a.id]={min:t,mid:o,max:l};}}return r}Fl.deviation=function(t,e,r,n){var i=e&&e.length,s=Math.abs(ou(t,0,i?e[0]*r:t.length,r));if(i)for(var a=0,o=e.length;a<o;a++)s-=Math.abs(ou(t,e[a]*r,a<o-1?e[a+1]*r:t.length,r));var l=0;for(a=0;a<n.length;a+=3){var u=n[a]*r,c=n[a+1]*r,h=n[a+2]*r;l+=Math.abs((t[u]-t[h])*(t[c+1]-t[u+1])-(t[u]-t[c])*(t[h+1]-t[u+1]));}return 0===s&&0===l?0:Math.abs((l-s)/s)},Fl.flatten=function(t){for(var e=t[0][0].length,r={vertices:[],holes:[],dimensions:e},n=0,i=0;i<t.length;i++){for(var s=0;s<t[i].length;s++)for(var a=0;a<e;a++)r.vertices.push(t[i][s][a]);i>0&&r.holes.push(n+=t[i-1].length);}return r},Dl.default=Vl;class mu{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.hasPattern=!1,this.patternFeatures=[],this.layoutVertexArray=new pa,this.indexArray=new ka,this.indexArray2=new Ca,this.programConfigurations=new xo(t.layers,t.zoom),this.segments=new Mo,this.segments2=new Mo,this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id));}populate(t,e,r,n){this.hasPattern=fu("fill",this.layers,e);const i=this.layers[0].layout.get("fill-sort-key"),s=[];for(const{feature:a,id:o,index:l,sourceLayerIndex:u}of t){const t=this.layers[0]._featureFilter.needGeometry,c=Yo(a,t);if(!this.layers[0]._featureFilter.filter(new Gs(this.zoom),c,r))continue;const h=i?i.evaluate(c,{},r,e.availableImages):void 0,p={id:o,properties:a.properties,type:a.type,sourceLayerIndex:u,index:l,geometry:t?c.geometry:Ko(a,r,n),patterns:{},sortKey:h};s.push(p);}i&&s.sort(((t,e)=>t.sortKey-e.sortKey));for(const n of s){const{geometry:i,index:s,sourceLayerIndex:a}=n;if(this.hasPattern){const t=yu("fill",this.layers,n,this.zoom,e);this.patternFeatures.push(t);}else this.addFeature(n,i,s,r,{},e.availableImages);e.featureIndex.insert(t[s].feature,i,s,a,this.index);}}update(t,e,r,n){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,r,n);}addFeatures(t,e,r,n){for(const t of this.patternFeatures)this.addFeature(t,t.geometry,t.index,e,r,n);}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return !this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,El),this.indexBuffer=t.createIndexBuffer(this.indexArray),this.indexBuffer2=t.createIndexBuffer(this.indexArray2)),this.programConfigurations.upload(t),this.uploaded=!0;}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.indexBuffer2.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.segments2.destroy());}addFeature(t,e,r,n,i,s=[]){for(const t of pu(e,500)){let e=0;for(const r of t)e+=r.length;const r=this.segments.prepareSegment(e,this.layoutVertexArray,this.indexArray),n=r.vertexLength,i=[],s=[];for(const e of t){if(0===e.length)continue;e!==t[0]&&s.push(i.length/2);const r=this.segments2.prepareSegment(e.length,this.layoutVertexArray,this.indexArray2),n=r.vertexLength;this.layoutVertexArray.emplaceBack(e[0].x,e[0].y),this.indexArray2.emplaceBack(n+e.length-1,n),i.push(e[0].x),i.push(e[0].y);for(let t=1;t<e.length;t++)this.layoutVertexArray.emplaceBack(e[t].x,e[t].y),this.indexArray2.emplaceBack(n+t-1,n+t),i.push(e[t].x),i.push(e[t].y);r.vertexLength+=e.length,r.primitiveLength+=e.length;}const a=Dl(i,s);for(let t=0;t<a.length;t+=3)this.indexArray.emplaceBack(n+a[t],n+a[t+1],n+a[t+2]);r.vertexLength+=e,r.primitiveLength+=a.length/3;}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,i,s,n);}}Zi("FillBucket",mu,{omit:["layers","patternFeatures"]});const gu=new sa({"fill-sort-key":new ea(ve.layout_fill["fill-sort-key"])});var xu={paint:new sa({"fill-antialias":new ta(ve.paint_fill["fill-antialias"]),"fill-opacity":new ea(ve.paint_fill["fill-opacity"]),"fill-color":new ea(ve.paint_fill["fill-color"]),"fill-outline-color":new ea(ve.paint_fill["fill-outline-color"]),"fill-translate":new ta(ve.paint_fill["fill-translate"]),"fill-translate-anchor":new ta(ve.paint_fill["fill-translate-anchor"]),"fill-pattern":new ra(ve.paint_fill["fill-pattern"])}),layout:gu};const vu=ca([{name:"a_pos_normal_ed",components:4,type:"Int16"}]),bu=ca([{name:"a_centroid_pos",components:2,type:"Uint16"}]),{members:wu}=vu;var _u=Au;function Au(t,e,r,n,i){this.properties={},this.extent=r,this.type=0,this._pbf=t,this._geometry=-1,this._keys=n,this._values=i,t.readFields(ku,this,e);}function ku(t,e,r){1==t?e.id=r.readVarint():2==t?function(t,e){for(var r=t.readVarint()+t.pos;t.pos<r;){var n=e._keys[t.readVarint()],i=e._values[t.readVarint()];e.properties[n]=i;}}(r,e):3==t?e.type=r.readVarint():4==t&&(e._geometry=r.pos);}function Su(t){for(var e,r,n=0,i=0,s=t.length,a=s-1;i<s;a=i++)n+=((r=t[a]).x-(e=t[i]).x)*(e.y+r.y);return n}Au.types=["Unknown","Point","LineString","Polygon"],Au.prototype.loadGeometry=function(){var t=this._pbf;t.pos=this._geometry;for(var e,r=t.readVarint()+t.pos,n=1,s=0,a=0,o=0,l=[];t.pos<r;){if(s<=0){var u=t.readVarint();n=7&u,s=u>>3;}if(s--,1===n||2===n)a+=t.readSVarint(),o+=t.readSVarint(),1===n&&(e&&l.push(e),e=[]),e.push(new i(a,o));else {if(7!==n)throw new Error("unknown command "+n);e&&e.push(e[0].clone());}}return e&&l.push(e),l},Au.prototype.bbox=function(){var t=this._pbf;t.pos=this._geometry;for(var e=t.readVarint()+t.pos,r=1,n=0,i=0,s=0,a=1/0,o=-1/0,l=1/0,u=-1/0;t.pos<e;){if(n<=0){var c=t.readVarint();r=7&c,n=c>>3;}if(n--,1===r||2===r)(i+=t.readSVarint())<a&&(a=i),i>o&&(o=i),(s+=t.readSVarint())<l&&(l=s),s>u&&(u=s);else if(7!==r)throw new Error("unknown command "+r)}return [a,l,o,u]},Au.prototype.toGeoJSON=function(t,e,r){var n,i,s=this.extent*Math.pow(2,r),a=this.extent*t,o=this.extent*e,l=this.loadGeometry(),u=Au.types[this.type];function c(t){for(var e=0;e<t.length;e++){var r=t[e];t[e]=[360*(r.x+a)/s-180,360/Math.PI*Math.atan(Math.exp((180-360*(r.y+o)/s)*Math.PI/180))-90];}}switch(this.type){case 1:var h=[];for(n=0;n<l.length;n++)h[n]=l[n][0];c(l=h);break;case 2:for(n=0;n<l.length;n++)c(l[n]);break;case 3:for(l=function(t){var e=t.length;if(e<=1)return [t];for(var r,n,i=[],s=0;s<e;s++){var a=Su(t[s]);0!==a&&(void 0===n&&(n=a<0),n===a<0?(r&&i.push(r),r=[t[s]]):r.push(t[s]));}return r&&i.push(r),i}(l),n=0;n<l.length;n++)for(i=0;i<l[n].length;i++)c(l[n][i]);}1===l.length?l=l[0]:u="Multi"+u;var p={type:"Feature",geometry:{type:u,coordinates:l},properties:this.properties};return "id"in this&&(p.id=this.id),p};var Iu=zu;function zu(t,e){this.version=1,this.name=null,this.extent=4096,this.length=0,this._pbf=t,this._keys=[],this._values=[],this._features=[],t.readFields(Mu,this,e),this.length=this._features.length;}function Mu(t,e,r){15===t?e.version=r.readVarint():1===t?e.name=r.readString():5===t?e.extent=r.readVarint():2===t?e._features.push(r.pos):3===t?e._keys.push(r.readString()):4===t&&e._values.push(function(t){for(var e=null,r=t.readVarint()+t.pos;t.pos<r;){var n=t.readVarint()>>3;e=1===n?t.readString():2===n?t.readFloat():3===n?t.readDouble():4===n?t.readVarint64():5===n?t.readVarint():6===n?t.readSVarint():7===n?t.readBoolean():null;}return e}(r));}function Tu(t,e,r){if(3===t){var n=new Iu(r,r.readVarint()+r.pos);n.length&&(e[n.name]=n);}}zu.prototype.feature=function(t){if(t<0||t>=this._features.length)throw new Error("feature index out of bounds");this._pbf.pos=this._features[t];var e=this._pbf.readVarint()+this._pbf.pos;return new _u(this._pbf,e,this.extent,this._keys,this._values)};var Bu={VectorTile:function(t,e){this.layers=t.readFields(Tu,{},e);},VectorTileFeature:_u,VectorTileLayer:Iu};const Cu=Bu.VectorTileFeature.types,Pu=Math.pow(2,13);function Eu(t,e,r,n,i,s,a,o){t.emplaceBack((e<<1)+a,(r<<1)+s,(Math.floor(n*Pu)<<1)+i,Math.round(o));}class Du{constructor(){this.acc=new i(0,0),this.polyCount=[];}startRing(t){this.currentPolyCount={edges:0,top:0},this.polyCount.push(this.currentPolyCount),this.min||(this.min=new i(t.x,t.y),this.max=new i(t.x,t.y));}append(t,e){this.currentPolyCount.edges++,this.acc._add(t);let r=!!this.borders;const n=this.min,i=this.max;t.x<n.x?(n.x=t.x,r=!0):t.x>i.x&&(i.x=t.x,r=!0),t.y<n.y?(n.y=t.y,r=!0):t.y>i.y&&(i.y=t.y,r=!0),((0===t.x||t.x===To)&&t.x===e.x)!=((0===t.y||t.y===To)&&t.y===e.y)&&this.processBorderOverlap(t,e),r&&this.checkBorderIntersection(t,e);}checkBorderIntersection(t,e){e.x<0!=t.x<0&&this.addBorderIntersection(0,Lr(e.y,t.y,(0-e.x)/(t.x-e.x))),e.x>To!=t.x>To&&this.addBorderIntersection(1,Lr(e.y,t.y,(To-e.x)/(t.x-e.x))),e.y<0!=t.y<0&&this.addBorderIntersection(2,Lr(e.x,t.x,(0-e.y)/(t.y-e.y))),e.y>To!=t.y>To&&this.addBorderIntersection(3,Lr(e.x,t.x,(To-e.y)/(t.y-e.y)));}addBorderIntersection(t,e){this.borders||(this.borders=[[Number.MAX_VALUE,-Number.MAX_VALUE],[Number.MAX_VALUE,-Number.MAX_VALUE],[Number.MAX_VALUE,-Number.MAX_VALUE],[Number.MAX_VALUE,-Number.MAX_VALUE]]);const r=this.borders[t];e<r[0]&&(r[0]=e),e>r[1]&&(r[1]=e);}processBorderOverlap(t,e){if(t.x===e.x){if(t.y===e.y)return;const r=0===t.x?0:1;this.addBorderIntersection(r,e.y),this.addBorderIntersection(r,t.y);}else {const r=0===t.y?2:3;this.addBorderIntersection(r,e.x),this.addBorderIntersection(r,t.x);}}centroid(){const t=this.polyCount.reduce(((t,e)=>t+e.edges),0);return 0!==t?this.acc.div(t)._round():new i(0,0)}span(){return new i(this.max.x-this.min.x,this.max.y-this.min.y)}intersectsCount(){return this.borders.reduce(((t,e)=>t+ +(e[0]!==Number.MAX_VALUE)),0)}}class Vu{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.hasPattern=!1,this.layoutVertexArray=new da,this.centroidVertexArray=new Za,this.indexArray=new ka,this.programConfigurations=new xo(t.layers,t.zoom),this.segments=new Mo,this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id)),this.enableTerrain=t.enableTerrain;}populate(t,e,r,n){this.features=[],this.hasPattern=fu("fill-extrusion",this.layers,e),this.featuresOnBorder=[],this.borders=[[],[],[],[]],this.borderDone=[!1,!1,!1,!1],this.tileToMeter=function(t){const e=Math.exp(Math.PI*(1-t.y/(1<<t.z)*2));return 80150034*e/(e*e+1)/To/(1<<t.z)}(r);for(const{feature:i,id:s,index:a,sourceLayerIndex:o}of t){const t=this.layers[0]._featureFilter.needGeometry,l=Yo(i,t);if(!this.layers[0]._featureFilter.filter(new Gs(this.zoom),l,r))continue;const u={id:s,sourceLayerIndex:o,index:a,geometry:t?l.geometry:Ko(i,r,n),properties:i.properties,type:i.type,patterns:{}},c=this.layoutVertexArray.length;this.hasPattern?this.features.push(yu("fill-extrusion",this.layers,u,this.zoom,e)):this.addFeature(u,u.geometry,a,r,{},e.availableImages),e.featureIndex.insert(i,u.geometry,a,o,this.index,c);}this.sortBorders();}addFeatures(t,e,r,n){for(const t of this.features){const{geometry:i}=t;this.addFeature(t,i,t.index,e,r,n);}this.sortBorders();}update(t,e,r,n){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,r,n);}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return !this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,wu),this.indexBuffer=t.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(t),this.uploaded=!0;}uploadCentroid(t){0!==this.centroidVertexArray.length&&(this.centroidVertexBuffer?this.needsCentroidUpdate&&this.centroidVertexBuffer.updateData(this.centroidVertexArray):this.centroidVertexBuffer=t.createVertexBuffer(this.centroidVertexArray,bu.members,!0),this.needsCentroidUpdate=!1);}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.centroidVertexBuffer&&this.centroidVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy());}addFeature(t,e,r,n,i,s){const a=this.enableTerrain?new Du:null;for(const r of pu(e,500)){let e=0,n=this.segments.prepareSegment(4,this.layoutVertexArray,this.indexArray);if(0===r.length||(o=r[0]).every((t=>t.x<=0))||o.every((t=>t.x>=To))||o.every((t=>t.y<=0))||o.every((t=>t.y>=To)))continue;for(let t=0;t<r.length;t++){const i=r[t];if(0===i.length)continue;e+=i.length;let s=0;a&&a.startRing(i[0]);for(let t=0;t<i.length;t++){const e=i[t];if(t>=1){const r=i[t-1];if(!Fu(e,r)){a&&a.append(e,r),n.vertexLength+4>Mo.MAX_VERTEX_ARRAY_LENGTH&&(n=this.segments.prepareSegment(4,this.layoutVertexArray,this.indexArray));const t=e.sub(r)._perp(),i=t.x/(Math.abs(t.x)+Math.abs(t.y)),o=t.y>0?1:0,l=r.dist(e);s+l>32768&&(s=0),Eu(this.layoutVertexArray,e.x,e.y,i,o,0,0,s),Eu(this.layoutVertexArray,e.x,e.y,i,o,0,1,s),s+=l,Eu(this.layoutVertexArray,r.x,r.y,i,o,0,0,s),Eu(this.layoutVertexArray,r.x,r.y,i,o,0,1,s);const u=n.vertexLength;this.indexArray.emplaceBack(u,u+2,u+1),this.indexArray.emplaceBack(u+1,u+2,u+3),n.vertexLength+=4,n.primitiveLength+=2;}}}}if(n.vertexLength+e>Mo.MAX_VERTEX_ARRAY_LENGTH&&(n=this.segments.prepareSegment(e,this.layoutVertexArray,this.indexArray)),"Polygon"!==Cu[t.type])continue;const i=[],s=[],l=n.vertexLength;for(let t=0;t<r.length;t++){const e=r[t];if(0!==e.length){e!==r[0]&&s.push(i.length/2);for(let t=0;t<e.length;t++){const r=e[t];Eu(this.layoutVertexArray,r.x,r.y,0,0,1,1,0),i.push(r.x),i.push(r.y),a&&a.currentPolyCount.top++;}}}const u=Dl(i,s);for(let t=0;t<u.length;t+=3)this.indexArray.emplaceBack(l+u[t],l+u[t+2],l+u[t+1]);n.primitiveLength+=u.length/3,n.vertexLength+=e;}var o;if(a&&a.polyCount.length>0){if(a.borders){a.vertexArrayOffset=this.centroidVertexArray.length;const t=a.borders,e=this.featuresOnBorder.push(a)-1;for(let r=0;r<4;r++)t[r][0]!==Number.MAX_VALUE&&this.borders[r].push(e);}this.encodeCentroid(a.borders?void 0:a.centroid(),a);}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,i,s,n);}sortBorders(){for(let t=0;t<4;t++)this.borders[t].sort(((e,r)=>this.featuresOnBorder[e].borders[t][0]-this.featuresOnBorder[r].borders[t][0]));}encodeCentroid(t,e,r=!0){let n,i;if(t)if(0!==t.y){const r=e.span()._mult(this.tileToMeter);n=(Math.max(t.x,1)<<3)+Math.min(7,Math.round(r.x/10)),i=(Math.max(t.y,1)<<3)+Math.min(7,Math.round(r.y/10));}else n=Math.ceil(7*(t.x+450)),i=0;else n=0,i=+r;let s=r?this.centroidVertexArray.length:e.vertexArrayOffset;for(const t of e.polyCount){r&&this.centroidVertexArray.resize(this.centroidVertexArray.length+4*t.edges+t.top);for(let e=0;e<2*t.edges;e++)this.centroidVertexArray.emplace(s++,0,i),this.centroidVertexArray.emplace(s++,n,i);for(let e=0;e<t.top;e++)this.centroidVertexArray.emplace(s++,n,i);}}}function Fu(t,e){return t.x===e.x&&(t.x<0||t.x>To)||t.y===e.y&&(t.y<0||t.y>To)}Zi("FillExtrusionBucket",Vu,{omit:["layers","features"]}),Zi("PartMetadata",Du);var Lu={paint:new sa({"fill-extrusion-opacity":new ta(ve["paint_fill-extrusion"]["fill-extrusion-opacity"]),"fill-extrusion-color":new ea(ve["paint_fill-extrusion"]["fill-extrusion-color"]),"fill-extrusion-translate":new ta(ve["paint_fill-extrusion"]["fill-extrusion-translate"]),"fill-extrusion-translate-anchor":new ta(ve["paint_fill-extrusion"]["fill-extrusion-translate-anchor"]),"fill-extrusion-pattern":new ra(ve["paint_fill-extrusion"]["fill-extrusion-pattern"]),"fill-extrusion-height":new ea(ve["paint_fill-extrusion"]["fill-extrusion-height"]),"fill-extrusion-base":new ea(ve["paint_fill-extrusion"]["fill-extrusion-base"]),"fill-extrusion-vertical-gradient":new ta(ve["paint_fill-extrusion"]["fill-extrusion-vertical-gradient"])})};function Ru(t,e){return t.x*e.x+t.y*e.y}function Uu(t,e){if(1===t.length){let r=0;const n=e[r++];let i;for(;!i||n.equals(i);)if(i=e[r++],!i)return 1/0;for(;r<e.length;r++){const s=e[r],a=t[0],o=i.sub(n),l=s.sub(n),u=a.sub(n),c=Ru(o,o),h=Ru(o,l),p=Ru(l,l),d=Ru(u,o),f=Ru(u,l),y=c*p-h*h,m=(p*d-h*f)/y,g=(c*f-h*d)/y,x=n.z*(1-m-g)+i.z*m+s.z*g;if(isFinite(x))return x}return 1/0}{let t=1/0;for(const r of e)t=Math.min(t,r.z);return t}}function $u(t){const e=new i(t[0],t[1]);return e.z=t[2],e}function Ou(t,e,r,n,i,s,a,o){const l=a*i.getElevationAt(t,e,!0,!0),u=0!==s[0],c=u?0===s[1]?a*(s[0]/7-450):a*function(t,e,r){const n=Math.floor(e[0]/8),i=Math.floor(e[1]/8),s=10*(e[0]-8*n),a=10*(e[1]-8*i),o=t.getElevationAt(n,i,!0,!0),l=t.getMeterToDEM(r),u=Math.floor(.5*(s*l-1)),c=Math.floor(.5*(a*l-1)),h=t.tileCoordToPixel(n,i),p=2*u+1,d=2*c+1,f=function(t,e,r,n,i){return [t.getElevationAtPixel(e,r,!0),t.getElevationAtPixel(e+i,r,!0),t.getElevationAtPixel(e,r+i,!0),t.getElevationAtPixel(e+n,r+i,!0)]}(t,h.x-u,h.y-c,p,d),y=Math.abs(f[0]-f[1]),m=Math.abs(f[2]-f[3]),g=Math.abs(f[0]-f[2])+Math.abs(f[1]-f[3]),x=Math.min(.25,.5*l*(y+m)/p),v=Math.min(.25,.5*l*g/d);return o+Math.max(x*s,v*a)}(i,s,o):l;return {base:l+(0===r)?-1:r,top:u?Math.max(c+n,l+r+2):l+n}}const ju=ca([{name:"a_pos_normal",components:2,type:"Int16"},{name:"a_data",components:4,type:"Uint8"},{name:"a_linesofar",components:1,type:"Float32"}],4),{members:qu}=ju,Nu=ca([{name:"a_packed",components:3,type:"Float32"}]),{members:Gu}=Nu,Zu=Bu.VectorTileFeature.types,Xu=Math.cos(Math.PI/180*37.5);class Ku{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.hasPattern=!1,this.patternFeatures=[],this.lineClipsArray=[],this.gradients={},this.layers.forEach((t=>{this.gradients[t.id]={};})),this.layoutVertexArray=new fa,this.layoutVertexArray2=new ya,this.indexArray=new ka,this.programConfigurations=new xo(t.layers,t.zoom),this.segments=new Mo,this.maxLineLength=0,this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id));}populate(t,e,r,n){this.hasPattern=fu("line",this.layers,e);const i=this.layers[0].layout.get("line-sort-key"),s=[];for(const{feature:e,id:a,index:o,sourceLayerIndex:l}of t){const t=this.layers[0]._featureFilter.needGeometry,u=Yo(e,t);if(!this.layers[0]._featureFilter.filter(new Gs(this.zoom),u,r))continue;const c=i?i.evaluate(u,{},r):void 0,h={id:a,properties:e.properties,type:e.type,sourceLayerIndex:l,index:o,geometry:t?u.geometry:Ko(e,r,n),patterns:{},sortKey:c};s.push(h);}i&&s.sort(((t,e)=>t.sortKey-e.sortKey));const{lineAtlas:a,featureIndex:o}=e,l=this.addConstantDashes(a);for(const n of s){const{geometry:i,index:s,sourceLayerIndex:u}=n;if(l&&this.addFeatureDashes(n,a),this.hasPattern){const t=yu("line",this.layers,n,this.zoom,e);this.patternFeatures.push(t);}else this.addFeature(n,i,s,r,a.positions,e.availableImages);o.insert(t[s].feature,i,s,u,this.index);}}addConstantDashes(t){let e=!1;for(const r of this.layers){const n=r.paint.get("line-dasharray").value,i=r.layout.get("line-cap").value;if("constant"!==n.kind||"constant"!==i.kind)e=!0;else {const e=i.value,r=n.value;if(!r)continue;t.addDash(r.from,e),t.addDash(r.to,e),r.other&&t.addDash(r.other,e);}}return e}addFeatureDashes(t,e){const r=this.zoom;for(const n of this.layers){const i=n.paint.get("line-dasharray").value,s=n.layout.get("line-cap").value;if("constant"===i.kind&&"constant"===s.kind)continue;let a,o,l,u,c,h;if("constant"===i.kind){const t=i.value;if(!t)continue;a=t.other||t.to,o=t.to,l=t.from;}else a=i.evaluate({zoom:r-1},t),o=i.evaluate({zoom:r},t),l=i.evaluate({zoom:r+1},t);"constant"===s.kind?u=c=h=s.value:(u=s.evaluate({zoom:r-1},t),c=s.evaluate({zoom:r},t),h=s.evaluate({zoom:r+1},t)),e.addDash(a,u),e.addDash(o,c),e.addDash(l,h);const p=e.getKey(a,u),d=e.getKey(o,c),f=e.getKey(l,h);t.patterns[n.id]={min:p,mid:d,max:f};}}update(t,e,r,n){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,r,n);}addFeatures(t,e,r,n){for(const t of this.patternFeatures)this.addFeature(t,t.geometry,t.index,e,r,n);}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return !this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(0!==this.layoutVertexArray2.length&&(this.layoutVertexBuffer2=t.createVertexBuffer(this.layoutVertexArray2,Gu)),this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,qu),this.indexBuffer=t.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(t),this.uploaded=!0;}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy());}lineFeatureClips(t){if(t.properties&&t.properties.hasOwnProperty("mapbox_clip_start")&&t.properties.hasOwnProperty("mapbox_clip_end"))return {start:+t.properties.mapbox_clip_start,end:+t.properties.mapbox_clip_end}}addFeature(t,e,r,n,i,s){const a=this.layers[0].layout,o=a.get("line-join").evaluate(t,{}),l=a.get("line-cap").evaluate(t,{}),u=a.get("line-miter-limit"),c=a.get("line-round-limit");this.lineClips=this.lineFeatureClips(t);for(const r of e)this.addLine(r,t,o,l,u,c);this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,i,s,n);}addLine(t,e,r,n,i,s){if(this.distance=0,this.scaledDistance=0,this.totalDistance=0,this.lineSoFar=0,this.lineClips){this.lineClipsArray.push(this.lineClips);for(let e=0;e<t.length-1;e++)this.totalDistance+=t[e].dist(t[e+1]);this.updateScaledDistance(),this.maxLineLength=Math.max(this.maxLineLength,this.totalDistance);}const a="Polygon"===Zu[e.type];let o=t.length;for(;o>=2&&t[o-1].equals(t[o-2]);)o--;let l=0;for(;l<o-1&&t[l].equals(t[l+1]);)l++;if(o<(a?3:2))return;"bevel"===r&&(i=1.05);const u=this.overscaling<=16?122880/(512*this.overscaling):0,c=this.segments.prepareSegment(10*o,this.layoutVertexArray,this.indexArray);let h,p,d,f,y;this.e1=this.e2=-1,a&&(h=t[o-2],y=t[l].sub(h)._unit()._perp());for(let e=l;e<o;e++){if(d=e===o-1?a?t[l+1]:void 0:t[e+1],d&&t[e].equals(d))continue;y&&(f=y),h&&(p=h),h=t[e],y=d?d.sub(h)._unit()._perp():f,f=f||y;let m=f.add(y);0===m.x&&0===m.y||m._unit();const g=f.x*y.x+f.y*y.y,x=m.x*y.x+m.y*y.y,v=0!==x?1/x:1/0,b=2*Math.sqrt(2-2*x),w=x<Xu&&p&&d,_=f.x*y.y-f.y*y.x>0;if(w&&e>l){const t=h.dist(p);if(t>2*u){const e=h.sub(h.sub(p)._mult(u/t)._round());this.updateDistance(p,e),this.addCurrentVertex(e,f,0,0,c),p=e;}}const A=p&&d;let k=A?r:a?"butt":n;if(A&&"round"===k&&(v<s?k="miter":v<=2&&(k="fakeround")),"miter"===k&&v>i&&(k="bevel"),"bevel"===k&&(v>2&&(k="flipbevel"),v<i&&(k="miter")),p&&this.updateDistance(p,h),"miter"===k)m._mult(v),this.addCurrentVertex(h,m,0,0,c);else if("flipbevel"===k){if(v>100)m=y.mult(-1);else {const t=v*f.add(y).mag()/f.sub(y).mag();m._perp()._mult(t*(_?-1:1));}this.addCurrentVertex(h,m,0,0,c),this.addCurrentVertex(h,m.mult(-1),0,0,c);}else if("bevel"===k||"fakeround"===k){const t=-Math.sqrt(v*v-1),e=_?t:0,r=_?0:t;if(p&&this.addCurrentVertex(h,f,e,r,c),"fakeround"===k){const t=Math.round(180*b/Math.PI/20);for(let e=1;e<t;e++){let r=e/t;if(.5!==r){const t=r-.5;r+=r*t*(r-1)*((1.0904+g*(g*(3.55645-1.43519*g)-3.2452))*t*t+(.848013+g*(.215638*g-1.06021)));}const n=y.sub(f)._mult(r)._add(f)._unit()._mult(_?-1:1);this.addHalfVertex(h,n.x,n.y,!1,_,0,c);}}d&&this.addCurrentVertex(h,y,-e,-r,c);}else if("butt"===k)this.addCurrentVertex(h,m,0,0,c);else if("square"===k){const t=p?1:-1;p||this.addCurrentVertex(h,m,t,t,c),this.addCurrentVertex(h,m,0,0,c),p&&this.addCurrentVertex(h,m,t,t,c);}else "round"===k&&(p&&(this.addCurrentVertex(h,f,0,0,c),this.addCurrentVertex(h,f,1,1,c,!0)),d&&(this.addCurrentVertex(h,y,-1,-1,c,!0),this.addCurrentVertex(h,y,0,0,c)));if(w&&e<o-1){const t=h.dist(d);if(t>2*u){const e=h.add(d.sub(h)._mult(u/t)._round());this.updateDistance(h,e),this.addCurrentVertex(e,y,0,0,c),h=e;}}}}addCurrentVertex(t,e,r,n,i,s=!1){const a=e.y*n-e.x,o=-e.y-e.x*n;this.addHalfVertex(t,e.x+e.y*r,e.y-e.x*r,s,!1,r,i),this.addHalfVertex(t,a,o,s,!0,-n,i);}addHalfVertex({x:t,y:e},r,n,i,s,a,o){this.layoutVertexArray.emplaceBack((t<<1)+(i?1:0),(e<<1)+(s?1:0),Math.round(63*r)+128,Math.round(63*n)+128,1+(0===a?0:a<0?-1:1),0,this.lineSoFar),this.lineClips&&this.layoutVertexArray2.emplaceBack(this.scaledDistance,this.lineClipsArray.length,this.lineSoFar);const l=o.vertexLength++;this.e1>=0&&this.e2>=0&&(this.indexArray.emplaceBack(this.e1,this.e2,l),o.primitiveLength++),s?this.e2=l:this.e1=l;}updateScaledDistance(){if(this.lineClips){const t=this.totalDistance/(this.lineClips.end-this.lineClips.start);this.scaledDistance=this.distance/this.totalDistance,this.lineSoFar=t*this.lineClips.start+this.distance;}else this.lineSoFar=this.distance;}updateDistance(t,e){this.distance+=t.dist(e),this.updateScaledDistance();}}Zi("LineBucket",Ku,{omit:["layers","patternFeatures"]});const Yu=new sa({"line-cap":new ea(ve.layout_line["line-cap"]),"line-join":new ea(ve.layout_line["line-join"]),"line-miter-limit":new ta(ve.layout_line["line-miter-limit"]),"line-round-limit":new ta(ve.layout_line["line-round-limit"]),"line-sort-key":new ea(ve.layout_line["line-sort-key"])});var Hu={paint:new sa({"line-opacity":new ea(ve.paint_line["line-opacity"]),"line-color":new ea(ve.paint_line["line-color"]),"line-translate":new ta(ve.paint_line["line-translate"]),"line-translate-anchor":new ta(ve.paint_line["line-translate-anchor"]),"line-width":new ea(ve.paint_line["line-width"]),"line-gap-width":new ea(ve.paint_line["line-gap-width"]),"line-offset":new ea(ve.paint_line["line-offset"]),"line-blur":new ea(ve.paint_line["line-blur"]),"line-dasharray":new ra(ve.paint_line["line-dasharray"]),"line-pattern":new ra(ve.paint_line["line-pattern"]),"line-gradient":new ia(ve.paint_line["line-gradient"])}),layout:Yu};const Ju=new class extends ea{possiblyEvaluate(t,e){return e=new Gs(Math.floor(e.zoom),{now:e.now,fadeDuration:e.fadeDuration,zoomHistory:e.zoomHistory,transition:e.transition}),super.possiblyEvaluate(t,e)}evaluate(t,e,r,n){return e=tt({},e,{zoom:Math.floor(e.zoom)}),super.evaluate(t,e,r,n)}}(Hu.paint.properties["line-width"].specification);function Wu(t,e){return e>0?e+2*t:t}Ju.useIntegerZoom=!0;const Qu=ca([{name:"a_pos_offset",components:4,type:"Int16"},{name:"a_tex_size",components:4,type:"Uint16"},{name:"a_pixeloffset",components:4,type:"Int16"},{name:"a_z_tile_anchor",components:4,type:"Int16"}],4),tc=ca([{name:"a_projected_pos",components:3,type:"Float32"}],4);ca([{name:"a_fade_opacity",components:1,type:"Uint32"}],4);const ec=ca([{name:"a_placed",components:2,type:"Uint8"},{name:"a_shift",components:2,type:"Float32"}]),rc=ca([{name:"a_size_scale",components:1,type:"Float32"},{name:"a_padding",components:2,type:"Float32"}]);ca([{type:"Int16",name:"projectedAnchorX"},{type:"Int16",name:"projectedAnchorY"},{type:"Int16",name:"projectedAnchorZ"},{type:"Int16",name:"tileAnchorX"},{type:"Int16",name:"tileAnchorY"},{type:"Float32",name:"x1"},{type:"Float32",name:"y1"},{type:"Float32",name:"x2"},{type:"Float32",name:"y2"},{type:"Int16",name:"padding"},{type:"Uint32",name:"featureIndex"},{type:"Uint16",name:"sourceLayerIndex"},{type:"Uint16",name:"bucketIndex"}]);const nc=ca([{name:"a_pos",components:3,type:"Int16"},{name:"a_anchor_pos",components:2,type:"Int16"},{name:"a_extrude",components:2,type:"Int16"}],4),ic=ca([{name:"a_pos_2f",components:2,type:"Float32"},{name:"a_radius",components:1,type:"Float32"},{name:"a_flags",components:2,type:"Int16"}],4);ca([{name:"triangle",components:3,type:"Uint16"}]),ca([{type:"Int16",name:"projectedAnchorX"},{type:"Int16",name:"projectedAnchorY"},{type:"Int16",name:"projectedAnchorZ"},{type:"Float32",name:"tileAnchorX"},{type:"Float32",name:"tileAnchorY"},{type:"Uint16",name:"glyphStartIndex"},{type:"Uint16",name:"numGlyphs"},{type:"Uint32",name:"vertexStartIndex"},{type:"Uint32",name:"lineStartIndex"},{type:"Uint32",name:"lineLength"},{type:"Uint16",name:"segment"},{type:"Uint16",name:"lowerSize"},{type:"Uint16",name:"upperSize"},{type:"Float32",name:"lineOffsetX"},{type:"Float32",name:"lineOffsetY"},{type:"Uint8",name:"writingMode"},{type:"Uint8",name:"placedOrientation"},{type:"Uint8",name:"hidden"},{type:"Uint32",name:"crossTileID"},{type:"Int16",name:"associatedIconIndex"},{type:"Uint8",name:"flipState"}]),ca([{type:"Int16",name:"projectedAnchorX"},{type:"Int16",name:"projectedAnchorY"},{type:"Int16",name:"projectedAnchorZ"},{type:"Float32",name:"tileAnchorX"},{type:"Float32",name:"tileAnchorY"},{type:"Int16",name:"rightJustifiedTextSymbolIndex"},{type:"Int16",name:"centerJustifiedTextSymbolIndex"},{type:"Int16",name:"leftJustifiedTextSymbolIndex"},{type:"Int16",name:"verticalPlacedTextSymbolIndex"},{type:"Int16",name:"placedIconSymbolIndex"},{type:"Int16",name:"verticalPlacedIconSymbolIndex"},{type:"Uint16",name:"key"},{type:"Uint16",name:"textBoxStartIndex"},{type:"Uint16",name:"textBoxEndIndex"},{type:"Uint16",name:"verticalTextBoxStartIndex"},{type:"Uint16",name:"verticalTextBoxEndIndex"},{type:"Uint16",name:"iconBoxStartIndex"},{type:"Uint16",name:"iconBoxEndIndex"},{type:"Uint16",name:"verticalIconBoxStartIndex"},{type:"Uint16",name:"verticalIconBoxEndIndex"},{type:"Uint16",name:"featureIndex"},{type:"Uint16",name:"numHorizontalGlyphVertices"},{type:"Uint16",name:"numVerticalGlyphVertices"},{type:"Uint16",name:"numIconVertices"},{type:"Uint16",name:"numVerticalIconVertices"},{type:"Uint16",name:"useRuntimeCollisionCircles"},{type:"Uint32",name:"crossTileID"},{type:"Float32",components:2,name:"textOffset"},{type:"Float32",name:"collisionCircleDiameter"}]),ca([{type:"Float32",name:"offsetX"}]),ca([{type:"Int16",name:"x"},{type:"Int16",name:"y"},{type:"Int16",name:"tileUnitDistanceFromAnchor"}]);var sc=24;const ac=128;function oc(t,e){const{expression:r}=e;if("constant"===r.kind)return {kind:"constant",layoutSize:r.evaluate(new Gs(t+1))};if("source"===r.kind)return {kind:"source"};{const{zoomStops:e,interpolationType:n}=r;let i=0;for(;i<e.length&&e[i]<=t;)i++;i=Math.max(0,i-1);let s=i;for(;s<e.length&&e[s]<t+1;)s++;s=Math.min(e.length-1,s);const a=e[i],o=e[s];return "composite"===r.kind?{kind:"composite",minZoom:a,maxZoom:o,interpolationType:n}:{kind:"camera",minZoom:a,maxZoom:o,minSize:r.evaluate(new Gs(a)),maxSize:r.evaluate(new Gs(o)),interpolationType:n}}}function lc(t,{uSize:e,uSizeT:r},{lowerSize:n,upperSize:i}){return "source"===t.kind?n/ac:"composite"===t.kind?Lr(n/ac,i/ac,r):e}function uc(t,e){let r=0,n=0;if("constant"===t.kind)n=t.layoutSize;else if("source"!==t.kind){const{interpolationType:i,minZoom:s,maxZoom:a}=t,o=i?Y(rn.interpolationFactor(i,e,s,a),0,1):0;"camera"===t.kind?n=Lr(t.minSize,t.maxSize,o):r=o;}return {uSizeT:r,uSize:n}}var cc=Object.freeze({__proto__:null,getSizeData:oc,evaluateSizeForFeature:lc,evaluateSizeForZoom:uc,SIZE_PACK_FACTOR:ac});function hc(t,e,r){return t.sections.forEach((t=>{t.text=function(t,e,r){const n=e.layout.get("text-transform").evaluate(r,{});return "uppercase"===n?t=t.toLocaleUpperCase():"lowercase"===n&&(t=t.toLocaleLowerCase()),Ns.applyArabicShaping&&(t=Ns.applyArabicShaping(t)),t}(t.text,e,r);})),t}const pc={"!":"︕","#":"＃",$:"＄","%":"％","&":"＆","(":"︵",")":"︶","*":"＊","+":"＋",",":"︐","-":"︲",".":"・","/":"／",":":"︓",";":"︔","<":"︿","=":"＝",">":"﹀","?":"︖","@":"＠","[":"﹇","\\":"＼","]":"﹈","^":"＾",_:"︳","`":"｀","{":"︷","|":"―","}":"︸","~":"～","¢":"￠","£":"￡","¥":"￥","¦":"￤","¬":"￢","¯":"￣","–":"︲","—":"︱","‘":"﹃","’":"﹄","“":"﹁","”":"﹂","…":"︙","‧":"・","₩":"￦","、":"︑","。":"︒","〈":"︿","〉":"﹀","《":"︽","》":"︾","「":"﹁","」":"﹂","『":"﹃","』":"﹄","【":"︻","】":"︼","〔":"︹","〕":"︺","〖":"︗","〗":"︘","！":"︕","（":"︵","）":"︶","，":"︐","－":"︲","．":"・","：":"︓","；":"︔","＜":"︿","＞":"﹀","？":"︖","［":"﹇","］":"﹈","＿":"︳","｛":"︷","｜":"―","｝":"︸","｟":"︵","｠":"︶","｡":"︒","｢":"﹁","｣":"﹂"};function dc(t){return "︶"===t||"﹈"===t||"︸"===t||"﹄"===t||"﹂"===t||"︾"===t||"︼"===t||"︺"===t||"︘"===t||"﹀"===t||"︐"===t||"︓"===t||"︔"===t||"｀"===t||"￣"===t||"︑"===t||"︒"===t}function fc(t){return "︵"===t||"﹇"===t||"︷"===t||"﹃"===t||"﹁"===t||"︽"===t||"︻"===t||"︹"===t||"︗"===t||"︿"===t}var yc=function(t,e,r,n,i){var s,a,o=8*i-n-1,l=(1<<o)-1,u=l>>1,c=-7,h=r?i-1:0,p=r?-1:1,d=t[e+h];for(h+=p,s=d&(1<<-c)-1,d>>=-c,c+=o;c>0;s=256*s+t[e+h],h+=p,c-=8);for(a=s&(1<<-c)-1,s>>=-c,c+=n;c>0;a=256*a+t[e+h],h+=p,c-=8);if(0===s)s=1-u;else {if(s===l)return a?NaN:1/0*(d?-1:1);a+=Math.pow(2,n),s-=u;}return (d?-1:1)*a*Math.pow(2,s-n)},mc=function(t,e,r,n,i,s){var a,o,l,u=8*s-i-1,c=(1<<u)-1,h=c>>1,p=23===i?Math.pow(2,-24)-Math.pow(2,-77):0,d=n?0:s-1,f=n?1:-1,y=e<0||0===e&&1/e<0?1:0;for(e=Math.abs(e),isNaN(e)||e===1/0?(o=isNaN(e)?1:0,a=c):(a=Math.floor(Math.log(e)/Math.LN2),e*(l=Math.pow(2,-a))<1&&(a--,l*=2),(e+=a+h>=1?p/l:p*Math.pow(2,1-h))*l>=2&&(a++,l/=2),a+h>=c?(o=0,a=c):a+h>=1?(o=(e*l-1)*Math.pow(2,i),a+=h):(o=e*Math.pow(2,h-1)*Math.pow(2,i),a=0));i>=8;t[r+d]=255&o,d+=f,o/=256,i-=8);for(a=a<<i|o,u+=i;u>0;t[r+d]=255&a,d+=f,a/=256,u-=8);t[r+d-f]|=128*y;},gc=xc;function xc(t){this.buf=ArrayBuffer.isView&&ArrayBuffer.isView(t)?t:new Uint8Array(t||0),this.pos=0,this.type=0,this.length=this.buf.length;}xc.Varint=0,xc.Fixed64=1,xc.Bytes=2,xc.Fixed32=5;var vc=4294967296,bc=1/vc,wc="undefined"==typeof TextDecoder?null:new TextDecoder("utf8");function _c(t){return t.type===xc.Bytes?t.readVarint()+t.pos:t.pos+1}function Ac(t,e,r){return r?4294967296*e+(t>>>0):4294967296*(e>>>0)+(t>>>0)}function kc(t,e,r){var n=e<=16383?1:e<=2097151?2:e<=268435455?3:Math.floor(Math.log(e)/(7*Math.LN2));r.realloc(n);for(var i=r.pos-1;i>=t;i--)r.buf[i+n]=r.buf[i];}function Sc(t,e){for(var r=0;r<t.length;r++)e.writeVarint(t[r]);}function Ic(t,e){for(var r=0;r<t.length;r++)e.writeSVarint(t[r]);}function zc(t,e){for(var r=0;r<t.length;r++)e.writeFloat(t[r]);}function Mc(t,e){for(var r=0;r<t.length;r++)e.writeDouble(t[r]);}function Tc(t,e){for(var r=0;r<t.length;r++)e.writeBoolean(t[r]);}function Bc(t,e){for(var r=0;r<t.length;r++)e.writeFixed32(t[r]);}function Cc(t,e){for(var r=0;r<t.length;r++)e.writeSFixed32(t[r]);}function Pc(t,e){for(var r=0;r<t.length;r++)e.writeFixed64(t[r]);}function Ec(t,e){for(var r=0;r<t.length;r++)e.writeSFixed64(t[r]);}function Dc(t,e){return (t[e]|t[e+1]<<8|t[e+2]<<16)+16777216*t[e+3]}function Vc(t,e,r){t[r]=e,t[r+1]=e>>>8,t[r+2]=e>>>16,t[r+3]=e>>>24;}function Fc(t,e){return (t[e]|t[e+1]<<8|t[e+2]<<16)+(t[e+3]<<24)}function Lc(t,e,r){e.glyphs=[],1===t&&r.readMessage(Rc,e);}function Rc(t,e,r){if(3===t){const{id:t,bitmap:n,width:i,height:s,left:a,top:o,advance:l}=r.readMessage(Uc,{});e.glyphs.push({id:t,bitmap:new zl({width:i+6,height:s+6},n),metrics:{width:i,height:s,left:a,top:o,advance:l}});}else 4===t?e.ascender=r.readSVarint():5===t&&(e.descender=r.readSVarint());}function Uc(t,e,r){1===t?e.id=r.readVarint():2===t?e.bitmap=r.readBytes():3===t?e.width=r.readVarint():4===t?e.height=r.readVarint():5===t?e.left=r.readSVarint():6===t?e.top=r.readSVarint():7===t&&(e.advance=r.readVarint());}function $c(t){let e=0,r=0;for(const n of t)e+=n.w*n.h,r=Math.max(r,n.w);t.sort(((t,e)=>e.h-t.h));const n=[{x:0,y:0,w:Math.max(Math.ceil(Math.sqrt(e/.95)),r),h:1/0}];let i=0,s=0;for(const e of t)for(let t=n.length-1;t>=0;t--){const r=n[t];if(!(e.w>r.w||e.h>r.h)){if(e.x=r.x,e.y=r.y,s=Math.max(s,e.y+e.h),i=Math.max(i,e.x+e.w),e.w===r.w&&e.h===r.h){const e=n.pop();t<n.length&&(n[t]=e);}else e.h===r.h?(r.x+=e.w,r.w-=e.w):e.w===r.w?(r.y+=e.h,r.h-=e.h):(n.push({x:r.x+e.w,y:r.y,w:r.w-e.w,h:e.h}),r.y+=e.h,r.h-=e.h);break}}return {w:i,h:s,fill:e/(i*s)||0}}xc.prototype={destroy:function(){this.buf=null;},readFields:function(t,e,r){for(r=r||this.length;this.pos<r;){var n=this.readVarint(),i=n>>3,s=this.pos;this.type=7&n,t(i,e,this),this.pos===s&&this.skip(n);}return e},readMessage:function(t,e){return this.readFields(t,e,this.readVarint()+this.pos)},readFixed32:function(){var t=Dc(this.buf,this.pos);return this.pos+=4,t},readSFixed32:function(){var t=Fc(this.buf,this.pos);return this.pos+=4,t},readFixed64:function(){var t=Dc(this.buf,this.pos)+Dc(this.buf,this.pos+4)*vc;return this.pos+=8,t},readSFixed64:function(){var t=Dc(this.buf,this.pos)+Fc(this.buf,this.pos+4)*vc;return this.pos+=8,t},readFloat:function(){var t=yc(this.buf,this.pos,!0,23,4);return this.pos+=4,t},readDouble:function(){var t=yc(this.buf,this.pos,!0,52,8);return this.pos+=8,t},readVarint:function(t){var e,r,n=this.buf;return e=127&(r=n[this.pos++]),r<128?e:(e|=(127&(r=n[this.pos++]))<<7,r<128?e:(e|=(127&(r=n[this.pos++]))<<14,r<128?e:(e|=(127&(r=n[this.pos++]))<<21,r<128?e:function(t,e,r){var n,i,s=r.buf;if(n=(112&(i=s[r.pos++]))>>4,i<128)return Ac(t,n,e);if(n|=(127&(i=s[r.pos++]))<<3,i<128)return Ac(t,n,e);if(n|=(127&(i=s[r.pos++]))<<10,i<128)return Ac(t,n,e);if(n|=(127&(i=s[r.pos++]))<<17,i<128)return Ac(t,n,e);if(n|=(127&(i=s[r.pos++]))<<24,i<128)return Ac(t,n,e);if(n|=(1&(i=s[r.pos++]))<<31,i<128)return Ac(t,n,e);throw new Error("Expected varint not more than 10 bytes")}(e|=(15&(r=n[this.pos]))<<28,t,this))))},readVarint64:function(){return this.readVarint(!0)},readSVarint:function(){var t=this.readVarint();return t%2==1?(t+1)/-2:t/2},readBoolean:function(){return Boolean(this.readVarint())},readString:function(){var t=this.readVarint()+this.pos,e=this.pos;return this.pos=t,t-e>=12&&wc?function(t,e,r){return wc.decode(t.subarray(e,r))}(this.buf,e,t):function(t,e,r){for(var n="",i=e;i<r;){var s,a,o,l=t[i],u=null,c=l>239?4:l>223?3:l>191?2:1;if(i+c>r)break;1===c?l<128&&(u=l):2===c?128==(192&(s=t[i+1]))&&(u=(31&l)<<6|63&s)<=127&&(u=null):3===c?(a=t[i+2],128==(192&(s=t[i+1]))&&128==(192&a)&&((u=(15&l)<<12|(63&s)<<6|63&a)<=2047||u>=55296&&u<=57343)&&(u=null)):4===c&&(a=t[i+2],o=t[i+3],128==(192&(s=t[i+1]))&&128==(192&a)&&128==(192&o)&&((u=(15&l)<<18|(63&s)<<12|(63&a)<<6|63&o)<=65535||u>=1114112)&&(u=null)),null===u?(u=65533,c=1):u>65535&&(u-=65536,n+=String.fromCharCode(u>>>10&1023|55296),u=56320|1023&u),n+=String.fromCharCode(u),i+=c;}return n}(this.buf,e,t)},readBytes:function(){var t=this.readVarint()+this.pos,e=this.buf.subarray(this.pos,t);return this.pos=t,e},readPackedVarint:function(t,e){if(this.type!==xc.Bytes)return t.push(this.readVarint(e));var r=_c(this);for(t=t||[];this.pos<r;)t.push(this.readVarint(e));return t},readPackedSVarint:function(t){if(this.type!==xc.Bytes)return t.push(this.readSVarint());var e=_c(this);for(t=t||[];this.pos<e;)t.push(this.readSVarint());return t},readPackedBoolean:function(t){if(this.type!==xc.Bytes)return t.push(this.readBoolean());var e=_c(this);for(t=t||[];this.pos<e;)t.push(this.readBoolean());return t},readPackedFloat:function(t){if(this.type!==xc.Bytes)return t.push(this.readFloat());var e=_c(this);for(t=t||[];this.pos<e;)t.push(this.readFloat());return t},readPackedDouble:function(t){if(this.type!==xc.Bytes)return t.push(this.readDouble());var e=_c(this);for(t=t||[];this.pos<e;)t.push(this.readDouble());return t},readPackedFixed32:function(t){if(this.type!==xc.Bytes)return t.push(this.readFixed32());var e=_c(this);for(t=t||[];this.pos<e;)t.push(this.readFixed32());return t},readPackedSFixed32:function(t){if(this.type!==xc.Bytes)return t.push(this.readSFixed32());var e=_c(this);for(t=t||[];this.pos<e;)t.push(this.readSFixed32());return t},readPackedFixed64:function(t){if(this.type!==xc.Bytes)return t.push(this.readFixed64());var e=_c(this);for(t=t||[];this.pos<e;)t.push(this.readFixed64());return t},readPackedSFixed64:function(t){if(this.type!==xc.Bytes)return t.push(this.readSFixed64());var e=_c(this);for(t=t||[];this.pos<e;)t.push(this.readSFixed64());return t},skip:function(t){var e=7&t;if(e===xc.Varint)for(;this.buf[this.pos++]>127;);else if(e===xc.Bytes)this.pos=this.readVarint()+this.pos;else if(e===xc.Fixed32)this.pos+=4;else {if(e!==xc.Fixed64)throw new Error("Unimplemented type: "+e);this.pos+=8;}},writeTag:function(t,e){this.writeVarint(t<<3|e);},realloc:function(t){for(var e=this.length||16;e<this.pos+t;)e*=2;if(e!==this.length){var r=new Uint8Array(e);r.set(this.buf),this.buf=r,this.length=e;}},finish:function(){return this.length=this.pos,this.pos=0,this.buf.subarray(0,this.length)},writeFixed32:function(t){this.realloc(4),Vc(this.buf,t,this.pos),this.pos+=4;},writeSFixed32:function(t){this.realloc(4),Vc(this.buf,t,this.pos),this.pos+=4;},writeFixed64:function(t){this.realloc(8),Vc(this.buf,-1&t,this.pos),Vc(this.buf,Math.floor(t*bc),this.pos+4),this.pos+=8;},writeSFixed64:function(t){this.realloc(8),Vc(this.buf,-1&t,this.pos),Vc(this.buf,Math.floor(t*bc),this.pos+4),this.pos+=8;},writeVarint:function(t){(t=+t||0)>268435455||t<0?function(t,e){var r,n;if(t>=0?(r=t%4294967296|0,n=t/4294967296|0):(n=~(-t/4294967296),4294967295^(r=~(-t%4294967296))?r=r+1|0:(r=0,n=n+1|0)),t>=0x10000000000000000||t<-0x10000000000000000)throw new Error("Given varint doesn't fit into 10 bytes");e.realloc(10),function(t,e,r){r.buf[r.pos++]=127&t|128,t>>>=7,r.buf[r.pos++]=127&t|128,t>>>=7,r.buf[r.pos++]=127&t|128,t>>>=7,r.buf[r.pos++]=127&t|128,r.buf[r.pos]=127&(t>>>=7);}(r,0,e),function(t,e){var r=(7&t)<<4;e.buf[e.pos++]|=r|((t>>>=3)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t)))));}(n,e);}(t,this):(this.realloc(4),this.buf[this.pos++]=127&t|(t>127?128:0),t<=127||(this.buf[this.pos++]=127&(t>>>=7)|(t>127?128:0),t<=127||(this.buf[this.pos++]=127&(t>>>=7)|(t>127?128:0),t<=127||(this.buf[this.pos++]=t>>>7&127))));},writeSVarint:function(t){this.writeVarint(t<0?2*-t-1:2*t);},writeBoolean:function(t){this.writeVarint(Boolean(t));},writeString:function(t){t=String(t),this.realloc(4*t.length),this.pos++;var e=this.pos;this.pos=function(t,e,r){for(var n,i,s=0;s<e.length;s++){if((n=e.charCodeAt(s))>55295&&n<57344){if(!i){n>56319||s+1===e.length?(t[r++]=239,t[r++]=191,t[r++]=189):i=n;continue}if(n<56320){t[r++]=239,t[r++]=191,t[r++]=189,i=n;continue}n=i-55296<<10|n-56320|65536,i=null;}else i&&(t[r++]=239,t[r++]=191,t[r++]=189,i=null);n<128?t[r++]=n:(n<2048?t[r++]=n>>6|192:(n<65536?t[r++]=n>>12|224:(t[r++]=n>>18|240,t[r++]=n>>12&63|128),t[r++]=n>>6&63|128),t[r++]=63&n|128);}return r}(this.buf,t,this.pos);var r=this.pos-e;r>=128&&kc(e,r,this),this.pos=e-1,this.writeVarint(r),this.pos+=r;},writeFloat:function(t){this.realloc(4),mc(this.buf,t,this.pos,!0,23,4),this.pos+=4;},writeDouble:function(t){this.realloc(8),mc(this.buf,t,this.pos,!0,52,8),this.pos+=8;},writeBytes:function(t){var e=t.length;this.writeVarint(e),this.realloc(e);for(var r=0;r<e;r++)this.buf[this.pos++]=t[r];},writeRawMessage:function(t,e){this.pos++;var r=this.pos;t(e,this);var n=this.pos-r;n>=128&&kc(r,n,this),this.pos=r-1,this.writeVarint(n),this.pos+=n;},writeMessage:function(t,e,r){this.writeTag(t,xc.Bytes),this.writeRawMessage(e,r);},writePackedVarint:function(t,e){e.length&&this.writeMessage(t,Sc,e);},writePackedSVarint:function(t,e){e.length&&this.writeMessage(t,Ic,e);},writePackedBoolean:function(t,e){e.length&&this.writeMessage(t,Tc,e);},writePackedFloat:function(t,e){e.length&&this.writeMessage(t,zc,e);},writePackedDouble:function(t,e){e.length&&this.writeMessage(t,Mc,e);},writePackedFixed32:function(t,e){e.length&&this.writeMessage(t,Bc,e);},writePackedSFixed32:function(t,e){e.length&&this.writeMessage(t,Cc,e);},writePackedFixed64:function(t,e){e.length&&this.writeMessage(t,Pc,e);},writePackedSFixed64:function(t,e){e.length&&this.writeMessage(t,Ec,e);},writeBytesField:function(t,e){this.writeTag(t,xc.Bytes),this.writeBytes(e);},writeFixed32Field:function(t,e){this.writeTag(t,xc.Fixed32),this.writeFixed32(e);},writeSFixed32Field:function(t,e){this.writeTag(t,xc.Fixed32),this.writeSFixed32(e);},writeFixed64Field:function(t,e){this.writeTag(t,xc.Fixed64),this.writeFixed64(e);},writeSFixed64Field:function(t,e){this.writeTag(t,xc.Fixed64),this.writeSFixed64(e);},writeVarintField:function(t,e){this.writeTag(t,xc.Varint),this.writeVarint(e);},writeSVarintField:function(t,e){this.writeTag(t,xc.Varint),this.writeSVarint(e);},writeStringField:function(t,e){this.writeTag(t,xc.Bytes),this.writeString(e);},writeFloatField:function(t,e){this.writeTag(t,xc.Fixed32),this.writeFloat(e);},writeDoubleField:function(t,e){this.writeTag(t,xc.Fixed64),this.writeDouble(e);},writeBooleanField:function(t,e){this.writeVarintField(t,Boolean(e));}};class Oc{constructor(t,{pixelRatio:e,version:r,stretchX:n,stretchY:i,content:s}){this.paddedRect=t,this.pixelRatio=e,this.stretchX=n,this.stretchY=i,this.content=s,this.version=r;}get tl(){return [this.paddedRect.x+1,this.paddedRect.y+1]}get br(){return [this.paddedRect.x+this.paddedRect.w-1,this.paddedRect.y+this.paddedRect.h-1]}get displaySize(){return [(this.paddedRect.w-2)/this.pixelRatio,(this.paddedRect.h-2)/this.pixelRatio]}}class jc{constructor(t,e){const r={},n={};this.haveRenderCallbacks=[];const i=[];this.addImages(t,r,i),this.addImages(e,n,i);const{w:s,h:a}=$c(i),o=new Ml({width:s||1,height:a||1});for(const e in t){const n=t[e],i=r[e].paddedRect;Ml.copy(n.data,o,{x:0,y:0},{x:i.x+1,y:i.y+1},n.data);}for(const t in e){const r=e[t],i=n[t].paddedRect,s=i.x+1,a=i.y+1,l=r.data.width,u=r.data.height;Ml.copy(r.data,o,{x:0,y:0},{x:s,y:a},r.data),Ml.copy(r.data,o,{x:0,y:u-1},{x:s,y:a-1},{width:l,height:1}),Ml.copy(r.data,o,{x:0,y:0},{x:s,y:a+u},{width:l,height:1}),Ml.copy(r.data,o,{x:l-1,y:0},{x:s-1,y:a},{width:1,height:u}),Ml.copy(r.data,o,{x:0,y:0},{x:s+l,y:a},{width:1,height:u});}this.image=o,this.iconPositions=r,this.patternPositions=n;}addImages(t,e,r){for(const n in t){const i=t[n],s={x:0,y:0,w:i.data.width+2,h:i.data.height+2};r.push(s),e[n]=new Oc(s,i),i.hasRenderCallback&&this.haveRenderCallbacks.push(n);}}patchUpdatedImages(t,e){t.dispatchRenderCallbacks(this.haveRenderCallbacks);for(const r in t.updatedImages)this.patchUpdatedImage(this.iconPositions[r],t.getImage(r),e),this.patchUpdatedImage(this.patternPositions[r],t.getImage(r),e);}patchUpdatedImage(t,e,r){if(!t||!e)return;if(t.version===e.version)return;t.version=e.version;const[n,i]=t.tl;r.update(e.data,void 0,{x:n,y:i});}}Zi("ImagePosition",Oc),Zi("ImageAtlas",jc);const qc={horizontal:1,vertical:2,horizontalOnly:3};class Nc{constructor(){this.scale=1,this.fontStack="",this.imageName=null;}static forText(t,e){const r=new Nc;return r.scale=t||1,r.fontStack=e,r}static forImage(t){const e=new Nc;return e.imageName=t,e}}class Gc{constructor(){this.text="",this.sectionIndex=[],this.sections=[],this.imageSectionID=null;}static fromFeature(t,e){const r=new Gc;for(let n=0;n<t.sections.length;n++){const i=t.sections[n];i.image?r.addImageSection(i):r.addTextSection(i,e);}return r}length(){return this.text.length}getSection(t){return this.sections[this.sectionIndex[t]]}getSections(){return this.sections}getSectionIndex(t){return this.sectionIndex[t]}getCharCode(t){return this.text.charCodeAt(t)}verticalizePunctuation(t){this.text=function(t,e){let r="";for(let n=0;n<t.length;n++){const i=t.charCodeAt(n+1)||null,s=t.charCodeAt(n-1)||null;r+=!e&&(i&&Ts(i)&&!pc[t[n+1]]||s&&Ts(s)&&!pc[t[n-1]])||!pc[t[n]]?t[n]:pc[t[n]];}return r}(this.text,t);}trim(){let t=0;for(let e=0;e<this.text.length&&Xc[this.text.charCodeAt(e)];e++)t++;let e=this.text.length;for(let r=this.text.length-1;r>=0&&r>=t&&Xc[this.text.charCodeAt(r)];r--)e--;this.text=this.text.substring(t,e),this.sectionIndex=this.sectionIndex.slice(t,e);}substring(t,e){const r=new Gc;return r.text=this.text.substring(t,e),r.sectionIndex=this.sectionIndex.slice(t,e),r.sections=this.sections,r}toString(){return this.text}getMaxScale(){return this.sectionIndex.reduce(((t,e)=>Math.max(t,this.sections[e].scale)),0)}addTextSection(t,e){this.text+=t.text,this.sections.push(Nc.forText(t.scale,t.fontStack||e));const r=this.sections.length-1;for(let e=0;e<t.text.length;++e)this.sectionIndex.push(r);}addImageSection(t){const e=t.image?t.image.name:"";if(0===e.length)return void pt("Can't add FormattedSection with an empty image.");const r=this.getNextImageSectionCharCode();r?(this.text+=String.fromCharCode(r),this.sections.push(Nc.forImage(e)),this.sectionIndex.push(this.sections.length-1)):pt("Reached maximum number of images 6401");}getNextImageSectionCharCode(){return this.imageSectionID?this.imageSectionID>=63743?null:++this.imageSectionID:(this.imageSectionID=57344,this.imageSectionID)}}function Zc(t,e,r,n,i,s,a,o,l,u,c,h,p,d,f,y){const m=Gc.fromFeature(t,i);let g;h===qc.vertical&&m.verticalizePunctuation(p);const{processBidirectionalText:x,processStyledBidirectionalText:v}=Ns;if(x&&1===m.sections.length){g=[];const t=x(m.toString(),th(m,u,s,e,n,d,f));for(const e of t){const t=new Gc;t.text=e,t.sections=m.sections;for(let r=0;r<e.length;r++)t.sectionIndex.push(0);g.push(t);}}else if(v){g=[];const t=v(m.text,m.sectionIndex,th(m,u,s,e,n,d,f));for(const e of t){const t=new Gc;t.text=e[0],t.sectionIndex=e[1],t.sections=m.sections,g.push(t);}}else g=function(t,e){const r=[],n=t.text;let i=0;for(const n of e)r.push(t.substring(i,n)),i=n;return i<n.length&&r.push(t.substring(i,n.length)),r}(m,th(m,u,s,e,n,d,f));const b=[],w={positionedLines:b,text:m.toString(),top:c[1],bottom:c[1],left:c[0],right:c[0],writingMode:h,iconsInText:!1,verticalizable:!1,hasBaseline:!1};return function(t,e,r,n,i,s,a,o,l,u,c,h){let p=0,d=0,f=0;const y="right"===o?1:"left"===o?0:.5;let m=!1;for(const t of i){const r=t.getSections();for(const t of r){if(t.imageName)continue;const r=e[t.fontStack];if(r&&(m=void 0!==r.ascender&&void 0!==r.descender,!m))break}if(!m)break}let g=0;for(const a of i){a.trim();const i=a.getMaxScale(),o=(i-1)*sc,v={positionedGlyphs:[],lineOffset:0};t.positionedLines[g]=v;const b=v.positionedGlyphs;let w=0;if(!a.length()){d+=s,++g;continue}let _=0,A=0;for(let s=0;s<a.length();s++){const o=a.getSection(s),f=a.getSectionIndex(s),y=a.getCharCode(s);let g=o.scale,v=null,k=null,S=null,I=sc,z=0;const M=!(l===qc.horizontal||!c&&!Ms(y)||c&&(Xc[y]||(x=y,Wi(x)||Qi(x)||ts(x)||vs(x)||As(x))));if(o.imageName){const e=n[o.imageName];if(!e)continue;S=o.imageName,t.iconsInText=t.iconsInText||!0,k=e.paddedRect;const r=e.displaySize;g=g*sc/h,v={width:r[0],height:r[1],left:1,top:-3,advance:M?r[1]:r[0],localGlyph:!1},z=m?-v.height*g:i*sc-17-r[1]*g,I=v.advance;const s=(M?r[0]:r[1])*g-sc*i;s>0&&s>w&&(w=s);}else {const t=r[o.fontStack];if(!t)continue;t[y]&&(k=t[y]);const n=e[o.fontStack];if(!n)continue;const s=n.glyphs[y];if(!s)continue;if(v=s.metrics,I=8203!==y?sc:0,m){const t=void 0!==n.ascender?Math.abs(n.ascender):0,e=void 0!==n.descender?Math.abs(n.descender):0,r=(t+e)*g;_<r&&(_=r,A=(t-e)/2*g),z=-t*g;}else z=(i-g)*sc-17;}M?(t.verticalizable=!0,b.push({glyph:y,imageName:S,x:p,y:d+z,vertical:M,scale:g,localGlyph:v.localGlyph,fontStack:o.fontStack,sectionIndex:f,metrics:v,rect:k}),p+=I*g+u):(b.push({glyph:y,imageName:S,x:p,y:d+z,vertical:M,scale:g,localGlyph:v.localGlyph,fontStack:o.fontStack,sectionIndex:f,metrics:v,rect:k}),p+=v.advance*g+u);}0!==b.length&&(f=Math.max(p-u,f),m?rh(b,y,w,A,s*i/2):rh(b,y,w,0,s/2)),p=0;const k=s*i+w;v.lineOffset=Math.max(w,o),d+=k,++g;}var x;const v=d,{horizontalAlign:b,verticalAlign:w}=eh(a);(function(t,e,r,n,i,s){const a=(e-r)*i,o=-s*n;for(const e of t)for(const t of e.positionedGlyphs)t.x+=a,t.y+=o;})(t.positionedLines,y,b,w,f,v),t.top+=-w*v,t.bottom=t.top+v,t.left+=-b*f,t.right=t.left+f,t.hasBaseline=m;}(w,e,r,n,g,a,o,l,h,u,p,y),!function(t){for(const e of t)if(0!==e.positionedGlyphs.length)return !1;return !0}(b)&&w}const Xc={9:!0,10:!0,11:!0,12:!0,13:!0,32:!0},Kc={10:!0,32:!0,38:!0,40:!0,41:!0,43:!0,45:!0,47:!0,173:!0,183:!0,8203:!0,8208:!0,8211:!0,8231:!0};function Yc(t,e,r,n,i,s){if(e.imageName){const t=n[e.imageName];return t?t.displaySize[0]*e.scale*sc/s+i:0}{const n=r[e.fontStack],s=n&&n.glyphs[t];return s?s.metrics.advance*e.scale+i:0}}function Hc(t,e,r,n){const i=Math.pow(t-e,2);return n?t<e?i/2:2*i:i+Math.abs(r)*r}function Jc(t,e,r){let n=0;return 10===t&&(n-=1e4),r&&(n+=150),40!==t&&65288!==t||(n+=50),41!==e&&65289!==e||(n+=50),n}function Wc(t,e,r,n,i,s){let a=null,o=Hc(e,r,i,s);for(const t of n){const n=Hc(e-t.x,r,i,s)+t.badness;n<=o&&(a=t,o=n);}return {index:t,x:e,priorBreak:a,badness:o}}function Qc(t){return t?Qc(t.priorBreak).concat(t.index):[]}function th(t,e,r,n,i,s,a){if("point"!==s)return [];if(!t)return [];const o=[],l=function(t,e,r,n,i,s){let a=0;for(let r=0;r<t.length();r++){const o=t.getSection(r);a+=Yc(t.getCharCode(r),o,n,i,e,s);}return a/Math.max(1,Math.ceil(a/r))}(t,e,r,n,i,a),u=t.text.indexOf("​")>=0;let c=0;for(let r=0;r<t.length();r++){const s=t.getSection(r),p=t.getCharCode(r);if(Xc[p]||(c+=Yc(p,s,n,i,e,a)),r<t.length()-1){const e=!((h=p)<11904||!(ls(h)||os(h)||ws(h)||xs(h)||ps(h)||es(h)||us(h)||is(h)||ds(h)||fs(h)||hs(h)||ks(h)||ss(h)||ns(h)||rs(h)||cs(h)||as(h)||bs(h)||ms(h)||ys(h)));(Kc[p]||e||s.imageName)&&o.push(Wc(r+1,c,l,o,Jc(p,t.getCharCode(r+1),e&&u),!1));}}var h;return Qc(Wc(t.length(),c,l,o,0,!0))}function eh(t){let e=.5,r=.5;switch(t){case"right":case"top-right":case"bottom-right":e=1;break;case"left":case"top-left":case"bottom-left":e=0;}switch(t){case"bottom":case"bottom-right":case"bottom-left":r=1;break;case"top":case"top-right":case"top-left":r=0;}return {horizontalAlign:e,verticalAlign:r}}function rh(t,e,r,n,i){if(!(e||r||n||i))return;const s=t.length-1,a=t[s],o=(a.x+a.metrics.advance*a.scale)*e;for(let e=0;e<=s;e++)t[e].x-=o,t[e].y+=r+n+i;}function nh(t,e,r){const{horizontalAlign:n,verticalAlign:i}=eh(r),s=e[0]-t.displaySize[0]*n,a=e[1]-t.displaySize[1]*i;return {image:t,top:a,bottom:a+t.displaySize[1],left:s,right:s+t.displaySize[0]}}function ih(t,e,r,n,i,s){const a=t.image;let o;if(a.content){const t=a.content,e=a.pixelRatio||1;o=[t[0]/e,t[1]/e,a.displaySize[0]-t[2]/e,a.displaySize[1]-t[3]/e];}const l=e.left*s,u=e.right*s;let c,h,p,d;"width"===r||"both"===r?(d=i[0]+l-n[3],h=i[0]+u+n[1]):(d=i[0]+(l+u-a.displaySize[0])/2,h=d+a.displaySize[0]);const f=e.top*s,y=e.bottom*s;return "height"===r||"both"===r?(c=i[1]+f-n[0],p=i[1]+y+n[2]):(c=i[1]+(f+y-a.displaySize[1])/2,p=c+a.displaySize[1]),{image:a,top:c,right:h,bottom:p,left:d,collisionPadding:o}}class sh extends i{constructor(t,e,r,n,i){super(t,e),this.angle=n,this.z=r,void 0!==i&&(this.segment=i);}clone(){return new sh(this.x,this.y,this.z,this.angle,this.segment)}}function ah(t,e,r,n,i){if(void 0===e.segment)return !0;let s=e,a=e.segment+1,o=0;for(;o>-r/2;){if(a--,a<0)return !1;o-=t[a].dist(s),s=t[a];}o+=t[a].dist(t[a+1]),a++;const l=[];let u=0;for(;o<r/2;){const e=t[a],r=t[a+1];if(!r)return !1;let s=t[a-1].angleTo(e)-e.angleTo(r);for(s=Math.abs((s+3*Math.PI)%(2*Math.PI)-Math.PI),l.push({distance:o,angleDelta:s}),u+=s;o-l[0].distance>n;)u-=l.shift().angleDelta;if(u>i)return !1;a++,o+=e.dist(r);}return !0}function oh(t){let e=0;for(let r=0;r<t.length-1;r++)e+=t[r].dist(t[r+1]);return e}function lh(t,e,r){return t?.6*e*r:0}function uh(t,e){return Math.max(t?t.right-t.left:0,e?e.right-e.left:0)}function ch(t,e,r,n,i,s){const a=lh(r,i,s),o=uh(r,n)*s;let l=0;const u=oh(t)/2;for(let r=0;r<t.length-1;r++){const n=t[r],i=t[r+1],s=n.dist(i);if(l+s>u){const c=(u-l)/s,h=Lr(n.x,i.x,c),p=Lr(n.y,i.y,c),d=new sh(h,p,0,i.angleTo(n),r);return !a||ah(t,d,o,a,e)?d:void 0}l+=s;}}function hh(t,e,r,n,i,s,a,o,l){const u=lh(n,s,a),c=uh(n,i),h=c*a,p=0===t[0].x||t[0].x===l||0===t[0].y||t[0].y===l;return e-h<e/4&&(e=h+e/4),ph(t,p?e/2*o%e:(c/2+2*s)*a*o%e,e,u,r,h,p,!1,l)}function ph(t,e,r,n,i,s,a,o,l){const u=s/2,c=oh(t);let h=0,p=e-r,d=[];for(let e=0;e<t.length-1;e++){const a=t[e],o=t[e+1],f=a.dist(o),y=o.angleTo(a);for(;p+r<h+f;){p+=r;const m=(p-h)/f,g=Lr(a.x,o.x,m),x=Lr(a.y,o.y,m);if(g>=0&&g<l&&x>=0&&x<l&&p-u>=0&&p+u<=c){const r=new sh(g,x,0,y,e);r._round(),n&&!ah(t,r,s,n,i)||d.push(r);}}h+=f;}return o||d.length||a||(d=ph(t,h/2,r,n,i,s,a,!0,l)),d}function dh(t,e,r,n,s){const a=[];for(let o=0;o<t.length;o++){const l=t[o];let u;for(let t=0;t<l.length-1;t++){let o=l[t],c=l[t+1];o.x<e&&c.x<e||(o.x<e?o=new i(e,o.y+(e-o.x)/(c.x-o.x)*(c.y-o.y))._round():c.x<e&&(c=new i(e,o.y+(e-o.x)/(c.x-o.x)*(c.y-o.y))._round()),o.y<r&&c.y<r||(o.y<r?o=new i(o.x+(r-o.y)/(c.y-o.y)*(c.x-o.x),r)._round():c.y<r&&(c=new i(o.x+(r-o.y)/(c.y-o.y)*(c.x-o.x),r)._round()),o.x>=n&&c.x>=n||(o.x>=n?o=new i(n,o.y+(n-o.x)/(c.x-o.x)*(c.y-o.y))._round():c.x>=n&&(c=new i(n,o.y+(n-o.x)/(c.x-o.x)*(c.y-o.y))._round()),o.y>=s&&c.y>=s||(o.y>=s?o=new i(o.x+(s-o.y)/(c.y-o.y)*(c.x-o.x),s)._round():c.y>=s&&(c=new i(o.x+(s-o.y)/(c.y-o.y)*(c.x-o.x),s)._round()),u&&o.equals(u[u.length-1])||(u=[o],a.push(u)),u.push(c)))));}}return a}Zi("Anchor",sh);const fh=1e20;function yh(t,e,r,n,i,s,a,o,l){for(let u=e;u<e+n;u++)mh(t,r*s+u,s,i,a,o,l);for(let u=r;u<r+i;u++)mh(t,u*s+e,1,n,a,o,l);}function mh(t,e,r,n,i,s,a){s[0]=0,a[0]=-fh,a[1]=fh,i[0]=t[e];for(let o=1,l=0,u=0;o<n;o++){i[o]=t[e+o*r];const n=o*o;do{const t=s[l];u=(i[o]-i[t]+n-t*t)/(o-t)/2;}while(u<=a[l]&&--l>-1);l++,s[l]=o,a[l]=u,a[l+1]=fh;}for(let o=0,l=0;o<n;o++){for(;a[l+1]<o;)l++;const n=s[l],u=o-n;t[e+o*r]=i[n]+u*u;}}const gh={none:0,ideographs:1,all:2};class xh{constructor(t,e,r){this.requestManager=t,this.localGlyphMode=e,this.localFontFamily=r,this.entries={},this.localGlyphs={200:{},400:{},500:{},900:{}};}setURL(t){this.url=t;}getGlyphs(t,e){const r=[];for(const e in t)for(const n of t[e])r.push({stack:e,id:n});W(r,(({stack:t,id:e},r)=>{let n=this.entries[t];n||(n=this.entries[t]={glyphs:{},requests:{},ranges:{},ascender:void 0,descender:void 0});let i=n.glyphs[e];if(void 0!==i)return void r(null,{stack:t,id:e,glyph:i});if(i=this._tinySDF(n,t,e),i)return n.glyphs[e]=i,void r(null,{stack:t,id:e,glyph:i});const s=Math.floor(e/256);if(256*s>65535)return void r(new Error("glyphs > 65535 not supported"));if(n.ranges[s])return void r(null,{stack:t,id:e,glyph:i});let a=n.requests[s];a||(a=n.requests[s]=[],xh.loadGlyphRange(t,s,this.url,this.requestManager,((t,e)=>{if(e){n.ascender=e.ascender,n.descender=e.descender;for(const t in e.glyphs)this._doesCharSupportLocalGlyph(+t)||(n.glyphs[+t]=e.glyphs[+t]);n.ranges[s]=!0;}for(const r of a)r(t,e);delete n.requests[s];}))),a.push(((n,i)=>{n?r(n):i&&r(null,{stack:t,id:e,glyph:i.glyphs[e]||null});}));}),((t,r)=>{if(t)e(t);else if(r){const t={};for(const{stack:e,id:n,glyph:i}of r)void 0===t[e]&&(t[e]={}),void 0===t[e].glyphs&&(t[e].glyphs={}),t[e].glyphs[n]=i&&{id:i.id,bitmap:i.bitmap.clone(),metrics:i.metrics},t[e].ascender=this.entries[e].ascender,t[e].descender=this.entries[e].descender;e(null,t);}}));}_doesCharSupportLocalGlyph(t){return this.localGlyphMode!==gh.none&&(this.localGlyphMode===gh.all?!!this.localFontFamily:!!this.localFontFamily&&(fs(t)||gs(t)||ss(t)||as(t))||is(t))}_tinySDF(t,e,r){const n=this.localFontFamily;if(!n||!this._doesCharSupportLocalGlyph(r))return;let i=t.tinySDF;if(!i){let r="400";/bold/i.test(e)?r="900":/medium/i.test(e)?r="500":/light/i.test(e)&&(r="200"),i=t.tinySDF=new xh.TinySDF({fontFamily:n,fontWeight:r,fontSize:48,buffer:6,radius:16}),i.fontWeight=r;}if(this.localGlyphs[i.fontWeight][r])return this.localGlyphs[i.fontWeight][r];const s=String.fromCharCode(r),{data:a,width:o,height:l,glyphWidth:u,glyphHeight:c,glyphLeft:h,glyphTop:p,glyphAdvance:d}=i.draw(s);return this.localGlyphs[i.fontWeight][r]={id:r,bitmap:new zl({width:o,height:l},a),metrics:{width:u/2,height:c/2,left:h/2,top:p/2-27,advance:d/2,localGlyph:!0}}}}function vh(t,e,r,n){const s=[],a=t.image,o=a.pixelRatio,l=a.paddedRect.w-2,u=a.paddedRect.h-2,c=t.right-t.left,h=t.bottom-t.top,p=a.stretchX||[[0,l]],d=a.stretchY||[[0,u]],f=(t,e)=>t+e[1]-e[0],y=p.reduce(f,0),m=d.reduce(f,0),g=l-y,x=u-m;let v=0,b=y,w=0,_=m,A=0,k=g,S=0,I=x;if(a.content&&n){const t=a.content;v=bh(p,0,t[0]),w=bh(d,0,t[1]),b=bh(p,t[0],t[2]),_=bh(d,t[1],t[3]),A=t[0]-v,S=t[1]-w,k=t[2]-t[0]-b,I=t[3]-t[1]-_;}const z=(n,s,l,u)=>{const p=_h(n.stretch-v,b,c,t.left),d=Ah(n.fixed-A,k,n.stretch,y),f=_h(s.stretch-w,_,h,t.top),g=Ah(s.fixed-S,I,s.stretch,m),x=_h(l.stretch-v,b,c,t.left),z=Ah(l.fixed-A,k,l.stretch,y),M=_h(u.stretch-w,_,h,t.top),T=Ah(u.fixed-S,I,u.stretch,m),B=new i(p,f),C=new i(x,f),P=new i(x,M),E=new i(p,M),D=new i(d/o,g/o),V=new i(z/o,T/o),F=e*Math.PI/180;if(F){const t=Math.sin(F),e=Math.cos(F),r=[e,-t,t,e];B._matMult(r),C._matMult(r),E._matMult(r),P._matMult(r);}const L=n.stretch+n.fixed,R=s.stretch+s.fixed;return {tl:B,tr:C,bl:E,br:P,tex:{x:a.paddedRect.x+1+L,y:a.paddedRect.y+1+R,w:l.stretch+l.fixed-L,h:u.stretch+u.fixed-R},writingMode:void 0,glyphOffset:[0,0],sectionIndex:0,pixelOffsetTL:D,pixelOffsetBR:V,minFontScaleX:k/o/c,minFontScaleY:I/o/h,isSDF:r}};if(n&&(a.stretchX||a.stretchY)){const t=wh(p,g,y),e=wh(d,x,m);for(let r=0;r<t.length-1;r++){const n=t[r],i=t[r+1];for(let t=0;t<e.length-1;t++)s.push(z(n,e[t],i,e[t+1]));}}else s.push(z({fixed:0,stretch:-1},{fixed:0,stretch:-1},{fixed:0,stretch:l+1},{fixed:0,stretch:u+1}));return s}function bh(t,e,r){let n=0;for(const i of t)n+=Math.max(e,Math.min(r,i[1]))-Math.max(e,Math.min(r,i[0]));return n}function wh(t,e,r){const n=[{fixed:-1,stretch:0}];for(const[e,r]of t){const t=n[n.length-1];n.push({fixed:e-t.stretch,stretch:t.stretch}),n.push({fixed:e-t.stretch,stretch:t.stretch+(r-e)});}return n.push({fixed:e+1,stretch:r}),n}function _h(t,e,r,n){return t/e*r+n}function Ah(t,e,r,n){return t-e*r/n}function kh(t,e,r,n){const i=e+t.positionedLines[n].lineOffset;return 0===n?r+i/2:r+(i+(e+t.positionedLines[n-1].lineOffset))/2}xh.loadGlyphRange=function(t,e,r,n,i){const s=256*e,a=s+255,o=n.transformRequest(n.normalizeGlyphsURL(r).replace("{fontstack}",t).replace("{range}",`${s}-${a}`),re.Glyphs);ae(o,((t,e)=>{if(t)i(t);else if(e){const t={},r=function(t){return new gc(t).readFields(Lc,{})}(e);for(const e of r.glyphs)t[e.id]=e;i(null,{glyphs:t,ascender:r.ascender,descender:r.descender});}}));},xh.TinySDF=class{constructor({fontSize:t=24,buffer:e=3,radius:r=8,cutoff:n=.25,fontFamily:i="sans-serif",fontWeight:s="normal",fontStyle:a="normal"}){this.buffer=e,this.cutoff=n,this.radius=r;const o=this.size=t+4*e,l=this._createCanvas(o),u=this.ctx=l.getContext("2d",{willReadFrequently:!0});u.font=`${a} ${s} ${t}px ${i}`,u.textBaseline="alphabetic",u.textAlign="left",u.fillStyle="black",this.gridOuter=new Float64Array(o*o),this.gridInner=new Float64Array(o*o),this.f=new Float64Array(o),this.z=new Float64Array(o+1),this.v=new Uint16Array(o);}_createCanvas(t){const e=document.createElement("canvas");return e.width=e.height=t,e}draw(t){const{width:e,actualBoundingBoxAscent:r,actualBoundingBoxDescent:n,actualBoundingBoxLeft:i,actualBoundingBoxRight:s}=this.ctx.measureText(t),a=Math.floor(r),o=Math.min(this.size-this.buffer,Math.ceil(s-i)),l=Math.min(this.size-this.buffer,Math.ceil(r)+Math.ceil(n)),u=o+2*this.buffer,c=l+2*this.buffer,h=u*c,p=new Uint8ClampedArray(h),d={data:p,width:u,height:c,glyphWidth:o,glyphHeight:l,glyphTop:a,glyphLeft:0,glyphAdvance:e};if(0===o||0===l)return d;const{ctx:f,buffer:y,gridInner:m,gridOuter:g}=this;f.clearRect(y,y,o,l),f.fillText(t,y,y+a+1);const x=f.getImageData(y,y,o,l);g.fill(fh,0,h),m.fill(0,0,h);for(let t=0;t<l;t++)for(let e=0;e<o;e++){const r=x.data[4*(t*o+e)+3]/255;if(0===r)continue;const n=(t+y)*u+e+y;if(1===r)g[n]=0,m[n]=fh;else {const t=.5-r;g[n]=t>0?t*t:0,m[n]=t<0?t*t:0;}}yh(g,0,0,u,c,u,this.f,this.v,this.z),yh(m,y,y,o,l,u,this.f,this.v,this.z);for(let t=0;t<h;t++){const e=Math.sqrt(g[t])-Math.sqrt(m[t]);p[t]=Math.round(255-255*(e/this.radius+this.cutoff));}return d}};class Sh{constructor(t=[],e=Ih){if(this.data=t,this.length=this.data.length,this.compare=e,this.length>0)for(let t=(this.length>>1)-1;t>=0;t--)this._down(t);}push(t){this.data.push(t),this.length++,this._up(this.length-1);}pop(){if(0===this.length)return;const t=this.data[0],e=this.data.pop();return this.length--,this.length>0&&(this.data[0]=e,this._down(0)),t}peek(){return this.data[0]}_up(t){const{data:e,compare:r}=this,n=e[t];for(;t>0;){const i=t-1>>1,s=e[i];if(r(n,s)>=0)break;e[t]=s,t=i;}e[t]=n;}_down(t){const{data:e,compare:r}=this,n=this.length>>1,i=e[t];for(;t<n;){let n=1+(t<<1),s=e[n];const a=n+1;if(a<this.length&&r(e[a],s)<0&&(n=a,s=e[a]),r(s,i)>=0)break;e[t]=s,t=n;}e[t]=i;}}function Ih(t,e){return t<e?-1:t>e?1:0}function zh(t,e=1,r=!1){let n=1/0,s=1/0,a=-1/0,o=-1/0;const l=t[0];for(let t=0;t<l.length;t++){const e=l[t];(!t||e.x<n)&&(n=e.x),(!t||e.y<s)&&(s=e.y),(!t||e.x>a)&&(a=e.x),(!t||e.y>o)&&(o=e.y);}const u=Math.min(a-n,o-s);let c=u/2;const h=new Sh([],Mh);if(0===u)return new i(n,s);for(let e=n;e<a;e+=u)for(let r=s;r<o;r+=u)h.push(new Th(e+c,r+c,c,t));let p=function(t){let e=0,r=0,n=0;const i=t[0];for(let t=0,s=i.length,a=s-1;t<s;a=t++){const s=i[t],o=i[a],l=s.x*o.y-o.x*s.y;r+=(s.x+o.x)*l,n+=(s.y+o.y)*l,e+=3*l;}return new Th(r/e,n/e,0,t)}(t),d=h.length;for(;h.length;){const n=h.pop();(n.d>p.d||!p.d)&&(p=n,r&&console.log("found best %d after %d probes",Math.round(1e4*n.d)/1e4,d)),n.max-p.d<=e||(c=n.h/2,h.push(new Th(n.p.x-c,n.p.y-c,c,t)),h.push(new Th(n.p.x+c,n.p.y-c,c,t)),h.push(new Th(n.p.x-c,n.p.y+c,c,t)),h.push(new Th(n.p.x+c,n.p.y+c,c,t)),d+=4);}return r&&(console.log(`num probes: ${d}`),console.log(`best distance: ${p.d}`)),p.p}function Mh(t,e){return e.max-t.max}function Th(t,e,r,n){this.p=new i(t,e),this.h=r,this.d=function(t,e){let r=!1,n=1/0;for(let i=0;i<e.length;i++){const s=e[i];for(let e=0,i=s.length,a=i-1;e<i;a=e++){const i=s[e],o=s[a];i.y>t.y!=o.y>t.y&&t.x<(o.x-i.x)*(t.y-i.y)/(o.y-i.y)+i.x&&(r=!r),n=Math.min(n,sl(t,i,o));}}return (r?1:-1)*Math.sqrt(n)}(this.p,n),this.max=this.d+this.h*Math.SQRT2;}const Bh=Number.POSITIVE_INFINITY,Ch=Math.sqrt(2);function Ph(t,e){return e[1]!==Bh?function(t,e,r){let n=0,i=0;switch(e=Math.abs(e),r=Math.abs(r),t){case"top-right":case"top-left":case"top":i=r-7;break;case"bottom-right":case"bottom-left":case"bottom":i=7-r;}switch(t){case"top-right":case"bottom-right":case"right":n=-e;break;case"top-left":case"bottom-left":case"left":n=e;}return [n,i]}(t,e[0],e[1]):function(t,e){let r=0,n=0;e<0&&(e=0);const i=e/Ch;switch(t){case"top-right":case"top-left":n=i-7;break;case"bottom-right":case"bottom-left":n=7-i;break;case"bottom":n=7-e;break;case"top":n=e-7;}switch(t){case"top-right":case"bottom-right":r=-i;break;case"top-left":case"bottom-left":r=i;break;case"left":r=e;break;case"right":r=-e;}return [r,n]}(t,e[0])}function Eh(t,e,r,n,i,s,a,o,l,u){t.createArrays(),t.tilePixelRatio=To/(512*t.overscaling),t.compareText={},t.iconsNeedLinear=!1;const c=t.layers[0].layout,h=t.layers[0]._unevaluatedLayout._values,p={};if("composite"===t.textSizeData.kind){const{minZoom:e,maxZoom:r}=t.textSizeData;p.compositeTextSizes=[h["text-size"].possiblyEvaluate(new Gs(e),o),h["text-size"].possiblyEvaluate(new Gs(r),o)];}if("composite"===t.iconSizeData.kind){const{minZoom:e,maxZoom:r}=t.iconSizeData;p.compositeIconSizes=[h["icon-size"].possiblyEvaluate(new Gs(e),o),h["icon-size"].possiblyEvaluate(new Gs(r),o)];}p.layoutTextSize=h["text-size"].possiblyEvaluate(new Gs(l+1),o),p.layoutIconSize=h["icon-size"].possiblyEvaluate(new Gs(l+1),o),p.textMaxSize=h["text-size"].possiblyEvaluate(new Gs(18),o);const d="map"===c.get("text-rotation-alignment")&&"point"!==c.get("symbol-placement"),f=c.get("text-size");for(const s of t.features){const l=c.get("text-font").evaluate(s,{},o).join(","),h=f.evaluate(s,{},o),y=p.layoutTextSize.evaluate(s,{},o),m=(p.layoutIconSize.evaluate(s,{},o),{horizontal:{},vertical:void 0}),g=s.text;let x,v=[0,0];if(g){const n=g.toString(),a=c.get("text-letter-spacing").evaluate(s,{},o)*sc,u=c.get("text-line-height").evaluate(s,{},o)*sc,p=Is(n)?a:0,f=c.get("text-anchor").evaluate(s,{},o),x=c.get("text-variable-anchor");if(!x){const t=c.get("text-radial-offset").evaluate(s,{},o);v=t?Ph(f,[t*sc,Bh]):c.get("text-offset").evaluate(s,{},o).map((t=>t*sc));}let b=d?"center":c.get("text-justify").evaluate(s,{},o);const w=c.get("symbol-placement"),_="point"===w,A="point"===w?c.get("text-max-width").evaluate(s,{},o)*sc:0,k=s=>{t.allowVerticalPlacement&&Ss(n)&&(m.vertical=Zc(g,e,r,i,l,A,u,f,s,p,v,qc.vertical,!0,w,y,h));};if(!d&&x){const t="auto"===b?x.map((t=>Dh(t))):[b];let n=!1;for(let s=0;s<t.length;s++){const a=t[s];if(!m.horizontal[a])if(n)m.horizontal[a]=m.horizontal[0];else {const t=Zc(g,e,r,i,l,A,u,"center",a,p,v,qc.horizontal,!1,w,y,h);t&&(m.horizontal[a]=t,n=1===t.positionedLines.length);}}k("left");}else {if("auto"===b&&(b=Dh(f)),_||c.get("text-writing-mode").indexOf("horizontal")>=0||!Ss(n)){const t=Zc(g,e,r,i,l,A,u,f,b,p,v,qc.horizontal,!1,w,y,h);t&&(m.horizontal[b]=t);}k("point"===w?"left":b);}}let b=!1;if(s.icon&&s.icon.name){const e=n[s.icon.name];e&&(x=nh(i[s.icon.name],c.get("icon-offset").evaluate(s,{},o),c.get("icon-anchor").evaluate(s,{},o)),b=e.sdf,void 0===t.sdfIcons?t.sdfIcons=e.sdf:t.sdfIcons!==e.sdf&&pt("Style sheet warning: Cannot mix SDF and non-SDF icons in one buffer"),(e.pixelRatio!==t.pixelRatio||0!==c.get("icon-rotate").constantOr(1))&&(t.iconsNeedLinear=!0));}const w=Rh(m.horizontal)||m.vertical;t.iconsInText||(t.iconsInText=!!w&&w.iconsInText),(w||x)&&Vh(t,s,m,x,n,p,y,0,v,b,a,o,u);}s&&t.generateCollisionDebugBuffers(l,t.collisionBoxArray);}function Dh(t){switch(t){case"right":case"top-right":case"bottom-right":return "right";case"left":case"top-left":case"bottom-left":return "left"}return "center"}function Vh(t,e,r,n,i,s,a,o,l,u,c,h,p){let d=s.textMaxSize.evaluate(e,{},h);void 0===d&&(d=a);const f=t.layers[0].layout,y=f.get("icon-offset").evaluate(e,{},h),m=Rh(r.horizontal)||r.vertical,g=a/24,x=t.tilePixelRatio*d/24,v=t.tilePixelRatio*f.get("symbol-spacing"),b=f.get("text-padding")*t.tilePixelRatio,w=f.get("icon-padding")*t.tilePixelRatio,_=q(f.get("text-max-angle")),A="map"===f.get("text-rotation-alignment")&&"point"!==f.get("symbol-placement"),k="map"===f.get("icon-rotation-alignment")&&"point"!==f.get("symbol-placement"),S=f.get("symbol-placement"),I=v/2,z=f.get("icon-text-fit");let M;n&&"none"!==z&&(t.allowVerticalPlacement&&r.vertical&&(M=ih(n,r.vertical,z,f.get("icon-text-fit-padding"),y,g)),m&&(n=ih(n,m,z,f.get("icon-text-fit-padding"),y,g)));const T=(a,o,d)=>{if(o.x<0||o.x>=To||o.y<0||o.y>=To)return;const{x:f,y:m,z:g}=p.projectTilePoint(o.x,o.y,d),x=new sh(f,m,g,0,void 0);!function(t,e,r,n,i,s,a,o,l,u,c,h,p,d,f,y,m,g,x,v,b,w,_,A,k){const S=t.addToLineVertexArray(e,n);let I,z,M,T,B,C,P,E=0,D=0,V=0,F=0,L=-1,R=-1;const U={};let $=Ja(""),O=0,j=0;if(void 0===l._unevaluatedLayout.getValue("text-radial-offset")?[O,j]=l.layout.get("text-offset").evaluate(b,{},k).map((t=>t*sc)):(O=l.layout.get("text-radial-offset").evaluate(b,{},k)*sc,j=Bh),t.allowVerticalPlacement&&i.vertical){const t=i.vertical;if(f)C=$h(t),o&&(P=$h(o));else {const n=l.layout.get("text-rotate").evaluate(b,{},k)+90;M=Uh(u,r,e,c,h,p,t,d,n,y),o&&(T=Uh(u,r,e,c,h,p,o,g,n));}}if(s){const n=l.layout.get("icon-rotate").evaluate(b,{},k),i="none"!==l.layout.get("icon-text-fit"),a=vh(s,n,_,i),d=o?vh(o,n,_,i):void 0;z=Uh(u,r,e,c,h,p,s,g,n),E=4*a.length;const f=t.iconSizeData;let y=null;"source"===f.kind?(y=[ac*l.layout.get("icon-size").evaluate(b,{},k)],y[0]>Fh&&pt(`${t.layerIds[0]}: Value for "icon-size" is >= 255. Reduce your "icon-size".`)):"composite"===f.kind&&(y=[ac*w.compositeIconSizes[0].evaluate(b,{},k),ac*w.compositeIconSizes[1].evaluate(b,{},k)],(y[0]>Fh||y[1]>Fh)&&pt(`${t.layerIds[0]}: Value for "icon-size" is >= 255. Reduce your "icon-size".`)),t.addSymbols(t.icon,a,y,v,x,b,!1,r,e,S.lineStartIndex,S.lineLength,-1,A,k),L=t.icon.placedSymbolArray.length-1,d&&(D=4*d.length,t.addSymbols(t.icon,d,y,v,x,b,qc.vertical,r,e,S.lineStartIndex,S.lineLength,-1,A,k),R=t.icon.placedSymbolArray.length-1);}for(const n in i.horizontal){const s=i.horizontal[n];I||($=Ja(s.text),f?B=$h(s):I=Uh(u,r,e,c,h,p,s,d,l.layout.get("text-rotate").evaluate(b,{},k),y));const o=1===s.positionedLines.length;if(V+=Lh(t,r,e,s,a,l,f,b,y,S,i.vertical?qc.horizontal:qc.horizontalOnly,o?Object.keys(i.horizontal):[n],U,L,w,A,k),o)break}i.vertical&&(F+=Lh(t,r,e,i.vertical,a,l,f,b,y,S,qc.vertical,["vertical"],U,R,w,A,k));let q=-1;const N=(t,e)=>t?Math.max(t,e):e;q=N(B,q),q=N(C,q),q=N(P,q);const G=q>-1?1:0;t.glyphOffsetArray.length>=Yh.MAX_GLYPHS&&pt("Too many glyphs being rendered in a tile. See https://github.com/mapbox/mapbox-gl-js/issues/2907"),void 0!==b.sortKey&&t.addToSortKeyRanges(t.symbolInstances.length,b.sortKey),t.symbolInstances.emplaceBack(r.x,r.y,r.z,e.x,e.y,U.right>=0?U.right:-1,U.center>=0?U.center:-1,U.left>=0?U.left:-1,U.vertical>=0?U.vertical:-1,L,R,$,void 0!==I?I:t.collisionBoxArray.length,void 0!==I?I+1:t.collisionBoxArray.length,void 0!==M?M:t.collisionBoxArray.length,void 0!==M?M+1:t.collisionBoxArray.length,void 0!==z?z:t.collisionBoxArray.length,void 0!==z?z+1:t.collisionBoxArray.length,T||t.collisionBoxArray.length,T?T+1:t.collisionBoxArray.length,c,V,F,E,D,G,0,O,j,q);}(t,o,x,a,r,n,i,M,t.layers[0],t.collisionBoxArray,e.index,e.sourceLayerIndex,t.index,b,A,l,0,w,k,y,e,s,u,c,h);};if("line"===S)for(const i of dh(e.geometry,0,0,To,To)){const e=hh(i,v,_,r.vertical||m,n,24,x,t.overscaling,To);for(const r of e){const e=m;e&&Oh(t,e.text,I,r)||T(i,r,h);}}else if("line-center"===S){for(const t of e.geometry)if(t.length>1){const e=ch(t,_,r.vertical||m,n,24,x);e&&T(t,e,h);}}else if("Polygon"===e.type)for(const t of pu(e.geometry,0)){const e=zh(t,16);T(t[0],new sh(e.x,e.y,0,0,void 0),h);}else if("LineString"===e.type)for(const t of e.geometry)T(t,new sh(t[0].x,t[0].y,0,0,void 0),h);else if("Point"===e.type)for(const t of e.geometry)for(const e of t)T([e],new sh(e.x,e.y,0,0,void 0),h);}const Fh=32640;function Lh(t,e,r,n,s,a,o,l,u,c,h,p,d,f,y,m,g){const x=function(t,e,r,n,s,a,o,l){const u=[];if(0===e.positionedLines.length)return u;const c=n.layout.get("text-rotate").evaluate(a,{})*Math.PI/180,h=function(t){const e=t[0],r=t[1],n=e*r;return n>0?[e,-r]:n<0?[-e,r]:0===e?[r,e]:[r,-e]}(r);let p=Math.abs(e.top-e.bottom);for(const t of e.positionedLines)p-=t.lineOffset;const d=e.positionedLines.length,f=p/d;let y=e.top-r[1];for(let t=0;t<d;++t){const n=e.positionedLines[t];y=kh(e,f,y,t);for(const t of n.positionedGlyphs){if(!t.rect)continue;const n=t.rect||{};let a=4,p=!0,d=1,f=0;if(t.imageName){const e=o[t.imageName];if(!e)continue;if(e.sdf){pt("SDF images are not supported in formatted text and will be ignored.");continue}p=!1,d=e.pixelRatio,a=1/d;}const m=(s||l)&&t.vertical,g=t.metrics.advance*t.scale/2,x=t.metrics,v=t.rect;if(null===v)continue;l&&e.verticalizable&&(f=t.imageName?g-t.metrics.width*t.scale/2:0);const b=s?[t.x+g,t.y]:[0,0];let w=[0,0],_=[0,0],A=!1;s||(m?(_=[t.x+g+h[0],t.y+h[1]-f],A=!0):w=[t.x+g+r[0],t.y+r[1]-f]);const k=v.w*t.scale/(d*(t.localGlyph?2:1)),S=v.h*t.scale/(d*(t.localGlyph?2:1));let I,z,M,T;if(m){const e=t.y-y,r=new i(-g,g-e),n=-Math.PI/2,s=new i(..._);I=new i(-g+w[0],w[1]),I._rotateAround(n,r)._add(s),I.x+=-e+g,I.y-=(x.left-a)*t.scale;const o=t.imageName?x.advance*t.scale:sc*t.scale,l=String.fromCharCode(t.glyph);dc(l)?I.x+=(1-a)*t.scale:fc(l)?I.x+=o-x.height*t.scale+(-a-1)*t.scale:I.x+=t.imageName||x.width+2*a===v.w&&x.height+2*a===v.h?(o-S)/2:(o-(x.height+2*a)*t.scale)/2,z=new i(I.x,I.y-k),M=new i(I.x+S,I.y),T=new i(I.x+S,I.y-k);}else {const e=(x.left-a)*t.scale-g+w[0],r=(-x.top-a)*t.scale+w[1],n=e+k,s=r+S;I=new i(e,r),z=new i(n,r),M=new i(e,s),T=new i(n,s);}if(c){let t;t=s?new i(0,0):A?new i(h[0],h[1]):new i(r[0],r[1]),I._rotateAround(c,t),z._rotateAround(c,t),M._rotateAround(c,t),T._rotateAround(c,t);}const B=new i(0,0),C=new i(0,0);u.push({tl:I,tr:z,bl:M,br:T,tex:n,writingMode:e.writingMode,glyphOffset:b,sectionIndex:t.sectionIndex,isSDF:p,pixelOffsetTL:B,pixelOffsetBR:C,minFontScaleX:0,minFontScaleY:0});}}return u}(0,n,u,a,o,l,s,t.allowVerticalPlacement),v=t.textSizeData;let b=null;"source"===v.kind?(b=[ac*a.layout.get("text-size").evaluate(l,{},g)],b[0]>Fh&&pt(`${t.layerIds[0]}: Value for "text-size" is >= 255. Reduce your "text-size".`)):"composite"===v.kind&&(b=[ac*y.compositeTextSizes[0].evaluate(l,{},g),ac*y.compositeTextSizes[1].evaluate(l,{},g)],(b[0]>Fh||b[1]>Fh)&&pt(`${t.layerIds[0]}: Value for "text-size" is >= 255. Reduce your "text-size".`)),t.addSymbols(t.text,x,b,u,o,l,h,e,r,c.lineStartIndex,c.lineLength,f,m,g);for(const e of p)d[e]=t.text.placedSymbolArray.length-1;return 4*x.length}function Rh(t){for(const e in t)return t[e];return null}function Uh(t,e,r,n,s,a,o,l,u,c){let h=o.top,p=o.bottom,d=o.left,f=o.right;const y=o.collisionPadding;if(y&&(d-=y[0],h-=y[1],f+=y[2],p+=y[3]),u){const t=new i(d,h),e=new i(f,h),r=new i(d,p),n=new i(f,p),s=q(u);let a=new i(0,0);c&&(a=new i(c[0],c[1])),t._rotateAround(s,a),e._rotateAround(s,a),r._rotateAround(s,a),n._rotateAround(s,a),d=Math.min(t.x,e.x,r.x,n.x),f=Math.max(t.x,e.x,r.x,n.x),h=Math.min(t.y,e.y,r.y,n.y),p=Math.max(t.y,e.y,r.y,n.y);}return t.emplaceBack(e.x,e.y,e.z,r.x,r.y,d,h,f,p,l,n,s,a),t.length-1}function $h(t){t.collisionPadding&&(t.top-=t.collisionPadding[1],t.bottom+=t.collisionPadding[3]);const e=t.bottom-t.top;return e>0?Math.max(10,e):null}function Oh(t,e,r,n){const i=t.compareText;if(e in i){const t=i[e];for(let e=t.length-1;e>=0;e--)if(n.dist(t[e])<r)return !0}else i[e]=[];return i[e].push(n),!1}const jh=Bu.VectorTileFeature.types,qh=[{name:"a_fade_opacity",components:1,type:"Uint8",offset:0}];function Nh(t,e,r,n,i,s,a,o,l,u,c,h,p,d,f,y){const m=c?Math.min(Fh,Math.round(c[0])):0,g=c?Math.min(Fh,Math.round(c[1])):0;t.emplaceBack(e,r,Math.round(32*a),Math.round(32*o),l,u,(m<<1)+(h?1:0),g,16*p,16*d,256*f,256*y,n,i,s,0);}function Gh(t,e,r){t.emplaceBack(e.x,e.y,r),t.emplaceBack(e.x,e.y,r),t.emplaceBack(e.x,e.y,r),t.emplaceBack(e.x,e.y,r);}function Zh(t){for(const e of t.sections)if(Ps(e.text))return !0;return !1}class Xh{constructor(t){this.layoutVertexArray=new xa,this.indexArray=new ka,this.programConfigurations=t,this.segments=new Mo,this.dynamicLayoutVertexArray=new ya,this.opacityVertexArray=new va,this.placedSymbolArray=new Ra;}isEmpty(){return 0===this.layoutVertexArray.length&&0===this.indexArray.length&&0===this.dynamicLayoutVertexArray.length&&0===this.opacityVertexArray.length}upload(t,e,r,n){this.isEmpty()||(r&&(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,Qu.members),this.indexBuffer=t.createIndexBuffer(this.indexArray,e),this.dynamicLayoutVertexBuffer=t.createVertexBuffer(this.dynamicLayoutVertexArray,tc.members,!0),this.opacityVertexBuffer=t.createVertexBuffer(this.opacityVertexArray,qh,!0),this.opacityVertexBuffer.itemSize=1),(r||n)&&this.programConfigurations.upload(t));}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.dynamicLayoutVertexBuffer.destroy(),this.opacityVertexBuffer.destroy());}}Zi("SymbolBuffers",Xh);class Kh{constructor(t,e,r){this.layoutVertexArray=new t,this.layoutAttributes=e,this.indexArray=new r,this.segments=new Mo,this.collisionVertexArray=new Aa,this.collisionVertexArrayExt=new ya;}upload(t){this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,this.layoutAttributes),this.indexBuffer=t.createIndexBuffer(this.indexArray),this.collisionVertexBuffer=t.createVertexBuffer(this.collisionVertexArray,ec.members,!0),this.collisionVertexBufferExt=t.createVertexBuffer(this.collisionVertexArrayExt,rc.members,!0);}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.segments.destroy(),this.collisionVertexBuffer.destroy(),this.collisionVertexBufferExt.destroy());}}Zi("CollisionBuffers",Kh);class Yh{constructor(t){this.collisionBoxArray=t.collisionBoxArray,this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.pixelRatio=t.pixelRatio,this.sourceLayerIndex=t.sourceLayerIndex,this.hasPattern=!1,this.hasRTLText=!1,this.fullyClipped=!1,this.sortKeyRanges=[],this.collisionCircleArray=[],this.placementInvProjMatrix=c([]),this.placementViewportMatrix=c([]);const e=this.layers[0]._unevaluatedLayout._values;this.textSizeData=oc(this.zoom,e["text-size"]),this.iconSizeData=oc(this.zoom,e["icon-size"]);const r=this.layers[0].layout,n=r.get("symbol-sort-key"),i=r.get("symbol-z-order");this.canOverlap=r.get("text-allow-overlap")||r.get("icon-allow-overlap")||r.get("text-ignore-placement")||r.get("icon-ignore-placement"),this.sortFeaturesByKey="viewport-y"!==i&&void 0!==n.constantOr(1),this.sortFeaturesByY=("viewport-y"===i||"auto"===i&&!this.sortFeaturesByKey)&&this.canOverlap,this.writingModes=r.get("text-writing-mode").map((t=>qc[t])),this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id)),this.sourceID=t.sourceID;}createArrays(){this.text=new Xh(new xo(this.layers,this.zoom,(t=>/^text/.test(t)))),this.icon=new Xh(new xo(this.layers,this.zoom,(t=>/^icon/.test(t)))),this.glyphOffsetArray=new Oa,this.lineVertexArray=new ja,this.symbolInstances=new $a;}calculateGlyphDependencies(t,e,r,n,i){for(let r=0;r<t.length;r++)if(e[t.charCodeAt(r)]=!0,n&&i){const n=pc[t.charAt(r)];n&&(e[n.charCodeAt(0)]=!0);}}populate(t,e,r,n){const i=this.layers[0],s=i.layout,a=s.get("text-font"),o=s.get("text-field"),l=s.get("icon-image"),u=("constant"!==o.value.kind||o.value.value instanceof Ke&&!o.value.value.isEmpty()||o.value.value.toString().length>0)&&("constant"!==a.value.kind||a.value.value.length>0),c="constant"!==l.value.kind||!!l.value.value||Object.keys(l.parameters).length>0,h=s.get("symbol-sort-key");if(this.features=[],!u&&!c)return;const p=e.iconDependencies,d=e.glyphDependencies,f=e.availableImages,y=new Gs(this.zoom);for(const{feature:e,id:o,index:l,sourceLayerIndex:m}of t){const t=i._featureFilter.needGeometry,g=Yo(e,t);if(!i._featureFilter.filter(y,g,r))continue;let x,v;if(t||(g.geometry=Ko(e,r,n)),u){const t=i.getValueAndResolveTokens("text-field",g,r,f),e=Ke.factory(t);Zh(e)&&(this.hasRTLText=!0),(!this.hasRTLText||"unavailable"===js()||this.hasRTLText&&Ns.isParsed())&&(x=hc(e,i,g));}if(c){const t=i.getValueAndResolveTokens("icon-image",g,r,f);v=t instanceof Ye?t:Ye.fromString(t);}if(!x&&!v)continue;const b=this.sortFeaturesByKey?h.evaluate(g,{},r):void 0;if(this.features.push({id:o,text:x,icon:v,index:l,sourceLayerIndex:m,geometry:g.geometry,properties:e.properties,type:jh[e.type],sortKey:b}),v&&(p[v.name]=!0),x){const t=a.evaluate(g,{},r).join(","),e="map"===s.get("text-rotation-alignment")&&"point"!==s.get("symbol-placement");this.allowVerticalPlacement=this.writingModes&&this.writingModes.indexOf(qc.vertical)>=0;for(const r of x.sections)if(r.image)p[r.image.name]=!0;else {const n=Ss(x.toString()),i=r.fontStack||t,s=d[i]=d[i]||{};this.calculateGlyphDependencies(r.text,s,e,this.allowVerticalPlacement,n);}}}"line"===s.get("symbol-placement")&&(this.features=function(t){const e={},r={},n=[];let i=0;function s(e){n.push(t[e]),i++;}function a(t,e,i){const s=r[t];return delete r[t],r[e]=s,n[s].geometry[0].pop(),n[s].geometry[0]=n[s].geometry[0].concat(i[0]),s}function o(t,r,i){const s=e[r];return delete e[r],e[t]=s,n[s].geometry[0].shift(),n[s].geometry[0]=i[0].concat(n[s].geometry[0]),s}function l(t,e,r){const n=r?e[0][e[0].length-1]:e[0][0];return `${t}:${n.x}:${n.y}`}for(let u=0;u<t.length;u++){const c=t[u],h=c.geometry,p=c.text?c.text.toString():null;if(!p){s(u);continue}const d=l(p,h),f=l(p,h,!0);if(d in r&&f in e&&r[d]!==e[f]){const t=o(d,f,h),i=a(d,f,n[t].geometry);delete e[d],delete r[f],r[l(p,n[i].geometry,!0)]=i,n[t].geometry=null;}else d in r?a(d,f,h):f in e?o(d,f,h):(s(u),e[d]=i-1,r[f]=i-1);}return n.filter((t=>t.geometry))}(this.features)),this.sortFeaturesByKey&&this.features.sort(((t,e)=>t.sortKey-e.sortKey));}update(t,e,r,n){this.stateDependentLayers.length&&(this.text.programConfigurations.updatePaintArrays(t,e,this.layers,r,n),this.icon.programConfigurations.updatePaintArrays(t,e,this.layers,r,n));}isEmpty(){return 0===this.symbolInstances.length&&!this.hasRTLText}uploadPending(){return !this.uploaded||this.text.programConfigurations.needsUpload||this.icon.programConfigurations.needsUpload}upload(t){!this.uploaded&&this.hasDebugData()&&(this.textCollisionBox.upload(t),this.iconCollisionBox.upload(t)),this.text.upload(t,this.sortFeaturesByY,!this.uploaded,this.text.programConfigurations.needsUpload),this.icon.upload(t,this.sortFeaturesByY,!this.uploaded,this.icon.programConfigurations.needsUpload),this.uploaded=!0;}destroyDebugData(){this.textCollisionBox.destroy(),this.iconCollisionBox.destroy();}destroy(){this.text.destroy(),this.icon.destroy(),this.hasDebugData()&&this.destroyDebugData();}addToLineVertexArray(t,e){const r=this.lineVertexArray.length;if(void 0!==t.segment){let r=t.dist(e[t.segment+1]),n=t.dist(e[t.segment]);const i={};for(let n=t.segment+1;n<e.length;n++)i[n]={x:e[n].x,y:e[n].y,tileUnitDistanceFromAnchor:r},n<e.length-1&&(r+=e[n+1].dist(e[n]));for(let r=t.segment||0;r>=0;r--)i[r]={x:e[r].x,y:e[r].y,tileUnitDistanceFromAnchor:n},r>0&&(n+=e[r-1].dist(e[r]));for(let t=0;t<e.length;t++){const e=i[t];this.lineVertexArray.emplaceBack(e.x,e.y,e.tileUnitDistanceFromAnchor);}}return {lineStartIndex:r,lineLength:this.lineVertexArray.length-r}}addSymbols(t,e,r,n,i,s,a,o,l,u,c,h,p,d){const f=t.indexArray,y=t.layoutVertexArray,m=t.segments.prepareSegment(4*e.length,y,f,this.canOverlap?s.sortKey:void 0),g=this.glyphOffsetArray.length,x=m.vertexLength,v=this.allowVerticalPlacement&&a===qc.vertical?Math.PI/2:0,b=s.text&&s.text.sections;for(let n=0;n<e.length;n++){const{tl:i,tr:a,bl:u,br:c,tex:h,pixelOffsetTL:g,pixelOffsetBR:x,minFontScaleX:w,minFontScaleY:_,glyphOffset:A,isSDF:k,sectionIndex:S}=e[n],I=m.vertexLength,z=A[1];Nh(y,o.x,o.y,o.z,l.x,l.y,i.x,z+i.y,h.x,h.y,r,k,g.x,g.y,w,_),Nh(y,o.x,o.y,o.z,l.x,l.y,a.x,z+a.y,h.x+h.w,h.y,r,k,x.x,g.y,w,_),Nh(y,o.x,o.y,o.z,l.x,l.y,u.x,z+u.y,h.x,h.y+h.h,r,k,g.x,x.y,w,_),Nh(y,o.x,o.y,o.z,l.x,l.y,c.x,z+c.y,h.x+h.w,h.y+h.h,r,k,x.x,x.y,w,_),Gh(t.dynamicLayoutVertexArray,o,v),f.emplaceBack(I,I+1,I+2),f.emplaceBack(I+1,I+2,I+3),m.vertexLength+=4,m.primitiveLength+=2,this.glyphOffsetArray.emplaceBack(A[0]),n!==e.length-1&&S===e[n+1].sectionIndex||t.programConfigurations.populatePaintArrays(y.length,s,s.index,{},p,d,b&&b[S]);}t.placedSymbolArray.emplaceBack(o.x,o.y,o.z,l.x,l.y,g,this.glyphOffsetArray.length-g,x,u,c,l.segment,r?r[0]:0,r?r[1]:0,n[0],n[1],a,0,!1,0,h,0);}_commitLayoutVertex(t,e,r,n,i,s,a){t.emplaceBack(e,r,n,i,s,Math.round(a.x),Math.round(a.y));}_addCollisionDebugVertices(t,e,r,n,s,a,o){const l=r.segments.prepareSegment(4,r.layoutVertexArray,r.indexArray),u=l.vertexLength,c=o.tileAnchorX,h=o.tileAnchorY;for(let t=0;t<4;t++)r.collisionVertexArray.emplaceBack(0,0,0,0);r.collisionVertexArrayExt.emplaceBack(e,-t.padding,-t.padding),r.collisionVertexArrayExt.emplaceBack(e,t.padding,-t.padding),r.collisionVertexArrayExt.emplaceBack(e,t.padding,t.padding),r.collisionVertexArrayExt.emplaceBack(e,-t.padding,t.padding),this._commitLayoutVertex(r.layoutVertexArray,n,s,a,c,h,new i(t.x1,t.y1)),this._commitLayoutVertex(r.layoutVertexArray,n,s,a,c,h,new i(t.x2,t.y1)),this._commitLayoutVertex(r.layoutVertexArray,n,s,a,c,h,new i(t.x2,t.y2)),this._commitLayoutVertex(r.layoutVertexArray,n,s,a,c,h,new i(t.x1,t.y2)),l.vertexLength+=4;const p=r.indexArray;p.emplaceBack(u,u+1),p.emplaceBack(u+1,u+2),p.emplaceBack(u+2,u+3),p.emplaceBack(u+3,u),l.primitiveLength+=4;}_addTextDebugCollisionBoxes(t,e,r,n,i,s){for(let a=n;a<i;a++){const n=r.get(a),i=this.getSymbolInstanceTextSize(t,s,e,a);this._addCollisionDebugVertices(n,i,this.textCollisionBox,n.projectedAnchorX,n.projectedAnchorY,n.projectedAnchorZ,s);}}_addIconDebugCollisionBoxes(t,e,r,n,i,s){for(let a=n;a<i;a++){const n=r.get(a),i=this.getSymbolInstanceIconSize(t,e,a);this._addCollisionDebugVertices(n,i,this.iconCollisionBox,n.projectedAnchorX,n.projectedAnchorY,n.projectedAnchorZ,s);}}generateCollisionDebugBuffers(t,e){this.hasDebugData()&&this.destroyDebugData(),this.textCollisionBox=new Kh(wa,nc.members,Ca),this.iconCollisionBox=new Kh(wa,nc.members,Ca);const r=uc(this.iconSizeData,t),n=uc(this.textSizeData,t);for(let i=0;i<this.symbolInstances.length;i++){const s=this.symbolInstances.get(i);this._addTextDebugCollisionBoxes(n,t,e,s.textBoxStartIndex,s.textBoxEndIndex,s),this._addTextDebugCollisionBoxes(n,t,e,s.verticalTextBoxStartIndex,s.verticalTextBoxEndIndex,s),this._addIconDebugCollisionBoxes(r,t,e,s.iconBoxStartIndex,s.iconBoxEndIndex,s),this._addIconDebugCollisionBoxes(r,t,e,s.verticalIconBoxStartIndex,s.verticalIconBoxEndIndex,s);}}getSymbolInstanceTextSize(t,e,r,n){const i=this.text.placedSymbolArray.get(e.rightJustifiedTextSymbolIndex>=0?e.rightJustifiedTextSymbolIndex:e.centerJustifiedTextSymbolIndex>=0?e.centerJustifiedTextSymbolIndex:e.leftJustifiedTextSymbolIndex>=0?e.leftJustifiedTextSymbolIndex:e.verticalPlacedTextSymbolIndex>=0?e.verticalPlacedTextSymbolIndex:n),s=lc(this.textSizeData,t,i)/sc;return this.tilePixelRatio*s}getSymbolInstanceIconSize(t,e,r){const n=this.icon.placedSymbolArray.get(r),i=lc(this.iconSizeData,t,n);return this.tilePixelRatio*i}_commitDebugCollisionVertexUpdate(t,e,r){t.emplaceBack(e,-r,-r),t.emplaceBack(e,r,-r),t.emplaceBack(e,r,r),t.emplaceBack(e,-r,r);}_updateTextDebugCollisionBoxes(t,e,r,n,i,s){for(let a=n;a<i;a++){const n=r.get(a),i=this.getSymbolInstanceTextSize(t,s,e,a);this._commitDebugCollisionVertexUpdate(this.textCollisionBox.collisionVertexArrayExt,i,n.padding);}}_updateIconDebugCollisionBoxes(t,e,r,n,i){for(let s=n;s<i;s++){const n=r.get(s),i=this.getSymbolInstanceIconSize(t,e,s);this._commitDebugCollisionVertexUpdate(this.iconCollisionBox.collisionVertexArrayExt,i,n.padding);}}updateCollisionDebugBuffers(t,e){if(!this.hasDebugData())return;this.hasTextCollisionBoxData()&&this.textCollisionBox.collisionVertexArrayExt.clear(),this.hasIconCollisionBoxData()&&this.iconCollisionBox.collisionVertexArrayExt.clear();const r=uc(this.iconSizeData,t),n=uc(this.textSizeData,t);for(let i=0;i<this.symbolInstances.length;i++){const s=this.symbolInstances.get(i);this._updateTextDebugCollisionBoxes(n,t,e,s.textBoxStartIndex,s.textBoxEndIndex,s),this._updateTextDebugCollisionBoxes(n,t,e,s.verticalTextBoxStartIndex,s.verticalTextBoxEndIndex,s),this._updateIconDebugCollisionBoxes(r,t,e,s.iconBoxStartIndex,s.iconBoxEndIndex),this._updateIconDebugCollisionBoxes(r,t,e,s.verticalIconBoxStartIndex,s.verticalIconBoxEndIndex);}this.hasTextCollisionBoxData()&&this.textCollisionBox.collisionVertexBufferExt&&this.textCollisionBox.collisionVertexBufferExt.updateData(this.textCollisionBox.collisionVertexArrayExt),this.hasIconCollisionBoxData()&&this.iconCollisionBox.collisionVertexBufferExt&&this.iconCollisionBox.collisionVertexBufferExt.updateData(this.iconCollisionBox.collisionVertexArrayExt);}_deserializeCollisionBoxesForSymbol(t,e,r,n,i,s,a,o,l){const u={};for(let n=e;n<r;n++){const e=t.get(n);u.textBox={x1:e.x1,y1:e.y1,x2:e.x2,y2:e.y2,padding:e.padding,projectedAnchorX:e.projectedAnchorX,projectedAnchorY:e.projectedAnchorY,projectedAnchorZ:e.projectedAnchorZ,tileAnchorX:e.tileAnchorX,tileAnchorY:e.tileAnchorY},u.textFeatureIndex=e.featureIndex;break}for(let e=n;e<i;e++){const r=t.get(e);u.verticalTextBox={x1:r.x1,y1:r.y1,x2:r.x2,y2:r.y2,padding:r.padding,projectedAnchorX:r.projectedAnchorX,projectedAnchorY:r.projectedAnchorY,projectedAnchorZ:r.projectedAnchorZ,tileAnchorX:r.tileAnchorX,tileAnchorY:r.tileAnchorY},u.verticalTextFeatureIndex=r.featureIndex;break}for(let e=s;e<a;e++){const r=t.get(e);u.iconBox={x1:r.x1,y1:r.y1,x2:r.x2,y2:r.y2,padding:r.padding,projectedAnchorX:r.projectedAnchorX,projectedAnchorY:r.projectedAnchorY,projectedAnchorZ:r.projectedAnchorZ,tileAnchorX:r.tileAnchorX,tileAnchorY:r.tileAnchorY},u.iconFeatureIndex=r.featureIndex;break}for(let e=o;e<l;e++){const r=t.get(e);u.verticalIconBox={x1:r.x1,y1:r.y1,x2:r.x2,y2:r.y2,padding:r.padding,projectedAnchorX:r.projectedAnchorX,projectedAnchorY:r.projectedAnchorY,projectedAnchorZ:r.projectedAnchorZ,tileAnchorX:r.tileAnchorX,tileAnchorY:r.tileAnchorY},u.verticalIconFeatureIndex=r.featureIndex;break}return u}deserializeCollisionBoxes(t){this.collisionArrays=[];for(let e=0;e<this.symbolInstances.length;e++){const r=this.symbolInstances.get(e);this.collisionArrays.push(this._deserializeCollisionBoxesForSymbol(t,r.textBoxStartIndex,r.textBoxEndIndex,r.verticalTextBoxStartIndex,r.verticalTextBoxEndIndex,r.iconBoxStartIndex,r.iconBoxEndIndex,r.verticalIconBoxStartIndex,r.verticalIconBoxEndIndex));}}hasTextData(){return this.text.segments.get().length>0}hasIconData(){return this.icon.segments.get().length>0}hasDebugData(){return this.textCollisionBox&&this.iconCollisionBox}hasTextCollisionBoxData(){return this.hasDebugData()&&this.textCollisionBox.segments.get().length>0}hasIconCollisionBoxData(){return this.hasDebugData()&&this.iconCollisionBox.segments.get().length>0}addIndicesForPlacedSymbol(t,e){const r=t.placedSymbolArray.get(e),n=r.vertexStartIndex+4*r.numGlyphs;for(let e=r.vertexStartIndex;e<n;e+=4)t.indexArray.emplaceBack(e,e+1,e+2),t.indexArray.emplaceBack(e+1,e+2,e+3);}getSortedSymbolIndexes(t){if(this.sortedAngle===t&&void 0!==this.symbolInstanceIndexes)return this.symbolInstanceIndexes;const e=Math.sin(t),r=Math.cos(t),n=[],i=[],s=[];for(let t=0;t<this.symbolInstances.length;++t){s.push(t);const a=this.symbolInstances.get(t);n.push(0|Math.round(e*a.tileAnchorX+r*a.tileAnchorY)),i.push(a.featureIndex);}return s.sort(((t,e)=>n[t]-n[e]||i[e]-i[t])),s}addToSortKeyRanges(t,e){const r=this.sortKeyRanges[this.sortKeyRanges.length-1];r&&r.sortKey===e?r.symbolInstanceEnd=t+1:this.sortKeyRanges.push({sortKey:e,symbolInstanceStart:t,symbolInstanceEnd:t+1});}sortFeatures(t){if(this.sortFeaturesByY&&this.sortedAngle!==t&&!(this.text.segments.get().length>1||this.icon.segments.get().length>1)){this.symbolInstanceIndexes=this.getSortedSymbolIndexes(t),this.sortedAngle=t,this.text.indexArray.clear(),this.icon.indexArray.clear(),this.featureSortOrder=[];for(const t of this.symbolInstanceIndexes){const e=this.symbolInstances.get(t);this.featureSortOrder.push(e.featureIndex),[e.rightJustifiedTextSymbolIndex,e.centerJustifiedTextSymbolIndex,e.leftJustifiedTextSymbolIndex].forEach(((t,e,r)=>{t>=0&&r.indexOf(t)===e&&this.addIndicesForPlacedSymbol(this.text,t);})),e.verticalPlacedTextSymbolIndex>=0&&this.addIndicesForPlacedSymbol(this.text,e.verticalPlacedTextSymbolIndex),e.placedIconSymbolIndex>=0&&this.addIndicesForPlacedSymbol(this.icon,e.placedIconSymbolIndex),e.verticalPlacedIconSymbolIndex>=0&&this.addIndicesForPlacedSymbol(this.icon,e.verticalPlacedIconSymbolIndex);}this.text.indexBuffer&&this.text.indexBuffer.updateData(this.text.indexArray),this.icon.indexBuffer&&this.icon.indexBuffer.updateData(this.icon.indexArray);}}}Zi("SymbolBucket",Yh,{omit:["layers","collisionBoxArray","features","compareText"]}),Yh.MAX_GLYPHS=65535,Yh.addDynamicAttributes=Gh;const Hh=new sa({"symbol-placement":new ta(ve.layout_symbol["symbol-placement"]),"symbol-spacing":new ta(ve.layout_symbol["symbol-spacing"]),"symbol-avoid-edges":new ta(ve.layout_symbol["symbol-avoid-edges"]),"symbol-sort-key":new ea(ve.layout_symbol["symbol-sort-key"]),"symbol-z-order":new ta(ve.layout_symbol["symbol-z-order"]),"icon-allow-overlap":new ta(ve.layout_symbol["icon-allow-overlap"]),"icon-ignore-placement":new ta(ve.layout_symbol["icon-ignore-placement"]),"icon-optional":new ta(ve.layout_symbol["icon-optional"]),"icon-rotation-alignment":new ta(ve.layout_symbol["icon-rotation-alignment"]),"icon-size":new ea(ve.layout_symbol["icon-size"]),"icon-text-fit":new ta(ve.layout_symbol["icon-text-fit"]),"icon-text-fit-padding":new ta(ve.layout_symbol["icon-text-fit-padding"]),"icon-image":new ea(ve.layout_symbol["icon-image"]),"icon-rotate":new ea(ve.layout_symbol["icon-rotate"]),"icon-padding":new ta(ve.layout_symbol["icon-padding"]),"icon-keep-upright":new ta(ve.layout_symbol["icon-keep-upright"]),"icon-offset":new ea(ve.layout_symbol["icon-offset"]),"icon-anchor":new ea(ve.layout_symbol["icon-anchor"]),"icon-pitch-alignment":new ta(ve.layout_symbol["icon-pitch-alignment"]),"text-pitch-alignment":new ta(ve.layout_symbol["text-pitch-alignment"]),"text-rotation-alignment":new ta(ve.layout_symbol["text-rotation-alignment"]),"text-field":new ea(ve.layout_symbol["text-field"]),"text-font":new ea(ve.layout_symbol["text-font"]),"text-size":new ea(ve.layout_symbol["text-size"]),"text-max-width":new ea(ve.layout_symbol["text-max-width"]),"text-line-height":new ea(ve.layout_symbol["text-line-height"]),"text-letter-spacing":new ea(ve.layout_symbol["text-letter-spacing"]),"text-justify":new ea(ve.layout_symbol["text-justify"]),"text-radial-offset":new ea(ve.layout_symbol["text-radial-offset"]),"text-variable-anchor":new ta(ve.layout_symbol["text-variable-anchor"]),"text-anchor":new ea(ve.layout_symbol["text-anchor"]),"text-max-angle":new ta(ve.layout_symbol["text-max-angle"]),"text-writing-mode":new ta(ve.layout_symbol["text-writing-mode"]),"text-rotate":new ea(ve.layout_symbol["text-rotate"]),"text-padding":new ta(ve.layout_symbol["text-padding"]),"text-keep-upright":new ta(ve.layout_symbol["text-keep-upright"]),"text-transform":new ea(ve.layout_symbol["text-transform"]),"text-offset":new ea(ve.layout_symbol["text-offset"]),"text-allow-overlap":new ta(ve.layout_symbol["text-allow-overlap"]),"text-ignore-placement":new ta(ve.layout_symbol["text-ignore-placement"]),"text-optional":new ta(ve.layout_symbol["text-optional"])});var Jh={paint:new sa({"icon-opacity":new ea(ve.paint_symbol["icon-opacity"]),"icon-color":new ea(ve.paint_symbol["icon-color"]),"icon-halo-color":new ea(ve.paint_symbol["icon-halo-color"]),"icon-halo-width":new ea(ve.paint_symbol["icon-halo-width"]),"icon-halo-blur":new ea(ve.paint_symbol["icon-halo-blur"]),"icon-translate":new ta(ve.paint_symbol["icon-translate"]),"icon-translate-anchor":new ta(ve.paint_symbol["icon-translate-anchor"]),"text-opacity":new ea(ve.paint_symbol["text-opacity"]),"text-color":new ea(ve.paint_symbol["text-color"],{runtimeType:Ce,getOverride:t=>t.textColor,hasOverride:t=>!!t.textColor}),"text-halo-color":new ea(ve.paint_symbol["text-halo-color"]),"text-halo-width":new ea(ve.paint_symbol["text-halo-width"]),"text-halo-blur":new ea(ve.paint_symbol["text-halo-blur"]),"text-translate":new ta(ve.paint_symbol["text-translate"]),"text-translate-anchor":new ta(ve.paint_symbol["text-translate-anchor"])}),layout:Hh};class Wh{constructor(t){this.type=t.property.overrides?t.property.overrides.runtimeType:ze,this.defaultValue=t;}evaluate(t){if(t.formattedSection){const e=this.defaultValue.property.overrides;if(e&&e.hasOverride(t.formattedSection))return e.getOverride(t.formattedSection)}return t.feature&&t.featureState?this.defaultValue.evaluate(t.feature,t.featureState):this.defaultValue.property.specification.default}eachChild(t){this.defaultValue.isConstant()||t(this.defaultValue.value._styleExpression.expression);}outputDefined(){return !1}serialize(){return null}}Zi("FormatSectionOverride",Wh,{omit:["defaultValue"]});class Qh extends So{constructor(t){super(t,Jh);}recalculate(t,e){super.recalculate(t,e),"auto"===this.layout.get("icon-rotation-alignment")&&(this.layout._values["icon-rotation-alignment"]="point"!==this.layout.get("symbol-placement")?"map":"viewport"),"auto"===this.layout.get("text-rotation-alignment")&&(this.layout._values["text-rotation-alignment"]="point"!==this.layout.get("symbol-placement")?"map":"viewport"),"auto"===this.layout.get("text-pitch-alignment")&&(this.layout._values["text-pitch-alignment"]=this.layout.get("text-rotation-alignment")),"auto"===this.layout.get("icon-pitch-alignment")&&(this.layout._values["icon-pitch-alignment"]=this.layout.get("icon-rotation-alignment"));const r=this.layout.get("text-writing-mode");if(r){const t=[];for(const e of r)t.indexOf(e)<0&&t.push(e);this.layout._values["text-writing-mode"]=t;}else this.layout._values["text-writing-mode"]="point"===this.layout.get("symbol-placement")?["horizontal"]:["horizontal","vertical"];this._setPaintOverrides();}getValueAndResolveTokens(t,e,r,n){const i=this.layout.get(t).evaluate(e,{},r,n),s=this._unevaluatedLayout._values[t];return s.isDataDriven()||Nn(s.value)||!i?i:function(t,e){return e.replace(/{([^{}]+)}/g,((e,r)=>r in t?String(t[r]):""))}(e.properties,i)}createBucket(t){return new Yh(t)}queryRadius(){return 0}queryIntersectsFeature(){return !1}_setPaintOverrides(){for(const t of Jh.paint.overridableProperties){if(!Qh.hasPaintOverride(this.layout,t))continue;const e=this.paint.get(t),r=new Wh(e),n=new qn(r,e.property.specification);let i=null;i="constant"===e.value.kind||"source"===e.value.kind?new Zn("source",n):new Xn("composite",n,e.value.zoomStops,e.value._interpolationType),this.paint._values[t]=new Ws(e.property,i,e.parameters);}}_handleOverridablePaintPropertyUpdate(t,e,r){return !(!this.layout||e.isDataDriven()||r.isDataDriven())&&Qh.hasPaintOverride(this.layout,t)}static hasPaintOverride(t,e){const r=t.get("text-field"),n=Jh.paint.properties[e];let i=!1;const s=t=>{for(const e of t)if(n.overrides&&n.overrides.hasOverride(e))return void(i=!0)};if("constant"===r.value.kind&&r.value.value instanceof Ke)s(r.value.value.sections);else if("source"===r.value.kind){const t=e=>{i||(e instanceof tr&&We(e.value)===Ve?s(e.value.sections):e instanceof ir?s(e.sections):e.eachChild(t));},e=r.value;e._styleExpression&&t(e._styleExpression.expression);}return i}getProgramConfiguration(t){return new go(this,t)}}var tp={paint:new sa({"background-color":new ta(ve.paint_background["background-color"]),"background-pattern":new na(ve.paint_background["background-pattern"]),"background-opacity":new ta(ve.paint_background["background-opacity"])})},ep={paint:new sa({"raster-opacity":new ta(ve.paint_raster["raster-opacity"]),"raster-hue-rotate":new ta(ve.paint_raster["raster-hue-rotate"]),"raster-brightness-min":new ta(ve.paint_raster["raster-brightness-min"]),"raster-brightness-max":new ta(ve.paint_raster["raster-brightness-max"]),"raster-saturation":new ta(ve.paint_raster["raster-saturation"]),"raster-contrast":new ta(ve.paint_raster["raster-contrast"]),"raster-resampling":new ta(ve.paint_raster["raster-resampling"]),"raster-fade-duration":new ta(ve.paint_raster["raster-fade-duration"])})};class rp extends So{constructor(t){super(t,{}),this.implementation=t;}is3D(){return "3d"===this.implementation.renderingMode}hasOffscreenPass(){return void 0!==this.implementation.prerender}recalculate(){}updateTransitions(){}hasTransition(){}serialize(){}onAdd(t){this.implementation.onAdd&&this.implementation.onAdd(t,t.painter.context.gl);}onRemove(t){this.implementation.onRemove&&this.implementation.onRemove(t,t.painter.context.gl);}}var np={paint:new sa({"sky-type":new ta(ve.paint_sky["sky-type"]),"sky-atmosphere-sun":new ta(ve.paint_sky["sky-atmosphere-sun"]),"sky-atmosphere-sun-intensity":new ta(ve.paint_sky["sky-atmosphere-sun-intensity"]),"sky-gradient-center":new ta(ve.paint_sky["sky-gradient-center"]),"sky-gradient-radius":new ta(ve.paint_sky["sky-gradient-radius"]),"sky-gradient":new ia(ve.paint_sky["sky-gradient"]),"sky-atmosphere-halo-color":new ta(ve.paint_sky["sky-atmosphere-halo-color"]),"sky-atmosphere-color":new ta(ve.paint_sky["sky-atmosphere-color"]),"sky-opacity":new ta(ve.paint_sky["sky-opacity"])})};function ip(t,e,r){const n=b(0,0,1),i=R(L());return function(t,e,r){r*=.5;var n=e[0],i=e[1],s=e[2],a=e[3],o=Math.sin(r),l=Math.cos(r);t[0]=n*l-s*o,t[1]=i*l+a*o,t[2]=s*l+n*o,t[3]=a*l-i*o;}(i,i,r?-q(t)+Math.PI:q(t)),U(i,i,-q(e)),C(n,n,i),z(n,n)}const sp={circle:class extends So{constructor(t){super(t,yl);}createBucket(t){return new Jo(t)}queryRadius(t){const e=t;return cl("circle-radius",this,e)+cl("circle-stroke-width",this,e)+hl(this.paint.get("circle-translate"))}queryIntersectsFeature(t,e,r,n,i,s,a,o){const l=dl(this.paint.get("circle-translate"),this.paint.get("circle-translate-anchor"),s.angle,t.pixelToTileUnitsFactor),u=this.paint.get("circle-radius").evaluate(e,r)+this.paint.get("circle-stroke-width").evaluate(e,r);return xl(t,n,s,a,o,"map"===this.paint.get("circle-pitch-alignment"),"map"===this.paint.get("circle-pitch-scale"),l,u)}getProgramIds(){return ["circle"]}getProgramConfiguration(t){return new go(this,t)}},heatmap:class extends So{createBucket(t){return new Al(t)}constructor(t){super(t,Tl),this._updateColorRamp();}_handleSpecialPaintPropertyUpdate(t){"heatmap-color"===t&&this._updateColorRamp();}_updateColorRamp(){this.colorRamp=Bl({expression:this._transitionablePaint._values["heatmap-color"].value.expression,evaluationKey:"heatmapDensity",image:this.colorRamp}),this.colorRampTexture=null;}resize(){this.heatmapFbo&&(this.heatmapFbo.destroy(),this.heatmapFbo=null);}queryRadius(t){return cl("heatmap-radius",this,t)}queryIntersectsFeature(t,e,r,n,s,a,o,l){const u=this.paint.get("heatmap-radius").evaluate(e,r);return xl(t,n,a,o,l,!0,!0,new i(0,0),u)}hasOffscreenPass(){return 0!==this.paint.get("heatmap-opacity")&&"none"!==this.visibility}getProgramIds(){return ["heatmap","heatmapTexture"]}getProgramConfiguration(t){return new go(this,t)}},hillshade:class extends So{constructor(t){super(t,Cl);}hasOffscreenPass(){return 0!==this.paint.get("hillshade-exaggeration")&&"none"!==this.visibility}getProgramIds(){return ["hillshade","hillshadePrepare"]}getProgramConfiguration(t){return new go(this,t)}},fill:class extends So{constructor(t){super(t,xu);}getProgramIds(){const t=this.paint.get("fill-pattern"),e=t&&t.constantOr(1),r=[e?"fillPattern":"fill"];return this.paint.get("fill-antialias")&&r.push(e&&!this.getPaintProperty("fill-outline-color")?"fillOutlinePattern":"fillOutline"),r}getProgramConfiguration(t){return new go(this,t)}recalculate(t,e){super.recalculate(t,e);const r=this.paint._values["fill-outline-color"];"constant"===r.value.kind&&void 0===r.value.value&&(this.paint._values["fill-outline-color"]=this.paint._values["fill-color"]);}createBucket(t){return new mu(t)}queryRadius(){return hl(this.paint.get("fill-translate"))}queryIntersectsFeature(t,e,r,n,i,s){return !t.queryGeometry.isAboveHorizon&&tl(pl(t.tilespaceGeometry,this.paint.get("fill-translate"),this.paint.get("fill-translate-anchor"),s.angle,t.pixelToTileUnitsFactor),n)}isTileClipped(){return !0}},"fill-extrusion":class extends So{constructor(t){super(t,Lu);}createBucket(t){return new Vu(t)}queryRadius(){return hl(this.paint.get("fill-extrusion-translate"))}is3D(){return !0}getProgramIds(){return [this.paint.get("fill-extrusion-pattern").constantOr(1)?"fillExtrusionPattern":"fillExtrusion"]}getProgramConfiguration(t){return new go(this,t)}queryIntersectsFeature(t,e,r,n,s,a,o,l,u){const c=dl(this.paint.get("fill-extrusion-translate"),this.paint.get("fill-extrusion-translate-anchor"),a.angle,t.pixelToTileUnitsFactor),h=this.paint.get("fill-extrusion-height").evaluate(e,r),p=this.paint.get("fill-extrusion-base").evaluate(e,r),d=[0,0],f=l&&a.elevation,y=a.elevation?a.elevation.exaggeration():1;if(f){const e=t.tile.getBucket(this).centroidVertexArray,r=u+1;if(r<e.length){const t=e.get(r);d[0]=t.a_centroid_pos0,d[1]=t.a_centroid_pos1;}}if(0===d[0]&&1===d[1])return !1;const m=function(t,e,r,n,s,a,o,l,u){return a?function(t,e,r,n,i,s,a,o,l){const u=[],c=[],h=[0,0,0,1];for(const p of t){const t=[],d=[];for(const u of p){const c=u.x+n.x,p=u.y+n.y,f=Ou(c,p,e,r,s,a,o,l);h[0]=c,h[1]=p,h[2]=f.base,h[3]=1,F(h,h,i),h[3]=Math.max(h[3],1e-5);const y=$u([h[0]/h[3],h[1]/h[3],h[2]/h[3]]);h[0]=c,h[1]=p,h[2]=f.top,h[3]=1,F(h,h,i),h[3]=Math.max(h[3],1e-5);const m=$u([h[0]/h[3],h[1]/h[3],h[2]/h[3]]);t.push(y),d.push(m);}u.push(t),c.push(d);}return [u,c]}(t,e,r,n,s,a,o,l,u):function(t,e,r,n,s){const a=[],o=[],l=s[8]*e,u=s[9]*e,c=s[10]*e,h=s[11]*e,p=s[8]*r,d=s[9]*r,f=s[10]*r,y=s[11]*r;for(const e of t){const t=[],r=[];for(const a of e){const e=a.x+n.x,o=a.y+n.y,m=s[0]*e+s[4]*o+s[12],g=s[1]*e+s[5]*o+s[13],x=s[2]*e+s[6]*o+s[14],v=s[3]*e+s[7]*o+s[15],b=m+l,w=g+u,_=x+c,A=Math.max(v+h,1e-5),k=m+p,S=g+d,I=x+f,z=Math.max(v+y,1e-5),M=new i(b/A,w/A);M.z=_/A,t.push(M);const T=new i(k/z,S/z);T.z=I/z,r.push(T);}a.push(t),o.push(r);}return [a,o]}(t,e,r,n,s)}(n,p,h,c,o,f?l:null,d,y,a.center.lat),g=t.queryGeometry;return function(t,e,r){let n=1/0;tl(r,e)&&(n=Uu(r,e[0]));for(let i=0;i<e.length;i++){const s=e[i],a=t[i];for(let t=0;t<s.length-1;t++){const e=s[t],i=[e,s[t+1],a[t+1],a[t],e];Wo(r,i)&&(n=Math.min(n,Uu(r,i)));}}return n!==1/0&&n}(m[0],m[1],g.isPointQuery()?g.screenBounds:g.screenGeometry)}},line:class extends So{constructor(t){super(t,Hu),this.gradientVersion=0;}_handleSpecialPaintPropertyUpdate(t){if("line-gradient"===t){const t=this._transitionablePaint._values["line-gradient"].value.expression;this.stepInterpolant=t._styleExpression&&t._styleExpression.expression instanceof Fr,this.gradientVersion=(this.gradientVersion+1)%Number.MAX_SAFE_INTEGER;}}gradientExpression(){return this._transitionablePaint._values["line-gradient"].value.expression}recalculate(t,e){super.recalculate(t,e),this.paint._values["line-floorwidth"]=Ju.possiblyEvaluate(this._transitioningPaint._values["line-width"].value,t);}createBucket(t){return new Ku(t)}getProgramIds(){return [this.paint.get("line-pattern").constantOr(1)?"linePattern":"line"]}getProgramConfiguration(t){return new go(this,t)}queryRadius(t){const e=t,r=Wu(cl("line-width",this,e),cl("line-gap-width",this,e)),n=cl("line-offset",this,e);return r/2+Math.abs(n)+hl(this.paint.get("line-translate"))}queryIntersectsFeature(t,e,r,n,s,a){if(t.queryGeometry.isAboveHorizon)return !1;const o=pl(t.tilespaceGeometry,this.paint.get("line-translate"),this.paint.get("line-translate-anchor"),a.angle,t.pixelToTileUnitsFactor),l=t.pixelToTileUnitsFactor/2*Wu(this.paint.get("line-width").evaluate(e,r),this.paint.get("line-gap-width").evaluate(e,r)),u=this.paint.get("line-offset").evaluate(e,r);return u&&(n=function(t,e){const r=[],n=new i(0,0);for(let i=0;i<t.length;i++){const s=t[i],a=[];for(let t=0;t<s.length;t++){const r=s[t-1],i=s[t],o=s[t+1],l=0===t?n:i.sub(r)._unit()._perp(),u=t===s.length-1?n:o.sub(i)._unit()._perp(),c=l._add(u)._unit();c._mult(1/(c.x*u.x+c.y*u.y)),a.push(c._mult(e)._add(i));}r.push(a);}return r}(n,u*t.pixelToTileUnitsFactor)),function(t,e,r){for(let n=0;n<e.length;n++){const i=e[n];if(t.length>=3)for(let e=0;e<i.length;e++)if(ol(t,i[e]))return !0;if(el(t,i,r))return !0}return !1}(o,n,l)}isTileClipped(){return !0}},symbol:Qh,background:class extends So{constructor(t){super(t,tp);}getProgramIds(){return [this.paint.get("background-pattern")?"backgroundPattern":"background"]}},raster:class extends So{constructor(t){super(t,ep);}getProgramIds(){return ["raster"]}},sky:class extends So{constructor(t){super(t,np),this._updateColorRamp();}_handleSpecialPaintPropertyUpdate(t){"sky-gradient"===t?this._updateColorRamp():"sky-atmosphere-sun"!==t&&"sky-atmosphere-halo-color"!==t&&"sky-atmosphere-color"!==t&&"sky-atmosphere-sun-intensity"!==t||(this._skyboxInvalidated=!0);}_updateColorRamp(){this.colorRamp=Bl({expression:this._transitionablePaint._values["sky-gradient"].value.expression,evaluationKey:"skyRadialProgress"}),this.colorRampTexture&&(this.colorRampTexture.destroy(),this.colorRampTexture=null);}needsSkyboxCapture(t){if(this._skyboxInvalidated||!this.skyboxTexture||!this.skyboxGeometry)return !0;if(!this.paint.get("sky-atmosphere-sun")){const e=t.style.light.properties.get("position");return this._lightPosition.azimuthal!==e.azimuthal||this._lightPosition.polar!==e.polar}}getCenter(t,e){const r=this.paint.get("sky-type");if("atmosphere"===r){const r=this.paint.get("sky-atmosphere-sun"),n=!r,i=t.style.light,s=i.properties.get("position");return n&&"viewport"===i.properties.get("anchor")&&pt("The sun direction is attached to a light with viewport anchor, lighting may behave unexpectedly."),n?ip(s.azimuthal,90-s.polar,e):ip(r[0],90-r[1],e)}if("gradient"===r){const t=this.paint.get("sky-gradient-center");return ip(t[0],90-t[1],e)}}is3D(){return !1}isSky(){return !0}markSkyboxValid(t){this._skyboxInvalidated=!1,this._lightPosition=t.style.light.properties.get("position");}hasOffscreenPass(){return !0}getProgramIds(){const t=this.paint.get("sky-type");return "atmosphere"===t?["skyboxCapture","skybox"]:"gradient"===t?["skyboxGradient"]:null}}},{HTMLImageElement:ap,HTMLCanvasElement:op,HTMLVideoElement:lp,ImageData:up,ImageBitmap:cp}=a;class hp{constructor(t,e,r,n){this.context=t,this.format=r,this.texture=t.gl.createTexture(),this.update(e,n);}update(t,e,r){const{width:n,height:i}=t,{context:s}=this,{gl:a}=s;if(a.bindTexture(a.TEXTURE_2D,this.texture),s.pixelStoreUnpackFlipY.set(!1),s.pixelStoreUnpack.set(1),s.pixelStoreUnpackPremultiplyAlpha.set(this.format===a.RGBA&&(!e||!1!==e.premultiply)),r||this.size&&this.size[0]===n&&this.size[1]===i){const{x:e,y:s}=r||{x:0,y:0};t instanceof ap||t instanceof op||t instanceof lp||t instanceof up||cp&&t instanceof cp?a.texSubImage2D(a.TEXTURE_2D,0,e,s,a.RGBA,a.UNSIGNED_BYTE,t):a.texSubImage2D(a.TEXTURE_2D,0,e,s,n,i,a.RGBA,a.UNSIGNED_BYTE,t.data);}else this.size=[n,i],t instanceof ap||t instanceof op||t instanceof lp||t instanceof up||cp&&t instanceof cp?a.texImage2D(a.TEXTURE_2D,0,this.format,this.format,a.UNSIGNED_BYTE,t):a.texImage2D(a.TEXTURE_2D,0,this.format,n,i,0,this.format,a.UNSIGNED_BYTE,t.data);this.useMipmap=Boolean(e&&e.useMipmap&&this.isSizePowerOfTwo()),this.useMipmap&&a.generateMipmap(a.TEXTURE_2D);}bind(t,e){const{context:r}=this,{gl:n}=r;n.bindTexture(n.TEXTURE_2D,this.texture),t!==this.filter&&(n.texParameteri(n.TEXTURE_2D,n.TEXTURE_MAG_FILTER,t),n.texParameteri(n.TEXTURE_2D,n.TEXTURE_MIN_FILTER,this.useMipmap?t===n.NEAREST?n.NEAREST_MIPMAP_NEAREST:n.LINEAR_MIPMAP_NEAREST:t),this.filter=t),e!==this.wrap&&(n.texParameteri(n.TEXTURE_2D,n.TEXTURE_WRAP_S,e),n.texParameteri(n.TEXTURE_2D,n.TEXTURE_WRAP_T,e),this.wrap=e);}isSizePowerOfTwo(){return this.size[0]===this.size[1]&&Math.log(this.size[0])/Math.LN2%1==0}destroy(){const{gl:t}=this.context;t.deleteTexture(this.texture),this.texture=null;}}class pp{constructor(t,e){this.width=t,this.height=e,this.nextRow=0,this.image=new zl({width:t,height:e}),this.positions={},this.uploaded=!1;}getDash(t,e){const r=this.getKey(t,e);return this.positions[r]}trim(){const t=this.width,e=this.height=it(this.nextRow);this.image.resize({width:t,height:e});}getKey(t,e){return t.join(",")+e}getDashRanges(t,e,r){const n=[];let i=t.length%2==1?-t[t.length-1]*r:0,s=t[0]*r,a=!0;n.push({left:i,right:s,isDash:a,zeroLength:0===t[0]});let o=t[0];for(let e=1;e<t.length;e++){a=!a;const l=t[e];i=o*r,o+=l,s=o*r,n.push({left:i,right:s,isDash:a,zeroLength:0===l});}return n}addRoundDash(t,e,r){const n=e/2;for(let e=-r;e<=r;e++){const i=this.width*(this.nextRow+r+e);let s=0,a=t[s];for(let o=0;o<this.width;o++){o/a.right>1&&(a=t[++s]);const l=Math.abs(o-a.left),u=Math.abs(o-a.right),c=Math.min(l,u);let h;const p=e/r*(n+1);if(a.isDash){const t=n-Math.abs(p);h=Math.sqrt(c*c+t*t);}else h=n-Math.sqrt(c*c+p*p);this.image.data[i+o]=Math.max(0,Math.min(255,h+128));}}}addRegularDash(t,e){for(let e=t.length-1;e>=0;--e){const r=t[e],n=t[e+1];r.zeroLength?t.splice(e,1):n&&n.isDash===r.isDash&&(n.left=r.left,t.splice(e,1));}const r=t[0],n=t[t.length-1];r.isDash===n.isDash&&(r.left=n.left-this.width,n.right=r.right+this.width);const i=this.width*this.nextRow;let s=0,a=t[s];for(let r=0;r<this.width;r++){r/a.right>1&&(a=t[++s]);const n=Math.abs(r-a.left),o=Math.abs(r-a.right),l=Math.min(n,o);this.image.data[i+r]=Math.max(0,Math.min(255,(a.isDash?l:-l)+e+128));}}addDash(t,e){const r=this.getKey(t,e);if(this.positions[r])return this.positions[r];const n="round"===e,i=n?7:0,s=2*i+1;if(this.nextRow+s>this.height)return pt("LineAtlas out of space"),null;0===t.length&&t.push(1);let a=0;for(let e=0;e<t.length;e++)t[e]<0&&(pt("Negative value is found in line dasharray, replacing values with 0"),t[e]=0),a+=t[e];if(0!==a){const r=this.width/a,s=this.getDashRanges(t,this.width,r);n?this.addRoundDash(s,r,i):this.addRegularDash(s,"square"===e?.5*r:0);}const o=this.nextRow+i;this.nextRow+=s;const l={tl:[o,i],br:[a,0]};return this.positions[r]=l,l}}Zi("LineAtlas",pp);class dp{constructor(t){this._callback=t,this._triggered=!1,"undefined"!=typeof MessageChannel&&(this._channel=new MessageChannel,this._channel.port2.onmessage=()=>{this._triggered=!1,this._callback();});}trigger(){this._triggered||(this._triggered=!0,this._channel?this._channel.port1.postMessage(!0):setTimeout((()=>{this._triggered=!1,this._callback();}),0));}remove(){delete this._channel,this._callback=()=>{};}}const fp=a.performance;function yp(t){const e=t?t.url.toString():void 0;return fp.getEntriesByName(e)}class mp{constructor(){this.tasks={},this.taskQueue=[],at(["process"],this),this.invoker=new dp(this.process),this.nextId=0;}add(t,e){const r=this.nextId++,n=function({type:t,isSymbolTile:e,zoom:r}){return r=r||0,"message"===t?0:"maybePrepare"!==t||e?"parseTile"!==t||e?"parseTile"===t&&e?300-r:"maybePrepare"===t&&e?400-r:500:200-r:100-r}(e);if(0===n){yt();try{t();}finally{}return {cancel:()=>{}}}return this.tasks[r]={fn:t,metadata:e,priority:n,id:r},this.taskQueue.push(r),this.invoker.trigger(),{cancel:()=>{delete this.tasks[r];}}}process(){yt();try{if(this.taskQueue=this.taskQueue.filter((t=>!!this.tasks[t])),!this.taskQueue.length)return;const t=this.pick();if(null===t)return;const e=this.tasks[t];if(delete this.tasks[t],this.taskQueue.length&&this.invoker.trigger(),!e)return;e.fn();}finally{}}pick(){let t=null,e=1/0;for(let r=0;r<this.taskQueue.length;r++){const n=this.tasks[this.taskQueue[r]];n.priority<e&&(e=n.priority,t=r);}if(null===t)return null;const r=this.taskQueue[t];return this.taskQueue.splice(t,1),r}remove(){this.invoker.remove();}}function gp(t,e,r){var n=2*Math.PI*6378137/256/Math.pow(2,r);return [t*n-2*Math.PI*6378137/2,e*n-2*Math.PI*6378137/2]}class xp{constructor(t,e,r){this.z=t,this.x=e,this.y=r,this.key=wp(0,t,t,e,r);}equals(t){return this.z===t.z&&this.x===t.x&&this.y===t.y}url(t,e){const r=function(t,e,r){var n=gp(256*t,256*(e=Math.pow(2,r)-e-1),r),i=gp(256*(t+1),256*(e+1),r);return n[0]+","+n[1]+","+i[0]+","+i[1]}(this.x,this.y,this.z),n=function(t,e,r){let n,i="";for(let s=t;s>0;s--)n=1<<s-1,i+=(e&n?1:0)+(r&n?2:0);return i}(this.z,this.x,this.y);return t[(this.x+this.y)%t.length].replace("{prefix}",(this.x%16).toString(16)+(this.y%16).toString(16)).replace("{z}",String(this.z)).replace("{x}",String(this.x)).replace("{y}",String("tms"===e?Math.pow(2,this.z)-this.y-1:this.y)).replace("{quadkey}",n).replace("{bbox-epsg-3857}",r)}toString(){return `${this.z}/${this.x}/${this.y}`}}class vp{constructor(t,e){this.wrap=t,this.canonical=e,this.key=wp(t,e.z,e.z,e.x,e.y);}}class bp{constructor(t,e,r,n,i){this.overscaledZ=t,this.wrap=e,this.canonical=new xp(r,+n,+i),this.key=0===e&&t===r?this.canonical.key:wp(e,t,r,n,i);}equals(t){return this.overscaledZ===t.overscaledZ&&this.wrap===t.wrap&&this.canonical.equals(t.canonical)}scaledTo(t){const e=this.canonical.z-t;return t>this.canonical.z?new bp(t,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y):new bp(t,this.wrap,t,this.canonical.x>>e,this.canonical.y>>e)}calculateScaledKey(t,e=!0){if(this.overscaledZ===t&&e)return this.key;if(t>this.canonical.z)return wp(this.wrap*+e,t,this.canonical.z,this.canonical.x,this.canonical.y);{const r=this.canonical.z-t;return wp(this.wrap*+e,t,t,this.canonical.x>>r,this.canonical.y>>r)}}isChildOf(t){if(t.wrap!==this.wrap)return !1;const e=this.canonical.z-t.canonical.z;return 0===t.overscaledZ||t.overscaledZ<this.overscaledZ&&t.canonical.x===this.canonical.x>>e&&t.canonical.y===this.canonical.y>>e}children(t){if(this.overscaledZ>=t)return [new bp(this.overscaledZ+1,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y)];const e=this.canonical.z+1,r=2*this.canonical.x,n=2*this.canonical.y;return [new bp(e,this.wrap,e,r,n),new bp(e,this.wrap,e,r+1,n),new bp(e,this.wrap,e,r,n+1),new bp(e,this.wrap,e,r+1,n+1)]}isLessThan(t){return this.wrap<t.wrap||!(this.wrap>t.wrap)&&(this.overscaledZ<t.overscaledZ||!(this.overscaledZ>t.overscaledZ)&&(this.canonical.x<t.canonical.x||!(this.canonical.x>t.canonical.x)&&this.canonical.y<t.canonical.y))}wrapped(){return new bp(this.overscaledZ,0,this.canonical.z,this.canonical.x,this.canonical.y)}unwrapTo(t){return new bp(this.overscaledZ,t,this.canonical.z,this.canonical.x,this.canonical.y)}overscaleFactor(){return Math.pow(2,this.overscaledZ-this.canonical.z)}toUnwrapped(){return new vp(this.wrap,this.canonical)}toString(){return `${this.overscaledZ}/${this.canonical.x}/${this.canonical.y}`}}function wp(t,e,r,n,i){const s=1<<Math.min(r,22);let a=s*(i%s)+n%s;return t&&r<22&&(a+=s*s*((t<0?-2*t-1:2*t)%(1<<2*(22-r)))),16*(32*a+r)+(e-r)}Zi("CanonicalTileID",xp),Zi("OverscaledTileID",bp,{omit:["projMatrix"]});class _p{constructor(t,e,r){this.func=t,this.mask=e,this.range=r;}}_p.ReadOnly=!1,_p.ReadWrite=!0,_p.disabled=new _p(519,_p.ReadOnly,[0,1]);const Ap=7680;class kp{constructor(t,e,r,n,i,s){this.test=t,this.ref=e,this.mask=r,this.fail=n,this.depthFail=i,this.pass=s;}}kp.disabled=new kp({func:519,mask:0},0,0,Ap,Ap,Ap);class Sp{constructor(t,e,r){this.blendFunction=t,this.blendColor=e,this.mask=r;}}Sp.Replace=[1,0],Sp.disabled=new Sp(Sp.Replace,Ge.transparent,[!1,!1,!1,!1]),Sp.unblended=new Sp(Sp.Replace,Ge.transparent,[!0,!0,!0,!0]),Sp.alphaBlended=new Sp([1,771],Ge.transparent,[!0,!0,!0,!0]);const Ip=1029,zp=2305;class Mp{constructor(t,e,r){this.enable=t,this.mode=e,this.frontFace=r;}}Mp.disabled=new Mp(!1,Ip,zp),Mp.backCCW=new Mp(!0,Ip,zp),Mp.backCW=new Mp(!0,Ip,2304),Mp.frontCW=new Mp(!0,1028,2304),Mp.frontCCW=new Mp(!0,1028,zp);class Tp{constructor(t){this._stringToNumber={},this._numberToString=[];for(let e=0;e<t.length;e++){const r=t[e];this._stringToNumber[r]=e,this._numberToString[e]=r;}}encode(t){return this._stringToNumber[t]}decode(t){return this._numberToString[t]}}class Bp{constructor(t,e,r,n,i){this.type="Feature",this._vectorTileFeature=t,t._z=e,t._x=r,t._y=n,this.properties=t.properties,this.id=i;}get geometry(){return void 0===this._geometry&&(this._geometry=this._vectorTileFeature.toGeoJSON(this._vectorTileFeature._x,this._vectorTileFeature._y,this._vectorTileFeature._z).geometry),this._geometry}set geometry(t){this._geometry=t;}toJSON(){const t={geometry:this.geometry};for(const e in this)"_geometry"!==e&&"_vectorTileFeature"!==e&&(t[e]=this[e]);return t}}class Cp{constructor(){this.state={},this.stateChanges={},this.deletedStates={};}updateState(t,e,r){const n=String(e);if(this.stateChanges[t]=this.stateChanges[t]||{},this.stateChanges[t][n]=this.stateChanges[t][n]||{},tt(this.stateChanges[t][n],r),null===this.deletedStates[t]){this.deletedStates[t]={};for(const e in this.state[t])e!==n&&(this.deletedStates[t][e]=null);}else if(this.deletedStates[t]&&null===this.deletedStates[t][n]){this.deletedStates[t][n]={};for(const e in this.state[t][n])r[e]||(this.deletedStates[t][n][e]=null);}else for(const e in r)this.deletedStates[t]&&this.deletedStates[t][n]&&null===this.deletedStates[t][n][e]&&delete this.deletedStates[t][n][e];}removeFeatureState(t,e,r){if(null===this.deletedStates[t])return;const n=String(e);if(this.deletedStates[t]=this.deletedStates[t]||{},r&&void 0!==e)null!==this.deletedStates[t][n]&&(this.deletedStates[t][n]=this.deletedStates[t][n]||{},this.deletedStates[t][n][r]=null);else if(void 0!==e)if(this.stateChanges[t]&&this.stateChanges[t][n])for(r in this.deletedStates[t][n]={},this.stateChanges[t][n])this.deletedStates[t][n][r]=null;else this.deletedStates[t][n]=null;else this.deletedStates[t]=null;}getState(t,e){const r=String(e),n=tt({},(this.state[t]||{})[r],(this.stateChanges[t]||{})[r]);if(null===this.deletedStates[t])return {};if(this.deletedStates[t]){const r=this.deletedStates[t][e];if(null===r)return {};for(const t in r)delete n[t];}return n}initializeTileState(t,e){t.setFeatureState(this.state,e);}coalesceChanges(t,e){const r={};for(const t in this.stateChanges){this.state[t]=this.state[t]||{};const e={};for(const r in this.stateChanges[t])this.state[t][r]||(this.state[t][r]={}),tt(this.state[t][r],this.stateChanges[t][r]),e[r]=this.state[t][r];r[t]=e;}for(const t in this.deletedStates){this.state[t]=this.state[t]||{};const e={};if(null===this.deletedStates[t])for(const r in this.state[t])e[r]={},this.state[t][r]={};else for(const r in this.deletedStates[t]){if(null===this.deletedStates[t][r])this.state[t][r]={};else for(const e of Object.keys(this.deletedStates[t][r]))delete this.state[t][r][e];e[r]=this.state[t][r];}r[t]=r[t]||{},tt(r[t],e);}if(this.stateChanges={},this.deletedStates={},0!==Object.keys(r).length)for(const n in t)t[n].setFeatureState(r,e);}}class Pp{constructor(t){this.size=t,this.minimums=[],this.maximums=[],this.leaves=[];}getElevation(t,e){const r=this.toIdx(t,e);return {min:this.minimums[r],max:this.maximums[r]}}isLeaf(t,e){return this.leaves[this.toIdx(t,e)]}toIdx(t,e){return e*this.size+t}}function Ep(t,e,r,n){let i=0,s=Number.MAX_VALUE;for(let a=0;a<3;a++)if(Math.abs(n[a])<1e-15){if(r[a]<t[a]||r[a]>e[a])return null}else {const o=1/n[a];let l=(t[a]-r[a])*o,u=(e[a]-r[a])*o;if(l>u){const t=l;l=u,u=t;}if(l>i&&(i=l),u<s&&(s=u),i>s)return null}return i}function Dp(t,e,r,n,i,s,a,o,l,u,c){const h=n-t,p=i-e,d=s-r,f=a-t,y=o-e,m=l-r,g=c[1]*m-c[2]*y,x=c[2]*f-c[0]*m,v=c[0]*y-c[1]*f,b=h*g+p*x+d*v;if(Math.abs(b)<1e-15)return null;const w=1/b,_=u[0]-t,A=u[1]-e,k=u[2]-r,S=(_*g+A*x+k*v)*w;if(S<0||S>1)return null;const I=A*d-k*p,z=k*h-_*d,M=_*p-A*h,T=(c[0]*I+c[1]*z+c[2]*M)*w;return T<0||S+T>1?null:(f*I+y*z+m*M)*w}function Vp(t,e,r){return (t-e)/(r-e)}function Fp(t,e,r,n,i,s,a,o,l){const u=1<<r,c=s-n,h=a-i,p=(t+1)/u*c+n,d=(e+0)/u*h+i,f=(e+1)/u*h+i;o[0]=(t+0)/u*c+n,o[1]=d,l[0]=p,l[1]=f;}class Lp{constructor(t){if(this.maximums=[],this.minimums=[],this.leaves=[],this.childOffsets=[],this.nodeCount=0,this.dem=t,this._siblingOffset=[[0,0],[1,0],[0,1],[1,1]],!this.dem)return;const e=function(t){const e=Math.ceil(Math.log2(t.dim/8)),r=[];let n=Math.ceil(Math.pow(2,e));const i=1/n,s=(t,e,r,n,i)=>{const s=n?1:0,a=(t+1)*r-s,o=e*r,l=(e+1)*r-s;i[0]=t*r,i[1]=o,i[2]=a,i[3]=l;};let a=new Pp(n);const o=[];for(let e=0;e<n*n;e++){s(e%n,Math.floor(e/n),i,!1,o);const r=Up(o[0],o[1],t),l=Up(o[2],o[1],t),u=Up(o[2],o[3],t),c=Up(o[0],o[3],t);a.minimums.push(Math.min(r,l,u,c)),a.maximums.push(Math.max(r,l,u,c)),a.leaves.push(1);}for(r.push(a),n/=2;n>=1;n/=2){const t=r[r.length-1];a=new Pp(n);for(let e=0;e<n*n;e++){s(e%n,Math.floor(e/n),2,!0,o);const r=t.getElevation(o[0],o[1]),i=t.getElevation(o[2],o[1]),l=t.getElevation(o[2],o[3]),u=t.getElevation(o[0],o[3]),c=t.isLeaf(o[0],o[1]),h=t.isLeaf(o[2],o[1]),p=t.isLeaf(o[2],o[3]),d=t.isLeaf(o[0],o[3]),f=Math.min(r.min,i.min,l.min,u.min),y=Math.max(r.max,i.max,l.max,u.max),m=c&&h&&p&&d;a.maximums.push(y),a.minimums.push(f),a.leaves.push(y-f<=5&&m?1:0);}r.push(a);}return r}(this.dem),r=e.length-1,n=e[r];this._addNode(n.minimums[0],n.maximums[0],n.leaves[0]),this._construct(e,0,0,r,0);}raycastRoot(t,e,r,n,i,s,a=1){return Ep([t,e,-100],[r,n,this.maximums[0]*a],i,s)}raycast(t,e,r,n,i,s,a=1){if(!this.nodeCount)return null;const o=this.raycastRoot(t,e,r,n,i,s,a);if(null==o)return null;const l=[],u=[],c=[],h=[],p=[{idx:0,t:o,nodex:0,nodey:0,depth:0}];for(;p.length>0;){const{idx:o,t:d,nodex:f,nodey:y,depth:m}=p.pop();if(this.leaves[o]){Fp(f,y,m,t,e,r,n,c,h);const o=1<<m,l=(f+0)/o,u=(f+1)/o,p=(y+0)/o,g=(y+1)/o,x=Up(l,p,this.dem)*a,v=Up(u,p,this.dem)*a,b=Up(u,g,this.dem)*a,w=Up(l,g,this.dem)*a,_=Dp(c[0],c[1],x,h[0],c[1],v,h[0],h[1],b,i,s),A=Dp(h[0],h[1],b,c[0],h[1],w,c[0],c[1],x,i,s),k=Math.min(null!==_?_:Number.MAX_VALUE,null!==A?A:Number.MAX_VALUE);if(k!==Number.MAX_VALUE)return k;{const t=I([],i,s,d);if(Rp(x,v,w,b,Vp(t[0],c[0],h[0]),Vp(t[1],c[1],h[1]))>=t[2])return d}continue}let g=0;for(let p=0;p<this._siblingOffset.length;p++){Fp((f<<1)+this._siblingOffset[p][0],(y<<1)+this._siblingOffset[p][1],m+1,t,e,r,n,c,h),c[2]=-100,h[2]=this.maximums[this.childOffsets[o]+p]*a;const d=Ep(c,h,i,s);if(null!=d){const t=d;l[p]=t;let e=!1;for(let r=0;r<g&&!e;r++)t>=l[u[r]]&&(u.splice(r,0,p),e=!0);e||(u[g]=p),g++;}}for(let t=0;t<g;t++){const e=u[t];p.push({idx:this.childOffsets[o]+e,t:l[e],nodex:(f<<1)+this._siblingOffset[e][0],nodey:(y<<1)+this._siblingOffset[e][1],depth:m+1});}}return null}_addNode(t,e,r){return this.minimums.push(t),this.maximums.push(e),this.leaves.push(r),this.childOffsets.push(0),this.nodeCount++}_construct(t,e,r,n,i){if(1===t[n].isLeaf(e,r))return;this.childOffsets[i]||(this.childOffsets[i]=this.nodeCount);const s=n-1,a=t[s];let o,l=0;for(let t=0;t<this._siblingOffset.length;t++){const n=2*e+this._siblingOffset[t][0],i=2*r+this._siblingOffset[t][1],s=a.getElevation(n,i),u=a.isLeaf(n,i),c=this._addNode(s.min,s.max,u);u&&(l|=1<<t),o||(o=c);}for(let n=0;n<this._siblingOffset.length;n++)l&1<<n||this._construct(t,2*e+this._siblingOffset[n][0],2*r+this._siblingOffset[n][1],s,o+n);}}function Rp(t,e,r,n,i,s){return Lr(Lr(t,r,s),Lr(e,n,s),i)}function Up(t,e,r){const n=r.dim,i=Y(t*n-.5,0,n-1),s=Y(e*n-.5,0,n-1),a=Math.floor(i),o=Math.floor(s),l=Math.min(a+1,n-1),u=Math.min(o+1,n-1);return Rp(r.get(a,o),r.get(l,o),r.get(a,u),r.get(l,u),i-a,s-o)}const $p={mapbox:[6553.6,25.6,.1,1e4],terrarium:[256,1,1/256,32768]};class Op{get tree(){return this._tree||this._buildQuadTree(),this._tree}constructor(t,e,r,n=!1,i=!1){if(this.uid=t,e.height!==e.width)throw new RangeError("DEM tiles must be square");if(r&&"mapbox"!==r&&"terrarium"!==r)return pt(`"${r}" is not a valid encoding type. Valid types include "mapbox" and "terrarium".`);this.stride=e.height;const s=this.dim=e.height-2;if(this.data=new Uint32Array(e.data.buffer),this.encoding=r||"mapbox",this.borderReady=n,!n){for(let t=0;t<s;t++)this.data[this._idx(-1,t)]=this.data[this._idx(0,t)],this.data[this._idx(s,t)]=this.data[this._idx(s-1,t)],this.data[this._idx(t,-1)]=this.data[this._idx(t,0)],this.data[this._idx(t,s)]=this.data[this._idx(t,s-1)];this.data[this._idx(-1,-1)]=this.data[this._idx(0,0)],this.data[this._idx(s,-1)]=this.data[this._idx(s-1,0)],this.data[this._idx(-1,s)]=this.data[this._idx(0,s-1)],this.data[this._idx(s,s)]=this.data[this._idx(s-1,s-1)],i&&this._buildQuadTree();}}_buildQuadTree(){this._tree=new Lp(this);}get(t,e,r=!1){const n=new Uint8Array(this.data.buffer);r&&(t=Y(t,-1,this.dim),e=Y(e,-1,this.dim));const i=4*this._idx(t,e);return ("terrarium"===this.encoding?this._unpackTerrarium:this._unpackMapbox)(n[i],n[i+1],n[i+2])}static getUnpackVector(t){return $p[t]}get unpackVector(){return $p[this.encoding]}_idx(t,e){if(t<-1||t>=this.dim+1||e<-1||e>=this.dim+1)throw new RangeError("out of range source coordinates for DEM data");return (e+1)*this.stride+(t+1)}_unpackMapbox(t,e,r){return (256*t*256+256*e+r)/10-1e4}_unpackTerrarium(t,e,r){return 256*t+e+r/256-32768}static pack(t,e){const r=[0,0,0,0],n=Op.getUnpackVector(e);let i=Math.floor((t+n[3])/n[2]);return r[2]=i%256,i=Math.floor(i/256),r[1]=i%256,i=Math.floor(i/256),r[0]=i,r}getPixels(){return new Ml({width:this.stride,height:this.stride},new Uint8Array(this.data.buffer))}backfillBorder(t,e,r){if(this.dim!==t.dim)throw new Error("dem dimension mismatch");let n=e*this.dim,i=e*this.dim+this.dim,s=r*this.dim,a=r*this.dim+this.dim;switch(e){case-1:n=i-1;break;case 1:i=n+1;}switch(r){case-1:s=a-1;break;case 1:a=s+1;}const o=-e*this.dim,l=-r*this.dim;for(let e=s;e<a;e++)for(let r=n;r<i;r++)this.data[this._idx(r,e)]=t.data[this._idx(r+o,e+l)];}onDeserialize(){this._tree&&(this._tree.dem=this);}}Zi("DEMData",Op),Zi("DemMinMaxQuadTree",Lp,{omit:["dem"]});class jp{constructor(t,e){this.max=t,this.onRemove=e,this.reset();}reset(){for(const t in this.data)for(const e of this.data[t])e.timeout&&clearTimeout(e.timeout),this.onRemove(e.value);return this.data={},this.order=[],this}add(t,e,r){const n=t.wrapped().key;void 0===this.data[n]&&(this.data[n]=[]);const i={value:e,timeout:void 0};if(void 0!==r&&(i.timeout=setTimeout((()=>{this.remove(t,i);}),r)),this.data[n].push(i),this.order.push(n),this.order.length>this.max){const t=this._getAndRemoveByKey(this.order[0]);t&&this.onRemove(t);}return this}has(t){return t.wrapped().key in this.data}getAndRemove(t){return this.has(t)?this._getAndRemoveByKey(t.wrapped().key):null}_getAndRemoveByKey(t){const e=this.data[t].shift();return e.timeout&&clearTimeout(e.timeout),0===this.data[t].length&&delete this.data[t],this.order.splice(this.order.indexOf(t),1),e.value}getByKey(t){const e=this.data[t];return e?e[0].value:null}get(t){return this.has(t)?this.data[t.wrapped().key][0].value:null}remove(t,e){if(!this.has(t))return this;const r=t.wrapped().key,n=void 0===e?0:this.data[r].indexOf(e),i=this.data[r][n];return this.data[r].splice(n,1),i.timeout&&clearTimeout(i.timeout),0===this.data[r].length&&delete this.data[r],this.onRemove(i.value),this.order.splice(this.order.indexOf(r),1),this}setMaxSize(t){for(this.max=t;this.order.length>this.max;){const t=this._getAndRemoveByKey(this.order[0]);t&&this.onRemove(t);}return this}filter(t){const e=[];for(const r in this.data)for(const n of this.data[r])t(n.value)||e.push(n);for(const t of e)this.remove(t.value.tileID,t);}}class qp extends xe{constructor(t,e,r){super(),this.id=t,this._onlySymbols=r,e.on("data",(t=>{"source"===t.dataType&&"metadata"===t.sourceDataType&&(this._sourceLoaded=!0),this._sourceLoaded&&!this._paused&&"source"===t.dataType&&"content"===t.sourceDataType&&(this.reload(),this.transform&&this.update(this.transform));})),e.on("error",(()=>{this._sourceErrored=!0;})),this._source=e,this._tiles={},this._cache=new jp(0,this._unloadTile.bind(this)),this._timers={},this._cacheTimers={},this._minTileCacheSize=null,this._maxTileCacheSize=null,this._loadedParentTiles={},this._coveredTiles={},this._state=new Cp;}onAdd(t){this.map=t,this._minTileCacheSize=t?t._minTileCacheSize:null,this._maxTileCacheSize=t?t._maxTileCacheSize:null;}loaded(){if(this._sourceErrored)return !0;if(!this._sourceLoaded)return !1;if(!this._source.loaded())return !1;for(const t in this._tiles){const e=this._tiles[t];if("loaded"!==e.state&&"errored"!==e.state)return !1}return !0}getSource(){return this._source}pause(){this._paused=!0;}resume(){if(!this._paused)return;const t=this._shouldReloadOnResume;this._paused=!1,this._shouldReloadOnResume=!1,t&&this.reload(),this.transform&&this.update(this.transform);}_loadTile(t,e){return t.isSymbolTile=this._onlySymbols,this._source.loadTile(t,e)}_unloadTile(t){if(this._source.unloadTile)return this._source.unloadTile(t,(()=>{}))}_abortTile(t){if(this._source.abortTile)return this._source.abortTile(t,(()=>{}))}serialize(){return this._source.serialize()}prepare(t){this._source.prepare&&this._source.prepare(),this._state.coalesceChanges(this._tiles,this.map?this.map.painter:null);for(const e in this._tiles){const r=this._tiles[e];r.upload(t),r.prepare(this.map.style.imageManager);}}getIds(){return Q(this._tiles).map((t=>t.tileID)).sort(Np).map((t=>t.key))}getRenderableIds(t){const e=[];for(const r in this._tiles)this._isIdRenderable(+r,t)&&e.push(this._tiles[r]);return t?e.sort(((t,e)=>{const r=t.tileID,n=e.tileID,s=new i(r.canonical.x,r.canonical.y)._rotate(this.transform.angle),a=new i(n.canonical.x,n.canonical.y)._rotate(this.transform.angle);return r.overscaledZ-n.overscaledZ||a.y-s.y||a.x-s.x})).map((t=>t.tileID.key)):e.map((t=>t.tileID)).sort(Np).map((t=>t.key))}hasRenderableParent(t){const e=this.findLoadedParent(t,0);return !!e&&this._isIdRenderable(e.tileID.key)}_isIdRenderable(t,e){return this._tiles[t]&&this._tiles[t].hasData()&&!this._coveredTiles[t]&&(e||!this._tiles[t].holdingForFade())}reload(){if(this._paused)this._shouldReloadOnResume=!0;else {this._cache.reset();for(const t in this._tiles)"errored"!==this._tiles[t].state&&this._reloadTile(+t,"reloading");}}_reloadTile(t,e){const r=this._tiles[t];r&&("loading"!==r.state&&(r.state=e),this._loadTile(r,this._tileLoaded.bind(this,r,t,e)));}_tileLoaded(t,e,r,n){if(n)if(t.state="errored",404!==n.status)this._source.fire(new ge(n,{tile:t}));else if("raster-dem"===this._source.type&&this.usedForTerrain&&this.map.painter.terrain){const t=this.map.painter.terrain;this.update(this.transform,t.getScaledDemTileSize(),!0),t.resetTileLookupCache(this.id);}else this.update(this.transform);else t.timeAdded=At.now(),"expired"===r&&(t.refreshedUponExpiration=!0),this._setTileReloadTimer(e,t),"raster-dem"===this._source.type&&t.dem&&this._backfillDEM(t),this._state.initializeTileState(t,this.map?this.map.painter:null),this._source.fire(new me("data",{dataType:"source",tile:t,coord:t.tileID,sourceCacheId:this.id}));}_backfillDEM(t){const e=this.getRenderableIds();for(let n=0;n<e.length;n++){const i=e[n];if(t.neighboringTiles&&t.neighboringTiles[i]){const e=this.getTileByID(i);r(t,e),r(e,t);}}function r(t,e){if(!t.dem||t.dem.borderReady)return;t.needsHillshadePrepare=!0,t.needsDEMTextureUpload=!0;let r=e.tileID.canonical.x-t.tileID.canonical.x;const n=e.tileID.canonical.y-t.tileID.canonical.y,i=Math.pow(2,t.tileID.canonical.z),s=e.tileID.key;0===r&&0===n||Math.abs(n)>1||(Math.abs(r)>1&&(1===Math.abs(r+i)?r+=i:1===Math.abs(r-i)&&(r-=i)),e.dem&&t.dem&&(t.dem.backfillBorder(e.dem,r,n),t.neighboringTiles&&t.neighboringTiles[s]&&(t.neighboringTiles[s].backfilled=!0)));}}getTile(t){return this.getTileByID(t.key)}getTileByID(t){return this._tiles[t]}_retainLoadedChildren(t,e,r,n){for(const i in this._tiles){let s=this._tiles[i];if(n[i]||!s.hasData()||s.tileID.overscaledZ<=e||s.tileID.overscaledZ>r)continue;let a=s.tileID;for(;s&&s.tileID.overscaledZ>e+1;){const t=s.tileID.scaledTo(s.tileID.overscaledZ-1);s=this._tiles[t.key],s&&s.hasData()&&(a=t);}let o=a;for(;o.overscaledZ>e;)if(o=o.scaledTo(o.overscaledZ-1),t[o.key]){n[a.key]=a;break}}}findLoadedParent(t,e){if(t.key in this._loadedParentTiles){const r=this._loadedParentTiles[t.key];return r&&r.tileID.overscaledZ>=e?r:null}for(let r=t.overscaledZ-1;r>=e;r--){const e=t.scaledTo(r),n=this._getLoadedTile(e);if(n)return n}}_getLoadedTile(t){const e=this._tiles[t.key];return e&&e.hasData()?e:this._cache.getByKey(this._source.reparseOverscaled?t.wrapped().key:t.canonical.key)}updateCacheSize(t,e){e=e||this._source.tileSize;const r=Math.ceil(t.width/e)+1,n=Math.ceil(t.height/e)+1,i=Math.floor(r*n*5),s="number"==typeof this._minTileCacheSize?Math.max(this._minTileCacheSize,i):i,a="number"==typeof this._maxTileCacheSize?Math.min(this._maxTileCacheSize,s):s;this._cache.setMaxSize(a);}handleWrapJump(t){const e=Math.round((t-(void 0===this._prevLng?t:this._prevLng))/360);if(this._prevLng=t,e){const t={};for(const r in this._tiles){const n=this._tiles[r];n.tileID=n.tileID.unwrapTo(n.tileID.wrap+e),t[n.tileID.key]=n;}this._tiles=t;for(const t in this._timers)clearTimeout(this._timers[t]),delete this._timers[t];for(const t in this._tiles)this._setTileReloadTimer(+t,this._tiles[t]);}}update(t,e,r){if(this.transform=t,!this._sourceLoaded||this._paused||this.transform.freezeTileCoverage)return;if(this.usedForTerrain&&!r)return;let n;this.updateCacheSize(t,e),"globe"!==this.transform.projection.name&&this.handleWrapJump(this.transform.center.lng),this._coveredTiles={},this.used||this.usedForTerrain?this._source.tileID?n=t.getVisibleUnwrappedCoordinates(this._source.tileID).map((t=>new bp(t.canonical.z,t.wrap,t.canonical.z,t.canonical.x,t.canonical.y))):(n=t.coveringTiles({tileSize:e||this._source.tileSize,minzoom:this._source.minzoom,maxzoom:this._source.maxzoom,roundZoom:this._source.roundZoom&&!r,reparseOverscaled:this._source.reparseOverscaled,isTerrainDEM:this.usedForTerrain}),this._source.hasTile&&(n=n.filter((t=>this._source.hasTile(t))))):n=[];const i=this._updateRetainedTiles(n);if(Gp(this._source.type)&&0!==n.length){const t={},e={},r=Object.keys(i);for(const n of r){const r=i[n],s=this._tiles[n];if(!s||s.fadeEndTime&&s.fadeEndTime<=At.now())continue;const a=this.findLoadedParent(r,Math.max(r.overscaledZ-qp.maxOverzooming,this._source.minzoom));a&&(this._addTile(a.tileID),t[a.tileID.key]=a.tileID),e[n]=r;}const s=n[n.length-1].overscaledZ;for(const t in this._tiles){const r=this._tiles[t];if(i[t]||!r.hasData())continue;let n=r.tileID;for(;n.overscaledZ>s;){n=n.scaledTo(n.overscaledZ-1);const s=this._tiles[n.key];if(s&&s.hasData()&&e[n.key]){i[t]=r.tileID;break}}}for(const e in t)i[e]||(this._coveredTiles[e]=!0,i[e]=t[e]);}for(const t in i)this._tiles[t].clearFadeHold();const s=function(t,e){const r=[];for(const n in t)n in e||r.push(n);return r}(this._tiles,i);for(const t of s){const e=this._tiles[t];e.hasSymbolBuckets&&!e.holdingForFade()?e.setHoldDuration(this.map._fadeDuration):e.hasSymbolBuckets&&!e.symbolFadeFinished()||this._removeTile(+t);}this._updateLoadedParentTileCache(),this._onlySymbols&&this._source.afterUpdate&&this._source.afterUpdate();}releaseSymbolFadeTiles(){for(const t in this._tiles)this._tiles[t].holdingForFade()&&this._removeTile(+t);}_updateRetainedTiles(t){const e={};if(0===t.length)return e;const r={},n=t.reduce(((t,e)=>Math.min(t,e.overscaledZ)),1/0),i=t[0].overscaledZ,s=Math.max(i-qp.maxOverzooming,this._source.minzoom),a=Math.max(i+qp.maxUnderzooming,this._source.minzoom),o={};for(const r of t){const t=this._addTile(r);e[r.key]=r,t.hasData()||n<this._source.maxzoom&&(o[r.key]=r);}this._retainLoadedChildren(o,n,a,e);for(const n of t){let t=this._tiles[n.key];if(t.hasData())continue;if(n.canonical.z>=this._source.maxzoom){const t=n.children(this._source.maxzoom)[0],r=this.getTile(t);if(r&&r.hasData()){e[t.key]=t;continue}}else {const t=n.children(this._source.maxzoom);if(e[t[0].key]&&e[t[1].key]&&e[t[2].key]&&e[t[3].key])continue}let i=t.wasRequested();for(let a=n.overscaledZ-1;a>=s;--a){const s=n.scaledTo(a);if(r[s.key])break;if(r[s.key]=!0,t=this.getTile(s),!t&&i&&(t=this._addTile(s)),t&&(e[s.key]=s,i=t.wasRequested(),t.hasData()))break}}return e}_updateLoadedParentTileCache(){this._loadedParentTiles={};for(const t in this._tiles){const e=[];let r,n=this._tiles[t].tileID;for(;n.overscaledZ>0;){if(n.key in this._loadedParentTiles){r=this._loadedParentTiles[n.key];break}e.push(n.key);const t=n.scaledTo(n.overscaledZ-1);if(r=this._getLoadedTile(t),r)break;n=t;}for(const t of e)this._loadedParentTiles[t]=r;}}_addTile(t){let e=this._tiles[t.key];if(e)return e;e=this._cache.getAndRemove(t),e&&(this._setTileReloadTimer(t.key,e),e.tileID=t,this._state.initializeTileState(e,this.map?this.map.painter:null),this._cacheTimers[t.key]&&(clearTimeout(this._cacheTimers[t.key]),delete this._cacheTimers[t.key],this._setTileReloadTimer(t.key,e)));const r=Boolean(e);if(!r){const r=this.map?this.map.painter:null,n="raster"===this._source.type||"raster-dem"===this._source.type;e=new ad(t,this._source.tileSize*t.overscaleFactor(),this.transform.tileZoom,r,n),this._loadTile(e,this._tileLoaded.bind(this,e,t.key,e.state));}return e?(e.uses++,this._tiles[t.key]=e,r||this._source.fire(new me("dataloading",{tile:e,coord:e.tileID,dataType:"source"})),e):null}_setTileReloadTimer(t,e){t in this._timers&&(clearTimeout(this._timers[t]),delete this._timers[t]);const r=e.getExpiryTimeout();r&&(this._timers[t]=setTimeout((()=>{this._reloadTile(t,"expired"),delete this._timers[t];}),r));}_removeTile(t){const e=this._tiles[t];e&&(e.uses--,delete this._tiles[t],this._timers[t]&&(clearTimeout(this._timers[t]),delete this._timers[t]),e.uses>0||(e.hasData()&&"reloading"!==e.state?this._cache.add(e.tileID,e,e.getExpiryTimeout()):(e.aborted=!0,this._abortTile(e),this._unloadTile(e))));}clearTiles(){this._shouldReloadOnResume=!1,this._paused=!1;for(const t in this._tiles)this._removeTile(+t);this._source._clear&&this._source._clear(),this._cache.reset();}tilesIn(t,e,r){const n=[],i=this.transform;if(!i)return n;for(const s in this._tiles){const a=this._tiles[s];if(r&&a.clearQueryDebugViz(),a.holdingForFade())continue;const o=t.containsTile(a,i,e);o&&n.push(o);}return n}getVisibleCoordinates(t){const e=this.getRenderableIds(t).map((t=>this._tiles[t].tileID));for(const t of e)t.projMatrix=this.transform.calculateProjMatrix(t.toUnwrapped());return e}hasTransition(){if(this._source.hasTransition())return !0;if(Gp(this._source.type))for(const t in this._tiles){const e=this._tiles[t];if(void 0!==e.fadeEndTime&&e.fadeEndTime>=At.now())return !0}return !1}setFeatureState(t,e,r){this._state.updateState(t=t||"_geojsonTileLayer",e,r);}removeFeatureState(t,e,r){this._state.removeFeatureState(t=t||"_geojsonTileLayer",e,r);}getFeatureState(t,e){return this._state.getState(t=t||"_geojsonTileLayer",e)}setDependencies(t,e,r){const n=this._tiles[t];n&&n.setDependencies(e,r);}reloadTilesForDependencies(t,e){for(const r in this._tiles)this._tiles[r].hasDependency(t,e)&&this._reloadTile(+r,"reloading");this._cache.filter((r=>!r.hasDependency(t,e)));}_preloadTiles(t,e){const r=new Map,n=Array.isArray(t)?t:[t],i=this.map.painter.terrain,s=this.usedForTerrain&&i?i.getScaledDemTileSize():this._source.tileSize;for(const t of n){const e=t.coveringTiles({tileSize:s,minzoom:this._source.minzoom,maxzoom:this._source.maxzoom,roundZoom:this._source.roundZoom&&!this.usedForTerrain,reparseOverscaled:this._source.reparseOverscaled,isTerrainDEM:this.usedForTerrain});for(const t of e)r.set(t.key,t);this.usedForTerrain&&t.updateElevation(!1);}const a=Array.from(r.values()),o="raster"===this._source.type||"raster-dem"===this._source.type;W(a,((t,e)=>{const r=new ad(t,this._source.tileSize*t.overscaleFactor(),this.transform.tileZoom,this.map.painter,o);this._loadTile(r,(t=>{"raster-dem"===this._source.type&&r.dem&&this._backfillDEM(r),e(t,r);}));}),e);}}function Np(t,e){const r=Math.abs(2*t.wrap)-+(t.wrap<0),n=Math.abs(2*e.wrap)-+(e.wrap<0);return t.overscaledZ-e.overscaledZ||n-r||e.canonical.y-t.canonical.y||e.canonical.x-t.canonical.x}function Gp(t){return "raster"===t||"image"===t||"video"===t}qp.maxOverzooming=10,qp.maxUnderzooming=3;class Zp{constructor(t,e,r){this._demTile=t,this._dem=this._demTile.dem,this._scale=e,this._offset=r;}static create(t,e,r){const n=r||t.findDEMTileFor(e);if(!n||!n.dem)return;const i=n.dem,s=n.tileID,a=1<<e.canonical.z-s.canonical.z;return new Zp(n,n.tileSize/To/a,[(e.canonical.x/a-s.canonical.x)*i.dim,(e.canonical.y/a-s.canonical.y)*i.dim])}tileCoordToPixel(t,e){const r=e*this._scale+this._offset[1],n=Math.floor(t*this._scale+this._offset[0]),s=Math.floor(r);return new i(n,s)}getElevationAt(t,e,r,n){const i=t*this._scale+this._offset[0],s=e*this._scale+this._offset[1],a=Math.floor(i),o=Math.floor(s),l=this._dem;return n=!!n,r?Lr(Lr(l.get(a,o,n),l.get(a,o+1,n),s-o),Lr(l.get(a+1,o,n),l.get(a+1,o+1,n),s-o),i-a):l.get(a,o,n)}getElevationAtPixel(t,e,r){return this._dem.get(t,e,!!r)}getMeterToDEM(t){return (1<<this._demTile.tileID.canonical.z)*Lo(1,t)*this._dem.stride}}class Xp{constructor(t,e){this.tileID=t,this.x=t.canonical.x,this.y=t.canonical.y,this.z=t.canonical.z,this.grid=new Oi(To,16,0),this.featureIndexArray=new Na,this.promoteId=e;}insert(t,e,r,n,i,s=0){const a=this.featureIndexArray.length;this.featureIndexArray.emplaceBack(r,n,i,s);const o=this.grid;for(let t=0;t<e.length;t++){const r=e[t],n=[1/0,1/0,-1/0,-1/0];for(let t=0;t<r.length;t++){const e=r[t];n[0]=Math.min(n[0],e.x),n[1]=Math.min(n[1],e.y),n[2]=Math.max(n[2],e.x),n[3]=Math.max(n[3],e.y);}n[0]<To&&n[1]<To&&n[2]>=0&&n[3]>=0&&o.insert(a,n[0],n[1],n[2],n[3]);}}loadVTLayers(){if(!this.vtLayers){this.vtLayers=new Bu.VectorTile(new gc(this.rawTileData)).layers,this.sourceLayerCoder=new Tp(this.vtLayers?Object.keys(this.vtLayers).sort():["_geojsonTileLayer"]),this.vtFeatures={};for(const t in this.vtLayers)this.vtFeatures[t]=[];}return this.vtLayers}query(t,e,r,n){this.loadVTLayers();const i=t.params||{},s=si(i.filter),a=t.tileResult,o=t.transform,l=a.bufferedTilespaceBounds,u=this.grid.query(l.min.x,l.min.y,l.max.x,l.max.y,((t,e,r,n)=>ll(a.bufferedTilespaceGeometry,t,e,r,n)));u.sort(Yp);let c=null;o.elevation&&u.length>0&&(c=Zp.create(o.elevation,this.tileID));const h={};let p;for(let o=0;o<u.length;o++){const l=u[o];if(l===p)continue;p=l;const d=this.featureIndexArray.get(l);let f=null;this.loadMatchingFeature(h,d,s,i.layers,i.availableImages,e,r,n,((e,r,n,i=0)=>(f||(f=Ko(e,this.tileID.canonical,t.tileTransform)),r.queryIntersectsFeature(a,e,n,f,this.z,t.transform,t.pixelPosMatrix,c,i))));}return h}loadMatchingFeature(t,e,r,n,i,s,a,o,l){const{featureIndex:u,bucketIndex:c,sourceLayerIndex:h,layoutVertexArrayOffset:p}=e,d=this.bucketLayerIDs[c];if(n&&!function(t,e){for(let r=0;r<t.length;r++)if(e.indexOf(t[r])>=0)return !0;return !1}(n,d))return;const f=this.sourceLayerCoder.decode(h),y=this.vtLayers[f].feature(u);if(r.needGeometry){const t=Yo(y,!0);if(!r.filter(new Gs(this.tileID.overscaledZ),t,this.tileID.canonical))return}else if(!r.filter(new Gs(this.tileID.overscaledZ),y))return;const m=this.getId(y,f);for(let e=0;e<d.length;e++){const r=d[e];if(n&&n.indexOf(r)<0)continue;const c=s[r];if(!c)continue;let h={};void 0!==m&&o&&(h=o.getState(c.sourceLayer||"_geojsonTileLayer",m));const f=tt({},a[r]);f.paint=Kp(f.paint,c.paint,y,h,i),f.layout=Kp(f.layout,c.layout,y,h,i);const g=!l||l(y,c,h,p);if(!g)continue;const x=new Bp(y,this.z,this.x,this.y,m);x.layer=f;let v=t[r];void 0===v&&(v=t[r]=[]),v.push({featureIndex:u,feature:x,intersectionZ:g});}}lookupSymbolFeatures(t,e,r,n,i,s,a,o){const l={};this.loadVTLayers();const u=si(i);for(const i of t)this.loadMatchingFeature(l,{bucketIndex:r,sourceLayerIndex:n,featureIndex:i,layoutVertexArrayOffset:0},u,s,a,o,e);return l}loadFeature(t){const{featureIndex:e,sourceLayerIndex:r}=t;this.loadVTLayers();const n=this.sourceLayerCoder.decode(r),i=this.vtFeatures[n];if(i[e])return i[e];const s=this.vtLayers[n].feature(e);return i[e]=s,s}hasLayer(t){for(const e of this.bucketLayerIDs)for(const r of e)if(t===r)return !0;return !1}getId(t,e){let r=t.id;return this.promoteId&&(r=t.properties["string"==typeof this.promoteId?this.promoteId:this.promoteId[e]],"boolean"==typeof r&&(r=Number(r))),r}}function Kp(t,e,r,n,i){return lt(t,((t,s)=>{const a=e instanceof Qs?e.get(s):null;return a&&a.evaluate?a.evaluate(r,n,i):a}))}function Yp(t,e){return e-t}Zi("FeatureIndex",Xp,{omit:["rawTileData","sourceLayerCoder"]});var Hp=ca([{name:"a_pos",type:"Int16",components:2}]);const Jp=32,Wp=33,Qp=new Uint16Array(8184);for(let t=0;t<2046;t++){let e=t+2,r=0,n=0,i=0,s=0,a=0,o=0;for(1&e?i=s=a=Jp:r=n=o=Jp;(e>>=1)>1;){const t=r+i>>1,l=n+s>>1;1&e?(i=r,s=n,r=a,n=o):(r=i,n=s,i=a,s=o),a=t,o=l;}const l=4*t;Qp[l+0]=r,Qp[l+1]=n,Qp[l+2]=i,Qp[l+3]=s;}const td=new Uint16Array(2178),ed=new Uint8Array(1089),rd=new Uint16Array(1089);function nd(t){return 0===t?-.03125:32===t?.03125:0}var id=ca([{name:"a_pos",type:"Int16",components:2},{name:"a_texture_pos",type:"Int16",components:2}]);const sd={type:2,extent:To,loadGeometry:()=>[[new i(0,0),new i(8193,0),new i(8193,8193),new i(0,8193),new i(0,0)]]};class ad{constructor(t,e,r,n,i){this.tileID=t,this.uid=rt(),this.uses=0,this.tileSize=e,this.tileZoom=r,this.buckets={},this.expirationTime=null,this.queryPadding=0,this.hasSymbolBuckets=!1,this.hasRTLText=!1,this.dependencies={},this.isRaster=i,this.expiredRequestCount=0,this.state="loading",n&&n.transform&&(this.projection=n.transform.projection);}registerFadeDuration(t){const e=t+this.timeAdded;e<At.now()||this.fadeEndTime&&e<this.fadeEndTime||(this.fadeEndTime=e);}wasRequested(){return "errored"===this.state||"loaded"===this.state||"reloading"===this.state}get tileTransform(){return this._tileTransform||(this._tileTransform=Ad(this.tileID.canonical,this.projection)),this._tileTransform}loadVectorData(t,e,r){if(this.unloadVectorData(),this.state="loaded",t){t.featureIndex&&(this.latestFeatureIndex=t.featureIndex,t.rawTileData?(this.latestRawTileData=t.rawTileData,this.latestFeatureIndex.rawTileData=t.rawTileData):this.latestRawTileData&&(this.latestFeatureIndex.rawTileData=this.latestRawTileData)),this.collisionBoxArray=t.collisionBoxArray,this.buckets=function(t,e){const r={};if(!e)return r;for(const n of t){const t=n.layerIds.map((t=>e.getLayer(t))).filter(Boolean);if(0!==t.length){n.layers=t,n.stateDependentLayerIds&&(n.stateDependentLayers=n.stateDependentLayerIds.map((e=>t.filter((t=>t.id===e))[0])));for(const e of t)r[e.id]=n;}}return r}(t.buckets,e.style),this.hasSymbolBuckets=!1;for(const t in this.buckets){const e=this.buckets[t];if(e instanceof Yh){if(this.hasSymbolBuckets=!0,!r)break;e.justReloaded=!0;}}if(this.hasRTLText=!1,this.hasSymbolBuckets)for(const t in this.buckets){const e=this.buckets[t];if(e instanceof Yh&&e.hasRTLText){this.hasRTLText=!0,Ns.isLoading()||Ns.isLoaded()||"deferred"!==js()||qs();break}}this.queryPadding=0;for(const t in this.buckets){const r=this.buckets[t];this.queryPadding=Math.max(this.queryPadding,e.style.getLayer(t).queryRadius(r));}t.imageAtlas&&(this.imageAtlas=t.imageAtlas),t.glyphAtlasImage&&(this.glyphAtlasImage=t.glyphAtlasImage),t.lineAtlas&&(this.lineAtlas=t.lineAtlas);}else this.collisionBoxArray=new Fa;}unloadVectorData(){if(this.hasData()){for(const t in this.buckets)this.buckets[t].destroy();this.buckets={},this.imageAtlas&&(this.imageAtlas=null),this.lineAtlas&&(this.lineAtlas=null),this.imageAtlasTexture&&this.imageAtlasTexture.destroy(),this.glyphAtlasTexture&&this.glyphAtlasTexture.destroy(),this.lineAtlasTexture&&this.lineAtlasTexture.destroy(),this._tileBoundsBuffer&&(this._tileBoundsBuffer.destroy(),this._tileBoundsIndexBuffer.destroy(),this._tileBoundsSegments.destroy(),this._tileBoundsBuffer=null),this._tileDebugBuffer&&(this._tileDebugBuffer.destroy(),this._tileDebugIndexBuffer.destroy(),this._tileDebugSegments.destroy(),this._tileDebugBuffer=null),this.globeGridBuffer&&(this.globeGridBuffer.destroy(),this.globeGridBuffer=null),this.globePoleBuffer&&(this.globePoleBuffer.destroy(),this.globePoleBuffer=null),this.latestFeatureIndex=null,this.state="unloaded";}}getBucket(t){return this.buckets[t.id]}upload(t){for(const e in this.buckets){const r=this.buckets[e];r.uploadPending()&&r.upload(t);}const e=t.gl;this.imageAtlas&&!this.imageAtlas.uploaded&&(this.imageAtlasTexture=new hp(t,this.imageAtlas.image,e.RGBA),this.imageAtlas.uploaded=!0),this.glyphAtlasImage&&(this.glyphAtlasTexture=new hp(t,this.glyphAtlasImage,e.ALPHA),this.glyphAtlasImage=null),this.lineAtlas&&!this.lineAtlas.uploaded&&(this.lineAtlasTexture=new hp(t,this.lineAtlas.image,e.ALPHA),this.lineAtlas.uploaded=!0);}prepare(t){this.imageAtlas&&this.imageAtlas.patchUpdatedImages(t,this.imageAtlasTexture);}queryRenderedFeatures(t,e,r,n,i,s,a,o){return this.latestFeatureIndex&&this.latestFeatureIndex.rawTileData?this.latestFeatureIndex.query({tileResult:n,pixelPosMatrix:a,transform:s,params:i,tileTransform:this.tileTransform},t,e,r):{}}querySourceFeatures(t,e){const r=this.latestFeatureIndex;if(!r||!r.rawTileData)return;const n=r.loadVTLayers(),i=e?e.sourceLayer:"",s=n._geojsonTileLayer||n[i];if(!s)return;const a=si(e&&e.filter),{z:o,x:l,y:u}=this.tileID.canonical,c={z:o,x:l,y:u};for(let e=0;e<s.length;e++){const n=s.feature(e);if(a.needGeometry){const t=Yo(n,!0);if(!a.filter(new Gs(this.tileID.overscaledZ),t,this.tileID.canonical))continue}else if(!a.filter(new Gs(this.tileID.overscaledZ),n))continue;const h=r.getId(n,i),p=new Bp(n,o,l,u,h);p.tile=c,t.push(p);}}hasData(){return "loaded"===this.state||"reloading"===this.state||"expired"===this.state}patternsLoaded(){return this.imageAtlas&&!!Object.keys(this.imageAtlas.patternPositions).length}setExpiryData(t){const e=this.expirationTime;if(t.cacheControl){const e=mt(t.cacheControl);e["max-age"]&&(this.expirationTime=Date.now()+1e3*e["max-age"]);}else t.expires&&(this.expirationTime=new Date(t.expires).getTime());if(this.expirationTime){const t=Date.now();let r=!1;if(this.expirationTime>t)r=!1;else if(e)if(this.expirationTime<e)r=!0;else {const n=this.expirationTime-e;n?this.expirationTime=t+Math.max(n,3e4):r=!0;}else r=!0;r?(this.expiredRequestCount++,this.state="expired"):this.expiredRequestCount=0;}}getExpiryTimeout(){if(this.expirationTime)return this.expiredRequestCount?1e3*(1<<Math.min(this.expiredRequestCount-1,31)):Math.min(this.expirationTime-(new Date).getTime(),Math.pow(2,31)-1)}setFeatureState(t,e){if(!this.latestFeatureIndex||!this.latestFeatureIndex.rawTileData||0===Object.keys(t).length||!e)return;const r=this.latestFeatureIndex.loadVTLayers(),n=e.style.listImages();for(const i in this.buckets){if(!e.style.hasLayer(i))continue;const s=this.buckets[i],a=s.layers[0].sourceLayer||"_geojsonTileLayer",o=r[a],l=t[a];if(!o||!l||0===Object.keys(l).length)continue;if(s.update(l,o,n,this.imageAtlas&&this.imageAtlas.patternPositions||{}),s instanceof Ku||s instanceof mu){const t=e.style._getSourceCache(s.layers[0].source);e._terrain&&e._terrain.enabled&&t&&s.programConfigurations.needsUpload&&e._terrain._clearRenderCacheForTile(t.id,this.tileID);}const u=e&&e.style&&e.style.getLayer(i);u&&(this.queryPadding=Math.max(this.queryPadding,u.queryRadius(s)));}}holdingForFade(){return void 0!==this.symbolFadeHoldUntil}symbolFadeFinished(){return !this.symbolFadeHoldUntil||this.symbolFadeHoldUntil<At.now()}clearFadeHold(){this.symbolFadeHoldUntil=void 0;}setHoldDuration(t){this.symbolFadeHoldUntil=At.now()+t;}setDependencies(t,e){const r={};for(const t of e)r[t]=!0;this.dependencies[t]=r;}hasDependency(t,e){for(const r of t){const t=this.dependencies[r];if(t)for(const r of e)if(t[r])return !0}return !1}clearQueryDebugViz(){}_makeDebugTileBoundsBuffers(t,e){if(!e||"mercator"===e.name||this._tileDebugBuffer)return;const r=Ko(sd,this.tileID.canonical,this.tileTransform)[0],n=new pa,i=new Pa;for(let t=0;t<r.length;t++){const{x:e,y:s}=r[t];n.emplaceBack(e,s),i.emplaceBack(t);}i.emplaceBack(0),this._tileDebugIndexBuffer=t.createIndexBuffer(i),this._tileDebugBuffer=t.createVertexBuffer(n,id.members),this._tileDebugSegments=Mo.simpleSegment(0,0,n.length,i.length);}_makeTileBoundsBuffers(t,e){if(this._tileBoundsBuffer||!e||"mercator"===e.name)return;const r=Ko(sd,this.tileID.canonical,this.tileTransform)[0];let n,i;if(this.isRaster){const t=function(t,e){const r=Ad(t,e),n=Math.pow(2,t.z);for(let i=0;i<Wp;i++)for(let s=0;s<Wp;s++){const a=Ro((t.x+(s+nd(s))/Jp)/n),o=Uo((t.y+(i+nd(i))/Jp)/n),l=e.project(a,o),u=i*Wp+s;td[2*u+0]=Math.round((l.x*r.scale-r.x)*To),td[2*u+1]=Math.round((l.y*r.scale-r.y)*To);}ed.fill(0),rd.fill(0);for(let t=2045;t>=0;t--){const e=4*t,r=Qp[e+0],n=Qp[e+1],i=Qp[e+2],s=Qp[e+3],a=r+i>>1,o=n+s>>1,l=a+o-n,u=o+r-a,c=n*Wp+r,h=s*Wp+i,p=o*Wp+a,d=Math.hypot((td[2*c+0]+td[2*h+0])/2-td[2*p+0],(td[2*c+1]+td[2*h+1])/2-td[2*p+1])>=16;if(ed[p]=ed[p]||(d?1:0),t<1022){const t=(n+u>>1)*Wp+(r+l>>1),e=(s+u>>1)*Wp+(i+l>>1);ed[p]=ed[p]||ed[t]||ed[e];}}const i=new da,s=new ka;let a=0;function o(t,e){const r=e*Wp+t;return 0===rd[r]&&(i.emplaceBack(td[2*r+0],td[2*r+1],t*To/Jp,e*To/Jp),rd[r]=++a),rd[r]-1}function l(t,e,r,n,i,a){const u=t+r>>1,c=e+n>>1;if(Math.abs(t-i)+Math.abs(e-a)>1&&ed[c*Wp+u])l(i,a,t,e,u,c),l(r,n,i,a,u,c);else {const l=o(t,e),u=o(r,n),c=o(i,a);s.emplaceBack(l,u,c);}}return l(0,0,Jp,Jp,Jp,0),l(Jp,Jp,0,0,0,Jp),{vertices:i,indices:s}}(this.tileID.canonical,e);n=t.vertices,i=t.indices;}else {n=new da,i=new ka;for(const{x:t,y:e}of r)n.emplaceBack(t,e,0,0);const t=Dl(n.int16,void 0,4);for(let e=0;e<t.length;e+=3)i.emplaceBack(t[e],t[e+1],t[e+2]);}this._tileBoundsBuffer=t.createVertexBuffer(n,id.members),this._tileBoundsIndexBuffer=t.createIndexBuffer(i),this._tileBoundsSegments=Mo.simpleSegment(0,0,n.length,i.length);}}const od=ca([{type:"Float32",name:"a_globe_pos",components:3},{type:"Float32",name:"a_merc_pos",components:2},{type:"Float32",name:"a_uv",components:2}]),ld=ca([{type:"Float32",name:"a_pos",components:3},{type:"Float32",name:"a_uv",components:2}]),{members:ud}=od;function cd(t,e){const r=t.fovAboveCenter,n=t.elevation?t.elevation.getMinElevationBelowMSL()*e:0,i=(t._camera.position[2]*t.worldSize-n)/Math.cos(t._pitch),s=Math.sin(r)*i/Math.sin(Math.max(Math.PI/2-t._pitch-r,.01)),a=Math.sin(t._pitch)*s+i;return Math.min(1.01*a,i*(1/t._horizonShift))}const hd=To/Math.PI/2,pd=-hd,dd=hd,fd=[new gl([pd,pd,pd],[dd,dd,dd]),new gl([pd,pd,pd],[0,0,dd]),new gl([0,pd,pd],[dd,0,dd]),new gl([pd,0,pd],[0,dd,dd]),new gl([0,0,pd],[dd,dd,dd])];function yd(t){if(t.z<=1)return fd[t.z+2*t.y+t.x];const[e,r]=md(t),n=[xd(e[0],e[1]),xd(e[0],r[1]),xd(r[0],e[1]),xd(r[0],r[1])],i=[dd,dd,dd],s=[pd,pd,pd];for(const t of n)i[0]=Math.min(i[0],t[0]),i[1]=Math.min(i[1],t[1]),i[2]=Math.min(i[2],t[2]),s[0]=Math.max(s[0],t[0]),s[1]=Math.max(s[1],t[1]),s[2]=Math.max(s[2],t[2]);return new gl(i,s)}function md(t){const e=Math.pow(2,t.z),r=t.x/e,n=(t.x+1)/e,i=(t.y+1)/e;return [[Uo(t.y/e),Ro(r)],[Uo(i),Ro(n)]]}function gd(t,e,r,n){return r=q(r),n||(n=hd),[t*Math.sin(r)*n,-e*n,t*Math.cos(r)*n]}function xd(t,e,r){return gd(Math.cos(q(t)),Math.sin(q(t)),e,r)}function vd(t){return 16383/Math.max(...E([],t.max,t.min))}function bd(t){const e=c(new Float64Array(16)),r=1/vd(t);return p(e,e,t.min),d(e,e,[r,r,r]),e}function wd(t,e,r){const n=e/(2*Math.PI),i=function(t){const e=To/(2*Math.PI);return t/(2*Math.PI)/e}(e);if(!r){const n=Y(t.center.lat,-85.051129,Oo);r=[Vo(t.center.lng)*e,Fo(n)*e];}const s=c(new Float64Array(16));return p(s,s,[r[0],r[1],-n]),d(s,s,[i,i,i]),f(s,s,q(-t._center.lat)),y(s,s,q(-t._center.lng)),s}class _d{constructor(t){const e=this._createGridIndices();this.gridIndexBuffer=t.createIndexBuffer(e,!0),this.gridSegments=Mo.simpleSegment(0,0,4225,8192);const r=this._createPoleTriangleIndices();this.poleIndexBuffer=t.createIndexBuffer(r,!0),this.poleSegments=Mo.simpleSegment(0,0,66,64);const n=new Ta;n.emplaceBack(-1,1,1,0,0,0,0),n.emplaceBack(1,1,1,0,0,1,0),n.emplaceBack(1,-1,1,0,0,1,1),n.emplaceBack(-1,-1,1,0,0,0,1);const i=new ka;i.emplaceBack(0,1,2),i.emplaceBack(2,3,0),this.atmosphereVertexBuffer=t.createVertexBuffer(n,ld.members),this.atmosphereIndexBuffer=t.createIndexBuffer(i),this.atmosphereSegments=Mo.simpleSegment(0,0,4,2);}destroy(){this.poleIndexBuffer.destroy(),this.gridIndexBuffer.destroy(),this.poleSegments.destroy(),this.gridSegments.destroy(),this.atmosphereVertexBuffer.destroy(),this.atmosphereIndexBuffer.destroy(),this.atmosphereSegments.destroy(),this.wireframeIndexBuffer&&(this.wireframeIndexBuffer.destroy(),this.wireframeSegments.destroy());}static createPoleTriangleVertices(t,e,r){const n=new Ta,i=e/Math.PI/2;n.emplaceBack(0,-i,0,0,0,.5,r?0:1);const s=360/t,a=Math.cos(q(85)),o=Math.sin(q(85));for(let t=0;t<=64;t++){const e=t/64,u=gd(a,o,0*(1-(l=e))+s*l,i);n.emplaceBack(u[0],u[1],u[2],0,0,e,r?0:1);}var l;return n}_createPoleTriangleIndices(){const t=new ka;for(let e=0;e<=64;e++)t.emplaceBack(0,e+1,e+2);return t}static createGridVertices(t){const e=Math.pow(2,t.z),r=(t,e,r)=>t*(1-r)+e*r,[n,i]=md(t),s=new Ta,a=function(t){const e=c(new Float64Array(16)),r=vd(t);var n,i;return d(e,e,[r,r,r]),p(e,e,((n=[])[0]=-(i=t.min)[0],n[1]=-i[1],n[2]=-i[2],n)),e}(yd(t));s.reserve(4096);for(let o=0;o<65;o++){const l=r(n[0],i[0],o/64),u=Fo(l),c=u*e-t.y,h=Math.sin(q(l)),p=Math.cos(q(l));for(let t=0;t<65;t++){const e=t/64,o=r(n[1],i[1],e),l=gd(p,h,o);B(l,l,a);const d=Vo(o);s.emplaceBack(l[0],l[1],l[2],d,u,e,c);}}return s}_createGridIndices(){const t=new ka,e=(e,r)=>{const n=65*r+e;t.emplaceBack(n+1,n,n+65),t.emplaceBack(n+65,n+65+1,n+1);};for(let t=0;t<64;t++)for(let r=0;r<64;r++)e(r,t);return t}getWirefameBuffer(t){if(!this.wireframeSegments){const e=this._createWireframeGrid();this.wireframeIndexBuffer=t.createIndexBuffer(e),this.wireframeSegments=Mo.simpleSegment(0,0,4096,e.length);}return [this.wireframeIndexBuffer,this.wireframeSegments]}_createWireframeGrid(){const t=new Ca,e=(e,r)=>{const n=65*r+e;t.emplaceBack(n,n+1),t.emplaceBack(n,n+65),t.emplaceBack(n,n+65+1);};for(let t=0;t<64;t++)for(let r=0;r<64;r++)e(r,t);return t}}function Ad(t,e){if(!e.isReprojectedInTileSpace)return {scale:1<<t.z,x:t.x,y:t.y,x2:t.x+1,y2:t.y+1,projection:e};const r=Math.pow(2,-t.z),n=t.x*r,i=(t.x+1)*r,s=t.y*r,a=(t.y+1)*r,o=Ro(n),l=Ro(i),u=Uo(s),c=Uo(a),h=e.project(o,u),p=e.project(l,u),d=e.project(l,c),f=e.project(o,c);let y=Math.min(h.x,p.x,d.x,f.x),m=Math.min(h.y,p.y,d.y,f.y),g=Math.max(h.x,p.x,d.x,f.x),x=Math.max(h.y,p.y,d.y,f.y);const v=r/16;function b(t,r,n,i,s,a){const o=(n+s)/2,l=(i+a)/2,u=e.project(Ro(o),Uo(l)),c=Math.max(0,y-u.x,m-u.y,u.x-g,u.y-x);y=Math.min(y,u.x),g=Math.max(g,u.x),m=Math.min(m,u.y),x=Math.max(x,u.y),c>v&&(b(t,u,n,i,o,l),b(u,r,o,l,s,a));}b(h,p,n,s,i,s),b(p,d,i,s,i,a),b(d,f,i,a,n,a),b(f,h,n,a,n,s),y-=v,m-=v,g+=v,x+=v;const w=1/Math.max(g-y,x-m);return {scale:w,x:y*w,y:m*w,x2:g*w,y2:x*w,projection:e}}class kd{constructor(t){const e={},r=[];for(const n in t){const i=t[n],s=e[n]={};for(const t in i.glyphs){const e=i.glyphs[+t];if(!e||0===e.bitmap.width||0===e.bitmap.height)continue;const n=e.metrics.localGlyph?2:1,a={x:0,y:0,w:e.bitmap.width+2*n,h:e.bitmap.height+2*n};r.push(a),s[t]=a;}}const{w:n,h:i}=$c(r),s=new zl({width:n||1,height:i||1});for(const r in t){const n=t[r];for(const t in n.glyphs){const i=n.glyphs[+t];if(!i||0===i.bitmap.width||0===i.bitmap.height)continue;const a=e[r][t],o=i.metrics.localGlyph?2:1;zl.copy(i.bitmap,s,{x:0,y:0},{x:a.x+o,y:a.y+o},i.bitmap);}}this.image=s,this.positions=e;}}Zi("GlyphAtlas",kd);class Sd{constructor(t){this.tileID=new bp(t.tileID.overscaledZ,t.tileID.wrap,t.tileID.canonical.z,t.tileID.canonical.x,t.tileID.canonical.y),this.tileZoom=t.tileZoom,this.uid=t.uid,this.zoom=t.zoom,this.canonical=t.tileID.canonical,this.pixelRatio=t.pixelRatio,this.tileSize=t.tileSize,this.source=t.source,this.overscaling=this.tileID.overscaleFactor(),this.showCollisionBoxes=t.showCollisionBoxes,this.collectResourceTiming=!!t.collectResourceTiming,this.returnDependencies=!!t.returnDependencies,this.promoteId=t.promoteId,this.enableTerrain=!!t.enableTerrain,this.isSymbolTile=t.isSymbolTile,this.tileTransform=Ad(t.tileID.canonical,t.projection),this.projection=t.projection;}parse(t,e,r,n,i){this.status="parsing",this.data=t,this.collisionBoxArray=new Fa;const s=new Tp(Object.keys(t.layers).sort()),a=new Xp(this.tileID,this.promoteId);a.bucketLayerIDs=[];const o={},l=new pp(256,256),u={featureIndex:a,iconDependencies:{},patternDependencies:{},glyphDependencies:{},lineAtlas:l,availableImages:r},c=e.familiesBySource[this.source];for(const e in c){const n=t.layers[e];if(!n)continue;let i=!1,l=!1;for(const t of c[e])"symbol"===t[0].type?i=!0:l=!0;if(!0===this.isSymbolTile&&!i)continue;if(!1===this.isSymbolTile&&!l)continue;1===n.version&&pt(`Vector tile source "${this.source}" layer "${e}" does not use vector tile spec v2 and therefore may have some rendering errors.`);const h=s.encode(e),p=[];for(let t=0;t<n.length;t++){const r=n.feature(t),i=a.getId(r,e);p.push({feature:r,id:i,index:t,sourceLayerIndex:h});}for(const t of c[e]){const e=t[0];void 0!==this.isSymbolTile&&"symbol"===e.type!==this.isSymbolTile||e.minzoom&&this.zoom<Math.floor(e.minzoom)||e.maxzoom&&this.zoom>=e.maxzoom||"none"!==e.visibility&&(Id(t,this.zoom,r),(o[e.id]=e.createBucket({index:a.bucketLayerIDs.length,layers:t,zoom:this.zoom,canonical:this.canonical,pixelRatio:this.pixelRatio,overscaling:this.overscaling,collisionBoxArray:this.collisionBoxArray,sourceLayerIndex:h,sourceID:this.source,enableTerrain:this.enableTerrain,availableImages:r})).populate(p,u,this.tileID.canonical,this.tileTransform),a.bucketLayerIDs.push(t.map((t=>t.id))));}}let h,p,d,f;l.trim();const y={type:"maybePrepare",isSymbolTile:this.isSymbolTile,zoom:this.zoom},m=lt(u.glyphDependencies,(t=>Object.keys(t).map(Number)));Object.keys(m).length?n.send("getGlyphs",{uid:this.uid,stacks:m},((t,e)=>{h||(h=t,p=e,v.call(this));}),void 0,!1,y):p={};const g=Object.keys(u.iconDependencies);g.length?n.send("getImages",{icons:g,source:this.source,tileID:this.tileID,type:"icons"},((t,e)=>{h||(h=t,d=e,v.call(this));}),void 0,!1,y):d={};const x=Object.keys(u.patternDependencies);function v(){if(h)return i(h);if(p&&d&&f){const t=new kd(p),e=new jc(d,f);for(const n in o){const i=o[n];i instanceof Yh?(Id(i.layers,this.zoom,r),Eh(i,p,t.positions,d,e.iconPositions,this.showCollisionBoxes,r,this.tileID.canonical,this.tileZoom,this.projection),i.projection=this.projection.name):i.hasPattern&&(i instanceof Ku||i instanceof mu||i instanceof Vu)&&(Id(i.layers,this.zoom,r),i.addFeatures(u,this.tileID.canonical,e.patternPositions,r));}this.status="done",i(null,{buckets:Q(o).filter((t=>!t.isEmpty())),featureIndex:a,collisionBoxArray:this.collisionBoxArray,glyphAtlasImage:t.image,lineAtlas:l,imageAtlas:e,glyphMap:this.returnDependencies?p:null,iconMap:this.returnDependencies?d:null,glyphPositions:this.returnDependencies?t.positions:null});}}x.length?n.send("getImages",{icons:x,source:this.source,tileID:this.tileID,type:"patterns"},((t,e)=>{h||(h=t,f=e,v.call(this));}),void 0,!1,y):f={},v.call(this);}}function Id(t,e,r){const n=new Gs(e);for(const e of t)e.recalculate(n,r);}class zd{constructor(t){this.entries={},this.scheduler=t;}request(t,e,r,n){const i=this.entries[t]=this.entries[t]||{callbacks:[]};if(i.result){const[t,r]=i.result;return this.scheduler?this.scheduler.add((()=>{n(t,r);}),e):n(t,r),()=>{}}return i.callbacks.push(n),i.cancel||(i.cancel=r(((r,n)=>{i.result=[r,n];for(const t of i.callbacks)this.scheduler?this.scheduler.add((()=>{t(r,n);}),e):t(r,n);setTimeout((()=>delete this.entries[t]),3e3);}))),()=>{i.result||(i.callbacks=i.callbacks.filter((t=>t!==n)),i.callbacks.length||(i.cancel(),delete this.entries[t]));}}}function Md(t,e,r){const n=JSON.stringify(t.request);return t.data&&(this.deduped.entries[n]={result:[null,t.data]}),this.deduped.request(n,{type:"parseTile",isSymbolTile:t.isSymbolTile,zoom:t.tileZoom},(e=>{const n=ae(t.request,((t,n,i,s)=>{t?e(t):n&&e(null,{vectorTile:r?void 0:new Bu.VectorTile(new gc(n)),rawData:n,cacheControl:i,expires:s});}));return ()=>{n.cancel(),e();}}),e)}const Td=c(new Float64Array(16));class Bd{constructor(t,e){this._tr=t,this._worldSize=e;}createInversionMatrix(){return Td}createTileMatrix(t){let e,r,n;const i=t.canonical,s=c(new Float64Array(16)),a=this._tr.projection;if(a.isReprojectedInTileSpace){const o=Ad(i,a);e=1,r=o.x+t.wrap*o.scale,n=o.y,d(s,s,[e/o.scale,e/o.scale,this._tr.pixelsPerMeter/this._worldSize]);}else e=this._worldSize/this._tr.zoomScale(i.z),r=(i.x+Math.pow(2,i.z)*t.wrap)*e,n=i.y*e;return p(s,s,[r,n,0]),d(s,s,[e/To,e/To,1]),s}pointCoordinate(t,e,r){const n=this._tr.horizonLineFromTop(!1),s=new i(t,Math.max(n,e));return this._tr.rayIntersectionCoordinate(this._tr.pointRayIntersection(s,r))}upVector(){return [0,0,1]}upVectorScale(){return 1}}var Cd={name:"albers",range:[4,7],center:[-96,37.5],parallels:[29.5,45.5],zAxisUnit:"meters",conic:!0,isReprojectedInTileSpace:!0,unsupportedLayers:["custom"],initializeConstants(){if(this.constants&&$(this.parallels,this.constants.parallels))return;const t=Math.sin(q(this.parallels[0])),e=(t+Math.sin(q(this.parallels[1])))/2,r=1+t*(2*e-t),n=Math.sqrt(r)/e;this.constants={n:e,c:r,r0:n,parallels:this.parallels};},project(t,e){this.initializeConstants();const r=q(t-this.center[0]),n=q(e),{n:i,c:s,r0:a}=this.constants,o=Math.sqrt(s-2*i*Math.sin(n))/i;return {x:o*Math.sin(r*i),y:o*Math.cos(r*i)-a,z:0}},unproject(t,e){this.initializeConstants();const{n:r,c:n,r0:i}=this.constants,s=i+e;let a=Math.atan2(t,Math.abs(s))*Math.sign(s);s*r<0&&(a-=Math.PI*Math.sign(t)*Math.sign(s));const o=q(this.center[0])*r;a=J(a,-Math.PI-o,Math.PI-o);const l=N(a/r)+this.center[0],u=Math.asin(Y((n-(t*t+s*s)*r*r)/(2*r),-1,1)),c=Y(N(u),-85.051129,Oo);return new Po(l,c)},projectTilePoint:(t,e)=>({x:t,y:e,z:0}),locationPoint:(t,e)=>t._coordinatePoint(t.locationCoordinate(e),!1),pixelsPerMeter:(t,e)=>Lo(1,t)*e,farthestPixelDistance(t){return cd(t,this.pixelsPerMeter(t.center.lat,t.worldSize))},createTileTransform:(t,e)=>new Bd(t,e)};const Pd=1.340264,Ed=-.081106,Dd=893e-6,Vd=.003796,Fd=Math.sqrt(3)/2;var Ld={name:"equalEarth",center:[0,0],range:[3.5,7],zAxisUnit:"meters",isReprojectedInTileSpace:!0,unsupportedLayers:["custom"],project(t,e){e=e/180*Math.PI,t=t/180*Math.PI;const r=Math.asin(Fd*Math.sin(e)),n=r*r,i=n*n*n;return {x:.5*(t*Math.cos(r)/(Fd*(Pd+3*Ed*n+i*(7*Dd+9*Vd*n)))/Math.PI+.5),y:1-.5*(r*(Pd+Ed*n+i*(Dd+Vd*n))/Math.PI+1),z:0}},unproject(t,e){t=(2*t-.5)*Math.PI;let r=e=(2*(1-e)-1)*Math.PI,n=r*r,i=n*n*n;for(let t,s,a,o=0;o<12&&(s=r*(Pd+Ed*n+i*(Dd+Vd*n))-e,a=Pd+3*Ed*n+i*(7*Dd+9*Vd*n),t=s/a,r=Y(r-t,-Math.PI/3,Math.PI/3),n=r*r,i=n*n*n,!(Math.abs(t)<1e-12));++o);const s=Fd*t*(Pd+3*Ed*n+i*(7*Dd+9*Vd*n))/Math.cos(r),a=Math.asin(Math.sin(r)/Fd),o=Y(180*s/Math.PI,-180,180),l=Y(180*a/Math.PI,-85.051129,Oo);return new Po(o,l)},projectTilePoint:(t,e)=>({x:t,y:e,z:0}),locationPoint:(t,e)=>t._coordinatePoint(t.locationCoordinate(e),!1),pixelsPerMeter:(t,e)=>Lo(1,t)*e,farthestPixelDistance(t){return cd(t,this.pixelsPerMeter(t.center.lat,t.worldSize))},createTileTransform:(t,e)=>new Bd(t,e)},Rd={name:"equirectangular",supportsWorldCopies:!0,center:[0,0],range:[3.5,7],zAxisUnit:"meters",wrap:!0,isReprojectedInTileSpace:!0,unsupportedLayers:["custom"],project:(t,e)=>({x:.5+t/360,y:.5-e/360,z:0}),unproject(t,e){const r=360*(t-.5),n=Y(360*(.5-e),-85.051129,Oo);return new Po(r,n)},projectTilePoint:(t,e)=>({x:t,y:e,z:0}),locationPoint:(t,e)=>t._coordinatePoint(t.locationCoordinate(e),!1),pixelsPerMeter:(t,e)=>Lo(1,t)*e,farthestPixelDistance(t){return cd(t,this.pixelsPerMeter(t.center.lat,t.worldSize))},createTileTransform:(t,e)=>new Bd(t,e)};const Ud=Math.PI/2;function $d(t){return Math.tan((Ud+t)/2)}var Od={name:"lambertConformalConic",range:[3.5,7],zAxisUnit:"meters",center:[0,30],parallels:[30,30],conic:!0,isReprojectedInTileSpace:!0,unsupportedLayers:["custom"],initializeConstants(){if(this.constants&&$(this.parallels,this.constants.parallels))return;const t=q(this.parallels[0]),e=q(this.parallels[1]),r=Math.cos(t),n=t===e?Math.sin(t):Math.log(r/Math.cos(e))/Math.log($d(e)/$d(t)),i=r*Math.pow($d(t),n)/n;this.constants={n:n,f:i,parallels:this.parallels};},project(t,e){this.initializeConstants(),e=q(e),t=q(t-this.center[0]);const r=1e-6,{n:n,f:i}=this.constants;i>0?e<-Ud+r&&(e=-Ud+r):e>Ud-r&&(e=Ud-r);const s=i/Math.pow($d(e),n),a=s*Math.sin(n*t),o=i-s*Math.cos(n*t);return {x:.5*(a/Math.PI+.5),y:1-.5*(o/Math.PI+.5),z:0}},unproject(t,e){this.initializeConstants(),t=(2*t-.5)*Math.PI,e=(2*(1-e)-.5)*Math.PI;const{n:r,f:n}=this.constants,i=n-e,s=Math.sign(i),a=Math.sign(r)*Math.sqrt(t*t+i*i);let o=Math.atan2(t,Math.abs(i))*s;i*r<0&&(o-=Math.PI*Math.sign(t)*s);const l=Y(N(o/r)+this.center[0],-180,180),u=Y(N(2*Math.atan(Math.pow(n/a,1/r))-Ud),-85.051129,Oo);return new Po(l,u)},projectTilePoint:(t,e)=>({x:t,y:e,z:0}),locationPoint:(t,e)=>t._coordinatePoint(t.locationCoordinate(e),!1),pixelsPerMeter:(t,e)=>Lo(1,t)*e,farthestPixelDistance(t){return cd(t,this.pixelsPerMeter(t.center.lat,t.worldSize))},createTileTransform:(t,e)=>new Bd(t,e)},jd={name:"mercator",wrap:!0,requiresDraping:!1,supportsWorldCopies:!0,supportsTerrain:!0,supportsFog:!0,supportsFreeCamera:!0,zAxisUnit:"meters",center:[0,0],project:(t,e)=>({x:Vo(t),y:Fo(e),z:0}),unproject(t,e){const r=Ro(t),n=Uo(e);return new Po(r,n)},projectTilePoint:(t,e)=>({x:t,y:e,z:0}),locationPoint:(t,e)=>t._coordinatePoint(t.locationCoordinate(e),!1),pixelsPerMeter:(t,e)=>Lo(1,t)*e,farthestPixelDistance(t){return cd(t,this.pixelsPerMeter(t.center.lat,t.worldSize))},createTileTransform:(t,e)=>new Bd(t,e)};const qd=q(Oo);var Nd={name:"naturalEarth",center:[0,0],range:[3.5,7],isReprojectedInTileSpace:!0,zAxisUnit:"meters",unsupportedLayers:["custom"],project(t,e){const r=(e=q(e))*e,n=r*r;return {x:.5*((t=q(t))*(.8707-.131979*r+n*(n*(.003971*r-.001529*n)-.013791))/Math.PI+.5),y:1-.5*(e*(1.007226+r*(.015085+n*(.028874*r-.044475-.005916*n)))/Math.PI+1),z:0}},unproject(t,e){t=(2*t-.5)*Math.PI;let r=e=(2*(1-e)-1)*Math.PI,n=25,i=0,s=r*r;do{s=r*r;const t=s*s;i=(r*(1.007226+s*(.015085+t*(.028874*s-.044475-.005916*t)))-e)/(1.007226+s*(.045255+t*(.259866*s-.311325-.005916*11*t))),r=Y(r-i,-qd,qd);}while(Math.abs(i)>1e-6&&--n>0);s=r*r;const a=Y(N(t/(.8707+s*(s*(s*s*s*(.003971-.001529*s)-.013791)-.131979))),-180,180),o=N(r);return new Po(a,o)},projectTilePoint:(t,e)=>({x:t,y:e,z:0}),locationPoint:(t,e)=>t._coordinatePoint(t.locationCoordinate(e),!1),pixelsPerMeter:(t,e)=>Lo(1,t)*e,farthestPixelDistance(t){return cd(t,this.pixelsPerMeter(t.center.lat,t.worldSize))},createTileTransform:(t,e)=>new Bd(t,e)};const Gd=q(Oo),Zd={albers:Cd,equalEarth:Ld,equirectangular:Rd,lambertConformalConic:Od,mercator:jd,naturalEarth:Nd,winkelTripel:{name:"winkelTripel",center:[0,0],range:[3.5,7],zAxisUnit:"meters",isReprojectedInTileSpace:!0,unsupportedLayers:["custom"],project(t,e){e=q(e),t=q(t);const r=Math.cos(e),n=2/Math.PI,i=Math.acos(r*Math.cos(t/2)),s=Math.sin(i)/i,a=.5*(t*n+2*r*Math.sin(t/2)/s)||0,o=.5*(e+Math.sin(e)/s)||0;return {x:.5*(a/Math.PI+.5),y:1-.5*(o/Math.PI+1),z:0}},unproject(t,e){let r=t=(2*t-.5)*Math.PI,n=e=(2*(1-e)-1)*Math.PI,i=25;const s=1e-6;let a=0,o=0;do{const i=Math.cos(n),s=Math.sin(n),l=2*s*i,u=s*s,c=i*i,h=Math.cos(r/2),p=Math.sin(r/2),d=2*h*p,f=p*p,y=1-c*h*h,m=y?1/y:0,g=y?Math.acos(i*h)*Math.sqrt(1/y):0,x=.5*(2*g*i*p+2*r/Math.PI)-t,v=.5*(g*s+n)-e,b=.5*m*(c*f+g*i*h*u)+1/Math.PI,w=m*(d*l/4-g*s*p),_=.125*m*(l*p-g*s*c*d),A=.5*m*(u*h+g*f*i)+.5,k=w*_-A*b;a=(v*w-x*A)/k,o=(x*_-v*b)/k,r=Y(r-a,-Math.PI,Math.PI),n=Y(n-o,-Gd,Gd);}while((Math.abs(a)>s||Math.abs(o)>s)&&--i>0);return new Po(N(r),N(n))},projectTilePoint:(t,e)=>({x:t,y:e,z:0}),locationPoint:(t,e)=>t._coordinatePoint(t.locationCoordinate(e),!1),pixelsPerMeter:(t,e)=>Lo(1,t)*e,farthestPixelDistance(t){return cd(t,this.pixelsPerMeter(t.center.lat,t.worldSize))},createTileTransform:(t,e)=>new Bd(t,e)}};t.ARRAY_TYPE=l,t.AUTH_ERR_MSG=Et,t.Aabb=gl,t.Actor=class{constructor(t,e,r){this.target=t,this.parent=e,this.mapId=r,this.callbacks={},this.cancelCallbacks={},at(["receive"],this),this.target.addEventListener("message",this.receive,!1),this.globalScope=yt()?t:a,this.scheduler=new mp;}send(t,e,r,n,i=!1,s){const a=Math.round(1e18*Math.random()).toString(36).substring(0,10);r&&(r.metadata=s,this.callbacks[a]=r);const o=wt(this.globalScope)?void 0:[];return this.target.postMessage({id:a,type:t,hasCallback:!!r,targetMapId:n,mustQueue:i,sourceMapId:this.mapId,data:Yi(e,o)},o),{cancel:()=>{r&&delete this.callbacks[a],this.target.postMessage({id:a,type:"<cancel>",targetMapId:n,sourceMapId:this.mapId});}}}receive(t){const e=t.data,r=e.id;if(r&&(!e.targetMapId||this.mapId===e.targetMapId))if("<cancel>"===e.type){const t=this.cancelCallbacks[r];delete this.cancelCallbacks[r],t&&t.cancel();}else if(e.mustQueue||yt()){const t=this.callbacks[r];this.cancelCallbacks[r]=this.scheduler.add((()=>this.processTask(r,e)),t&&t.metadata||{type:"message"});}else this.processTask(r,e);}processTask(t,e){if("<response>"===e.type){const r=this.callbacks[t];delete this.callbacks[t],r&&(e.error?r(Hi(e.error)):r(null,Hi(e.data)));}else {const r=wt(this.globalScope)?void 0:[],n=e.hasCallback?(e,n)=>{delete this.cancelCallbacks[t],this.target.postMessage({id:t,type:"<response>",sourceMapId:this.mapId,error:e?Yi(e):null,data:Yi(n,r)},r);}:t=>{},i=Hi(e.data);if(this.parent[e.type])this.parent[e.type](e.sourceMapId,i,n);else if(this.parent.getWorkerSource){const t=e.type.split(".");this.parent.getWorkerSource(e.sourceMapId,t[0],i.source)[t[1]](i,n);}else n(new Error(`Could not find function ${e.type}`));}}remove(){this.scheduler.remove(),this.target.removeEventListener("message",this.receive,!1);}},t.CanonicalTileID=xp,t.Color=Ge,t.ColorMode=Sp,t.CullFaceMode=Mp,t.DEMData=Op,t.DataConstantProperty=ta,t.DedupedRequest=zd,t.DepthMode=_p,t.EXTENT=To,t.Elevation=class{getAtPointOrZero(t,e=0){return this.getAtPoint(t,e)||0}getAtPoint(t,e,r=!0){null==e&&(e=null);const n=this._source();if(!n)return e;if(t.y<0||t.y>1)return e;const i=n.getSource().maxzoom,s=1<<i,a=Math.floor(t.x),o=t.x-a,l=new bp(i,a,i,Math.floor(o*s),Math.floor(t.y*s)),u=this.findDEMTileFor(l);if(!u||!u.dem)return e;const c=u.dem,h=1<<u.tileID.canonical.z,p=(o*h-u.tileID.canonical.x)*c.dim,d=(t.y*h-u.tileID.canonical.y)*c.dim,f=Math.floor(p),y=Math.floor(d);return (r?this.exaggeration():1)*Lr(Lr(c.get(f,y),c.get(f,y+1),d-y),Lr(c.get(f+1,y),c.get(f+1,y+1),d-y),p-f)}getAtTileOffset(t,e,r){const n=1<<t.canonical.z;return this.getAtPointOrZero(new jo(t.wrap+(t.canonical.x+e/To)/n,(t.canonical.y+r/To)/n))}getAtTileOffsetFunc(t,e){return r=>{const n=this.getAtTileOffset(t,r.x,r.y),i=e.upVector(t.canonical,r.x,r.y);return S(i,i,n*e.upVectorScale(t.canonical)),i}}getForTilePoints(t,e,r,n){const i=Zp.create(this,t,n);return !!i&&(e.forEach((t=>{t[2]=this.exaggeration()*i.getElevationAt(t[0],t[1],r);})),!0)}getMinMaxForTile(t){const e=this.findDEMTileFor(t);if(!e||!e.dem)return null;const r=e.dem.tree,n=e.tileID,i=1<<t.canonical.z-n.canonical.z;let s=t.canonical.x/i-n.canonical.x,a=t.canonical.y/i-n.canonical.y,o=0;for(let e=0;e<t.canonical.z-n.canonical.z&&!r.leaves[o];e++){s*=2,a*=2;const t=2*Math.floor(a)+Math.floor(s);o=r.childOffsets[o]+t,s%=1,a%=1;}return {min:this.exaggeration()*r.minimums[o],max:this.exaggeration()*r.maximums[o]}}getMinElevationBelowMSL(){throw new Error("Pure virtual method called.")}raycast(t,e,r){throw new Error("Pure virtual method called.")}pointCoordinate(t){throw new Error("Pure virtual method called.")}_source(){throw new Error("Pure virtual method called.")}exaggeration(){throw new Error("Pure virtual method called.")}findDEMTileFor(t){throw new Error("Pure virtual method called.")}get visibleDemTiles(){throw new Error("Getter must be implemented in subclass.")}},t.ErrorEvent=ge,t.EvaluationParameters=Gs,t.Event=me,t.Evented=xe,t.Frustum=ml,t.GLOBE_ZOOM_THRESHOLD_MAX=6,t.GlobeSharedBuffers=_d,t.GlyphManager=xh,t.ImagePosition=Oc,t.LineAtlas=pp,t.LngLat=Po,t.LngLatBounds=Bo,t.LocalGlyphMode=gh,t.MAX_MERCATOR_LATITUDE=Oo,t.MercatorCoordinate=jo,t.ONE_EM=sc,t.OverscaledTileID=bp,t.Properties=sa,t.RGBAImage=Ml,t.Ray=class{constructor(t,e){this.pos=t,this.dir=e;}intersectsPlane(t,e,r){const n=M(e,this.dir);if(Math.abs(n)<1e-6)return !1;const i=((t[0]-this.pos[0])*e[0]+(t[1]-this.pos[1])*e[1]+(t[2]-this.pos[2])*e[2])/n;return r[0]=this.pos[0]+this.dir[0]*i,r[1]=this.pos[1]+this.dir[1]*i,r[2]=this.pos[2]+this.dir[2]*i,!0}closestPointOnSphere(t,e,r){if(function(t,e){var r=t[0],n=t[1],i=t[2],s=e[0],a=e[1],l=e[2];return Math.abs(r-s)<=o*Math.max(1,Math.abs(r),Math.abs(s))&&Math.abs(n-a)<=o*Math.max(1,Math.abs(n),Math.abs(a))&&Math.abs(i-l)<=o*Math.max(1,Math.abs(i),Math.abs(l))}(this.pos,t)||0===e)return r[0]=r[1]=r[2]=0,!1;const[n,i,s]=this.dir,a=this.pos[0]-t[0],l=this.pos[1]-t[1],u=this.pos[2]-t[2],c=n*n+i*i+s*s,h=2*(a*n+l*i+u*s),p=h*h-4*c*(a*a+l*l+u*u-e*e);if(p<0){const t=Math.max(-h/2,0),o=a+n*t,c=l+i*t,p=u+s*t,d=Math.hypot(o,c,p);return r[0]=o*e/d,r[1]=c*e/d,r[2]=p*e/d,!1}{const t=(-h-Math.sqrt(p))/(2*c);if(t<0){const t=Math.hypot(a,l,u);return r[0]=a*e/t,r[1]=l*e/t,r[2]=u*e/t,!1}return r[0]=a+n*t,r[1]=l+i*t,r[2]=u+s*t,!0}}},t.RequestManager=class{constructor(t,e,r){this._transformRequestFn=t,this._customAccessToken=e,this._silenceAuthErrors=!!r,this._createSkuToken();}_createSkuToken(){const t=function(){let t="";for(let e=0;e<10;e++)t+="0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"[Math.floor(62*Math.random())];return {token:["1",Pt,t].join(""),tokenExpiresAt:Date.now()+432e5}}();this._skuToken=t.token,this._skuTokenExpiresAt=t.tokenExpiresAt;}_isSkuTokenExpired(){return Date.now()>this._skuTokenExpiresAt}transformRequest(t,e){return this._transformRequestFn&&this._transformRequestFn(t,e)||{url:t}}normalizeStyleURL(t,e){if(!Dt(t))return t;const r=Lt(t);return r.path=`/styles/v1${r.path}`,this._makeAPIURL(r,this._customAccessToken||e)}normalizeGlyphsURL(t,e){if(!Dt(t))return t;const r=Lt(t);return r.path=`/fonts/v1${r.path}`,this._makeAPIURL(r,this._customAccessToken||e)}normalizeSourceURL(t,e){if(!Dt(t))return t;const r=Lt(t);return r.path=`/v4/${r.authority}.json`,r.params.push("secure"),this._makeAPIURL(r,this._customAccessToken||e)}normalizeSpriteURL(t,e,r,n){const i=Lt(t);return Dt(t)?(i.path=`/styles/v1${i.path}/sprite${e}${r}`,this._makeAPIURL(i,this._customAccessToken||n)):(i.path+=`${e}${r}`,Rt(i))}normalizeTileURL(t,e,r){if(this._isSkuTokenExpired()&&this._createSkuToken(),t&&!Dt(t))return t;const n=Lt(t);n.path=n.path.replace(/(\.(png|jpg)\d*)(?=$)/,`${e||r&&"raster"!==n.authority&&512===r?"@2x":""}${It.supported?".webp":"$1"}`),"raster"===n.authority?n.path=`/${St.RASTER_URL_PREFIX}${n.path}`:(n.path=n.path.replace(/^.+\/v4\//,"/"),n.path=`/${St.TILE_URL_VERSION}${n.path}`);const i=this._customAccessToken||function(t){for(const e of t){const t=e.match(/^access_token=(.*)$/);if(t)return t[1]}return null}(n.params)||St.ACCESS_TOKEN;return St.REQUIRE_ACCESS_TOKEN&&i&&this._skuToken&&n.params.push(`sku=${this._skuToken}`),this._makeAPIURL(n,i)}canonicalizeTileURL(t,e){const r=Lt(t);if(!r.path.match(/^(\/v4\/|\/raster\/v1\/)/)||!r.path.match(/\.[\w]+$/))return t;let n="mapbox://";r.path.match(/^\/raster\/v1\//)?n+=`raster/${r.path.replace(`/${St.RASTER_URL_PREFIX}/`,"")}`:n+=`tiles/${r.path.replace(`/${St.TILE_URL_VERSION}/`,"")}`;let i=r.params;return e&&(i=i.filter((t=>!t.match(/^access_token=/)))),i.length&&(n+=`?${i.join("&")}`),n}canonicalizeTileset(t,e){const r=!!e&&Dt(e),n=[];for(const e of t.tiles||[])Vt(e)?n.push(this.canonicalizeTileURL(e,r)):n.push(e);return n}_makeAPIURL(t,e){const r="See https://www.mapbox.com/api-documentation/#access-tokens-and-token-scopes",n=Lt(St.API_URL);if(t.protocol=n.protocol,t.authority=n.authority,"http"===t.protocol){const e=t.params.indexOf("secure");e>=0&&t.params.splice(e,1);}if("/"!==n.path&&(t.path=`${n.path}${t.path}`),!St.REQUIRE_ACCESS_TOKEN)return Rt(t);if(e=e||St.ACCESS_TOKEN,!this._silenceAuthErrors){if(!e)throw new Error(`An API access token is required to use Mapbox GL. ${r}`);if("s"===e[0])throw new Error(`Use a public access token (pk.*) with Mapbox GL, not a secret access token (sk.*). ${r}`)}return t.params=t.params.filter((t=>-1===t.indexOf("access_token"))),t.params.push(`access_token=${e||""}`),Rt(t)}},t.ResourceType=re,t.SegmentVector=Mo,t.SourceCache=qp,t.StencilMode=kp,t.StructArrayLayout1ui2=Pa,t.StructArrayLayout2f1f2i16=_a,t.StructArrayLayout2i4=pa,t.StructArrayLayout2ui4=Ca,t.StructArrayLayout3f12=ya,t.StructArrayLayout3ui6=ka,t.StructArrayLayout4i8=da,t.Texture=hp,t.Tile=ad,t.Transitionable=Ks,t.Uniform1f=io,t.Uniform1i=class extends no{constructor(t,e){super(t,e),this.current=0;}set(t){this.current!==t&&(this.current=t,this.gl.uniform1i(this.location,t));}},t.Uniform2f=class extends no{constructor(t,e){super(t,e),this.current=[0,0];}set(t){t[0]===this.current[0]&&t[1]===this.current[1]||(this.current=t,this.gl.uniform2f(this.location,t[0],t[1]));}},t.Uniform3f=class extends no{constructor(t,e){super(t,e),this.current=[0,0,0];}set(t){t[0]===this.current[0]&&t[1]===this.current[1]&&t[2]===this.current[2]||(this.current=t,this.gl.uniform3f(this.location,t[0],t[1],t[2]));}},t.Uniform4f=so,t.UniformColor=ao,t.UniformMatrix2f=class extends no{constructor(t,e){super(t,e),this.current=uo;}set(t){for(let e=0;e<4;e++)if(t[e]!==this.current[e]){this.current=t,this.gl.uniformMatrix2fv(this.location,!1,t);break}}},t.UniformMatrix3f=class extends no{constructor(t,e){super(t,e),this.current=lo;}set(t){for(let e=0;e<9;e++)if(t[e]!==this.current[e]){this.current=t,this.gl.uniformMatrix3fv(this.location,!1,t);break}}},t.UniformMatrix4f=class extends no{constructor(t,e){super(t,e),this.current=oo;}set(t){if(t[12]!==this.current[12]||t[0]!==this.current[0])return this.current=t,void this.gl.uniformMatrix4fv(this.location,!1,t);for(let e=1;e<16;e++)if(t[e]!==this.current[e]){this.current=t,this.gl.uniformMatrix4fv(this.location,!1,t);break}}},t.UnwrappedTileID=vp,t.ValidationError=be,t.VectorTileWorkerSource=class extends xe{constructor(t,e,r,n,i){super(),this.actor=t,this.layerIndex=e,this.availableImages=r,this.loadVectorData=i||Md,this.loading={},this.loaded={},this.deduped=new zd(t.scheduler),this.isSpriteLoaded=n,this.scheduler=t.scheduler;}loadTile(t,e){const r=t.uid,n=t&&t.request,i=n&&n.collectResourceTiming,s=this.loading[r]=new Sd(t);s.abort=this.loadVectorData(t,((a,o)=>{const l=!this.loading[r];if(delete this.loading[r],l||a||!o)return s.status="done",l||(this.loaded[r]=s),e(a);const u=o.rawData,c={};o.expires&&(c.expires=o.expires),o.cacheControl&&(c.cacheControl=o.cacheControl),s.vectorTile=o.vectorTile||new Bu.VectorTile(new gc(u));const h=()=>{s.parse(s.vectorTile,this.layerIndex,this.availableImages,this.actor,((t,r)=>{if(t||!r)return e(t);const s={};if(i){const t=yp(n);t.length>0&&(s.resourceTiming=JSON.parse(JSON.stringify(t)));}e(null,tt({rawTileData:u.slice(0)},r,c,s));}));};this.isSpriteLoaded?h():this.once("isSpriteLoaded",(()=>{this.scheduler?this.scheduler.add(h,{type:"parseTile",isSymbolTile:t.isSymbolTile,zoom:t.tileZoom}):h();})),this.loaded=this.loaded||{},this.loaded[r]=s;}));}reloadTile(t,e){const r=this.loaded,n=t.uid,i=this;if(r&&r[n]){const s=r[n];s.showCollisionBoxes=t.showCollisionBoxes,s.enableTerrain=!!t.enableTerrain,s.projection=t.projection;const a=(t,r)=>{const n=s.reloadCallback;n&&(delete s.reloadCallback,s.parse(s.vectorTile,i.layerIndex,this.availableImages,i.actor,n)),e(t,r);};"parsing"===s.status?s.reloadCallback=a:"done"===s.status&&(s.vectorTile?s.parse(s.vectorTile,this.layerIndex,this.availableImages,this.actor,a):a());}}abortTile(t,e){const r=t.uid,n=this.loading[r];n&&(n.abort&&n.abort(),delete this.loading[r]),e();}removeTile(t,e){const r=this.loaded,n=t.uid;r&&r[n]&&delete r[n],e();}},t.WritingMode=qc,t.ZoomHistory=Ji,t.add=w,t.addDynamicAttributes=Gh,t.adjoint=function(t,e){var r=e[0],n=e[1],i=e[2],s=e[3],a=e[4],o=e[5],l=e[6],u=e[7],c=e[8];return t[0]=a*c-o*u,t[1]=i*u-n*c,t[2]=n*o-i*a,t[3]=o*l-s*c,t[4]=r*c-i*l,t[5]=i*s-r*o,t[6]=s*u-a*l,t[7]=n*l-r*u,t[8]=r*a-n*s,t},t.asyncAll=W,t.bezier=X,t.bindAll=at,t.boundsAttributes=id,t.bufferConvexPolygon=function(t,e){const r=[];for(let n=0;n<t.length;n++){const i=J(n-1,-1,t.length-1),s=J(n+1,-1,t.length-1),a=t[n],o=t[s],l=t[i].sub(a).unit(),u=o.sub(a).unit(),c=u.angleWithSep(l.x,l.y),h=l.add(u).unit().mult(-1*e/Math.sin(c/2));r.push(a.add(h));}return r},t.cacheEntryPossiblyAdded=function(t){ee++,ee>Wt&&(t.getActor().send("enforceCacheSizeLimit",Jt),ee=0);},t.calculateGlobeMatrix=wd,t.calculateGlobeMercatorMatrix=function(t){const e=t.worldSize,r=Y(t.center.lat,-85.051129,Oo),n=new i(Vo(t.center.lng)*e,Fo(r)*e),s=Lo(1,t.center.lat)*e,a=t.pixelsPerMeter,o=e/(s/t.pixelsPerMeter),l=c(new Float64Array(16));return p(l,l,[n.x,n.y,0]),d(l,l,[o,o,a]),l},t.clamp=Y,t.clearTileCache=function(t){const e=a.caches.delete(Kt);t&&e.catch(t).then((()=>t()));},t.clipLine=dh,t.clone=function(t){var e=new l(16);return e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[4]=t[4],e[5]=t[5],e[6]=t[6],e[7]=t[7],e[8]=t[8],e[9]=t[9],e[10]=t[10],e[11]=t[11],e[12]=t[12],e[13]=t[13],e[14]=t[14],e[15]=t[15],e},t.clone$1=ct,t.collisionCircleLayout=ic,t.config=St,t.conjugate=function(t,e){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=e[3],t},t.create=function(){var t=new l(16);return l!=Float32Array&&(t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[11]=0,t[12]=0,t[13]=0,t[14]=0),t[0]=1,t[5]=1,t[10]=1,t[15]=1,t},t.create$1=u,t.createExpression=Gn,t.createLayout=ca,t.createStyleLayer=function(t){return "custom"===t.type?new rp(t):new sp[t.type](t)},t.cross=T,t.degToRad=q,t.div=function(t,e,r){return t[0]=e[0]/r[0],t[1]=e[1]/r[1],t[2]=e[2]/r[2],t},t.dot=M,t.ease=K,t.easeCubicInOut=Z,t.emitValidationErrors=$i,t.endsWith=ot,t.enforceCacheSizeLimit=function(t){Qt(),Yt&&Yt.then((e=>{e.keys().then((r=>{for(let n=0;n<r.length-t;n++)e.delete(r[n]);}));}));},t.evaluateSizeForFeature=lc,t.evaluateSizeForZoom=uc,t.evaluateVariableOffset=Ph,t.evented=Os,t.exactEquals=function(t,e){return t[0]===e[0]&&t[1]===e[1]&&t[2]===e[2]&&t[3]===e[3]},t.exactEquals$1=function(t,e){return t[0]===e[0]&&t[1]===e[1]&&t[2]===e[2]},t.exported=At,t.exported$1=It,t.extend=tt,t.extend$1=_e,t.filterObject=ut,t.fromMat4=function(t,e){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[4],t[4]=e[5],t[5]=e[6],t[6]=e[8],t[7]=e[9],t[8]=e[10],t},t.fromQuat=function(t,e){var r=e[0],n=e[1],i=e[2],s=e[3],a=r+r,o=n+n,l=i+i,u=r*a,c=n*a,h=n*o,p=i*a,d=i*o,f=i*l,y=s*a,m=s*o,g=s*l;return t[0]=1-h-f,t[1]=c+g,t[2]=p-m,t[3]=0,t[4]=c-g,t[5]=1-u-f,t[6]=d+y,t[7]=0,t[8]=p+m,t[9]=d-y,t[10]=1-u-h,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t},t.fromRotation=function(t,e){var r=Math.sin(e),n=Math.cos(e);return t[0]=n,t[1]=r,t[2]=0,t[3]=-r,t[4]=n,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t},t.fromScaling=function(t,e){return t[0]=e[0],t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e[1],t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e[2],t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t},t.furthestTileCorner=function(t){const e=Math.round((t+45+360)%360/90)%4;return G[e]},t.getAABBPointSquareDist=function(t,e,r){let n=0;for(let i=0;i<2;++i){const s=r?r[i]:0;t[i]>s&&(n+=(t[i]-s)*(t[i]-s)),e[i]<s&&(n+=(s-e[i])*(s-e[i]));}return n},t.getAnchorAlignment=eh,t.getAnchorJustification=Dh,t.getBounds=function(t){let e=1/0,r=1/0,n=-1/0,s=-1/0;for(const i of t)e=Math.min(e,i.x),r=Math.min(r,i.y),n=Math.max(n,i.x),s=Math.max(s,i.y);return {min:new i(e,r),max:new i(n,s)}},t.getColumn=function(t,e){return [t[4*e],t[4*e+1],t[4*e+2],t[4*e+3]]},t.getImage=de,t.getJSON=function(t,e){return se(tt(t,{type:"json"}),e)},t.getMapSessionAPI=Zt,t.getPerformanceMeasurement=yp,t.getProjection=function(t){const e=Zd[t.name];if(!e)throw new Error(`Invalid projection name: ${t.name}`);return e.conic?function(t,e){if(e.parallels&&Math.abs(e.parallels[0]+e.parallels[1])<.01){let r=function(t){const e=Math.max(.01,Math.cos(q(t))),r=1/(2*Math.max(Math.PI*e,1/e));return {wrap:!0,supportsWorldCopies:!0,unsupportedLayers:["custom"],project(t,n){const i=q(t)*e,s=Math.sin(q(n))/e;return {x:i*r+.5,y:-s*r+.5,z:0}},unproject(t,n){const i=-(n-.5)/r,s=Y(N((t-.5)/r)/e,-180,180),a=Math.asin(Y(i*e,-1,1)),o=Y(N(a),-85.051129,Oo);return new Po(s,o)}}}(e.parallels[0]);if("lambertConformalConic"===e.name){const{project:t,unproject:e}=Zd.mercator;r={wrap:!0,supportsWorldCopies:!0,project:t,unproject:e};}return tt({},t,e,r)}return tt({},t,e)}(e,t):e},t.getRTLTextPluginStatus=js,t.getReferrer=ie,t.getTilePoint=function(t,{x:e,y:r},n=0){return new i(((e-n)*t.scale-t.x)*To,(r*t.scale-t.y)*To)},t.getTileVec3=function(t,e,r=0){return b(((e.x-r)*t.scale-t.x)*To,(e.y*t.scale-t.y)*To,$o(e.z,e.y))},t.getVideo=function(t,e){const r=a.document.createElement("video");r.muted=!0,r.onloadstart=function(){e(null,r);};for(let e=0;e<t.length;e++){const n=a.document.createElement("source");ue(t[e])||(r.crossOrigin="Anonymous"),n.src=t[e],r.appendChild(n);}return {cancel:()=>{}}},t.globeBuffersForTileMesh=function(t,e,r,n){const i=t.context,s=t.transform;let a=e.globeGridBuffer,o=e.globePoleBuffer;if(!a){const t=_d.createGridVertices(r.canonical);a=e.globeGridBuffer=i.createVertexBuffer(t,ud,!1);}if(!o){const t=_d.createPoleTriangleVertices(n,s.tileSize*n,0===r.canonical.y);o=e.globePoleBuffer=i.createVertexBuffer(t,ud,!1);}return [a,o]},t.globeDenormalizeECEF=bd,t.globeMatrixForTile=function(t,e){const r=bd(yd(t)),n=((i=new Float64Array(16))[0]=(s=e)[0],i[1]=s[1],i[2]=s[2],i[3]=s[3],i[4]=s[4],i[5]=s[5],i[6]=s[6],i[7]=s[7],i[8]=s[8],i[9]=s[9],i[10]=s[10],i[11]=s[11],i[12]=s[12],i[13]=s[13],i[14]=s[14],i[15]=s[15],i);var i,s;return m(n,n,r),n},t.globePoleMatrixForTile=function(t,e,r){const n=c(new Float64Array(16)),i=Math.pow(2,t.z),s=(t.x-i/2)/i*Math.PI*2,a=r.point,o=r.worldSize/(r.tileSize*i);return p(n,n,[a.x,a.y,-r.worldSize/Math.PI/2]),d(n,n,[o,o,o]),f(n,n,q(-r._center.lat)),y(n,n,q(-r._center.lng)),y(n,n,s),e&&d(n,n,[1,-1,1]),n},t.globeTileBounds=yd,t.globeToMercatorTransition=function(t){return H(5,6,t)},t.identity=c,t.identity$1=R,t.invert=function(t,e){var r=e[0],n=e[1],i=e[2],s=e[3],a=e[4],o=e[5],l=e[6],u=e[7],c=e[8],h=e[9],p=e[10],d=e[11],f=e[12],y=e[13],m=e[14],g=e[15],x=r*o-n*a,v=r*l-i*a,b=r*u-s*a,w=n*l-i*o,_=n*u-s*o,A=i*u-s*l,k=c*y-h*f,S=c*m-p*f,I=c*g-d*f,z=h*m-p*y,M=h*g-d*y,T=p*g-d*m,B=x*T-v*M+b*z+w*I-_*S+A*k;return B?(t[0]=(o*T-l*M+u*z)*(B=1/B),t[1]=(i*M-n*T-s*z)*B,t[2]=(y*A-m*_+g*w)*B,t[3]=(p*_-h*A-d*w)*B,t[4]=(l*I-a*T-u*S)*B,t[5]=(r*T-i*I+s*S)*B,t[6]=(m*b-f*A-g*v)*B,t[7]=(c*A-p*b+d*v)*B,t[8]=(a*M-o*I+u*k)*B,t[9]=(n*I-r*M-s*k)*B,t[10]=(f*_-y*b+g*x)*B,t[11]=(h*b-c*_-d*x)*B,t[12]=(o*S-a*z-l*k)*B,t[13]=(r*z-n*S+i*k)*B,t[14]=(y*v-f*w-m*x)*B,t[15]=(c*w-h*v+p*x)*B,t):null},t.isMapAuthenticated=function(t){return Xt.has(t)},t.isMapboxURL=Dt,t.latFromMercatorY=Uo,t.len=V,t.length=v,t.length$1=function(t){return Math.hypot(t[0],t[1],t[2],t[3])},t.loadVectorTile=Md,t.makeRequest=se,t.mercatorXfromLng=Vo,t.mercatorYfromLat=Fo,t.mercatorZfromAltitude=Lo,t.mul=m,t.mul$1=D,t.multiply=function(t,e,r){var n=e[0],i=e[1],s=e[2],a=e[3],o=e[4],l=e[5],u=e[6],c=e[7],h=e[8],p=r[0],d=r[1],f=r[2],y=r[3],m=r[4],g=r[5],x=r[6],v=r[7],b=r[8];return t[0]=p*n+d*a+f*u,t[1]=p*i+d*o+f*c,t[2]=p*s+d*l+f*h,t[3]=y*n+m*a+g*u,t[4]=y*i+m*o+g*c,t[5]=y*s+m*l+g*h,t[6]=x*n+v*a+b*u,t[7]=x*i+v*o+b*c,t[8]=x*s+v*l+b*h,t},t.multiply$1=h,t.multiply$2=A,t.nextPowerOfTwo=it,t.normalize=z,t.normalize$1=function(t,e){var r=e[0],n=e[1],i=e[2],s=e[3],a=r*r+n*n+i*i+s*s;return a>0&&(a=1/Math.sqrt(a)),t[0]=r*a,t[1]=n*a,t[2]=i*a,t[3]=s*a,t},t.number=Lr,t.ortho=function(t,e,r,n,i,s,a){var o=1/(e-r),l=1/(n-i),u=1/(s-a);return t[0]=-2*o,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=-2*l,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=2*u,t[11]=0,t[12]=(e+r)*o,t[13]=(i+n)*l,t[14]=(a+s)*u,t[15]=1,t},t.pbf=gc,t.perspective=function(t,e,r,n,i){var s,a=1/Math.tan(e/2);return t[0]=a/r,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=a,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[11]=-1,t[12]=0,t[13]=0,t[15]=0,null!=i&&i!==1/0?(t[10]=(i+n)*(s=1/(n-i)),t[14]=2*i*n*s):(t[10]=-1,t[14]=-2*n),t},t.pick=function(t,e){const r={};for(let n=0;n<e.length;n++){const i=e[n];i in t&&(r[i]=t[i]);}return r},t.plugin=Ns,t.pointGeometry=i,t.polygonIntersectsBox=ll,t.polygonIntersectsPolygon=Wo,t.polygonizeBounds=function(t,e,r=0,n=!0){const s=new i(r,r),a=t.sub(s),o=e.add(s),l=[a,new i(o.x,a.y),o,new i(a.x,o.y)];return n&&l.push(a),l},t.posAttributes=Hp,t.postMapLoadEvent=Nt,t.postTurnstileEvent=jt,t.potpack=$c,t.prevPowerOfTwo=function(t){return t<=1?1:Math.pow(2,Math.floor(Math.log(t)/Math.LN2))},t.radToDeg=N,t.refProperties=["type","source","source-layer","minzoom","maxzoom","filter","layout"],t.registerForPluginStateChange=function(t){return t({pluginStatus:Ls,pluginURL:Rs}),Os.on("pluginStateChange",t),t},t.removeAuthState=function(t){Xt.delete(t);},t.renderColorRamp=Bl,t.rotateX=f,t.rotateX$1=U,t.rotateY=y,t.rotateZ=function(t,e,r){var n=Math.sin(r),i=Math.cos(r),s=e[0],a=e[1],o=e[2],l=e[3],u=e[4],c=e[5],h=e[6],p=e[7];return e!==t&&(t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]),t[0]=s*i+u*n,t[1]=a*i+c*n,t[2]=o*i+h*n,t[3]=l*i+p*n,t[4]=u*i-s*n,t[5]=c*i-a*n,t[6]=h*i-o*n,t[7]=p*i-l*n,t},t.rotateZ$1=function(t,e,r){r*=.5;var n=e[0],i=e[1],s=e[2],a=e[3],o=Math.sin(r),l=Math.cos(r);return t[0]=n*l+i*o,t[1]=i*l-n*o,t[2]=s*l+a*o,t[3]=a*l-s*o,t},t.scale=d,t.scale$1=function(t,e,r){return t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t[3]=e[3]*r,t},t.scale$2=S,t.scaleAndAdd=I,t.setCacheLimits=function(t,e){Jt=t,Wt=e;},t.setColumn=function(t,e,r){t[4*e+0]=r[0],t[4*e+1]=r[1],t[4*e+2]=r[2],t[4*e+3]=r[3];},t.setRTLTextPlugin=function(t,e,r=!1){if(Ls===Es||Ls===Ds||Ls===Vs)throw new Error("setRTLTextPlugin cannot be called multiple times.");Rs=At.resolveURL(t),Ls=Es,Fs=e,$s(),r||qs();},t.smoothstep=H,t.spec=ve,t.storeAuthState=function(t,e){e?Xt.add(t):Xt.delete(t);},t.sub=E,t.subtract=_,t.symbolSize=cc,t.tileAABB=function(t,e,r,n,i,s,a,o,l){if("globe"===l.name){const a=yd(new vp(s,new xp(r,n,i)).canonical).getCorners(),o=Number.MAX_VALUE,l=[-o,-o,-o],p=[o,o,o],d=wd(t,e);for(let t=0;t<a.length;t++)B(a[t],a[t],d),c=p,h=a[t],(u=p)[0]=Math.min(c[0],h[0]),u[1]=Math.min(c[1],h[1]),u[2]=Math.min(c[2],h[2]),k(l,l,a[t]);return new gl(p,l)}var u,c,h;const p=Ad({z:r,x:n,y:i},l);return new gl([(s+p.x/p.scale)*e,e*(p.y/p.scale),a],[(s+p.x2/p.scale)*e,e*(p.y2/p.scale),o])},t.tileTransform=Ad,t.transformMat3=function(t,e,r){var n=e[0],i=e[1],s=e[2];return t[0]=n*r[0]+i*r[3]+s*r[6],t[1]=n*r[1]+i*r[4]+s*r[7],t[2]=n*r[2]+i*r[5]+s*r[8],t},t.transformMat4=B,t.transformMat4$1=F,t.transformQuat=C,t.translate=p,t.transpose=function(t,e){if(t===e){var r=e[1],n=e[2],i=e[5];t[1]=e[3],t[2]=e[6],t[3]=r,t[5]=e[7],t[6]=n,t[7]=i;}else t[0]=e[0],t[1]=e[3],t[2]=e[6],t[3]=e[1],t[4]=e[4],t[5]=e[7],t[6]=e[2],t[7]=e[5],t[8]=e[8];return t},t.triggerPluginCompletionEvent=Us,t.uniqueId=rt,t.validateCustomStyleLayer=function(t){const e=[],r=t.id;return void 0===r&&e.push({message:`layers.${r}: missing required property "id"`}),void 0===t.render&&e.push({message:`layers.${r}: missing required method "render"`}),t.renderingMode&&"2d"!==t.renderingMode&&"3d"!==t.renderingMode&&e.push({message:`layers.${r}: property "renderingMode" must be either "2d" or "3d"`}),e},t.validateFog=Li,t.validateLight=Fi,t.validateStyle=Vi,t.values=Q,t.vectorTile=Bu,t.version=e,t.warnOnce=pt,t.window=a,t.wrap=J;}));

define(["./shared"],(function(e){"use strict";function t(e){const r=typeof e;if("number"===r||"boolean"===r||"string"===r||null==e)return JSON.stringify(e);if(Array.isArray(e)){let r="[";for(const o of e)r+=`${t(o)},`;return `${r}]`}const o=Object.keys(e).sort();let n="{";for(let r=0;r<o.length;r++)n+=`${JSON.stringify(o[r])}:${t(e[o[r]])},`;return `${n}}`}function r(r){let o="";for(const n of e.refProperties)o+=`/${t(r[n])}`;return o}class o{constructor(e){this.keyCache={},e&&this.replace(e);}replace(e){this._layerConfigs={},this._layers={},this.update(e,[]);}update(t,o){for(const r of t)this._layerConfigs[r.id]=r,(this._layers[r.id]=e.createStyleLayer(r)).compileFilter(),this.keyCache[r.id]&&delete this.keyCache[r.id];for(const e of o)delete this.keyCache[e],delete this._layerConfigs[e],delete this._layers[e];this.familiesBySource={};const n=function(e,t){const o={};for(let n=0;n<e.length;n++){const i=t&&t[e[n].id]||r(e[n]);t&&(t[e[n].id]=i);let s=o[i];s||(s=o[i]=[]),s.push(e[n]);}const n=[];for(const e in o)n.push(o[e]);return n}(e.values(this._layerConfigs),this.keyCache);for(const e of n){const t=e.map((e=>this._layers[e.id])),r=t[0];if("none"===r.visibility)continue;const o=r.source||"";let n=this.familiesBySource[o];n||(n=this.familiesBySource[o]={});const i=r.sourceLayer||"_geojsonTileLayer";let s=n[i];s||(s=n[i]=[]),s.push(t);}}}const{ImageBitmap:n}=e.window;class i{loadTile(t,r){const{uid:o,encoding:i,rawImageData:s,padding:a,buildQuadTree:l}=t,u=n&&s instanceof n?this.getImageData(s,a):s;r(null,new e.DEMData(o,u,i,a<1,l));}getImageData(t,r){this.offscreenCanvas&&this.offscreenCanvasContext||(this.offscreenCanvas=new OffscreenCanvas(t.width,t.height),this.offscreenCanvasContext=this.offscreenCanvas.getContext("2d")),this.offscreenCanvas.width=t.width,this.offscreenCanvas.height=t.height,this.offscreenCanvasContext.drawImage(t,0,0,t.width,t.height);const o=this.offscreenCanvasContext.getImageData(-r,-r,t.width+2*r,t.height+2*r);return this.offscreenCanvasContext.clearRect(0,0,this.offscreenCanvas.width,this.offscreenCanvas.height),new e.RGBAImage({width:o.width,height:o.height},o.data)}}var s=function e(t,r){var o,n=t&&t.type;if("FeatureCollection"===n)for(o=0;o<t.features.length;o++)e(t.features[o],r);else if("GeometryCollection"===n)for(o=0;o<t.geometries.length;o++)e(t.geometries[o],r);else if("Feature"===n)e(t.geometry,r);else if("Polygon"===n)a(t.coordinates,r);else if("MultiPolygon"===n)for(o=0;o<t.coordinates.length;o++)a(t.coordinates[o],r);return t};function a(e,t){if(0!==e.length){l(e[0],t);for(var r=1;r<e.length;r++)l(e[r],!t);}}function l(e,t){for(var r=0,o=0,n=0,i=e.length,s=i-1;n<i;s=n++){var a=(e[n][0]-e[s][0])*(e[s][1]+e[n][1]),l=r+a;o+=Math.abs(r)>=Math.abs(a)?r-l+a:a-l+r,r=l;}r+o>=0!=!!t&&e.reverse();}const u=e.vectorTile.VectorTileFeature.prototype.toGeoJSON;class h{constructor(t){this._feature=t,this.extent=e.EXTENT,this.type=t.type,this.properties=t.tags,"id"in t&&!isNaN(t.id)&&(this.id=parseInt(t.id,10));}loadGeometry(){if(1===this._feature.type){const t=[];for(const r of this._feature.geometry)t.push([new e.pointGeometry(r[0],r[1])]);return t}{const t=[];for(const r of this._feature.geometry){const o=[];for(const t of r)o.push(new e.pointGeometry(t[0],t[1]));t.push(o);}return t}}toGeoJSON(e,t,r){return u.call(this,e,t,r)}}class c{constructor(t){this.layers={_geojsonTileLayer:this},this.name="_geojsonTileLayer",this.extent=e.EXTENT,this.length=t.length,this._features=t;}feature(e){return new h(this._features[e])}}var f=e.vectorTile.VectorTileFeature,p=g;function g(e,t){this.options=t||{},this.features=e,this.length=e.length;}function d(e,t){this.id="number"==typeof e.id?e.id:void 0,this.type=e.type,this.rawGeometry=1===e.type?[e.geometry]:e.geometry,this.properties=e.tags,this.extent=t||4096;}g.prototype.feature=function(e){return new d(this.features[e],this.options.extent)},d.prototype.loadGeometry=function(){var t=this.rawGeometry;this.geometry=[];for(var r=0;r<t.length;r++){for(var o=t[r],n=[],i=0;i<o.length;i++)n.push(new e.pointGeometry(o[i][0],o[i][1]));this.geometry.push(n);}return this.geometry},d.prototype.bbox=function(){this.geometry||this.loadGeometry();for(var e=this.geometry,t=1/0,r=-1/0,o=1/0,n=-1/0,i=0;i<e.length;i++)for(var s=e[i],a=0;a<s.length;a++){var l=s[a];t=Math.min(t,l.x),r=Math.max(r,l.x),o=Math.min(o,l.y),n=Math.max(n,l.y);}return [t,o,r,n]},d.prototype.toGeoJSON=f.prototype.toGeoJSON;var m=v,y=p;function v(t){var r=new e.pbf;return function(e,t){for(var r in e.layers)t.writeMessage(3,x,e.layers[r]);}(t,r),r.finish()}function x(e,t){var r;t.writeVarintField(15,e.version||1),t.writeStringField(1,e.name||""),t.writeVarintField(5,e.extent||4096);var o={keys:[],values:[],keycache:{},valuecache:{}};for(r=0;r<e.length;r++)o.feature=e.feature(r),t.writeMessage(2,w,o);var n=o.keys;for(r=0;r<n.length;r++)t.writeStringField(3,n[r]);var i=o.values;for(r=0;r<i.length;r++)t.writeMessage(4,T,i[r]);}function w(e,t){var r=e.feature;void 0!==r.id&&t.writeVarintField(1,r.id),t.writeMessage(2,S,e),t.writeVarintField(3,r.type),t.writeMessage(4,b,r);}function S(e,t){var r=e.feature,o=e.keys,n=e.values,i=e.keycache,s=e.valuecache;for(var a in r.properties){var l=r.properties[a],u=i[a];if(null!==l){void 0===u&&(o.push(a),i[a]=u=o.length-1),t.writeVarint(u);var h=typeof l;"string"!==h&&"boolean"!==h&&"number"!==h&&(l=JSON.stringify(l));var c=h+":"+l,f=s[c];void 0===f&&(n.push(l),s[c]=f=n.length-1),t.writeVarint(f);}}}function M(e,t){return (t<<3)+(7&e)}function P(e){return e<<1^e>>31}function b(e,t){for(var r=e.loadGeometry(),o=e.type,n=0,i=0,s=r.length,a=0;a<s;a++){var l=r[a],u=1;1===o&&(u=l.length),t.writeVarint(M(1,u));for(var h=3===o?l.length-1:l.length,c=0;c<h;c++){1===c&&1!==o&&t.writeVarint(M(2,h-1));var f=l[c].x-n,p=l[c].y-i;t.writeVarint(P(f)),t.writeVarint(P(p)),n+=f,i+=p;}3===o&&t.writeVarint(M(7,1));}}function T(e,t){var r=typeof e;"string"===r?t.writeStringField(1,e):"boolean"===r?t.writeBooleanField(7,e):"number"===r&&(e%1!=0?t.writeDoubleField(3,e):e<0?t.writeSVarintField(6,e):t.writeVarintField(5,e));}function k(e,t,r,o,n,i){if(n-o<=r)return;const s=o+n>>1;I(e,t,s,o,n,i%2),k(e,t,r,o,s-1,i+1),k(e,t,r,s+1,n,i+1);}function I(e,t,r,o,n,i){for(;n>o;){if(n-o>600){const s=n-o+1,a=r-o+1,l=Math.log(s),u=.5*Math.exp(2*l/3),h=.5*Math.sqrt(l*u*(s-u)/s)*(a-s/2<0?-1:1);I(e,t,r,Math.max(o,Math.floor(r-a*u/s+h)),Math.min(n,Math.floor(r+(s-a)*u/s+h)),i);}const s=t[2*r+i];let a=o,l=n;for(_(e,t,o,r),t[2*n+i]>s&&_(e,t,o,n);a<l;){for(_(e,t,a,l),a++,l--;t[2*a+i]<s;)a++;for(;t[2*l+i]>s;)l--;}t[2*o+i]===s?_(e,t,o,l):(l++,_(e,t,l,n)),l<=r&&(o=l+1),r<=l&&(n=l-1);}}function _(e,t,r,o){L(e,r,o),L(t,2*r,2*o),L(t,2*r+1,2*o+1);}function L(e,t,r){const o=e[t];e[t]=e[r],e[r]=o;}function C(e,t,r,o){const n=e-r,i=t-o;return n*n+i*i}m.fromVectorTileJs=v,m.fromGeojsonVt=function(e,t){t=t||{};var r={};for(var o in e)r[o]=new p(e[o].features,t),r[o].name=o,r[o].version=t.version,r[o].extent=t.extent;return v({layers:r})},m.GeoJSONWrapper=y;const O=e=>e[0],z=e=>e[1];class E{constructor(e,t=O,r=z,o=64,n=Float64Array){this.nodeSize=o,this.points=e;const i=e.length<65536?Uint16Array:Uint32Array,s=this.ids=new i(e.length),a=this.coords=new n(2*e.length);for(let o=0;o<e.length;o++)s[o]=o,a[2*o]=t(e[o]),a[2*o+1]=r(e[o]);k(s,a,o,0,s.length-1,0);}range(e,t,r,o){return function(e,t,r,o,n,i,s){const a=[0,e.length-1,0],l=[];let u,h;for(;a.length;){const c=a.pop(),f=a.pop(),p=a.pop();if(f-p<=s){for(let s=p;s<=f;s++)u=t[2*s],h=t[2*s+1],u>=r&&u<=n&&h>=o&&h<=i&&l.push(e[s]);continue}const g=Math.floor((p+f)/2);u=t[2*g],h=t[2*g+1],u>=r&&u<=n&&h>=o&&h<=i&&l.push(e[g]);const d=(c+1)%2;(0===c?r<=u:o<=h)&&(a.push(p),a.push(g-1),a.push(d)),(0===c?n>=u:i>=h)&&(a.push(g+1),a.push(f),a.push(d));}return l}(this.ids,this.coords,e,t,r,o,this.nodeSize)}within(e,t,r){return function(e,t,r,o,n,i){const s=[0,e.length-1,0],a=[],l=n*n;for(;s.length;){const u=s.pop(),h=s.pop(),c=s.pop();if(h-c<=i){for(let n=c;n<=h;n++)C(t[2*n],t[2*n+1],r,o)<=l&&a.push(e[n]);continue}const f=Math.floor((c+h)/2),p=t[2*f],g=t[2*f+1];C(p,g,r,o)<=l&&a.push(e[f]);const d=(u+1)%2;(0===u?r-n<=p:o-n<=g)&&(s.push(c),s.push(f-1),s.push(d)),(0===u?r+n>=p:o+n>=g)&&(s.push(f+1),s.push(h),s.push(d));}return a}(this.ids,this.coords,e,t,r,this.nodeSize)}}const F={minZoom:0,maxZoom:16,minPoints:2,radius:40,extent:512,nodeSize:64,log:!1,generateId:!1,reduce:null,map:e=>e},N=Math.fround||(j=new Float32Array(1),e=>(j[0]=+e,j[0]));var j;class Z{constructor(e){this.options=D(Object.create(F),e),this.trees=new Array(this.options.maxZoom+1);}load(e){const{log:t,minZoom:r,maxZoom:o,nodeSize:n}=this.options;t&&console.time("total time");const i=`prepare ${e.length} points`;t&&console.time(i),this.points=e;let s=[];for(let t=0;t<e.length;t++)e[t].geometry&&s.push(J(e[t],t));this.trees[o+1]=new E(s,$,B,n,Float32Array),t&&console.timeEnd(i);for(let e=o;e>=r;e--){const r=+Date.now();s=this._cluster(s,e),this.trees[e]=new E(s,$,B,n,Float32Array),t&&console.log("z%d: %d clusters in %dms",e,s.length,+Date.now()-r);}return t&&console.timeEnd("total time"),this}getClusters(e,t){let r=((e[0]+180)%360+360)%360-180;const o=Math.max(-90,Math.min(90,e[1]));let n=180===e[2]?180:((e[2]+180)%360+360)%360-180;const i=Math.max(-90,Math.min(90,e[3]));if(e[2]-e[0]>=360)r=-180,n=180;else if(r>n){const e=this.getClusters([r,o,180,i],t),s=this.getClusters([-180,o,n,i],t);return e.concat(s)}const s=this.trees[this._limitZoom(t)],a=s.range(X(r),V(i),X(n),V(o)),l=[];for(const e of a){const t=s.points[e];l.push(t.numPoints?W(t):this.points[t.index]);}return l}getChildren(e){const t=this._getOriginId(e),r=this._getOriginZoom(e),o="No cluster with the specified id.",n=this.trees[r];if(!n)throw new Error(o);const i=n.points[t];if(!i)throw new Error(o);const s=this.options.radius/(this.options.extent*Math.pow(2,r-1)),a=n.within(i.x,i.y,s),l=[];for(const t of a){const r=n.points[t];r.parentId===e&&l.push(r.numPoints?W(r):this.points[r.index]);}if(0===l.length)throw new Error(o);return l}getLeaves(e,t,r){const o=[];return this._appendLeaves(o,e,t=t||10,r=r||0,0),o}getTile(e,t,r){const o=this.trees[this._limitZoom(e)],n=Math.pow(2,e),{extent:i,radius:s}=this.options,a=s/i,l=(r-a)/n,u=(r+1+a)/n,h={features:[]};return this._addTileFeatures(o.range((t-a)/n,l,(t+1+a)/n,u),o.points,t,r,n,h),0===t&&this._addTileFeatures(o.range(1-a/n,l,1,u),o.points,n,r,n,h),t===n-1&&this._addTileFeatures(o.range(0,l,a/n,u),o.points,-1,r,n,h),h.features.length?h:null}getClusterExpansionZoom(e){let t=this._getOriginZoom(e)-1;for(;t<=this.options.maxZoom;){const r=this.getChildren(e);if(t++,1!==r.length)break;e=r[0].properties.cluster_id;}return t}_appendLeaves(e,t,r,o,n){const i=this.getChildren(t);for(const t of i){const i=t.properties;if(i&&i.cluster?n+i.point_count<=o?n+=i.point_count:n=this._appendLeaves(e,i.cluster_id,r,o,n):n<o?n++:e.push(t),e.length===r)break}return n}_addTileFeatures(e,t,r,o,n,i){for(const s of e){const e=t[s],a=e.numPoints;let l,u,h;if(a)l=Y(e),u=e.x,h=e.y;else {const t=this.points[e.index];l=t.properties,u=X(t.geometry.coordinates[0]),h=V(t.geometry.coordinates[1]);}const c={type:1,geometry:[[Math.round(this.options.extent*(u*n-r)),Math.round(this.options.extent*(h*n-o))]],tags:l};let f;a?f=e.id:this.options.generateId?f=e.index:this.points[e.index].id&&(f=this.points[e.index].id),void 0!==f&&(c.id=f),i.features.push(c);}}_limitZoom(e){return Math.max(this.options.minZoom,Math.min(+e,this.options.maxZoom+1))}_cluster(e,t){const r=[],{radius:o,extent:n,reduce:i,minPoints:s}=this.options,a=o/(n*Math.pow(2,t));for(let o=0;o<e.length;o++){const n=e[o];if(n.zoom<=t)continue;n.zoom=t;const l=this.trees[t+1],u=l.within(n.x,n.y,a),h=n.numPoints||1;let c=h;for(const e of u){const r=l.points[e];r.zoom>t&&(c+=r.numPoints||1);}if(c>h&&c>=s){let e=n.x*h,s=n.y*h,a=i&&h>1?this._map(n,!0):null;const f=(o<<5)+(t+1)+this.points.length;for(const r of u){const o=l.points[r];if(o.zoom<=t)continue;o.zoom=t;const u=o.numPoints||1;e+=o.x*u,s+=o.y*u,o.parentId=f,i&&(a||(a=this._map(n,!0)),i(a,this._map(o)));}n.parentId=f,r.push(G(e/c,s/c,f,c,a));}else if(r.push(n),c>1)for(const e of u){const o=l.points[e];o.zoom<=t||(o.zoom=t,r.push(o));}}return r}_getOriginId(e){return e-this.points.length>>5}_getOriginZoom(e){return (e-this.points.length)%32}_map(e,t){if(e.numPoints)return t?D({},e.properties):e.properties;const r=this.points[e.index].properties,o=this.options.map(r);return t&&o===r?D({},o):o}}function G(e,t,r,o,n){return {x:N(e),y:N(t),zoom:1/0,id:r,parentId:-1,numPoints:o,properties:n}}function J(e,t){const[r,o]=e.geometry.coordinates;return {x:N(X(r)),y:N(V(o)),zoom:1/0,index:t,parentId:-1}}function W(e){return {type:"Feature",id:e.id,properties:Y(e),geometry:{type:"Point",coordinates:[(t=e.x,360*(t-.5)),A(e.y)]}};var t;}function Y(e){const t=e.numPoints,r=t>=1e4?`${Math.round(t/1e3)}k`:t>=1e3?Math.round(t/100)/10+"k":t;return D(D({},e.properties),{cluster:!0,cluster_id:e.id,point_count:t,point_count_abbreviated:r})}function X(e){return e/360+.5}function V(e){const t=Math.sin(e*Math.PI/180),r=.5-.25*Math.log((1+t)/(1-t))/Math.PI;return r<0?0:r>1?1:r}function A(e){const t=(180-360*e)*Math.PI/180;return 360*Math.atan(Math.exp(t))/Math.PI-90}function D(e,t){for(const r in t)e[r]=t[r];return e}function $(e){return e.x}function B(e){return e.y}function R(e,t,r,o){for(var n,i=o,s=r-t>>1,a=r-t,l=e[t],u=e[t+1],h=e[r],c=e[r+1],f=t+3;f<r;f+=3){var p=q(e[f],e[f+1],l,u,h,c);if(p>i)n=f,i=p;else if(p===i){var g=Math.abs(f-s);g<a&&(n=f,a=g);}}i>o&&(n-t>3&&R(e,t,n,o),e[n+2]=i,r-n>3&&R(e,n,r,o));}function q(e,t,r,o,n,i){var s=n-r,a=i-o;if(0!==s||0!==a){var l=((e-r)*s+(t-o)*a)/(s*s+a*a);l>1?(r=n,o=i):l>0&&(r+=s*l,o+=a*l);}return (s=e-r)*s+(a=t-o)*a}function U(e,t,r,o){var n={id:void 0===e?null:e,type:t,geometry:r,tags:o,minX:1/0,minY:1/0,maxX:-1/0,maxY:-1/0};return function(e){var t=e.geometry,r=e.type;if("Point"===r||"MultiPoint"===r||"LineString"===r)Q(e,t);else if("Polygon"===r||"MultiLineString"===r)for(var o=0;o<t.length;o++)Q(e,t[o]);else if("MultiPolygon"===r)for(o=0;o<t.length;o++)for(var n=0;n<t[o].length;n++)Q(e,t[o][n]);}(n),n}function Q(e,t){for(var r=0;r<t.length;r+=3)e.minX=Math.min(e.minX,t[r]),e.minY=Math.min(e.minY,t[r+1]),e.maxX=Math.max(e.maxX,t[r]),e.maxY=Math.max(e.maxY,t[r+1]);}function H(e,t,r,o){if(t.geometry){var n=t.geometry.coordinates,i=t.geometry.type,s=Math.pow(r.tolerance/((1<<r.maxZoom)*r.extent),2),a=[],l=t.id;if(r.promoteId?l=t.properties[r.promoteId]:r.generateId&&(l=o||0),"Point"===i)K(n,a);else if("MultiPoint"===i)for(var u=0;u<n.length;u++)K(n[u],a);else if("LineString"===i)ee(n,a,s,!1);else if("MultiLineString"===i){if(r.lineMetrics){for(u=0;u<n.length;u++)ee(n[u],a=[],s,!1),e.push(U(l,"LineString",a,t.properties));return}te(n,a,s,!1);}else if("Polygon"===i)te(n,a,s,!0);else {if("MultiPolygon"!==i){if("GeometryCollection"===i){for(u=0;u<t.geometry.geometries.length;u++)H(e,{id:l,geometry:t.geometry.geometries[u],properties:t.properties},r,o);return}throw new Error("Input data is not a valid GeoJSON object.")}for(u=0;u<n.length;u++){var h=[];te(n[u],h,s,!0),a.push(h);}}e.push(U(l,i,a,t.properties));}}function K(e,t){t.push(re(e[0])),t.push(oe(e[1])),t.push(0);}function ee(e,t,r,o){for(var n,i,s=0,a=0;a<e.length;a++){var l=re(e[a][0]),u=oe(e[a][1]);t.push(l),t.push(u),t.push(0),a>0&&(s+=o?(n*u-l*i)/2:Math.sqrt(Math.pow(l-n,2)+Math.pow(u-i,2))),n=l,i=u;}var h=t.length-3;t[2]=1,R(t,0,h,r),t[h+2]=1,t.size=Math.abs(s),t.start=0,t.end=t.size;}function te(e,t,r,o){for(var n=0;n<e.length;n++){var i=[];ee(e[n],i,r,o),t.push(i);}}function re(e){return e/360+.5}function oe(e){var t=Math.sin(e*Math.PI/180),r=.5-.25*Math.log((1+t)/(1-t))/Math.PI;return r<0?0:r>1?1:r}function ne(e,t,r,o,n,i,s,a){if(o/=t,i>=(r/=t)&&s<o)return e;if(s<r||i>=o)return null;for(var l=[],u=0;u<e.length;u++){var h=e[u],c=h.geometry,f=h.type,p=0===n?h.minX:h.minY,g=0===n?h.maxX:h.maxY;if(p>=r&&g<o)l.push(h);else if(!(g<r||p>=o)){var d=[];if("Point"===f||"MultiPoint"===f)ie(c,d,r,o,n);else if("LineString"===f)se(c,d,r,o,n,!1,a.lineMetrics);else if("MultiLineString"===f)le(c,d,r,o,n,!1);else if("Polygon"===f)le(c,d,r,o,n,!0);else if("MultiPolygon"===f)for(var m=0;m<c.length;m++){var y=[];le(c[m],y,r,o,n,!0),y.length&&d.push(y);}if(d.length){if(a.lineMetrics&&"LineString"===f){for(m=0;m<d.length;m++)l.push(U(h.id,f,d[m],h.tags));continue}"LineString"!==f&&"MultiLineString"!==f||(1===d.length?(f="LineString",d=d[0]):f="MultiLineString"),"Point"!==f&&"MultiPoint"!==f||(f=3===d.length?"Point":"MultiPoint"),l.push(U(h.id,f,d,h.tags));}}}return l.length?l:null}function ie(e,t,r,o,n){for(var i=0;i<e.length;i+=3){var s=e[i+n];s>=r&&s<=o&&(t.push(e[i]),t.push(e[i+1]),t.push(e[i+2]));}}function se(e,t,r,o,n,i,s){for(var a,l,u=ae(e),h=0===n?he:ce,c=e.start,f=0;f<e.length-3;f+=3){var p=e[f],g=e[f+1],d=e[f+2],m=e[f+3],y=e[f+4],v=0===n?p:g,x=0===n?m:y,w=!1;s&&(a=Math.sqrt(Math.pow(p-m,2)+Math.pow(g-y,2))),v<r?x>r&&(l=h(u,p,g,m,y,r),s&&(u.start=c+a*l)):v>o?x<o&&(l=h(u,p,g,m,y,o),s&&(u.start=c+a*l)):ue(u,p,g,d),x<r&&v>=r&&(l=h(u,p,g,m,y,r),w=!0),x>o&&v<=o&&(l=h(u,p,g,m,y,o),w=!0),!i&&w&&(s&&(u.end=c+a*l),t.push(u),u=ae(e)),s&&(c+=a);}var S=e.length-3;p=e[S],g=e[S+1],d=e[S+2],(v=0===n?p:g)>=r&&v<=o&&ue(u,p,g,d),S=u.length-3,i&&S>=3&&(u[S]!==u[0]||u[S+1]!==u[1])&&ue(u,u[0],u[1],u[2]),u.length&&t.push(u);}function ae(e){var t=[];return t.size=e.size,t.start=e.start,t.end=e.end,t}function le(e,t,r,o,n,i){for(var s=0;s<e.length;s++)se(e[s],t,r,o,n,i,!1);}function ue(e,t,r,o){e.push(t),e.push(r),e.push(o);}function he(e,t,r,o,n,i){var s=(i-t)/(o-t);return e.push(i),e.push(r+(n-r)*s),e.push(1),s}function ce(e,t,r,o,n,i){var s=(i-r)/(n-r);return e.push(t+(o-t)*s),e.push(i),e.push(1),s}function fe(e,t){for(var r=[],o=0;o<e.length;o++){var n,i=e[o],s=i.type;if("Point"===s||"MultiPoint"===s||"LineString"===s)n=pe(i.geometry,t);else if("MultiLineString"===s||"Polygon"===s){n=[];for(var a=0;a<i.geometry.length;a++)n.push(pe(i.geometry[a],t));}else if("MultiPolygon"===s)for(n=[],a=0;a<i.geometry.length;a++){for(var l=[],u=0;u<i.geometry[a].length;u++)l.push(pe(i.geometry[a][u],t));n.push(l);}r.push(U(i.id,s,n,i.tags));}return r}function pe(e,t){var r=[];r.size=e.size,void 0!==e.start&&(r.start=e.start,r.end=e.end);for(var o=0;o<e.length;o+=3)r.push(e[o]+t,e[o+1],e[o+2]);return r}function ge(e,t){if(e.transformed)return e;var r,o,n,i=1<<e.z,s=e.x,a=e.y;for(r=0;r<e.features.length;r++){var l=e.features[r],u=l.geometry,h=l.type;if(l.geometry=[],1===h)for(o=0;o<u.length;o+=2)l.geometry.push(de(u[o],u[o+1],t,i,s,a));else for(o=0;o<u.length;o++){var c=[];for(n=0;n<u[o].length;n+=2)c.push(de(u[o][n],u[o][n+1],t,i,s,a));l.geometry.push(c);}}return e.transformed=!0,e}function de(e,t,r,o,n,i){return [Math.round(r*(e*o-n)),Math.round(r*(t*o-i))]}function me(e,t,r,o,n){for(var i=t===n.maxZoom?0:n.tolerance/((1<<t)*n.extent),s={features:[],numPoints:0,numSimplified:0,numFeatures:0,source:null,x:r,y:o,z:t,transformed:!1,minX:2,minY:1,maxX:-1,maxY:0},a=0;a<e.length;a++){s.numFeatures++,ye(s,e[a],i,n);var l=e[a].minX,u=e[a].minY,h=e[a].maxX,c=e[a].maxY;l<s.minX&&(s.minX=l),u<s.minY&&(s.minY=u),h>s.maxX&&(s.maxX=h),c>s.maxY&&(s.maxY=c);}return s}function ye(e,t,r,o){var n=t.geometry,i=t.type,s=[];if("Point"===i||"MultiPoint"===i)for(var a=0;a<n.length;a+=3)s.push(n[a]),s.push(n[a+1]),e.numPoints++,e.numSimplified++;else if("LineString"===i)ve(s,n,e,r,!1,!1);else if("MultiLineString"===i||"Polygon"===i)for(a=0;a<n.length;a++)ve(s,n[a],e,r,"Polygon"===i,0===a);else if("MultiPolygon"===i)for(var l=0;l<n.length;l++){var u=n[l];for(a=0;a<u.length;a++)ve(s,u[a],e,r,!0,0===a);}if(s.length){var h=t.tags||null;if("LineString"===i&&o.lineMetrics){for(var c in h={},t.tags)h[c]=t.tags[c];h.mapbox_clip_start=n.start/n.size,h.mapbox_clip_end=n.end/n.size;}var f={geometry:s,type:"Polygon"===i||"MultiPolygon"===i?3:"LineString"===i||"MultiLineString"===i?2:1,tags:h};null!==t.id&&(f.id=t.id),e.features.push(f);}}function ve(e,t,r,o,n,i){var s=o*o;if(o>0&&t.size<(n?s:o))r.numPoints+=t.length/3;else {for(var a=[],l=0;l<t.length;l+=3)(0===o||t[l+2]>s)&&(r.numSimplified++,a.push(t[l]),a.push(t[l+1])),r.numPoints++;n&&function(e,t){for(var r=0,o=0,n=e.length,i=n-2;o<n;i=o,o+=2)r+=(e[o]-e[i])*(e[o+1]+e[i+1]);if(r>0===t)for(o=0,n=e.length;o<n/2;o+=2){var s=e[o],a=e[o+1];e[o]=e[n-2-o],e[o+1]=e[n-1-o],e[n-2-o]=s,e[n-1-o]=a;}}(a,i),e.push(a);}}function xe(e,t){var r=(t=this.options=function(e,t){for(var r in t)e[r]=t[r];return e}(Object.create(this.options),t)).debug;if(r&&console.time("preprocess data"),t.maxZoom<0||t.maxZoom>24)throw new Error("maxZoom should be in the 0-24 range");if(t.promoteId&&t.generateId)throw new Error("promoteId and generateId cannot be used together.");var o=function(e,t){var r=[];if("FeatureCollection"===e.type)for(var o=0;o<e.features.length;o++)H(r,e.features[o],t,o);else H(r,"Feature"===e.type?e:{geometry:e},t);return r}(e,t);this.tiles={},this.tileCoords=[],r&&(console.timeEnd("preprocess data"),console.log("index: maxZoom: %d, maxPoints: %d",t.indexMaxZoom,t.indexMaxPoints),console.time("generate tiles"),this.stats={},this.total=0),(o=function(e,t){var r=t.buffer/t.extent,o=e,n=ne(e,1,-1-r,r,0,-1,2,t),i=ne(e,1,1-r,2+r,0,-1,2,t);return (n||i)&&(o=ne(e,1,-r,1+r,0,-1,2,t)||[],n&&(o=fe(n,1).concat(o)),i&&(o=o.concat(fe(i,-1)))),o}(o,t)).length&&this.splitTile(o,0,0,0),r&&(o.length&&console.log("features: %d, points: %d",this.tiles[0].numFeatures,this.tiles[0].numPoints),console.timeEnd("generate tiles"),console.log("tiles generated:",this.total,JSON.stringify(this.stats)));}function we(e,t,r){return 32*((1<<e)*r+t)+e}function Se(e,t){const r=e.tileID.canonical;if(!this._geoJSONIndex)return t(null,null);const o=this._geoJSONIndex.getTile(r.z,r.x,r.y);if(!o)return t(null,null);const n=new c(o.features);let i=m(n);0===i.byteOffset&&i.byteLength===i.buffer.byteLength||(i=new Uint8Array(i)),t(null,{vectorTile:n,rawData:i.buffer});}xe.prototype.options={maxZoom:14,indexMaxZoom:5,indexMaxPoints:1e5,tolerance:3,extent:4096,buffer:64,lineMetrics:!1,promoteId:null,generateId:!1,debug:0},xe.prototype.splitTile=function(e,t,r,o,n,i,s){for(var a=[e,t,r,o],l=this.options,u=l.debug;a.length;){o=a.pop(),r=a.pop(),t=a.pop(),e=a.pop();var h=1<<t,c=we(t,r,o),f=this.tiles[c];if(!f&&(u>1&&console.time("creation"),f=this.tiles[c]=me(e,t,r,o,l),this.tileCoords.push({z:t,x:r,y:o}),u)){u>1&&(console.log("tile z%d-%d-%d (features: %d, points: %d, simplified: %d)",t,r,o,f.numFeatures,f.numPoints,f.numSimplified),console.timeEnd("creation"));var p="z"+t;this.stats[p]=(this.stats[p]||0)+1,this.total++;}if(f.source=e,n){if(t===l.maxZoom||t===n)continue;var g=1<<n-t;if(r!==Math.floor(i/g)||o!==Math.floor(s/g))continue}else if(t===l.indexMaxZoom||f.numPoints<=l.indexMaxPoints)continue;if(f.source=null,0!==e.length){u>1&&console.time("clipping");var d,m,y,v,x,w,S=.5*l.buffer/l.extent,M=.5-S,P=.5+S,b=1+S;d=m=y=v=null,x=ne(e,h,r-S,r+P,0,f.minX,f.maxX,l),w=ne(e,h,r+M,r+b,0,f.minX,f.maxX,l),e=null,x&&(d=ne(x,h,o-S,o+P,1,f.minY,f.maxY,l),m=ne(x,h,o+M,o+b,1,f.minY,f.maxY,l),x=null),w&&(y=ne(w,h,o-S,o+P,1,f.minY,f.maxY,l),v=ne(w,h,o+M,o+b,1,f.minY,f.maxY,l),w=null),u>1&&console.timeEnd("clipping"),a.push(d||[],t+1,2*r,2*o),a.push(m||[],t+1,2*r,2*o+1),a.push(y||[],t+1,2*r+1,2*o),a.push(v||[],t+1,2*r+1,2*o+1);}}},xe.prototype.getTile=function(e,t,r){var o=this.options,n=o.extent,i=o.debug;if(e<0||e>24)return null;var s=1<<e,a=we(e,t=(t%s+s)%s,r);if(this.tiles[a])return ge(this.tiles[a],n);i>1&&console.log("drilling down to z%d-%d-%d",e,t,r);for(var l,u=e,h=t,c=r;!l&&u>0;)u--,h=Math.floor(h/2),c=Math.floor(c/2),l=this.tiles[we(u,h,c)];return l&&l.source?(i>1&&console.log("found parent tile z%d-%d-%d",u,h,c),i>1&&console.time("drilling down"),this.splitTile(l.source,u,h,c,e,t,r),i>1&&console.timeEnd("drilling down"),this.tiles[a]?ge(this.tiles[a],n):null):null};class Me extends e.VectorTileWorkerSource{constructor(e,t,r,o,n){super(e,t,r,o,Se),n&&(this.loadGeoJSON=n);}loadData(t,r){const o=t&&t.request,n=o&&o.collectResourceTiming;this.loadGeoJSON(t,((i,a)=>{if(i||!a)return r(i);if("object"!=typeof a)return r(new Error(`Input data given to '${t.source}' is not a valid GeoJSON object.`));{s(a,!0);try{if(t.filter){const r=e.createExpression(t.filter,{type:"boolean","property-type":"data-driven",overridable:!1,transition:!1});if("error"===r.result)throw new Error(r.value.map((e=>`${e.key}: ${e.message}`)).join(", "));const o=a.features.filter((e=>r.value.evaluate({zoom:0},e)));a={type:"FeatureCollection",features:o};}this._geoJSONIndex=t.cluster?new Z(function({superclusterOptions:t,clusterProperties:r}){if(!r||!t)return t;const o={},n={},i={accumulated:null,zoom:0},s={properties:null},a=Object.keys(r);for(const t of a){const[i,s]=r[t],a=e.createExpression(s),l=e.createExpression("string"==typeof i?[i,["accumulated"],["get",t]]:i);o[t]=a.value,n[t]=l.value;}return t.map=e=>{s.properties=e;const t={};for(const e of a)t[e]=o[e].evaluate(i,s);return t},t.reduce=(e,t)=>{s.properties=t;for(const t of a)i.accumulated=e[t],e[t]=n[t].evaluate(i,s);},t}(t)).load(a.features):function(e,t){return new xe(e,t)}(a,t.geojsonVtOptions);}catch(i){return r(i)}this.loaded={};const l={};if(n){const r=e.getPerformanceMeasurement(o);r&&(l.resourceTiming={},l.resourceTiming[t.source]=JSON.parse(JSON.stringify(r)));}r(null,l);}}));}reloadTile(e,t){const r=this.loaded;return r&&r[e.uid]?super.reloadTile(e,t):this.loadTile(e,t)}loadGeoJSON(t,r){if(t.request)e.getJSON(t.request,r);else {if("string"!=typeof t.data)return r(new Error(`Input data given to '${t.source}' is not a valid GeoJSON object.`));try{return r(null,JSON.parse(t.data))}catch(e){return r(new Error(`Input data given to '${t.source}' is not a valid GeoJSON object.`))}}}getClusterExpansionZoom(e,t){try{t(null,this._geoJSONIndex.getClusterExpansionZoom(e.clusterId));}catch(e){t(e);}}getClusterChildren(e,t){try{t(null,this._geoJSONIndex.getChildren(e.clusterId));}catch(e){t(e);}}getClusterLeaves(e,t){try{t(null,this._geoJSONIndex.getLeaves(e.clusterId,e.limit,e.offset));}catch(e){t(e);}}}class Pe{constructor(t){this.self=t,this.actor=new e.Actor(t,this),this.layerIndexes={},this.availableImages={},this.isSpriteLoaded={},this.projections={},this.defaultProjection=e.getProjection({name:"mercator"}),this.workerSourceTypes={vector:e.VectorTileWorkerSource,geojson:Me},this.workerSources={},this.demWorkerSources={},this.self.registerWorkerSource=(e,t)=>{if(this.workerSourceTypes[e])throw new Error(`Worker source with name "${e}" already registered.`);this.workerSourceTypes[e]=t;},this.self.registerRTLTextPlugin=t=>{if(e.plugin.isParsed())throw new Error("RTL text plugin already registered.");e.plugin.applyArabicShaping=t.applyArabicShaping,e.plugin.processBidirectionalText=t.processBidirectionalText,e.plugin.processStyledBidirectionalText=t.processStyledBidirectionalText;};}clearCaches(e,t,r){delete this.layerIndexes[e],delete this.availableImages[e],delete this.workerSources[e],delete this.demWorkerSources[e],r();}checkIfReady(e,t,r){r();}setReferrer(e,t){this.referrer=t;}spriteLoaded(t,r){this.isSpriteLoaded[t]=r;for(const o in this.workerSources[t]){const n=this.workerSources[t][o];for(const t in n)n[t]instanceof e.VectorTileWorkerSource&&(n[t].isSpriteLoaded=r,n[t].fire(new e.Event("isSpriteLoaded")));}}setImages(e,t,r){this.availableImages[e]=t;for(const r in this.workerSources[e]){const o=this.workerSources[e][r];for(const e in o)o[e].availableImages=t;}r();}enableTerrain(e,t,r){this.terrain=t,r();}setProjection(t,r){this.projections[t]=e.getProjection(r);}setLayers(e,t,r){this.getLayerIndex(e).replace(t),r();}updateLayers(e,t,r){this.getLayerIndex(e).update(t.layers,t.removedIds),r();}loadTile(t,r,o){const n=this.enableTerrain?e.extend({enableTerrain:this.terrain},r):r;n.projection=this.projections[t]||this.defaultProjection,this.getWorkerSource(t,r.type,r.source).loadTile(n,o);}loadDEMTile(t,r,o){const n=this.enableTerrain?e.extend({buildQuadTree:this.terrain},r):r;this.getDEMWorkerSource(t,r.source).loadTile(n,o);}reloadTile(t,r,o){const n=this.enableTerrain?e.extend({enableTerrain:this.terrain},r):r;n.projection=this.projections[t]||this.defaultProjection,this.getWorkerSource(t,r.type,r.source).reloadTile(n,o);}abortTile(e,t,r){this.getWorkerSource(e,t.type,t.source).abortTile(t,r);}removeTile(e,t,r){this.getWorkerSource(e,t.type,t.source).removeTile(t,r);}removeSource(e,t,r){if(!this.workerSources[e]||!this.workerSources[e][t.type]||!this.workerSources[e][t.type][t.source])return;const o=this.workerSources[e][t.type][t.source];delete this.workerSources[e][t.type][t.source],void 0!==o.removeSource?o.removeSource(t,r):r();}loadWorkerSource(e,t,r){try{this.self.importScripts(t.url),r();}catch(e){r(e.toString());}}syncRTLPluginState(t,r,o){try{e.plugin.setState(r);const t=e.plugin.getPluginURL();if(e.plugin.isLoaded()&&!e.plugin.isParsed()&&null!=t){this.self.importScripts(t);const r=e.plugin.isParsed();o(r?void 0:new Error(`RTL Text Plugin failed to import scripts from ${t}`),r);}}catch(e){o(e.toString());}}getAvailableImages(e){let t=this.availableImages[e];return t||(t=[]),t}getLayerIndex(e){let t=this.layerIndexes[e];return t||(t=this.layerIndexes[e]=new o),t}getWorkerSource(e,t,r){return this.workerSources[e]||(this.workerSources[e]={}),this.workerSources[e][t]||(this.workerSources[e][t]={}),this.workerSources[e][t][r]||(this.workerSources[e][t][r]=new this.workerSourceTypes[t]({send:(t,r,o,n,i,s)=>{this.actor.send(t,r,o,e,i,s);},scheduler:this.actor.scheduler},this.getLayerIndex(e),this.getAvailableImages(e),this.isSpriteLoaded[e])),this.workerSources[e][t][r]}getDEMWorkerSource(e,t){return this.demWorkerSources[e]||(this.demWorkerSources[e]={}),this.demWorkerSources[e][t]||(this.demWorkerSources[e][t]=new i),this.demWorkerSources[e][t]}enforceCacheSizeLimit(t,r){e.enforceCacheSizeLimit(r);}getWorkerPerformanceMetrics(e,t,r){r(void 0,void 0);}}return "undefined"!=typeof WorkerGlobalScope&&"undefined"!=typeof self&&self instanceof WorkerGlobalScope&&(self.worker=new Pe(self)),Pe}));

define(["./shared"],(function(e){"use strict";var t=i;function i(e){return !function(e){return "undefined"==typeof window||"undefined"==typeof document?"not a browser":Array.prototype&&Array.prototype.every&&Array.prototype.filter&&Array.prototype.forEach&&Array.prototype.indexOf&&Array.prototype.lastIndexOf&&Array.prototype.map&&Array.prototype.some&&Array.prototype.reduce&&Array.prototype.reduceRight&&Array.isArray?Function.prototype&&Function.prototype.bind?Object.keys&&Object.create&&Object.getPrototypeOf&&Object.getOwnPropertyNames&&Object.isSealed&&Object.isFrozen&&Object.isExtensible&&Object.getOwnPropertyDescriptor&&Object.defineProperty&&Object.defineProperties&&Object.seal&&Object.freeze&&Object.preventExtensions?"JSON"in window&&"parse"in JSON&&"stringify"in JSON?function(){if(!("Worker"in window&&"Blob"in window&&"URL"in window))return !1;var e,t,i=new Blob([""],{type:"text/javascript"}),o=URL.createObjectURL(i);try{t=new Worker(o),e=!0;}catch(t){e=!1;}return t&&t.terminate(),URL.revokeObjectURL(o),e}()?"Uint8ClampedArray"in window?ArrayBuffer.isView?function(){var e=document.createElement("canvas");e.width=e.height=1;var t=e.getContext("2d");if(!t)return !1;var i=t.getImageData(0,0,1,1);return i&&i.width===e.width}()?(void 0===o[t=e&&e.failIfMajorPerformanceCaveat]&&(o[t]=function(e){var t,o=function(e){var t=document.createElement("canvas"),o=Object.create(i.webGLContextAttributes);return o.failIfMajorPerformanceCaveat=e,t.getContext("webgl",o)||t.getContext("experimental-webgl",o)}(e);if(!o)return !1;try{t=o.createShader(o.VERTEX_SHADER);}catch(e){return !1}return !(!t||o.isContextLost())&&(o.shaderSource(t,"void main() {}"),o.compileShader(t),!0===o.getShaderParameter(t,o.COMPILE_STATUS))}(t)),o[t]?document.documentMode?"insufficient ECMAScript 6 support":void 0:"insufficient WebGL support"):"insufficient Canvas/getImageData support":"insufficient ArrayBuffer support":"insufficient Uint8ClampedArray support":"insufficient worker support":"insufficient JSON support":"insufficient Object support":"insufficient Function support":"insufficent Array support";var t;}(e)}var o={};function r(e,t){var i=t[0],o=t[1],r=t[2],n=t[3],a=i*n-r*o;return a?(e[0]=n*(a=1/a),e[1]=-o*a,e[2]=-r*a,e[3]=i*a,e):null}function n(e,t){if(Array.isArray(e)){if(!Array.isArray(t)||e.length!==t.length)return !1;for(let i=0;i<e.length;i++)if(!n(e[i],t[i]))return !1;return !0}if("object"==typeof e&&null!==e&&null!==t){if("object"!=typeof t)return !1;if(Object.keys(e).length!==Object.keys(t).length)return !1;for(const i in e)if(!n(e[i],t[i]))return !1;return !0}return e===t}i.webGLContextAttributes={antialias:!1,alpha:!0,stencil:!0,depth:!0};const a={create:function(t,i,o){const r=e.window.document.createElement(t);return void 0!==i&&(r.className=i),o&&o.appendChild(r),r},createSVG:function(t,i,o){const r=e.window.document.createElementNS("http://www.w3.org/2000/svg",t);for(const e of Object.keys(i))r.setAttributeNS(null,e,i[e]);return o&&o.appendChild(r),r}},s=e.window.document&&e.window.document.documentElement.style,l=s&&void 0!==s.userSelect?"userSelect":"WebkitUserSelect";let c;a.disableDrag=function(){s&&l&&(c=s[l],s[l]="none");},a.enableDrag=function(){s&&l&&(s[l]=c);};const h=function(t){t.preventDefault(),t.stopPropagation(),e.window.removeEventListener("click",h,!0);};function u(t,i,o){const r=t.offsetWidth===i.width?1:t.offsetWidth/i.width;return new e.pointGeometry((o.clientX-i.left)*r,(o.clientY-i.top)*r)}function _(e){const{userImage:t}=e;return !!(t&&t.render&&t.render())&&(e.data.replace(new Uint8Array(t.data.buffer)),!0)}a.suppressClick=function(){e.window.addEventListener("click",h,!0),e.window.setTimeout((()=>{e.window.removeEventListener("click",h,!0);}),0);},a.mousePos=function(e,t){const i=e.getBoundingClientRect();return u(e,i,t)},a.touchPos=function(e,t){const i=e.getBoundingClientRect(),o=[];for(let r=0;r<t.length;r++)o.push(u(e,i,t[r]));return o},a.mouseButton=function(t){return void 0!==e.window.InstallTrigger&&2===t.button&&t.ctrlKey&&e.window.navigator.platform.toUpperCase().indexOf("MAC")>=0?0:t.button};class d extends e.Evented{constructor(){super(),this.images={},this.updatedImages={},this.callbackDispatchedThisFrame={},this.loaded=!1,this.requestors=[],this.patterns={},this.atlasImage=new e.RGBAImage({width:1,height:1}),this.dirty=!0;}isLoaded(){return this.loaded}setLoaded(e){if(this.loaded!==e&&(this.loaded=e,e)){for(const{ids:e,callback:t}of this.requestors)this._notify(e,t);this.requestors=[];}}getImage(e){return this.images[e]}addImage(e,t){this._validate(e,t)&&(this.images[e]=t);}_validate(t,i){let o=!0;return this._validateStretch(i.stretchX,i.data&&i.data.width)||(this.fire(new e.ErrorEvent(new Error(`Image "${t}" has invalid "stretchX" value`))),o=!1),this._validateStretch(i.stretchY,i.data&&i.data.height)||(this.fire(new e.ErrorEvent(new Error(`Image "${t}" has invalid "stretchY" value`))),o=!1),this._validateContent(i.content,i)||(this.fire(new e.ErrorEvent(new Error(`Image "${t}" has invalid "content" value`))),o=!1),o}_validateStretch(e,t){if(!e)return !0;let i=0;for(const o of e){if(o[0]<i||o[1]<o[0]||t<o[1])return !1;i=o[1];}return !0}_validateContent(e,t){return !(e&&(4!==e.length||e[0]<0||t.data.width<e[0]||e[1]<0||t.data.height<e[1]||e[2]<0||t.data.width<e[2]||e[3]<0||t.data.height<e[3]||e[2]<e[0]||e[3]<e[1]))}updateImage(e,t){t.version=this.images[e].version+1,this.images[e]=t,this.updatedImages[e]=!0;}removeImage(e){const t=this.images[e];delete this.images[e],delete this.patterns[e],t.userImage&&t.userImage.onRemove&&t.userImage.onRemove();}listImages(){return Object.keys(this.images)}getImages(e,t){let i=!0;if(!this.isLoaded())for(const t of e)this.images[t]||(i=!1);this.isLoaded()||i?this._notify(e,t):this.requestors.push({ids:e,callback:t});}_notify(t,i){const o={};for(const i of t){this.images[i]||this.fire(new e.Event("styleimagemissing",{id:i}));const t=this.images[i];t?o[i]={data:t.data.clone(),pixelRatio:t.pixelRatio,sdf:t.sdf,version:t.version,stretchX:t.stretchX,stretchY:t.stretchY,content:t.content,hasRenderCallback:Boolean(t.userImage&&t.userImage.render)}:e.warnOnce(`Image "${i}" could not be loaded. Please make sure you have added the image with map.addImage() or a "sprite" property in your style. You can provide missing images by listening for the "styleimagemissing" map event.`);}i(null,o);}getPixelSize(){const{width:e,height:t}=this.atlasImage;return {width:e,height:t}}getPattern(t){const i=this.patterns[t],o=this.getImage(t);if(!o)return null;if(i&&i.position.version===o.version)return i.position;if(i)i.position.version=o.version;else {const i={w:o.data.width+2,h:o.data.height+2,x:0,y:0},r=new e.ImagePosition(i,o);this.patterns[t]={bin:i,position:r};}return this._updatePatternAtlas(),this.patterns[t].position}bind(t){const i=t.gl;this.atlasTexture?this.dirty&&(this.atlasTexture.update(this.atlasImage),this.dirty=!1):this.atlasTexture=new e.Texture(t,this.atlasImage,i.RGBA),this.atlasTexture.bind(i.LINEAR,i.CLAMP_TO_EDGE);}_updatePatternAtlas(){const t=[];for(const e in this.patterns)t.push(this.patterns[e].bin);const{w:i,h:o}=e.potpack(t),r=this.atlasImage;r.resize({width:i||1,height:o||1});for(const t in this.patterns){const{bin:i}=this.patterns[t],o=i.x+1,n=i.y+1,a=this.images[t].data,s=a.width,l=a.height;e.RGBAImage.copy(a,r,{x:0,y:0},{x:o,y:n},{width:s,height:l}),e.RGBAImage.copy(a,r,{x:0,y:l-1},{x:o,y:n-1},{width:s,height:1}),e.RGBAImage.copy(a,r,{x:0,y:0},{x:o,y:n+l},{width:s,height:1}),e.RGBAImage.copy(a,r,{x:s-1,y:0},{x:o-1,y:n},{width:1,height:l}),e.RGBAImage.copy(a,r,{x:0,y:0},{x:o+s,y:n},{width:1,height:l});}this.dirty=!0;}beginFrame(){this.callbackDispatchedThisFrame={};}dispatchRenderCallbacks(e){for(const t of e){if(this.callbackDispatchedThisFrame[t])continue;this.callbackDispatchedThisFrame[t]=!0;const e=this.images[t];_(e)&&this.updateImage(t,e);}}}const p=new e.Properties({anchor:new e.DataConstantProperty(e.spec.light.anchor),position:new class{constructor(){this.specification=e.spec.light.position;}possiblyEvaluate(t,i){return function([t,i,o]){const r=e.degToRad(i+90),n=e.degToRad(o);return {x:t*Math.cos(r)*Math.sin(n),y:t*Math.sin(r)*Math.sin(n),z:t*Math.cos(n),azimuthal:i,polar:o}}(t.expression.evaluate(i))}interpolate(t,i,o){return {x:e.number(t.x,i.x,o),y:e.number(t.y,i.y,o),z:e.number(t.z,i.z,o),azimuthal:e.number(t.azimuthal,i.azimuthal,o),polar:e.number(t.polar,i.polar,o)}}},color:new e.DataConstantProperty(e.spec.light.color),intensity:new e.DataConstantProperty(e.spec.light.intensity)}),m="-transition";class f extends e.Evented{constructor(t){super(),this._transitionable=new e.Transitionable(p),this.setLight(t),this._transitioning=this._transitionable.untransitioned();}getLight(){return this._transitionable.serialize()}setLight(t,i={}){if(!this._validate(e.validateLight,t,i))for(const i in t){const o=t[i];e.endsWith(i,m)?this._transitionable.setTransition(i.slice(0,-m.length),o):this._transitionable.setValue(i,o);}}updateTransitions(e){this._transitioning=this._transitionable.transitioned(e,this._transitioning);}hasTransition(){return this._transitioning.hasTransition()}recalculate(e){this.properties=this._transitioning.possiblyEvaluate(e);}_validate(t,i,o){return (!o||!1!==o.validate)&&e.emitValidationErrors(this,t.call(e.validateStyle,e.extend({value:i,style:{glyphs:!0,sprite:!0},styleSpec:e.spec})))}}const g=new e.Properties({source:new e.DataConstantProperty(e.spec.terrain.source),exaggeration:new e.DataConstantProperty(e.spec.terrain.exaggeration)}),v="-transition";class x extends e.Evented{constructor(t,i){super(),this._transitionable=new e.Transitionable(g),this.set(t),this._transitioning=this._transitionable.untransitioned(),this.drapeRenderMode=i;}get(){return this._transitionable.serialize()}set(t){for(const i in t){const o=t[i];e.endsWith(i,v)?this._transitionable.setTransition(i.slice(0,-v.length),o):this._transitionable.setValue(i,o);}}updateTransitions(e){this._transitioning=this._transitionable.transitioned(e,this._transitioning);}hasTransition(){return this._transitioning.hasTransition()}recalculate(e){this.properties=this._transitioning.possiblyEvaluate(e);}}function y(t,i,o,r){const n=e.smoothstep(45,65,o),[a,s]=b(t,r),l=e.length(i);let c=1-Math.min(1,Math.exp((l-a)/(s-a)*-6));return c*=c*c,c=Math.min(1,1.00747*c),c*n*t.alpha}function b(e,t){const i=.5/Math.tan(.5*t);return [e.range[0]+i,e.range[1]+i]}const w=new e.Properties({range:new e.DataConstantProperty(e.spec.fog.range),color:new e.DataConstantProperty(e.spec.fog.color),"horizon-blend":new e.DataConstantProperty(e.spec.fog["horizon-blend"])}),T="-transition";class E extends e.Evented{constructor(t,i){super(),this._transitionable=new e.Transitionable(w),this.set(t),this._transitioning=this._transitionable.untransitioned(),this._transform=i;}get state(){return {range:this.properties.get("range"),horizonBlend:this.properties.get("horizon-blend"),alpha:this.properties.get("color").a}}get(){return this._transitionable.serialize()}set(t,i={}){if(!this._validate(e.validateFog,t,i))for(const i in t){const o=t[i];e.endsWith(i,T)?this._transitionable.setTransition(i.slice(0,-T.length),o):this._transitionable.setValue(i,o);}}getOpacity(t){if(!this._transform.projection.supportsFog)return 0;const i=this.properties&&this.properties.get("color")||1;return e.smoothstep(45,65,t)*i.a}getOpacityAtLatLng(t,i){return this._transform.projection.supportsFog?function(t,i,o){const r=e.MercatorCoordinate.fromLngLat(i),n=o.elevation?o.elevation.getAtPointOrZero(r):0,a=[r.x,r.y,n];return e.transformMat4(a,a,o.mercatorFogMatrix),y(t,a,o.pitch,o._fov)}(this.state,t,i):0}getFovAdjustedRange(e){return this._transform.projection.supportsFog?b(this.state,e):[0,1]}updateTransitions(e){this._transitioning=this._transitionable.transitioned(e,this._transitioning);}hasTransition(){return this._transitioning.hasTransition()}recalculate(e){this.properties=this._transitioning.possiblyEvaluate(e);}_validate(t,i,o){return (!o||!1!==o.validate)&&e.emitValidationErrors(this,t.call(e.validateStyle,e.extend({value:i,style:{glyphs:!0,sprite:!0},styleSpec:e.spec})))}}class C{constructor(t,i){this.workerPool=t,this.actors=[],this.currentActor=0,this.id=e.uniqueId();const o=this.workerPool.acquire(this.id);for(let e=0;e<o.length;e++){const t=new C.Actor(o[e],i,this.id);t.name=`Worker ${e}`,this.actors.push(t);}this.ready=!1,this.broadcast("checkIfReady",null,(()=>{this.ready=!0;}));}broadcast(t,i,o){e.asyncAll(this.actors,((e,o)=>{e.send(t,i,o);}),o=o||function(){});}getActor(){return this.currentActor=(this.currentActor+1)%this.actors.length,this.actors[this.currentActor]}remove(){this.actors.forEach((e=>{e.remove();})),this.actors=[],this.workerPool.release(this.id);}}function M(t,i,o){return i*(e.EXTENT/(t.tileSize*Math.pow(2,o-t.tileID.overscaledZ)))}C.Actor=e.Actor;class S{constructor(e,t,i){this.context=e;const o=e.gl;this.buffer=o.createBuffer(),this.dynamicDraw=Boolean(i),this.context.unbindVAO(),e.bindElementBuffer.set(this.buffer),o.bufferData(o.ELEMENT_ARRAY_BUFFER,t.arrayBuffer,this.dynamicDraw?o.DYNAMIC_DRAW:o.STATIC_DRAW),this.dynamicDraw||delete t.arrayBuffer;}bind(){this.context.bindElementBuffer.set(this.buffer);}updateData(e){const t=this.context.gl;this.context.unbindVAO(),this.bind(),t.bufferSubData(t.ELEMENT_ARRAY_BUFFER,0,e.arrayBuffer);}destroy(){this.buffer&&(this.context.gl.deleteBuffer(this.buffer),delete this.buffer);}}const I={Int8:"BYTE",Uint8:"UNSIGNED_BYTE",Int16:"SHORT",Uint16:"UNSIGNED_SHORT",Int32:"INT",Uint32:"UNSIGNED_INT",Float32:"FLOAT"};class z{constructor(e,t,i,o){this.length=t.length,this.attributes=i,this.itemSize=t.bytesPerElement,this.dynamicDraw=o,this.context=e;const r=e.gl;this.buffer=r.createBuffer(),e.bindVertexBuffer.set(this.buffer),r.bufferData(r.ARRAY_BUFFER,t.arrayBuffer,this.dynamicDraw?r.DYNAMIC_DRAW:r.STATIC_DRAW),this.dynamicDraw||delete t.arrayBuffer;}bind(){this.context.bindVertexBuffer.set(this.buffer);}updateData(e){const t=this.context.gl;this.bind(),t.bufferSubData(t.ARRAY_BUFFER,0,e.arrayBuffer);}enableAttributes(e,t){for(let i=0;i<this.attributes.length;i++){const o=t.attributes[this.attributes[i].name];void 0!==o&&e.enableVertexAttribArray(o);}}setVertexAttribPointers(e,t,i){for(let o=0;o<this.attributes.length;o++){const r=this.attributes[o],n=t.attributes[r.name];void 0!==n&&e.vertexAttribPointer(n,r.components,e[I[r.type]],!1,this.itemSize,r.offset+this.itemSize*(i||0));}}destroy(){this.buffer&&(this.context.gl.deleteBuffer(this.buffer),delete this.buffer);}}class D{constructor(e){this.gl=e.gl,this.default=this.getDefault(),this.current=this.default,this.dirty=!1;}get(){return this.current}set(e){}getDefault(){return this.default}setDefault(){this.set(this.default);}}class P extends D{getDefault(){return e.Color.transparent}set(e){const t=this.current;(e.r!==t.r||e.g!==t.g||e.b!==t.b||e.a!==t.a||this.dirty)&&(this.gl.clearColor(e.r,e.g,e.b,e.a),this.current=e,this.dirty=!1);}}class A extends D{getDefault(){return 1}set(e){(e!==this.current||this.dirty)&&(this.gl.clearDepth(e),this.current=e,this.dirty=!1);}}class L extends D{getDefault(){return 0}set(e){(e!==this.current||this.dirty)&&(this.gl.clearStencil(e),this.current=e,this.dirty=!1);}}class R extends D{getDefault(){return [!0,!0,!0,!0]}set(e){const t=this.current;(e[0]!==t[0]||e[1]!==t[1]||e[2]!==t[2]||e[3]!==t[3]||this.dirty)&&(this.gl.colorMask(e[0],e[1],e[2],e[3]),this.current=e,this.dirty=!1);}}class k extends D{getDefault(){return !0}set(e){(e!==this.current||this.dirty)&&(this.gl.depthMask(e),this.current=e,this.dirty=!1);}}class O extends D{getDefault(){return 255}set(e){(e!==this.current||this.dirty)&&(this.gl.stencilMask(e),this.current=e,this.dirty=!1);}}class B extends D{getDefault(){return {func:this.gl.ALWAYS,ref:0,mask:255}}set(e){const t=this.current;(e.func!==t.func||e.ref!==t.ref||e.mask!==t.mask||this.dirty)&&(this.gl.stencilFunc(e.func,e.ref,e.mask),this.current=e,this.dirty=!1);}}class F extends D{getDefault(){const e=this.gl;return [e.KEEP,e.KEEP,e.KEEP]}set(e){const t=this.current;(e[0]!==t[0]||e[1]!==t[1]||e[2]!==t[2]||this.dirty)&&(this.gl.stencilOp(e[0],e[1],e[2]),this.current=e,this.dirty=!1);}}class U extends D{getDefault(){return !1}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;e?t.enable(t.STENCIL_TEST):t.disable(t.STENCIL_TEST),this.current=e,this.dirty=!1;}}class N extends D{getDefault(){return [0,1]}set(e){const t=this.current;(e[0]!==t[0]||e[1]!==t[1]||this.dirty)&&(this.gl.depthRange(e[0],e[1]),this.current=e,this.dirty=!1);}}class G extends D{getDefault(){return !1}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;e?t.enable(t.DEPTH_TEST):t.disable(t.DEPTH_TEST),this.current=e,this.dirty=!1;}}class j extends D{getDefault(){return this.gl.LESS}set(e){(e!==this.current||this.dirty)&&(this.gl.depthFunc(e),this.current=e,this.dirty=!1);}}class Z extends D{getDefault(){return !1}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;e?t.enable(t.BLEND):t.disable(t.BLEND),this.current=e,this.dirty=!1;}}class V extends D{getDefault(){const e=this.gl;return [e.ONE,e.ZERO]}set(e){const t=this.current;(e[0]!==t[0]||e[1]!==t[1]||this.dirty)&&(this.gl.blendFunc(e[0],e[1]),this.current=e,this.dirty=!1);}}class W extends D{getDefault(){return e.Color.transparent}set(e){const t=this.current;(e.r!==t.r||e.g!==t.g||e.b!==t.b||e.a!==t.a||this.dirty)&&(this.gl.blendColor(e.r,e.g,e.b,e.a),this.current=e,this.dirty=!1);}}class q extends D{getDefault(){return this.gl.FUNC_ADD}set(e){(e!==this.current||this.dirty)&&(this.gl.blendEquation(e),this.current=e,this.dirty=!1);}}class X extends D{getDefault(){return !1}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;e?t.enable(t.CULL_FACE):t.disable(t.CULL_FACE),this.current=e,this.dirty=!1;}}class $ extends D{getDefault(){return this.gl.BACK}set(e){(e!==this.current||this.dirty)&&(this.gl.cullFace(e),this.current=e,this.dirty=!1);}}class H extends D{getDefault(){return this.gl.CCW}set(e){(e!==this.current||this.dirty)&&(this.gl.frontFace(e),this.current=e,this.dirty=!1);}}class K extends D{getDefault(){return null}set(e){(e!==this.current||this.dirty)&&(this.gl.useProgram(e),this.current=e,this.dirty=!1);}}class Y extends D{getDefault(){return this.gl.TEXTURE0}set(e){(e!==this.current||this.dirty)&&(this.gl.activeTexture(e),this.current=e,this.dirty=!1);}}class J extends D{getDefault(){const e=this.gl;return [0,0,e.drawingBufferWidth,e.drawingBufferHeight]}set(e){const t=this.current;(e[0]!==t[0]||e[1]!==t[1]||e[2]!==t[2]||e[3]!==t[3]||this.dirty)&&(this.gl.viewport(e[0],e[1],e[2],e[3]),this.current=e,this.dirty=!1);}}class Q extends D{getDefault(){return null}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.bindFramebuffer(t.FRAMEBUFFER,e),this.current=e,this.dirty=!1;}}class ee extends D{getDefault(){return null}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.bindRenderbuffer(t.RENDERBUFFER,e),this.current=e,this.dirty=!1;}}class te extends D{getDefault(){return null}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.bindTexture(t.TEXTURE_2D,e),this.current=e,this.dirty=!1;}}class ie extends D{getDefault(){return null}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.bindBuffer(t.ARRAY_BUFFER,e),this.current=e,this.dirty=!1;}}class oe extends D{getDefault(){return null}set(e){const t=this.gl;t.bindBuffer(t.ELEMENT_ARRAY_BUFFER,e),this.current=e,this.dirty=!1;}}class re extends D{constructor(e){super(e),this.vao=e.extVertexArrayObject;}getDefault(){return null}set(e){this.vao&&(e!==this.current||this.dirty)&&(this.vao.bindVertexArrayOES(e),this.current=e,this.dirty=!1);}}class ne extends D{getDefault(){return 4}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.pixelStorei(t.UNPACK_ALIGNMENT,e),this.current=e,this.dirty=!1;}}class ae extends D{getDefault(){return !1}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.pixelStorei(t.UNPACK_PREMULTIPLY_ALPHA_WEBGL,e),this.current=e,this.dirty=!1;}}class se extends D{getDefault(){return !1}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.pixelStorei(t.UNPACK_FLIP_Y_WEBGL,e),this.current=e,this.dirty=!1;}}class le extends D{constructor(e,t){super(e),this.context=e,this.parent=t;}getDefault(){return null}}class ce extends le{setDirty(){this.dirty=!0;}set(e){if(e===this.current&&!this.dirty)return;this.context.bindFramebuffer.set(this.parent);const t=this.gl;t.framebufferTexture2D(t.FRAMEBUFFER,t.COLOR_ATTACHMENT0,t.TEXTURE_2D,e,0),this.current=e,this.dirty=!1;}}class he extends le{attachment(){return this.gl.DEPTH_ATTACHMENT}set(e){if(e===this.current&&!this.dirty)return;this.context.bindFramebuffer.set(this.parent);const t=this.gl;t.framebufferRenderbuffer(t.FRAMEBUFFER,this.attachment(),t.RENDERBUFFER,e),this.current=e,this.dirty=!1;}}class ue extends he{attachment(){return this.gl.DEPTH_STENCIL_ATTACHMENT}}class _e{constructor(e,t,i,o){this.context=e,this.width=t,this.height=i;const r=this.framebuffer=e.gl.createFramebuffer();this.colorAttachment=new ce(e,r),o&&(this.depthAttachment=new he(e,r));}destroy(){const e=this.context.gl,t=this.colorAttachment.get();if(t&&e.deleteTexture(t),this.depthAttachment){const t=this.depthAttachment.get();t&&e.deleteRenderbuffer(t);}e.deleteFramebuffer(this.framebuffer);}}class de{constructor(e){this.gl=e,this.extVertexArrayObject=this.gl.getExtension("OES_vertex_array_object"),this.clearColor=new P(this),this.clearDepth=new A(this),this.clearStencil=new L(this),this.colorMask=new R(this),this.depthMask=new k(this),this.stencilMask=new O(this),this.stencilFunc=new B(this),this.stencilOp=new F(this),this.stencilTest=new U(this),this.depthRange=new N(this),this.depthTest=new G(this),this.depthFunc=new j(this),this.blend=new Z(this),this.blendFunc=new V(this),this.blendColor=new W(this),this.blendEquation=new q(this),this.cullFace=new X(this),this.cullFaceSide=new $(this),this.frontFace=new H(this),this.program=new K(this),this.activeTexture=new Y(this),this.viewport=new J(this),this.bindFramebuffer=new Q(this),this.bindRenderbuffer=new ee(this),this.bindTexture=new te(this),this.bindVertexBuffer=new ie(this),this.bindElementBuffer=new oe(this),this.bindVertexArrayOES=this.extVertexArrayObject&&new re(this),this.pixelStoreUnpack=new ne(this),this.pixelStoreUnpackPremultiplyAlpha=new ae(this),this.pixelStoreUnpackFlipY=new se(this),this.extTextureFilterAnisotropic=e.getExtension("EXT_texture_filter_anisotropic")||e.getExtension("MOZ_EXT_texture_filter_anisotropic")||e.getExtension("WEBKIT_EXT_texture_filter_anisotropic"),this.extTextureFilterAnisotropic&&(this.extTextureFilterAnisotropicMax=e.getParameter(this.extTextureFilterAnisotropic.MAX_TEXTURE_MAX_ANISOTROPY_EXT)),this.extTextureFilterAnisotropicForceOff=!1,this.extTextureHalfFloat=e.getExtension("OES_texture_half_float"),this.extTextureHalfFloat&&(e.getExtension("OES_texture_half_float_linear"),this.extRenderToTextureHalfFloat=e.getExtension("EXT_color_buffer_half_float")),this.extTimerQuery=e.getExtension("EXT_disjoint_timer_query"),this.maxTextureSize=e.getParameter(e.MAX_TEXTURE_SIZE);}setDefault(){this.unbindVAO(),this.clearColor.setDefault(),this.clearDepth.setDefault(),this.clearStencil.setDefault(),this.colorMask.setDefault(),this.depthMask.setDefault(),this.stencilMask.setDefault(),this.stencilFunc.setDefault(),this.stencilOp.setDefault(),this.stencilTest.setDefault(),this.depthRange.setDefault(),this.depthTest.setDefault(),this.depthFunc.setDefault(),this.blend.setDefault(),this.blendFunc.setDefault(),this.blendColor.setDefault(),this.blendEquation.setDefault(),this.cullFace.setDefault(),this.cullFaceSide.setDefault(),this.frontFace.setDefault(),this.program.setDefault(),this.activeTexture.setDefault(),this.bindFramebuffer.setDefault(),this.pixelStoreUnpack.setDefault(),this.pixelStoreUnpackPremultiplyAlpha.setDefault(),this.pixelStoreUnpackFlipY.setDefault();}setDirty(){this.clearColor.dirty=!0,this.clearDepth.dirty=!0,this.clearStencil.dirty=!0,this.colorMask.dirty=!0,this.depthMask.dirty=!0,this.stencilMask.dirty=!0,this.stencilFunc.dirty=!0,this.stencilOp.dirty=!0,this.stencilTest.dirty=!0,this.depthRange.dirty=!0,this.depthTest.dirty=!0,this.depthFunc.dirty=!0,this.blend.dirty=!0,this.blendFunc.dirty=!0,this.blendColor.dirty=!0,this.blendEquation.dirty=!0,this.cullFace.dirty=!0,this.cullFaceSide.dirty=!0,this.frontFace.dirty=!0,this.program.dirty=!0,this.activeTexture.dirty=!0,this.viewport.dirty=!0,this.bindFramebuffer.dirty=!0,this.bindRenderbuffer.dirty=!0,this.bindTexture.dirty=!0,this.bindVertexBuffer.dirty=!0,this.bindElementBuffer.dirty=!0,this.extVertexArrayObject&&(this.bindVertexArrayOES.dirty=!0),this.pixelStoreUnpack.dirty=!0,this.pixelStoreUnpackPremultiplyAlpha.dirty=!0,this.pixelStoreUnpackFlipY.dirty=!0;}createIndexBuffer(e,t){return new S(this,e,t)}createVertexBuffer(e,t,i){return new z(this,e,t,i)}createRenderbuffer(e,t,i){const o=this.gl,r=o.createRenderbuffer();return this.bindRenderbuffer.set(r),o.renderbufferStorage(o.RENDERBUFFER,e,t,i),this.bindRenderbuffer.set(null),r}createFramebuffer(e,t,i){return new _e(this,e,t,i)}clear({color:e,depth:t,stencil:i}){const o=this.gl;let r=0;e&&(r|=o.COLOR_BUFFER_BIT,this.clearColor.set(e),this.colorMask.set([!0,!0,!0,!0])),void 0!==t&&(r|=o.DEPTH_BUFFER_BIT,this.depthRange.set([0,1]),this.clearDepth.set(t),this.depthMask.set(!0)),void 0!==i&&(r|=o.STENCIL_BUFFER_BIT,this.clearStencil.set(i),this.stencilMask.set(255)),o.clear(r);}setCullFace(e){!1===e.enable?this.cullFace.set(!1):(this.cullFace.set(!0),this.cullFaceSide.set(e.mode),this.frontFace.set(e.frontFace));}setDepthMode(e){e.func!==this.gl.ALWAYS||e.mask?(this.depthTest.set(!0),this.depthFunc.set(e.func),this.depthMask.set(e.mask),this.depthRange.set(e.range)):this.depthTest.set(!1);}setStencilMode(e){e.test.func!==this.gl.ALWAYS||e.mask?(this.stencilTest.set(!0),this.stencilMask.set(e.mask),this.stencilOp.set([e.fail,e.depthFail,e.pass]),this.stencilFunc.set({func:e.test.func,ref:e.ref,mask:e.test.mask})):this.stencilTest.set(!1);}setColorMode(t){n(t.blendFunction,e.ColorMode.Replace)?this.blend.set(!1):(this.blend.set(!0),this.blendFunc.set(t.blendFunction),this.blendColor.set(t.blendColor)),this.colorMask.set(t.mask);}unbindVAO(){this.extVertexArrayObject&&this.bindVertexArrayOES.set(null);}}class pe{constructor(e,t,i,o){this.screenBounds=e,this.cameraPoint=t,this._screenRaycastCache={},this._cameraRaycastCache={},this.isAboveHorizon=i,this.screenGeometry=this.bufferedScreenGeometry(0),this.screenGeometryMercator=this.screenGeometry.map((e=>o.pointCoordinate3D(e))),this.cameraGeometry=this.bufferedCameraGeometry(0);}static createFromScreenPoints(t,i){let o,r;if(t instanceof e.pointGeometry||"number"==typeof t[0]){const n=e.pointGeometry.convert(t);o=[e.pointGeometry.convert(t)],r=i.isPointAboveHorizon(n);}else {const n=e.pointGeometry.convert(t[0]),a=e.pointGeometry.convert(t[1]);o=[n,a],r=e.polygonizeBounds(n,a).every((e=>i.isPointAboveHorizon(e)));}return new pe(o,i.getCameraPoint(),r,i)}isPointQuery(){return 1===this.screenBounds.length}bufferedScreenGeometry(t){return e.polygonizeBounds(this.screenBounds[0],1===this.screenBounds.length?this.screenBounds[0]:this.screenBounds[1],t)}bufferedCameraGeometry(t){const i=this.screenBounds[0],o=1===this.screenBounds.length?this.screenBounds[0].add(new e.pointGeometry(1,1)):this.screenBounds[1],r=e.polygonizeBounds(i,o,0,!1);return this.cameraPoint.y>o.y&&(this.cameraPoint.x>i.x&&this.cameraPoint.x<o.x?r.splice(3,0,this.cameraPoint):this.cameraPoint.x>=o.x?r[2]=this.cameraPoint:this.cameraPoint.x<=i.x&&(r[3]=this.cameraPoint)),e.bufferConvexPolygon(r,t)}containsTile(t,i,o){const r=t.queryPadding+1,n=t.tileID.wrap,a=o?this._bufferedCameraMercator(r,i).map((i=>e.getTilePoint(t.tileTransform,i,n))):this._bufferedScreenMercator(r,i).map((i=>e.getTilePoint(t.tileTransform,i,n))),s=this.screenGeometryMercator.map((i=>e.getTileVec3(t.tileTransform,i,n))),l=s.map((t=>new e.pointGeometry(t[0],t[1]))),c=i.getFreeCameraOptions().position||new e.MercatorCoordinate(0,0,0),h=e.getTileVec3(t.tileTransform,c,n),u=s.map((t=>{const i=e.sub(t,t,h);return e.normalize(i,i),new e.Ray(h,i)})),_=M(t,1,i.zoom);if(e.polygonIntersectsBox(a,0,0,e.EXTENT,e.EXTENT))return {queryGeometry:this,tilespaceGeometry:l,tilespaceRays:u,bufferedTilespaceGeometry:a,bufferedTilespaceBounds:(d=e.getBounds(a),d.min.x=e.clamp(d.min.x,0,e.EXTENT),d.min.y=e.clamp(d.min.y,0,e.EXTENT),d.max.x=e.clamp(d.max.x,0,e.EXTENT),d.max.y=e.clamp(d.max.y,0,e.EXTENT),d),tile:t,tileID:t.tileID,pixelToTileUnitsFactor:_};var d;}_bufferedScreenMercator(e,t){const i=me(e);if(this._screenRaycastCache[i])return this._screenRaycastCache[i];{const o=this.bufferedScreenGeometry(e).map((e=>t.pointCoordinate3D(e)));return this._screenRaycastCache[i]=o,o}}_bufferedCameraMercator(e,t){const i=me(e);if(this._cameraRaycastCache[i])return this._cameraRaycastCache[i];{const o=this.bufferedCameraGeometry(e).map((e=>t.pointCoordinate3D(e)));return this._cameraRaycastCache[i]=o,o}}}function me(e){return 100*e|0}function fe(t,i,o){const r=function(r,n){if(r)return o(r);if(n){const r=e.pick(e.extend(n,t),["tiles","minzoom","maxzoom","attribution","mapbox_logo","bounds","scheme","tileSize","encoding"]);n.vector_layers&&(r.vectorLayers=n.vector_layers,r.vectorLayerIds=r.vectorLayers.map((e=>e.id))),r.tiles=i.canonicalizeTileset(r,t.url),o(null,r);}};return t.url?e.getJSON(i.transformRequest(i.normalizeSourceURL(t.url),e.ResourceType.Source),r):e.exported.frame((()=>r(null,t)))}class ge{constructor(t,i,o){this.bounds=e.LngLatBounds.convert(this.validateBounds(t)),this.minzoom=i||0,this.maxzoom=o||24;}validateBounds(e){return Array.isArray(e)&&4===e.length?[Math.max(-180,e[0]),Math.max(-90,e[1]),Math.min(180,e[2]),Math.min(90,e[3])]:[-180,-90,180,90]}contains(t){const i=Math.pow(2,t.z),o=Math.floor(e.mercatorXfromLng(this.bounds.getWest())*i),r=Math.floor(e.mercatorYfromLat(this.bounds.getNorth())*i),n=Math.ceil(e.mercatorXfromLng(this.bounds.getEast())*i),a=Math.ceil(e.mercatorYfromLat(this.bounds.getSouth())*i);return t.x>=o&&t.x<n&&t.y>=r&&t.y<a}}class ve extends e.Evented{constructor(t,i,o,r){super(),this.id=t,this.dispatcher=o,this.setEventedParent(r),this.type="raster",this.minzoom=0,this.maxzoom=22,this.roundZoom=!0,this.scheme="xyz",this.tileSize=512,this._loaded=!1,this._options=e.extend({type:"raster"},i),e.extend(this,e.pick(i,["url","scheme","tileSize"]));}load(){this._loaded=!1,this.fire(new e.Event("dataloading",{dataType:"source"})),this._tileJSONRequest=fe(this._options,this.map._requestManager,((t,i)=>{this._tileJSONRequest=null,this._loaded=!0,t?this.fire(new e.ErrorEvent(t)):i&&(e.extend(this,i),i.bounds&&(this.tileBounds=new ge(i.bounds,this.minzoom,this.maxzoom)),e.postTurnstileEvent(i.tiles),this.fire(new e.Event("data",{dataType:"source",sourceDataType:"metadata"})),this.fire(new e.Event("data",{dataType:"source",sourceDataType:"content"})));}));}loaded(){return this._loaded}onAdd(e){this.map=e,this.load();}onRemove(){this._tileJSONRequest&&(this._tileJSONRequest.cancel(),this._tileJSONRequest=null);}serialize(){return e.extend({},this._options)}hasTile(e){return !this.tileBounds||this.tileBounds.contains(e.canonical)}loadTile(t,i){const o=e.exported.devicePixelRatio>=2,r=this.map._requestManager.normalizeTileURL(t.tileID.canonical.url(this.tiles,this.scheme),o,this.tileSize);t.request=e.getImage(this.map._requestManager.transformRequest(r,e.ResourceType.Tile),((o,r,n,a)=>{if(delete t.request,t.aborted)t.state="unloaded",i(null);else if(o)t.state="errored",i(o);else if(r){this.map._refreshExpiredTiles&&t.setExpiryData({cacheControl:n,expires:a});const o=this.map.painter.context,s=o.gl;t.texture=this.map.painter.getTileTexture(r.width),t.texture?t.texture.update(r,{useMipmap:!0}):(t.texture=new e.Texture(o,r,s.RGBA,{useMipmap:!0}),t.texture.bind(s.LINEAR,s.CLAMP_TO_EDGE),o.extTextureFilterAnisotropic&&s.texParameterf(s.TEXTURE_2D,o.extTextureFilterAnisotropic.TEXTURE_MAX_ANISOTROPY_EXT,o.extTextureFilterAnisotropicMax)),t.state="loaded",e.cacheEntryPossiblyAdded(this.dispatcher),i(null);}}));}abortTile(e,t){e.request&&(e.request.cancel(),delete e.request),t();}unloadTile(e,t){e.texture&&this.map.painter.saveTileTexture(e.texture),t();}hasTransition(){return !1}}let xe;function ye(t,i,o,r,n,a,s,l){const c=[t,o,n,i,r,a,1,1,1],h=[s,l,1],u=e.adjoint([],c),[_,d,p]=e.transformMat3(h,h,e.transpose(u,u));return e.multiply(c,[_,0,0,0,d,0,0,0,p],c)}class be extends e.Evented{constructor(e,t,i,o){super(),this.id=e,this.dispatcher=i,this.coordinates=t.coordinates,this.type="image",this.minzoom=0,this.maxzoom=22,this.tileSize=512,this.tiles={},this._loaded=!1,this.setEventedParent(o),this.options=t;}load(t,i){this._loaded=!1,this.fire(new e.Event("dataloading",{dataType:"source"})),this.url=this.options.url,e.getImage(this.map._requestManager.transformRequest(this.url,e.ResourceType.Image),((o,r)=>{this._loaded=!0,o?this.fire(new e.ErrorEvent(o)):r&&(this.image=e.exported.getImageData(r),this.width=this.image.width,this.height=this.image.height,t&&(this.coordinates=t),i&&i(),this._finishLoading());}));}loaded(){return this._loaded}updateImage(e){return this.image&&e.url?(this.options.url=e.url,this.load(e.coordinates,(()=>{this.texture=null;})),this):this}_finishLoading(){this.map&&(this.setCoordinates(this.coordinates),this.fire(new e.Event("data",{dataType:"source",sourceDataType:"metadata"})));}onAdd(e){this.map=e,this.load();}setCoordinates(t){this.coordinates=t,delete this._boundsArray;const i=t.map(e.MercatorCoordinate.fromLngLat);return this.tileID=function(t){let i=1/0,o=1/0,r=-1/0,n=-1/0;for(const e of t)i=Math.min(i,e.x),o=Math.min(o,e.y),r=Math.max(r,e.x),n=Math.max(n,e.y);const a=Math.max(r-i,n-o),s=Math.max(0,Math.floor(-Math.log(a)/Math.LN2)),l=Math.pow(2,s);return new e.CanonicalTileID(s,Math.floor((i+r)/2*l),Math.floor((o+n)/2*l))}(i),this.minzoom=this.maxzoom=this.tileID.z,this.fire(new e.Event("data",{dataType:"source",sourceDataType:"content"})),this}_clear(){delete this._boundsArray;}_makeBoundsArray(){const t=e.tileTransform(this.tileID,this.map.transform.projection),[i,o,r,n]=this.coordinates.map((i=>{const o=t.projection.project(i[0],i[1]);return e.getTilePoint(t,o)._round()}));return this.perspectiveTransform=function(t,i,o,r,n,a,s,l,c,h){const u=ye(0,0,t,0,0,i,t,i),_=ye(o,r,n,a,s,l,c,h);return e.multiply(_,e.adjoint(u,u),_),[_[6]/_[8]*t/e.EXTENT,_[7]/_[8]*i/e.EXTENT]}(this.width,this.height,i.x,i.y,o.x,o.y,n.x,n.y,r.x,r.y),this._boundsArray=new e.StructArrayLayout4i8,this._boundsArray.emplaceBack(i.x,i.y,0,0),this._boundsArray.emplaceBack(o.x,o.y,e.EXTENT,0),this._boundsArray.emplaceBack(n.x,n.y,0,e.EXTENT),this._boundsArray.emplaceBack(r.x,r.y,e.EXTENT,e.EXTENT),this.boundsBuffer&&(this.boundsBuffer.destroy(),delete this.boundsBuffer),this}prepare(){if(0===Object.keys(this.tiles).length||!this.image)return;const t=this.map.painter.context,i=t.gl;this._boundsArray||this._makeBoundsArray(),this.boundsBuffer||(this.boundsBuffer=t.createVertexBuffer(this._boundsArray,e.boundsAttributes.members)),this.boundsSegments||(this.boundsSegments=e.SegmentVector.simpleSegment(0,0,4,2)),this.texture||(this.texture=new e.Texture(t,this.image,i.RGBA),this.texture.bind(i.LINEAR,i.CLAMP_TO_EDGE));for(const e in this.tiles){const t=this.tiles[e];"loaded"!==t.state&&(t.state="loaded",t.texture=this.texture);}}loadTile(e,t){this.tileID&&this.tileID.equals(e.tileID.canonical)?(this.tiles[String(e.tileID.wrap)]=e,e.buckets={},t(null)):(e.state="errored",t(null));}serialize(){return {type:"image",url:this.options.url,coordinates:this.coordinates}}hasTransition(){return !1}}const we={vector:class extends e.Evented{constructor(t,i,o,r){if(super(),this.id=t,this.dispatcher=o,this.type="vector",this.minzoom=0,this.maxzoom=22,this.scheme="xyz",this.tileSize=512,this.reparseOverscaled=!0,this.isTileClipped=!0,this._loaded=!1,e.extend(this,e.pick(i,["url","scheme","tileSize","promoteId"])),this._options=e.extend({type:"vector"},i),this._collectResourceTiming=i.collectResourceTiming,512!==this.tileSize)throw new Error("vector tile sources must have a tileSize of 512");this.setEventedParent(r),this._tileWorkers={},this._deduped=new e.DedupedRequest;}load(){this._loaded=!1,this.fire(new e.Event("dataloading",{dataType:"source"})),this._tileJSONRequest=fe(this._options,this.map._requestManager,((t,i)=>{this._tileJSONRequest=null,this._loaded=!0,t?this.fire(new e.ErrorEvent(t)):i&&(e.extend(this,i),i.bounds&&(this.tileBounds=new ge(i.bounds,this.minzoom,this.maxzoom)),e.postTurnstileEvent(i.tiles,this.map._requestManager._customAccessToken),this.fire(new e.Event("data",{dataType:"source",sourceDataType:"metadata"})),this.fire(new e.Event("data",{dataType:"source",sourceDataType:"content"})));}));}loaded(){return this._loaded}hasTile(e){return !this.tileBounds||this.tileBounds.contains(e.canonical)}onAdd(e){this.map=e,this.load();}setSourceProperty(e){this._tileJSONRequest&&this._tileJSONRequest.cancel(),e();const t=this.map.style._getSourceCaches(this.id);for(const e of t)e.clearTiles();this.load();}setTiles(e){return this.setSourceProperty((()=>{this._options.tiles=e;})),this}setUrl(e){return this.setSourceProperty((()=>{this.url=e,this._options.url=e;})),this}onRemove(){this._tileJSONRequest&&(this._tileJSONRequest.cancel(),this._tileJSONRequest=null);}serialize(){return e.extend({},this._options)}loadTile(t,i){const o=this.map._requestManager.normalizeTileURL(t.tileID.canonical.url(this.tiles,this.scheme)),r={request:this.map._requestManager.transformRequest(o,e.ResourceType.Tile),data:void 0,uid:t.uid,tileID:t.tileID,tileZoom:t.tileZoom,zoom:t.tileID.overscaledZ,tileSize:this.tileSize*t.tileID.overscaleFactor(),type:this.type,source:this.id,pixelRatio:e.exported.devicePixelRatio,showCollisionBoxes:this.map.showCollisionBoxes,promoteId:this.promoteId,isSymbolTile:t.isSymbolTile};if(r.request.collectResourceTiming=this._collectResourceTiming,t.actor&&"expired"!==t.state)"loading"===t.state?t.reloadCallback=i:t.request=t.actor.send("reloadTile",r,n.bind(this));else if(t.actor=this._tileWorkers[o]=this._tileWorkers[o]||this.dispatcher.getActor(),this.dispatcher.ready)t.request=t.actor.send("loadTile",r,n.bind(this),void 0,!0);else {const i=e.loadVectorTile.call({deduped:this._deduped},r,((e,i)=>{e||!i?n.call(this,e):(r.data={cacheControl:i.cacheControl,expires:i.expires,rawData:i.rawData.slice(0)},t.actor&&t.actor.send("loadTile",r,n.bind(this),void 0,!0));}),!0);t.request={cancel:i};}function n(o,r){return delete t.request,t.aborted?i(null):o&&404!==o.status?i(o):(r&&r.resourceTiming&&(t.resourceTiming=r.resourceTiming),this.map._refreshExpiredTiles&&r&&t.setExpiryData(r),t.loadVectorData(r,this.map.painter),e.cacheEntryPossiblyAdded(this.dispatcher),i(null),void(t.reloadCallback&&(this.loadTile(t,t.reloadCallback),t.reloadCallback=null)))}}abortTile(e){e.request&&(e.request.cancel(),delete e.request),e.actor&&e.actor.send("abortTile",{uid:e.uid,type:this.type,source:this.id});}unloadTile(e){e.unloadVectorData(),e.actor&&e.actor.send("removeTile",{uid:e.uid,type:this.type,source:this.id});}hasTransition(){return !1}afterUpdate(){this._tileWorkers={};}},raster:ve,"raster-dem":class extends ve{constructor(t,i,o,r){super(t,i,o,r),this.type="raster-dem",this.maxzoom=22,this._options=e.extend({type:"raster-dem"},i),this.encoding=i.encoding||"mapbox";}loadTile(t,i){const o=this.map._requestManager.normalizeTileURL(t.tileID.canonical.url(this.tiles,this.scheme),!1,this.tileSize);function r(e,o){e&&(t.state="errored",i(e)),o&&(t.dem=o,t.dem.onDeserialize(),t.needsHillshadePrepare=!0,t.needsDEMTextureUpload=!0,t.state="loaded",i(null));}t.request=e.getImage(this.map._requestManager.transformRequest(o,e.ResourceType.Tile),function(o,n,a,s){if(delete t.request,t.aborted)t.state="unloaded",i(null);else if(o)t.state="errored",i(o);else if(n){this.map._refreshExpiredTiles&&t.setExpiryData({cacheControl:a,expires:s});const i=e.window.ImageBitmap&&n instanceof e.window.ImageBitmap&&(null==xe&&(xe=e.window.OffscreenCanvas&&new e.window.OffscreenCanvas(1,1).getContext("2d")&&"function"==typeof e.window.createImageBitmap),xe),o=1-(n.width-e.prevPowerOfTwo(n.width))/2;o<1||t.neighboringTiles||(t.neighboringTiles=this._getNeighboringTiles(t.tileID));const l=i?n:e.exported.getImageData(n,o),c={uid:t.uid,coord:t.tileID,source:this.id,rawImageData:l,encoding:this.encoding,padding:o};t.actor&&"expired"!==t.state||(t.actor=this.dispatcher.getActor(),t.actor.send("loadDEMTile",c,r.bind(this),void 0,!0));}}.bind(this));}_getNeighboringTiles(t){const i=t.canonical,o=Math.pow(2,i.z),r=(i.x-1+o)%o,n=0===i.x?t.wrap-1:t.wrap,a=(i.x+1+o)%o,s=i.x+1===o?t.wrap+1:t.wrap,l={};return l[new e.OverscaledTileID(t.overscaledZ,n,i.z,r,i.y).key]={backfilled:!1},l[new e.OverscaledTileID(t.overscaledZ,s,i.z,a,i.y).key]={backfilled:!1},i.y>0&&(l[new e.OverscaledTileID(t.overscaledZ,n,i.z,r,i.y-1).key]={backfilled:!1},l[new e.OverscaledTileID(t.overscaledZ,t.wrap,i.z,i.x,i.y-1).key]={backfilled:!1},l[new e.OverscaledTileID(t.overscaledZ,s,i.z,a,i.y-1).key]={backfilled:!1}),i.y+1<o&&(l[new e.OverscaledTileID(t.overscaledZ,n,i.z,r,i.y+1).key]={backfilled:!1},l[new e.OverscaledTileID(t.overscaledZ,t.wrap,i.z,i.x,i.y+1).key]={backfilled:!1},l[new e.OverscaledTileID(t.overscaledZ,s,i.z,a,i.y+1).key]={backfilled:!1}),l}unloadTile(e){e.demTexture&&this.map.painter.saveTileTexture(e.demTexture),e.fbo&&(e.fbo.destroy(),delete e.fbo),e.dem&&delete e.dem,delete e.neighboringTiles,e.state="unloaded";}},geojson:class extends e.Evented{constructor(t,i,o,r){super(),this.id=t,this.type="geojson",this.minzoom=0,this.maxzoom=18,this.tileSize=512,this.isTileClipped=!0,this.reparseOverscaled=!0,this._loaded=!1,this.actor=o.getActor(),this.setEventedParent(r),this._data=i.data,this._options=e.extend({},i),this._collectResourceTiming=i.collectResourceTiming,void 0!==i.maxzoom&&(this.maxzoom=i.maxzoom),i.type&&(this.type=i.type),i.attribution&&(this.attribution=i.attribution),this.promoteId=i.promoteId;const n=e.EXTENT/this.tileSize;this.workerOptions=e.extend({source:this.id,cluster:i.cluster||!1,geojsonVtOptions:{buffer:(void 0!==i.buffer?i.buffer:128)*n,tolerance:(void 0!==i.tolerance?i.tolerance:.375)*n,extent:e.EXTENT,maxZoom:this.maxzoom,lineMetrics:i.lineMetrics||!1,generateId:i.generateId||!1},superclusterOptions:{maxZoom:void 0!==i.clusterMaxZoom?i.clusterMaxZoom:this.maxzoom-1,minPoints:Math.max(2,i.clusterMinPoints||2),extent:e.EXTENT,radius:(void 0!==i.clusterRadius?i.clusterRadius:50)*n,log:!1,generateId:i.generateId||!1},clusterProperties:i.clusterProperties,filter:i.filter},i.workerOptions);}onAdd(e){this.map=e,this.setData(this._data);}setData(e){return this._data=e,this._updateWorkerData(),this}getClusterExpansionZoom(e,t){return this.actor.send("geojson.getClusterExpansionZoom",{clusterId:e,source:this.id},t),this}getClusterChildren(e,t){return this.actor.send("geojson.getClusterChildren",{clusterId:e,source:this.id},t),this}getClusterLeaves(e,t,i,o){return this.actor.send("geojson.getClusterLeaves",{source:this.id,clusterId:e,limit:t,offset:i},o),this}_updateWorkerData(){if(this._pendingLoad)return void(this._coalesce=!0);this.fire(new e.Event("dataloading",{dataType:"source"})),this._loaded=!1;const t=e.extend({},this.workerOptions),i=this._data;"string"==typeof i?(t.request=this.map._requestManager.transformRequest(e.exported.resolveURL(i),e.ResourceType.Source),t.request.collectResourceTiming=this._collectResourceTiming):t.data=JSON.stringify(i),this._pendingLoad=this.actor.send(`${this.type}.loadData`,t,((t,i)=>{if(this._loaded=!0,this._pendingLoad=null,t)this.fire(new e.ErrorEvent(t));else {const t={dataType:"source",sourceDataType:this._metadataFired?"content":"metadata"};this._collectResourceTiming&&i&&i.resourceTiming&&i.resourceTiming[this.id]&&(t.resourceTiming=i.resourceTiming[this.id]),this.fire(new e.Event("data",t)),this._metadataFired=!0;}this._coalesce&&(this._updateWorkerData(),this._coalesce=!1);}));}loaded(){return this._loaded}loadTile(t,i){const o=t.actor?"reloadTile":"loadTile";t.actor=this.actor,t.request=this.actor.send(o,{type:this.type,uid:t.uid,tileID:t.tileID,tileZoom:t.tileZoom,zoom:t.tileID.overscaledZ,maxZoom:this.maxzoom,tileSize:this.tileSize,source:this.id,pixelRatio:e.exported.devicePixelRatio,showCollisionBoxes:this.map.showCollisionBoxes,promoteId:this.promoteId},((e,r)=>(delete t.request,t.unloadVectorData(),t.aborted?i(null):e?i(e):(t.loadVectorData(r,this.map.painter,"reloadTile"===o),i(null)))),void 0,"loadTile"===o);}abortTile(e){e.request&&(e.request.cancel(),delete e.request),e.aborted=!0;}unloadTile(e){e.unloadVectorData(),this.actor.send("removeTile",{uid:e.uid,type:this.type,source:this.id});}onRemove(){this._pendingLoad&&this._pendingLoad.cancel();}serialize(){return e.extend({},this._options,{type:this.type,data:this._data})}hasTransition(){return !1}},video:class extends be{constructor(e,t,i,o){super(e,t,i,o),this.roundZoom=!0,this.type="video",this.options=t;}load(){this._loaded=!1;const t=this.options;this.urls=[];for(const i of t.urls)this.urls.push(this.map._requestManager.transformRequest(i,e.ResourceType.Source).url);e.getVideo(this.urls,((t,i)=>{this._loaded=!0,t?this.fire(new e.ErrorEvent(t)):i&&(this.video=i,this.video.loop=!0,this.video.setAttribute("playsinline",""),this.video.addEventListener("playing",(()=>{this.map.triggerRepaint();})),this.map&&this.video.play(),this._finishLoading());}));}pause(){this.video&&this.video.pause();}play(){this.video&&this.video.play();}seek(t){if(this.video){const i=this.video.seekable;t<i.start(0)||t>i.end(0)?this.fire(new e.ErrorEvent(new e.ValidationError(`sources.${this.id}`,null,`Playback for this video can be set only between the ${i.start(0)} and ${i.end(0)}-second mark.`))):this.video.currentTime=t;}}getVideo(){return this.video}onAdd(e){this.map||(this.map=e,this.load(),this.video&&(this.video.play(),this.setCoordinates(this.coordinates)));}prepare(){if(0===Object.keys(this.tiles).length||this.video.readyState<2)return;const t=this.map.painter.context,i=t.gl;this.texture?this.video.paused||(this.texture.bind(i.LINEAR,i.CLAMP_TO_EDGE),i.texSubImage2D(i.TEXTURE_2D,0,0,0,i.RGBA,i.UNSIGNED_BYTE,this.video)):(this.texture=new e.Texture(t,this.video,i.RGBA),this.texture.bind(i.LINEAR,i.CLAMP_TO_EDGE),this.width=this.video.videoWidth,this.height=this.video.videoHeight),this._boundsArray||this._makeBoundsArray(),this.boundsBuffer||(this.boundsBuffer=t.createVertexBuffer(this._boundsArray,e.boundsAttributes.members)),this.boundsSegments||(this.boundsSegments=e.SegmentVector.simpleSegment(0,0,4,2));for(const e in this.tiles){const t=this.tiles[e];"loaded"!==t.state&&(t.state="loaded",t.texture=this.texture);}}serialize(){return {type:"video",urls:this.urls,coordinates:this.coordinates}}hasTransition(){return this.video&&!this.video.paused}},image:be,canvas:class extends be{constructor(t,i,o,r){super(t,i,o,r),i.coordinates?Array.isArray(i.coordinates)&&4===i.coordinates.length&&!i.coordinates.some((e=>!Array.isArray(e)||2!==e.length||e.some((e=>"number"!=typeof e))))||this.fire(new e.ErrorEvent(new e.ValidationError(`sources.${t}`,null,'"coordinates" property must be an array of 4 longitude/latitude array pairs'))):this.fire(new e.ErrorEvent(new e.ValidationError(`sources.${t}`,null,'missing required property "coordinates"'))),i.animate&&"boolean"!=typeof i.animate&&this.fire(new e.ErrorEvent(new e.ValidationError(`sources.${t}`,null,'optional "animate" property must be a boolean value'))),i.canvas?"string"==typeof i.canvas||i.canvas instanceof e.window.HTMLCanvasElement||this.fire(new e.ErrorEvent(new e.ValidationError(`sources.${t}`,null,'"canvas" must be either a string representing the ID of the canvas element from which to read, or an HTMLCanvasElement instance'))):this.fire(new e.ErrorEvent(new e.ValidationError(`sources.${t}`,null,'missing required property "canvas"'))),this.options=i,this.animate=void 0===i.animate||i.animate;}load(){this._loaded=!0,this.canvas||(this.canvas=this.options.canvas instanceof e.window.HTMLCanvasElement?this.options.canvas:e.window.document.getElementById(this.options.canvas)),this.width=this.canvas.width,this.height=this.canvas.height,this._hasInvalidDimensions()?this.fire(new e.ErrorEvent(new Error("Canvas dimensions cannot be less than or equal to zero."))):(this.play=function(){this._playing=!0,this.map.triggerRepaint();},this.pause=function(){this._playing&&(this.prepare(),this._playing=!1);},this._finishLoading());}getCanvas(){return this.canvas}onAdd(e){this.map=e,this.load(),this.canvas&&this.animate&&this.play();}onRemove(){this.pause();}prepare(){let t=!1;if(this.canvas.width!==this.width&&(this.width=this.canvas.width,t=!0),this.canvas.height!==this.height&&(this.height=this.canvas.height,t=!0),this._hasInvalidDimensions())return;if(0===Object.keys(this.tiles).length)return;const i=this.map.painter.context,o=i.gl;this._boundsArray||this._makeBoundsArray(),this.boundsBuffer||(this.boundsBuffer=i.createVertexBuffer(this._boundsArray,e.boundsAttributes.members)),this.boundsSegments||(this.boundsSegments=e.SegmentVector.simpleSegment(0,0,4,2)),this.texture?(t||this._playing)&&this.texture.update(this.canvas,{premultiply:!0}):this.texture=new e.Texture(i,this.canvas,o.RGBA,{premultiply:!0});for(const e in this.tiles){const t=this.tiles[e];"loaded"!==t.state&&(t.state="loaded",t.texture=this.texture);}}serialize(){return {type:"canvas",coordinates:this.coordinates}}hasTransition(){return this._playing}_hasInvalidDimensions(){for(const e of [this.canvas.width,this.canvas.height])if(isNaN(e)||e<=0)return !0;return !1}}},Te=function(t,i,o,r){const n=new we[i.type](t,i,o,r);if(n.id!==t)throw new Error(`Expected Source id to be ${t} instead of ${n.id}`);return e.bindAll(["load","abort","unload","serialize","prepare"],n),n};function Ee(t,i){const o=e.identity([]);return e.scale(o,o,[.5*t.width,.5*-t.height,1]),e.translate(o,o,[1,-1,0]),e.multiply$1(o,o,t.calculateProjMatrix(i.toUnwrapped()))}function Ce(e,t,i,o,r,n,a,s=!1){const l=e.tilesIn(o,a,s);l.sort(Se);const c=[];for(const o of l)c.push({wrappedTileID:o.tile.tileID.wrapped().key,queryResults:o.tile.queryRenderedFeatures(t,i,e._state,o,r,n,Ee(e.transform,o.tile.tileID),s)});const h=function(e){const t={},i={};for(const o of e){const e=o.queryResults,r=o.wrappedTileID,n=i[r]=i[r]||{};for(const i in e){const o=e[i],r=n[i]=n[i]||{},a=t[i]=t[i]||[];for(const e of o)r[e.featureIndex]||(r[e.featureIndex]=!0,a.push(e));}}return t}(c);for(const t in h)h[t].forEach((t=>{const i=t.feature,o=e.getFeatureState(i.layer["source-layer"],i.id);i.source=i.layer.source,i.layer["source-layer"]&&(i.sourceLayer=i.layer["source-layer"]),i.state=o;}));return h}function Me(e,t){const i=e.getRenderableIds().map((t=>e.getTileByID(t))),o=[],r={};for(let e=0;e<i.length;e++){const n=i[e],a=n.tileID.canonical.key;r[a]||(r[a]=!0,n.querySourceFeatures(o,t));}return o}function Se(e,t){const i=e.tileID,o=t.tileID;return i.overscaledZ-o.overscaledZ||i.canonical.y-o.canonical.y||i.wrap-o.wrap||i.canonical.x-o.canonical.x}function Ie(){return null!=Kr.workerClass?new Kr.workerClass:new e.window.Worker(Kr.workerUrl)}const ze="mapboxgl_preloaded_worker_pool";class De{constructor(){this.active={};}acquire(e){if(!this.workers)for(this.workers=[];this.workers.length<De.workerCount;)this.workers.push(new Ie);return this.active[e]=!0,this.workers.slice()}release(e){delete this.active[e],0===this.numActive()&&(this.workers.forEach((e=>{e.terminate();})),this.workers=null);}isPreloaded(){return !!this.active[ze]}numActive(){return Object.keys(this.active).length}}let Pe;function Ae(){return Pe||(Pe=new De),Pe}function Le(t,i){const o={};for(const e in t)"ref"!==e&&(o[e]=t[e]);return e.refProperties.forEach((e=>{e in i&&(o[e]=i[e]);})),o}function Re(e){e=e.slice();const t=Object.create(null);for(let i=0;i<e.length;i++)t[e[i].id]=e[i];for(let i=0;i<e.length;i++)"ref"in e[i]&&(e[i]=Le(e[i],t[e[i].ref]));return e}De.workerCount=2;const ke={setStyle:"setStyle",addLayer:"addLayer",removeLayer:"removeLayer",setPaintProperty:"setPaintProperty",setLayoutProperty:"setLayoutProperty",setFilter:"setFilter",addSource:"addSource",removeSource:"removeSource",setGeoJSONSourceData:"setGeoJSONSourceData",setLayerZoomRange:"setLayerZoomRange",setLayerProperty:"setLayerProperty",setCenter:"setCenter",setZoom:"setZoom",setBearing:"setBearing",setPitch:"setPitch",setSprite:"setSprite",setGlyphs:"setGlyphs",setTransition:"setTransition",setLight:"setLight",setTerrain:"setTerrain",setFog:"setFog",setProjection:"setProjection"};function Oe(e,t,i){i.push({command:ke.addSource,args:[e,t[e]]});}function Be(e,t,i){t.push({command:ke.removeSource,args:[e]}),i[e]=!0;}function Fe(e,t,i,o){Be(e,i,o),Oe(e,t,i);}function Ue(e,t,i){let o;for(o in e[i])if(e[i].hasOwnProperty(o)&&"data"!==o&&!n(e[i][o],t[i][o]))return !1;for(o in t[i])if(t[i].hasOwnProperty(o)&&"data"!==o&&!n(e[i][o],t[i][o]))return !1;return !0}function Ne(e,t,i,o,r,a){let s;for(s in t=t||{},e=e||{})e.hasOwnProperty(s)&&(n(e[s],t[s])||i.push({command:a,args:[o,s,t[s],r]}));for(s in t)t.hasOwnProperty(s)&&!e.hasOwnProperty(s)&&(n(e[s],t[s])||i.push({command:a,args:[o,s,t[s],r]}));}function Ge(e){return e.id}function je(e,t){return e[t.id]=t,e}class Ze{constructor(e,t){this.reset(e,t);}reset(e,t){this.points=e||[],this._distances=[0];for(let e=1;e<this.points.length;e++)this._distances[e]=this._distances[e-1]+this.points[e].dist(this.points[e-1]);this.length=this._distances[this._distances.length-1],this.padding=Math.min(t||0,.5*this.length),this.paddedLength=this.length-2*this.padding;}lerp(t){if(1===this.points.length)return this.points[0];t=e.clamp(t,0,1);let i=1,o=this._distances[i];const r=t*this.paddedLength+this.padding;for(;o<r&&i<this._distances.length;)o=this._distances[++i];const n=i-1,a=this._distances[n],s=o-a,l=s>0?(r-a)/s:0;return this.points[n].mult(1-l).add(this.points[i].mult(l))}}class Ve{constructor(e,t,i){const o=this.boxCells=[],r=this.circleCells=[];this.xCellCount=Math.ceil(e/i),this.yCellCount=Math.ceil(t/i);for(let e=0;e<this.xCellCount*this.yCellCount;e++)o.push([]),r.push([]);this.circleKeys=[],this.boxKeys=[],this.bboxes=[],this.circles=[],this.width=e,this.height=t,this.xScale=this.xCellCount/e,this.yScale=this.yCellCount/t,this.boxUid=0,this.circleUid=0;}keysLength(){return this.boxKeys.length+this.circleKeys.length}insert(e,t,i,o,r){this._forEachCell(t,i,o,r,this._insertBoxCell,this.boxUid++),this.boxKeys.push(e),this.bboxes.push(t),this.bboxes.push(i),this.bboxes.push(o),this.bboxes.push(r);}insertCircle(e,t,i,o){this._forEachCell(t-o,i-o,t+o,i+o,this._insertCircleCell,this.circleUid++),this.circleKeys.push(e),this.circles.push(t),this.circles.push(i),this.circles.push(o);}_insertBoxCell(e,t,i,o,r,n){this.boxCells[r].push(n);}_insertCircleCell(e,t,i,o,r,n){this.circleCells[r].push(n);}_query(e,t,i,o,r,n){if(i<0||e>this.width||o<0||t>this.height)return !r&&[];const a=[];if(e<=0&&t<=0&&this.width<=i&&this.height<=o){if(r)return !0;for(let e=0;e<this.boxKeys.length;e++)a.push({key:this.boxKeys[e],x1:this.bboxes[4*e],y1:this.bboxes[4*e+1],x2:this.bboxes[4*e+2],y2:this.bboxes[4*e+3]});for(let e=0;e<this.circleKeys.length;e++){const t=this.circles[3*e],i=this.circles[3*e+1],o=this.circles[3*e+2];a.push({key:this.circleKeys[e],x1:t-o,y1:i-o,x2:t+o,y2:i+o});}return n?a.filter(n):a}return this._forEachCell(e,t,i,o,this._queryCell,a,{hitTest:r,seenUids:{box:{},circle:{}}},n),r?a.length>0:a}_queryCircle(e,t,i,o,r){const n=e-i,a=e+i,s=t-i,l=t+i;if(a<0||n>this.width||l<0||s>this.height)return !o&&[];const c=[];return this._forEachCell(n,s,a,l,this._queryCellCircle,c,{hitTest:o,circle:{x:e,y:t,radius:i},seenUids:{box:{},circle:{}}},r),o?c.length>0:c}query(e,t,i,o,r){return this._query(e,t,i,o,!1,r)}hitTest(e,t,i,o,r){return this._query(e,t,i,o,!0,r)}hitTestCircle(e,t,i,o){return this._queryCircle(e,t,i,!0,o)}_queryCell(e,t,i,o,r,n,a,s){const l=a.seenUids,c=this.boxCells[r];if(null!==c){const r=this.bboxes;for(const h of c)if(!l.box[h]){l.box[h]=!0;const c=4*h;if(e<=r[c+2]&&t<=r[c+3]&&i>=r[c+0]&&o>=r[c+1]&&(!s||s(this.boxKeys[h]))){if(a.hitTest)return n.push(!0),!0;n.push({key:this.boxKeys[h],x1:r[c],y1:r[c+1],x2:r[c+2],y2:r[c+3]});}}}const h=this.circleCells[r];if(null!==h){const r=this.circles;for(const c of h)if(!l.circle[c]){l.circle[c]=!0;const h=3*c;if(this._circleAndRectCollide(r[h],r[h+1],r[h+2],e,t,i,o)&&(!s||s(this.circleKeys[c]))){if(a.hitTest)return n.push(!0),!0;{const e=r[h],t=r[h+1],i=r[h+2];n.push({key:this.circleKeys[c],x1:e-i,y1:t-i,x2:e+i,y2:t+i});}}}}}_queryCellCircle(e,t,i,o,r,n,a,s){const l=a.circle,c=a.seenUids,h=this.boxCells[r];if(null!==h){const e=this.bboxes;for(const t of h)if(!c.box[t]){c.box[t]=!0;const i=4*t;if(this._circleAndRectCollide(l.x,l.y,l.radius,e[i+0],e[i+1],e[i+2],e[i+3])&&(!s||s(this.boxKeys[t])))return n.push(!0),!0}}const u=this.circleCells[r];if(null!==u){const e=this.circles;for(const t of u)if(!c.circle[t]){c.circle[t]=!0;const i=3*t;if(this._circlesCollide(e[i],e[i+1],e[i+2],l.x,l.y,l.radius)&&(!s||s(this.circleKeys[t])))return n.push(!0),!0}}}_forEachCell(e,t,i,o,r,n,a,s){const l=this._convertToXCellCoord(e),c=this._convertToYCellCoord(t),h=this._convertToXCellCoord(i),u=this._convertToYCellCoord(o);for(let _=l;_<=h;_++)for(let l=c;l<=u;l++)if(r.call(this,e,t,i,o,this.xCellCount*l+_,n,a,s))return}_convertToXCellCoord(e){return Math.max(0,Math.min(this.xCellCount-1,Math.floor(e*this.xScale)))}_convertToYCellCoord(e){return Math.max(0,Math.min(this.yCellCount-1,Math.floor(e*this.yScale)))}_circlesCollide(e,t,i,o,r,n){const a=o-e,s=r-t,l=i+n;return l*l>a*a+s*s}_circleAndRectCollide(e,t,i,o,r,n,a){const s=(n-o)/2,l=Math.abs(e-(o+s));if(l>s+i)return !1;const c=(a-r)/2,h=Math.abs(t-(r+c));if(h>c+i)return !1;if(l<=s||h<=c)return !0;const u=l-s,_=h-c;return u*u+_*_<=i*i}}const We=Math.tan(85*Math.PI/180);function qe(t,i,o,n,a,s){let l=e.create();if(o){if("globe"===a.projection.name)l=e.calculateGlobeMatrix(a,a.worldSize/a._projectionScaler,[0,0]),e.multiply$1(l,l,e.globeDenormalizeECEF(e.globeTileBounds(i)));else {const e=r([],s);l[0]=e[0],l[1]=e[1],l[4]=e[2],l[5]=e[3];}n||e.rotateZ(l,l,a.angle);}else e.multiply$1(l,a.labelPlaneMatrix,t);return l}function Xe(t,i,o,r,n,a){if(o){if("globe"===n.projection.name){const s=qe(t,i,o,r,n,a);return e.invert(s,s),e.multiply$1(s,t,s),s}{const i=e.clone(t),o=e.identity([]);return o[0]=a[0],o[1]=a[1],o[4]=a[2],o[5]=a[3],e.multiply$1(i,i,o),r||e.rotateZ(i,i,-n.angle),i}}return n.glCoordMatrix}function $e(t,i,o=0){const r=[t.x,t.y,o,1];o?e.transformMat4$1(r,r,i):at(r,r,i);const n=r[3];return {point:new e.pointGeometry(r[0]/n,r[1]/n),signedDistanceFromCamera:n}}function He(e,t){return Math.min(.5+e/t*.5,1.5)}function Ke(e,t){const i=e[0]/e[3],o=e[1]/e[3];return i>=-t[0]&&i<=t[0]&&o>=-t[1]&&o<=t[1]}function Ye(t,i,o,r,n,a,s,l,c,h){const u=o.transform,_=r?t.textSizeData:t.iconSizeData,d=e.evaluateSizeForZoom(_,o.transform.zoom),p=[256/o.width*2+1,256/o.height*2+1],m=r?t.text.dynamicLayoutVertexArray:t.icon.dynamicLayoutVertexArray;m.clear();const f=t.lineVertexArray,g=r?t.text.placedSymbolArray:t.icon.placedSymbolArray,v=o.transform.width/o.transform.height;let x=!1;for(let r=0;r<g.length;r++){const y=g.get(r);if(y.writingMode!==e.WritingMode.vertical||x||0!==r&&g.get(r-1).writingMode===e.WritingMode.horizontal||(x=!0),y.hidden||y.writingMode===e.WritingMode.vertical&&!x){nt(y.numGlyphs,m);continue}x=!1;const b=new e.pointGeometry(y.tileAnchorX,y.tileAnchorY),w=c?c(b):[0,0,0],T=u.projection.projectTilePoint(b.x,b.y,h.canonical),E=[T.x+w[0],T.y+w[1],T.z+w[2]],C=[...E,1];if(e.transformMat4$1(C,C,i),!Ke(C,p)){nt(y.numGlyphs,m);continue}const M=He(o.transform.cameraToCenterDistance,C[3]),S=e.evaluateSizeForFeature(_,d,y),I=s?S/M:S*M,z=$e(new e.pointGeometry(E[0],E[1]),n,E[2]);if(z.signedDistanceFromCamera<=0){nt(y.numGlyphs,m);continue}let D={};const P=s?null:c,A=et(y,I,!1,l,i,n,a,t.glyphOffsetArray,f,m,z.point,b,D,v,P,u.projection,h);x=A.useVertical,P&&A.needsFlipping&&(D={}),(A.notEnoughRoom||x||A.needsFlipping&&et(y,I,!0,l,i,n,a,t.glyphOffsetArray,f,m,z.point,b,D,v,P,u.projection,h).notEnoughRoom)&&nt(y.numGlyphs,m);}r?t.text.dynamicLayoutVertexBuffer.updateData(m):t.icon.dynamicLayoutVertexBuffer.updateData(m);}function Je(e,t,i,o,r,n,a,s,l,c,h,u,_,d,p){const m=s.glyphStartIndex+s.numGlyphs,f=s.lineStartIndex,g=s.lineStartIndex+s.lineLength,v=t.getoffsetX(s.glyphStartIndex),x=t.getoffsetX(m-1),y=ot(e*v,i,o,r,n,a,s.segment,f,g,l,c,h,u,_,!0,d,p);if(!y)return null;const b=ot(e*x,i,o,r,n,a,s.segment,f,g,l,c,h,u,_,!0,d,p);return b?{first:y,last:b}:null}function Qe(t,i,o,r){return t.writingMode===e.WritingMode.horizontal&&Math.abs(o.y-i.y)>Math.abs(o.x-i.x)*r?{useVertical:!0}:t.writingMode===e.WritingMode.vertical?i.y<o.y?{needsFlipping:!0}:null:0!==t.flipState&&function(e,t,i){const o=(t.x-e.x)*i;return 0===o||Math.abs((t.y-e.y)/o)>We}(i,o,r)?1===t.flipState?{needsFlipping:!0}:null:i.x>o.x?{needsFlipping:!0}:null}function et(t,i,o,r,n,a,s,l,c,h,u,_,d,p,m,f,g){const v=i/24,x=t.lineOffsetX*v,y=t.lineOffsetY*v;let b;if(t.numGlyphs>1){const e=t.glyphStartIndex+t.numGlyphs,i=t.lineStartIndex,n=t.lineStartIndex+t.lineLength,h=Je(v,l,x,y,o,u,_,t,c,a,d,m,!1,f,g);if(!h)return {notEnoughRoom:!0};const w=$e(h.first.point,s).point,T=$e(h.last.point,s).point;if(r&&!o){const e=Qe(t,w,T,p);if(t.flipState=e&&e.needsFlipping?1:2,e)return e}b=[h.first];for(let r=t.glyphStartIndex+1;r<e-1;r++)b.push(ot(v*l.getoffsetX(r),x,y,o,u,_,t.segment,i,n,c,a,d,m,!1,!1,f,g));b.push(h.last);}else {if(r&&!o){const i=$e(_,n).point,o=t.lineStartIndex+t.segment+1,r=new e.pointGeometry(c.getx(o),c.gety(o)),a=$e(r,n),s=Qe(t,i,a.signedDistanceFromCamera>0?a.point:it(_,r,i,1,n,void 0,f,g.canonical),p);if(t.flipState=s&&s.needsFlipping?1:2,s)return s}const i=ot(v*l.getoffsetX(t.glyphStartIndex),x,y,o,u,_,t.segment,t.lineStartIndex,t.lineStartIndex+t.lineLength,c,a,d,m,!1,!1,f,g);if(!i)return {notEnoughRoom:!0};b=[i];}for(const t of b)e.addDynamicAttributes(h,t.point,t.angle);return {}}function tt(t,i,o,r,n){const a=r.projectTilePoint(t.x,t.y,i);if(!n)return $e(a,o,a.z);const s=n(t);return $e(new e.pointGeometry(a.x+s[0],a.y+s[1]),o,a.z+s[2])}function it(e,t,i,o,r,n,a,s){const l=tt(e.add(e.sub(t)._unit()),s,r,a,n).point,c=i.sub(l);return i.add(c._mult(o/c.mag()))}function ot(t,i,o,r,n,a,s,l,c,h,u,_,d,p,m,f,g){const v=r?t-i:t+i;let x=v>0?1:-1,y=0;r&&(x*=-1,y=Math.PI),x<0&&(y+=Math.PI);let b=x>0?l+s:l+s+1,w=n,T=n,E=0,C=0;const M=Math.abs(v),S=[],I=[];let z=a;const D=()=>{const t=b-x;return 0===E?a:new e.pointGeometry(h.getx(t),h.gety(t))},P=()=>it(D(),z,T,M-E+1,u,d,f,g.canonical);for(;E+C<=M;){if(b+=x,b<l||b>=c)return null;if(T=w,S.push(w),p&&I.push(z||D()),w=_[b],void 0===w){z=new e.pointGeometry(h.getx(b),h.gety(b));const t=tt(z,g.canonical,u,f,d);w=t.signedDistanceFromCamera>0?_[b]=t.point:P();}else z=null;E+=C,C=T.dist(w);}m&&d&&(z=z||new e.pointGeometry(h.getx(b),h.gety(b)),_[b]=w=void 0===_[b]?w:P(),C=T.dist(w));const A=(M-E)/C,L=w.sub(T),R=L.mult(A)._add(T);o&&R._add(L._unit()._perp()._mult(o*x));const k=y+Math.atan2(w.y-T.y,w.x-T.x);return S.push(R),p&&(z=z||new e.pointGeometry(h.getx(b),h.gety(b)),I.push(function(t,i,o){const r=1-o;return new e.pointGeometry(t.x*r+i.x*o,t.y*r+i.y*o)}(I.length>0?I[I.length-1]:z,z,A))),{point:R,angle:k,path:S,tilePath:I}}const rt=new Float32Array([-1/0,-1/0,0,-1/0,-1/0,0,-1/0,-1/0,0,-1/0,-1/0,0]);function nt(e,t){for(let i=0;i<e;i++){const e=t.length;t.resize(e+4),t.float32.set(rt,3*e);}}function at(e,t,i){const o=t[0],r=t[1];return e[0]=i[0]*o+i[4]*r+i[12],e[1]=i[1]*o+i[5]*r+i[13],e[3]=i[3]*o+i[7]*r+i[15],e}const st=100;class lt{constructor(e,t,i=new Ve(e.width+200,e.height+200,25),o=new Ve(e.width+200,e.height+200,25)){this.transform=e,this.grid=i,this.ignoredGrid=o,this.pitchfactor=Math.cos(e._pitch)*e.cameraToCenterDistance,this.screenRightBoundary=e.width+st,this.screenBottomBoundary=e.height+st,this.gridRightBoundary=e.width+200,this.gridBottomBoundary=e.height+200,this.fogState=t;}placeCollisionBox(e,t,i,o,r,n,a){let s=t.projectedAnchorX,l=t.projectedAnchorY,c=t.projectedAnchorZ;const h=t.elevation,u=t.tileID;if(h&&u){const e=this.transform.projection.createTileTransform(this.transform,this.transform.worldSize),i=e.upVector(u.canonical,t.tileAnchorX,t.tileAnchorY),o=e.upVectorScale(u.canonical);s+=i[0]*h*o,l+=i[1]*h*o,c+=i[2]*h*o;}const _=this.projectAndGetPerspectiveRatio(n,s,l,c,t.tileID),d=r*_.perspectiveRatio,p=(t.x1*e+i.x-t.padding)*d+_.point.x,m=(t.y1*e+i.y-t.padding)*d+_.point.y,f=(t.x2*e+i.x+t.padding)*d+_.point.x,g=(t.y2*e+i.y+t.padding)*d+_.point.y,v=_.perspectiveRatio<=.55||_.aboveHorizon;return !this.isInsideGrid(p,m,f,g)||!o&&this.grid.hitTest(p,m,f,g,a)||v?{box:[],offscreen:!1}:{box:[p,m,f,g],offscreen:this.isOffscreen(p,m,f,g)}}placeCollisionCircles(t,i,o,r,n,a,s,l,c,h,u,_,d,p){const m=[],f=this.transform.elevation,g=this.transform.projection.createTileTransform(this.transform,this.transform.worldSize),v=f?f.getAtTileOffsetFunc(p,g):e=>[0,0,0],x=new e.pointGeometry(i.tileAnchorX,i.tileAnchorY),y=this.transform.projection.projectTilePoint(i.tileAnchorX,i.tileAnchorY,p.canonical),b=v(x),w=[y.x+b[0],y.y+b[1],y.z+b[2]],T=this.projectAndGetPerspectiveRatio(a,w[0],w[1],w[2],p),{perspectiveRatio:E}=T,C=(h?n/E:n*E)/e.ONE_EM,M=$e(new e.pointGeometry(w[0],w[1]),s,w[2]).point,S=T.signedDistanceFromCamera>0?Je(C,r,i.lineOffsetX*C,i.lineOffsetY*C,!1,M,x,i,o,s,{},f&&!h?v:null,h&&!!f,this.transform.projection,p):null;let I=!1,z=!1,D=!0;if(S&&!T.aboveHorizon){const i=.5*_*E+d,o=new e.pointGeometry(-100,-100),r=new e.pointGeometry(this.screenRightBoundary,this.screenBottomBoundary),n=new Ze,a=S.first,s=S.last;let h=[];for(let e=a.path.length-1;e>=1;e--)h.push(a.path[e]);for(let e=1;e<s.path.length;e++)h.push(s.path[e]);const p=2.5*i;if(l){const e=h.map(f?(e,t)=>{const i=v(t<a.path.length-1?a.tilePath[a.path.length-1-t]:s.tilePath[t-a.path.length+2]);return $e(e,l,i[2])}:e=>$e(e,l));h=e.some((e=>e.signedDistanceFromCamera<=0))?[]:e.map((e=>e.point));}let g=[];if(h.length>0){const t=h[0].clone(),i=h[0].clone();for(let e=1;e<h.length;e++)t.x=Math.min(t.x,h[e].x),t.y=Math.min(t.y,h[e].y),i.x=Math.max(i.x,h[e].x),i.y=Math.max(i.y,h[e].y);g=t.x>=o.x&&i.x<=r.x&&t.y>=o.y&&i.y<=r.y?[h]:i.x<o.x||t.x>r.x||i.y<o.y||t.y>r.y?[]:e.clipLine([h],o.x,o.y,r.x,r.y);}for(const e of g){n.reset(e,.25*i);let o=0;o=n.length<=.5*i?1:Math.ceil(n.paddedLength/p)+1;for(let e=0;e<o;e++){const r=e/Math.max(o-1,1),a=n.lerp(r),s=a.x+st,l=a.y+st;m.push(s,l,i,0);const h=s-i,_=l-i,d=s+i,p=l+i;if(D=D&&this.isOffscreen(h,_,d,p),z=z||this.isInsideGrid(h,_,d,p),!t&&this.grid.hitTestCircle(s,l,i,u)&&(I=!0,!c))return {circles:[],offscreen:!1,collisionDetected:I}}}}return {circles:!c&&I||!z?[]:m,offscreen:D,collisionDetected:I}}queryRenderedSymbols(t){if(0===t.length||0===this.grid.keysLength()&&0===this.ignoredGrid.keysLength())return {};const i=[];let o=1/0,r=1/0,n=-1/0,a=-1/0;for(const s of t){const t=new e.pointGeometry(s.x+st,s.y+st);o=Math.min(o,t.x),r=Math.min(r,t.y),n=Math.max(n,t.x),a=Math.max(a,t.y),i.push(t);}const s=this.grid.query(o,r,n,a).concat(this.ignoredGrid.query(o,r,n,a)),l={},c={};for(const t of s){const o=t.key;if(void 0===l[o.bucketInstanceId]&&(l[o.bucketInstanceId]={}),l[o.bucketInstanceId][o.featureIndex])continue;const r=[new e.pointGeometry(t.x1,t.y1),new e.pointGeometry(t.x2,t.y1),new e.pointGeometry(t.x2,t.y2),new e.pointGeometry(t.x1,t.y2)];e.polygonIntersectsPolygon(i,r)&&(l[o.bucketInstanceId][o.featureIndex]=!0,void 0===c[o.bucketInstanceId]&&(c[o.bucketInstanceId]=[]),c[o.bucketInstanceId].push(o.featureIndex));}return c}insertCollisionBox(e,t,i,o,r){(t?this.ignoredGrid:this.grid).insert({bucketInstanceId:i,featureIndex:o,collisionGroupID:r},e[0],e[1],e[2],e[3]);}insertCollisionCircles(e,t,i,o,r){const n=t?this.ignoredGrid:this.grid,a={bucketInstanceId:i,featureIndex:o,collisionGroupID:r};for(let t=0;t<e.length;t+=4)n.insertCircle(a,e[t],e[t+1],e[t+2]);}projectAndGetPerspectiveRatio(t,i,o,r,n){const a=[i,o,r||0,1];let s=!1;if(r||this.transform.pitch>0){e.transformMat4$1(a,a,t);let l=!1;this.fogState&&n&&(l=function(t,i,o,r,n,a){const s=a.calculateFogTileMatrix(n),l=[i,o,r];return e.transformMat4(l,l,s),y(t,l,a.pitch,a._fov)}(this.fogState,i,o,r||0,n.toUnwrapped(),this.transform)>.9),s=a[2]>a[3]||l;}else at(a,a,t);return {point:new e.pointGeometry((a[0]/a[3]+1)/2*this.transform.width+st,(-a[1]/a[3]+1)/2*this.transform.height+st),perspectiveRatio:Math.min(.5+this.transform.cameraToCenterDistance/a[3]*.5,1.5),signedDistanceFromCamera:a[3],aboveHorizon:s}}isOffscreen(e,t,i,o){return i<st||e>=this.screenRightBoundary||o<st||t>this.screenBottomBoundary}isInsideGrid(e,t,i,o){return i>=0&&e<this.gridRightBoundary&&o>=0&&t<this.gridBottomBoundary}getViewportMatrix(){const t=e.identity([]);return e.translate(t,t,[-100,-100,0]),t}}class ct{constructor(e,t,i,o){this.opacity=e?Math.max(0,Math.min(1,e.opacity+(e.placed?t:-t))):o&&i?1:0,this.placed=i;}isHidden(){return 0===this.opacity&&!this.placed}}class ht{constructor(e,t,i,o,r,n=!1){this.text=new ct(e?e.text:null,t,i,r),this.icon=new ct(e?e.icon:null,t,o,r),this.clipped=n;}isHidden(){return this.text.isHidden()&&this.icon.isHidden()}}class ut{constructor(e,t,i,o=!1){this.text=e,this.icon=t,this.skipFade=i,this.clipped=o;}}class _t{constructor(){this.invProjMatrix=e.create(),this.viewportMatrix=e.create(),this.circles=[];}}class dt{constructor(e,t,i,o,r){this.bucketInstanceId=e,this.featureIndex=t,this.sourceLayerIndex=i,this.bucketIndex=o,this.tileID=r;}}class pt{constructor(e){this.crossSourceCollisions=e,this.maxGroupID=0,this.collisionGroups={};}get(e){if(this.crossSourceCollisions)return {ID:0,predicate:null};if(!this.collisionGroups[e]){const t=++this.maxGroupID;this.collisionGroups[e]={ID:t,predicate:e=>e.collisionGroupID===t};}return this.collisionGroups[e]}}function mt(t,i,o,r,n){const{horizontalAlign:a,verticalAlign:s}=e.getAnchorAlignment(t),l=-(a-.5)*i,c=-(s-.5)*o,h=e.evaluateVariableOffset(t,r);return new e.pointGeometry(l+h[0]*n,c+h[1]*n)}function ft(t,i,o,r,n){const a=new e.pointGeometry(t,i);return o&&a._rotate(r?n:-n),a}class gt{constructor(e,t,i,o,r){this.transform=e.clone(),this.collisionIndex=new lt(this.transform,r),this.placements={},this.opacities={},this.variableOffsets={},this.stale=!1,this.commitTime=0,this.fadeDuration=t,this.retainedQueryData={},this.collisionGroups=new pt(i),this.collisionCircleArrays={},this.prevPlacement=o,o&&(o.prevPlacement=void 0),this.placedOrientations={};}getBucketParts(t,i,o,r){const n=o.getBucket(i),a=o.latestFeatureIndex;if(!n||!a||i.id!==n.layerIds[0])return;const s=n.layers[0].layout,l=o.collisionBoxArray,c=Math.pow(2,this.transform.zoom-o.tileID.overscaledZ),h=o.tileSize/e.EXTENT,u=o.tileID.toUnwrapped(),_=this.transform.calculateProjMatrix(u),d="map"===s.get("text-pitch-alignment"),p="map"===s.get("text-rotation-alignment");i.compileFilter();const m=i.dynamicFilter(),f=i.dynamicFilterNeedsFeature(),g=this.transform.calculatePixelsToTileUnitsMatrix(o),v=qe(_,o.tileID.canonical,d,p,this.transform,g);let x=null;if(d){const t=Xe(_,o.tileID.canonical,d,p,this.transform,g);x=e.multiply$1([],this.transform.labelPlaneMatrix,t);}let y=null;m&&o.latestFeatureIndex&&(y={unwrappedTileID:u,dynamicFilter:m,dynamicFilterNeedsFeature:f,featureIndex:o.latestFeatureIndex}),this.retainedQueryData[n.bucketInstanceId]=new dt(n.bucketInstanceId,a,n.sourceLayerIndex,n.index,o.tileID);const b={bucket:n,layout:s,posMatrix:_,textLabelPlaneMatrix:v,labelToScreenMatrix:x,clippingData:y,scale:c,textPixelRatio:h,holdingForFade:o.holdingForFade(),collisionBoxArray:l,partiallyEvaluatedTextSize:e.evaluateSizeForZoom(n.textSizeData,this.transform.zoom),partiallyEvaluatedIconSize:e.evaluateSizeForZoom(n.iconSizeData,this.transform.zoom),collisionGroup:this.collisionGroups.get(n.sourceID)};if(r)for(const e of n.sortKeyRanges){const{sortKey:i,symbolInstanceStart:o,symbolInstanceEnd:r}=e;t.push({sortKey:i,symbolInstanceStart:o,symbolInstanceEnd:r,parameters:b});}else t.push({symbolInstanceStart:0,symbolInstanceEnd:n.symbolInstances.length,parameters:b});}attemptAnchorPlacement(e,t,i,o,r,n,a,s,l,c,h,u,_,d,p,m,f,g){const v=[u.textOffset0,u.textOffset1],x=mt(e,i,o,v,r),y=this.collisionIndex.placeCollisionBox(r,t,ft(x.x,x.y,n,a,this.transform.angle),h,s,l,c.predicate);if((!m||0!==this.collisionIndex.placeCollisionBox(d.getSymbolInstanceIconSize(g,this.transform.zoom,_),m,ft(x.x,x.y,n,a,this.transform.angle),h,s,l,c.predicate).box.length)&&y.box.length>0){let t;return this.prevPlacement&&this.prevPlacement.variableOffsets[u.crossTileID]&&this.prevPlacement.placements[u.crossTileID]&&this.prevPlacement.placements[u.crossTileID].text&&(t=this.prevPlacement.variableOffsets[u.crossTileID].anchor),this.variableOffsets[u.crossTileID]={textOffset:v,width:i,height:o,anchor:e,textScale:r,prevAnchor:t},this.markUsedJustification(d,e,u,p),d.allowVerticalPlacement&&(this.markUsedOrientation(d,p,u),this.placedOrientations[u.crossTileID]=p),{shift:x,placedGlyphBoxes:y}}}placeLayerBucketPart(t,i,o,r){const{bucket:n,layout:a,posMatrix:s,textLabelPlaneMatrix:l,labelToScreenMatrix:c,clippingData:h,textPixelRatio:u,holdingForFade:_,collisionBoxArray:d,partiallyEvaluatedTextSize:p,partiallyEvaluatedIconSize:m,collisionGroup:f}=t.parameters,g=a.get("text-optional"),v=a.get("icon-optional"),x=a.get("text-allow-overlap"),y=a.get("icon-allow-overlap"),b="map"===a.get("text-rotation-alignment"),w="map"===a.get("text-pitch-alignment"),T="none"!==a.get("icon-text-fit"),E="viewport-y"===a.get("symbol-z-order"),C=x&&(y||!n.hasIconData()||v),M=y&&(x||!n.hasTextData()||g);!n.collisionArrays&&d&&n.deserializeCollisionBoxes(d),o&&r&&n.updateCollisionDebugBuffers(this.transform.zoom,d);const S=(t,r,d)=>{if(h){const o={zoom:this.transform.zoom,pitch:this.transform.pitch};let r=null;if(h.dynamicFilterNeedsFeature){const e=this.retainedQueryData[n.bucketInstanceId];r=h.featureIndex.loadFeature({featureIndex:t.featureIndex,bucketIndex:e.bucketIndex,sourceLayerIndex:e.sourceLayerIndex,layoutVertexArrayOffset:0});}if(!(0,h.dynamicFilter)(o,r,this.retainedQueryData[n.bucketInstanceId].tileID.canonical,new e.pointGeometry(t.tileAnchorX,t.tileAnchorY),this.transform.calculateDistanceTileData(h.unwrappedTileID)))return this.placements[t.crossTileID]=new ut(!1,!1,!1,!0),void(i[t.crossTileID]=!0)}if(i[t.crossTileID])return;if(_)return void(this.placements[t.crossTileID]=new ut(!1,!1,!1));let E=!1,S=!1,I=!0,z=null,D={box:null,offscreen:null},P={box:null,offscreen:null},A=null,L=null,R=null,k=0,O=0,B=0;d.textFeatureIndex?k=d.textFeatureIndex:t.useRuntimeCollisionCircles&&(k=t.featureIndex),d.verticalTextFeatureIndex&&(O=d.verticalTextFeatureIndex);const F=e=>{e.tileID=this.retainedQueryData[n.bucketInstanceId].tileID,(this.transform.elevation||e.elevation)&&(e.elevation=this.transform.elevation?this.transform.elevation.getAtTileOffset(this.retainedQueryData[n.bucketInstanceId].tileID,e.tileAnchorX,e.tileAnchorY):0);},U=d.textBox;if(U){F(U);const i=i=>{let o=e.WritingMode.horizontal;if(n.allowVerticalPlacement&&!i&&this.prevPlacement){const e=this.prevPlacement.placedOrientations[t.crossTileID];e&&(this.placedOrientations[t.crossTileID]=e,o=e,this.markUsedOrientation(n,o,t));}return o},o=(i,o)=>{if(n.allowVerticalPlacement&&t.numVerticalGlyphVertices>0&&d.verticalTextBox){for(const t of n.writingModes)if(t===e.WritingMode.vertical?(D=o(),P=D):D=i(),D&&D.box&&D.box.length)break}else D=i();};if(a.get("text-variable-anchor")){let l=a.get("text-variable-anchor");if(this.prevPlacement&&this.prevPlacement.variableOffsets[t.crossTileID]){const e=this.prevPlacement.variableOffsets[t.crossTileID];l.indexOf(e.anchor)>0&&(l=l.filter((t=>t!==e.anchor)),l.unshift(e.anchor));}const c=(e,i,o)=>{const a=n.getSymbolInstanceTextSize(p,t,this.transform.zoom,r),c=(e.x2-e.x1)*a+2*e.padding,h=(e.y2-e.y1)*a+2*e.padding,_=T&&!y?i:null;_&&F(_);let d={box:[],offscreen:!1};const g=x?2*l.length:l.length;for(let i=0;i<g;++i){const g=this.attemptAnchorPlacement(l[i%l.length],e,c,h,a,b,w,u,s,f,i>=l.length,t,r,n,o,_,p,m);if(g&&(d=g.placedGlyphBoxes,d&&d.box&&d.box.length)){E=!0,z=g.shift;break}}return d};o((()=>c(U,d.iconBox,e.WritingMode.horizontal)),(()=>{const i=d.verticalTextBox;return i&&F(i),n.allowVerticalPlacement&&!(D&&D.box&&D.box.length)&&t.numVerticalGlyphVertices>0&&i?c(i,d.verticalIconBox,e.WritingMode.vertical):{box:null,offscreen:null}})),D&&(E=D.box,I=D.offscreen);const h=i(D&&D.box);if(!E&&this.prevPlacement){const e=this.prevPlacement.variableOffsets[t.crossTileID];e&&(this.variableOffsets[t.crossTileID]=e,this.markUsedJustification(n,e.anchor,t,h));}}else {const a=(i,o)=>{const a=n.getSymbolInstanceTextSize(p,t,this.transform.zoom,r),l=this.collisionIndex.placeCollisionBox(a,i,new e.pointGeometry(0,0),x,u,s,f.predicate);return l&&l.box&&l.box.length&&(this.markUsedOrientation(n,o,t),this.placedOrientations[t.crossTileID]=o),l};o((()=>a(U,e.WritingMode.horizontal)),(()=>{const i=d.verticalTextBox;return n.allowVerticalPlacement&&t.numVerticalGlyphVertices>0&&i?(F(i),a(i,e.WritingMode.vertical)):{box:null,offscreen:null}})),i(D&&D.box&&D.box.length);}}if(A=D,E=A&&A.box&&A.box.length>0,I=A&&A.offscreen,t.useRuntimeCollisionCircles){const i=n.text.placedSymbolArray.get(t.centerJustifiedTextSymbolIndex>=0?t.centerJustifiedTextSymbolIndex:t.verticalPlacedTextSymbolIndex),r=e.evaluateSizeForFeature(n.textSizeData,p,i),h=a.get("text-padding");L=this.collisionIndex.placeCollisionCircles(x,i,n.lineVertexArray,n.glyphOffsetArray,r,s,l,c,o,w,f.predicate,t.collisionCircleDiameter*r/e.ONE_EM,h,this.retainedQueryData[n.bucketInstanceId].tileID),E=x||L.circles.length>0&&!L.collisionDetected,I=I&&L.offscreen;}if(d.iconFeatureIndex&&(B=d.iconFeatureIndex),d.iconBox){const t=t=>{F(t);const i=T&&z?ft(z.x,z.y,b,w,this.transform.angle):new e.pointGeometry(0,0),o=n.getSymbolInstanceIconSize(m,this.transform.zoom,r);return this.collisionIndex.placeCollisionBox(o,t,i,y,u,s,f.predicate)};P&&P.box&&P.box.length&&d.verticalIconBox?(R=t(d.verticalIconBox),S=R.box.length>0):(R=t(d.iconBox),S=R.box.length>0),I=I&&R.offscreen;}const N=g||0===t.numHorizontalGlyphVertices&&0===t.numVerticalGlyphVertices,G=v||0===t.numIconVertices;if(N||G?G?N||(S=S&&E):E=S&&E:S=E=S&&E,E&&A&&A.box&&this.collisionIndex.insertCollisionBox(A.box,a.get("text-ignore-placement"),n.bucketInstanceId,P&&P.box&&O?O:k,f.ID),S&&R&&this.collisionIndex.insertCollisionBox(R.box,a.get("icon-ignore-placement"),n.bucketInstanceId,B,f.ID),L&&(E&&this.collisionIndex.insertCollisionCircles(L.circles,a.get("text-ignore-placement"),n.bucketInstanceId,k,f.ID),o)){const e=n.bucketInstanceId;let t=this.collisionCircleArrays[e];void 0===t&&(t=this.collisionCircleArrays[e]=new _t);for(let e=0;e<L.circles.length;e+=4)t.circles.push(L.circles[e+0]),t.circles.push(L.circles[e+1]),t.circles.push(L.circles[e+2]),t.circles.push(L.collisionDetected?1:0);}this.placements[t.crossTileID]=new ut(E||C,S||M,I||n.justReloaded),i[t.crossTileID]=!0;};if(E){const e=n.getSortedSymbolIndexes(this.transform.angle);for(let t=e.length-1;t>=0;--t){const i=e[t];S(n.symbolInstances.get(i),i,n.collisionArrays[i]);}}else for(let e=t.symbolInstanceStart;e<t.symbolInstanceEnd;e++)S(n.symbolInstances.get(e),e,n.collisionArrays[e]);if(o&&n.bucketInstanceId in this.collisionCircleArrays){const t=this.collisionCircleArrays[n.bucketInstanceId];e.invert(t.invProjMatrix,s),t.viewportMatrix=this.collisionIndex.getViewportMatrix();}n.justReloaded=!1;}markUsedJustification(t,i,o,r){let n;n=r===e.WritingMode.vertical?o.verticalPlacedTextSymbolIndex:{left:o.leftJustifiedTextSymbolIndex,center:o.centerJustifiedTextSymbolIndex,right:o.rightJustifiedTextSymbolIndex}[e.getAnchorJustification(i)];const a=[o.leftJustifiedTextSymbolIndex,o.centerJustifiedTextSymbolIndex,o.rightJustifiedTextSymbolIndex,o.verticalPlacedTextSymbolIndex];for(const e of a)e>=0&&(t.text.placedSymbolArray.get(e).crossTileID=n>=0&&e!==n?0:o.crossTileID);}markUsedOrientation(t,i,o){const r=i===e.WritingMode.horizontal||i===e.WritingMode.horizontalOnly?i:0,n=i===e.WritingMode.vertical?i:0,a=[o.leftJustifiedTextSymbolIndex,o.centerJustifiedTextSymbolIndex,o.rightJustifiedTextSymbolIndex];for(const e of a)t.text.placedSymbolArray.get(e).placedOrientation=r;o.verticalPlacedTextSymbolIndex&&(t.text.placedSymbolArray.get(o.verticalPlacedTextSymbolIndex).placedOrientation=n);}commit(e){this.commitTime=e,this.zoomAtLastRecencyCheck=this.transform.zoom;const t=this.prevPlacement;let i=!1;this.prevZoomAdjustment=t?t.zoomAdjustment(this.transform.zoom):0;const o=t?t.symbolFadeChange(e):1,r=t?t.opacities:{},n=t?t.variableOffsets:{},a=t?t.placedOrientations:{};for(const e in this.placements){const t=this.placements[e],n=r[e];n?(this.opacities[e]=new ht(n,o,t.text,t.icon,null,t.clipped),i=i||t.text!==n.text.placed||t.icon!==n.icon.placed):(this.opacities[e]=new ht(null,o,t.text,t.icon,t.skipFade,t.clipped),i=i||t.text||t.icon);}for(const e in r){const t=r[e];if(!this.opacities[e]){const r=new ht(t,o,!1,!1);r.isHidden()||(this.opacities[e]=r,i=i||t.text.placed||t.icon.placed);}}for(const e in n)this.variableOffsets[e]||!this.opacities[e]||this.opacities[e].isHidden()||(this.variableOffsets[e]=n[e]);for(const e in a)this.placedOrientations[e]||!this.opacities[e]||this.opacities[e].isHidden()||(this.placedOrientations[e]=a[e]);i?this.lastPlacementChangeTime=e:"number"!=typeof this.lastPlacementChangeTime&&(this.lastPlacementChangeTime=t?t.lastPlacementChangeTime:e);}updateLayerOpacities(e,t){const i={};for(const o of t){const t=o.getBucket(e);t&&o.latestFeatureIndex&&e.id===t.layerIds[0]&&this.updateBucketOpacities(t,i,o.collisionBoxArray);}}updateBucketOpacities(t,i,o){t.hasTextData()&&t.text.opacityVertexArray.clear(),t.hasIconData()&&t.icon.opacityVertexArray.clear(),t.hasIconCollisionBoxData()&&t.iconCollisionBox.collisionVertexArray.clear(),t.hasTextCollisionBoxData()&&t.textCollisionBox.collisionVertexArray.clear();const r=t.layers[0].layout,n=!!t.layers[0].dynamicFilter(),a=new ht(null,0,!1,!1,!0),s=r.get("text-allow-overlap"),l=r.get("icon-allow-overlap"),c=r.get("text-variable-anchor"),h="map"===r.get("text-rotation-alignment"),u="map"===r.get("text-pitch-alignment"),_="none"!==r.get("icon-text-fit"),d=new ht(null,0,s&&(l||!t.hasIconData()||r.get("icon-optional")),l&&(s||!t.hasTextData()||r.get("text-optional")),!0);!t.collisionArrays&&o&&(t.hasIconCollisionBoxData()||t.hasTextCollisionBoxData())&&t.deserializeCollisionBoxes(o);const p=(e,t,i)=>{for(let o=0;o<t/4;o++)e.opacityVertexArray.emplaceBack(i);};let m=0;for(let o=0;o<t.symbolInstances.length;o++){const r=t.symbolInstances.get(o),{numHorizontalGlyphVertices:s,numVerticalGlyphVertices:l,crossTileID:f}=r;let g=this.opacities[f];i[f]?g=a:g||(g=d,this.opacities[f]=g),i[f]=!0;const v=s>0||l>0,x=r.numIconVertices>0,y=this.placedOrientations[r.crossTileID],b=y===e.WritingMode.vertical,w=y===e.WritingMode.horizontal||y===e.WritingMode.horizontalOnly;if(!v&&!x||g.isHidden()||m++,v){const e=Mt(g.text);p(t.text,s,b?St:e),p(t.text,l,w?St:e);const i=g.text.isHidden();[r.rightJustifiedTextSymbolIndex,r.centerJustifiedTextSymbolIndex,r.leftJustifiedTextSymbolIndex].forEach((e=>{e>=0&&(t.text.placedSymbolArray.get(e).hidden=i||b?1:0);})),r.verticalPlacedTextSymbolIndex>=0&&(t.text.placedSymbolArray.get(r.verticalPlacedTextSymbolIndex).hidden=i||w?1:0);const o=this.variableOffsets[r.crossTileID];o&&this.markUsedJustification(t,o.anchor,r,y);const n=this.placedOrientations[r.crossTileID];n&&(this.markUsedJustification(t,"left",r,n),this.markUsedOrientation(t,n,r));}if(x){const e=Mt(g.icon);r.placedIconSymbolIndex>=0&&(p(t.icon,r.numIconVertices,b?St:e),t.icon.placedSymbolArray.get(r.placedIconSymbolIndex).hidden=g.icon.isHidden()),r.verticalPlacedIconSymbolIndex>=0&&(p(t.icon,r.numVerticalIconVertices,w?St:e),t.icon.placedSymbolArray.get(r.verticalPlacedIconSymbolIndex).hidden=g.icon.isHidden());}if(t.hasIconCollisionBoxData()||t.hasTextCollisionBoxData()){const i=t.collisionArrays[o];if(i){let o=new e.pointGeometry(0,0),r=!0;if(i.textBox||i.verticalTextBox){if(c){const e=this.variableOffsets[f];e?(o=mt(e.anchor,e.width,e.height,e.textOffset,e.textScale),h&&o._rotate(u?this.transform.angle:-this.transform.angle)):r=!1;}n&&(r=!g.clipped),i.textBox&&vt(t.textCollisionBox.collisionVertexArray,g.text.placed,!r||b,o.x,o.y),i.verticalTextBox&&vt(t.textCollisionBox.collisionVertexArray,g.text.placed,!r||w,o.x,o.y);}const a=r&&Boolean(!w&&i.verticalIconBox);i.iconBox&&vt(t.iconCollisionBox.collisionVertexArray,g.icon.placed,a,_?o.x:0,_?o.y:0),i.verticalIconBox&&vt(t.iconCollisionBox.collisionVertexArray,g.icon.placed,!a,_?o.x:0,_?o.y:0);}}}if(t.fullyClipped=0===m,t.sortFeatures(this.transform.angle),this.retainedQueryData[t.bucketInstanceId]&&(this.retainedQueryData[t.bucketInstanceId].featureSortOrder=t.featureSortOrder),t.hasTextData()&&t.text.opacityVertexBuffer&&t.text.opacityVertexBuffer.updateData(t.text.opacityVertexArray),t.hasIconData()&&t.icon.opacityVertexBuffer&&t.icon.opacityVertexBuffer.updateData(t.icon.opacityVertexArray),t.hasIconCollisionBoxData()&&t.iconCollisionBox.collisionVertexBuffer&&t.iconCollisionBox.collisionVertexBuffer.updateData(t.iconCollisionBox.collisionVertexArray),t.hasTextCollisionBoxData()&&t.textCollisionBox.collisionVertexBuffer&&t.textCollisionBox.collisionVertexBuffer.updateData(t.textCollisionBox.collisionVertexArray),t.bucketInstanceId in this.collisionCircleArrays){const e=this.collisionCircleArrays[t.bucketInstanceId];t.placementInvProjMatrix=e.invProjMatrix,t.placementViewportMatrix=e.viewportMatrix,t.collisionCircleArray=e.circles,delete this.collisionCircleArrays[t.bucketInstanceId];}}symbolFadeChange(e){return 0===this.fadeDuration?1:(e-this.commitTime)/this.fadeDuration+this.prevZoomAdjustment}zoomAdjustment(e){return Math.max(0,(this.transform.zoom-e)/1.5)}hasTransitions(e){return this.stale||e-this.lastPlacementChangeTime<this.fadeDuration}stillRecent(e,t){const i=this.zoomAtLastRecencyCheck===t?1-this.zoomAdjustment(t):1;return this.zoomAtLastRecencyCheck=t,this.commitTime+this.fadeDuration*i>e}setStale(){this.stale=!0;}}function vt(e,t,i,o,r){e.emplaceBack(t?1:0,i?1:0,o||0,r||0),e.emplaceBack(t?1:0,i?1:0,o||0,r||0),e.emplaceBack(t?1:0,i?1:0,o||0,r||0),e.emplaceBack(t?1:0,i?1:0,o||0,r||0);}const xt=Math.pow(2,25),yt=Math.pow(2,24),bt=Math.pow(2,17),wt=Math.pow(2,16),Tt=Math.pow(2,9),Et=Math.pow(2,8),Ct=Math.pow(2,1);function Mt(e){if(0===e.opacity&&!e.placed)return 0;if(1===e.opacity&&e.placed)return 4294967295;const t=e.placed?1:0,i=Math.floor(127*e.opacity);return i*xt+t*yt+i*bt+t*wt+i*Tt+t*Et+i*Ct+t}const St=0;class It{constructor(e){this._sortAcrossTiles="viewport-y"!==e.layout.get("symbol-z-order")&&void 0!==e.layout.get("symbol-sort-key").constantOr(1),this._currentTileIndex=0,this._currentPartIndex=0,this._seenCrossTileIDs={},this._bucketParts=[];}continuePlacement(e,t,i,o,r){const n=this._bucketParts;for(;this._currentTileIndex<e.length;)if(t.getBucketParts(n,o,e[this._currentTileIndex],this._sortAcrossTiles),this._currentTileIndex++,r())return !0;for(this._sortAcrossTiles&&(this._sortAcrossTiles=!1,n.sort(((e,t)=>e.sortKey-t.sortKey)));this._currentPartIndex<n.length;){const e=n[this._currentPartIndex];if(t.placeLayerBucketPart(e,this._seenCrossTileIDs,i,0===e.symbolInstanceStart),this._currentPartIndex++,r())return !0}return !1}}class zt{constructor(e,t,i,o,r,n,a,s){this.placement=new gt(e,r,n,a,s),this._currentPlacementIndex=t.length-1,this._forceFullPlacement=i,this._showCollisionBoxes=o,this._done=!1;}isDone(){return this._done}continuePlacement(t,i,o){const r=e.exported.now(),n=()=>{const t=e.exported.now()-r;return !this._forceFullPlacement&&t>2};for(;this._currentPlacementIndex>=0;){const e=i[t[this._currentPlacementIndex]],r=this.placement.collisionIndex.transform.zoom;if("symbol"===e.type&&(!e.minzoom||e.minzoom<=r)&&(!e.maxzoom||e.maxzoom>r)){if(this._inProgressLayer||(this._inProgressLayer=new It(e)),this._inProgressLayer.continuePlacement(o[e.source],this.placement,this._showCollisionBoxes,e,n))return;delete this._inProgressLayer;}this._currentPlacementIndex--;}this._done=!0;}commit(e){return this.placement.commit(e),this.placement}}const Dt=512/e.EXTENT/2;class Pt{constructor(e,t,i){this.tileID=e,this.indexedSymbolInstances={},this.bucketInstanceId=i;for(let i=0;i<t.length;i++){const o=t.get(i),r=o.key;this.indexedSymbolInstances[r]||(this.indexedSymbolInstances[r]=[]),this.indexedSymbolInstances[r].push({crossTileID:o.crossTileID,coord:this.getScaledCoordinates(o,e)});}}getScaledCoordinates(t,i){const o=Dt/Math.pow(2,i.canonical.z-this.tileID.canonical.z);return {x:Math.floor((i.canonical.x*e.EXTENT+t.tileAnchorX)*o),y:Math.floor((i.canonical.y*e.EXTENT+t.tileAnchorY)*o)}}findMatches(e,t,i){const o=this.tileID.canonical.z<t.canonical.z?1:Math.pow(2,this.tileID.canonical.z-t.canonical.z);for(let r=0;r<e.length;r++){const n=e.get(r);if(n.crossTileID)continue;const a=this.indexedSymbolInstances[n.key];if(!a)continue;const s=this.getScaledCoordinates(n,t);for(const e of a)if(Math.abs(e.coord.x-s.x)<=o&&Math.abs(e.coord.y-s.y)<=o&&!i[e.crossTileID]){i[e.crossTileID]=!0,n.crossTileID=e.crossTileID;break}}}}class At{constructor(){this.maxCrossTileID=0;}generate(){return ++this.maxCrossTileID}}class Lt{constructor(){this.indexes={},this.usedCrossTileIDs={},this.lng=0;}handleWrapJump(e){const t=Math.round((e-this.lng)/360);if(0!==t)for(const e in this.indexes){const i=this.indexes[e],o={};for(const e in i){const r=i[e];r.tileID=r.tileID.unwrapTo(r.tileID.wrap+t),o[r.tileID.key]=r;}this.indexes[e]=o;}this.lng=e;}addBucket(e,t,i){if(this.indexes[e.overscaledZ]&&this.indexes[e.overscaledZ][e.key]){if(this.indexes[e.overscaledZ][e.key].bucketInstanceId===t.bucketInstanceId)return !1;this.removeBucketCrossTileIDs(e.overscaledZ,this.indexes[e.overscaledZ][e.key]);}for(let e=0;e<t.symbolInstances.length;e++)t.symbolInstances.get(e).crossTileID=0;this.usedCrossTileIDs[e.overscaledZ]||(this.usedCrossTileIDs[e.overscaledZ]={});const o=this.usedCrossTileIDs[e.overscaledZ];for(const i in this.indexes){const r=this.indexes[i];if(Number(i)>e.overscaledZ)for(const i in r){const n=r[i];n.tileID.isChildOf(e)&&n.findMatches(t.symbolInstances,e,o);}else {const n=r[e.scaledTo(Number(i)).key];n&&n.findMatches(t.symbolInstances,e,o);}}for(let e=0;e<t.symbolInstances.length;e++){const r=t.symbolInstances.get(e);r.crossTileID||(r.crossTileID=i.generate(),o[r.crossTileID]=!0);}return void 0===this.indexes[e.overscaledZ]&&(this.indexes[e.overscaledZ]={}),this.indexes[e.overscaledZ][e.key]=new Pt(e,t.symbolInstances,t.bucketInstanceId),!0}removeBucketCrossTileIDs(e,t){for(const i in t.indexedSymbolInstances)for(const o of t.indexedSymbolInstances[i])delete this.usedCrossTileIDs[e][o.crossTileID];}removeStaleBuckets(e){let t=!1;for(const i in this.indexes){const o=this.indexes[i];for(const r in o)e[o[r].bucketInstanceId]||(this.removeBucketCrossTileIDs(i,o[r]),delete o[r],t=!0);}return t}}class Rt{constructor(){this.layerIndexes={},this.crossTileIDs=new At,this.maxBucketInstanceId=0,this.bucketsInCurrentPlacement={};}addLayer(e,t,i,o){let r=this.layerIndexes[e.id];void 0===r&&(r=this.layerIndexes[e.id]=new Lt);let n=!1;const a={};"globe"!==o.name&&r.handleWrapJump(i);for(const i of t){const t=i.getBucket(e);t&&e.id===t.layerIds[0]&&(t.bucketInstanceId||(t.bucketInstanceId=++this.maxBucketInstanceId),r.addBucket(i.tileID,t,this.crossTileIDs)&&(n=!0),a[t.bucketInstanceId]=!0);}return r.removeStaleBuckets(a)&&(n=!0),n}pruneUnusedLayers(e){const t={};e.forEach((e=>{t[e]=!0;}));for(const e in this.layerIndexes)t[e]||delete this.layerIndexes[e];}}const kt=(t,i)=>e.emitValidationErrors(t,i&&i.filter((e=>"source.canvas"!==e.identifier))),Ot=e.pick(ke,["addLayer","removeLayer","setPaintProperty","setLayoutProperty","setFilter","addSource","removeSource","setLayerZoomRange","setLight","setTransition","setGeoJSONSourceData","setTerrain","setFog","setProjection"]),Bt=e.pick(ke,["setCenter","setZoom","setBearing","setPitch"]),Ft=function(){const t={},i=e.spec.$version;for(const o in e.spec.$root){const r=e.spec.$root[o];if(r.required){let e=null;e="version"===o?i:"array"===r.type?[]:{},null!=e&&(t[o]=e);}}return t}(),Ut={fill:!0,line:!0,background:!0,hillshade:!0,raster:!0};class Nt extends e.Evented{constructor(t,i={}){super(),this.map=t,this.dispatcher=new C(Ae(),this),this.imageManager=new d,this.imageManager.setEventedParent(this),this.glyphManager=new e.GlyphManager(t._requestManager,i.localFontFamily?e.LocalGlyphMode.all:i.localIdeographFontFamily?e.LocalGlyphMode.ideographs:e.LocalGlyphMode.none,i.localFontFamily||i.localIdeographFontFamily),this.lineAtlas=new e.LineAtlas(256,512),this.crossTileSymbolIndex=new Rt,this._layers={},this._num3DLayers=0,this._numSymbolLayers=0,this._numCircleLayers=0,this._serializedLayers={},this._sourceCaches={},this._otherSourceCaches={},this._symbolSourceCaches={},this.zoomHistory=new e.ZoomHistory,this._loaded=!1,this._availableImages=[],this._order=[],this._drapedFirstOrder=[],this._markersNeedUpdate=!1,this._resetUpdates(),this.dispatcher.broadcast("setReferrer",e.getReferrer());const o=this;this._rtlTextPluginCallback=Nt.registerForPluginStateChange((t=>{o.dispatcher.broadcast("syncRTLPluginState",{pluginStatus:t.pluginStatus,pluginURL:t.pluginURL},((t,i)=>{if(e.triggerPluginCompletionEvent(t),i&&i.every((e=>e)))for(const e in o._sourceCaches){const t=o._sourceCaches[e],i=t.getSource().type;"vector"!==i&&"geojson"!==i||t.reload();}}));})),this.on("data",(e=>{if("source"!==e.dataType||"metadata"!==e.sourceDataType)return;const t=this.getSource(e.sourceId);if(t&&t.vectorLayerIds)for(const e in this._layers){const i=this._layers[e];i.source===t.id&&this._validateLayer(i);}}));}loadURL(t,i={}){this.fire(new e.Event("dataloading",{dataType:"style"}));const o="boolean"==typeof i.validate?i.validate:!e.isMapboxURL(t);t=this.map._requestManager.normalizeStyleURL(t,i.accessToken);const r=this.map._requestManager.transformRequest(t,e.ResourceType.Style);this._request=e.getJSON(r,((t,i)=>{this._request=null,t?this.fire(new e.ErrorEvent(t)):i&&this._load(i,o);}));}loadJSON(t,i={}){this.fire(new e.Event("dataloading",{dataType:"style"})),this._request=e.exported.frame((()=>{this._request=null,this._load(t,!1!==i.validate);}));}loadEmpty(){this.fire(new e.Event("dataloading",{dataType:"style"})),this._load(Ft,!1);}_updateLayerCount(e,t){const i=t?1:-1;e.is3D()&&(this._num3DLayers+=i),"circle"===e.type&&(this._numCircleLayers+=i),"symbol"===e.type&&(this._numSymbolLayers+=i);}_load(t,i){if(i&&kt(this,e.validateStyle(t)))return;this._loaded=!0,this.stylesheet=t,this.updateProjection();for(const e in t.sources)this.addSource(e,t.sources[e],{validate:!1});this._changed=!1,t.sprite?this._loadSprite(t.sprite):(this.imageManager.setLoaded(!0),this.dispatcher.broadcast("spriteLoaded",!0)),this.glyphManager.setURL(t.glyphs);const o=Re(this.stylesheet.layers);this._order=o.map((e=>e.id)),this._layers={},this._serializedLayers={};for(let t of o)t=e.createStyleLayer(t),t.setEventedParent(this,{layer:{id:t.id}}),this._layers[t.id]=t,this._serializedLayers[t.id]=t.serialize(),this._updateLayerCount(t,!0);this.dispatcher.broadcast("setLayers",this._serializeLayers(this._order)),this.light=new f(this.stylesheet.light),this.stylesheet.terrain&&!this.terrainSetForDrapingOnly()&&this._createTerrain(this.stylesheet.terrain,1),this.stylesheet.fog&&this._createFog(this.stylesheet.fog),this._updateDrapeFirstLayers(),this.fire(new e.Event("data",{dataType:"style"})),this.fire(new e.Event("style.load"));}terrainSetForDrapingOnly(){return this.terrain&&0===this.terrain.drapeRenderMode}setProjection(e){e?this.stylesheet.projection=e:delete this.stylesheet.projection,this.updateProjection();}updateProjection(){const e=this.map.transform.projection,t=this.map.transform.setProjection(this.map._runtimeProjection||(this.stylesheet?this.stylesheet.projection:void 0)),i=this.map.transform.projection;if(this._loaded&&(i.requiresDraping?this.getTerrain()||this.stylesheet.terrain||this.setTerrainForDraping():this.terrainSetForDrapingOnly()&&this.setTerrain(null)),this.dispatcher.broadcast("setProjection",this.map.transform.projectionOptions),t){if(i.isReprojectedInTileSpace||e.isReprojectedInTileSpace){this.map.painter.clearBackgroundTiles();for(const e in this._sourceCaches)this._sourceCaches[e].clearTiles();}else this._forceSymbolLayerUpdate();this.map._update(!0);}}_loadSprite(t){this._spriteRequest=function(t,i,o){let r,n,a;const s=e.exported.devicePixelRatio>1?"@2x":"";let l=e.getJSON(i.transformRequest(i.normalizeSpriteURL(t,s,".json"),e.ResourceType.SpriteJSON),((e,t)=>{l=null,a||(a=e,r=t,h());})),c=e.getImage(i.transformRequest(i.normalizeSpriteURL(t,s,".png"),e.ResourceType.SpriteImage),((e,t)=>{c=null,a||(a=e,n=t,h());}));function h(){if(a)o(a);else if(r&&n){const t=e.exported.getImageData(n),i={};for(const o in r){const{width:n,height:a,x:s,y:l,sdf:c,pixelRatio:h,stretchX:u,stretchY:_,content:d}=r[o],p=new e.RGBAImage({width:n,height:a});e.RGBAImage.copy(t,p,{x:s,y:l},{x:0,y:0},{width:n,height:a}),i[o]={data:p,pixelRatio:h,sdf:c,stretchX:u,stretchY:_,content:d};}o(null,i);}}return {cancel(){l&&(l.cancel(),l=null),c&&(c.cancel(),c=null);}}}(t,this.map._requestManager,((t,i)=>{if(this._spriteRequest=null,t)this.fire(new e.ErrorEvent(t));else if(i)for(const e in i)this.imageManager.addImage(e,i[e]);this.imageManager.setLoaded(!0),this._availableImages=this.imageManager.listImages(),this.dispatcher.broadcast("setImages",this._availableImages),this.dispatcher.broadcast("spriteLoaded",!0),this.fire(new e.Event("data",{dataType:"style"}));}));}_validateLayer(t){const i=this.getSource(t.source);if(!i)return;const o=t.sourceLayer;o&&("geojson"===i.type||i.vectorLayerIds&&-1===i.vectorLayerIds.indexOf(o))&&this.fire(new e.ErrorEvent(new Error(`Source layer "${o}" does not exist on source "${i.id}" as specified by style layer "${t.id}"`)));}loaded(){if(!this._loaded)return !1;if(Object.keys(this._updatedSources).length)return !1;for(const e in this._sourceCaches)if(!this._sourceCaches[e].loaded())return !1;return !!this.imageManager.isLoaded()}_serializeLayers(e){const t=[];for(const i of e){const e=this._layers[i];"custom"!==e.type&&t.push(e.serialize());}return t}hasTransitions(){if(this.light&&this.light.hasTransition())return !0;if(this.fog&&this.fog.hasTransition())return !0;for(const e in this._sourceCaches)if(this._sourceCaches[e].hasTransition())return !0;for(const e in this._layers)if(this._layers[e].hasTransition())return !0;return !1}get order(){return this.map._optimizeForTerrain&&this.terrain?this._drapedFirstOrder:this._order}isLayerDraped(e){return !!this.terrain&&Ut[e.type]}_checkLoaded(){if(!this._loaded)throw new Error("Style is not done loading")}update(t){if(!this._loaded)return;const i=this._changed;if(this._changed){const e=Object.keys(this._updatedLayers),i=Object.keys(this._removedLayers);(e.length||i.length)&&this._updateWorkerLayers(e,i);for(const e in this._updatedSources){const t=this._updatedSources[e];"reload"===t?this._reloadSource(e):"clear"===t&&this._clearSource(e);}this._updateTilesForChangedImages();for(const e in this._updatedPaintProps)this._layers[e].updateTransitions(t);this.light.updateTransitions(t),this.fog&&this.fog.updateTransitions(t),this._resetUpdates();}const o={};for(const e in this._sourceCaches){const t=this._sourceCaches[e];o[e]=t.used,t.used=!1;}for(const e of this._order){const i=this._layers[e];if(i.recalculate(t,this._availableImages),!i.isHidden(t.zoom)){const e=this._getLayerSourceCache(i);e&&(e.used=!0);}const o=this.map.painter;if(o){const e=i.getProgramIds();if(!e)continue;const r=i.getProgramConfiguration(t.zoom);for(const t of e)o.useProgram(t,r);}}for(const t in o){const i=this._sourceCaches[t];o[t]!==i.used&&i.getSource().fire(new e.Event("data",{sourceDataType:"visibility",dataType:"source",sourceId:i.getSource().id}));}this.light.recalculate(t),this.terrain&&this.terrain.recalculate(t),this.fog&&this.fog.recalculate(t),this.z=t.zoom,this._markersNeedUpdate&&(this._updateMarkersOpacity(),this._markersNeedUpdate=!1),i&&this.fire(new e.Event("data",{dataType:"style"}));}_updateTilesForChangedImages(){const e=Object.keys(this._changedImages);if(e.length){for(const t in this._sourceCaches)this._sourceCaches[t].reloadTilesForDependencies(["icons","patterns"],e);this._changedImages={};}}_updateWorkerLayers(e,t){this.dispatcher.broadcast("updateLayers",{layers:this._serializeLayers(e),removedIds:t});}_resetUpdates(){this._changed=!1,this._updatedLayers={},this._removedLayers={},this._updatedSources={},this._updatedPaintProps={},this._changedImages={};}setState(t){if(this._checkLoaded(),kt(this,e.validateStyle(t)))return !1;(t=e.clone$1(t)).layers=Re(t.layers);const i=function(e,t){if(!e)return [{command:ke.setStyle,args:[t]}];let i=[];try{if(!n(e.version,t.version))return [{command:ke.setStyle,args:[t]}];n(e.center,t.center)||i.push({command:ke.setCenter,args:[t.center]}),n(e.zoom,t.zoom)||i.push({command:ke.setZoom,args:[t.zoom]}),n(e.bearing,t.bearing)||i.push({command:ke.setBearing,args:[t.bearing]}),n(e.pitch,t.pitch)||i.push({command:ke.setPitch,args:[t.pitch]}),n(e.sprite,t.sprite)||i.push({command:ke.setSprite,args:[t.sprite]}),n(e.glyphs,t.glyphs)||i.push({command:ke.setGlyphs,args:[t.glyphs]}),n(e.transition,t.transition)||i.push({command:ke.setTransition,args:[t.transition]}),n(e.light,t.light)||i.push({command:ke.setLight,args:[t.light]}),n(e.fog,t.fog)||i.push({command:ke.setFog,args:[t.fog]}),n(e.projection,t.projection)||i.push({command:ke.setProjection,args:[t.projection]});const o={},r=[];!function(e,t,i,o){let r;for(r in t=t||{},e=e||{})e.hasOwnProperty(r)&&(t.hasOwnProperty(r)||Be(r,i,o));for(r in t)t.hasOwnProperty(r)&&(e.hasOwnProperty(r)?n(e[r],t[r])||("geojson"===e[r].type&&"geojson"===t[r].type&&Ue(e,t,r)?i.push({command:ke.setGeoJSONSourceData,args:[r,t[r].data]}):Fe(r,t,i,o)):Oe(r,t,i));}(e.sources,t.sources,r,o);const a=[];e.layers&&e.layers.forEach((e=>{o[e.source]?i.push({command:ke.removeLayer,args:[e.id]}):a.push(e);}));let s=e.terrain;s&&o[s.source]&&(i.push({command:ke.setTerrain,args:[void 0]}),s=void 0),i=i.concat(r),n(s,t.terrain)||i.push({command:ke.setTerrain,args:[t.terrain]}),function(e,t,i){t=t||[];const o=(e=e||[]).map(Ge),r=t.map(Ge),a=e.reduce(je,{}),s=t.reduce(je,{}),l=o.slice(),c=Object.create(null);let h,u,_,d,p,m,f;for(h=0,u=0;h<o.length;h++)_=o[h],s.hasOwnProperty(_)?u++:(i.push({command:ke.removeLayer,args:[_]}),l.splice(l.indexOf(_,u),1));for(h=0,u=0;h<r.length;h++)_=r[r.length-1-h],l[l.length-1-h]!==_&&(a.hasOwnProperty(_)?(i.push({command:ke.removeLayer,args:[_]}),l.splice(l.lastIndexOf(_,l.length-u),1)):u++,m=l[l.length-h],i.push({command:ke.addLayer,args:[s[_],m]}),l.splice(l.length-h,0,_),c[_]=!0);for(h=0;h<r.length;h++)if(_=r[h],d=a[_],p=s[_],!c[_]&&!n(d,p))if(n(d.source,p.source)&&n(d["source-layer"],p["source-layer"])&&n(d.type,p.type)){for(f in Ne(d.layout,p.layout,i,_,null,ke.setLayoutProperty),Ne(d.paint,p.paint,i,_,null,ke.setPaintProperty),n(d.filter,p.filter)||i.push({command:ke.setFilter,args:[_,p.filter]}),n(d.minzoom,p.minzoom)&&n(d.maxzoom,p.maxzoom)||i.push({command:ke.setLayerZoomRange,args:[_,p.minzoom,p.maxzoom]}),d)d.hasOwnProperty(f)&&"layout"!==f&&"paint"!==f&&"filter"!==f&&"metadata"!==f&&"minzoom"!==f&&"maxzoom"!==f&&(0===f.indexOf("paint.")?Ne(d[f],p[f],i,_,f.slice(6),ke.setPaintProperty):n(d[f],p[f])||i.push({command:ke.setLayerProperty,args:[_,f,p[f]]}));for(f in p)p.hasOwnProperty(f)&&!d.hasOwnProperty(f)&&"layout"!==f&&"paint"!==f&&"filter"!==f&&"metadata"!==f&&"minzoom"!==f&&"maxzoom"!==f&&(0===f.indexOf("paint.")?Ne(d[f],p[f],i,_,f.slice(6),ke.setPaintProperty):n(d[f],p[f])||i.push({command:ke.setLayerProperty,args:[_,f,p[f]]}));}else i.push({command:ke.removeLayer,args:[_]}),m=l[l.lastIndexOf(_)+1],i.push({command:ke.addLayer,args:[p,m]});}(a,t.layers,i);}catch(e){console.warn("Unable to compute style diff:",e),i=[{command:ke.setStyle,args:[t]}];}return i}(this.serialize(),t).filter((e=>!(e.command in Bt)));if(0===i.length)return !1;const o=i.filter((e=>!(e.command in Ot)));if(o.length>0)throw new Error(`Unimplemented: ${o.map((e=>e.command)).join(", ")}.`);return i.forEach((e=>{"setTransition"!==e.command&&this[e.command].apply(this,e.args);})),this.stylesheet=t,this.updateProjection(),!0}addImage(t,i){if(this.getImage(t))return this.fire(new e.ErrorEvent(new Error("An image with this name already exists.")));this.imageManager.addImage(t,i),this._afterImageUpdated(t);}updateImage(e,t){this.imageManager.updateImage(e,t);}getImage(e){return this.imageManager.getImage(e)}removeImage(t){if(!this.getImage(t))return this.fire(new e.ErrorEvent(new Error("No image with this name exists.")));this.imageManager.removeImage(t),this._afterImageUpdated(t);}_afterImageUpdated(t){this._availableImages=this.imageManager.listImages(),this._changedImages[t]=!0,this._changed=!0,this.dispatcher.broadcast("setImages",this._availableImages),this.fire(new e.Event("data",{dataType:"style"}));}listImages(){return this._checkLoaded(),this._availableImages.slice()}addSource(t,i,o={}){if(this._checkLoaded(),void 0!==this.getSource(t))throw new Error("There is already a source with this ID");if(!i.type)throw new Error(`The type property must be defined, but only the following properties were given: ${Object.keys(i).join(", ")}.`);if(["vector","raster","geojson","video","image"].indexOf(i.type)>=0&&this._validate(e.validateStyle.source,`sources.${t}`,i,null,o))return;this.map&&this.map._collectResourceTiming&&(i.collectResourceTiming=!0);const r=Te(t,i,this.dispatcher,this);r.setEventedParent(this,(()=>({isSourceLoaded:this.loaded(),source:r.serialize(),sourceId:t})));const n=i=>{const o=(i?"symbol:":"other:")+t,n=this._sourceCaches[o]=new e.SourceCache(o,r,i);(i?this._symbolSourceCaches:this._otherSourceCaches)[t]=n,n.style=this,n.onAdd(this.map);};n(!1),"vector"!==i.type&&"geojson"!==i.type||n(!0),r.onAdd&&r.onAdd(this.map),this._changed=!0;}removeSource(t){this._checkLoaded();const i=this.getSource(t);if(void 0===i)throw new Error("There is no source with this ID");for(const i in this._layers)if(this._layers[i].source===t)return this.fire(new e.ErrorEvent(new Error(`Source "${t}" cannot be removed while layer "${i}" is using it.`)));if(this.terrain&&this.terrain.get().source===t)return this.fire(new e.ErrorEvent(new Error(`Source "${t}" cannot be removed while terrain is using it.`)));const o=this._getSourceCaches(t);for(const t of o)delete this._sourceCaches[t.id],delete this._updatedSources[t.id],t.fire(new e.Event("data",{sourceDataType:"metadata",dataType:"source",sourceId:t.getSource().id})),t.setEventedParent(null),t.clearTiles();delete this._otherSourceCaches[t],delete this._symbolSourceCaches[t],i.setEventedParent(null),i.onRemove&&i.onRemove(this.map),this._changed=!0;}setGeoJSONSourceData(e,t){this._checkLoaded(),this.getSource(e).setData(t),this._changed=!0;}getSource(e){const t=this._getSourceCache(e);return t&&t.getSource()}addLayer(t,i,o={}){this._checkLoaded();const r=t.id;if(this.getLayer(r))return void this.fire(new e.ErrorEvent(new Error(`Layer with id "${r}" already exists on this map`)));let n;if("custom"===t.type){if(kt(this,e.validateCustomStyleLayer(t)))return;n=e.createStyleLayer(t);}else {if("object"==typeof t.source&&(this.addSource(r,t.source),t=e.clone$1(t),t=e.extend(t,{source:r})),this._validate(e.validateStyle.layer,`layers.${r}`,t,{arrayIndex:-1},o))return;n=e.createStyleLayer(t),this._validateLayer(n),n.setEventedParent(this,{layer:{id:r}}),this._serializedLayers[n.id]=n.serialize(),this._updateLayerCount(n,!0);}const a=i?this._order.indexOf(i):this._order.length;if(i&&-1===a)return void this.fire(new e.ErrorEvent(new Error(`Layer with id "${i}" does not exist on this map.`)));this._order.splice(a,0,r),this._layerOrderChanged=!0,this._layers[r]=n;const s=this._getLayerSourceCache(n);if(this._removedLayers[r]&&n.source&&s&&"custom"!==n.type){const e=this._removedLayers[r];delete this._removedLayers[r],e.type!==n.type?this._updatedSources[n.source]="clear":(this._updatedSources[n.source]="reload",s.pause());}this._updateLayer(n),n.onAdd&&n.onAdd(this.map),this._updateDrapeFirstLayers();}moveLayer(t,i){if(this._checkLoaded(),this._changed=!0,!this._layers[t])return void this.fire(new e.ErrorEvent(new Error(`The layer '${t}' does not exist in the map's style and cannot be moved.`)));if(t===i)return;const o=this._order.indexOf(t);this._order.splice(o,1);const r=i?this._order.indexOf(i):this._order.length;i&&-1===r?this.fire(new e.ErrorEvent(new Error(`Layer with id "${i}" does not exist on this map.`))):(this._order.splice(r,0,t),this._layerOrderChanged=!0,this._updateDrapeFirstLayers());}removeLayer(t){this._checkLoaded();const i=this._layers[t];if(!i)return void this.fire(new e.ErrorEvent(new Error(`The layer '${t}' does not exist in the map's style and cannot be removed.`)));i.setEventedParent(null),this._updateLayerCount(i,!1);const o=this._order.indexOf(t);this._order.splice(o,1),this._layerOrderChanged=!0,this._changed=!0,this._removedLayers[t]=i,delete this._layers[t],delete this._serializedLayers[t],delete this._updatedLayers[t],delete this._updatedPaintProps[t],i.onRemove&&i.onRemove(this.map),this._updateDrapeFirstLayers();}getLayer(e){return this._layers[e]}hasLayer(e){return e in this._layers}hasLayerType(e){for(const t in this._layers)if(this._layers[t].type===e)return !0;return !1}setLayerZoomRange(t,i,o){this._checkLoaded();const r=this.getLayer(t);r?r.minzoom===i&&r.maxzoom===o||(null!=i&&(r.minzoom=i),null!=o&&(r.maxzoom=o),this._updateLayer(r)):this.fire(new e.ErrorEvent(new Error(`The layer '${t}' does not exist in the map's style and cannot have zoom extent.`)));}setFilter(t,i,o={}){this._checkLoaded();const r=this.getLayer(t);if(r){if(!n(r.filter,i))return null==i?(r.filter=void 0,void this._updateLayer(r)):void(this._validate(e.validateStyle.filter,`layers.${r.id}.filter`,i,{layerType:r.type},o)||(r.filter=e.clone$1(i),this._updateLayer(r)))}else this.fire(new e.ErrorEvent(new Error(`The layer '${t}' does not exist in the map's style and cannot be filtered.`)));}getFilter(t){return e.clone$1(this.getLayer(t).filter)}setLayoutProperty(t,i,o,r={}){this._checkLoaded();const a=this.getLayer(t);a?n(a.getLayoutProperty(i),o)||(a.setLayoutProperty(i,o,r),this._updateLayer(a)):this.fire(new e.ErrorEvent(new Error(`The layer '${t}' does not exist in the map's style and cannot be styled.`)));}getLayoutProperty(t,i){const o=this.getLayer(t);if(o)return o.getLayoutProperty(i);this.fire(new e.ErrorEvent(new Error(`The layer '${t}' does not exist in the map's style.`)));}setPaintProperty(t,i,o,r={}){this._checkLoaded();const a=this.getLayer(t);a?n(a.getPaintProperty(i),o)||(a.setPaintProperty(i,o,r)&&this._updateLayer(a),this._changed=!0,this._updatedPaintProps[t]=!0):this.fire(new e.ErrorEvent(new Error(`The layer '${t}' does not exist in the map's style and cannot be styled.`)));}getPaintProperty(e,t){return this.getLayer(e).getPaintProperty(t)}setFeatureState(t,i){this._checkLoaded();const o=t.source,r=t.sourceLayer,n=this.getSource(o);if(void 0===n)return void this.fire(new e.ErrorEvent(new Error(`The source '${o}' does not exist in the map's style.`)));const a=n.type;if("geojson"===a&&r)return void this.fire(new e.ErrorEvent(new Error("GeoJSON sources cannot have a sourceLayer parameter.")));if("vector"===a&&!r)return void this.fire(new e.ErrorEvent(new Error("The sourceLayer parameter must be provided for vector source types.")));void 0===t.id&&this.fire(new e.ErrorEvent(new Error("The feature id parameter must be provided.")));const s=this._getSourceCaches(o);for(const e of s)e.setFeatureState(r,t.id,i);}removeFeatureState(t,i){this._checkLoaded();const o=t.source,r=this.getSource(o);if(void 0===r)return void this.fire(new e.ErrorEvent(new Error(`The source '${o}' does not exist in the map's style.`)));const n=r.type,a="vector"===n?t.sourceLayer:void 0;if("vector"===n&&!a)return void this.fire(new e.ErrorEvent(new Error("The sourceLayer parameter must be provided for vector source types.")));if(i&&"string"!=typeof t.id&&"number"!=typeof t.id)return void this.fire(new e.ErrorEvent(new Error("A feature id is required to remove its specific state property.")));const s=this._getSourceCaches(o);for(const e of s)e.removeFeatureState(a,t.id,i);}getFeatureState(t){this._checkLoaded();const i=t.source,o=t.sourceLayer,r=this.getSource(i);if(void 0!==r){if("vector"!==r.type||o)return void 0===t.id&&this.fire(new e.ErrorEvent(new Error("The feature id parameter must be provided."))),this._getSourceCaches(i)[0].getFeatureState(o,t.id);this.fire(new e.ErrorEvent(new Error("The sourceLayer parameter must be provided for vector source types.")));}else this.fire(new e.ErrorEvent(new Error(`The source '${i}' does not exist in the map's style.`)));}getTransition(){return e.extend({duration:300,delay:0},this.stylesheet&&this.stylesheet.transition)}serialize(){const t={};for(const e in this._sourceCaches){const i=this._sourceCaches[e].getSource();t[i.id]||(t[i.id]=i.serialize());}return e.filterObject({version:this.stylesheet.version,name:this.stylesheet.name,metadata:this.stylesheet.metadata,light:this.stylesheet.light,terrain:this.stylesheet.terrain,fog:this.stylesheet.fog,center:this.stylesheet.center,zoom:this.stylesheet.zoom,bearing:this.stylesheet.bearing,pitch:this.stylesheet.pitch,sprite:this.stylesheet.sprite,glyphs:this.stylesheet.glyphs,transition:this.stylesheet.transition,projection:this.stylesheet.projection,sources:t,layers:this._serializeLayers(this._order)},(e=>void 0!==e))}_updateLayer(e){this._updatedLayers[e.id]=!0;const t=this._getLayerSourceCache(e);e.source&&!this._updatedSources[e.source]&&t&&"raster"!==t.getSource().type&&(this._updatedSources[e.source]="reload",t.pause()),this._changed=!0,e.invalidateCompiledFilter();}_flattenAndSortRenderedFeatures(e){const t=e=>"fill-extrusion"===this._layers[e].type,i={},o=[];for(let r=this._order.length-1;r>=0;r--){const n=this._order[r];if(t(n)){i[n]=r;for(const t of e){const e=t[n];if(e)for(const t of e)o.push(t);}}}o.sort(((e,t)=>t.intersectionZ-e.intersectionZ));const r=[];for(let n=this._order.length-1;n>=0;n--){const a=this._order[n];if(t(a))for(let e=o.length-1;e>=0;e--){const t=o[e].feature;if(i[t.layer.id]<n)break;r.push(t),o.pop();}else for(const t of e){const e=t[a];if(e)for(const t of e)r.push(t.feature);}}return r}queryRenderedFeatures(t,i,o){i&&i.filter&&this._validate(e.validateStyle.filter,"queryRenderedFeatures.filter",i.filter,null,i);const r={};if(i&&i.layers){if(!Array.isArray(i.layers))return this.fire(new e.ErrorEvent(new Error("parameters.layers must be an Array."))),[];for(const t of i.layers){const i=this._layers[t];if(!i)return this.fire(new e.ErrorEvent(new Error(`The layer '${t}' does not exist in the map's style and cannot be queried for features.`))),[];r[i.source]=!0;}}const n=[];i.availableImages=this._availableImages;const a=i&&i.layers?i.layers.some((e=>{const t=this.getLayer(e);return t&&t.is3D()})):this.has3DLayers(),s=pe.createFromScreenPoints(t,o);for(const e in this._sourceCaches){const t=this._sourceCaches[e].getSource().id;i.layers&&!r[t]||n.push(Ce(this._sourceCaches[e],this._layers,this._serializedLayers,s,i,o,a,!!this.map._showQueryGeometry));}return this.placement&&n.push(function(e,t,i,o,r,n,a){const s={},l=n.queryRenderedSymbols(o),c=[];for(const e of Object.keys(l).map(Number))c.push(a[e]);c.sort(Se);for(const i of c){const o=i.featureIndex.lookupSymbolFeatures(l[i.bucketInstanceId],t,i.bucketIndex,i.sourceLayerIndex,r.filter,r.layers,r.availableImages,e);for(const e in o){const t=s[e]=s[e]||[],r=o[e];r.sort(((e,t)=>{const o=i.featureSortOrder;if(o){const i=o.indexOf(e.featureIndex);return o.indexOf(t.featureIndex)-i}return t.featureIndex-e.featureIndex}));for(const e of r)t.push(e);}}for(const t in s)s[t].forEach((o=>{const r=o.feature,n=i(e[t]).getFeatureState(r.layer["source-layer"],r.id);r.source=r.layer.source,r.layer["source-layer"]&&(r.sourceLayer=r.layer["source-layer"]),r.state=n;}));return s}(this._layers,this._serializedLayers,this._getLayerSourceCache.bind(this),s.screenGeometry,i,this.placement.collisionIndex,this.placement.retainedQueryData)),this._flattenAndSortRenderedFeatures(n)}querySourceFeatures(t,i){i&&i.filter&&this._validate(e.validateStyle.filter,"querySourceFeatures.filter",i.filter,null,i);const o=this._getSourceCaches(t);let r=[];for(const e of o)r=r.concat(Me(e,i));return r}addSourceType(e,t,i){return Nt.getSourceType(e)?i(new Error(`A source type called "${e}" already exists.`)):(Nt.setSourceType(e,t),t.workerSourceURL?void this.dispatcher.broadcast("loadWorkerSource",{name:e,url:t.workerSourceURL},i):i(null,null))}getLight(){return this.light.getLight()}setLight(t,i={}){this._checkLoaded();const o=this.light.getLight();let r=!1;for(const e in t)if(!n(t[e],o[e])){r=!0;break}if(!r)return;const a={now:e.exported.now(),transition:e.extend({duration:300,delay:0},this.stylesheet.transition)};this.light.setLight(t,i),this.light.updateTransitions(a);}getTerrain(){return this.terrain&&1===this.terrain.drapeRenderMode?this.terrain.get():null}setTerrainForDraping(){this.setTerrain({source:"",exaggeration:0},0);}setTerrain(t,i=1){if(this._checkLoaded(),!t)return delete this.terrain,delete this.stylesheet.terrain,this.dispatcher.broadcast("enableTerrain",!1),this._force3DLayerUpdate(),void(this._markersNeedUpdate=!0);if(1===i){if("object"==typeof t.source){const i="terrain-dem-src";this.addSource(i,t.source),t=e.clone$1(t),t=e.extend(t,{source:i});}if(this._validate(e.validateStyle.terrain,"terrain",t))return}if(!this.terrain||this.terrain&&i!==this.terrain.drapeRenderMode)this._createTerrain(t,i);else {const i=this.terrain,o=i.get();for(const r in t)if(!n(t[r],o[r])){i.set(t),this.stylesheet.terrain=t;const o={now:e.exported.now(),transition:e.extend({duration:0},this.stylesheet.transition)};i.updateTransitions(o);break}}this._updateDrapeFirstLayers(),this._markersNeedUpdate=!0;}_createFog(t){const i=this.fog=new E(t,this.map.transform);this.stylesheet.fog=t;const o={now:e.exported.now(),transition:e.extend({duration:0},this.stylesheet.transition)};i.updateTransitions(o);}_updateMarkersOpacity(){0!==this.map._markers.length&&this.map._requestDomTask((()=>{for(const e of this.map._markers)e._evaluateOpacity();}));}getFog(){return this.fog?this.fog.get():null}setFog(t){if(this._checkLoaded(),!t)return delete this.fog,delete this.stylesheet.fog,void(this._markersNeedUpdate=!0);if(this.fog){const i=this.fog,o=i.get();for(const r in t)if(!n(t[r],o[r])){i.set(t),this.stylesheet.fog=t;const o={now:e.exported.now(),transition:e.extend({duration:0},this.stylesheet.transition)};i.updateTransitions(o);break}}else this._createFog(t);this._markersNeedUpdate=!0;}_updateDrapeFirstLayers(){if(!this.map._optimizeForTerrain||!this.terrain)return;const e=this._order.filter((e=>this.isLayerDraped(this._layers[e]))),t=this._order.filter((e=>!this.isLayerDraped(this._layers[e])));this._drapedFirstOrder=[],this._drapedFirstOrder.push(...e),this._drapedFirstOrder.push(...t);}_createTerrain(t,i){const o=this.terrain=new x(t,i);this.stylesheet.terrain=t,this.dispatcher.broadcast("enableTerrain",!0),this._force3DLayerUpdate();const r={now:e.exported.now(),transition:e.extend({duration:0},this.stylesheet.transition)};o.updateTransitions(r);}_force3DLayerUpdate(){for(const e in this._layers){const t=this._layers[e];"fill-extrusion"===t.type&&this._updateLayer(t);}}_forceSymbolLayerUpdate(){for(const e in this._layers){const t=this._layers[e];"symbol"===t.type&&this._updateLayer(t);}}_validate(t,i,o,r,n={}){return (!n||!1!==n.validate)&&kt(this,t.call(e.validateStyle,e.extend({key:i,style:this.serialize(),value:o,styleSpec:e.spec},r)))}_remove(){this._request&&(this._request.cancel(),this._request=null),this._spriteRequest&&(this._spriteRequest.cancel(),this._spriteRequest=null),e.evented.off("pluginStateChange",this._rtlTextPluginCallback);for(const e in this._layers)this._layers[e].setEventedParent(null);for(const e in this._sourceCaches)this._sourceCaches[e].clearTiles(),this._sourceCaches[e].setEventedParent(null);this.imageManager.setEventedParent(null),this.setEventedParent(null),this.dispatcher.remove();}_clearSource(e){const t=this._getSourceCaches(e);for(const e of t)e.clearTiles();}_reloadSource(e){const t=this._getSourceCaches(e);for(const e of t)e.resume(),e.reload();}_updateSources(e){for(const t in this._sourceCaches)this._sourceCaches[t].update(e);}_generateCollisionBoxes(){for(const e in this._sourceCaches){const t=this._sourceCaches[e];t.resume(),t.reload();}}_updatePlacement(t,i,o,r,n=!1){let a=!1,s=!1;const l={};for(const e of this._order){const i=this._layers[e];if("symbol"!==i.type)continue;if(!l[i.source]){const e=this._getLayerSourceCache(i);if(!e)continue;l[i.source]=e.getRenderableIds(!0).map((t=>e.getTileByID(t))).sort(((e,t)=>t.tileID.overscaledZ-e.tileID.overscaledZ||(e.tileID.isLessThan(t.tileID)?-1:1)));}const o=this.crossTileSymbolIndex.addLayer(i,l[i.source],t.center.lng,t.projection);a=a||o;}if(this.crossTileSymbolIndex.pruneUnusedLayers(this._order),n=n||this._layerOrderChanged||0===o,this._layerOrderChanged&&this.fire(new e.Event("neworder")),(n||!this.pauseablePlacement||this.pauseablePlacement.isDone()&&!this.placement.stillRecent(e.exported.now(),t.zoom))&&(this.pauseablePlacement=new zt(t,this._order,n,i,o,r,this.placement,this.fog&&t.projection.supportsFog?this.fog.state:null),this._layerOrderChanged=!1),this.pauseablePlacement.isDone()?this.placement.setStale():(this.pauseablePlacement.continuePlacement(this._order,this._layers,l),this.pauseablePlacement.isDone()&&(this.placement=this.pauseablePlacement.commit(e.exported.now()),s=!0),a&&this.pauseablePlacement.placement.setStale()),s||a)for(const e of this._order){const t=this._layers[e];"symbol"===t.type&&this.placement.updateLayerOpacities(t,l[t.source]);}return !this.pauseablePlacement.isDone()||this.placement.hasTransitions(e.exported.now())}_releaseSymbolFadeTiles(){for(const e in this._sourceCaches)this._sourceCaches[e].releaseSymbolFadeTiles();}getImages(e,t,i){this.imageManager.getImages(t.icons,i),this._updateTilesForChangedImages();const o=e=>{e&&e.setDependencies(t.tileID.key,t.type,t.icons);};o(this._otherSourceCaches[t.source]),o(this._symbolSourceCaches[t.source]);}getGlyphs(e,t,i){this.glyphManager.getGlyphs(t.stacks,i);}getResource(t,i,o){return e.makeRequest(i,o)}_getSourceCache(e){return this._otherSourceCaches[e]}_getLayerSourceCache(e){return "symbol"===e.type?this._symbolSourceCaches[e.source]:this._otherSourceCaches[e.source]}_getSourceCaches(e){const t=[];return this._otherSourceCaches[e]&&t.push(this._otherSourceCaches[e]),this._symbolSourceCaches[e]&&t.push(this._symbolSourceCaches[e]),t}has3DLayers(){return this._num3DLayers>0}hasSymbolLayers(){return this._numSymbolLayers>0}hasCircleLayers(){return this._numCircleLayers>0}_clearWorkerCaches(){this.dispatcher.broadcast("clearCaches");}destroy(){this._clearWorkerCaches(),this.terrainSetForDrapingOnly()&&(delete this.terrain,delete this.stylesheet.terrain);}}Nt.getSourceType=function(e){return we[e]},Nt.setSourceType=function(e,t){we[e]=t;},Nt.registerForPluginStateChange=e.registerForPluginStateChange;var Gt="\n#define EPSILON 0.0000001\n#define PI 3.141592653589793\n#define EXTENT 8192.0\n#ifdef FOG\nuniform mediump vec4 u_fog_color;uniform mediump vec2 u_fog_range;uniform mediump float u_fog_horizon_blend;varying vec3 v_fog_pos;float fog_range(float depth) {return (depth-u_fog_range[0])/(u_fog_range[1]-u_fog_range[0]);}float fog_horizon_blending(vec3 camera_dir) {float t=max(0.0,camera_dir.z/u_fog_horizon_blend);return u_fog_color.a*exp(-3.0*t*t);}float fog_opacity(float t) {const float decay=6.0;float falloff=1.0-min(1.0,exp(-decay*t));falloff*=falloff*falloff;return u_fog_color.a*min(1.0,1.00747*falloff);}\n#endif",jt="attribute highp vec3 a_pos_3f;uniform lowp mat4 u_matrix;varying highp vec3 v_uv;void main() {const mat3 half_neg_pi_around_x=mat3(1.0,0.0, 0.0,0.0,0.0,-1.0,0.0,1.0, 0.0);v_uv=half_neg_pi_around_x*a_pos_3f;vec4 pos=u_matrix*vec4(a_pos_3f,1.0);gl_Position=pos.xyww;}";let Zt={},Vt={};Zt=$t("","\n#define ELEVATION_SCALE 7.0\n#define ELEVATION_OFFSET 450.0\n#ifdef PROJECTION_GLOBE_VIEW\nuniform vec3 u_tile_tl_up;uniform vec3 u_tile_tr_up;uniform vec3 u_tile_br_up;uniform vec3 u_tile_bl_up;uniform float u_tile_up_scale;vec3 elevationVector(vec2 pos) {vec2 uv=pos/EXTENT;vec3 up=normalize(mix(\nmix(u_tile_tl_up,u_tile_tr_up,uv.xxx),mix(u_tile_bl_up,u_tile_br_up,uv.xxx),uv.yyy));return up*u_tile_up_scale;}\n#else\nvec3 elevationVector(vec2 pos) { return vec3(0,0,1); }\n#endif\n#ifdef TERRAIN\n#ifdef TERRAIN_DEM_FLOAT_FORMAT\nuniform highp sampler2D u_dem;uniform highp sampler2D u_dem_prev;\n#else\nuniform sampler2D u_dem;uniform sampler2D u_dem_prev;\n#endif\nuniform vec4 u_dem_unpack;uniform vec2 u_dem_tl;uniform vec2 u_dem_tl_prev;uniform float u_dem_scale;uniform float u_dem_scale_prev;uniform float u_dem_size;uniform float u_dem_lerp;uniform float u_exaggeration;uniform float u_meter_to_dem;uniform mat4 u_label_plane_matrix_inv;uniform sampler2D u_depth;uniform vec2 u_depth_size_inv;vec4 tileUvToDemSample(vec2 uv,float dem_size,float dem_scale,vec2 dem_tl) {vec2 pos=dem_size*(uv*dem_scale+dem_tl)+1.0;vec2 f=fract(pos);return vec4((pos-f+0.5)/(dem_size+2.0),f);}float decodeElevation(vec4 v) {return dot(vec4(v.xyz*255.0,-1.0),u_dem_unpack);}float currentElevation(vec2 apos) {\n#ifdef TERRAIN_DEM_FLOAT_FORMAT\nvec2 pos=(u_dem_size*(apos/8192.0*u_dem_scale+u_dem_tl)+1.5)/(u_dem_size+2.0);return u_exaggeration*texture2D(u_dem,pos).a;\n#else\nfloat dd=1.0/(u_dem_size+2.0);vec4 r=tileUvToDemSample(apos/8192.0,u_dem_size,u_dem_scale,u_dem_tl);vec2 pos=r.xy;vec2 f=r.zw;float tl=decodeElevation(texture2D(u_dem,pos));\n#ifdef TERRAIN_DEM_NEAREST_FILTER\nreturn u_exaggeration*tl;\n#endif\nfloat tr=decodeElevation(texture2D(u_dem,pos+vec2(dd,0.0)));float bl=decodeElevation(texture2D(u_dem,pos+vec2(0.0,dd)));float br=decodeElevation(texture2D(u_dem,pos+vec2(dd,dd)));return u_exaggeration*mix(mix(tl,tr,f.x),mix(bl,br,f.x),f.y);\n#endif\n}float prevElevation(vec2 apos) {\n#ifdef TERRAIN_DEM_FLOAT_FORMAT\nvec2 pos=(u_dem_size*(apos/8192.0*u_dem_scale_prev+u_dem_tl_prev)+1.5)/(u_dem_size+2.0);return u_exaggeration*texture2D(u_dem_prev,pos).a;\n#else\nfloat dd=1.0/(u_dem_size+2.0);vec4 r=tileUvToDemSample(apos/8192.0,u_dem_size,u_dem_scale_prev,u_dem_tl_prev);vec2 pos=r.xy;vec2 f=r.zw;float tl=decodeElevation(texture2D(u_dem_prev,pos));float tr=decodeElevation(texture2D(u_dem_prev,pos+vec2(dd,0.0)));float bl=decodeElevation(texture2D(u_dem_prev,pos+vec2(0.0,dd)));float br=decodeElevation(texture2D(u_dem_prev,pos+vec2(dd,dd)));return u_exaggeration*mix(mix(tl,tr,f.x),mix(bl,br,f.x),f.y);\n#endif\n}\n#ifdef TERRAIN_VERTEX_MORPHING\nfloat elevation(vec2 apos) {float nextElevation=currentElevation(apos);float prevElevation=prevElevation(apos);return mix(prevElevation,nextElevation,u_dem_lerp);}\n#else\nfloat elevation(vec2 apos) {return currentElevation(apos);}\n#endif\nfloat unpack_depth(vec4 rgba_depth)\n{const vec4 bit_shift=vec4(1.0/(256.0*256.0*256.0),1.0/(256.0*256.0),1.0/256.0,1.0);return dot(rgba_depth,bit_shift)*2.0-1.0;}bool isOccluded(vec4 frag) {vec3 coord=frag.xyz/frag.w;float depth=unpack_depth(texture2D(u_depth,(coord.xy+1.0)*0.5));return coord.z > depth+0.0005;}float occlusionFade(vec4 frag) {vec3 coord=frag.xyz/frag.w;vec3 df=vec3(5.0*u_depth_size_inv,0.0);vec2 uv=0.5*coord.xy+0.5;vec4 depth=vec4(\nunpack_depth(texture2D(u_depth,uv-df.xz)),unpack_depth(texture2D(u_depth,uv+df.xz)),unpack_depth(texture2D(u_depth,uv-df.zy)),unpack_depth(texture2D(u_depth,uv+df.zy))\n);return dot(vec4(0.25),vec4(1.0)-clamp(300.0*(vec4(coord.z-0.001)-depth),0.0,1.0));}vec4 fourSample(vec2 pos,vec2 off) {\n#ifdef TERRAIN_DEM_FLOAT_FORMAT\nfloat tl=texture2D(u_dem,pos).a;float tr=texture2D(u_dem,pos+vec2(off.x,0.0)).a;float bl=texture2D(u_dem,pos+vec2(0.0,off.y)).a;float br=texture2D(u_dem,pos+off).a;\n#else\nvec4 demtl=vec4(texture2D(u_dem,pos).xyz*255.0,-1.0);float tl=dot(demtl,u_dem_unpack);vec4 demtr=vec4(texture2D(u_dem,pos+vec2(off.x,0.0)).xyz*255.0,-1.0);float tr=dot(demtr,u_dem_unpack);vec4 dembl=vec4(texture2D(u_dem,pos+vec2(0.0,off.y)).xyz*255.0,-1.0);float bl=dot(dembl,u_dem_unpack);vec4 dembr=vec4(texture2D(u_dem,pos+off).xyz*255.0,-1.0);float br=dot(dembr,u_dem_unpack);\n#endif\nreturn vec4(tl,tr,bl,br);}float flatElevation(vec2 pack) {vec2 apos=floor(pack/8.0);vec2 span=10.0*(pack-apos*8.0);vec2 uvTex=(apos-vec2(1.0,1.0))/8190.0;float size=u_dem_size+2.0;float dd=1.0/size;vec2 pos=u_dem_size*(uvTex*u_dem_scale+u_dem_tl)+1.0;vec2 f=fract(pos);pos=(pos-f+0.5)*dd;vec4 h=fourSample(pos,vec2(dd));float z=mix(mix(h.x,h.y,f.x),mix(h.z,h.w,f.x),f.y);vec2 w=floor(0.5*(span*u_meter_to_dem-1.0));vec2 d=dd*w;vec4 bounds=vec4(d,vec2(1.0)-d);h=fourSample(pos-d,2.0*d+vec2(dd));vec4 diff=abs(h.xzxy-h.ywzw);vec2 slope=min(vec2(0.25),u_meter_to_dem*0.5*(diff.xz+diff.yw)/(2.0*w+vec2(1.0)));vec2 fix=slope*span;float base=z+max(fix.x,fix.y);return u_exaggeration*base;}float elevationFromUint16(float word) {return u_exaggeration*(word/ELEVATION_SCALE-ELEVATION_OFFSET);}\n#else\nfloat elevation(vec2 pos) { return 0.0; }bool isOccluded(vec4 frag) { return false; }float occlusionFade(vec4 frag) { return 1.0; }\n#endif",!0),Vt=$t("#ifdef FOG\nuniform float u_fog_temporal_offset;float fog_opacity(vec3 pos) {float depth=length(pos);return fog_opacity(fog_range(depth));}vec3 fog_apply(vec3 color,vec3 pos) {float depth=length(pos);float opacity=fog_opacity(fog_range(depth));opacity*=fog_horizon_blending(pos/depth);return mix(color,u_fog_color.rgb,opacity);}vec4 fog_apply_from_vert(vec4 color,float fog_opac) {float alpha=EPSILON+color.a;color.rgb=mix(color.rgb/alpha,u_fog_color.rgb,fog_opac)*alpha;return color;}vec3 fog_apply_sky_gradient(vec3 camera_ray,vec3 sky_color) {float horizon_blend=fog_horizon_blending(normalize(camera_ray));return mix(sky_color,u_fog_color.rgb,horizon_blend);}vec4 fog_apply_premultiplied(vec4 color,vec3 pos) {float alpha=EPSILON+color.a;color.rgb=fog_apply(color.rgb/alpha,pos)*alpha;return color;}vec3 fog_dither(vec3 color) {vec2 dither_seed=gl_FragCoord.xy+u_fog_temporal_offset;return dither(color,dither_seed);}vec4 fog_dither(vec4 color) {return vec4(fog_dither(color.rgb),color.a);}\n#endif","#ifdef FOG\nuniform mat4 u_fog_matrix;vec3 fog_position(vec3 pos) {return (u_fog_matrix*vec4(pos,1.0)).xyz;}vec3 fog_position(vec2 pos) {return fog_position(vec3(pos,0.0));}float fog(vec3 pos) {float depth=length(pos);float opacity=fog_opacity(fog_range(depth));return opacity*fog_horizon_blending(pos/depth);}\n#endif",!0);const Wt=$t("\nhighp vec3 hash(highp vec2 p) {highp vec3 p3=fract(p.xyx*vec3(443.8975,397.2973,491.1871));p3+=dot(p3,p3.yxz+19.19);return fract((p3.xxy+p3.yzz)*p3.zyx);}vec3 dither(vec3 color,highp vec2 seed) {vec3 rnd=hash(seed)+hash(seed+0.59374)-0.5;return color+rnd/255.0;}\n#ifdef TERRAIN\nhighp vec4 pack_depth(highp float ndc_z) {highp float depth=ndc_z*0.5+0.5;const highp vec4 bit_shift=vec4(256.0*256.0*256.0,256.0*256.0,256.0,1.0);const highp vec4 bit_mask =vec4(0.0,1.0/256.0,1.0/256.0,1.0/256.0);highp vec4 res=fract(depth*bit_shift);res-=res.xxyz*bit_mask;return res;}\n#endif","\nfloat wrap(float n,float min,float max) {float d=max-min;float w=mod(mod(n-min,d)+d,d)+min;return (w==min) ? max : w;}vec3 mercator_tile_position(mat4 matrix,vec2 tile_anchor,vec3 tile_id,vec2 mercator_center) {\n#if defined(PROJECTION_GLOBE_VIEW) && !defined(PROJECTED_POS_ON_VIEWPORT)\nfloat tiles=tile_id.z;vec2 mercator=(tile_anchor/EXTENT+tile_id.xy)/tiles;mercator-=mercator_center;mercator.x=wrap(mercator.x,-0.5,0.5);vec4 mercator_tile=vec4(mercator.xy*EXTENT,EXTENT/(2.0*PI),1.0);mercator_tile=matrix*mercator_tile;return mercator_tile.xyz;\n#else\nreturn vec3(0.0);\n#endif\n}vec3 mix_globe_mercator(vec3 globe,vec3 mercator,float t) {\n#if defined(PROJECTION_GLOBE_VIEW) && !defined(PROJECTED_POS_ON_VIEWPORT)\nreturn mix(globe,mercator,t);\n#else\nreturn globe;\n#endif\n}\n#ifdef PROJECTION_GLOBE_VIEW\nmat3 globe_mercator_surface_vectors(vec3 pos_normal,vec3 up_dir,float zoom_transition) {vec3 normal=zoom_transition==0.0 ? pos_normal : normalize(mix(pos_normal,up_dir,zoom_transition));vec3 xAxis=normalize(vec3(normal.z,0.0,-normal.x));vec3 yAxis=normalize(cross(normal,xAxis));return mat3(xAxis,yAxis,normal);}\n#endif\nvec2 unpack_float(const float packedValue) {int packedIntValue=int(packedValue);int v0=packedIntValue/256;return vec2(v0,packedIntValue-v0*256);}vec2 unpack_opacity(const float packedOpacity) {int intOpacity=int(packedOpacity)/2;return vec2(float(intOpacity)/127.0,mod(packedOpacity,2.0));}vec4 decode_color(const vec2 encodedColor) {return vec4(\nunpack_float(encodedColor[0])/255.0,unpack_float(encodedColor[1])/255.0\n);}float unpack_mix_vec2(const vec2 packedValue,const float t) {return mix(packedValue[0],packedValue[1],t);}vec4 unpack_mix_color(const vec4 packedColors,const float t) {vec4 minColor=decode_color(vec2(packedColors[0],packedColors[1]));vec4 maxColor=decode_color(vec2(packedColors[2],packedColors[3]));return mix(minColor,maxColor,t);}vec2 get_pattern_pos(const vec2 pixel_coord_upper,const vec2 pixel_coord_lower,const vec2 pattern_size,const float tile_units_to_pixels,const vec2 pos) {vec2 offset=mod(mod(mod(pixel_coord_upper,pattern_size)*256.0,pattern_size)*256.0+pixel_coord_lower,pattern_size);return (tile_units_to_pixels*pos+offset)/pattern_size;}const vec4 AWAY=vec4(-1000.0,-1000.0,-1000.0,1);//Normalized device coordinate that is not rendered."),qt=Gt;var Xt={background:$t("uniform vec4 u_color;uniform float u_opacity;void main() {vec4 out_color=u_color;\n#ifdef FOG\nout_color=fog_dither(fog_apply_premultiplied(out_color,v_fog_pos));\n#endif\ngl_FragColor=out_color*u_opacity;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","attribute vec2 a_pos;uniform mat4 u_matrix;void main() {gl_Position=u_matrix*vec4(a_pos,0,1);\n#ifdef FOG\nv_fog_pos=fog_position(a_pos);\n#endif\n}"),backgroundPattern:$t("uniform vec2 u_pattern_tl_a;uniform vec2 u_pattern_br_a;uniform vec2 u_pattern_tl_b;uniform vec2 u_pattern_br_b;uniform vec2 u_texsize;uniform float u_mix;uniform float u_opacity;uniform sampler2D u_image;varying vec2 v_pos_a;varying vec2 v_pos_b;void main() {vec2 imagecoord=mod(v_pos_a,1.0);vec2 pos=mix(u_pattern_tl_a/u_texsize,u_pattern_br_a/u_texsize,imagecoord);vec4 color1=texture2D(u_image,pos);vec2 imagecoord_b=mod(v_pos_b,1.0);vec2 pos2=mix(u_pattern_tl_b/u_texsize,u_pattern_br_b/u_texsize,imagecoord_b);vec4 color2=texture2D(u_image,pos2);vec4 out_color=mix(color1,color2,u_mix);\n#ifdef FOG\nout_color=fog_dither(fog_apply_premultiplied(out_color,v_fog_pos));\n#endif\ngl_FragColor=out_color*u_opacity;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_pattern_size_a;uniform vec2 u_pattern_size_b;uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform float u_scale_a;uniform float u_scale_b;uniform float u_tile_units_to_pixels;attribute vec2 a_pos;varying vec2 v_pos_a;varying vec2 v_pos_b;void main() {gl_Position=u_matrix*vec4(a_pos,0,1);v_pos_a=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,u_scale_a*u_pattern_size_a,u_tile_units_to_pixels,a_pos);v_pos_b=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,u_scale_b*u_pattern_size_b,u_tile_units_to_pixels,a_pos);\n#ifdef FOG\nv_fog_pos=fog_position(a_pos);\n#endif\n}"),circle:$t("varying vec3 v_data;varying float v_visibility;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define mediump float radius\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define highp vec4 stroke_color\n#pragma mapbox: define mediump float stroke_width\n#pragma mapbox: define lowp float stroke_opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize mediump float radius\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize highp vec4 stroke_color\n#pragma mapbox: initialize mediump float stroke_width\n#pragma mapbox: initialize lowp float stroke_opacity\nvec2 extrude=v_data.xy;float extrude_length=length(extrude);lowp float antialiasblur=v_data.z;float antialiased_blur=-max(blur,antialiasblur);float opacity_t=smoothstep(0.0,antialiased_blur,extrude_length-1.0);float color_t=stroke_width < 0.01 ? 0.0 : smoothstep(\nantialiased_blur,0.0,extrude_length-radius/(radius+stroke_width)\n);vec4 out_color=mix(color*opacity,stroke_color*stroke_opacity,color_t);\n#ifdef FOG\nout_color=fog_apply_premultiplied(out_color,v_fog_pos);\n#endif\ngl_FragColor=out_color*(v_visibility*opacity_t);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","#define NUM_VISIBILITY_RINGS 2\n#define INV_SQRT2 0.70710678\n#define ELEVATION_BIAS 0.0001\n#define NUM_SAMPLES_PER_RING 16\nuniform mat4 u_matrix;uniform mat2 u_extrude_scale;uniform lowp float u_device_pixel_ratio;uniform highp float u_camera_to_center_distance;attribute vec2 a_pos;\n#ifdef PROJECTION_GLOBE_VIEW\nattribute vec3 a_pos_3;attribute vec3 a_pos_normal_3;attribute float a_scale;uniform mat4 u_inv_rot_matrix;uniform vec2 u_merc_center;uniform vec3 u_tile_id;uniform float u_zoom_transition;uniform vec3 u_up_dir;\n#endif\nvarying vec3 v_data;varying float v_visibility;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define mediump float radius\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define highp vec4 stroke_color\n#pragma mapbox: define mediump float stroke_width\n#pragma mapbox: define lowp float stroke_opacity\nvec2 calc_offset(vec2 extrusion,float radius,float stroke_width, float view_scale) {return extrusion*(radius+stroke_width)*u_extrude_scale*view_scale;}float cantilevered_elevation(vec2 pos,float radius,float stroke_width,float view_scale) {vec2 c1=pos+calc_offset(vec2(-1,-1),radius,stroke_width,view_scale);vec2 c2=pos+calc_offset(vec2(1,-1),radius,stroke_width,view_scale);vec2 c3=pos+calc_offset(vec2(1,1),radius,stroke_width,view_scale);vec2 c4=pos+calc_offset(vec2(-1,1),radius,stroke_width,view_scale);float h1=elevation(c1)+ELEVATION_BIAS;float h2=elevation(c2)+ELEVATION_BIAS;float h3=elevation(c3)+ELEVATION_BIAS;float h4=elevation(c4)+ELEVATION_BIAS;return max(h4,max(h3,max(h1,h2)));}float circle_elevation(vec2 pos) {\n#if defined(TERRAIN)\nreturn elevation(pos)+ELEVATION_BIAS;\n#else\nreturn 0.0;\n#endif\n}vec4 project_vertex(vec2 extrusion,vec4 world_center,vec4 projected_center,float radius,float stroke_width, float view_scale,mat3 surface_vectors) {vec2 sample_offset=calc_offset(extrusion,radius,stroke_width,view_scale);\n#ifdef PITCH_WITH_MAP\n#ifdef PROJECTION_GLOBE_VIEW\nreturn u_matrix*( world_center+vec4(sample_offset.x*surface_vectors[0]+sample_offset.y*surface_vectors[1],0) );\n#else\nreturn u_matrix*( world_center+vec4(sample_offset,0,0) );\n#endif\n#else\nreturn projected_center+vec4(sample_offset,0,0);\n#endif\n}float get_sample_step() {\n#ifdef PITCH_WITH_MAP\nreturn 2.0*PI/float(NUM_SAMPLES_PER_RING);\n#else\nreturn PI/float(NUM_SAMPLES_PER_RING);\n#endif\n}void main(void) {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize mediump float radius\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize highp vec4 stroke_color\n#pragma mapbox: initialize mediump float stroke_width\n#pragma mapbox: initialize lowp float stroke_opacity\nvec2 extrude=vec2(mod(a_pos,2.0)*2.0-1.0);vec2 circle_center=floor(a_pos*0.5);\n#ifdef PROJECTION_GLOBE_VIEW\nvec2 scaled_extrude=extrude*a_scale;vec3 pos_normal_3=a_pos_normal_3/16384.0;mat3 surface_vectors=globe_mercator_surface_vectors(pos_normal_3,u_up_dir,u_zoom_transition);vec3 surface_extrusion=scaled_extrude.x*surface_vectors[0]+scaled_extrude.y*surface_vectors[1];vec3 globe_elevation=elevationVector(circle_center)*circle_elevation(circle_center);vec3 globe_pos=a_pos_3+surface_extrusion+globe_elevation;vec3 mercator_elevation=u_up_dir*u_tile_up_scale*circle_elevation(circle_center);vec3 merc_pos=mercator_tile_position(u_inv_rot_matrix,circle_center,u_tile_id,u_merc_center)+surface_extrusion+mercator_elevation;vec3 pos=mix_globe_mercator(globe_pos,merc_pos,u_zoom_transition);vec4 world_center=vec4(pos,1);\n#else \nmat3 surface_vectors=mat3(1.0);float height=circle_elevation(circle_center);vec4 world_center=vec4(circle_center,height,1);\n#endif\nvec4 projected_center=u_matrix*world_center;float view_scale=0.0;\n#ifdef PITCH_WITH_MAP\n#ifdef SCALE_WITH_MAP\nview_scale=1.0;\n#else\nview_scale=projected_center.w/u_camera_to_center_distance;\n#endif\n#else\n#ifdef SCALE_WITH_MAP\nview_scale=u_camera_to_center_distance;\n#else\nview_scale=projected_center.w;\n#endif\n#endif\n#if defined(SCALE_WITH_MAP) && defined(PROJECTION_GLOBE_VIEW)\nview_scale*=a_scale;\n#endif\ngl_Position=project_vertex(extrude,world_center,projected_center,radius,stroke_width,view_scale,surface_vectors);float visibility=0.0;\n#ifdef TERRAIN\nfloat step=get_sample_step();\n#ifdef PITCH_WITH_MAP\nfloat cantilevered_height=cantilevered_elevation(circle_center,radius,stroke_width,view_scale);vec4 occlusion_world_center=vec4(circle_center,cantilevered_height,1);vec4 occlusion_projected_center=u_matrix*occlusion_world_center;\n#else\nvec4 occlusion_world_center=world_center;vec4 occlusion_projected_center=projected_center;\n#endif\nfor(int ring=0; ring < NUM_VISIBILITY_RINGS; ring++) {float scale=(float(ring)+1.0)/float(NUM_VISIBILITY_RINGS);for(int i=0; i < NUM_SAMPLES_PER_RING; i++) {vec2 extrusion=vec2(cos(step*float(i)),-sin(step*float(i)))*scale;vec4 frag_pos=project_vertex(extrusion,occlusion_world_center,occlusion_projected_center,radius,stroke_width,view_scale,surface_vectors);visibility+=float(!isOccluded(frag_pos));}}visibility/=float(NUM_VISIBILITY_RINGS)*float(NUM_SAMPLES_PER_RING);\n#else\nvisibility=1.0;\n#endif\n#ifdef PROJECTION_GLOBE_VIEW\nvisibility=1.0;\n#endif\nv_visibility=visibility;lowp float antialiasblur=1.0/u_device_pixel_ratio/(radius+stroke_width);v_data=vec3(extrude.x,extrude.y,antialiasblur);\n#ifdef FOG\nv_fog_pos=fog_position(world_center.xyz);\n#endif\n}"),clippingMask:$t("void main() {gl_FragColor=vec4(1.0);}","attribute vec2 a_pos;uniform mat4 u_matrix;void main() {gl_Position=u_matrix*vec4(a_pos,0,1);}"),heatmap:$t("uniform highp float u_intensity;varying vec2 v_extrude;\n#pragma mapbox: define highp float weight\n#define GAUSS_COEF 0.3989422804014327\nvoid main() {\n#pragma mapbox: initialize highp float weight\nfloat d=-0.5*3.0*3.0*dot(v_extrude,v_extrude);float val=weight*u_intensity*GAUSS_COEF*exp(d);gl_FragColor=vec4(val,1.0,1.0,1.0);\n#ifdef FOG\ngl_FragColor.r*=pow(1.0-fog_opacity(v_fog_pos),2.0);\n#endif\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform float u_extrude_scale;uniform float u_opacity;uniform float u_intensity;attribute vec2 a_pos;\n#ifdef PROJECTION_GLOBE_VIEW\nattribute vec3 a_pos_3;attribute vec3 a_pos_normal_3;attribute float a_scale;uniform mat4 u_inv_rot_matrix;uniform vec2 u_merc_center;uniform vec3 u_tile_id;uniform float u_zoom_transition;uniform vec3 u_up_dir;\n#endif\nvarying vec2 v_extrude;\n#pragma mapbox: define highp float weight\n#pragma mapbox: define mediump float radius\nconst highp float ZERO=1.0/255.0/16.0;\n#define GAUSS_COEF 0.3989422804014327\nvoid main(void) {\n#pragma mapbox: initialize highp float weight\n#pragma mapbox: initialize mediump float radius\nvec2 unscaled_extrude=vec2(mod(a_pos,2.0)*2.0-1.0);float S=sqrt(-2.0*log(ZERO/weight/u_intensity/GAUSS_COEF))/3.0;v_extrude=S*unscaled_extrude;vec2 extrude=v_extrude*radius*u_extrude_scale;vec2 tilePos=floor(a_pos*0.5);\n#ifdef PROJECTION_GLOBE_VIEW\nextrude*=a_scale;vec3 pos_normal_3=a_pos_normal_3/16384.0;mat3 surface_vectors=globe_mercator_surface_vectors(pos_normal_3,u_up_dir,u_zoom_transition);vec3 surface_extrusion=extrude.x*surface_vectors[0]+extrude.y*surface_vectors[1];vec3 globe_elevation=elevationVector(tilePos)*elevation(tilePos);vec3 globe_pos=a_pos_3+surface_extrusion+globe_elevation;vec3 mercator_elevation=u_up_dir*u_tile_up_scale*elevation(tilePos);vec3 merc_pos=mercator_tile_position(u_inv_rot_matrix,tilePos,u_tile_id,u_merc_center)+surface_extrusion+mercator_elevation;vec3 pos=mix_globe_mercator(globe_pos,merc_pos,u_zoom_transition);\n#else\nvec3 pos=vec3(tilePos+extrude,elevation(tilePos));\n#endif\ngl_Position=u_matrix*vec4(pos,1);\n#ifdef FOG\nv_fog_pos=fog_position(pos);\n#endif\n}"),heatmapTexture:$t("uniform sampler2D u_image;uniform sampler2D u_color_ramp;uniform float u_opacity;varying vec2 v_pos;void main() {float t=texture2D(u_image,v_pos).r;vec4 color=texture2D(u_color_ramp,vec2(t,0.5));gl_FragColor=color*u_opacity;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(0.0);\n#endif\n}","attribute vec2 a_pos;varying vec2 v_pos;void main() {gl_Position=vec4(a_pos,0,1);v_pos=a_pos*0.5+0.5;}"),collisionBox:$t("varying float v_placed;varying float v_notUsed;void main() {vec4 red =vec4(1.0,0.0,0.0,1.0);vec4 blue=vec4(0.0,0.0,1.0,0.5);gl_FragColor =mix(red,blue,step(0.5,v_placed))*0.5;gl_FragColor*=mix(1.0,0.1,step(0.5,v_notUsed));}","attribute vec3 a_pos;attribute vec2 a_anchor_pos;attribute vec2 a_extrude;attribute vec2 a_placed;attribute vec2 a_shift;attribute float a_size_scale;attribute vec2 a_padding;uniform mat4 u_matrix;uniform vec2 u_extrude_scale;uniform float u_camera_to_center_distance;varying float v_placed;varying float v_notUsed;void main() {vec4 projectedPoint=u_matrix*vec4(a_pos+elevationVector(a_anchor_pos)*elevation(a_anchor_pos),1);highp float camera_to_anchor_distance=projectedPoint.w;highp float collision_perspective_ratio=clamp(\n0.5+0.5*(u_camera_to_center_distance/camera_to_anchor_distance),0.0,1.5);gl_Position=projectedPoint;gl_Position.xy+=(a_extrude*a_size_scale+a_shift+a_padding)*u_extrude_scale*gl_Position.w*collision_perspective_ratio;v_placed=a_placed.x;v_notUsed=a_placed.y;}"),collisionCircle:$t("varying float v_radius;varying vec2 v_extrude;varying float v_perspective_ratio;varying float v_collision;void main() {float alpha=0.5*min(v_perspective_ratio,1.0);float stroke_radius=0.9*max(v_perspective_ratio,1.0);float distance_to_center=length(v_extrude);float distance_to_edge=abs(distance_to_center-v_radius);float opacity_t=smoothstep(-stroke_radius,0.0,-distance_to_edge);vec4 color=mix(vec4(0.0,0.0,1.0,0.5),vec4(1.0,0.0,0.0,1.0),v_collision);gl_FragColor=color*alpha*opacity_t;}","attribute vec2 a_pos_2f;attribute float a_radius;attribute vec2 a_flags;uniform mat4 u_matrix;uniform mat4 u_inv_matrix;uniform vec2 u_viewport_size;uniform float u_camera_to_center_distance;varying float v_radius;varying vec2 v_extrude;varying float v_perspective_ratio;varying float v_collision;vec3 toTilePosition(vec2 screenPos) {vec4 rayStart=u_inv_matrix*vec4(screenPos,-1.0,1.0);vec4 rayEnd  =u_inv_matrix*vec4(screenPos, 1.0,1.0);rayStart.xyz/=rayStart.w;rayEnd.xyz  /=rayEnd.w;highp float t=(0.0-rayStart.z)/(rayEnd.z-rayStart.z);return mix(rayStart.xyz,rayEnd.xyz,t);}void main() {vec2 quadCenterPos=a_pos_2f;float radius=a_radius;float collision=a_flags.x;float vertexIdx=a_flags.y;vec2 quadVertexOffset=vec2(\nmix(-1.0,1.0,float(vertexIdx >=2.0)),mix(-1.0,1.0,float(vertexIdx >=1.0 && vertexIdx <=2.0)));vec2 quadVertexExtent=quadVertexOffset*radius;vec3 tilePos=toTilePosition(quadCenterPos);vec4 clipPos=u_matrix*vec4(tilePos,1.0);highp float camera_to_anchor_distance=clipPos.w;highp float collision_perspective_ratio=clamp(\n0.5+0.5*(u_camera_to_center_distance/camera_to_anchor_distance),0.0,4.0);float padding_factor=1.2;v_radius=radius;v_extrude=quadVertexExtent*padding_factor;v_perspective_ratio=collision_perspective_ratio;v_collision=collision;gl_Position=vec4(clipPos.xyz/clipPos.w,1.0)+vec4(quadVertexExtent*padding_factor/u_viewport_size*2.0,0.0,0.0);}"),debug:$t("uniform highp vec4 u_color;uniform sampler2D u_overlay;varying vec2 v_uv;void main() {vec4 overlay_color=texture2D(u_overlay,v_uv);gl_FragColor=mix(u_color,overlay_color,overlay_color.a);}","attribute vec2 a_pos;\n#ifdef PROJECTION_GLOBE_VIEW\nattribute vec3 a_pos_3;\n#endif\nvarying vec2 v_uv;uniform mat4 u_matrix;uniform float u_overlay_scale;void main() {float h=elevation(a_pos);v_uv=a_pos/8192.0;\n#ifdef PROJECTION_GLOBE_VIEW\ngl_Position=u_matrix*vec4(a_pos_3+elevationVector(a_pos)*h,1);\n#else\ngl_Position=u_matrix*vec4(a_pos*u_overlay_scale,h,1);\n#endif\n}"),fill:$t("#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float opacity\nvec4 out_color=color;\n#ifdef FOG\nout_color=fog_dither(fog_apply_premultiplied(out_color,v_fog_pos));\n#endif\ngl_FragColor=out_color*opacity;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","attribute vec2 a_pos;uniform mat4 u_matrix;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float opacity\ngl_Position=u_matrix*vec4(a_pos,0,1);\n#ifdef FOG\nv_fog_pos=fog_position(a_pos);\n#endif\n}"),fillOutline:$t("varying vec2 v_pos;\n#pragma mapbox: define highp vec4 outline_color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 outline_color\n#pragma mapbox: initialize lowp float opacity\nfloat dist=length(v_pos-gl_FragCoord.xy);float alpha=1.0-smoothstep(0.0,1.0,dist);vec4 out_color=outline_color;\n#ifdef FOG\nout_color=fog_dither(fog_apply_premultiplied(out_color,v_fog_pos));\n#endif\ngl_FragColor=out_color*(alpha*opacity);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","attribute vec2 a_pos;uniform mat4 u_matrix;uniform vec2 u_world;varying vec2 v_pos;\n#pragma mapbox: define highp vec4 outline_color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 outline_color\n#pragma mapbox: initialize lowp float opacity\ngl_Position=u_matrix*vec4(a_pos,0,1);v_pos=(gl_Position.xy/gl_Position.w+1.0)/2.0*u_world;\n#ifdef FOG\nv_fog_pos=fog_position(a_pos);\n#endif\n}"),fillOutlinePattern:$t("uniform vec2 u_texsize;uniform sampler2D u_image;uniform float u_fade;varying vec2 v_pos_a;varying vec2 v_pos_b;varying vec2 v_pos;\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;vec2 imagecoord=mod(v_pos_a,1.0);vec2 pos=mix(pattern_tl_a/u_texsize,pattern_br_a/u_texsize,imagecoord);vec4 color1=texture2D(u_image,pos);vec2 imagecoord_b=mod(v_pos_b,1.0);vec2 pos2=mix(pattern_tl_b/u_texsize,pattern_br_b/u_texsize,imagecoord_b);vec4 color2=texture2D(u_image,pos2);float dist=length(v_pos-gl_FragCoord.xy);float alpha=1.0-smoothstep(0.0,1.0,dist);vec4 out_color=mix(color1,color2,u_fade);\n#ifdef FOG\nout_color=fog_dither(fog_apply_premultiplied(out_color,v_fog_pos));\n#endif\ngl_FragColor=out_color*(alpha*opacity);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_world;uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform vec3 u_scale;attribute vec2 a_pos;varying vec2 v_pos_a;varying vec2 v_pos_b;varying vec2 v_pos;\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;float tileRatio=u_scale.x;float fromScale=u_scale.y;float toScale=u_scale.z;gl_Position=u_matrix*vec4(a_pos,0,1);vec2 display_size_a=(pattern_br_a-pattern_tl_a)/pixel_ratio_from;vec2 display_size_b=(pattern_br_b-pattern_tl_b)/pixel_ratio_to;v_pos_a=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,fromScale*display_size_a,tileRatio,a_pos);v_pos_b=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,toScale*display_size_b,tileRatio,a_pos);v_pos=(gl_Position.xy/gl_Position.w+1.0)/2.0*u_world;\n#ifdef FOG\nv_fog_pos=fog_position(a_pos);\n#endif\n}"),fillPattern:$t("uniform vec2 u_texsize;uniform float u_fade;uniform sampler2D u_image;varying vec2 v_pos_a;varying vec2 v_pos_b;\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;vec2 imagecoord=mod(v_pos_a,1.0);vec2 pos=mix(pattern_tl_a/u_texsize,pattern_br_a/u_texsize,imagecoord);vec4 color1=texture2D(u_image,pos);vec2 imagecoord_b=mod(v_pos_b,1.0);vec2 pos2=mix(pattern_tl_b/u_texsize,pattern_br_b/u_texsize,imagecoord_b);vec4 color2=texture2D(u_image,pos2);vec4 out_color=mix(color1,color2,u_fade);\n#ifdef FOG\nout_color=fog_dither(fog_apply_premultiplied(out_color,v_fog_pos));\n#endif\ngl_FragColor=out_color*opacity;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform vec3 u_scale;attribute vec2 a_pos;varying vec2 v_pos_a;varying vec2 v_pos_b;\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;float tileZoomRatio=u_scale.x;float fromScale=u_scale.y;float toScale=u_scale.z;vec2 display_size_a=(pattern_br_a-pattern_tl_a)/pixel_ratio_from;vec2 display_size_b=(pattern_br_b-pattern_tl_b)/pixel_ratio_to;gl_Position=u_matrix*vec4(a_pos,0,1);v_pos_a=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,fromScale*display_size_a,tileZoomRatio,a_pos);v_pos_b=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,toScale*display_size_b,tileZoomRatio,a_pos);\n#ifdef FOG\nv_fog_pos=fog_position(a_pos);\n#endif\n}"),fillExtrusion:$t("varying vec4 v_color;void main() {vec4 color=v_color;\n#ifdef FOG\ncolor=fog_dither(fog_apply_premultiplied(color,v_fog_pos));\n#endif\ngl_FragColor=color;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec3 u_lightcolor;uniform lowp vec3 u_lightpos;uniform lowp float u_lightintensity;uniform float u_vertical_gradient;uniform lowp float u_opacity;attribute vec4 a_pos_normal_ed;attribute vec2 a_centroid_pos;\n#ifdef PROJECTION_GLOBE_VIEW\nattribute vec3 a_pos_3;attribute vec3 a_pos_normal_3;uniform mat4 u_inv_rot_matrix;uniform vec2 u_merc_center;uniform vec3 u_tile_id;uniform float u_zoom_transition;uniform vec3 u_up_dir;uniform float u_height_lift;\n#endif\nvarying vec4 v_color;\n#pragma mapbox: define highp float base\n#pragma mapbox: define highp float height\n#pragma mapbox: define highp vec4 color\nvoid main() {\n#pragma mapbox: initialize highp float base\n#pragma mapbox: initialize highp float height\n#pragma mapbox: initialize highp vec4 color\nvec3 pos_nx=floor(a_pos_normal_ed.xyz*0.5);mediump vec3 top_up_ny=a_pos_normal_ed.xyz-2.0*pos_nx;float x_normal=pos_nx.z/8192.0;vec3 normal=top_up_ny.y==1.0 ? vec3(0.0,0.0,1.0) : normalize(vec3(x_normal,(2.0*top_up_ny.z-1.0)*(1.0-abs(x_normal)),0.0));base=max(0.0,base);height=max(0.0,height);float t=top_up_ny.x;vec2 centroid_pos=vec2(0.0);\n#if defined(HAS_CENTROID) || defined(TERRAIN)\ncentroid_pos=a_centroid_pos;\n#endif\n#ifdef TERRAIN\nbool flat_roof=centroid_pos.x !=0.0 && t > 0.0;float ele=elevation(pos_nx.xy);float c_ele=flat_roof ? centroid_pos.y==0.0 ? elevationFromUint16(centroid_pos.x) : flatElevation(centroid_pos) : ele;float h=flat_roof ? max(c_ele+height,ele+base+2.0) : ele+(t > 0.0 ? height : base==0.0 ?-5.0 : base);vec3 pos=vec3(pos_nx.xy,h);\n#else\nvec3 pos=vec3(pos_nx.xy,t > 0.0 ? height : base);\n#endif\n#ifdef PROJECTION_GLOBE_VIEW\nfloat lift=float((t+base) > 0.0)*u_height_lift;vec3 globe_normal=normalize(mix(a_pos_normal_3/16384.0,u_up_dir,u_zoom_transition));vec3 globe_pos=a_pos_3+globe_normal*(u_tile_up_scale*(pos.z+lift));vec3 merc_pos=mercator_tile_position(u_inv_rot_matrix,pos.xy,u_tile_id,u_merc_center)+u_up_dir*u_tile_up_scale*pos.z;pos=mix_globe_mercator(globe_pos,merc_pos,u_zoom_transition);\n#endif\nfloat hidden=float(centroid_pos.x==0.0 && centroid_pos.y==1.0);gl_Position=mix(u_matrix*vec4(pos,1),AWAY,hidden);float colorvalue=color.r*0.2126+color.g*0.7152+color.b*0.0722;v_color=vec4(0.0,0.0,0.0,1.0);vec4 ambientlight=vec4(0.03,0.03,0.03,1.0);color+=ambientlight;float directional=clamp(dot(normal,u_lightpos),0.0,1.0);directional=mix((1.0-u_lightintensity),max((1.0-colorvalue+u_lightintensity),1.0),directional);if (normal.y !=0.0) {directional*=(\n(1.0-u_vertical_gradient)+(u_vertical_gradient*clamp((t+base)*pow(height/150.0,0.5),mix(0.7,0.98,1.0-u_lightintensity),1.0)));}v_color.rgb+=clamp(color.rgb*directional*u_lightcolor,mix(vec3(0.0),vec3(0.3),1.0-u_lightcolor),vec3(1.0));v_color*=u_opacity;\n#ifdef FOG\nv_fog_pos=fog_position(pos);\n#endif\n}"),fillExtrusionPattern:$t("uniform vec2 u_texsize;uniform float u_fade;uniform sampler2D u_image;varying vec2 v_pos_a;varying vec2 v_pos_b;varying vec4 v_lighting;\n#pragma mapbox: define lowp float base\n#pragma mapbox: define lowp float height\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float base\n#pragma mapbox: initialize lowp float height\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;vec2 imagecoord=mod(v_pos_a,1.0);vec2 pos=mix(pattern_tl_a/u_texsize,pattern_br_a/u_texsize,imagecoord);vec4 color1=texture2D(u_image,pos);vec2 imagecoord_b=mod(v_pos_b,1.0);vec2 pos2=mix(pattern_tl_b/u_texsize,pattern_br_b/u_texsize,imagecoord_b);vec4 color2=texture2D(u_image,pos2);vec4 out_color=mix(color1,color2,u_fade);out_color=out_color*v_lighting;\n#ifdef FOG\nout_color=fog_dither(fog_apply_premultiplied(out_color,v_fog_pos));\n#endif\ngl_FragColor=out_color;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform float u_height_factor;uniform vec3 u_scale;uniform float u_vertical_gradient;uniform lowp float u_opacity;uniform vec3 u_lightcolor;uniform lowp vec3 u_lightpos;uniform lowp float u_lightintensity;attribute vec4 a_pos_normal_ed;attribute vec2 a_centroid_pos;\n#ifdef PROJECTION_GLOBE_VIEW\nattribute vec3 a_pos_3;attribute vec3 a_pos_normal_3;uniform mat4 u_inv_rot_matrix;uniform vec2 u_merc_center;uniform vec3 u_tile_id;uniform float u_zoom_transition;uniform vec3 u_up_dir;uniform float u_height_lift;\n#endif\nvarying vec2 v_pos_a;varying vec2 v_pos_b;varying vec4 v_lighting;\n#pragma mapbox: define lowp float base\n#pragma mapbox: define lowp float height\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float base\n#pragma mapbox: initialize lowp float height\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;float tileRatio=u_scale.x;float fromScale=u_scale.y;float toScale=u_scale.z;vec3 pos_nx=floor(a_pos_normal_ed.xyz*0.5);mediump vec3 top_up_ny=a_pos_normal_ed.xyz-2.0*pos_nx;float x_normal=pos_nx.z/8192.0;vec3 normal=top_up_ny.y==1.0 ? vec3(0.0,0.0,1.0) : normalize(vec3(x_normal,(2.0*top_up_ny.z-1.0)*(1.0-abs(x_normal)),0.0));float edgedistance=a_pos_normal_ed.w;vec2 display_size_a=(pattern_br_a-pattern_tl_a)/pixel_ratio_from;vec2 display_size_b=(pattern_br_b-pattern_tl_b)/pixel_ratio_to;base=max(0.0,base);height=max(0.0,height);float t=top_up_ny.x;float z=t > 0.0 ? height : base;vec2 centroid_pos=vec2(0.0);\n#if defined(HAS_CENTROID) || defined(TERRAIN)\ncentroid_pos=a_centroid_pos;\n#endif\n#ifdef TERRAIN\nbool flat_roof=centroid_pos.x !=0.0 && t > 0.0;float ele=elevation(pos_nx.xy);float c_ele=flat_roof ? centroid_pos.y==0.0 ? elevationFromUint16(centroid_pos.x) : flatElevation(centroid_pos) : ele;float h=flat_roof ? max(c_ele+height,ele+base+2.0) : ele+(t > 0.0 ? height : base==0.0 ?-5.0 : base);vec3 p=vec3(pos_nx.xy,h);\n#else\nvec3 p=vec3(pos_nx.xy,z);\n#endif\n#ifdef PROJECTION_GLOBE_VIEW\nfloat lift=float((t+base) > 0.0)*u_height_lift;vec3 globe_normal=normalize(mix(a_pos_normal_3/16384.0,u_up_dir,u_zoom_transition));vec3 globe_pos=a_pos_3+globe_normal*(u_tile_up_scale*(p.z+lift));vec3 merc_pos=mercator_tile_position(u_inv_rot_matrix,p.xy,u_tile_id,u_merc_center)+u_up_dir*u_tile_up_scale*p.z;p=mix_globe_mercator(globe_pos,merc_pos,u_zoom_transition);\n#endif\nfloat hidden=float(centroid_pos.x==0.0 && centroid_pos.y==1.0);gl_Position=mix(u_matrix*vec4(p,1),AWAY,hidden);vec2 pos=normal.z==1.0\n? pos_nx.xy\n: vec2(edgedistance,z*u_height_factor);v_pos_a=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,fromScale*display_size_a,tileRatio,pos);v_pos_b=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,toScale*display_size_b,tileRatio,pos);v_lighting=vec4(0.0,0.0,0.0,1.0);float directional=clamp(dot(normal,u_lightpos),0.0,1.0);directional=mix((1.0-u_lightintensity),max((0.5+u_lightintensity),1.0),directional);if (normal.y !=0.0) {directional*=(\n(1.0-u_vertical_gradient)+(u_vertical_gradient*clamp((t+base)*pow(height/150.0,0.5),mix(0.7,0.98,1.0-u_lightintensity),1.0)));}v_lighting.rgb+=clamp(directional*u_lightcolor,mix(vec3(0.0),vec3(0.3),1.0-u_lightcolor),vec3(1.0));v_lighting*=u_opacity;\n#ifdef FOG\nv_fog_pos=fog_position(p);\n#endif\n}"),hillshadePrepare:$t("#ifdef GL_ES\nprecision highp float;\n#endif\nuniform sampler2D u_image;varying vec2 v_pos;uniform vec2 u_dimension;uniform float u_zoom;uniform vec4 u_unpack;float getElevation(vec2 coord) {\n#ifdef TERRAIN_DEM_FLOAT_FORMAT\nreturn texture2D(u_image,coord).a/4.0;\n#else\nvec4 data=texture2D(u_image,coord)*255.0;data.a=-1.0;return dot(data,u_unpack)/4.0;\n#endif\n}void main() {vec2 epsilon=1.0/u_dimension;float a=getElevation(v_pos+vec2(-epsilon.x,-epsilon.y));float b=getElevation(v_pos+vec2(0,-epsilon.y));float c=getElevation(v_pos+vec2(epsilon.x,-epsilon.y));float d=getElevation(v_pos+vec2(-epsilon.x,0));float e=getElevation(v_pos);float f=getElevation(v_pos+vec2(epsilon.x,0));float g=getElevation(v_pos+vec2(-epsilon.x,epsilon.y));float h=getElevation(v_pos+vec2(0,epsilon.y));float i=getElevation(v_pos+vec2(epsilon.x,epsilon.y));float exaggerationFactor=u_zoom < 2.0 ? 0.4 : u_zoom < 4.5 ? 0.35 : 0.3;float exaggeration=u_zoom < 15.0 ? (u_zoom-15.0)*exaggerationFactor : 0.0;vec2 deriv=vec2(\n(c+f+f+i)-(a+d+d+g),(g+h+h+i)-(a+b+b+c)\n)/pow(2.0,exaggeration+(19.2562-u_zoom));gl_FragColor=clamp(vec4(\nderiv.x/2.0+0.5,deriv.y/2.0+0.5,1.0,1.0),0.0,1.0);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_dimension;attribute vec2 a_pos;attribute vec2 a_texture_pos;varying vec2 v_pos;void main() {gl_Position=u_matrix*vec4(a_pos,0,1);highp vec2 epsilon=1.0/u_dimension;float scale=(u_dimension.x-2.0)/u_dimension.x;v_pos=(a_texture_pos/8192.0)*scale+epsilon;}"),hillshade:$t("uniform sampler2D u_image;varying vec2 v_pos;uniform vec2 u_latrange;uniform vec2 u_light;uniform vec4 u_shadow;uniform vec4 u_highlight;uniform vec4 u_accent;void main() {vec4 pixel=texture2D(u_image,v_pos);vec2 deriv=((pixel.rg*2.0)-1.0);float scaleFactor=cos(radians((u_latrange[0]-u_latrange[1])*(1.0-v_pos.y)+u_latrange[1]));float slope=atan(1.25*length(deriv)/scaleFactor);float aspect=deriv.x !=0.0 ? atan(deriv.y,-deriv.x) : PI/2.0*(deriv.y > 0.0 ? 1.0 :-1.0);float intensity=u_light.x;float azimuth=u_light.y+PI;float base=1.875-intensity*1.75;float maxValue=0.5*PI;float scaledSlope=intensity !=0.5 ? ((pow(base,slope)-1.0)/(pow(base,maxValue)-1.0))*maxValue : slope;float accent=cos(scaledSlope);vec4 accent_color=(1.0-accent)*u_accent*clamp(intensity*2.0,0.0,1.0);float shade=abs(mod((aspect+azimuth)/PI+0.5,2.0)-1.0);vec4 shade_color=mix(u_shadow,u_highlight,shade)*sin(scaledSlope)*clamp(intensity*2.0,0.0,1.0);gl_FragColor=accent_color*(1.0-shade_color.a)+shade_color;\n#ifdef FOG\ngl_FragColor=fog_dither(fog_apply_premultiplied(gl_FragColor,v_fog_pos));\n#endif\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;attribute vec2 a_pos;attribute vec2 a_texture_pos;varying vec2 v_pos;void main() {gl_Position=u_matrix*vec4(a_pos,0,1);v_pos=a_texture_pos/8192.0;\n#ifdef FOG\nv_fog_pos=fog_position(a_pos);\n#endif\n}"),line:$t("uniform lowp float u_device_pixel_ratio;uniform float u_alpha_discard_threshold;varying vec2 v_width2;varying vec2 v_normal;varying float v_gamma_scale;\n#ifdef RENDER_LINE_DASH\nuniform sampler2D u_dash_image;uniform float u_mix;uniform vec3 u_scale;varying vec2 v_tex_a;varying vec2 v_tex_b;\n#endif\n#ifdef RENDER_LINE_GRADIENT\nuniform sampler2D u_gradient_image;varying highp vec2 v_uv;\n#endif\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float floorwidth\n#pragma mapbox: define lowp vec4 dash_from\n#pragma mapbox: define lowp vec4 dash_to\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float floorwidth\n#pragma mapbox: initialize lowp vec4 dash_from\n#pragma mapbox: initialize lowp vec4 dash_to\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\nfloat dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);\n#ifdef RENDER_LINE_DASH\nfloat sdfdist_a=texture2D(u_dash_image,v_tex_a).a;float sdfdist_b=texture2D(u_dash_image,v_tex_b).a;float sdfdist=mix(sdfdist_a,sdfdist_b,u_mix);float sdfwidth=min(dash_from.z*u_scale.y,dash_to.z*u_scale.z);float sdfgamma=1.0/(2.0*u_device_pixel_ratio)/sdfwidth;alpha*=smoothstep(0.5-sdfgamma/floorwidth,0.5+sdfgamma/floorwidth,sdfdist);\n#endif\n#ifdef RENDER_LINE_GRADIENT\nvec4 out_color=texture2D(u_gradient_image,v_uv);\n#else\nvec4 out_color=color;\n#endif\n#ifdef FOG\nout_color=fog_dither(fog_apply_premultiplied(out_color,v_fog_pos));\n#endif\n#ifdef RENDER_LINE_ALPHA_DISCARD\nif (alpha < u_alpha_discard_threshold) {discard;}\n#endif\ngl_FragColor=out_color*(alpha*opacity);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","\n#define EXTRUDE_SCALE 0.015873016\nattribute vec2 a_pos_normal;attribute vec4 a_data;\n#ifdef RENDER_LINE_GRADIENT\nattribute vec3 a_packed;\n#else\nattribute float a_linesofar;\n#endif\nuniform mat4 u_matrix;uniform mat2 u_pixels_to_tile_units;uniform vec2 u_units_to_pixels;uniform lowp float u_device_pixel_ratio;varying vec2 v_normal;varying vec2 v_width2;varying float v_gamma_scale;\n#ifdef RENDER_LINE_DASH\nuniform vec2 u_texsize;uniform mediump vec3 u_scale;varying vec2 v_tex_a;varying vec2 v_tex_b;\n#endif\n#ifdef RENDER_LINE_GRADIENT\nuniform float u_image_height;varying highp vec2 v_uv;\n#endif\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float floorwidth\n#pragma mapbox: define lowp vec4 dash_from\n#pragma mapbox: define lowp vec4 dash_to\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float width\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float floorwidth\n#pragma mapbox: initialize lowp vec4 dash_from\n#pragma mapbox: initialize lowp vec4 dash_to\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float width\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*EXTRUDE_SCALE;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*EXTRUDE_SCALE*normal.y*mat2(t,-u,u,t);vec4 projected_extrude=u_matrix*vec4(dist*u_pixels_to_tile_units,0.0,0.0);gl_Position=u_matrix*vec4(pos+offset2*u_pixels_to_tile_units,0.0,1.0)+projected_extrude;\n#ifndef RENDER_TO_TEXTURE\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length(projected_extrude.xy/gl_Position.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#else\nv_gamma_scale=1.0;\n#endif\n#ifdef RENDER_LINE_GRADIENT\nfloat a_uv_x=a_packed[0];float a_split_index=a_packed[1];float a_linesofar=a_packed[2];highp float texel_height=1.0/u_image_height;highp float half_texel_height=0.5*texel_height;v_uv=vec2(a_uv_x,a_split_index*texel_height-half_texel_height);\n#endif\n#ifdef RENDER_LINE_DASH\nfloat tileZoomRatio=u_scale.x;float fromScale=u_scale.y;float toScale=u_scale.z;float scaleA=dash_from.z==0.0 ? 0.0 : tileZoomRatio/(dash_from.z*fromScale);float scaleB=dash_to.z==0.0 ? 0.0 : tileZoomRatio/(dash_to.z*toScale);float heightA=dash_from.y;float heightB=dash_to.y;v_tex_a=vec2(a_linesofar*scaleA/floorwidth,(-normal.y*heightA+dash_from.x+0.5)/u_texsize.y);v_tex_b=vec2(a_linesofar*scaleB/floorwidth,(-normal.y*heightB+dash_to.x+0.5)/u_texsize.y);\n#endif\nv_width2=vec2(outset,inset);\n#ifdef FOG\nv_fog_pos=fog_position(pos);\n#endif\n}"),linePattern:$t("uniform lowp float u_device_pixel_ratio;uniform vec2 u_texsize;uniform float u_fade;uniform mediump vec3 u_scale;uniform sampler2D u_image;varying vec2 v_normal;varying vec2 v_width2;varying float v_linesofar;varying float v_gamma_scale;varying float v_width;\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;float tileZoomRatio=u_scale.x;float fromScale=u_scale.y;float toScale=u_scale.z;vec2 display_size_a=(pattern_br_a-pattern_tl_a)/pixel_ratio_from;vec2 display_size_b=(pattern_br_b-pattern_tl_b)/pixel_ratio_to;vec2 pattern_size_a=vec2(display_size_a.x*fromScale/tileZoomRatio,display_size_a.y);vec2 pattern_size_b=vec2(display_size_b.x*toScale/tileZoomRatio,display_size_b.y);float aspect_a=display_size_a.y/v_width;float aspect_b=display_size_b.y/v_width;float dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);float x_a=mod(v_linesofar/pattern_size_a.x*aspect_a,1.0);float x_b=mod(v_linesofar/pattern_size_b.x*aspect_b,1.0);float y=0.5*v_normal.y+0.5;vec2 texel_size=1.0/u_texsize;vec2 pos_a=mix(pattern_tl_a*texel_size-texel_size,pattern_br_a*texel_size+texel_size,vec2(x_a,y));vec2 pos_b=mix(pattern_tl_b*texel_size-texel_size,pattern_br_b*texel_size+texel_size,vec2(x_b,y));vec4 color=mix(texture2D(u_image,pos_a),texture2D(u_image,pos_b),u_fade);\n#ifdef FOG\ncolor=fog_dither(fog_apply_premultiplied(color,v_fog_pos));\n#endif\ngl_FragColor=color*(alpha*opacity);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","\n#define scale 0.015873016\nattribute vec2 a_pos_normal;attribute vec4 a_data;attribute float a_linesofar;uniform mat4 u_matrix;uniform vec2 u_units_to_pixels;uniform mat2 u_pixels_to_tile_units;uniform lowp float u_device_pixel_ratio;varying vec2 v_normal;varying vec2 v_width2;varying float v_linesofar;varying float v_gamma_scale;varying float v_width;\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define mediump float width\n#pragma mapbox: define lowp float floorwidth\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize mediump float width\n#pragma mapbox: initialize lowp float floorwidth\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*scale;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*scale*normal.y*mat2(t,-u,u,t);vec4 projected_extrude=u_matrix*vec4(dist*u_pixels_to_tile_units,0.0,0.0);gl_Position=u_matrix*vec4(pos+offset2*u_pixels_to_tile_units,0.0,1.0)+projected_extrude;\n#ifndef RENDER_TO_TEXTURE\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length(projected_extrude.xy/gl_Position.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#else\nv_gamma_scale=1.0;\n#endif\nv_linesofar=a_linesofar;v_width2=vec2(outset,inset);v_width=floorwidth;\n#ifdef FOG\nv_fog_pos=fog_position(pos);\n#endif\n}"),raster:$t("uniform float u_fade_t;uniform float u_opacity;uniform sampler2D u_image0;uniform sampler2D u_image1;varying vec2 v_pos0;varying vec2 v_pos1;uniform float u_brightness_low;uniform float u_brightness_high;uniform float u_saturation_factor;uniform float u_contrast_factor;uniform vec3 u_spin_weights;void main() {vec4 color0=texture2D(u_image0,v_pos0);vec4 color1=texture2D(u_image1,v_pos1);if (color0.a > 0.0) {color0.rgb=color0.rgb/color0.a;}if (color1.a > 0.0) {color1.rgb=color1.rgb/color1.a;}vec4 color=mix(color0,color1,u_fade_t);color.a*=u_opacity;vec3 rgb=color.rgb;rgb=vec3(\ndot(rgb,u_spin_weights.xyz),dot(rgb,u_spin_weights.zxy),dot(rgb,u_spin_weights.yzx));float average=(color.r+color.g+color.b)/3.0;rgb+=(average-rgb)*u_saturation_factor;rgb=(rgb-0.5)*u_contrast_factor+0.5;vec3 u_high_vec=vec3(u_brightness_low,u_brightness_low,u_brightness_low);vec3 u_low_vec=vec3(u_brightness_high,u_brightness_high,u_brightness_high);vec3 out_color=mix(u_high_vec,u_low_vec,rgb);\n#ifdef FOG\nout_color=fog_dither(fog_apply(out_color,v_fog_pos));\n#endif\ngl_FragColor=vec4(out_color*color.a,color.a);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_tl_parent;uniform float u_scale_parent;uniform vec2 u_perspective_transform;attribute vec2 a_pos;attribute vec2 a_texture_pos;varying vec2 v_pos0;varying vec2 v_pos1;void main() {float w=1.0+dot(a_texture_pos,u_perspective_transform);gl_Position=u_matrix*vec4(a_pos*w,0,w);v_pos0=a_texture_pos/8192.0;v_pos1=(v_pos0*u_scale_parent)+u_tl_parent;\n#ifdef FOG\nv_fog_pos=fog_position(a_pos);\n#endif\n}"),symbolIcon:$t("uniform sampler2D u_texture;varying vec2 v_tex;varying float v_fade_opacity;\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\nlowp float alpha=opacity*v_fade_opacity;gl_FragColor=texture2D(u_texture,v_tex)*alpha;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","attribute vec4 a_pos_offset;attribute vec4 a_tex_size;attribute vec4 a_pixeloffset;attribute vec4 a_z_tile_anchor;attribute vec3 a_projected_pos;attribute float a_fade_opacity;uniform bool u_is_size_zoom_constant;uniform bool u_is_size_feature_constant;uniform highp float u_size_t;uniform highp float u_size;uniform highp float u_camera_to_center_distance;uniform highp float u_pitch;uniform bool u_rotate_symbol;uniform highp float u_aspect_ratio;uniform float u_fade_change;uniform mat4 u_inv_rot_matrix;uniform vec2 u_merc_center;uniform vec3 u_tile_id;uniform float u_zoom_transition;uniform mat4 u_matrix;uniform mat4 u_label_plane_matrix;uniform mat4 u_coord_matrix;uniform bool u_is_text;uniform bool u_pitch_with_map;uniform vec2 u_texsize;varying vec2 v_tex;varying float v_fade_opacity;\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\nvec2 a_pos=a_pos_offset.xy;vec2 a_offset=a_pos_offset.zw;vec2 a_tex=a_tex_size.xy;vec2 a_size=a_tex_size.zw;float a_size_min=floor(a_size[0]*0.5);vec2 a_pxoffset=a_pixeloffset.xy;vec2 a_minFontScale=a_pixeloffset.zw/256.0;highp float segment_angle=-a_projected_pos[2];float size;if (!u_is_size_zoom_constant && !u_is_size_feature_constant) {size=mix(a_size_min,a_size[1],u_size_t)/128.0;} else if (u_is_size_zoom_constant && !u_is_size_feature_constant) {size=a_size_min/128.0;} else {size=u_size;}float anchorZ=a_z_tile_anchor.x;vec2 tileAnchor=a_z_tile_anchor.yz;vec3 h=elevationVector(tileAnchor)*elevation(tileAnchor);vec3 mercator_pos=mercator_tile_position(u_inv_rot_matrix,tileAnchor,u_tile_id,u_merc_center);vec3 world_pos=mix_globe_mercator(vec3(a_pos,anchorZ)+h,mercator_pos,u_zoom_transition);vec4 projectedPoint=u_matrix*vec4(world_pos,1);highp float camera_to_anchor_distance=projectedPoint.w;highp float distance_ratio=u_pitch_with_map ?\ncamera_to_anchor_distance/u_camera_to_center_distance :\nu_camera_to_center_distance/camera_to_anchor_distance;highp float perspective_ratio=clamp(\n0.5+0.5*distance_ratio,0.0,1.5);size*=perspective_ratio;float fontScale=u_is_text ? size/24.0 : size;highp float symbol_rotation=0.0;if (u_rotate_symbol) {vec4 offsetProjectedPoint=u_matrix*vec4(a_pos+vec2(1,0),anchorZ,1);vec2 a=projectedPoint.xy/projectedPoint.w;vec2 b=offsetProjectedPoint.xy/offsetProjectedPoint.w;symbol_rotation=atan((b.y-a.y)/u_aspect_ratio,b.x-a.x);}vec3 proj_pos=mix_globe_mercator(vec3(a_projected_pos.xy,anchorZ),mercator_pos,u_zoom_transition);\n#ifdef PROJECTED_POS_ON_VIEWPORT\nvec4 projected_pos=u_label_plane_matrix*vec4(proj_pos.xy,0.0,1.0);\n#else\nvec4 projected_pos=u_label_plane_matrix*vec4(proj_pos.xyz+h,1.0);\n#endif\nhighp float angle_sin=sin(segment_angle+symbol_rotation);highp float angle_cos=cos(segment_angle+symbol_rotation);mat2 rotation_matrix=mat2(angle_cos,-1.0*angle_sin,angle_sin,angle_cos);float z=0.0;vec2 offset=rotation_matrix*(a_offset/32.0*max(a_minFontScale,fontScale)+a_pxoffset/16.0);\n#ifdef PITCH_WITH_MAP_TERRAIN\nvec4 tile_pos=u_label_plane_matrix_inv*vec4(a_projected_pos.xy+offset,0.0,1.0);z=elevation(tile_pos.xy);\n#endif\nfloat occlusion_fade=occlusionFade(projectedPoint);gl_Position=mix(u_coord_matrix*vec4(projected_pos.xy/projected_pos.w+offset,z,1.0),AWAY,float(projectedPoint.w <=0.0 || occlusion_fade==0.0));float projection_transition_fade=1.0;\n#if defined(PROJECTED_POS_ON_VIEWPORT) && defined(PROJECTION_GLOBE_VIEW)\nprojection_transition_fade=1.0-step(EPSILON,u_zoom_transition);\n#endif\nv_tex=a_tex/u_texsize;vec2 fade_opacity=unpack_opacity(a_fade_opacity);float fade_change=fade_opacity[1] > 0.5 ? u_fade_change :-u_fade_change;v_fade_opacity=max(0.0,min(occlusion_fade,fade_opacity[0]+fade_change))*projection_transition_fade;}"),symbolSDF:$t("#define SDF_PX 8.0\nuniform bool u_is_halo;uniform sampler2D u_texture;uniform highp float u_gamma_scale;uniform lowp float u_device_pixel_ratio;uniform bool u_is_text;varying vec2 v_data0;varying vec3 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nfloat EDGE_GAMMA=0.105/u_device_pixel_ratio;vec2 tex=v_data0.xy;float gamma_scale=v_data1.x;float size=v_data1.y;float fade_opacity=v_data1[2];float fontScale=u_is_text ? size/24.0 : size;lowp vec4 color=fill_color;highp float gamma=EDGE_GAMMA/(fontScale*u_gamma_scale);lowp float buff=(256.0-64.0)/256.0;if (u_is_halo) {color=halo_color;gamma=(halo_blur*1.19/SDF_PX+EDGE_GAMMA)/(fontScale*u_gamma_scale);buff=(6.0-halo_width/fontScale)/SDF_PX;}lowp float dist=texture2D(u_texture,tex).a;highp float gamma_scaled=gamma*gamma_scale;highp float alpha=smoothstep(buff-gamma_scaled,buff+gamma_scaled,dist);gl_FragColor=color*(alpha*opacity*fade_opacity);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","attribute vec4 a_pos_offset;attribute vec4 a_tex_size;attribute vec4 a_pixeloffset;attribute vec4 a_z_tile_anchor;attribute vec3 a_projected_pos;attribute float a_fade_opacity;uniform bool u_is_size_zoom_constant;uniform bool u_is_size_feature_constant;uniform highp float u_size_t;uniform highp float u_size;uniform mat4 u_matrix;uniform mat4 u_label_plane_matrix;uniform mat4 u_inv_rot_matrix;uniform vec2 u_merc_center;uniform mat4 u_coord_matrix;uniform bool u_is_text;uniform bool u_pitch_with_map;uniform highp float u_pitch;uniform bool u_rotate_symbol;uniform highp float u_aspect_ratio;uniform highp float u_camera_to_center_distance;uniform float u_fade_change;uniform vec2 u_texsize;uniform vec3 u_tile_id;uniform float u_zoom_transition;varying vec2 v_data0;varying vec3 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nvec2 a_pos=a_pos_offset.xy;vec2 a_offset=a_pos_offset.zw;vec2 a_tex=a_tex_size.xy;vec2 a_size=a_tex_size.zw;float a_size_min=floor(a_size[0]*0.5);vec2 a_pxoffset=a_pixeloffset.xy;highp float segment_angle=-a_projected_pos[2];float size;if (!u_is_size_zoom_constant && !u_is_size_feature_constant) {size=mix(a_size_min,a_size[1],u_size_t)/128.0;} else if (u_is_size_zoom_constant && !u_is_size_feature_constant) {size=a_size_min/128.0;} else {size=u_size;}float anchorZ=a_z_tile_anchor.x;vec2 tileAnchor=a_z_tile_anchor.yz;vec3 h=elevationVector(tileAnchor)*elevation(tileAnchor);vec3 mercator_pos=mercator_tile_position(u_inv_rot_matrix,tileAnchor,u_tile_id,u_merc_center);vec3 world_pos=mix_globe_mercator(vec3(a_pos,anchorZ)+h,mercator_pos,u_zoom_transition);vec4 projectedPoint=u_matrix*vec4(world_pos,1);highp float camera_to_anchor_distance=projectedPoint.w;highp float distance_ratio=u_pitch_with_map ?\ncamera_to_anchor_distance/u_camera_to_center_distance :\nu_camera_to_center_distance/camera_to_anchor_distance;highp float perspective_ratio=clamp(\n0.5+0.5*distance_ratio,0.0,1.5);size*=perspective_ratio;float fontScale=u_is_text ? size/24.0 : size;highp float symbol_rotation=0.0;if (u_rotate_symbol) {vec4 offsetProjectedPoint=u_matrix*vec4(a_pos+vec2(1,0),anchorZ,1);vec2 a=projectedPoint.xy/projectedPoint.w;vec2 b=offsetProjectedPoint.xy/offsetProjectedPoint.w;symbol_rotation=atan((b.y-a.y)/u_aspect_ratio,b.x-a.x);}vec3 proj_pos=mix_globe_mercator(vec3(a_projected_pos.xy,anchorZ),mercator_pos,u_zoom_transition);\n#ifdef PROJECTED_POS_ON_VIEWPORT\nvec4 projected_pos=u_label_plane_matrix*vec4(proj_pos.xy,0.0,1.0);\n#else\nvec4 projected_pos=u_label_plane_matrix*vec4(proj_pos.xyz+h,1.0);\n#endif\nhighp float angle_sin=sin(segment_angle+symbol_rotation);highp float angle_cos=cos(segment_angle+symbol_rotation);mat2 rotation_matrix=mat2(angle_cos,-1.0*angle_sin,angle_sin,angle_cos);float z=0.0;vec2 offset=rotation_matrix*(a_offset/32.0*fontScale+a_pxoffset);\n#ifdef PITCH_WITH_MAP_TERRAIN\nvec4 tile_pos=u_label_plane_matrix_inv*vec4(a_projected_pos.xy+offset,0.0,1.0);z=elevation(tile_pos.xy);\n#endif\nfloat occlusion_fade=occlusionFade(projectedPoint);gl_Position=mix(u_coord_matrix*vec4(projected_pos.xy/projected_pos.w+offset,z,1.0),AWAY,float(projectedPoint.w <=0.0 || occlusion_fade==0.0));float gamma_scale=gl_Position.w;float projection_transition_fade=1.0;\n#if defined(PROJECTED_POS_ON_VIEWPORT) && defined(PROJECTION_GLOBE_VIEW)\nprojection_transition_fade=1.0-step(EPSILON,u_zoom_transition);\n#endif\nvec2 fade_opacity=unpack_opacity(a_fade_opacity);float fade_change=fade_opacity[1] > 0.5 ? u_fade_change :-u_fade_change;float interpolated_fade_opacity=max(0.0,min(occlusion_fade,fade_opacity[0]+fade_change));v_data0=a_tex/u_texsize;v_data1=vec3(gamma_scale,size,interpolated_fade_opacity*projection_transition_fade);}"),symbolTextAndIcon:$t("#define SDF_PX 8.0\n#define SDF 1.0\n#define ICON 0.0\nuniform bool u_is_halo;uniform sampler2D u_texture;uniform sampler2D u_texture_icon;uniform highp float u_gamma_scale;uniform lowp float u_device_pixel_ratio;varying vec4 v_data0;varying vec4 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nfloat fade_opacity=v_data1[2];if (v_data1.w==ICON) {vec2 tex_icon=v_data0.zw;lowp float alpha=opacity*fade_opacity;gl_FragColor=texture2D(u_texture_icon,tex_icon)*alpha;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\nreturn;}vec2 tex=v_data0.xy;float EDGE_GAMMA=0.105/u_device_pixel_ratio;float gamma_scale=v_data1.x;float size=v_data1.y;float fontScale=size/24.0;lowp vec4 color=fill_color;highp float gamma=EDGE_GAMMA/(fontScale*u_gamma_scale);lowp float buff=(256.0-64.0)/256.0;if (u_is_halo) {color=halo_color;gamma=(halo_blur*1.19/SDF_PX+EDGE_GAMMA)/(fontScale*u_gamma_scale);buff=(6.0-halo_width/fontScale)/SDF_PX;}lowp float dist=texture2D(u_texture,tex).a;highp float gamma_scaled=gamma*gamma_scale;highp float alpha=smoothstep(buff-gamma_scaled,buff+gamma_scaled,dist);gl_FragColor=color*(alpha*opacity*fade_opacity);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","attribute vec4 a_pos_offset;attribute vec4 a_tex_size;attribute vec4 a_z_tile_anchor;attribute vec3 a_projected_pos;attribute float a_fade_opacity;uniform bool u_is_size_zoom_constant;uniform bool u_is_size_feature_constant;uniform highp float u_size_t;uniform highp float u_size;uniform mat4 u_matrix;uniform mat4 u_label_plane_matrix;uniform mat4 u_coord_matrix;uniform bool u_is_text;uniform bool u_pitch_with_map;uniform highp float u_pitch;uniform bool u_rotate_symbol;uniform highp float u_aspect_ratio;uniform highp float u_camera_to_center_distance;uniform float u_fade_change;uniform vec2 u_texsize;uniform vec2 u_texsize_icon;uniform mat4 u_inv_rot_matrix;uniform vec2 u_merc_center;uniform vec3 u_tile_id;uniform float u_zoom_transition;varying vec4 v_data0;varying vec4 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nvec2 a_pos=a_pos_offset.xy;vec2 a_offset=a_pos_offset.zw;vec2 a_tex=a_tex_size.xy;vec2 a_size=a_tex_size.zw;float a_size_min=floor(a_size[0]*0.5);float is_sdf=a_size[0]-2.0*a_size_min;highp float segment_angle=-a_projected_pos[2];float size;if (!u_is_size_zoom_constant && !u_is_size_feature_constant) {size=mix(a_size_min,a_size[1],u_size_t)/128.0;} else if (u_is_size_zoom_constant && !u_is_size_feature_constant) {size=a_size_min/128.0;} else {size=u_size;}float anchorZ=a_z_tile_anchor.x;vec2 tileAnchor=a_z_tile_anchor.yz;vec3 h=elevationVector(tileAnchor)*elevation(tileAnchor);vec3 mercator_pos=mercator_tile_position(u_inv_rot_matrix,tileAnchor,u_tile_id,u_merc_center);vec3 world_pos=mix_globe_mercator(vec3(a_pos,anchorZ)+h,mercator_pos,u_zoom_transition);vec4 projectedPoint=u_matrix*vec4(world_pos,1);highp float camera_to_anchor_distance=projectedPoint.w;highp float distance_ratio=u_pitch_with_map ?\ncamera_to_anchor_distance/u_camera_to_center_distance :\nu_camera_to_center_distance/camera_to_anchor_distance;highp float perspective_ratio=clamp(\n0.5+0.5*distance_ratio,0.0,1.5);size*=perspective_ratio;float fontScale=size/24.0;highp float symbol_rotation=0.0;if (u_rotate_symbol) {vec4 offsetProjectedPoint=u_matrix*vec4(a_pos+vec2(1,0),anchorZ,1);vec2 a=projectedPoint.xy/projectedPoint.w;vec2 b=offsetProjectedPoint.xy/offsetProjectedPoint.w;symbol_rotation=atan((b.y-a.y)/u_aspect_ratio,b.x-a.x);}vec3 proj_pos=mix_globe_mercator(vec3(a_projected_pos.xy,anchorZ),mercator_pos,u_zoom_transition);\n#ifdef PROJECTED_POS_ON_VIEWPORT\nvec4 projected_pos=u_label_plane_matrix*vec4(proj_pos.xy,0.0,1.0);\n#else\nvec4 projected_pos=u_label_plane_matrix*vec4(proj_pos.xyz+h,1.0);\n#endif\nhighp float angle_sin=sin(segment_angle+symbol_rotation);highp float angle_cos=cos(segment_angle+symbol_rotation);mat2 rotation_matrix=mat2(angle_cos,-1.0*angle_sin,angle_sin,angle_cos);float z=0.0;vec2 offset=rotation_matrix*(a_offset/32.0*fontScale);\n#ifdef PITCH_WITH_MAP_TERRAIN\nvec4 tile_pos=u_label_plane_matrix_inv*vec4(a_projected_pos.xy+offset,0.0,1.0);z=elevation(tile_pos.xy);\n#endif\nfloat occlusion_fade=occlusionFade(projectedPoint);gl_Position=mix(u_coord_matrix*vec4(projected_pos.xy/projected_pos.w+offset,z,1.0),AWAY,float(projectedPoint.w <=0.0 || occlusion_fade==0.0));float gamma_scale=gl_Position.w;vec2 fade_opacity=unpack_opacity(a_fade_opacity);float fade_change=fade_opacity[1] > 0.5 ? u_fade_change :-u_fade_change;float interpolated_fade_opacity=max(0.0,min(occlusion_fade,fade_opacity[0]+fade_change));float projection_transition_fade=1.0;\n#if defined(PROJECTED_POS_ON_VIEWPORT) && defined(PROJECTION_GLOBE_VIEW)\nprojection_transition_fade=1.0-step(EPSILON,u_zoom_transition);\n#endif\nv_data0.xy=a_tex/u_texsize;v_data0.zw=a_tex/u_texsize_icon;v_data1=vec4(gamma_scale,size,interpolated_fade_opacity*projection_transition_fade,is_sdf);}"),terrainRaster:$t("uniform sampler2D u_image0;varying vec2 v_pos0;\n#ifdef FOG\nvarying float v_fog_opacity;\n#endif\nvoid main() {vec4 color=texture2D(u_image0,v_pos0);\n#ifdef FOG\ncolor=fog_dither(fog_apply_from_vert(color,v_fog_opacity));\n#endif\ngl_FragColor=color;\n#ifdef TERRAIN_WIREFRAME\ngl_FragColor=vec4(1.0,0.0,0.0,0.8);\n#endif\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform float u_skirt_height;attribute vec2 a_pos;attribute vec2 a_texture_pos;varying vec2 v_pos0;\n#ifdef FOG\nvarying float v_fog_opacity;\n#endif\nconst float skirtOffset=24575.0;const float wireframeOffset=0.00015;void main() {v_pos0=a_texture_pos/8192.0;float skirt=float(a_pos.x >=skirtOffset);float elevation=elevation(a_texture_pos)-skirt*u_skirt_height;\n#ifdef TERRAIN_WIREFRAME\nelevation+=u_skirt_height*u_skirt_height*wireframeOffset;\n#endif\nvec2 decodedPos=a_pos-vec2(skirt*skirtOffset,0.0);gl_Position=u_matrix*vec4(decodedPos,elevation,1.0);\n#ifdef FOG\nv_fog_opacity=fog(fog_position(vec3(decodedPos,elevation)));\n#endif\n}"),terrainDepth:$t("#ifdef GL_ES\nprecision highp float;\n#endif\nvarying float v_depth;void main() {gl_FragColor=pack_depth(v_depth);}","uniform mat4 u_matrix;attribute vec2 a_pos;attribute vec2 a_texture_pos;varying float v_depth;void main() {float elevation=elevation(a_texture_pos);gl_Position=u_matrix*vec4(a_pos,elevation,1.0);v_depth=gl_Position.z/gl_Position.w;}"),skybox:$t("\nvarying lowp vec3 v_uv;uniform lowp samplerCube u_cubemap;uniform lowp float u_opacity;uniform highp float u_temporal_offset;uniform highp vec3 u_sun_direction;float sun_disk(highp vec3 ray_direction,highp vec3 sun_direction) {highp float cos_angle=dot(normalize(ray_direction),sun_direction);const highp float cos_sun_angular_diameter=0.99996192306;const highp float smoothstep_delta=1e-5;return smoothstep(\ncos_sun_angular_diameter-smoothstep_delta,cos_sun_angular_diameter+smoothstep_delta,cos_angle);}float map(float value,float start,float end,float new_start,float new_end) {return ((value-start)*(new_end-new_start))/(end-start)+new_start;}void main() {vec3 uv=v_uv;const float y_bias=0.015;uv.y+=y_bias;uv.y=pow(abs(uv.y),1.0/5.0);uv.y=map(uv.y,0.0,1.0,-1.0,1.0);vec3 sky_color=textureCube(u_cubemap,uv).rgb;\n#ifdef FOG\nsky_color=fog_apply_sky_gradient(v_uv.xzy,sky_color);\n#endif\nsky_color.rgb=dither(sky_color.rgb,gl_FragCoord.xy+u_temporal_offset);sky_color+=0.1*sun_disk(v_uv,u_sun_direction);gl_FragColor=vec4(sky_color*u_opacity,u_opacity);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}",jt),skyboxGradient:$t("varying highp vec3 v_uv;uniform lowp sampler2D u_color_ramp;uniform highp vec3 u_center_direction;uniform lowp float u_radius;uniform lowp float u_opacity;uniform highp float u_temporal_offset;void main() {float progress=acos(dot(normalize(v_uv),u_center_direction))/u_radius;vec4 color=texture2D(u_color_ramp,vec2(progress,0.5));\n#ifdef FOG\ncolor.rgb=fog_apply_sky_gradient(v_uv.xzy,color.rgb/color.a)*color.a;\n#endif\ncolor*=u_opacity;color.rgb=dither(color.rgb,gl_FragCoord.xy+u_temporal_offset);gl_FragColor=color;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}",jt),skyboxCapture:$t("\nvarying highp vec3 v_position;uniform highp float u_sun_intensity;uniform highp float u_luminance;uniform lowp vec3 u_sun_direction;uniform highp vec4 u_color_tint_r;uniform highp vec4 u_color_tint_m;\n#ifdef GL_ES\nprecision highp float;\n#endif\n#define BETA_R                  vec3(5.5e-6,13.0e-6,22.4e-6)\n#define BETA_M                  vec3(21e-6,21e-6,21e-6)\n#define MIE_G                   0.76\n#define DENSITY_HEIGHT_SCALE_R  8000.0\n#define DENSITY_HEIGHT_SCALE_M  1200.0\n#define PLANET_RADIUS           6360e3\n#define ATMOSPHERE_RADIUS       6420e3\n#define SAMPLE_STEPS            10\n#define DENSITY_STEPS           4\nfloat ray_sphere_exit(vec3 orig,vec3 dir,float radius) {float a=dot(dir,dir);float b=2.0*dot(dir,orig);float c=dot(orig,orig)-radius*radius;float d=sqrt(b*b-4.0*a*c);return (-b+d)/(2.0*a);}vec3 extinction(vec2 density) {return exp(-vec3(BETA_R*u_color_tint_r.a*density.x+BETA_M*u_color_tint_m.a*density.y));}vec2 local_density(vec3 point) {float height=max(length(point)-PLANET_RADIUS,0.0);float exp_r=exp(-height/DENSITY_HEIGHT_SCALE_R);float exp_m=exp(-height/DENSITY_HEIGHT_SCALE_M);return vec2(exp_r,exp_m);}float phase_ray(float cos_angle) {return (3.0/(16.0*PI))*(1.0+cos_angle*cos_angle);}float phase_mie(float cos_angle) {return (3.0/(8.0*PI))*((1.0-MIE_G*MIE_G)*(1.0+cos_angle*cos_angle))/((2.0+MIE_G*MIE_G)*pow(1.0+MIE_G*MIE_G-2.0*MIE_G*cos_angle,1.5));}vec2 density_to_atmosphere(vec3 point,vec3 light_dir) {float ray_len=ray_sphere_exit(point,light_dir,ATMOSPHERE_RADIUS);float step_len=ray_len/float(DENSITY_STEPS);vec2 density_point_to_atmosphere=vec2(0.0);for (int i=0; i < DENSITY_STEPS;++i) {vec3 point_on_ray=point+light_dir*((float(i)+0.5)*step_len);density_point_to_atmosphere+=local_density(point_on_ray)*step_len;;}return density_point_to_atmosphere;}vec3 atmosphere(vec3 ray_dir,vec3 sun_direction,float sun_intensity) {vec2 density_orig_to_point=vec2(0.0);vec3 scatter_r=vec3(0.0);vec3 scatter_m=vec3(0.0);vec3 origin=vec3(0.0,PLANET_RADIUS,0.0);float ray_len=ray_sphere_exit(origin,ray_dir,ATMOSPHERE_RADIUS);float step_len=ray_len/float(SAMPLE_STEPS);for (int i=0; i < SAMPLE_STEPS;++i) {vec3 point_on_ray=origin+ray_dir*((float(i)+0.5)*step_len);vec2 density=local_density(point_on_ray)*step_len;density_orig_to_point+=density;vec2 density_point_to_atmosphere=density_to_atmosphere(point_on_ray,sun_direction);vec2 density_orig_to_atmosphere=density_orig_to_point+density_point_to_atmosphere;vec3 extinction=extinction(density_orig_to_atmosphere);scatter_r+=density.x*extinction;scatter_m+=density.y*extinction;}float cos_angle=dot(ray_dir,sun_direction);float phase_r=phase_ray(cos_angle);float phase_m=phase_mie(cos_angle);vec3 beta_r=BETA_R*u_color_tint_r.rgb*u_color_tint_r.a;vec3 beta_m=BETA_M*u_color_tint_m.rgb*u_color_tint_m.a;return (scatter_r*phase_r*beta_r+scatter_m*phase_m*beta_m)*sun_intensity;}const float A=0.15;const float B=0.50;const float C=0.10;const float D=0.20;const float E=0.02;const float F=0.30;vec3 uncharted2_tonemap(vec3 x) {return ((x*(A*x+C*B)+D*E)/(x*(A*x+B)+D*F))-E/F;}void main() {vec3 ray_direction=v_position;ray_direction.y=pow(ray_direction.y,5.0);const float y_bias=0.015;ray_direction.y+=y_bias;vec3 color=atmosphere(normalize(ray_direction),u_sun_direction,u_sun_intensity);float white_scale=1.0748724675633854;color=uncharted2_tonemap((log2(2.0/pow(u_luminance,4.0)))*color)*white_scale;gl_FragColor=vec4(color,1.0);}","attribute highp vec3 a_pos_3f;uniform mat3 u_matrix_3f;varying highp vec3 v_position;float map(float value,float start,float end,float new_start,float new_end) {return ((value-start)*(new_end-new_start))/(end-start)+new_start;}void main() {vec4 pos=vec4(u_matrix_3f*a_pos_3f,1.0);v_position=pos.xyz;v_position.y*=-1.0;v_position.y=map(v_position.y,-1.0,1.0,0.0,1.0);gl_Position=vec4(a_pos_3f.xy,0.0,1.0);}"),globeRaster:$t("uniform sampler2D u_image0;varying vec2 v_pos0;void main() {gl_FragColor=texture2D(u_image0,v_pos0);\n#ifdef TERRAIN_WIREFRAME\ngl_FragColor=vec4(1.0,0.0,0.0,0.8);\n#endif\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_proj_matrix;uniform mat4 u_globe_matrix;uniform mat4 u_merc_matrix;uniform float u_zoom_transition;uniform vec2 u_merc_center;attribute vec3 a_globe_pos;attribute vec2 a_merc_pos;attribute vec2 a_uv;varying vec2 v_pos0;const float wireframeOffset=1e3;void main() {v_pos0=a_uv;vec2 uv=a_uv*EXTENT;vec4 up_vector=vec4(elevationVector(uv),1.0);float height=elevation(uv);\n#ifdef TERRAIN_WIREFRAME\nheight+=wireframeOffset;\n#endif\nvec4 globe=u_globe_matrix*vec4(a_globe_pos+up_vector.xyz*height,1.0);vec4 mercator=vec4(0.0);if (u_zoom_transition > 0.0) {mercator=vec4(a_merc_pos,height,1.0);mercator.xy-=u_merc_center;mercator.x=wrap(mercator.x,-0.5,0.5);mercator=u_merc_matrix*mercator;}vec3 position=mix(globe.xyz,mercator.xyz,u_zoom_transition);gl_Position=u_proj_matrix*vec4(position,1.0);}"),globeAtmosphere:$t("uniform vec2 u_center;uniform float u_radius;uniform vec2 u_screen_size;uniform float u_opacity;uniform highp float u_fadeout_range;uniform vec3 u_start_color;uniform vec3 u_end_color;uniform float u_pixel_ratio;void main() {highp vec2 fragCoord=gl_FragCoord.xy/u_pixel_ratio;fragCoord.y=u_screen_size.y-fragCoord.y;float distFromCenter=length(fragCoord-u_center);float normDistFromCenter=length(fragCoord-u_center)/u_radius;if (normDistFromCenter < 1.0)\ndiscard;float t=clamp(1.0-sqrt(normDistFromCenter-1.0)/u_fadeout_range,0.0,1.0);vec3 color=mix(u_start_color,u_end_color,1.0-t);gl_FragColor=vec4(color*t*u_opacity,u_opacity);}","attribute vec3 a_pos;void main() {gl_Position=vec4(a_pos,1.0);}")};function $t(e,t,i){const o=/#pragma mapbox: ([\w]+) ([\w]+) ([\w]+) ([\w]+)/g,r=/uniform (highp |mediump |lowp )?([\w]+) ([\w]+)([\s]*)([\w]*)/g,n=t.match(/attribute (highp |mediump |lowp )?([\w]+) ([\w]+)/g),a=e.match(r),s=t.match(r),l=Gt.match(r);let c=s?s.concat(a):a;i||(Zt.staticUniforms&&(c=Zt.staticUniforms.concat(c)),Vt.staticUniforms&&(c=Vt.staticUniforms.concat(c))),c&&(c=c.concat(l));const h={};return {fragmentSource:e=e.replace(o,((e,t,i,o,r)=>(h[r]=!0,"define"===t?`\n#ifndef HAS_UNIFORM_u_${r}\nvarying ${i} ${o} ${r};\n#else\nuniform ${i} ${o} u_${r};\n#endif\n`:`\n#ifdef HAS_UNIFORM_u_${r}\n    ${i} ${o} ${r} = u_${r};\n#endif\n`))),vertexSource:t=t.replace(o,((e,t,i,o,r)=>{const n="float"===o?"vec2":"vec4",a=r.match(/color/)?"color":n;return h[r]?"define"===t?`\n#ifndef HAS_UNIFORM_u_${r}\nuniform lowp float u_${r}_t;\nattribute ${i} ${n} a_${r};\nvarying ${i} ${o} ${r};\n#else\nuniform ${i} ${o} u_${r};\n#endif\n`:"vec4"===a?`\n#ifndef HAS_UNIFORM_u_${r}\n    ${r} = a_${r};\n#else\n    ${i} ${o} ${r} = u_${r};\n#endif\n`:`\n#ifndef HAS_UNIFORM_u_${r}\n    ${r} = unpack_mix_${a}(a_${r}, u_${r}_t);\n#else\n    ${i} ${o} ${r} = u_${r};\n#endif\n`:"define"===t?`\n#ifndef HAS_UNIFORM_u_${r}\nuniform lowp float u_${r}_t;\nattribute ${i} ${n} a_${r};\n#else\nuniform ${i} ${o} u_${r};\n#endif\n`:"vec4"===a?`\n#ifndef HAS_UNIFORM_u_${r}\n    ${i} ${o} ${r} = a_${r};\n#else\n    ${i} ${o} ${r} = u_${r};\n#endif\n`:`\n#ifndef HAS_UNIFORM_u_${r}\n    ${i} ${o} ${r} = unpack_mix_${a}(a_${r}, u_${r}_t);\n#else\n    ${i} ${o} ${r} = u_${r};\n#endif\n`})),staticAttributes:n,staticUniforms:c}}class Ht{constructor(){this.boundProgram=null,this.boundLayoutVertexBuffer=null,this.boundPaintVertexBuffers=[],this.boundIndexBuffer=null,this.boundVertexOffset=null,this.boundDynamicVertexBuffer=null,this.vao=null;}bind(e,t,i,o,r,n,a,s){this.context=e;let l=this.boundPaintVertexBuffers.length!==o.length;for(let e=0;!l&&e<o.length;e++)this.boundPaintVertexBuffers[e]!==o[e]&&(l=!0);e.extVertexArrayObject&&this.vao&&this.boundProgram===t&&this.boundLayoutVertexBuffer===i&&!l&&this.boundIndexBuffer===r&&this.boundVertexOffset===n&&this.boundDynamicVertexBuffer===a&&this.boundDynamicVertexBuffer2===s?(e.bindVertexArrayOES.set(this.vao),a&&a.bind(),r&&r.dynamicDraw&&r.bind(),s&&s.bind()):this.freshBind(t,i,o,r,n,a,s);}freshBind(e,t,i,o,r,n,a){let s;const l=e.numAttributes,c=this.context,h=c.gl;if(c.extVertexArrayObject)this.vao&&this.destroy(),this.vao=c.extVertexArrayObject.createVertexArrayOES(),c.bindVertexArrayOES.set(this.vao),s=0,this.boundProgram=e,this.boundLayoutVertexBuffer=t,this.boundPaintVertexBuffers=i,this.boundIndexBuffer=o,this.boundVertexOffset=r,this.boundDynamicVertexBuffer=n,this.boundDynamicVertexBuffer2=a;else {s=c.currentNumAttributes||0;for(let e=l;e<s;e++)h.disableVertexAttribArray(e);}t.enableAttributes(h,e);for(const t of i)t.enableAttributes(h,e);n&&n.enableAttributes(h,e),a&&a.enableAttributes(h,e),t.bind(),t.setVertexAttribPointers(h,e,r);for(const t of i)t.bind(),t.setVertexAttribPointers(h,e,r);n&&(n.bind(),n.setVertexAttribPointers(h,e,r)),o&&o.bind(),a&&(a.bind(),a.setVertexAttribPointers(h,e,r)),c.currentNumAttributes=l;}destroy(){this.vao&&(this.context.extVertexArrayObject.deleteVertexArrayOES(this.vao),this.vao=null);}}function Kt(t,i){const o=Math.pow(2,i.canonical.z),r=i.canonical.y;return [new e.MercatorCoordinate(0,r/o).toLngLat().lat,new e.MercatorCoordinate(0,(r+1)/o).toLngLat().lat]}function Yt(t,i,o,r,n,a,s){const l=t.context,c=l.gl,h=o.fbo;if(!h)return;t.prepareDrawTile(i);const u=t.useProgram("hillshade");l.activeTexture.set(c.TEXTURE0),c.bindTexture(c.TEXTURE_2D,h.colorAttachment.get());const _=((e,t,i,o)=>{const r=i.paint.get("hillshade-shadow-color"),n=i.paint.get("hillshade-highlight-color"),a=i.paint.get("hillshade-accent-color");let s=i.paint.get("hillshade-illumination-direction")*(Math.PI/180);"viewport"===i.paint.get("hillshade-illumination-anchor")&&(s-=e.transform.angle);const l=!e.options.moving;return {u_matrix:o||e.transform.calculateProjMatrix(t.tileID.toUnwrapped(),l),u_image:0,u_latrange:Kt(0,t.tileID),u_light:[i.paint.get("hillshade-exaggeration"),s],u_shadow:r,u_highlight:n,u_accent:a}})(t,o,r,t.terrain?i.projMatrix:null);t.prepareDrawProgram(l,u,i.toUnwrapped());const{tileBoundsBuffer:d,tileBoundsIndexBuffer:p,tileBoundsSegments:m}=t.getTileBoundsBuffers(o);u.draw(l,c.TRIANGLES,n,a,s,e.CullFaceMode.disabled,_,r.id,d,p,m);}function Jt(t,i,o){if(!i.needsDEMTextureUpload)return;const r=t.context,n=r.gl;r.pixelStoreUnpackPremultiplyAlpha.set(!1),i.demTexture=i.demTexture||t.getTileTexture(o.stride);const a=o.getPixels();i.demTexture?i.demTexture.update(a,{premultiply:!1}):i.demTexture=new e.Texture(r,a,n.RGBA,{premultiply:!1}),i.needsDEMTextureUpload=!1;}function Qt(t,i,o,r,n,a){const s=t.context,l=s.gl;if(!i.dem)return;const c=i.dem;if(s.activeTexture.set(l.TEXTURE1),Jt(t,i,c),!i.demTexture)return;i.demTexture.bind(l.NEAREST,l.CLAMP_TO_EDGE);const h=c.dim;s.activeTexture.set(l.TEXTURE0);let u=i.fbo;if(!u){const t=new e.Texture(s,{width:h,height:h,data:null},l.RGBA);t.bind(l.LINEAR,l.CLAMP_TO_EDGE),u=i.fbo=s.createFramebuffer(h,h,!0),u.colorAttachment.set(t.texture);}s.bindFramebuffer.set(u.framebuffer),s.viewport.set([0,0,h,h]);const{tileBoundsBuffer:_,tileBoundsIndexBuffer:d,tileBoundsSegments:p}=t.getMercatorTileBoundsBuffers();t.useProgram("hillshadePrepare").draw(s,l.TRIANGLES,r,n,a,e.CullFaceMode.disabled,((t,i)=>{const o=i.stride,r=e.create();return e.ortho(r,0,e.EXTENT,-e.EXTENT,0,0,1),e.translate(r,r,[0,-e.EXTENT,0]),{u_matrix:r,u_image:1,u_dimension:[o,o],u_zoom:t.overscaledZ,u_unpack:i.unpackVector}})(i.tileID,c),o.id,_,d,p),i.needsHillshadePrepare=!1;}const ei=(t,i)=>({u_matrix:new e.UniformMatrix4f(t,i.u_matrix),u_image0:new e.Uniform1i(t,i.u_image0),u_skirt_height:new e.Uniform1f(t,i.u_skirt_height)}),ti=(e,t)=>({u_matrix:e,u_image0:0,u_skirt_height:t}),ii=(e,t,i,o,r)=>({u_proj_matrix:Float32Array.from(e),u_globe_matrix:t,u_merc_matrix:i,u_zoom_transition:o,u_merc_center:r,u_image0:0});function oi(e,t){return null!=e&&null!=t&&!(!e.hasData()||!t.hasData())&&null!=e.demTexture&&null!=t.demTexture&&e.tileID.key!==t.tileID.key}const ri=new class{constructor(){this.operations={};}newMorphing(e,t,i,o,r){if(e in this.operations){const t=this.operations[e];t.to.tileID.key!==i.tileID.key&&(t.queued=i);}else this.operations[e]={startTime:o,phase:0,duration:r,from:t,to:i,queued:null};}getMorphValuesForProxy(e){if(!(e in this.operations))return null;const t=this.operations[e];return {from:t.from,to:t.to,phase:t.phase}}update(e){for(const t in this.operations){const i=this.operations[t];for(i.phase=(e-i.startTime)/i.duration;i.phase>=1||!this._validOp(i);)if(!this._nextOp(i,e)){delete this.operations[t];break}}}_nextOp(e,t){return !!e.queued&&(e.from=e.to,e.to=e.queued,e.queued=null,e.phase=0,e.startTime=t,!0)}_validOp(e){return e.from.hasData()&&e.to.hasData()}},ni={0:null,1:"TERRAIN_VERTEX_MORPHING",2:"TERRAIN_WIREFRAME"};function ai(e,t){const i=1<<e.z;return !t&&(0===e.x||e.x===i-1)||0===e.y||e.y===i-1}const si=e=>({u_matrix:e});function li(t,i,o,r,n){if(n>0){const a=e.exported.now(),s=(a-t.timeAdded)/n,l=i?(a-i.timeAdded)/n:-1,c=o.getSource(),h=r.coveringZoomLevel({tileSize:c.tileSize,roundZoom:c.roundZoom}),u=!i||Math.abs(i.tileID.overscaledZ-h)>Math.abs(t.tileID.overscaledZ-h),_=u&&t.refreshedUponExpiration?1:e.clamp(u?s:1-l,0,1);return t.refreshedUponExpiration&&s>=1&&(t.refreshedUponExpiration=!1),i?{opacity:1,mix:1-_}:{opacity:_,mix:0}}return {opacity:1,mix:0}}class ci extends e.SourceCache{constructor(e){const t={type:"raster-dem",maxzoom:e.transform.maxZoom},i=new C(Ae(),null),o=Te("mock-dem",t,i,e.style);super("mock-dem",o,!1),o.setEventedParent(this),this._sourceLoaded=!0;}_loadTile(e,t){e.state="loaded",t(null);}}class hi extends e.SourceCache{constructor(e){const t=Te("proxy",{type:"geojson",maxzoom:e.transform.maxZoom},new C(Ae(),null),e.style);super("proxy",t,!1),t.setEventedParent(this),this.map=this.getSource().map=e,this.used=this._sourceLoaded=!0,this.renderCache=[],this.renderCachePool=[],this.proxyCachedFBO={};}update(t,i,o){if(t.freezeTileCoverage)return;this.transform=t;const r=t.coveringTiles({tileSize:this._source.tileSize,minzoom:this._source.minzoom,maxzoom:this._source.maxzoom,roundZoom:this._source.roundZoom,reparseOverscaled:this._source.reparseOverscaled}).reduce(((i,o)=>{if(i[o.key]="",!this._tiles[o.key]){const i=new e.Tile(o,this._source.tileSize*o.overscaleFactor(),t.tileZoom);i.state="loaded",this._tiles[o.key]=i;}return i}),{});for(const e in this._tiles)e in r||(this.freeFBO(e),this._tiles[e].unloadVectorData(),delete this._tiles[e]);}freeFBO(e){const t=this.proxyCachedFBO[e];if(void 0!==t){const i=Object.values(t);this.renderCachePool.push(...i),delete this.proxyCachedFBO[e];}}deallocRenderCache(){this.renderCache.forEach((e=>e.fb.destroy())),this.renderCache=[],this.renderCachePool=[],this.proxyCachedFBO={};}}class ui extends e.OverscaledTileID{constructor(e,t,i){super(e.overscaledZ,e.wrap,e.canonical.z,e.canonical.x,e.canonical.y),this.proxyTileKey=t,this.projMatrix=i;}}class _i extends e.Elevation{constructor(t,i){super(),this.painter=t,this.terrainTileForTile={},this.prevTerrainTileForTile={};const[o,r,n]=function(t){const i=new e.StructArrayLayout4i8,o=new e.StructArrayLayout3ui6,r=131;i.reserve(17161),o.reserve(33800);const n=e.EXTENT/128,a=e.EXTENT+n/2,s=a+n;for(let t=-n;t<s;t+=n)for(let o=-n;o<s;o+=n){const r=o<0||o>a||t<0||t>a?24575:0,n=e.clamp(Math.round(o),0,e.EXTENT),s=e.clamp(Math.round(t),0,e.EXTENT);i.emplaceBack(n+r,s,n,s);}const l=(e,t)=>{const i=t*r+e;o.emplaceBack(i+1,i,i+r),o.emplaceBack(i+r,i+r+1,i+1);};for(let e=1;e<129;e++)for(let t=1;t<129;t++)l(t,e);return [0,129].forEach((e=>{for(let t=0;t<130;t++)l(t,e),l(e,t);})),[i,o,32768]}(),a=t.context;this.gridBuffer=a.createVertexBuffer(o,e.boundsAttributes.members),this.gridIndexBuffer=a.createIndexBuffer(r),this.gridSegments=e.SegmentVector.simpleSegment(0,0,o.length,r.length),this.gridNoSkirtSegments=e.SegmentVector.simpleSegment(0,0,o.length,n),this.proxyCoords=[],this.proxiedCoords={},this._visibleDemTiles=[],this._drapedRenderBatches=[],this._sourceTilesOverlap={},this.proxySourceCache=new hi(i.map),this.orthoMatrix=e.create(),e.ortho(this.orthoMatrix,0,e.EXTENT,0,e.EXTENT,0,1);const s=a.gl;this._overlapStencilMode=new e.StencilMode({func:s.GEQUAL,mask:255},0,255,s.KEEP,s.KEEP,s.REPLACE),this._previousZoom=t.transform.zoom,this.pool=[],this._findCoveringTileCache={},this._tilesDirty={},this.style=i,this._useVertexMorphing=!0,this._exaggeration=1,this._mockSourceCache=new ci(i.map);}set style(e){e.on("data",this._onStyleDataEvent.bind(this)),e.on("neworder",this._checkRenderCacheEfficiency.bind(this)),this._style=e,this._checkRenderCacheEfficiency();}update(t,i,o){if(t&&t.terrain){this._style!==t&&(this.style=t),this.enabled=!0;const r=t.terrain.properties;this.sourceCache=0===t.terrain.drapeRenderMode?this._mockSourceCache:t._getSourceCache(r.get("source")),this._exaggeration=r.get("exaggeration");const n=()=>{this.sourceCache.used&&e.warnOnce(`Raster DEM source '${this.sourceCache.id}' is used both for terrain and as layer source.\nThis leads to lower resolution of hillshade. For full hillshade resolution but higher memory consumption, define another raster DEM source.`);const t=this.getScaledDemTileSize();this.sourceCache.update(i,t,!0),this.resetTileLookupCache(this.sourceCache.id);};this.sourceCache.usedForTerrain||(this.resetTileLookupCache(this.sourceCache.id),this.sourceCache.usedForTerrain=!0,n(),this._initializing=!0),n(),i.updateElevation(!o),this.resetTileLookupCache(this.proxySourceCache.id),this.proxySourceCache.update(i),this._emptyDEMTextureDirty=!0;}else this._disable();}resetTileLookupCache(e){this._findCoveringTileCache[e]={};}getScaledDemTileSize(){return this.sourceCache.getSource().tileSize/128*this.proxySourceCache.getSource().tileSize}_checkRenderCacheEfficiency(){const t=this.renderCacheEfficiency(this._style);this._style.map._optimizeForTerrain||100!==t.efficiency&&e.warnOnce(`Terrain render cache efficiency is not optimal (${t.efficiency}%) and performance\n                may be affected negatively, consider placing all background, fill and line layers before layer\n                with id '${t.firstUndrapedLayer}' or create a map using optimizeForTerrain: true option.`);}_onStyleDataEvent(e){e.coord&&"source"===e.dataType?this._clearRenderCacheForTile(e.sourceCacheId,e.coord):"style"===e.dataType&&(this._invalidateRenderCache=!0);}_disable(){if(this.enabled&&(this.enabled=!1,this._sharedDepthStencil=void 0,this.proxySourceCache.deallocRenderCache(),this._style))for(const e in this._style._sourceCaches)this._style._sourceCaches[e].usedForTerrain=!1;}destroy(){this._disable(),this._emptyDEMTexture&&this._emptyDEMTexture.destroy(),this._emptyDepthBufferTexture&&this._emptyDepthBufferTexture.destroy(),this.pool.forEach((e=>e.fb.destroy())),this.pool=[],this._depthFBO&&(this._depthFBO.destroy(),delete this._depthFBO,delete this._depthTexture);}_source(){return this.enabled?this.sourceCache:null}exaggeration(){return this._exaggeration}get visibleDemTiles(){return this._visibleDemTiles}get drapeBufferSize(){const e=2*this.proxySourceCache.getSource().tileSize;return [e,e]}set useVertexMorphing(e){this._useVertexMorphing=e;}updateTileBinding(t){if(!this.enabled)return;this.prevTerrainTileForTile=this.terrainTileForTile;const i=this.proxySourceCache,o=this.painter.transform;this._initializing&&(this._initializing=0===o._centerAltitude&&-1===this.getAtPointOrZero(e.MercatorCoordinate.fromLngLat(o.center),-1),this._emptyDEMTextureDirty=!this._initializing);const r=this.proxyCoords=i.getIds().map((e=>{const t=i.getTileByID(e).tileID;return t.projMatrix=o.calculateProjMatrix(t.toUnwrapped()),t}));!function(t,i){const o=i.transform.pointCoordinate(i.transform.getCameraPoint()),r=new e.pointGeometry(o.x,o.y);t.sort(((t,i)=>{if(i.overscaledZ-t.overscaledZ)return i.overscaledZ-t.overscaledZ;const o=new e.pointGeometry(t.canonical.x+(1<<t.canonical.z)*t.wrap,t.canonical.y),n=new e.pointGeometry(i.canonical.x+(1<<i.canonical.z)*i.wrap,i.canonical.y),a=r.mult(1<<t.canonical.z);return a.x-=.5,a.y-=.5,a.distSqr(o)-a.distSqr(n)}));}(r,this.painter),this._previousZoom=o.zoom;const n=this.proxyToSource||{};this.proxyToSource={},r.forEach((e=>{this.proxyToSource[e.key]={};})),this.terrainTileForTile={};const a=this._style._sourceCaches;for(const e in a){const i=a[e];if(!i.used)continue;if(i!==this.sourceCache&&this.resetTileLookupCache(i.id),this._setupProxiedCoordsForOrtho(i,t[e],n),i.usedForTerrain)continue;const o=t[e];i.getSource().reparseOverscaled&&this._assignTerrainTiles(o);}this.proxiedCoords[i.id]=r.map((e=>new ui(e,e.key,this.orthoMatrix))),this._assignTerrainTiles(r),this._prepareDEMTextures(),this._setupDrapedRenderBatches(),this._initFBOPool(),this._setupRenderCache(n),this.renderingToTexture=!1,this._updateTimestamp=e.exported.now();const s={};this._visibleDemTiles=[];for(const e of this.proxyCoords){const t=this.terrainTileForTile[e.key];if(!t)continue;const i=t.tileID.key;i in s||(this._visibleDemTiles.push(t),s[i]=i);}}_assignTerrainTiles(e){this._initializing||e.forEach((e=>{if(this.terrainTileForTile[e.key])return;const t=this._findTileCoveringTileID(e,this.sourceCache);t&&(this.terrainTileForTile[e.key]=t);}));}_prepareDEMTextures(){const e=this.painter.context,t=e.gl;for(const i in this.terrainTileForTile){const o=this.terrainTileForTile[i],r=o.dem;!r||o.demTexture&&!o.needsDEMTextureUpload||(e.activeTexture.set(t.TEXTURE1),Jt(this.painter,o,r));}}_prepareDemTileUniforms(e,t,i,o){if(!t||null==t.demTexture)return !1;const r=e.tileID.canonical,n=Math.pow(2,t.tileID.canonical.z-r.z),a=o||"";return i[`u_dem_tl${a}`]=[r.x*n%1,r.y*n%1],i[`u_dem_scale${a}`]=n,!0}get emptyDEMTexture(){return !this._emptyDEMTextureDirty&&this._emptyDEMTexture?this._emptyDEMTexture:this._updateEmptyDEMTexture()}get emptyDepthBufferTexture(){const t=this.painter.context,i=t.gl;if(!this._emptyDepthBufferTexture){const o={width:1,height:1,data:new Uint8Array([255,255,255,255])};this._emptyDepthBufferTexture=new e.Texture(t,o,i.RGBA,{premultiply:!1});}return this._emptyDepthBufferTexture}_getLoadedAreaMinimum(){let e=0;const t=this._visibleDemTiles.reduce(((t,i)=>{if(!i.dem)return t;const o=i.dem.tree.minimums[0];return o>0&&e++,t+o}),0);return e?t/e:0}_updateEmptyDEMTexture(){const t=this.painter.context,i=t.gl;t.activeTexture.set(i.TEXTURE2);const o=this._getLoadedAreaMinimum(),r={width:1,height:1,data:new Uint8Array(e.DEMData.pack(o,this.sourceCache.getSource().encoding))};this._emptyDEMTextureDirty=!1;let n=this._emptyDEMTexture;return n?n.update(r,{premultiply:!1}):n=this._emptyDEMTexture=new e.Texture(t,r,i.RGBA,{premultiply:!1}),n}setupElevationDraw(t,i,o){const r=this.painter.context,n=r.gl,a=(s=this.sourceCache.getSource().encoding,{u_dem:2,u_dem_prev:4,u_dem_unpack:e.DEMData.getUnpackVector(s),u_dem_tl:[0,0],u_dem_tl_prev:[0,0],u_dem_scale:0,u_dem_scale_prev:0,u_dem_size:0,u_dem_lerp:1,u_depth:3,u_depth_size_inv:[0,0],u_exaggeration:0,u_tile_tl_up:[0,0,1],u_tile_tr_up:[0,0,1],u_tile_br_up:[0,0,1],u_tile_bl_up:[0,0,1],u_tile_up_scale:1});var s;a.u_dem_size=this.sourceCache.getSource().tileSize,a.u_exaggeration=this.exaggeration();const l=this.painter.transform,c=l.projection.createTileTransform(l,l.worldSize),h=t.tileID.canonical;a.u_tile_tl_up=c.upVector(h,0,0),a.u_tile_tr_up=c.upVector(h,e.EXTENT,0),a.u_tile_br_up=c.upVector(h,e.EXTENT,e.EXTENT),a.u_tile_bl_up=c.upVector(h,0,e.EXTENT),a.u_tile_up_scale=c.upVectorScale(h);let u=null,_=null,d=1;if(o&&o.morphing&&this._useVertexMorphing){const e=o.morphing.srcDemTile,i=o.morphing.dstDemTile;d=o.morphing.phase,e&&i&&(this._prepareDemTileUniforms(t,e,a,"_prev")&&(_=e),this._prepareDemTileUniforms(t,i,a)&&(u=i));}if(_&&u?(r.activeTexture.set(n.TEXTURE2),u.demTexture.bind(n.NEAREST,n.CLAMP_TO_EDGE,n.NEAREST),r.activeTexture.set(n.TEXTURE4),_.demTexture.bind(n.NEAREST,n.CLAMP_TO_EDGE,n.NEAREST),a.u_dem_lerp=d):(u=this.terrainTileForTile[t.tileID.key],r.activeTexture.set(n.TEXTURE2),(this._prepareDemTileUniforms(t,u,a)?u.demTexture:this.emptyDEMTexture).bind(n.NEAREST,n.CLAMP_TO_EDGE)),r.activeTexture.set(n.TEXTURE3),o&&o.useDepthForOcclusion?(this._depthTexture.bind(n.NEAREST,n.CLAMP_TO_EDGE),a.u_depth_size_inv=[1/this._depthFBO.width,1/this._depthFBO.height]):(this.emptyDepthBufferTexture.bind(n.NEAREST,n.CLAMP_TO_EDGE),a.u_depth_size_inv=[1,1]),o&&o.useMeterToDem&&u){const t=(1<<u.tileID.canonical.z)*e.mercatorZfromAltitude(1,this.painter.transform.center.lat)*this.sourceCache.getSource().tileSize;a.u_meter_to_dem=t;}o&&o.labelPlaneMatrixInv&&(a.u_label_plane_matrix_inv=o.labelPlaneMatrixInv),i.setTerrainUniformValues(r,a);}renderToBackBuffer(t){const i=this.painter,o=this.painter.context;0!==t.length&&(o.bindFramebuffer.set(null),o.viewport.set([0,0,i.width,i.height]),this.renderingToTexture=!1,function(t,i,o,r,n){if("globe"===t.transform.projection.name)!function(t,i,o,r,n){const a=t.context,s=a.gl;let l,c;const h=t.options.showTerrainWireframe?2:0,u=(e,i)=>{if(c===e)return;const o=[];i&&o.push(ni[h]),o.push(ni[e]),o.push("PROJECTION_GLOBE_VIEW"),l=t.useProgram("globeRaster",null,o),c=e;},_=t.colorModeForRenderPass(),d=new e.DepthMode(s.LEQUAL,e.DepthMode.ReadWrite,t.depthRangeFor3D);ri.update(n);const p=t.transform,m=e.calculateGlobeMatrix(p,p.worldSize),f=e.calculateGlobeMercatorMatrix(p),g=[e.mercatorXfromLng(p.center.lng),e.mercatorYfromLat(p.center.lat)],v=t.globeSharedBuffers;(h?[!1,!0]:[!1]).forEach((h=>{c=-1;const x=h?s.LINES:s.TRIANGLES;for(const c of r){const r=o.getTile(c),y=Math.pow(2,c.canonical.z),[b,w]=e.globeBuffersForTileMesh(t,r,c,y),T=e.StencilMode.disabled,E=i.prevTerrainTileForTile[c.key],C=i.terrainTileForTile[c.key];oi(E,C)&&ri.newMorphing(c.key,E,C,n,250),a.activeTexture.set(s.TEXTURE0),r.texture.bind(s.LINEAR,s.CLAMP_TO_EDGE);const M=ri.getMorphValuesForProxy(c.key),S=M?1:0,I={};M&&e.extend$1(I,{morphing:{srcDemTile:M.from,dstDemTile:M.to,phase:e.easeCubicInOut(M.phase)}});const z=e.globeMatrixForTile(c.canonical,m),D=ii(p.projMatrix,z,f,e.globeToMercatorTransition(p.zoom),g);if(u(S,h),i.setupElevationDraw(r,l,I),t.prepareDrawProgram(a,l,c.toUnwrapped()),v){const[i,o]=h?v.getWirefameBuffer(t.context):[v.gridIndexBuffer,v.gridSegments];l.draw(a,x,d,T,_,e.CullFaceMode.backCCW,D,"globe_raster",b,i,o);}if(!h){const t=[0===c.canonical.y?e.globePoleMatrixForTile(c.canonical,!1,p):null,c.canonical.y===y-1?e.globePoleMatrixForTile(c.canonical,!0,p):null];for(const i of t){if(!i)continue;const t=ii(p.projMatrix,i,i,0,g);v&&l.draw(a,x,d,T,_,e.CullFaceMode.disabled,t,"globe_pole_raster",w,v.poleIndexBuffer,v.poleSegments);}}}}));}(t,i,o,r,n);else {const a=t.context,s=a.gl;let l,c;const h=t.options.showTerrainWireframe?2:0,u=(e,i)=>{if(c===e)return;const o=[ni[e]];i&&o.push(ni[h]),l=t.useProgram("terrainRaster",null,o),c=e;},_=t.colorModeForRenderPass(),d=new e.DepthMode(s.LEQUAL,e.DepthMode.ReadWrite,t.depthRangeFor3D);ri.update(n);const p=t.transform,m=6*Math.pow(1.5,22-p.zoom)*i.exaggeration();(h?[!1,!0]:[!1]).forEach((h=>{c=-1;const f=h?s.LINES:s.TRIANGLES,[g,v]=h?i.getWirefameBuffer():[i.gridIndexBuffer,i.gridSegments];for(const c of r){const r=o.getTile(c),x=e.StencilMode.disabled,y=i.prevTerrainTileForTile[c.key],b=i.terrainTileForTile[c.key];oi(y,b)&&ri.newMorphing(c.key,y,b,n,250),a.activeTexture.set(s.TEXTURE0),r.texture.bind(s.LINEAR,s.CLAMP_TO_EDGE,s.LINEAR_MIPMAP_NEAREST);const w=ri.getMorphValuesForProxy(c.key),T=w?1:0;let E;w&&(E={morphing:{srcDemTile:w.from,dstDemTile:w.to,phase:e.easeCubicInOut(w.phase)}});const C=ti(c.projMatrix,ai(c.canonical,p.renderWorldCopies)?m/10:m);u(T,h),i.setupElevationDraw(r,l,E),t.prepareDrawProgram(a,l,c.toUnwrapped()),l.draw(a,f,d,x,_,e.CullFaceMode.backCCW,C,"terrain_raster",i.gridBuffer,g,v);}}));}}(i,this,this.proxySourceCache,t,this._updateTimestamp),this.renderingToTexture=!0,t.splice(0,t.length));}renderBatch(t){if(0===this._drapedRenderBatches.length)return t+1;this.renderingToTexture=!0;const i=this.painter,o=this.painter.context,r=this.proxySourceCache,n=this.proxiedCoords[r.id],a=this._drapedRenderBatches.shift(),s=[],l=i.style.order;let c=0;for(const h of n){const n=r.getTileByID(h.proxyTileKey),u=r.proxyCachedFBO[h.key]?r.proxyCachedFBO[h.key][t]:void 0,_=void 0!==u?r.renderCache[u]:this.pool[c++],d=void 0!==u;if(n.texture=_.tex,d&&!_.dirty){s.push(n.tileID);continue}let p;o.bindFramebuffer.set(_.fb.framebuffer),this.renderedToTile=!1,_.dirty&&(o.clear({color:e.Color.transparent,stencil:0}),_.dirty=!1);for(let e=a.start;e<=a.end;++e){const t=i.style._layers[l[e]];if(t.isHidden(i.transform.zoom))continue;const r=i.style._getLayerSourceCache(t),n=r?this.proxyToSource[h.key][r.id]:[h];if(!n)continue;const a=n;o.viewport.set([0,0,_.fb.width,_.fb.height]),p!==(r?r.id:null)&&(this._setupStencil(_,n,t,r),p=r?r.id:null),i.renderLayer(i,r,t,a);}this.renderedToTile?(_.dirty=!0,s.push(n.tileID)):d||--c,5===c&&(c=0,this.renderToBackBuffer(s));}return this.renderToBackBuffer(s),this.renderingToTexture=!1,o.bindFramebuffer.set(null),o.viewport.set([0,0,i.width,i.height]),a.end+1}postRender(){}renderCacheEfficiency(e){const t=e.order.length;if(0===t)return {efficiency:100};let i,o=0,r=0,n=!1;for(let a=0;a<t;++a){const t=e._layers[e.order[a]];this._style.isLayerDraped(t)?(n&&++o,++r):n||(n=!0,i=t.id);}return 0===r?{efficiency:100}:{efficiency:100*(1-o/r),firstUndrapedLayer:i}}getMinElevationBelowMSL(){let e=0;return this._visibleDemTiles.filter((e=>e.dem)).forEach((t=>{e=Math.min(e,t.dem.tree.minimums[0]);})),0===e?e:(e-30)*this._exaggeration}raycast(e,t,i){if(!this._visibleDemTiles)return null;const o=this._visibleDemTiles.filter((e=>e.dem)).map((o=>{const r=o.tileID,n=Math.pow(2,r.overscaledZ),{x:a,y:s}=r.canonical,l=a/n,c=(a+1)/n,h=s/n,u=(s+1)/n;return {minx:l,miny:h,maxx:c,maxy:u,t:o.dem.tree.raycastRoot(l,h,c,u,e,t,i),tile:o}}));o.sort(((e,t)=>(null!==e.t?e.t:Number.MAX_VALUE)-(null!==t.t?t.t:Number.MAX_VALUE)));for(const r of o){if(null==r.t)return null;const o=r.tile.dem.tree.raycast(r.minx,r.miny,r.maxx,r.maxy,e,t,i);if(null!=o)return o}return null}_createFBO(){const t=this.painter.context,i=t.gl,o=this.drapeBufferSize;t.activeTexture.set(i.TEXTURE0);const r=new e.Texture(t,{width:o[0],height:o[1],data:null},i.RGBA);r.bind(i.LINEAR,i.CLAMP_TO_EDGE);const n=t.createFramebuffer(o[0],o[1],!1);return n.colorAttachment.set(r.texture),n.depthAttachment=new ue(t,n.framebuffer),void 0===this._sharedDepthStencil?(this._sharedDepthStencil=t.createRenderbuffer(t.gl.DEPTH_STENCIL,o[0],o[1]),this._stencilRef=0,n.depthAttachment.set(this._sharedDepthStencil),t.clear({stencil:0})):n.depthAttachment.set(this._sharedDepthStencil),t.extTextureFilterAnisotropic&&!t.extTextureFilterAnisotropicForceOff&&i.texParameterf(i.TEXTURE_2D,t.extTextureFilterAnisotropic.TEXTURE_MAX_ANISOTROPY_EXT,t.extTextureFilterAnisotropicMax),{fb:n,tex:r,dirty:!1}}_initFBOPool(){for(;this.pool.length<Math.min(5,this.proxyCoords.length);)this.pool.push(this._createFBO());}_shouldDisableRenderCache(){if(this._style.light&&this._style.light.hasTransition())return !0;for(const e in this._style._sourceCaches)if(this._style._sourceCaches[e].hasTransition())return !0;return this._style.order.some((e=>{const t=this._style._layers[e],i=t.isHidden(this.painter.transform.zoom),o=t.getCrossfadeParameters(),r=!!o&&1!==o.t,n=t.hasTransition();return "custom"!==t.type&&!i&&(r||n)}))}_clearRasterFadeFromRenderCache(){let e=!1;for(const t in this._style._sourceCaches)if(this._style._sourceCaches[t]._source instanceof ve){e=!0;break}if(e)for(let e=0;e<this._style.order.length;++e){const t=this._style._layers[this._style.order[e]],i=t.isHidden(this.painter.transform.zoom),o=this._style._getLayerSourceCache(t);if("raster"!==t.type||i||!o)continue;const r=t.paint.get("raster-fade-duration");for(const e of this.proxyCoords){const t=this.proxyToSource[e.key][o.id];if(t)for(const e of t){const t=li(o.getTile(e),o.findLoadedParent(e,0),o,this.painter.transform,r);(1!==t.opacity||0!==t.mix)&&this._clearRenderCacheForTile(o.id,e);}}}}_setupDrapedRenderBatches(){const e=this._style.order,t=e.length;if(0===t)return;const i=[];let o,r=0,n=this._style._layers[e[r]];for(;!this._style.isLayerDraped(n)&&n.isHidden(this.painter.transform.zoom)&&++r<t;)n=this._style._layers[e[r]];for(;r<t;++r){const t=this._style._layers[e[r]];t.isHidden(this.painter.transform.zoom)||(this._style.isLayerDraped(t)?void 0===o&&(o=r):void 0!==o&&(i.push({start:o,end:r-1}),o=void 0));}void 0!==o&&i.push({start:o,end:r-1}),this._drapedRenderBatches=i;}_setupRenderCache(e){const t=this.proxySourceCache;if(this._shouldDisableRenderCache()||this._invalidateRenderCache){if(this._invalidateRenderCache=!1,t.renderCache.length>t.renderCachePool.length){const e=Object.values(t.proxyCachedFBO);t.proxyCachedFBO={};for(let i=0;i<e.length;++i){const o=Object.values(e[i]);t.renderCachePool.push(...o);}}return}this._clearRasterFadeFromRenderCache();const i=this.proxyCoords,o=this._tilesDirty;for(let r=i.length-1;r>=0;r--){const n=i[r];if(t.getTileByID(n.key),void 0!==t.proxyCachedFBO[n.key]){const i=e[n.key],r=this.proxyToSource[n.key];let a=0;for(const e in r){const t=r[e],n=i[e];if(!n||n.length!==t.length||t.some(((t,i)=>t!==n[i]||o[e]&&o[e].hasOwnProperty(t.key)))){a=-1;break}++a;}for(const e in t.proxyCachedFBO[n.key])t.renderCache[t.proxyCachedFBO[n.key][e]].dirty=a<0||a!==Object.values(i).length;}}const r=[...this._drapedRenderBatches];r.sort(((e,t)=>t.end-t.start-(e.end-e.start)));for(const e of r)for(const o of i){if(t.proxyCachedFBO[o.key])continue;let i=t.renderCachePool.pop();void 0===i&&t.renderCache.length<50&&(i=t.renderCache.length,t.renderCache.push(this._createFBO())),void 0!==i&&(t.proxyCachedFBO[o.key]={},t.proxyCachedFBO[o.key][e.start]=i,t.renderCache[i].dirty=!0);}this._tilesDirty={};}_setupStencil(e,t,i,o){if(!o||!this._sourceTilesOverlap[o.id])return void(this._overlapStencilType&&(this._overlapStencilType=!1));const r=this.painter.context,n=r.gl;if(t.length<=1)return void(this._overlapStencilType=!1);let a;if(i.isTileClipped())a=t.length,this._overlapStencilMode.test={func:n.EQUAL,mask:255},this._overlapStencilType="Clip";else {if(!(t[0].overscaledZ>t[t.length-1].overscaledZ))return void(this._overlapStencilType=!1);a=1,this._overlapStencilMode.test={func:n.GREATER,mask:255},this._overlapStencilType="Mask";}this._stencilRef+a>255&&(r.clear({stencil:0}),this._stencilRef=0),this._stencilRef+=a,this._overlapStencilMode.ref=this._stencilRef,i.isTileClipped()&&this._renderTileClippingMasks(t,this._overlapStencilMode.ref);}clipOrMaskOverlapStencilType(){return "Clip"===this._overlapStencilType||"Mask"===this._overlapStencilType}stencilModeForRTTOverlap(t){return this.renderingToTexture&&this._overlapStencilType?("Clip"===this._overlapStencilType&&(this._overlapStencilMode.ref=this.painter._tileClippingMaskIDs[t.key]),this._overlapStencilMode):e.StencilMode.disabled}_renderTileClippingMasks(t,i){const o=this.painter,r=this.painter.context,n=r.gl;o._tileClippingMaskIDs={},r.setColorMode(e.ColorMode.disabled),r.setDepthMode(e.DepthMode.disabled);const a=o.useProgram("clippingMask");for(const s of t){const t=o._tileClippingMaskIDs[s.key]=--i;a.draw(r,n.TRIANGLES,e.DepthMode.disabled,new e.StencilMode({func:n.ALWAYS,mask:0},t,255,n.KEEP,n.KEEP,n.REPLACE),e.ColorMode.disabled,e.CullFaceMode.disabled,si(s.projMatrix),"$clipping",o.tileExtentBuffer,o.quadTriangleIndexBuffer,o.tileExtentSegments);}}pointCoordinate(t){const i=this.painter.transform;if(t.x<0||t.x>i.width||t.y<0||t.y>i.height)return null;const o=[t.x,t.y,1,1];e.transformMat4$1(o,o,i.pixelMatrixInverse),e.scale$1(o,o,1/o[3]),o[0]/=i.worldSize,o[1]/=i.worldSize;const r=i._camera.position,n=e.mercatorZfromAltitude(1,i.center.lat),a=[r[0],r[1],r[2]/n,0],s=e.subtract([],o.slice(0,3),a);e.normalize(s,s);const l=this.raycast(a,s,this._exaggeration);return null!==l&&l?(e.scaleAndAdd(a,a,s,l),a[3]=a[2],a[2]*=n,a):null}drawDepth(){const t=this.painter,i=t.context,o=this.proxySourceCache,r=Math.ceil(t.width),n=Math.ceil(t.height);if(!this._depthFBO||this._depthFBO.width===r&&this._depthFBO.height===n||(this._depthFBO.destroy(),delete this._depthFBO,delete this._depthTexture),!this._depthFBO){const t=i.gl,o=i.createFramebuffer(r,n,!0);i.activeTexture.set(t.TEXTURE0);const a=new e.Texture(i,{width:r,height:n,data:null},t.RGBA);a.bind(t.NEAREST,t.CLAMP_TO_EDGE),o.colorAttachment.set(a.texture);const s=i.createRenderbuffer(i.gl.DEPTH_COMPONENT16,r,n);o.depthAttachment.set(s),this._depthFBO=o,this._depthTexture=a;}i.bindFramebuffer.set(this._depthFBO.framebuffer),i.viewport.set([0,0,r,n]),function(t,i,o,r){if("globe"===t.transform.projection.name)return;const n=t.context,a=n.gl;n.clear({depth:1});const s=t.useProgram("terrainDepth"),l=new e.DepthMode(a.LESS,e.DepthMode.ReadWrite,t.depthRangeFor3D);for(const t of r){const r=o.getTile(t),c=ti(t.projMatrix,0);i.setupElevationDraw(r,s),s.draw(n,a.TRIANGLES,l,e.StencilMode.disabled,e.ColorMode.unblended,e.CullFaceMode.backCCW,c,"terrain_depth",i.gridBuffer,i.gridIndexBuffer,i.gridNoSkirtSegments);}}(t,this,o,this.proxyCoords);}_setupProxiedCoordsForOrtho(e,t,i){if(e.getSource()instanceof be)return this._setupProxiedCoordsForImageSource(e,t,i);this._findCoveringTileCache[e.id]=this._findCoveringTileCache[e.id]||{};const o=this.proxiedCoords[e.id]=[],r=this.proxyCoords;for(let t=0;t<r.length;t++){const n=r[t],a=this._findTileCoveringTileID(n,e);if(a){const t=this._createProxiedId(n,a,i[n.key]&&i[n.key][e.id]);o.push(t),this.proxyToSource[n.key][e.id]=[t];}}let n=!1;for(let r=0;r<t.length;r++){const a=e.getTile(t[r]);if(!a||!a.hasData())continue;const s=this._findTileCoveringTileID(a.tileID,this.proxySourceCache);if(s&&s.tileID.canonical.z!==a.tileID.canonical.z){const t=this.proxyToSource[s.tileID.key][e.id],r=this._createProxiedId(s.tileID,a,i[s.tileID.key]&&i[s.tileID.key][e.id]);t?t.splice(t.length-1,0,r):this.proxyToSource[s.tileID.key][e.id]=[r],o.push(r),n=!0;}}this._sourceTilesOverlap[e.id]=n;}_setupProxiedCoordsForImageSource(t,i,o){if(!t.getSource().loaded())return;const r=this.proxiedCoords[t.id]=[],n=this.proxyCoords,a=t.getSource(),s=new e.pointGeometry(a.tileID.x,a.tileID.y)._div(1<<a.tileID.z),l=a.coordinates.map(e.MercatorCoordinate.fromLngLat).reduce(((e,t)=>(e.min.x=Math.min(e.min.x,t.x-s.x),e.min.y=Math.min(e.min.y,t.y-s.y),e.max.x=Math.max(e.max.x,t.x-s.x),e.max.y=Math.max(e.max.y,t.y-s.y),e)),{min:new e.pointGeometry(Number.MAX_VALUE,Number.MAX_VALUE),max:new e.pointGeometry(-Number.MAX_VALUE,-Number.MAX_VALUE)}),c=(t,i)=>{const o=t.wrap+t.canonical.x/(1<<t.canonical.z),r=t.canonical.y/(1<<t.canonical.z),n=e.EXTENT/(1<<t.canonical.z),a=i.wrap+i.canonical.x/(1<<i.canonical.z),s=i.canonical.y/(1<<i.canonical.z);return o+n<a+l.min.x||o>a+l.max.x||r+n<s+l.min.y||r>s+l.max.y};for(let e=0;e<n.length;e++){const a=n[e];for(let e=0;e<i.length;e++){const n=t.getTile(i[e]);if(!n||!n.hasData())continue;if(c(a,n.tileID))continue;const s=this._createProxiedId(a,n,o[a.key]&&o[a.key][t.id]),l=this.proxyToSource[a.key][t.id];l?l.push(s):this.proxyToSource[a.key][t.id]=[s],r.push(s);}}}_createProxiedId(t,i,o){let r=this.orthoMatrix;if(o){const e=o.find((e=>e.key===i.tileID.key));if(e)return e}if(i.tileID.key!==t.key){const o=t.canonical.z-i.tileID.canonical.z;let n,a,s;r=e.create();const l=i.tileID.wrap-t.wrap<<t.overscaledZ;o>0?(n=e.EXTENT>>o,a=n*((i.tileID.canonical.x<<o)-t.canonical.x+l),s=n*((i.tileID.canonical.y<<o)-t.canonical.y)):(n=e.EXTENT<<-o,a=e.EXTENT*(i.tileID.canonical.x-(t.canonical.x+l<<-o)),s=e.EXTENT*(i.tileID.canonical.y-(t.canonical.y<<-o))),e.ortho(r,0,n,0,n,0,1),e.translate(r,r,[a,s,0]);}return new ui(i.tileID,t.key,r)}_findTileCoveringTileID(t,i){let o=i.getTile(t);if(o&&o.hasData())return o;const r=this._findCoveringTileCache[i.id],n=r[t.key];if(o=n?i.getTileByID(n):null,o&&o.hasData()||null===n)return o;let a=o?o.tileID:t,s=a.overscaledZ;const l=i.getSource().minzoom,c=[];if(!n){const r=i.getSource().maxzoom;if(t.canonical.z>=r){const o=t.canonical.z-r;i.getSource().reparseOverscaled?(s=Math.max(t.canonical.z+2,i.transform.tileZoom),a=new e.OverscaledTileID(s,t.wrap,r,t.canonical.x>>o,t.canonical.y>>o)):0!==o&&(s=r,a=new e.OverscaledTileID(s,t.wrap,r,t.canonical.x>>o,t.canonical.y>>o));}a.key!==t.key&&(c.push(a.key),o=i.getTile(a));}const h=e=>{c.forEach((t=>{r[t]=e;})),c.length=0;};for(s-=1;s>=l&&(!o||!o.hasData());s--){o&&h(o.tileID.key);const e=a.calculateScaledKey(s);if(o=i.getTileByID(e),o&&o.hasData())break;const t=r[e];if(null===t)break;void 0===t?c.push(e):o=i.getTileByID(t);}return h(o?o.tileID.key:null),o&&o.hasData()?o:null}findDEMTileFor(e){return this.enabled?this._findTileCoveringTileID(e,this.sourceCache):null}prepareDrawTile(e){this.renderedToTile=!0;}_clearRenderCacheForTile(e,t){let i=this._tilesDirty[e];i||(i=this._tilesDirty[e]={}),i[t.key]=!0;}getWirefameBuffer(){if(!this.wireframeSegments){const t=function(t){let i,o,r;const n=new e.StructArrayLayout2ui4,a=131;for(o=1;o<129;o++){for(i=1;i<129;i++)r=o*a+i,n.emplaceBack(r,r+1),n.emplaceBack(r,r+a),n.emplaceBack(r+1,r+a),128===o&&n.emplaceBack(r+a,r+a+1);n.emplaceBack(r+1,r+1+a);}return n}();this.wireframeIndexBuffer=this.painter.context.createIndexBuffer(t),this.wireframeSegments=e.SegmentVector.simpleSegment(0,0,this.gridBuffer.length,t.length);}return [this.wireframeIndexBuffer,this.wireframeSegments]}}function di(e){const t=[];for(let i=0;i<e.length;i++){if(null===e[i])continue;const o=e[i].split(" ");t.push(o.pop());}return t}class pi{static cacheKey(e,t,i){let o=`${e}${i?i.cacheKey:""}`;for(const e of t)o+=`/${e}`;return o}constructor(t,i,o,r,n,a){const s=t.gl;this.program=s.createProgram();const l=di(o.staticAttributes),c=r?r.getBinderAttributes():[],h=l.concat(c),u=o.staticUniforms?di(o.staticUniforms):[],_=r?r.getBinderUniforms():[],d=u.concat(_),p=[];for(const e of d)p.indexOf(e)<0&&p.push(e);let m=r?r.defines():[];m=m.concat(a.map((e=>`#define ${e}`)));const f=m.concat("\n#ifdef GL_ES\nprecision mediump float;\n#else\n\n#if !defined(lowp)\n#define lowp\n#endif\n\n#if !defined(mediump)\n#define mediump\n#endif\n\n#if !defined(highp)\n#define highp\n#endif\n\n#endif",qt,Wt.fragmentSource,Vt.fragmentSource,o.fragmentSource).join("\n"),g=m.concat("\n#ifdef GL_ES\nprecision highp float;\n#else\n\n#if !defined(lowp)\n#define lowp\n#endif\n\n#if !defined(mediump)\n#define mediump\n#endif\n\n#if !defined(highp)\n#define highp\n#endif\n\n#endif",qt,Wt.vertexSource,Vt.vertexSource,Zt.vertexSource,o.vertexSource).join("\n"),v=s.createShader(s.FRAGMENT_SHADER);if(s.isContextLost())return void(this.failedToCreate=!0);s.shaderSource(v,f),s.compileShader(v),s.attachShader(this.program,v);const x=s.createShader(s.VERTEX_SHADER);if(s.isContextLost())return void(this.failedToCreate=!0);s.shaderSource(x,g),s.compileShader(x),s.attachShader(this.program,x),this.attributes={};const y={};this.numAttributes=h.length;for(let e=0;e<this.numAttributes;e++)h[e]&&(s.bindAttribLocation(this.program,e,h[e]),this.attributes[h[e]]=e);s.linkProgram(this.program),s.deleteShader(x),s.deleteShader(v);for(let e=0;e<p.length;e++){const t=p[e];if(t&&!y[t]){const e=s.getUniformLocation(this.program,t);e&&(y[t]=e);}}this.fixedUniforms=n(t,y),this.binderUniforms=r?r.getUniforms(t,y):[],-1!==a.indexOf("TERRAIN")&&(this.terrainUniforms=((t,i)=>({u_dem:new e.Uniform1i(t,i.u_dem),u_dem_prev:new e.Uniform1i(t,i.u_dem_prev),u_dem_unpack:new e.Uniform4f(t,i.u_dem_unpack),u_dem_tl:new e.Uniform2f(t,i.u_dem_tl),u_dem_scale:new e.Uniform1f(t,i.u_dem_scale),u_dem_tl_prev:new e.Uniform2f(t,i.u_dem_tl_prev),u_dem_scale_prev:new e.Uniform1f(t,i.u_dem_scale_prev),u_dem_size:new e.Uniform1f(t,i.u_dem_size),u_dem_lerp:new e.Uniform1f(t,i.u_dem_lerp),u_exaggeration:new e.Uniform1f(t,i.u_exaggeration),u_depth:new e.Uniform1i(t,i.u_depth),u_depth_size_inv:new e.Uniform2f(t,i.u_depth_size_inv),u_meter_to_dem:new e.Uniform1f(t,i.u_meter_to_dem),u_label_plane_matrix_inv:new e.UniformMatrix4f(t,i.u_label_plane_matrix_inv),u_tile_tl_up:new e.Uniform3f(t,i.u_tile_tl_up),u_tile_tr_up:new e.Uniform3f(t,i.u_tile_tr_up),u_tile_br_up:new e.Uniform3f(t,i.u_tile_br_up),u_tile_bl_up:new e.Uniform3f(t,i.u_tile_bl_up),u_tile_up_scale:new e.Uniform1f(t,i.u_tile_up_scale)}))(t,y)),-1!==a.indexOf("FOG")&&(this.fogUniforms=((t,i)=>({u_fog_matrix:new e.UniformMatrix4f(t,i.u_fog_matrix),u_fog_range:new e.Uniform2f(t,i.u_fog_range),u_fog_color:new e.Uniform4f(t,i.u_fog_color),u_fog_horizon_blend:new e.Uniform1f(t,i.u_fog_horizon_blend),u_fog_temporal_offset:new e.Uniform1f(t,i.u_fog_temporal_offset)}))(t,y));}setTerrainUniformValues(e,t){if(!this.terrainUniforms)return;const i=this.terrainUniforms;if(!this.failedToCreate){e.program.set(this.program);for(const e in t)i[e].set(t[e]);}}setFogUniformValues(e,t){if(!this.fogUniforms)return;const i=this.fogUniforms;if(!this.failedToCreate){e.program.set(this.program);for(const e in t)i[e].location&&i[e].set(t[e]);}}draw(e,t,i,o,r,n,a,s,l,c,h,u,_,d,p,m){const f=e.gl;if(this.failedToCreate)return;e.program.set(this.program),e.setDepthMode(i),e.setStencilMode(o),e.setColorMode(r),e.setCullFace(n);for(const e of Object.keys(this.fixedUniforms))this.fixedUniforms[e].set(a[e]);d&&d.setUniforms(e,this.binderUniforms,u,{zoom:_});const g={[f.LINES]:2,[f.TRIANGLES]:3,[f.LINE_STRIP]:1}[t];for(const i of h.get()){const o=i.vaos||(i.vaos={});(o[s]||(o[s]=new Ht)).bind(e,this,l,d?d.getPaintVertexBuffers():[],c,i.vertexOffset,p,m),f.drawElements(t,i.primitiveLength*g,f.UNSIGNED_SHORT,i.primitiveOffset*g*2);}}}function mi(e,t,i){const o=1/M(i,1,t.transform.tileZoom),r=Math.pow(2,i.tileID.overscaledZ),n=i.tileSize*Math.pow(2,t.transform.tileZoom)/r,a=n*(i.tileID.canonical.x+i.tileID.wrap*r),s=n*i.tileID.canonical.y;return {u_image:0,u_texsize:i.imageAtlasTexture.size,u_scale:[o,e.fromScale,e.toScale],u_fade:e.t,u_pixel_coord_upper:[a>>16,s>>16],u_pixel_coord_lower:[65535&a,65535&s]}}const fi=(t,i,o,r)=>{const n=i.style.light,a=n.properties.get("position"),s=[a.x,a.y,a.z],l=e.create$1();"viewport"===n.properties.get("anchor")&&(e.fromRotation(l,-i.transform.angle),e.transformMat3(s,s,l));const c=n.properties.get("color");return {u_matrix:t,u_lightpos:s,u_lightintensity:n.properties.get("intensity"),u_lightcolor:[c.r,c.g,c.b],u_vertical_gradient:+o,u_opacity:r}},gi=(t,i,o,r,n,a,s)=>e.extend(fi(t,i,o,r),mi(a,i,s),{u_height_factor:-Math.pow(2,n.overscaledZ)/s.tileSize/8}),vi=e=>({u_matrix:e}),xi=(t,i,o,r)=>e.extend(vi(t),mi(o,i,r)),yi=(e,t)=>({u_matrix:e,u_world:t}),bi=(t,i,o,r,n)=>e.extend(xi(t,i,o,r),{u_world:n}),wi=(t,i,o,r)=>{const n=t.transform;let a;return a="map"===r.paint.get("circle-pitch-alignment")?n.calculatePixelsToTileUnitsMatrix(o):new Float32Array([n.pixelsToGLUnits[0],0,0,n.pixelsToGLUnits[1]]),{u_camera_to_center_distance:n.cameraToCenterDistance,u_matrix:t.translatePosMatrix(i.projMatrix,o,r.paint.get("circle-translate"),r.paint.get("circle-translate-anchor")),u_device_pixel_ratio:e.exported.devicePixelRatio,u_extrude_scale:a}},Ti=e=>{const t=[];return "map"===e.paint.get("circle-pitch-alignment")&&t.push("PITCH_WITH_MAP"),"map"===e.paint.get("circle-pitch-scale")&&t.push("SCALE_WITH_MAP"),t},Ei=(t,i,o)=>{const r=e.EXTENT/o.tileSize;return {u_matrix:t,u_camera_to_center_distance:i.cameraToCenterDistance,u_extrude_scale:[i.pixelsToGLUnits[0]/r,i.pixelsToGLUnits[1]/r]}},Ci=(e,t,i=1)=>({u_matrix:e,u_color:t,u_overlay:0,u_overlay_scale:i}),Mi=(e,t,i,o)=>({u_matrix:e,u_extrude_scale:M(t,1,i),u_intensity:o}),Si=(t,i,o,r,n,a)=>{const s=t.transform,l=s.calculatePixelsToTileUnitsMatrix(i),c={u_matrix:Di(t,i,o,n),u_pixels_to_tile_units:l,u_device_pixel_ratio:e.exported.devicePixelRatio,u_units_to_pixels:[1/s.pixelsToGLUnits[0],1/s.pixelsToGLUnits[1]],u_dash_image:0,u_gradient_image:1,u_image_height:a,u_texsize:[0,0],u_scale:[0,0,0],u_mix:0,u_alpha_discard_threshold:0};if(Pi(o)){const e=zi(i,t.transform);c.u_texsize=i.lineAtlasTexture.size,c.u_scale=[e,r.fromScale,r.toScale],c.u_mix=r.t;}return c},Ii=(t,i,o,r,n)=>{const a=t.transform,s=zi(i,a);return {u_matrix:Di(t,i,o,n),u_texsize:i.imageAtlasTexture.size,u_pixels_to_tile_units:a.calculatePixelsToTileUnitsMatrix(i),u_device_pixel_ratio:e.exported.devicePixelRatio,u_image:0,u_scale:[s,r.fromScale,r.toScale],u_fade:r.t,u_units_to_pixels:[1/a.pixelsToGLUnits[0],1/a.pixelsToGLUnits[1]],u_alpha_discard_threshold:0}};function zi(e,t){return 1/M(e,1,t.tileZoom)}function Di(e,t,i,o){return e.translatePosMatrix(o||t.tileID.projMatrix,t,i.paint.get("line-translate"),i.paint.get("line-translate-anchor"))}function Pi(e){const t=e.paint.get("line-dasharray").value;return t.value||"constant"!==t.kind}const Ai=(e,t,i,o,r,n)=>{return {u_matrix:e,u_tl_parent:t,u_scale_parent:i,u_fade_t:o.mix,u_opacity:o.opacity*r.paint.get("raster-opacity"),u_image0:0,u_image1:1,u_brightness_low:r.paint.get("raster-brightness-min"),u_brightness_high:r.paint.get("raster-brightness-max"),u_saturation_factor:(s=r.paint.get("raster-saturation"),s>0?1-1/(1.001-s):-s),u_contrast_factor:(a=r.paint.get("raster-contrast"),a>0?1/(1-a):1+a),u_spin_weights:Li(r.paint.get("raster-hue-rotate")),u_perspective_transform:n};var a,s;};function Li(e){e*=Math.PI/180;const t=Math.sin(e),i=Math.cos(e);return [(2*i+1)/3,(-Math.sqrt(3)*t-i+1)/3,(Math.sqrt(3)*t-i+1)/3]}const Ri=(e,t,i,o,r,n,a,s,l,c,h,u,_,d)=>{const p=r.transform;return {u_is_size_zoom_constant:+("constant"===e||"source"===e),u_is_size_feature_constant:+("constant"===e||"camera"===e),u_size_t:t?t.uSizeT:0,u_size:t?t.uSize:0,u_camera_to_center_distance:p.cameraToCenterDistance,u_pitch:p.pitch/360*2*Math.PI,u_rotate_symbol:+i,u_aspect_ratio:p.width/p.height,u_fade_change:r.options.fadeDuration?r.symbolFadeChange:1,u_matrix:n,u_label_plane_matrix:a,u_coord_matrix:s,u_is_text:+l,u_pitch_with_map:+o,u_texsize:c,u_tile_id:h,u_zoom_transition:u,u_inv_rot_matrix:_,u_merc_center:d,u_texture:0}},ki=(t,i,o,r,n,a,s,l,c,h,u,_,d,p,m)=>{const{cameraToCenterDistance:f,_pitch:g}=n.transform;return e.extend(Ri(t,i,o,r,n,a,s,l,c,h,_,d,p,m),{u_gamma_scale:r?f*Math.cos(n.terrain?0:g):1,u_device_pixel_ratio:e.exported.devicePixelRatio,u_is_halo:+u})},Oi=(t,i,o,r,n,a,s,l,c,h,u,_,d,p)=>e.extend(ki(t,i,o,r,n,a,s,l,!0,c,!0,u,_,d,p),{u_texsize_icon:h,u_texture_icon:1}),Bi=(e,t,i)=>({u_matrix:e,u_opacity:t,u_color:i}),Fi=(t,i,o,r,n,a)=>e.extend(function(e,t,i,o){const r=i.imageManager.getPattern(e.from.toString()),n=i.imageManager.getPattern(e.to.toString()),{width:a,height:s}=i.imageManager.getPixelSize(),l=Math.pow(2,o.tileID.overscaledZ),c=o.tileSize*Math.pow(2,i.transform.tileZoom)/l,h=c*(o.tileID.canonical.x+o.tileID.wrap*l),u=c*o.tileID.canonical.y;return {u_image:0,u_pattern_tl_a:r.tl,u_pattern_br_a:r.br,u_pattern_tl_b:n.tl,u_pattern_br_b:n.br,u_texsize:[a,s],u_mix:t.t,u_pattern_size_a:r.displaySize,u_pattern_size_b:n.displaySize,u_scale_a:t.fromScale,u_scale_b:t.toScale,u_tile_units_to_pixels:1/M(o,1,i.transform.tileZoom),u_pixel_coord_upper:[h>>16,u>>16],u_pixel_coord_lower:[65535&h,65535&u]}}(r,a,o,n),{u_matrix:t,u_opacity:i}),Ui={fillExtrusion:(t,i)=>({u_matrix:new e.UniformMatrix4f(t,i.u_matrix),u_lightpos:new e.Uniform3f(t,i.u_lightpos),u_lightintensity:new e.Uniform1f(t,i.u_lightintensity),u_lightcolor:new e.Uniform3f(t,i.u_lightcolor),u_vertical_gradient:new e.Uniform1f(t,i.u_vertical_gradient),u_opacity:new e.Uniform1f(t,i.u_opacity)}),fillExtrusionPattern:(t,i)=>({u_matrix:new e.UniformMatrix4f(t,i.u_matrix),u_lightpos:new e.Uniform3f(t,i.u_lightpos),u_lightintensity:new e.Uniform1f(t,i.u_lightintensity),u_lightcolor:new e.Uniform3f(t,i.u_lightcolor),u_vertical_gradient:new e.Uniform1f(t,i.u_vertical_gradient),u_height_factor:new e.Uniform1f(t,i.u_height_factor),u_image:new e.Uniform1i(t,i.u_image),u_texsize:new e.Uniform2f(t,i.u_texsize),u_pixel_coord_upper:new e.Uniform2f(t,i.u_pixel_coord_upper),u_pixel_coord_lower:new e.Uniform2f(t,i.u_pixel_coord_lower),u_scale:new e.Uniform3f(t,i.u_scale),u_fade:new e.Uniform1f(t,i.u_fade),u_opacity:new e.Uniform1f(t,i.u_opacity)}),fill:(t,i)=>({u_matrix:new e.UniformMatrix4f(t,i.u_matrix)}),fillPattern:(t,i)=>({u_matrix:new e.UniformMatrix4f(t,i.u_matrix),u_image:new e.Uniform1i(t,i.u_image),u_texsize:new e.Uniform2f(t,i.u_texsize),u_pixel_coord_upper:new e.Uniform2f(t,i.u_pixel_coord_upper),u_pixel_coord_lower:new e.Uniform2f(t,i.u_pixel_coord_lower),u_scale:new e.Uniform3f(t,i.u_scale),u_fade:new e.Uniform1f(t,i.u_fade)}),fillOutline:(t,i)=>({u_matrix:new e.UniformMatrix4f(t,i.u_matrix),u_world:new e.Uniform2f(t,i.u_world)}),fillOutlinePattern:(t,i)=>({u_matrix:new e.UniformMatrix4f(t,i.u_matrix),u_world:new e.Uniform2f(t,i.u_world),u_image:new e.Uniform1i(t,i.u_image),u_texsize:new e.Uniform2f(t,i.u_texsize),u_pixel_coord_upper:new e.Uniform2f(t,i.u_pixel_coord_upper),u_pixel_coord_lower:new e.Uniform2f(t,i.u_pixel_coord_lower),u_scale:new e.Uniform3f(t,i.u_scale),u_fade:new e.Uniform1f(t,i.u_fade)}),circle:(t,i)=>({u_camera_to_center_distance:new e.Uniform1f(t,i.u_camera_to_center_distance),u_extrude_scale:new e.UniformMatrix2f(t,i.u_extrude_scale),u_device_pixel_ratio:new e.Uniform1f(t,i.u_device_pixel_ratio),u_matrix:new e.UniformMatrix4f(t,i.u_matrix)}),collisionBox:(t,i)=>({u_matrix:new e.UniformMatrix4f(t,i.u_matrix),u_camera_to_center_distance:new e.Uniform1f(t,i.u_camera_to_center_distance),u_extrude_scale:new e.Uniform2f(t,i.u_extrude_scale)}),collisionCircle:(t,i)=>({u_matrix:new e.UniformMatrix4f(t,i.u_matrix),u_inv_matrix:new e.UniformMatrix4f(t,i.u_inv_matrix),u_camera_to_center_distance:new e.Uniform1f(t,i.u_camera_to_center_distance),u_viewport_size:new e.Uniform2f(t,i.u_viewport_size)}),debug:(t,i)=>({u_color:new e.UniformColor(t,i.u_color),u_matrix:new e.UniformMatrix4f(t,i.u_matrix),u_overlay:new e.Uniform1i(t,i.u_overlay),u_overlay_scale:new e.Uniform1f(t,i.u_overlay_scale)}),clippingMask:(t,i)=>({u_matrix:new e.UniformMatrix4f(t,i.u_matrix)}),heatmap:(t,i)=>({u_extrude_scale:new e.Uniform1f(t,i.u_extrude_scale),u_intensity:new e.Uniform1f(t,i.u_intensity),u_matrix:new e.UniformMatrix4f(t,i.u_matrix)}),heatmapTexture:(t,i)=>({u_image:new e.Uniform1i(t,i.u_image),u_color_ramp:new e.Uniform1i(t,i.u_color_ramp),u_opacity:new e.Uniform1f(t,i.u_opacity)}),hillshade:(t,i)=>({u_matrix:new e.UniformMatrix4f(t,i.u_matrix),u_image:new e.Uniform1i(t,i.u_image),u_latrange:new e.Uniform2f(t,i.u_latrange),u_light:new e.Uniform2f(t,i.u_light),u_shadow:new e.UniformColor(t,i.u_shadow),u_highlight:new e.UniformColor(t,i.u_highlight),u_accent:new e.UniformColor(t,i.u_accent)}),hillshadePrepare:(t,i)=>({u_matrix:new e.UniformMatrix4f(t,i.u_matrix),u_image:new e.Uniform1i(t,i.u_image),u_dimension:new e.Uniform2f(t,i.u_dimension),u_zoom:new e.Uniform1f(t,i.u_zoom),u_unpack:new e.Uniform4f(t,i.u_unpack)}),line:(t,i)=>({u_matrix:new e.UniformMatrix4f(t,i.u_matrix),u_pixels_to_tile_units:new e.UniformMatrix2f(t,i.u_pixels_to_tile_units),u_device_pixel_ratio:new e.Uniform1f(t,i.u_device_pixel_ratio),u_units_to_pixels:new e.Uniform2f(t,i.u_units_to_pixels),u_dash_image:new e.Uniform1i(t,i.u_dash_image),u_gradient_image:new e.Uniform1i(t,i.u_gradient_image),u_image_height:new e.Uniform1f(t,i.u_image_height),u_texsize:new e.Uniform2f(t,i.u_texsize),u_scale:new e.Uniform3f(t,i.u_scale),u_mix:new e.Uniform1f(t,i.u_mix),u_alpha_discard_threshold:new e.Uniform1f(t,i.u_alpha_discard_threshold)}),linePattern:(t,i)=>({u_matrix:new e.UniformMatrix4f(t,i.u_matrix),u_texsize:new e.Uniform2f(t,i.u_texsize),u_pixels_to_tile_units:new e.UniformMatrix2f(t,i.u_pixels_to_tile_units),u_device_pixel_ratio:new e.Uniform1f(t,i.u_device_pixel_ratio),u_image:new e.Uniform1i(t,i.u_image),u_units_to_pixels:new e.Uniform2f(t,i.u_units_to_pixels),u_scale:new e.Uniform3f(t,i.u_scale),u_fade:new e.Uniform1f(t,i.u_fade),u_alpha_discard_threshold:new e.Uniform1f(t,i.u_alpha_discard_threshold)}),raster:(t,i)=>({u_matrix:new e.UniformMatrix4f(t,i.u_matrix),u_tl_parent:new e.Uniform2f(t,i.u_tl_parent),u_scale_parent:new e.Uniform1f(t,i.u_scale_parent),u_fade_t:new e.Uniform1f(t,i.u_fade_t),u_opacity:new e.Uniform1f(t,i.u_opacity),u_image0:new e.Uniform1i(t,i.u_image0),u_image1:new e.Uniform1i(t,i.u_image1),u_brightness_low:new e.Uniform1f(t,i.u_brightness_low),u_brightness_high:new e.Uniform1f(t,i.u_brightness_high),u_saturation_factor:new e.Uniform1f(t,i.u_saturation_factor),u_contrast_factor:new e.Uniform1f(t,i.u_contrast_factor),u_spin_weights:new e.Uniform3f(t,i.u_spin_weights),u_perspective_transform:new e.Uniform2f(t,i.u_perspective_transform)}),symbolIcon:(t,i)=>({u_is_size_zoom_constant:new e.Uniform1i(t,i.u_is_size_zoom_constant),u_is_size_feature_constant:new e.Uniform1i(t,i.u_is_size_feature_constant),u_size_t:new e.Uniform1f(t,i.u_size_t),u_size:new e.Uniform1f(t,i.u_size),u_camera_to_center_distance:new e.Uniform1f(t,i.u_camera_to_center_distance),u_pitch:new e.Uniform1f(t,i.u_pitch),u_rotate_symbol:new e.Uniform1i(t,i.u_rotate_symbol),u_aspect_ratio:new e.Uniform1f(t,i.u_aspect_ratio),u_fade_change:new e.Uniform1f(t,i.u_fade_change),u_matrix:new e.UniformMatrix4f(t,i.u_matrix),u_label_plane_matrix:new e.UniformMatrix4f(t,i.u_label_plane_matrix),u_coord_matrix:new e.UniformMatrix4f(t,i.u_coord_matrix),u_is_text:new e.Uniform1i(t,i.u_is_text),u_pitch_with_map:new e.Uniform1i(t,i.u_pitch_with_map),u_texsize:new e.Uniform2f(t,i.u_texsize),u_tile_id:new e.Uniform3f(t,i.u_tile_id),u_zoom_transition:new e.Uniform1f(t,i.u_zoom_transition),u_inv_rot_matrix:new e.UniformMatrix4f(t,i.u_inv_rot_matrix),u_merc_center:new e.Uniform2f(t,i.u_merc_center),u_texture:new e.Uniform1i(t,i.u_texture)}),symbolSDF:(t,i)=>({u_is_size_zoom_constant:new e.Uniform1i(t,i.u_is_size_zoom_constant),u_is_size_feature_constant:new e.Uniform1i(t,i.u_is_size_feature_constant),u_size_t:new e.Uniform1f(t,i.u_size_t),u_size:new e.Uniform1f(t,i.u_size),u_camera_to_center_distance:new e.Uniform1f(t,i.u_camera_to_center_distance),u_pitch:new e.Uniform1f(t,i.u_pitch),u_rotate_symbol:new e.Uniform1i(t,i.u_rotate_symbol),u_aspect_ratio:new e.Uniform1f(t,i.u_aspect_ratio),u_fade_change:new e.Uniform1f(t,i.u_fade_change),u_matrix:new e.UniformMatrix4f(t,i.u_matrix),u_label_plane_matrix:new e.UniformMatrix4f(t,i.u_label_plane_matrix),u_coord_matrix:new e.UniformMatrix4f(t,i.u_coord_matrix),u_is_text:new e.Uniform1i(t,i.u_is_text),u_pitch_with_map:new e.Uniform1i(t,i.u_pitch_with_map),u_texsize:new e.Uniform2f(t,i.u_texsize),u_texture:new e.Uniform1i(t,i.u_texture),u_gamma_scale:new e.Uniform1f(t,i.u_gamma_scale),u_device_pixel_ratio:new e.Uniform1f(t,i.u_device_pixel_ratio),u_tile_id:new e.Uniform3f(t,i.u_tile_id),u_zoom_transition:new e.Uniform1f(t,i.u_zoom_transition),u_inv_rot_matrix:new e.UniformMatrix4f(t,i.u_inv_rot_matrix),u_merc_center:new e.Uniform2f(t,i.u_merc_center),u_is_halo:new e.Uniform1i(t,i.u_is_halo)}),symbolTextAndIcon:(t,i)=>({u_is_size_zoom_constant:new e.Uniform1i(t,i.u_is_size_zoom_constant),u_is_size_feature_constant:new e.Uniform1i(t,i.u_is_size_feature_constant),u_size_t:new e.Uniform1f(t,i.u_size_t),u_size:new e.Uniform1f(t,i.u_size),u_camera_to_center_distance:new e.Uniform1f(t,i.u_camera_to_center_distance),u_pitch:new e.Uniform1f(t,i.u_pitch),u_rotate_symbol:new e.Uniform1i(t,i.u_rotate_symbol),u_aspect_ratio:new e.Uniform1f(t,i.u_aspect_ratio),u_fade_change:new e.Uniform1f(t,i.u_fade_change),u_matrix:new e.UniformMatrix4f(t,i.u_matrix),u_label_plane_matrix:new e.UniformMatrix4f(t,i.u_label_plane_matrix),u_coord_matrix:new e.UniformMatrix4f(t,i.u_coord_matrix),u_is_text:new e.Uniform1i(t,i.u_is_text),u_pitch_with_map:new e.Uniform1i(t,i.u_pitch_with_map),u_texsize:new e.Uniform2f(t,i.u_texsize),u_texsize_icon:new e.Uniform2f(t,i.u_texsize_icon),u_texture:new e.Uniform1i(t,i.u_texture),u_texture_icon:new e.Uniform1i(t,i.u_texture_icon),u_gamma_scale:new e.Uniform1f(t,i.u_gamma_scale),u_device_pixel_ratio:new e.Uniform1f(t,i.u_device_pixel_ratio),u_is_halo:new e.Uniform1i(t,i.u_is_halo)}),background:(t,i)=>({u_matrix:new e.UniformMatrix4f(t,i.u_matrix),u_opacity:new e.Uniform1f(t,i.u_opacity),u_color:new e.UniformColor(t,i.u_color)}),backgroundPattern:(t,i)=>({u_matrix:new e.UniformMatrix4f(t,i.u_matrix),u_opacity:new e.Uniform1f(t,i.u_opacity),u_image:new e.Uniform1i(t,i.u_image),u_pattern_tl_a:new e.Uniform2f(t,i.u_pattern_tl_a),u_pattern_br_a:new e.Uniform2f(t,i.u_pattern_br_a),u_pattern_tl_b:new e.Uniform2f(t,i.u_pattern_tl_b),u_pattern_br_b:new e.Uniform2f(t,i.u_pattern_br_b),u_texsize:new e.Uniform2f(t,i.u_texsize),u_mix:new e.Uniform1f(t,i.u_mix),u_pattern_size_a:new e.Uniform2f(t,i.u_pattern_size_a),u_pattern_size_b:new e.Uniform2f(t,i.u_pattern_size_b),u_scale_a:new e.Uniform1f(t,i.u_scale_a),u_scale_b:new e.Uniform1f(t,i.u_scale_b),u_pixel_coord_upper:new e.Uniform2f(t,i.u_pixel_coord_upper),u_pixel_coord_lower:new e.Uniform2f(t,i.u_pixel_coord_lower),u_tile_units_to_pixels:new e.Uniform1f(t,i.u_tile_units_to_pixels)}),terrainRaster:ei,terrainDepth:ei,skybox:(t,i)=>({u_matrix:new e.UniformMatrix4f(t,i.u_matrix),u_sun_direction:new e.Uniform3f(t,i.u_sun_direction),u_cubemap:new e.Uniform1i(t,i.u_cubemap),u_opacity:new e.Uniform1f(t,i.u_opacity),u_temporal_offset:new e.Uniform1f(t,i.u_temporal_offset)}),skyboxGradient:(t,i)=>({u_matrix:new e.UniformMatrix4f(t,i.u_matrix),u_color_ramp:new e.Uniform1i(t,i.u_color_ramp),u_center_direction:new e.Uniform3f(t,i.u_center_direction),u_radius:new e.Uniform1f(t,i.u_radius),u_opacity:new e.Uniform1f(t,i.u_opacity),u_temporal_offset:new e.Uniform1f(t,i.u_temporal_offset)}),skyboxCapture:(t,i)=>({u_matrix_3f:new e.UniformMatrix3f(t,i.u_matrix_3f),u_sun_direction:new e.Uniform3f(t,i.u_sun_direction),u_sun_intensity:new e.Uniform1f(t,i.u_sun_intensity),u_color_tint_r:new e.Uniform4f(t,i.u_color_tint_r),u_color_tint_m:new e.Uniform4f(t,i.u_color_tint_m),u_luminance:new e.Uniform1f(t,i.u_luminance)}),globeRaster:(t,i)=>({u_proj_matrix:new e.UniformMatrix4f(t,i.u_proj_matrix),u_globe_matrix:new e.UniformMatrix4f(t,i.u_globe_matrix),u_merc_matrix:new e.UniformMatrix4f(t,i.u_merc_matrix),u_zoom_transition:new e.Uniform1f(t,i.u_zoom_transition),u_merc_center:new e.Uniform2f(t,i.u_merc_center),u_image0:new e.Uniform1i(t,i.u_image0)}),globeAtmosphere:(t,i)=>({u_center:new e.Uniform2f(t,i.u_center),u_radius:new e.Uniform1f(t,i.u_radius),u_screen_size:new e.Uniform2f(t,i.u_screen_size),u_pixel_ratio:new e.Uniform1f(t,i.u_pixel_ratio),u_opacity:new e.Uniform1f(t,i.u_opacity),u_fadeout_range:new e.Uniform1f(t,i.u_fadeout_range),u_start_color:new e.Uniform3f(t,i.u_start_color),u_end_color:new e.Uniform3f(t,i.u_end_color)})};let Ni;function Gi(t,i,o,r,n,a,s){const l=t.context,c=l.gl,h=t.useProgram("collisionBox"),u=[];let _=0,d=0;for(let p=0;p<r.length;p++){const m=r[p],f=i.getTile(m),g=f.getBucket(o);if(!g)continue;let v=m.projMatrix;0===n[0]&&0===n[1]||(v=t.translatePosMatrix(m.projMatrix,f,n,a));const x=s?g.textCollisionBox:g.iconCollisionBox,y=g.collisionCircleArray;if(y.length>0){const i=e.create(),o=v;e.mul(i,g.placementInvProjMatrix,t.transform.glCoordMatrix),e.mul(i,i,g.placementViewportMatrix),u.push({circleArray:y,circleOffset:d,transform:o,invTransform:i}),_+=y.length/4,d=_;}x&&(t.terrain&&t.terrain.setupElevationDraw(f,h),h.draw(l,c.LINES,e.DepthMode.disabled,e.StencilMode.disabled,t.colorModeForRenderPass(),e.CullFaceMode.disabled,Ei(v,t.transform,f),o.id,x.layoutVertexBuffer,x.indexBuffer,x.segments,null,t.transform.zoom,null,x.collisionVertexBuffer,x.collisionVertexBufferExt));}if(!s||!u.length)return;const p=t.useProgram("collisionCircle"),m=new e.StructArrayLayout2f1f2i16;m.resize(4*_),m._trim();let f=0;for(const e of u)for(let t=0;t<e.circleArray.length/4;t++){const i=4*t,o=e.circleArray[i+0],r=e.circleArray[i+1],n=e.circleArray[i+2],a=e.circleArray[i+3];m.emplace(f++,o,r,n,a,0),m.emplace(f++,o,r,n,a,1),m.emplace(f++,o,r,n,a,2),m.emplace(f++,o,r,n,a,3);}(!Ni||Ni.length<2*_)&&(Ni=function(t){const i=2*t,o=new e.StructArrayLayout3ui6;o.resize(i),o._trim();for(let e=0;e<i;e++){const t=6*e;o.uint16[t+0]=4*e+0,o.uint16[t+1]=4*e+1,o.uint16[t+2]=4*e+2,o.uint16[t+3]=4*e+2,o.uint16[t+4]=4*e+3,o.uint16[t+5]=4*e+0;}return o}(_));const g=l.createIndexBuffer(Ni,!0),v=l.createVertexBuffer(m,e.collisionCircleLayout.members,!0);for(const i of u){const r={u_matrix:i.transform,u_inv_matrix:i.invTransform,u_camera_to_center_distance:(x=t.transform).cameraToCenterDistance,u_viewport_size:[x.width,x.height]};p.draw(l,c.TRIANGLES,e.DepthMode.disabled,e.StencilMode.disabled,t.colorModeForRenderPass(),e.CullFaceMode.disabled,r,o.id,v,g,e.SegmentVector.simpleSegment(0,2*i.circleOffset,i.circleArray.length,i.circleArray.length/2),null,t.transform.zoom,null,null,null);}var x;v.destroy(),g.destroy();}const ji=e.identity(new Float32Array(16));function Zi(t,i,o,r,n,a){const{horizontalAlign:s,verticalAlign:l}=e.getAnchorAlignment(t),c=-(s-.5)*i,h=-(l-.5)*o,u=e.evaluateVariableOffset(t,r);return new e.pointGeometry((c/n+u[0])*a,(h/n+u[1])*a)}function Vi(t,i,o,r,n,a,s,l,c,h,u,_){const d=t.text.placedSymbolArray,p=t.text.dynamicLayoutVertexArray,m=t.icon.dynamicLayoutVertexArray,f={},g=l.projMatrix,v=a.elevation,x=v?v.getAtTileOffsetFunc(l,_):e=>[0,0,0];p.clear();for(let l=0;l<d.length;l++){const _=d.get(l),m=t.allowVerticalPlacement&&!_.placedOrientation,v=_.hidden||!_.crossTileID||m?null:r[_.crossTileID];if(v){const r=new e.pointGeometry(_.tileAnchorX,_.tileAnchorY),l=x(r),d=$e(r,o?g:s,l[2]),m=He(a.cameraToCenterDistance,d.signedDistanceFromCamera);let y=n.evaluateSizeForFeature(t.textSizeData,h,_)*m/e.ONE_EM;o&&(y*=t.tilePixelRatio/c);const{width:b,height:w,anchor:T,textOffset:E,textScale:C}=v,M=Zi(T,b,w,E,C,y),S=o?$e(r.add(M),s,l[2]).point:d.point.add(i?M.rotate(-a.angle):M),I=t.allowVerticalPlacement&&_.placedOrientation===e.WritingMode.vertical?Math.PI/2:0;for(let t=0;t<_.numGlyphs;t++)e.addDynamicAttributes(p,S,I);u&&_.associatedIconIndex>=0&&(f[_.associatedIconIndex]={shiftedAnchor:S,angle:I});}else nt(_.numGlyphs,p);}if(u){m.clear();const i=t.icon.placedSymbolArray;for(let t=0;t<i.length;t++){const o=i.get(t);if(o.hidden)nt(o.numGlyphs,m);else {const i=f[t];if(i)for(let t=0;t<o.numGlyphs;t++)e.addDynamicAttributes(m,i.shiftedAnchor,i.angle);else nt(o.numGlyphs,m);}}t.icon.dynamicLayoutVertexBuffer.updateData(m);}t.text.dynamicLayoutVertexBuffer.updateData(p);}function Wi(e,t,i){return i.iconsInText&&t?"symbolTextAndIcon":e?"symbolSDF":"symbolIcon"}function qi(t,i,o,r,n,a,s,l,c,h,u,_){const d=t.context,p=d.gl,m=t.transform,f=m.projection.createTileTransform(m,m.worldSize),g="map"===l,v="map"===c,x=g&&"point"!==o.layout.get("symbol-placement"),y=g&&!v&&!x,b=void 0!==o.layout.get("symbol-sort-key").constantOr(1);let w=!1;const T=t.depthModeForSublayer(0,e.DepthMode.ReadOnly),E=[e.mercatorXfromLng(m.center.lng),e.mercatorYfromLat(m.center.lat)],C=o.layout.get("text-variable-anchor"),M="globe"===m.projection.name,S=M?e.globeToMercatorTransition(m.zoom):0,I=[],z=[];t.terrain&&v&&z.push("PITCH_WITH_MAP_TERRAIN"),M&&z.push("PROJECTION_GLOBE_VIEW"),x&&z.push("PROJECTED_POS_ON_VIEWPORT");for(const l of r){const r=i.getTile(l),c=r.getBucket(o);if(!c||c.projection!==m.projection.name)continue;const u=n?c.text:c.icon;if(!u||c.fullyClipped||!u.segments.get().length)continue;const _=u.programConfigurations.get(o.id),d=n||c.sdfIcons,T=n?c.textSizeData:c.iconSizeData,M=v||0!==m.pitch,D=t.useProgram(Wi(d,n,c),_,z),P=e.evaluateSizeForZoom(T,m.zoom),A=[l.canonical.x,l.canonical.y,1<<l.canonical.z];let L,R,k,O,B=[0,0],F=null;if(n){if(R=r.glyphAtlasTexture,k=p.LINEAR,L=r.glyphAtlasTexture.size,c.iconsInText){B=r.imageAtlasTexture.size,F=r.imageAtlasTexture;const e="composite"===T.kind||"camera"===T.kind;O=M||t.options.rotating||t.options.zooming||e?p.LINEAR:p.NEAREST;}}else {const e=1!==o.layout.get("icon-size").constantOr(0)||c.iconsNeedLinear;R=r.imageAtlasTexture,k=d||t.options.rotating||t.options.zooming||e||M?p.LINEAR:p.NEAREST,L=r.imageAtlasTexture.size;}const U=t.transform.calculatePixelsToTileUnitsMatrix(r),N=qe(l.projMatrix,r.tileID.canonical,v,g,t.transform,U),G=t.terrain&&v&&x?e.invert(new Float32Array(16),N):ji,j=Xe(l.projMatrix,r.tileID.canonical,v,g,t.transform,U),Z=C&&c.hasTextData(),V="none"!==o.layout.get("icon-text-fit")&&Z&&c.hasIconData();if(x){const e=m.elevation,i=e?e.getAtTileOffsetFunc(l,f):e=>[0,0,0];Ye(c,l.projMatrix,t,n,N,j,v,h,i,l);}const W=t.translatePosMatrix(l.projMatrix,r,a,s),q=x||n&&C||V?ji:N,X=t.translatePosMatrix(j,r,a,s,!0),$=d&&0!==o.paint.get(n?"text-halo-width":"icon-halo-width").constantOr(1);let H;const K=f.createInversionMatrix(l.toUnwrapped());H=d?c.iconsInText?Oi(T.kind,P,y,v,t,W,q,X,L,B,A,S,K,E):ki(T.kind,P,y,v,t,W,q,X,n,L,!0,A,S,K,E):Ri(T.kind,P,y,v,t,W,q,X,n,L,A,S,K,E);const Y={program:D,buffers:u,uniformValues:H,atlasTexture:R,atlasTextureIcon:F,atlasInterpolation:k,atlasInterpolationIcon:O,isSDF:d,hasHalo:$,tile:r,labelPlaneMatrixInv:G};if(b&&c.canOverlap){w=!0;const t=u.segments.get();for(const i of t)I.push({segments:new e.SegmentVector([i]),sortKey:i.sortKey,state:Y});}else I.push({segments:u.segments,sortKey:0,state:Y});}w&&I.sort(((e,t)=>e.sortKey-t.sortKey));for(const e of I){const i=e.state;if(t.terrain&&t.terrain.setupElevationDraw(i.tile,i.program,{useDepthForOcclusion:!M,labelPlaneMatrixInv:i.labelPlaneMatrixInv}),d.activeTexture.set(p.TEXTURE0),i.atlasTexture.bind(i.atlasInterpolation,p.CLAMP_TO_EDGE),i.atlasTextureIcon&&(d.activeTexture.set(p.TEXTURE1),i.atlasTextureIcon&&i.atlasTextureIcon.bind(i.atlasInterpolationIcon,p.CLAMP_TO_EDGE)),i.isSDF){const r=i.uniformValues;i.hasHalo&&(r.u_is_halo=1,Xi(i.buffers,e.segments,o,t,i.program,T,u,_,r)),r.u_is_halo=0;}Xi(i.buffers,e.segments,o,t,i.program,T,u,_,i.uniformValues);}}function Xi(t,i,o,r,n,a,s,l,c){const h=r.context;n.draw(h,h.gl.TRIANGLES,a,s,l,e.CullFaceMode.disabled,c,o.id,t.layoutVertexBuffer,t.indexBuffer,i,o.paint,r.transform.zoom,t.programConfigurations.get(o.id),t.dynamicLayoutVertexBuffer,t.opacityVertexBuffer);}function $i(t,i,o,r,n,a,s){const l=t.context.gl,c=o.paint.get("fill-pattern"),h=c&&c.constantOr(1),u=o.getCrossfadeParameters();let _,d,p,m,f;s?(d=h&&!o.getPaintProperty("fill-outline-color")?"fillOutlinePattern":"fillOutline",_=l.LINES):(d=h?"fillPattern":"fill",_=l.TRIANGLES);for(const g of r){const r=i.getTile(g);if(h&&!r.patternsLoaded())continue;const v=r.getBucket(o);if(!v)continue;t.prepareDrawTile(g);const x=v.programConfigurations.get(o.id),y=t.useProgram(d,x);h&&(t.context.activeTexture.set(l.TEXTURE0),r.imageAtlasTexture.bind(l.LINEAR,l.CLAMP_TO_EDGE),x.updatePaintBuffers(u));const b=c.constantOr(null);if(b&&r.imageAtlas){const e=r.imageAtlas,t=e.patternPositions[b.to.toString()],i=e.patternPositions[b.from.toString()];t&&i&&x.setConstantPatternPositions(t,i);}const w=t.translatePosMatrix(g.projMatrix,r,o.paint.get("fill-translate"),o.paint.get("fill-translate-anchor"));if(s){m=v.indexBuffer2,f=v.segments2;const e=t.terrain&&t.terrain.renderingToTexture?t.terrain.drapeBufferSize:[l.drawingBufferWidth,l.drawingBufferHeight];p="fillOutlinePattern"===d&&h?bi(w,t,u,r,e):yi(w,e);}else m=v.indexBuffer,f=v.segments,p=h?xi(w,t,u,r):vi(w);t.prepareDrawProgram(t.context,y,g.toUnwrapped()),y.draw(t.context,_,n,t.stencilModeForClipping(g),a,e.CullFaceMode.disabled,p,o.id,v.layoutVertexBuffer,m,f,o.paint,t.transform.zoom,x);}}function Hi(t,i,o,r,n,a,s){const l=t.context,c=l.gl,h=o.paint.get("fill-extrusion-pattern"),u=h.constantOr(1),_=o.getCrossfadeParameters(),d=o.paint.get("fill-extrusion-opacity");for(const p of r){const r=i.getTile(p),m=r.getBucket(o);if(!m)continue;const f=m.programConfigurations.get(o.id),g=t.useProgram(u?"fillExtrusionPattern":"fillExtrusion",f);if(t.terrain){const e=t.terrain;if(!m.enableTerrain)continue;if(e.setupElevationDraw(r,g,{useMeterToDem:!0}),Ki(l,i,p,m,o,e),!m.centroidVertexBuffer){const e=g.attributes.a_centroid_pos;void 0!==e&&c.vertexAttrib2f(e,0,0);}}u&&(t.context.activeTexture.set(c.TEXTURE0),r.imageAtlasTexture.bind(c.LINEAR,c.CLAMP_TO_EDGE),f.updatePaintBuffers(_));const v=h.constantOr(null);if(v&&r.imageAtlas){const e=r.imageAtlas,t=e.patternPositions[v.to.toString()],i=e.patternPositions[v.from.toString()];t&&i&&f.setConstantPatternPositions(t,i);}const x=t.translatePosMatrix(p.projMatrix,r,o.paint.get("fill-extrusion-translate"),o.paint.get("fill-extrusion-translate-anchor")),y=o.paint.get("fill-extrusion-vertical-gradient"),b=u?gi(x,t,y,d,p,_,r):fi(x,t,y,d);t.prepareDrawProgram(l,g,p.toUnwrapped()),g.draw(l,l.gl.TRIANGLES,n,a,s,e.CullFaceMode.backCCW,b,o.id,m.layoutVertexBuffer,m.indexBuffer,m.segments,o.paint,t.transform.zoom,f,t.terrain?m.centroidVertexBuffer:null);}}function Ki(t,i,o,r,n,a){const s=[t=>{let i=t.canonical.x-1,o=t.wrap;return i<0&&(i=(1<<t.canonical.z)-1,o--),new e.OverscaledTileID(t.overscaledZ,o,t.canonical.z,i,t.canonical.y)},t=>{let i=t.canonical.x+1,o=t.wrap;return i===1<<t.canonical.z&&(i=0,o++),new e.OverscaledTileID(t.overscaledZ,o,t.canonical.z,i,t.canonical.y)},t=>new e.OverscaledTileID(t.overscaledZ,t.wrap,t.canonical.z,t.canonical.x,(0===t.canonical.y?1<<t.canonical.z:t.canonical.y)-1),t=>new e.OverscaledTileID(t.overscaledZ,t.wrap,t.canonical.z,t.canonical.x,t.canonical.y===(1<<t.canonical.z)-1?0:t.canonical.y+1)],l=e=>{const t=i.getSource().maxzoom,o=e=>{const t=i.getTileByID(e);if(t&&t.hasData())return t.getBucket(n)};let r,a,s;return (e.overscaledZ===e.canonical.z||e.overscaledZ>=t)&&(r=o(e.key)),e.overscaledZ>=t&&(a=o(e.calculateScaledKey(e.overscaledZ+1))),e.overscaledZ>t&&(s=o(e.calculateScaledKey(e.overscaledZ-1))),r||a||s},c=[0,0,0],h=(t,i)=>(c[0]=Math.min(t.min.y,i.min.y),c[1]=Math.max(t.max.y,i.max.y),c[2]=e.EXTENT-i.min.x>t.max.x?i.min.x-e.EXTENT:t.max.x,c),u=(t,i)=>(c[0]=Math.min(t.min.x,i.min.x),c[1]=Math.max(t.max.x,i.max.x),c[2]=e.EXTENT-i.min.y>t.max.y?i.min.y-e.EXTENT:t.max.y,c),_=[(e,t)=>h(e,t),(e,t)=>h(t,e),(e,t)=>u(e,t),(e,t)=>u(t,e)],d=new e.pointGeometry(0,0);let p,m,f;const g=(t,i,r,n,s)=>{const l=[[n?r:t,n?t:r,0],[n?r:i,n?i:r,0]],c=s<0?e.EXTENT+s:s,h=[n?c:(t+i)/2,n?(t+i)/2:c,0];return 0===r&&s<0||0!==r&&s>0?a.getForTilePoints(f,[h],!0,m):l.push(h),a.getForTilePoints(o,l,!0,p),Math.max(l[0][2],l[1][2],h[2])/a.exaggeration()};for(let t=0;t<4;t++){const i=r.borders[t];if(0===i.length&&(r.borderDone[t]=!0),r.borderDone[t])continue;const n=f=s[t](o),c=l(n);if(!c||!c.enableTerrain)continue;if(m=a.findDEMTileFor(n),!m||!m.dem)continue;if(!p){const e=a.findDEMTileFor(o);if(!e||!e.dem)return;p=e;}const h=(t<2?1:5)-t,u=c.borders[h];let v=0;for(let o=0;o<i.length;o++){const n=r.featuresOnBorder[i[o]],a=n.borders[t];let s;for(;v<u.length&&(s=c.featuresOnBorder[u[v]],!(s.borders[h][1]>a[0]+3));)c.borderDone[h]||c.encodeCentroid(void 0,s,!1),v++;if(s&&v<u.length){const i=v;let o=0;for(;!(s.borders[h][0]>a[1]-3)&&(o++,++v!==u.length);)s=c.featuresOnBorder[u[v]];if(s=c.featuresOnBorder[u[i]],n.intersectsCount()>1||s.intersectsCount()>1||1!==o){1!==o&&(v=i),r.encodeCentroid(void 0,n,!1),c.borderDone[h]||c.encodeCentroid(void 0,s,!1);continue}const l=_[t](n,s),p=t%2?e.EXTENT-1:0;d.x=g(l[0],Math.min(e.EXTENT-1,l[1]),p,t<2,l[2]),d.y=0,r.encodeCentroid(d,n,!1),c.borderDone[h]||c.encodeCentroid(d,s,!1);}else r.encodeCentroid(void 0,n,!1);}r.borderDone[t]=r.needsCentroidUpdate=!0,c.borderDone[h]||(c.borderDone[h]=c.needsCentroidUpdate=!0);}(r.needsCentroidUpdate||!r.centroidVertexBuffer&&0!==r.centroidVertexArray.length)&&r.uploadCentroid(t);}const Yi=new e.Color(1,0,0,1),Ji=new e.Color(0,1,0,1),Qi=new e.Color(0,0,1,1),eo=new e.Color(1,0,1,1),to=new e.Color(0,1,1,1);function io(e,t,i,o){ro(e,0,t+i/2,e.transform.width,i,o);}function oo(e,t,i,o){ro(e,t-i/2,0,i,e.transform.height,o);}function ro(t,i,o,r,n,a){const s=t.context,l=s.gl;l.enable(l.SCISSOR_TEST),l.scissor(i*e.exported.devicePixelRatio,o*e.exported.devicePixelRatio,r*e.exported.devicePixelRatio,n*e.exported.devicePixelRatio),s.clear({color:a}),l.disable(l.SCISSOR_TEST);}function no(t,i,o){const r=t.context,n=r.gl,a=o.projMatrix,s=t.useProgram("debug"),l=i.getTileByID(o.key);t.terrain&&t.terrain.setupElevationDraw(l,s);const c=e.DepthMode.disabled,h=e.StencilMode.disabled,u=t.colorModeForRenderPass(),_="$debug";r.activeTexture.set(n.TEXTURE0),t.emptyTexture.bind(n.LINEAR,n.CLAMP_TO_EDGE),l._makeDebugTileBoundsBuffers(t.context,t.transform.projection);const d=l._tileDebugBuffer||t.debugBuffer,p=l._tileDebugIndexBuffer||t.debugIndexBuffer,m=l._tileDebugSegments||t.debugSegments;s.draw(r,n.LINE_STRIP,c,h,u,e.CullFaceMode.disabled,Ci(a,e.Color.red),_,d,p,m);const f=l.latestRawTileData,g=Math.floor((f&&f.byteLength||0)/1024),v=i.getTile(o).tileSize,x=512/Math.min(v,512)*(o.overscaledZ/t.transform.zoom)*.5;let y=o.canonical.toString();o.overscaledZ!==o.canonical.z&&(y+=` => ${o.overscaledZ}`),function(e,t){e.initDebugOverlayCanvas();const i=e.debugOverlayCanvas,o=e.context.gl,r=e.debugOverlayCanvas.getContext("2d");r.clearRect(0,0,i.width,i.height),r.shadowColor="white",r.shadowBlur=2,r.lineWidth=1.5,r.strokeStyle="white",r.textBaseline="top",r.font="bold 36px Open Sans, sans-serif",r.fillText(t,5,5),r.strokeText(t,5,5),e.debugOverlayTexture.update(i),e.debugOverlayTexture.bind(o.LINEAR,o.CLAMP_TO_EDGE);}(t,`${y} ${g}kb`),s.draw(r,n.TRIANGLES,c,h,e.ColorMode.alphaBlended,e.CullFaceMode.disabled,Ci(a,e.Color.transparent,x),_,t.debugBuffer,t.quadTriangleIndexBuffer,t.debugSegments);}const ao=e.createLayout([{name:"a_pos_3f",components:3,type:"Float32"}]),{members:so}=ao;function lo(e,t,i,o){e.emplaceBack(t,i,o);}class co{constructor(t){this.vertexArray=new e.StructArrayLayout3f12,this.indices=new e.StructArrayLayout3ui6,lo(this.vertexArray,-1,-1,1),lo(this.vertexArray,1,-1,1),lo(this.vertexArray,-1,1,1),lo(this.vertexArray,1,1,1),lo(this.vertexArray,-1,-1,-1),lo(this.vertexArray,1,-1,-1),lo(this.vertexArray,-1,1,-1),lo(this.vertexArray,1,1,-1),this.indices.emplaceBack(5,1,3),this.indices.emplaceBack(3,7,5),this.indices.emplaceBack(6,2,0),this.indices.emplaceBack(0,4,6),this.indices.emplaceBack(2,6,7),this.indices.emplaceBack(7,3,2),this.indices.emplaceBack(5,4,0),this.indices.emplaceBack(0,1,5),this.indices.emplaceBack(0,2,3),this.indices.emplaceBack(3,1,0),this.indices.emplaceBack(7,6,4),this.indices.emplaceBack(4,5,7),this.vertexBuffer=t.createVertexBuffer(this.vertexArray,so),this.indexBuffer=t.createIndexBuffer(this.indices),this.segment=e.SegmentVector.simpleSegment(0,0,36,12);}}function ho(t,i,o,r,n,a){const s=t.gl,l=i.paint.get("sky-atmosphere-color"),c=i.paint.get("sky-atmosphere-halo-color"),h=i.paint.get("sky-atmosphere-sun-intensity"),u=((e,t,i,o,r)=>({u_matrix_3f:e,u_sun_direction:t,u_sun_intensity:i,u_color_tint_r:[o.r,o.g,o.b,o.a],u_color_tint_m:[r.r,r.g,r.b,r.a],u_luminance:5e-5}))(e.fromMat4([],r),n,h,l,c);s.framebufferTexture2D(s.FRAMEBUFFER,s.COLOR_ATTACHMENT0,s.TEXTURE_CUBE_MAP_POSITIVE_X+a,i.skyboxTexture,0),o.draw(t,s.TRIANGLES,e.DepthMode.disabled,e.StencilMode.disabled,e.ColorMode.unblended,e.CullFaceMode.frontCW,u,"skyboxCapture",i.skyboxGeometry.vertexBuffer,i.skyboxGeometry.indexBuffer,i.skyboxGeometry.segment);}const uo={symbol:function(t,i,o,r,n){if("translucent"!==t.renderPass)return;const a=e.StencilMode.disabled,s=t.colorModeForRenderPass();o.layout.get("text-variable-anchor")&&function(t,i,o,r,n,a,s){const l=i.transform,c="map"===n,h="map"===a,u=l.projection.createTileTransform(l,l.worldSize);for(const n of t){const t=r.getTile(n),a=t.getBucket(o);if(!a||a.projection!==l.projection.name||!a.text||!a.text.segments.get().length)continue;const _=e.evaluateSizeForZoom(a.textSizeData,l.zoom),d=i.transform.calculatePixelsToTileUnitsMatrix(t),p=qe(n.projMatrix,t.tileID.canonical,h,c,i.transform,d),m="none"!==o.layout.get("icon-text-fit")&&a.hasIconData();if(_){const i=Math.pow(2,l.zoom-t.tileID.overscaledZ);Vi(a,c,h,s,e.symbolSize,l,p,n,i,_,m,u);}}}(r,t,o,i,o.layout.get("text-rotation-alignment"),o.layout.get("text-pitch-alignment"),n),0!==o.paint.get("icon-opacity").constantOr(1)&&qi(t,i,o,r,!1,o.paint.get("icon-translate"),o.paint.get("icon-translate-anchor"),o.layout.get("icon-rotation-alignment"),o.layout.get("icon-pitch-alignment"),o.layout.get("icon-keep-upright"),a,s),0!==o.paint.get("text-opacity").constantOr(1)&&qi(t,i,o,r,!0,o.paint.get("text-translate"),o.paint.get("text-translate-anchor"),o.layout.get("text-rotation-alignment"),o.layout.get("text-pitch-alignment"),o.layout.get("text-keep-upright"),a,s),i.map.showCollisionBoxes&&(Gi(t,i,o,r,o.paint.get("text-translate"),o.paint.get("text-translate-anchor"),!0),Gi(t,i,o,r,o.paint.get("icon-translate"),o.paint.get("icon-translate-anchor"),!1));},circle:function(t,i,o,r){if("translucent"!==t.renderPass)return;const n=o.paint.get("circle-opacity"),a=o.paint.get("circle-stroke-width"),s=o.paint.get("circle-stroke-opacity"),l=void 0!==o.layout.get("circle-sort-key").constantOr(1);if(0===n.constantOr(1)&&(0===a.constantOr(1)||0===s.constantOr(1)))return;const c=t.context,h=c.gl,u=t.depthModeForSublayer(0,e.DepthMode.ReadOnly),_=e.StencilMode.disabled,d=t.colorModeForRenderPass(),p=[];for(let n=0;n<r.length;n++){const a=r[n],s=i.getTile(a),c=s.getBucket(o);if(!c)continue;const h=c.programConfigurations.get(o.id),u=Ti(o),_={programConfiguration:h,program:t.useProgram("circle",h,u),layoutVertexBuffer:c.layoutVertexBuffer,indexBuffer:c.indexBuffer,uniformValues:wi(t,a,s,o),tile:s};if(l){const t=c.segments.get();for(const i of t)p.push({segments:new e.SegmentVector([i]),sortKey:i.sortKey,state:_});}else p.push({segments:c.segments,sortKey:0,state:_});}l&&p.sort(((e,t)=>e.sortKey-t.sortKey));const m={useDepthForOcclusion:!("globe"===t.transform.projection.name)};for(const i of p){const{programConfiguration:r,program:n,layoutVertexBuffer:a,indexBuffer:s,uniformValues:l,tile:p}=i.state,f=i.segments;t.terrain&&t.terrain.setupElevationDraw(p,n,m),t.prepareDrawProgram(c,n,p.tileID.toUnwrapped()),n.draw(c,h.TRIANGLES,u,_,d,e.CullFaceMode.disabled,l,o.id,a,s,f,o.paint,t.transform.zoom,r);}},heatmap:function(t,i,o,r){if(0!==o.paint.get("heatmap-opacity"))if("offscreen"===t.renderPass){const n=t.context,a=n.gl,s=e.StencilMode.disabled,l=new e.ColorMode([a.ONE,a.ONE],e.Color.transparent,[!0,!0,!0,!0]);!function(e,t,i){const o=e.gl;e.activeTexture.set(o.TEXTURE1),e.viewport.set([0,0,t.width/4,t.height/4]);let r=i.heatmapFbo;if(r)o.bindTexture(o.TEXTURE_2D,r.colorAttachment.get()),e.bindFramebuffer.set(r.framebuffer);else {const n=o.createTexture();o.bindTexture(o.TEXTURE_2D,n),o.texParameteri(o.TEXTURE_2D,o.TEXTURE_WRAP_S,o.CLAMP_TO_EDGE),o.texParameteri(o.TEXTURE_2D,o.TEXTURE_WRAP_T,o.CLAMP_TO_EDGE),o.texParameteri(o.TEXTURE_2D,o.TEXTURE_MIN_FILTER,o.LINEAR),o.texParameteri(o.TEXTURE_2D,o.TEXTURE_MAG_FILTER,o.LINEAR),r=i.heatmapFbo=e.createFramebuffer(t.width/4,t.height/4,!1),function(e,t,i,o){const r=e.gl;r.texImage2D(r.TEXTURE_2D,0,r.RGBA,t.width/4,t.height/4,0,r.RGBA,e.extRenderToTextureHalfFloat?e.extTextureHalfFloat.HALF_FLOAT_OES:r.UNSIGNED_BYTE,null),o.colorAttachment.set(i);}(e,t,n,r);}}(n,t,o),n.clear({color:e.Color.transparent});for(let c=0;c<r.length;c++){const h=r[c];if(i.hasRenderableParent(h))continue;const u=i.getTile(h),_=u.getBucket(o);if(!_)continue;const d=_.programConfigurations.get(o.id),p=t.useProgram("heatmap",d),{zoom:m}=t.transform;t.terrain&&t.terrain.setupElevationDraw(u,p),t.prepareDrawProgram(n,p,h.toUnwrapped()),p.draw(n,a.TRIANGLES,e.DepthMode.disabled,s,l,e.CullFaceMode.disabled,Mi(h.projMatrix,u,m,o.paint.get("heatmap-intensity")),o.id,_.layoutVertexBuffer,_.indexBuffer,_.segments,o.paint,t.transform.zoom,d);}n.viewport.set([0,0,t.width,t.height]);}else "translucent"===t.renderPass&&(t.context.setColorMode(t.colorModeForRenderPass()),function(t,i){const o=t.context,r=o.gl,n=i.heatmapFbo;if(!n)return;o.activeTexture.set(r.TEXTURE0),r.bindTexture(r.TEXTURE_2D,n.colorAttachment.get()),o.activeTexture.set(r.TEXTURE1);let a=i.colorRampTexture;a||(a=i.colorRampTexture=new e.Texture(o,i.colorRamp,r.RGBA)),a.bind(r.LINEAR,r.CLAMP_TO_EDGE),t.useProgram("heatmapTexture").draw(o,r.TRIANGLES,e.DepthMode.disabled,e.StencilMode.disabled,t.colorModeForRenderPass(),e.CullFaceMode.disabled,((e,t,i,o)=>({u_image:0,u_color_ramp:1,u_opacity:t.paint.get("heatmap-opacity")}))(0,i),i.id,t.viewportBuffer,t.quadTriangleIndexBuffer,t.viewportSegments,i.paint,t.transform.zoom);}(t,o));},line:function(t,i,o,r){if("translucent"!==t.renderPass)return;const n=o.paint.get("line-opacity"),a=o.paint.get("line-width");if(0===n.constantOr(1)||0===a.constantOr(1))return;const s=t.depthModeForSublayer(0,e.DepthMode.ReadOnly),l=t.colorModeForRenderPass(),c=o.paint.get("line-dasharray"),h=c.constantOr(1),u=o.layout.get("line-cap"),_=o.paint.get("line-pattern"),d=_.constantOr(1),p=o.paint.get("line-gradient"),m=o.getCrossfadeParameters(),f=d?"linePattern":"line",g=t.context,v=g.gl,x=(e=>{const t=[];Pi(e)&&t.push("RENDER_LINE_DASH"),e.paint.get("line-gradient")&&t.push("RENDER_LINE_GRADIENT");const i=e.paint.get("line-pattern").constantOr(1),o=1!==e.paint.get("line-opacity").constantOr(1);return !i&&o&&t.push("RENDER_LINE_ALPHA_DISCARD"),t})(o);let y=x.includes("RENDER_LINE_ALPHA_DISCARD");t.terrain&&t.terrain.clipOrMaskOverlapStencilType()&&(y=!1);for(const n of r){const r=i.getTile(n);if(d&&!r.patternsLoaded())continue;const a=r.getBucket(o);if(!a)continue;t.prepareDrawTile(n);const b=a.programConfigurations.get(o.id),w=t.useProgram(f,b,x),T=_.constantOr(null);if(T&&r.imageAtlas){const e=r.imageAtlas,t=e.patternPositions[T.to.toString()],i=e.patternPositions[T.from.toString()];t&&i&&b.setConstantPatternPositions(t,i);}const E=c.constantOr(null),C=u.constantOr(null);if(!d&&E&&C&&r.lineAtlas){const e=r.lineAtlas,t=e.getDash(E.to,C),i=e.getDash(E.from,C);t&&i&&b.setConstantPatternPositions(t,i);}const M=t.terrain?n.projMatrix:null,S=d?Ii(t,r,o,m,M):Si(t,r,o,m,M,a.lineClipsArray.length);if(p){const r=a.gradients[o.id];let s=r.texture;if(o.gradientVersion!==r.version){let l=256;if(o.stepInterpolant){const o=i.getSource().maxzoom,r=n.canonical.z===o?Math.ceil(1<<t.transform.maxZoom-n.canonical.z):1;l=e.clamp(e.nextPowerOfTwo(a.maxLineLength/e.EXTENT*1024*r),256,g.maxTextureSize);}r.gradient=e.renderColorRamp({expression:o.gradientExpression(),evaluationKey:"lineProgress",resolution:l,image:r.gradient||void 0,clips:a.lineClipsArray}),r.texture?r.texture.update(r.gradient):r.texture=new e.Texture(g,r.gradient,v.RGBA),r.version=o.gradientVersion,s=r.texture;}g.activeTexture.set(v.TEXTURE1),s.bind(o.stepInterpolant?v.NEAREST:v.LINEAR,v.CLAMP_TO_EDGE);}h&&(g.activeTexture.set(v.TEXTURE0),r.lineAtlasTexture.bind(v.LINEAR,v.REPEAT),b.updatePaintBuffers(m)),d&&(g.activeTexture.set(v.TEXTURE0),r.imageAtlasTexture.bind(v.LINEAR,v.CLAMP_TO_EDGE),b.updatePaintBuffers(m)),t.prepareDrawProgram(g,w,n.toUnwrapped());const I=i=>{w.draw(g,v.TRIANGLES,s,i,l,e.CullFaceMode.disabled,S,o.id,a.layoutVertexBuffer,a.indexBuffer,a.segments,o.paint,t.transform.zoom,b,a.layoutVertexBuffer2);};if(y){const i=t.stencilModeForClipping(n).ref;0===i&&t.terrain&&g.clear({stencil:0});const o={func:v.EQUAL,mask:255};S.u_alpha_discard_threshold=.8,I(new e.StencilMode(o,i,255,v.KEEP,v.KEEP,v.INVERT)),S.u_alpha_discard_threshold=0,I(new e.StencilMode(o,i,255,v.KEEP,v.KEEP,v.KEEP));}else I(t.stencilModeForClipping(n));}y&&(t.resetStencilClippingMasks(),t.terrain&&g.clear({stencil:0}));},fill:function(t,i,o,r){const n=o.paint.get("fill-color"),a=o.paint.get("fill-opacity");if(0===a.constantOr(1))return;const s=t.colorModeForRenderPass(),l=o.paint.get("fill-pattern"),c=t.opaquePassEnabledForLayer()&&!l.constantOr(1)&&1===n.constantOr(e.Color.transparent).a&&1===a.constantOr(0)?"opaque":"translucent";if(t.renderPass===c){const n=t.depthModeForSublayer(1,"opaque"===t.renderPass?e.DepthMode.ReadWrite:e.DepthMode.ReadOnly);$i(t,i,o,r,n,s,!1);}if("translucent"===t.renderPass&&o.paint.get("fill-antialias")){const n=t.depthModeForSublayer(o.getPaintProperty("fill-outline-color")?2:0,e.DepthMode.ReadOnly);$i(t,i,o,r,n,s,!0);}},"fill-extrusion":function(t,i,o,r){const n=o.paint.get("fill-extrusion-opacity");if(0!==n&&"translucent"===t.renderPass){const a=new e.DepthMode(t.context.gl.LEQUAL,e.DepthMode.ReadWrite,t.depthRangeFor3D);if(1!==n||o.paint.get("fill-extrusion-pattern").constantOr(1))Hi(t,i,o,r,a,e.StencilMode.disabled,e.ColorMode.disabled),Hi(t,i,o,r,a,t.stencilModeFor3D(),t.colorModeForRenderPass()),t.resetStencilClippingMasks();else {const n=t.colorModeForRenderPass();Hi(t,i,o,r,a,e.StencilMode.disabled,n);}}},hillshade:function(t,i,o,r){if("offscreen"!==t.renderPass&&"translucent"!==t.renderPass)return;const n=t.context,a=t.depthModeForSublayer(0,e.DepthMode.ReadOnly),s=t.colorModeForRenderPass(),l=t.terrain&&t.terrain.renderingToTexture,[c,h]="translucent"!==t.renderPass||l?[{},r]:t.stencilConfigForOverlap(r);for(const r of h){const n=i.getTile(r);if(n.needsHillshadePrepare&&"offscreen"===t.renderPass)Qt(t,n,o,a,e.StencilMode.disabled,s);else if("translucent"===t.renderPass){const e=l&&t.terrain?t.terrain.stencilModeForRTTOverlap(r):c[r.overscaledZ];Yt(t,r,n,o,a,e,s);}}n.viewport.set([0,0,t.width,t.height]),t.resetStencilClippingMasks();},raster:function(t,i,o,r,n,a){if("translucent"!==t.renderPass)return;if(0===o.paint.get("raster-opacity"))return;if(!r.length)return;const s=t.context,l=s.gl,c=i.getSource(),h=t.useProgram("raster"),u=t.colorModeForRenderPass(),_=t.terrain&&t.terrain.renderingToTexture,[d,p]=c instanceof be||_?[{},r]:t.stencilConfigForOverlap(r),m=p[p.length-1].overscaledZ,f=!t.options.moving;for(const r of p){const n=_?e.DepthMode.disabled:t.depthModeForSublayer(r.overscaledZ-m,1===o.paint.get("raster-opacity")?e.DepthMode.ReadWrite:e.DepthMode.ReadOnly,l.LESS),p=r.toUnwrapped(),g=i.getTile(r);if(_&&(!g||!g.hasData()))continue;const v=_?r.projMatrix:t.transform.calculateProjMatrix(p,f),x=t.terrain&&_?t.terrain.stencilModeForRTTOverlap(r):d[r.overscaledZ],y=a?0:o.paint.get("raster-fade-duration");g.registerFadeDuration(y);const b=i.findLoadedParent(r,0),w=li(g,b,i,t.transform,y);let T,E;t.terrain&&t.terrain.prepareDrawTile(r);const C="nearest"===o.paint.get("raster-resampling")?l.NEAREST:l.LINEAR;s.activeTexture.set(l.TEXTURE0),g.texture.bind(C,l.CLAMP_TO_EDGE),s.activeTexture.set(l.TEXTURE1),b?(b.texture.bind(C,l.CLAMP_TO_EDGE),T=Math.pow(2,b.tileID.overscaledZ-g.tileID.overscaledZ),E=[g.tileID.canonical.x*T%1,g.tileID.canonical.y*T%1]):g.texture.bind(C,l.CLAMP_TO_EDGE);const M=Ai(v,E||[0,0],T||1,w,o,c instanceof be?c.perspectiveTransform:[0,0]);if(t.prepareDrawProgram(s,h,p),c instanceof be)h.draw(s,l.TRIANGLES,n,e.StencilMode.disabled,u,e.CullFaceMode.disabled,M,o.id,c.boundsBuffer,t.quadTriangleIndexBuffer,c.boundsSegments);else {const{tileBoundsBuffer:i,tileBoundsIndexBuffer:r,tileBoundsSegments:a}=t.getTileBoundsBuffers(g);h.draw(s,l.TRIANGLES,n,x,u,e.CullFaceMode.disabled,M,o.id,i,r,a);}}t.resetStencilClippingMasks();},background:function(t,i,o,r){const n=o.paint.get("background-color"),a=o.paint.get("background-opacity");if(0===a)return;const s=t.context,l=s.gl,c=t.transform,h=c.tileSize,u=o.paint.get("background-pattern");if(t.isPatternMissing(u))return;const _=!u&&1===n.a&&1===a&&t.opaquePassEnabledForLayer()?"opaque":"translucent";if(t.renderPass!==_)return;const d=e.StencilMode.disabled,p=t.depthModeForSublayer(0,"opaque"===_?e.DepthMode.ReadWrite:e.DepthMode.ReadOnly),m=t.colorModeForRenderPass(),f=t.useProgram(u?"backgroundPattern":"background");let g,v=r;v||(g=t.getBackgroundTiles(),v=Object.values(g).map((e=>e.tileID))),u&&(s.activeTexture.set(l.TEXTURE0),t.imageManager.bind(t.context));const x=o.getCrossfadeParameters();for(const _ of v){const v=_.toUnwrapped(),y=r?_.projMatrix:t.transform.calculateProjMatrix(v);t.prepareDrawTile(_);const b=i?i.getTile(_):g?g[_.key]:new e.Tile(_,h,c.zoom,t),w=u?Fi(y,a,t,u,{tileID:_,tileSize:h},x):Bi(y,a,n);t.prepareDrawProgram(s,f,v);const{tileBoundsBuffer:T,tileBoundsIndexBuffer:E,tileBoundsSegments:C}=t.getTileBoundsBuffers(b);f.draw(s,l.TRIANGLES,p,d,m,e.CullFaceMode.disabled,w,o.id,T,E,C);}},sky:function(t,i,o){const r=t.transform,n="mercator"===r.projection.name||"globe"===r.projection.name?1:e.smoothstep(7,8,r.zoom),a=o.paint.get("sky-opacity")*n;if(0===a)return;const s=t.context,l=o.paint.get("sky-type"),c=new e.DepthMode(s.gl.LEQUAL,e.DepthMode.ReadOnly,[0,1]),h=t.frameCounter/1e3%1;"atmosphere"===l?"offscreen"===t.renderPass?o.needsSkyboxCapture(t)&&(function(t,i,o,r){const n=t.context,a=n.gl;let s=i.skyboxFbo;if(!s){s=i.skyboxFbo=n.createFramebuffer(32,32,!1),i.skyboxGeometry=new co(n),i.skyboxTexture=n.gl.createTexture(),a.bindTexture(a.TEXTURE_CUBE_MAP,i.skyboxTexture),a.texParameteri(a.TEXTURE_CUBE_MAP,a.TEXTURE_WRAP_S,a.CLAMP_TO_EDGE),a.texParameteri(a.TEXTURE_CUBE_MAP,a.TEXTURE_WRAP_T,a.CLAMP_TO_EDGE),a.texParameteri(a.TEXTURE_CUBE_MAP,a.TEXTURE_MIN_FILTER,a.LINEAR),a.texParameteri(a.TEXTURE_CUBE_MAP,a.TEXTURE_MAG_FILTER,a.LINEAR);for(let e=0;e<6;++e)a.texImage2D(a.TEXTURE_CUBE_MAP_POSITIVE_X+e,0,a.RGBA,32,32,0,a.RGBA,a.UNSIGNED_BYTE,null);}n.bindFramebuffer.set(s.framebuffer),n.viewport.set([0,0,32,32]);const l=i.getCenter(t,!0),c=t.useProgram("skyboxCapture"),h=new Float64Array(16);e.identity(h),e.rotateY(h,h,.5*-Math.PI),ho(n,i,c,h,l,0),e.identity(h),e.rotateY(h,h,.5*Math.PI),ho(n,i,c,h,l,1),e.identity(h),e.rotateX(h,h,.5*-Math.PI),ho(n,i,c,h,l,2),e.identity(h),e.rotateX(h,h,.5*Math.PI),ho(n,i,c,h,l,3),e.identity(h),ho(n,i,c,h,l,4),e.identity(h),e.rotateY(h,h,Math.PI),ho(n,i,c,h,l,5),n.viewport.set([0,0,t.width,t.height]);}(t,o),o.markSkyboxValid(t)):"sky"===t.renderPass&&function(t,i,o,r,n){const a=t.context,s=a.gl,l=t.transform,c=t.useProgram("skybox");a.activeTexture.set(s.TEXTURE0),s.bindTexture(s.TEXTURE_CUBE_MAP,i.skyboxTexture);const h=((e,t,i,o,r)=>({u_matrix:e,u_sun_direction:t,u_cubemap:0,u_opacity:o,u_temporal_offset:r}))(l.skyboxMatrix,i.getCenter(t,!1),0,r,n);t.prepareDrawProgram(a,c),c.draw(a,s.TRIANGLES,o,e.StencilMode.disabled,t.colorModeForRenderPass(),e.CullFaceMode.backCW,h,"skybox",i.skyboxGeometry.vertexBuffer,i.skyboxGeometry.indexBuffer,i.skyboxGeometry.segment);}(t,o,c,a,h):"gradient"===l&&"sky"===t.renderPass&&function(t,i,o,r,n){const a=t.context,s=a.gl,l=t.transform,c=t.useProgram("skyboxGradient");i.skyboxGeometry||(i.skyboxGeometry=new co(a)),a.activeTexture.set(s.TEXTURE0);let h=i.colorRampTexture;h||(h=i.colorRampTexture=new e.Texture(a,i.colorRamp,s.RGBA)),h.bind(s.LINEAR,s.CLAMP_TO_EDGE);const u=((t,i,o,r,n)=>({u_matrix:t,u_color_ramp:0,u_center_direction:i,u_radius:e.degToRad(o),u_opacity:r,u_temporal_offset:n}))(l.skyboxMatrix,i.getCenter(t,!1),i.paint.get("sky-gradient-radius"),r,n);t.prepareDrawProgram(a,c),c.draw(a,s.TRIANGLES,o,e.StencilMode.disabled,t.colorModeForRenderPass(),e.CullFaceMode.backCW,u,"skyboxGradient",i.skyboxGeometry.vertexBuffer,i.skyboxGeometry.indexBuffer,i.skyboxGeometry.segment);}(t,o,c,a,h);},debug:function(e,t,i){for(let o=0;o<i.length;o++)no(e,t,i[o]);},custom:function(t,i,o){const r=t.context,n=o.implementation;if(t.transform.projection.unsupportedLayers&&t.transform.projection.unsupportedLayers.includes("custom"))e.warnOnce("Custom layers are not yet supported with non-mercator projections. Use mercator to enable custom layers.");else if("offscreen"===t.renderPass){const e=n.prerender;e&&(t.setCustomLayerDefaults(),r.setColorMode(t.colorModeForRenderPass()),e.call(n,r.gl,t.transform.customLayerMatrix()),r.setDirty(),t.setBaseState());}else if("translucent"===t.renderPass){t.setCustomLayerDefaults(),r.setColorMode(t.colorModeForRenderPass()),r.setStencilMode(e.StencilMode.disabled);const i="3d"===n.renderingMode?new e.DepthMode(t.context.gl.LEQUAL,e.DepthMode.ReadWrite,t.depthRangeFor3D):t.depthModeForSublayer(0,e.DepthMode.ReadOnly);r.setDepthMode(i),n.render(r.gl,t.transform.customLayerMatrix()),r.setDirty(),t.setBaseState(),r.bindFramebuffer.set(null);}}};class _o{constructor(t,i){this.context=new de(t),this.transform=i,this._tileTextures={},this.frameCopies=[],this.loadTimeStamps=[],this.setup(),this.numSublayers=e.SourceCache.maxUnderzooming+e.SourceCache.maxOverzooming+1,this.depthEpsilon=1/Math.pow(2,16),this.crossTileSymbolIndex=new Rt,this.gpuTimers={},this.frameCounter=0,this._backgroundTiles={};}updateTerrain(e,t){const i=!!e&&!!e.terrain&&this.transform.projection.supportsTerrain;if(!(i||this._terrain&&this._terrain.enabled))return;this._terrain||(this._terrain=new _i(this,e));const o=this._terrain;this.transform.elevation=i?o:null,o.update(e,this.transform,t);}_updateFog(e){const t=e.fog;if(!t||t.getOpacity(this.transform.pitch)<1||t.properties.get("horizon-blend")<.03)return void(this.transform.fogCullDistSq=null);const[i,o]=t.getFovAdjustedRange(this.transform._fov);if(i>o)return void(this.transform.fogCullDistSq=null);const r=i+.78*(o-i);this.transform.fogCullDistSq=r*r;}get terrain(){return this.transform._terrainEnabled()&&this._terrain&&this._terrain.enabled?this._terrain:null}resize(t,i){if(this.width=t*e.exported.devicePixelRatio,this.height=i*e.exported.devicePixelRatio,this.context.viewport.set([0,0,this.width,this.height]),this.style)for(const e of this.style.order)this.style._layers[e].resize();}setup(){const t=this.context,i=new e.StructArrayLayout2i4;i.emplaceBack(0,0),i.emplaceBack(e.EXTENT,0),i.emplaceBack(0,e.EXTENT),i.emplaceBack(e.EXTENT,e.EXTENT),this.tileExtentBuffer=t.createVertexBuffer(i,e.posAttributes.members),this.tileExtentSegments=e.SegmentVector.simpleSegment(0,0,4,2);const o=new e.StructArrayLayout2i4;o.emplaceBack(0,0),o.emplaceBack(e.EXTENT,0),o.emplaceBack(0,e.EXTENT),o.emplaceBack(e.EXTENT,e.EXTENT),this.debugBuffer=t.createVertexBuffer(o,e.posAttributes.members),this.debugSegments=e.SegmentVector.simpleSegment(0,0,4,5);const r=new e.StructArrayLayout2i4;r.emplaceBack(-1,-1),r.emplaceBack(1,-1),r.emplaceBack(-1,1),r.emplaceBack(1,1),this.viewportBuffer=t.createVertexBuffer(r,e.posAttributes.members),this.viewportSegments=e.SegmentVector.simpleSegment(0,0,4,2);const n=new e.StructArrayLayout4i8;n.emplaceBack(0,0,0,0),n.emplaceBack(e.EXTENT,0,e.EXTENT,0),n.emplaceBack(0,e.EXTENT,0,e.EXTENT),n.emplaceBack(e.EXTENT,e.EXTENT,e.EXTENT,e.EXTENT),this.mercatorBoundsBuffer=t.createVertexBuffer(n,e.boundsAttributes.members),this.mercatorBoundsSegments=e.SegmentVector.simpleSegment(0,0,4,2);const a=new e.StructArrayLayout3ui6;a.emplaceBack(0,1,2),a.emplaceBack(2,1,3),this.quadTriangleIndexBuffer=t.createIndexBuffer(a);const s=new e.StructArrayLayout1ui2;for(const e of [0,1,3,2,0])s.emplaceBack(e);this.debugIndexBuffer=t.createIndexBuffer(s),this.emptyTexture=new e.Texture(t,{width:1,height:1,data:new Uint8Array([0,0,0,0])},t.gl.RGBA),this.identityMat=e.create();const l=this.context.gl;this.stencilClearMode=new e.StencilMode({func:l.ALWAYS,mask:0},0,255,l.ZERO,l.ZERO,l.ZERO),this.loadTimeStamps.push(e.window.performance.now());}getMercatorTileBoundsBuffers(){return {tileBoundsBuffer:this.mercatorBoundsBuffer,tileBoundsIndexBuffer:this.quadTriangleIndexBuffer,tileBoundsSegments:this.mercatorBoundsSegments}}getTileBoundsBuffers(e){return e._makeTileBoundsBuffers(this.context,this.transform.projection),e._tileBoundsBuffer?{tileBoundsBuffer:e._tileBoundsBuffer,tileBoundsIndexBuffer:e._tileBoundsIndexBuffer,tileBoundsSegments:e._tileBoundsSegments}:this.getMercatorTileBoundsBuffers()}clearStencil(){const t=this.context,i=t.gl;this.nextStencilID=1,this.currentStencilSource=void 0,this._tileClippingMaskIDs={},this.useProgram("clippingMask").draw(t,i.TRIANGLES,e.DepthMode.disabled,this.stencilClearMode,e.ColorMode.disabled,e.CullFaceMode.disabled,si(this.identityMat),"$clipping",this.viewportBuffer,this.quadTriangleIndexBuffer,this.viewportSegments);}resetStencilClippingMasks(){this.terrain||(this.currentStencilSource=void 0,this._tileClippingMaskIDs={});}_renderTileClippingMasks(t,i,o){if(!i||this.currentStencilSource===i.id||!t.isTileClipped()||!o||0===o.length)return;if(this._tileClippingMaskIDs&&!this.terrain){let e=!1;for(const t of o)if(void 0===this._tileClippingMaskIDs[t.key]){e=!0;break}if(!e)return}this.currentStencilSource=i.id;const r=this.context,n=r.gl;this.nextStencilID+o.length>256&&this.clearStencil(),r.setColorMode(e.ColorMode.disabled),r.setDepthMode(e.DepthMode.disabled);const a=this.useProgram("clippingMask");this._tileClippingMaskIDs={};for(const t of o){const o=i.getTile(t),s=this._tileClippingMaskIDs[t.key]=this.nextStencilID++,{tileBoundsBuffer:l,tileBoundsIndexBuffer:c,tileBoundsSegments:h}=this.getTileBoundsBuffers(o);a.draw(r,n.TRIANGLES,e.DepthMode.disabled,new e.StencilMode({func:n.ALWAYS,mask:0},s,255,n.KEEP,n.KEEP,n.REPLACE),e.ColorMode.disabled,e.CullFaceMode.disabled,si(t.projMatrix),"$clipping",l,c,h);}}stencilModeFor3D(){this.currentStencilSource=void 0,this.nextStencilID+1>256&&this.clearStencil();const t=this.nextStencilID++,i=this.context.gl;return new e.StencilMode({func:i.NOTEQUAL,mask:255},t,255,i.KEEP,i.KEEP,i.REPLACE)}stencilModeForClipping(t){if(this.terrain)return this.terrain.stencilModeForRTTOverlap(t);const i=this.context.gl;return new e.StencilMode({func:i.EQUAL,mask:255},this._tileClippingMaskIDs[t.key],0,i.KEEP,i.KEEP,i.REPLACE)}stencilConfigForOverlap(t){const i=this.context.gl,o=t.sort(((e,t)=>t.overscaledZ-e.overscaledZ)),r=o[o.length-1].overscaledZ,n=o[0].overscaledZ-r+1;if(n>1){this.currentStencilSource=void 0,this.nextStencilID+n>256&&this.clearStencil();const t={};for(let o=0;o<n;o++)t[o+r]=new e.StencilMode({func:i.GEQUAL,mask:255},o+this.nextStencilID,255,i.KEEP,i.KEEP,i.REPLACE);return this.nextStencilID+=n,[t,o]}return [{[r]:e.StencilMode.disabled},o]}colorModeForRenderPass(){const t=this.context.gl;if(this._showOverdrawInspector){const i=1/8;return new e.ColorMode([t.CONSTANT_COLOR,t.ONE],new e.Color(i,i,i,0),[!0,!0,!0,!0])}return "opaque"===this.renderPass?e.ColorMode.unblended:e.ColorMode.alphaBlended}depthModeForSublayer(t,i,o){if(!this.opaquePassEnabledForLayer())return e.DepthMode.disabled;const r=1-((1+this.currentLayer)*this.numSublayers+t)*this.depthEpsilon;return new e.DepthMode(o||this.context.gl.LEQUAL,i,[r,r])}opaquePassEnabledForLayer(){return this.currentLayer<this.opaquePassCutoff}render(t,i){this.style=t,this.options=i,this.lineAtlas=t.lineAtlas,this.imageManager=t.imageManager,this.glyphManager=t.glyphManager,this.symbolFadeChange=t.placement.symbolFadeChange(e.exported.now()),this.imageManager.beginFrame();const o=this.style.order,r=this.style._sourceCaches;for(const e in r){const t=r[e];t.used&&t.prepare(this.context);}const n={},a={},s={};for(const e in r){const t=r[e];n[e]=t.getVisibleCoordinates(),a[e]=n[e].slice().reverse(),s[e]=t.getVisibleCoordinates(!0).reverse();}this.opaquePassCutoff=1/0;for(let e=0;e<o.length;e++)if(this.style._layers[o[e]].is3D()){this.opaquePassCutoff=e;break}if(this.terrain&&(this.terrain.updateTileBinding(s),this.opaquePassCutoff=0),"globe"!==this.transform.projection.name||this.globeSharedBuffers||(this.globeSharedBuffers=new e.GlobeSharedBuffers(this.context)),!e.isMapAuthenticated(this.context.gl))return;this.renderPass="offscreen";for(const e of o){const i=this.style._layers[e],o=t._getLayerSourceCache(i);if(!i.hasOffscreenPass()||i.isHidden(this.transform.zoom))continue;const r=o?a[o.id]:void 0;("custom"===i.type||i.isSky()||r&&r.length)&&this.renderLayer(this,o,i,r);}this.depthRangeFor3D=[0,1-(t.order.length+2)*this.numSublayers*this.depthEpsilon],this.terrain&&(this.style.hasSymbolLayers()||this.style.hasCircleLayers())&&this.terrain.drawDepth(),this.context.bindFramebuffer.set(null),this.context.viewport.set([0,0,this.width,this.height]);let l=e.Color.transparent;if(this.style.fog&&this.style.fog.getOpacity(this.transform.pitch)&&(l=this.style.fog.properties.get("color")),this.context.clear({color:i.showOverdrawInspector?e.Color.black:l,depth:1}),this.clearStencil(),this._showOverdrawInspector=i.showOverdrawInspector,this.renderPass="opaque",!this.terrain)for(this.currentLayer=o.length-1;this.currentLayer>=0;this.currentLayer--){const e=this.style._layers[o[this.currentLayer]],i=t._getLayerSourceCache(e);if(e.isSky())continue;const r=i?a[i.id]:void 0;this._renderTileClippingMasks(e,i,r),this.renderLayer(this,i,e,r);}if(this.renderPass="sky",(e.globeToMercatorTransition(this.transform.zoom)>0||"globe"!==this.transform.projection.name)&&this.transform.isHorizonVisible())for(this.currentLayer=0;this.currentLayer<o.length;this.currentLayer++){const e=this.style._layers[o[this.currentLayer]],i=t._getLayerSourceCache(e);e.isSky()&&this.renderLayer(this,i,e,i?a[i.id]:void 0);}for("globe"===this.transform.projection.name&&function(t){const i=t.context,o=i.gl,r=t.transform,n=new e.DepthMode(o.LEQUAL,e.DepthMode.ReadOnly,[0,1]),a=t.useProgram("globeAtmosphere"),s=r._camera.getWorldToCamera(r.worldSize,1),l=r._camera.getCameraToClipPerspective(r._fov,r.width/r.height,r._nearZ,r._farZ),c=e.mul([],s,e.calculateGlobeMatrix(r,r.worldSize)),h=e.mul([],r.labelPlaneMatrix,l),u=e.transformMat4([],[0,0,0],c),_=e.add([],u,[r.worldSize/Math.PI/2,0,0]),d=e.transformMat4([],u,h),p=e.transformMat4([],_,h),m=e.length(e.sub([],p,d)),f=1-e.globeToMercatorTransition(r.zoom),g={u_center:d,u_radius:m,u_screen_size:[r.width,r.height],u_pixel_ratio:e.exported.devicePixelRatio,u_opacity:f,u_fadeout_range:2,u_start_color:[1,1,1],u_end_color:[.0118,.7451,.9882]};t.prepareDrawProgram(i,a);const v=t.globeSharedBuffers;v&&a.draw(i,o.TRIANGLES,n,e.StencilMode.disabled,e.ColorMode.alphaBlended,e.CullFaceMode.backCW,g,"skybox",v.atmosphereVertexBuffer,v.atmosphereIndexBuffer,v.atmosphereSegments);}(this),this.renderPass="translucent",this.currentLayer=0;this.currentLayer<o.length;){const e=this.style._layers[o[this.currentLayer]],i=t._getLayerSourceCache(e);if(e.isSky()){++this.currentLayer;continue}if(this.terrain&&this.style.isLayerDraped(e)){if(e.isHidden(this.transform.zoom)){++this.currentLayer;continue}this.currentLayer=this.terrain.renderBatch(this.currentLayer);continue}const r=i?("symbol"===e.type?s:a)[i.id]:void 0;this._renderTileClippingMasks(e,i,i?n[i.id]:void 0),this.renderLayer(this,i,e,r),++this.currentLayer;}if(this.terrain&&this.terrain.postRender(),this.options.showTileBoundaries||this.options.showQueryGeometry){let i=null;e.values(this.style._layers).forEach((e=>{const o=t._getLayerSourceCache(e);o&&!e.isHidden(this.transform.zoom)&&(!i||i.getSource().maxzoom<o.getSource().maxzoom)&&(i=o);})),i&&this.options.showTileBoundaries&&uo.debug(this,i,i.getVisibleCoordinates());}this.options.showPadding&&function(e){const t=e.transform.padding;io(e,e.transform.height-(t.top||0),3,Yi),io(e,t.bottom||0,3,Ji),oo(e,t.left||0,3,Qi),oo(e,e.transform.width-(t.right||0),3,eo);const i=e.transform.centerPoint;!function(e,t,i,o){ro(e,t-1,i-10,2,20,o),ro(e,t-10,i-1,20,2,o);}(e,i.x,e.transform.height-i.y,to);}(this),this.context.setDefault(),this.frameCounter=(this.frameCounter+1)%Number.MAX_SAFE_INTEGER,this.tileLoaded&&this.options.speedIndexTiming&&(this.loadTimeStamps.push(e.window.performance.now()),this.saveCanvasCopy());}renderLayer(e,t,i,o){i.isHidden(this.transform.zoom)||("background"===i.type||"sky"===i.type||"custom"===i.type||o&&o.length)&&(this.id=i.id,this.gpuTimingStart(i),e.transform.projection.unsupportedLayers&&e.transform.projection.unsupportedLayers.includes(i.type)||uo[i.type](e,t,i,o,this.style.placement.variableOffsets,this.options.isInitialLoad),this.gpuTimingEnd());}gpuTimingStart(e){if(!this.options.gpuTiming)return;const t=this.context.extTimerQuery;let i=this.gpuTimers[e.id];i||(i=this.gpuTimers[e.id]={calls:0,cpuTime:0,query:t.createQueryEXT()}),i.calls++,t.beginQueryEXT(t.TIME_ELAPSED_EXT,i.query);}gpuTimingEnd(){if(!this.options.gpuTiming)return;const e=this.context.extTimerQuery;e.endQueryEXT(e.TIME_ELAPSED_EXT);}collectGpuTimers(){const e=this.gpuTimers;return this.gpuTimers={},e}queryGpuTimers(e){const t={};for(const i in e){const o=e[i],r=this.context.extTimerQuery,n=r.getQueryObjectEXT(o.query,r.QUERY_RESULT_EXT)/1e6;r.deleteQueryEXT(o.query),t[i]=n;}return t}translatePosMatrix(t,i,o,r,n){if(!o[0]&&!o[1])return t;const a=n?"map"===r?this.transform.angle:0:"viewport"===r?-this.transform.angle:0;if(a){const e=Math.sin(a),t=Math.cos(a);o=[o[0]*t-o[1]*e,o[0]*e+o[1]*t];}const s=[n?o[0]:M(i,o[0],this.transform.zoom),n?o[1]:M(i,o[1],this.transform.zoom),0],l=new Float32Array(16);return e.translate(l,t,s),l}saveTileTexture(e){const t=this._tileTextures[e.size[0]];t?t.push(e):this._tileTextures[e.size[0]]=[e];}getTileTexture(e){const t=this._tileTextures[e];return t&&t.length>0?t.pop():null}isPatternMissing(e){if(!e)return !1;if(!e.from||!e.to)return !0;const t=this.imageManager.getPattern(e.from.toString()),i=this.imageManager.getPattern(e.to.toString());return !t||!i}currentGlobalDefines(){const e=this.terrain&&this.terrain.renderingToTexture,t=this.style&&this.style.fog,i=[];return this.terrain&&!this.terrain.renderingToTexture&&i.push("TERRAIN"),t&&!e&&0!==t.getOpacity(this.transform.pitch)&&i.push("FOG"),e&&i.push("RENDER_TO_TEXTURE"),this._showOverdrawInspector&&i.push("OVERDRAW_INSPECTOR"),i}useProgram(e,t,i){this.cache=this.cache||{};const o=i||[],r=this.currentGlobalDefines().concat(o),n=pi.cacheKey(e,r,t);return this.cache[n]||(this.cache[n]=new pi(this.context,e,Xt[e],t,Ui[e],r)),this.cache[n]}setCustomLayerDefaults(){this.context.unbindVAO(),this.context.cullFace.setDefault(),this.context.frontFace.setDefault(),this.context.cullFaceSide.setDefault(),this.context.activeTexture.setDefault(),this.context.pixelStoreUnpack.setDefault(),this.context.pixelStoreUnpackPremultiplyAlpha.setDefault(),this.context.pixelStoreUnpackFlipY.setDefault();}setBaseState(){const e=this.context.gl;this.context.cullFace.set(!1),this.context.viewport.set([0,0,this.width,this.height]),this.context.blendEquation.set(e.FUNC_ADD);}initDebugOverlayCanvas(){null==this.debugOverlayCanvas&&(this.debugOverlayCanvas=e.window.document.createElement("canvas"),this.debugOverlayCanvas.width=512,this.debugOverlayCanvas.height=512,this.debugOverlayTexture=new e.Texture(this.context,this.debugOverlayCanvas,this.context.gl.RGBA));}destroy(){this._terrain&&this._terrain.destroy(),this.globeSharedBuffers&&this.globeSharedBuffers.destroy(),this.emptyTexture.destroy(),this.debugOverlayTexture&&this.debugOverlayTexture.destroy();}prepareDrawTile(e){this.terrain&&this.terrain.prepareDrawTile(e);}prepareDrawProgram(e,t,i){if(this.terrain&&this.terrain.renderingToTexture)return;const o=this.style.fog;if(o){const r=o.getOpacity(this.transform.pitch);0!==r&&t.setFogUniformValues(e,((e,t,i,o)=>{const r=t.properties.get("color"),n=e.frameCounter/1e3%1,a=[r.r/r.a,r.g/r.a,r.b/r.a,o];return {u_fog_matrix:i?e.transform.calculateFogTileMatrix(i):e.identityMat,u_fog_range:t.getFovAdjustedRange(e.transform._fov),u_fog_color:a,u_fog_horizon_blend:t.properties.get("horizon-blend"),u_fog_temporal_offset:n}})(this,o,i,r));}}setTileLoadedFlag(e){this.tileLoaded=e;}saveCanvasCopy(){this.frameCopies.push(this.canvasCopy()),this.tileLoaded=!1;}canvasCopy(){const e=this.context.gl,t=e.createTexture();return e.bindTexture(e.TEXTURE_2D,t),e.copyTexImage2D(e.TEXTURE_2D,0,e.RGBA,0,0,e.drawingBufferWidth,e.drawingBufferHeight,0),t}getCanvasCopiesAndTimestamps(){return {canvasCopies:this.frameCopies,timeStamps:this.loadTimeStamps}}averageElevationNeedsEasing(){if(!this.transform._elevation)return !1;const e=this.style&&this.style.fog;return !!e&&0!==e.getOpacity(this.transform.pitch)}getBackgroundTiles(){const t=this._backgroundTiles,i=this._backgroundTiles={},o=this.transform.coveringTiles({tileSize:512});for(const r of o)i[r.key]=t[r.key]||new e.Tile(r,512,this.transform.tileZoom,this);return i}clearBackgroundTiles(){this._backgroundTiles={};}}class po{constructor(e=0,t=0,i=0,o=0){if(isNaN(e)||e<0||isNaN(t)||t<0||isNaN(i)||i<0||isNaN(o)||o<0)throw new Error("Invalid value for edge-insets, top, bottom, left and right must all be numbers");this.top=e,this.bottom=t,this.left=i,this.right=o;}interpolate(t,i,o){return null!=i.top&&null!=t.top&&(this.top=e.number(t.top,i.top,o)),null!=i.bottom&&null!=t.bottom&&(this.bottom=e.number(t.bottom,i.bottom,o)),null!=i.left&&null!=t.left&&(this.left=e.number(t.left,i.left,o)),null!=i.right&&null!=t.right&&(this.right=e.number(t.right,i.right,o)),this}getCenter(t,i){const o=e.clamp((this.left+t-this.right)/2,0,t),r=e.clamp((this.top+i-this.bottom)/2,0,i);return new e.pointGeometry(o,r)}equals(e){return this.top===e.top&&this.bottom===e.bottom&&this.left===e.left&&this.right===e.right}clone(){return new po(this.top,this.bottom,this.left,this.right)}toJSON(){return {top:this.top,bottom:this.bottom,left:this.left,right:this.right}}}function mo(t,i){const o=e.getColumn(t,3);e.fromQuat(t,i),e.setColumn(t,3,o);}function fo(t,i){e.setColumn(t,3,[i[0],i[1],i[2],1]);}function go(t,i){const o=e.identity$1([]);return e.rotateZ$1(o,o,-i),e.rotateX$1(o,o,-t),o}function vo(t,i){const o=[t[0],t[1],0],r=[i[0],i[1],0];if(e.length(o)>=1e-15){const t=e.normalize([],o);e.scale$2(r,t,e.dot(r,t)),i[0]=r[0],i[1]=r[1];}const n=e.cross([],i,t);if(e.len(n)<1e-15)return null;const a=Math.atan2(-n[1],n[0]);return go(Math.atan2(Math.sqrt(t[0]*t[0]+t[1]*t[1]),-t[2]),a)}class xo{constructor(e,t){this.position=e,this.orientation=t;}get position(){return this._position}set position(t){this._position=this._renderWorldCopies?function(t){if(!t)return;const i=Array.isArray(t)?new e.MercatorCoordinate(t[0],t[1],t[2]):t;return i.x=e.wrap(i.x,0,1),i}(t):t;}lookAtPoint(t,i){if(this.orientation=null,!this.position)return;const o=this._elevation?this._elevation.getAtPointOrZero(e.MercatorCoordinate.fromLngLat(t)):0,r=this.position,n=e.MercatorCoordinate.fromLngLat(t,o),a=[n.x-r.x,n.y-r.y,n.z-r.z];i||(i=[0,0,1]),i[2]=Math.abs(i[2]),this.orientation=vo(a,i);}setPitchBearing(t,i){this.orientation=go(e.degToRad(t),e.degToRad(-i));}}class yo{constructor(t,i){this._transform=e.identity([]),this._orientation=e.identity$1([]),i&&(this._orientation=i,mo(this._transform,this._orientation)),t&&fo(this._transform,t);}get mercatorPosition(){const t=this.position;return new e.MercatorCoordinate(t[0],t[1],t[2])}get position(){const t=e.getColumn(this._transform,3);return [t[0],t[1],t[2]]}set position(e){fo(this._transform,e);}get orientation(){return this._orientation}set orientation(e){this._orientation=e,mo(this._transform,this._orientation);}getPitchBearing(){const e=this.forward(),t=this.right();return {bearing:Math.atan2(-t[1],t[0]),pitch:Math.atan2(Math.sqrt(e[0]*e[0]+e[1]*e[1]),-e[2])}}setPitchBearing(e,t){this._orientation=go(e,t),mo(this._transform,this._orientation);}forward(){const t=e.getColumn(this._transform,2);return [-t[0],-t[1],-t[2]]}up(){const t=e.getColumn(this._transform,1);return [-t[0],-t[1],-t[2]]}right(){const t=e.getColumn(this._transform,0);return [t[0],t[1],t[2]]}getCameraToWorld(t,i){const o=new Float64Array(16);return e.invert(o,this.getWorldToCamera(t,i)),o}getWorldToCameraPosition(t,i,o){const r=this.position;e.scale$2(r,r,-t);const n=new Float64Array(16);return e.fromScaling(n,[o,o,o]),e.translate(n,n,r),n[10]*=i,n}getWorldToCamera(t,i){const o=new Float64Array(16),r=new Float64Array(4),n=this.position;return e.conjugate(r,this._orientation),e.scale$2(n,n,-t),e.fromQuat(o,r),e.translate(o,o,n),o[1]*=-1,o[5]*=-1,o[9]*=-1,o[13]*=-1,o[8]*=i,o[9]*=i,o[10]*=i,o[11]*=i,o}getCameraToClipPerspective(t,i,o,r){const n=new Float64Array(16);return e.perspective(n,t,i,o,r),n}getDistanceToElevation(t){const i=0===t?0:e.mercatorZfromAltitude(t,this.position[1]),o=this.forward();return (i-this.position[2])/o[2]}clone(){return new yo([...this.position],[...this.orientation])}}function bo(t,i){const o=To(t),r=function(t,i,o,r,n){const a=new e.LngLat(o.lng-180*Eo,o.lat),s=new e.LngLat(o.lng+180*Eo,o.lat),l=t.project(a.lng,a.lat),c=t.project(s.lng,s.lat),h=-Math.atan2(c.y-l.y,c.x-l.x),u=e.MercatorCoordinate.fromLngLat(o);u.y=e.clamp(u.y,-.999975,.999975);const _=u.toLngLat(),d=t.project(_.lng,_.lat),p=e.MercatorCoordinate.fromLngLat(_);p.x+=Eo;const m=p.toLngLat(),f=t.project(m.lng,m.lat),g=Mo(f.x-d.x,f.y-d.y,h),v=e.MercatorCoordinate.fromLngLat(_);v.y+=Eo;const x=v.toLngLat(),y=t.project(x.lng,x.lat),b=Mo(y.x-d.x,y.y-d.y,h),w=Math.abs(g.x)/Math.abs(b.y),T=e.identity([]);e.rotateZ(T,T,-h*(1-(n?0:r)));const E=e.identity([]);return e.scale(E,E,[1,1-(1-w)*r,1]),E[4]=-b.x/b.y*r,e.rotateZ(E,E,h),e.multiply$1(E,T,E),E}(t.projection,0,t.center,o,i),n=wo(t);return e.scale(r,r,[n,n,1]),r}function wo(t){const i=t.projection,o=To(t),r=Co(i,t.center),n=Co(i,e.LngLat.convert(i.center));return Math.pow(2,r*o+(1-o)*n)}function To(t){const i=t.projection.range;if(!i)return 0;const o=Math.max(t.width,t.height),r=Math.log(o/1024)/Math.LN2;return e.smoothstep(i[0]+r,i[1]+r,t.zoom)}const Eo=1/4e4;function Co(t,i){const o=e.clamp(i.lat,-e.MAX_MERCATOR_LATITUDE,e.MAX_MERCATOR_LATITUDE),r=new e.LngLat(i.lng-180*Eo,o),n=new e.LngLat(i.lng+180*Eo,o),a=t.project(r.lng,o),s=t.project(n.lng,o),l=e.MercatorCoordinate.fromLngLat(r),c=e.MercatorCoordinate.fromLngLat(n),h=s.x-a.x,u=s.y-a.y,_=c.x-l.x,d=c.y-l.y,p=Math.sqrt((_*_+d*d)/(h*h+u*u));return Math.log(p)/Math.LN2}function Mo(e,t,i){const o=Math.cos(i),r=Math.sin(i);return {x:e*o-t*r,y:e*r+t*o}}class So{constructor(t,i,o,r,n){this.tileSize=512,this._renderWorldCopies=void 0===n||n,this._minZoom=t||0,this._maxZoom=i||22,this._minPitch=null==o?0:o,this._maxPitch=null==r?60:r,this.setProjection(),this.setMaxBounds(),this.width=0,this.height=0,this._center=new e.LngLat(0,0),this.zoom=0,this.angle=0,this._fov=.6435011087932844,this._pitch=0,this._nearZ=0,this._farZ=0,this._unmodified=!0,this._edgeInsets=new po,this._projMatrixCache={},this._alignedProjMatrixCache={},this._fogTileMatrixCache={},this._distanceTileDataCache={},this._camera=new yo,this._centerAltitude=0,this._averageElevation=0,this.cameraElevationReference="ground",this._projectionScaler=1,this._horizonShift=.1;}clone(){const e=new So(this._minZoom,this._maxZoom,this._minPitch,this.maxPitch,this._renderWorldCopies);return e.setProjection(this.getProjection()),e._elevation=this._elevation,e._centerAltitude=this._centerAltitude,e.tileSize=this.tileSize,e.setMaxBounds(this.getMaxBounds()),e.width=this.width,e.height=this.height,e.cameraElevationReference=this.cameraElevationReference,e._center=this._center,e._setZoom(this.zoom),e._cameraZoom=this._cameraZoom,e.angle=this.angle,e._fov=this._fov,e._pitch=this._pitch,e._nearZ=this._nearZ,e._farZ=this._farZ,e._averageElevation=this._averageElevation,e._unmodified=this._unmodified,e._edgeInsets=this._edgeInsets.clone(),e._camera=this._camera.clone(),e._calcMatrices(),e.freezeTileCoverage=this.freezeTileCoverage,e}get elevation(){return this._elevation}set elevation(e){this._elevation!==e&&(this._elevation=e,e?this._updateCenterElevation()&&this._updateCameraOnTerrain():(this._cameraZoom=null,this._centerAltitude=0),this._calcMatrices());}updateElevation(e){this._terrainEnabled()&&null==this._cameraZoom&&this._updateCenterElevation()&&this._updateCameraOnTerrain(),e&&this._constrainCameraAltitude(),this._calcMatrices();}getProjection(){return e.pick(this.projection,["name","center","parallels"])}setProjection(t){null==t&&(t={name:"mercator"}),this.projectionOptions=t;const i=this.projection?this.getProjection():void 0;return this.projection=e.getProjection(t),!n(i,this.getProjection())&&(this._calcMatrices(),!0)}get minZoom(){return this._minZoom}set minZoom(e){this._minZoom!==e&&(this._minZoom=e,this.zoom=Math.max(this.zoom,e));}get maxZoom(){return this._maxZoom}set maxZoom(e){this._maxZoom!==e&&(this._maxZoom=e,this.zoom=Math.min(this.zoom,e));}get minPitch(){return this._minPitch}set minPitch(e){this._minPitch!==e&&(this._minPitch=e,this.pitch=Math.max(this.pitch,e));}get maxPitch(){return this._maxPitch}set maxPitch(e){this._maxPitch!==e&&(this._maxPitch=e,this.pitch=Math.min(this.pitch,e));}get renderWorldCopies(){return this._renderWorldCopies&&!0===this.projection.supportsWorldCopies}set renderWorldCopies(e){void 0===e?e=!0:null===e&&(e=!1),this._renderWorldCopies=e;}get worldSize(){return this.tileSize*this.scale}get cameraWorldSize(){const e=Math.max(this._camera.getDistanceToElevation(this._averageElevation),Number.EPSILON);return this._worldSizeFromZoom(this._zoomFromMercatorZ(e))}get pixelsPerMeter(){return this.projection.pixelsPerMeter(this.center.lat,this.worldSize)}get cameraPixelsPerMeter(){return this.projection.pixelsPerMeter(this.center.lat,this.cameraWorldSize)}get centerOffset(){return this.centerPoint._sub(this.size._div(2))}get size(){return new e.pointGeometry(this.width,this.height)}get bearing(){return e.wrap(this.rotation,-180,180)}set bearing(e){this.rotation=e;}get rotation(){return -this.angle/Math.PI*180}set rotation(t){const i=-t*Math.PI/180;var o;this.angle!==i&&(this._unmodified=!1,this.angle=i,this._calcMatrices(),this.rotationMatrix=(o=new e.ARRAY_TYPE(4),e.ARRAY_TYPE!=Float32Array&&(o[1]=0,o[2]=0),o[0]=1,o[3]=1,o),function(e,t,i){var o=t[0],r=t[1],n=t[2],a=t[3],s=Math.sin(i),l=Math.cos(i);e[0]=o*l+n*s,e[1]=r*l+a*s,e[2]=o*-s+n*l,e[3]=r*-s+a*l;}(this.rotationMatrix,this.rotationMatrix,this.angle));}get pitch(){return this._pitch/Math.PI*180}set pitch(t){const i=e.clamp(t,this.minPitch,this.maxPitch)/180*Math.PI;this._pitch!==i&&(this._unmodified=!1,this._pitch=i,this._calcMatrices());}get fov(){return this._fov/Math.PI*180}set fov(e){e=Math.max(.01,Math.min(60,e)),this._fov!==e&&(this._unmodified=!1,this._fov=e/180*Math.PI,this._calcMatrices());}get averageElevation(){return this._averageElevation}set averageElevation(e){this._averageElevation=e,this._calcFogMatrices();}get zoom(){return this._zoom}set zoom(e){const t=Math.min(Math.max(e,this.minZoom),this.maxZoom);this._zoom!==t&&(this._unmodified=!1,this._setZoom(t),this._terrainEnabled()&&this._updateCameraOnTerrain(),this._constrain(),this._calcMatrices());}_setZoom(e){this._zoom=e,this.scale=this.zoomScale(e),this.tileZoom=Math.floor(e),this.zoomFraction=e-this.tileZoom;}_updateCenterElevation(){if(!this._elevation)return !1;const e=this._elevation.getAtPointOrZero(this.locationCoordinate(this.center),-1);return -1===e?(this._cameraZoom=null,!1):(this._centerAltitude=e,!0)}_updateCameraOnTerrain(){this._cameraZoom=this._zoomFromMercatorZ((this.pixelsPerMeter*this._centerAltitude+this.cameraToCenterDistance)/this.worldSize);}sampleAverageElevation(){if(!this._elevation)return 0;const t=this._elevation,i=[[.5,.2],[.3,.5],[.5,.5],[.7,.5],[.5,.8]],o=this.horizonLineFromTop();let r=0,n=0;for(let a=0;a<i.length;a++){const s=new e.pointGeometry(i[a][0]*this.width,o+i[a][1]*(this.height-o)),l=t.pointCoordinate(s);if(!l)continue;const c=1/Math.hypot(l[0]-this._camera.position[0],l[1]-this._camera.position[1]);r+=l[3]*c,n+=c;}return 0===n?NaN:r/n}get center(){return this._center}set center(e){e.lat===this._center.lat&&e.lng===this._center.lng||(this._unmodified=!1,this._center=e,this._terrainEnabled()&&("ground"===this.cameraElevationReference?this._updateCenterElevation()?this._updateCameraOnTerrain():this._cameraZoom=null:this._updateZoomFromElevation()),this._constrain(),this._calcMatrices());}_updateZoomFromElevation(){if(null==this._cameraZoom||!this._elevation)return;const e=this._cameraZoom,t=this._elevation.getAtPointOrZero(this.locationCoordinate(this.center)),i=this.pixelsPerMeter/this.worldSize*t,o=this._mercatorZfromZoom(e),r=this._mercatorZfromZoom(this._maxZoom),n=Math.max(o-i,r);this._setZoom(this._zoomFromMercatorZ(n));}get padding(){return this._edgeInsets.toJSON()}set padding(e){this._edgeInsets.equals(e)||(this._unmodified=!1,this._edgeInsets.interpolate(this._edgeInsets,e,1),this._calcMatrices());}computeZoomRelativeTo(t){const i=this.rayIntersectionCoordinate(this.pointRayIntersection(this.centerPoint,t.toAltitude()));let o;o=t.z<this._camera.position[2]?[i.x,i.y,i.z]:[t.x,t.y,t.z];const r=e.length(e.sub([],this._camera.position,o));return e.clamp(this._zoomFromMercatorZ(r),this._minZoom,this._maxZoom)}setFreeCameraOptions(t){if(!this.height)return;if(!t.position&&!t.orientation)return;this._updateCameraState();let i=!1;if(t.orientation&&!e.exactEquals(t.orientation,this._camera.orientation)&&(i=this._setCameraOrientation(t.orientation)),t.position){const o=[t.position.x,t.position.y,t.position.z];e.exactEquals$1(o,this._camera.position)||(this._setCameraPosition(o),i=!0);}i&&(this._updateStateFromCamera(),this.recenterOnTerrain());}getFreeCameraOptions(){this._updateCameraState();const t=this._camera.position,i=new xo;return i.position=new e.MercatorCoordinate(t[0],t[1],t[2]),i.orientation=this._camera.orientation,i._elevation=this.elevation,i._renderWorldCopies=this.renderWorldCopies,i}_setCameraOrientation(t){if(!e.length$1(t))return !1;e.normalize$1(t,t);const i=e.transformQuat([],[0,0,-1],t),o=e.transformQuat([],[0,-1,0],t);if(o[2]<0)return !1;const r=vo(i,o);return !!r&&(this._camera.orientation=r,!0)}_setCameraPosition(t){const i=this.zoomScale(this.minZoom)*this.tileSize,o=this.zoomScale(this.maxZoom)*this.tileSize,r=this.cameraToCenterDistance;t[2]=e.clamp(t[2],r/o,r/i),this._camera.position=t;}get centerPoint(){return this._edgeInsets.getCenter(this.width,this.height)}get fovAboveCenter(){return this._fov*(.5+this.centerOffset.y/this.height)}isPaddingEqual(e){return this._edgeInsets.equals(e)}interpolatePadding(e,t,i){this._unmodified=!1,this._edgeInsets.interpolate(e,t,i),this._constrain(),this._calcMatrices();}coveringZoomLevel(e){const t=(e.roundZoom?Math.round:Math.floor)(this.zoom+this.scaleZoom(this.tileSize/e.tileSize));return Math.max(0,t)}getVisibleUnwrappedCoordinates(t){const i=[new e.UnwrappedTileID(0,t)];if(this.renderWorldCopies){const o=this.pointCoordinate(new e.pointGeometry(0,0)),r=this.pointCoordinate(new e.pointGeometry(this.width,0)),n=this.pointCoordinate(new e.pointGeometry(this.width,this.height)),a=this.pointCoordinate(new e.pointGeometry(0,this.height)),s=Math.floor(Math.min(o.x,r.x,n.x,a.x)),l=Math.floor(Math.max(o.x,r.x,n.x,a.x)),c=1;for(let o=s-c;o<=l+c;o++)0!==o&&i.push(new e.UnwrappedTileID(o,t));}return i}coveringTiles(t){let i=this.coveringZoomLevel(t);const o=i,r=this.elevation&&!t.isTerrainDEM,n="mercator"===this.projection.name;if(void 0!==t.minzoom&&i<t.minzoom)return [];void 0!==t.maxzoom&&i>t.maxzoom&&(i=t.maxzoom);const a=this.locationCoordinate(this.center),s=1<<i,l=[s*a.x,s*a.y,0],c=e.Frustum.fromInvProjectionMatrix(this.invProjMatrix,this.worldSize,i,"globe"!==this.projection.name),h=this.pointCoordinate(this.getCameraPoint()),u=s*e.mercatorZfromAltitude(1,this.center.lat),_=this._camera.position[2]/e.mercatorZfromAltitude(1,this.center.lat),d=[s*h.x,s*h.y,_],p=this.cameraToCenterDistance/t.tileSize*(t.roundZoom?1:.502),m=this.pitch<=60&&this._edgeInsets.top<=this._edgeInsets.bottom&&!this._elevation&&!this.projection.isReprojectedInTileSpace?i:0,f=t.isTerrainDEM&&this._elevation?1e4*this._elevation.exaggeration():this._centerAltitude,g=t.isTerrainDEM?-f:this._elevation?this._elevation.getMinElevationBelowMSL():0,v=this.projection.isReprojectedInTileSpace?wo(this):1,x=t=>{const i=1/4e4,o=new e.MercatorCoordinate(t.x+i,t.y,t.z),r=new e.MercatorCoordinate(t.x,t.y+i,t.z),n=t.toLngLat(),a=o.toLngLat(),s=r.toLngLat(),l=this.locationCoordinate(n),c=this.locationCoordinate(a),h=this.locationCoordinate(s),u=Math.hypot(c.x-l.x,c.y-l.y),_=Math.hypot(h.x-l.x,h.y-l.y);return Math.sqrt(u*_)*v/i},y=t=>{const i=f,o=g;return {aabb:e.tileAABB(this,s,0,0,0,t,o,i,this.projection),zoom:0,x:0,y:0,minZ:o,maxZ:i,wrap:t,fullyVisible:!1}},b=[];let w=[];const T=i,E=t.reparseOverscaled?o:i,C=e=>e*e,M=C((_-this._centerAltitude)*u),S=e=>{if(!this._elevation||!e.tileID||!n)return;const t=this._elevation.getMinMaxForTile(e.tileID),i=e.aabb;t?(i.min[2]=t.min,i.max[2]=t.max,i.center[2]=(i.min[2]+i.max[2])/2):(e.shouldSplit=I(e),e.shouldSplit||(i.min[2]=i.max[2]=i.center[2]=this._centerAltitude));},I=t=>{if(t.zoom<m)return !0;if(t.zoom===T)return !1;if(null!=t.shouldSplit)return t.shouldSplit;const i=t.aabb.distanceX(d),n=t.aabb.distanceY(d);let a=M;r&&(a=C(t.aabb.distanceZ(d)*u));let s=1;if(this.projection.isReprojectedInTileSpace&&o<=5){const i=Math.pow(2,t.zoom),o=x(new e.MercatorCoordinate((t.x+.5)/i,(t.y+.5)/i));s=o>.85?1:o;}const l=i*i+n*n+a;return l<C((1<<T-t.zoom)*p*s*((e,t)=>{if(t*C(.707)<e)return 1;const i=Math.sqrt(t/e);return i/(1.4144271570014144+(Math.pow(1.1,i-1.4144271570014144+1)-1)/(1.1-1)-1)})(Math.max(a,M),l))};if(this.renderWorldCopies)for(let e=1;e<=3;e++)b.push(y(-e)),b.push(y(e));for(b.push(y(0));b.length>0;){const o=b.pop(),a=o.x,h=o.y;let u=o.fullyVisible;if(!u){const e=o.aabb.intersects(c);if(0===e)continue;u=2===e;}if(o.zoom!==T&&I(o))for(let t=0;t<4;t++){const i=(a<<1)+t%2,l=(h<<1)+(t>>1),c={aabb:n?o.aabb.quadrant(t):e.tileAABB(this,s,o.zoom+1,i,l,o.wrap,o.minZ,o.maxZ,this.projection),zoom:o.zoom+1,x:i,y:l,wrap:o.wrap,fullyVisible:u,tileID:void 0,shouldSplit:void 0,minZ:o.minZ,maxZ:o.maxZ};r&&(c.tileID=new e.OverscaledTileID(o.zoom+1===T?E:o.zoom+1,o.wrap,o.zoom+1,i,l),S(c)),b.push(c);}else {const r=o.zoom===T?E:o.zoom;if(t.minzoom&&t.minzoom>r)continue;const n=l[0]-(.5+a+(o.wrap<<o.zoom))*(1<<i-o.zoom),s=l[1]-.5-h,c=o.tileID?o.tileID:new e.OverscaledTileID(r,o.wrap,o.zoom,a,h);w.push({tileID:c,distanceSq:n*n+s*s});}}if(this.fogCullDistSq){const i=this.fogCullDistSq,o=this.horizonLineFromTop();w=w.filter((r=>{const n=[0,0,0,1],a=[e.EXTENT,e.EXTENT,0,1],s=this.calculateFogTileMatrix(r.tileID.toUnwrapped());e.transformMat4$1(n,n,s),e.transformMat4$1(a,a,s);const l=e.getAABBPointSquareDist(n,a);if(0===l)return !0;let c=!1;const h=this._elevation;if(h&&l>i&&0!==o){const i=this.calculateProjMatrix(r.tileID.toUnwrapped());let n;t.isTerrainDEM||(n=h.getMinMaxForTile(r.tileID)),n||(n={min:g,max:f});const a=e.furthestTileCorner(this.rotation),s=[a[0]*e.EXTENT,a[1]*e.EXTENT,n.max];e.transformMat4(s,s,i),c=(1-s[1])*this.height*.5<o;}return l<i||c}));}return w.sort(((e,t)=>e.distanceSq-t.distanceSq)).map((e=>e.tileID))}resize(e,t){this.width=e,this.height=t,this.pixelsToGLUnits=[2/e,-2/t],this._constrain(),this._calcMatrices();}get unmodified(){return this._unmodified}zoomScale(e){return Math.pow(2,e)}scaleZoom(e){return Math.log(e)/Math.LN2}project(t){const i=e.clamp(t.lat,-e.MAX_MERCATOR_LATITUDE,e.MAX_MERCATOR_LATITUDE),o=this.projection.project(t.lng,i);return new e.pointGeometry(o.x*this.worldSize,o.y*this.worldSize)}unproject(e){return this.projection.unproject(e.x/this.worldSize,e.y/this.worldSize)}get point(){return this.project(this.center)}setLocationAtPoint(t,i){const o=this.pointCoordinate(i),r=this.pointCoordinate(this.centerPoint),n=this.locationCoordinate(t);this.setLocation(new e.MercatorCoordinate(n.x-(o.x-r.x),n.y-(o.y-r.y)));}setLocation(e){this.center=this.coordinateLocation(e),this.projection.wrap&&(this.center=this.center.wrap());}locationPoint(e){return this.projection.locationPoint(this,e)}locationPoint3D(e){return this._coordinatePoint(this.locationCoordinate(e),!0)}pointLocation(e){return this.coordinateLocation(this.pointCoordinate(e))}pointLocation3D(e){return this.coordinateLocation(this.pointCoordinate3D(e))}locationCoordinate(t,i){const o=i?e.mercatorZfromAltitude(i,t.lat):void 0,r=this.projection.project(t.lng,t.lat);return new e.MercatorCoordinate(r.x,r.y,o)}coordinateLocation(e){return this.projection.unproject(e.x,e.y)}pointRayIntersection(t,i){const o=null!=i?i:this._centerAltitude,r=[t.x,t.y,0,1],n=[t.x,t.y,1,1];e.transformMat4$1(r,r,this.pixelMatrixInverse),e.transformMat4$1(n,n,this.pixelMatrixInverse);const a=n[3];e.scale$1(r,r,1/r[3]),e.scale$1(n,n,1/a);const s=r[2],l=n[2];return {p0:r,p1:n,t:s===l?0:(o-s)/(l-s)}}screenPointToMercatorRay(t){const i=[t.x,t.y,0,1],o=[t.x,t.y,1,1];return e.transformMat4$1(i,i,this.pixelMatrixInverse),e.transformMat4$1(o,o,this.pixelMatrixInverse),e.scale$1(i,i,1/i[3]),e.scale$1(o,o,1/o[3]),i[2]=e.mercatorZfromAltitude(i[2],this._center.lat)*this.worldSize,o[2]=e.mercatorZfromAltitude(o[2],this._center.lat)*this.worldSize,e.scale$1(i,i,1/this.worldSize),e.scale$1(o,o,1/this.worldSize),new e.Ray([i[0],i[1],i[2]],e.normalize([],e.sub([],o,i)))}rayIntersectionCoordinate(t){const{p0:i,p1:o,t:r}=t,n=e.mercatorZfromAltitude(i[2],this._center.lat),a=e.mercatorZfromAltitude(o[2],this._center.lat);return new e.MercatorCoordinate(e.number(i[0],o[0],r)/this.worldSize,e.number(i[1],o[1],r)/this.worldSize,e.number(n,a,r))}pointCoordinate(e,t=this._centerAltitude){return this.projection.createTileTransform(this,this.worldSize).pointCoordinate(e.x,e.y,t)}pointCoordinate3D(t){if(!this.elevation)return this.pointCoordinate(t);const i=this.elevation;let o=this.elevation.pointCoordinate(t);if(o)return new e.MercatorCoordinate(o[0],o[1],o[2]);let r=0,n=this.horizonLineFromTop();if(t.y>n)return this.pointCoordinate(t);const a=.02*n,s=t.clone();for(let t=0;t<10&&n-r>a;t++){s.y=e.number(r,n,.66);const t=i.pointCoordinate(s);t?(n=s.y,o=t):r=s.y;}return o?new e.MercatorCoordinate(o[0],o[1],o[2]):this.pointCoordinate(t)}isPointAboveHorizon(e){if(this.elevation)return !this.elevation.pointCoordinate(e);{const t=this.horizonLineFromTop();return e.y<t}}_coordinatePoint(t,i){const o=i&&this.elevation?this.elevation.getAtPointOrZero(t,this._centerAltitude):this._centerAltitude,r=[t.x*this.worldSize,t.y*this.worldSize,o+t.toAltitude(),1];return e.transformMat4$1(r,r,this.pixelMatrix),r[3]>0?new e.pointGeometry(r[0]/r[3],r[1]/r[3]):new e.pointGeometry(Number.MAX_VALUE,Number.MAX_VALUE)}_getBounds(t,i){const o=new e.pointGeometry(this._edgeInsets.left,this._edgeInsets.top),r=new e.pointGeometry(this.width-this._edgeInsets.right,this._edgeInsets.top),n=new e.pointGeometry(this.width-this._edgeInsets.right,this.height-this._edgeInsets.bottom),a=new e.pointGeometry(this._edgeInsets.left,this.height-this._edgeInsets.bottom);let s=this.pointCoordinate(o,t),l=this.pointCoordinate(r,t);const c=this.pointCoordinate(n,i),h=this.pointCoordinate(a,i),u=(e,t)=>(t.y-e.y)/(t.x-e.x);return s.y>1&&l.y>=0?s=new e.MercatorCoordinate((1-h.y)/u(h,s)+h.x,1):s.y<0&&l.y<=1&&(s=new e.MercatorCoordinate(-h.y/u(h,s)+h.x,0)),l.y>1&&s.y>=0?l=new e.MercatorCoordinate((1-c.y)/u(c,l)+c.x,1):l.y<0&&s.y<=1&&(l=new e.MercatorCoordinate(-c.y/u(c,l)+c.x,0)),(new e.LngLatBounds).extend(this.coordinateLocation(s)).extend(this.coordinateLocation(l)).extend(this.coordinateLocation(h)).extend(this.coordinateLocation(c))}_getBounds3D(){const e=this.elevation;if(!e.visibleDemTiles.length)return this._getBounds(0,0);const t=e.visibleDemTiles.reduce(((e,t)=>{if(t.dem){const i=t.dem.tree;e.min=Math.min(e.min,i.minimums[0]),e.max=Math.max(e.max,i.maximums[0]);}return e}),{min:Number.MAX_VALUE,max:0});return this._getBounds(t.min*e.exaggeration(),t.max*e.exaggeration())}getBounds(){return this._terrainEnabled()?this._getBounds3D():this._getBounds(0,0)}horizonLineFromTop(e=!0){const t=this.height/2/Math.tan(this._fov/2)/Math.tan(Math.max(this._pitch,.1))+this.centerOffset.y,i=this.height/2-t*(1-this._horizonShift);return e?Math.max(0,i):i}getMaxBounds(){return this.maxBounds}setMaxBounds(t){this.maxBounds=t,this.minLat=-e.MAX_MERCATOR_LATITUDE,this.maxLat=e.MAX_MERCATOR_LATITUDE,this.minLng=-180,this.maxLng=180,t&&(this.minLat=t.getSouth(),this.maxLat=t.getNorth(),this.minLng=t.getWest(),this.maxLng=t.getEast(),this.maxLng<this.minLng&&(this.maxLng+=360)),this.worldMinX=e.mercatorXfromLng(this.minLng)*this.tileSize,this.worldMaxX=e.mercatorXfromLng(this.maxLng)*this.tileSize,this.worldMinY=e.mercatorYfromLat(this.maxLat)*this.tileSize,this.worldMaxY=e.mercatorYfromLat(this.minLat)*this.tileSize,this._constrain();}calculatePosMatrix(e,t){return this.projection.createTileTransform(this,t).createTileMatrix(e)}calculateDistanceTileData(t){const i=t.key,o=this._distanceTileDataCache;if(o[i])return o[i];const r=t.canonical,n=1/this.height,a=this.cameraWorldSize/this.zoomScale(r.z),s=(r.x+Math.pow(2,r.z)*t.wrap)*a,l=r.y*a,c=this.point,h=this.angle,u=Math.sin(-h),_=-Math.cos(-h);return o[i]={bearing:[u,_],center:[(c.x-s)*n,(c.y-l)*n],scale:a/e.EXTENT*n},o[i]}calculateFogTileMatrix(t){const i=t.key,o=this._fogTileMatrixCache;if(o[i])return o[i];const r=this.calculatePosMatrix(t,this.cameraWorldSize);return e.multiply$1(r,this.worldToFogMatrix,r),o[i]=new Float32Array(r),o[i]}calculateProjMatrix(t,i=!1){const o=t.key,r=i?this._alignedProjMatrixCache:this._projMatrixCache;if(r[o])return r[o];const n=this.calculatePosMatrix(t,this.worldSize);return e.multiply$1(n,this.projection.isReprojectedInTileSpace?this.mercatorMatrix:i?this.alignedProjMatrix:this.projMatrix,n),r[o]=new Float32Array(n),r[o]}calculatePixelsToTileUnitsMatrix(t){const i=t.tileID.key,o=this._pixelsToTileUnitsCache;if(o[i])return o[i];const r=function(t,i){const{scale:o}=t.tileTransform,r=o*e.EXTENT/(t.tileSize*Math.pow(2,i.zoom-t.tileID.overscaledZ+t.tileID.canonical.z));return n=new Float32Array(4),l=(a=i.inverseAdjustmentMatrix)[1],c=a[2],h=a[3],_=(s=[r,r])[1],n[0]=a[0]*(u=s[0]),n[1]=l*u,n[2]=c*_,n[3]=h*_,n;var n,a,s,l,c,h,u,_;}(t,this);return o[i]=r,o[i]}customLayerMatrix(){return this.mercatorMatrix.slice()}recenterOnTerrain(){if(!this._elevation)return;const t=this._elevation;this._updateCameraState();const i=e.mercatorZfromAltitude(1,this._center.lat)*this.worldSize,o=this._computeCameraPosition(i),r=this._camera.forward(),n=e.mercatorZfromAltitude(1,this._center.lat);o[2]/=n,r[2]/=n,e.normalize(r,r);const a=t.raycast(o,r,t.exaggeration());if(a){const t=e.scaleAndAdd([],o,r,a),i=new e.MercatorCoordinate(t[0],t[1],e.mercatorZfromAltitude(t[2],e.latFromMercatorY(t[1]))),s=(i.z+e.length([i.x-o[0],i.y-o[1],i.z-o[2]*n]))*this._projectionScaler;this._cameraZoom=this._zoomFromMercatorZ(s),this._centerAltitude=i.toAltitude(),this._center=this.coordinateLocation(i),this._updateZoomFromElevation(),this._constrain(),this._calcMatrices();}}_constrainCameraAltitude(){if(!this._elevation)return;const t=this._elevation;this._updateCameraState();const i=e.mercatorZfromAltitude(1,this._center.lat)*this.worldSize,o=this._computeCameraPosition(i),r=t.getAtPointOrZero(new e.MercatorCoordinate(...o)),n=this._minimumHeightOverTerrain()*Math.cos(e.degToRad(this._maxPitch)),a=this._camera.position[2]-this.pixelsPerMeter/this.worldSize*r;if(a<n){const t=this.locationCoordinate(this._center,this._centerAltitude),i=[t.x-o[0],t.y-o[1],t.z-o[2]],r=e.length(i);i[2]-=(n-a)/this._projectionScaler;const s=e.length(i);if(0===s)return;e.scale$2(i,i,r/s*this._projectionScaler),this._camera.position=[t.x-i[0],t.y-i[1],t.z*this._projectionScaler-i[2]],this._camera.orientation=vo(i,this._camera.up()),this._updateStateFromCamera();}}_constrain(){if(!this.center||!this.width||!this.height||this._constraining)return;if(this._constraining=!0,this.projection.isReprojectedInTileSpace){const t=this.center;return t.lat=e.clamp(t.lat,this.minLat,this.maxLat),!this.maxBounds&&this.renderWorldCopies||(t.lng=e.clamp(t.lng,this.minLng,this.maxLng)),this.center=t,void(this._constraining=!1)}const t=this._unmodified,{x:i,y:o}=this.point;let r=0,n=i,a=o;const s=this.width/2,l=this.height/2,c=this.worldMinY*this.scale,h=this.worldMaxY*this.scale;if(o-l<c&&(a=c+l),o+l>h&&(a=h-l),h-c<this.height&&(r=Math.max(r,this.height/(h-c)),a=(h+c)/2),this.maxBounds||!this._renderWorldCopies||!this.projection.wrap){const e=this.worldMinX*this.scale,t=this.worldMaxX*this.scale,o=this.worldSize/2-(e+t)/2;n=(i+o+this.worldSize)%this.worldSize-o,n-s<e&&(n=e+s),n+s>t&&(n=t-s),t-e<this.width&&(r=Math.max(r,this.width/(t-e)),n=(t+e)/2);}n===i&&a===o||(this.center=this.unproject(new e.pointGeometry(n,a))),r&&(this.zoom+=this.scaleZoom(r)),this._constrainCameraAltitude(),this._unmodified=t,this._constraining=!1;}_minZoomForBounds(){let e=Math.max(0,this.scaleZoom(this.height/(this.worldMaxY-this.worldMinY)));return this.maxBounds&&(e=Math.max(e,this.scaleZoom(this.width/(this.worldMaxX-this.worldMinX)))),e}_maxCameraBoundsDistance(){return this._mercatorZfromZoom(this._minZoomForBounds())}_calcMatrices(){if(!this.height)return;const t=this._fov/2,i=this.centerOffset,o=this.pixelsPerMeter;this._projectionScaler=o/(e.mercatorZfromAltitude(1,this.center.lat)*this.worldSize),this.cameraToCenterDistance=.5/Math.tan(t)*this.height*this._projectionScaler,this._updateCameraState(),this._farZ=this.projection.farthestPixelDistance(this),this._nearZ=this.height/50;const n=this._camera.getWorldToCamera(this.worldSize,"meters"===this.projection.zAxisUnit?o:1),a=this._camera.getCameraToClipPerspective(this._fov,this.width/this.height,this._nearZ,this._farZ);a[8]=2*-i.x/this.width,a[9]=2*i.y/this.height;let s=e.mul([],a,n);if(this.projection.isReprojectedInTileSpace){const t=this.locationCoordinate(this.center),i=e.identity([]);e.translate(i,i,[t.x*this.worldSize,t.y*this.worldSize,0]),e.multiply$1(i,i,bo(this)),e.translate(i,i,[-t.x*this.worldSize,-t.y*this.worldSize,0]),e.multiply$1(s,s,i),this.inverseAdjustmentMatrix=function(e){const t=bo(e,!0);return r([],[t[0],t[1],t[4],t[5]])}(this);}else this.inverseAdjustmentMatrix=[1,0,0,1];this.mercatorMatrix=e.scale([],s,[this.worldSize,this.worldSize,this.worldSize/o,1]),this.projMatrix=s,this.invProjMatrix=e.invert(new Float64Array(16),this.projMatrix);const l=new Float32Array(16);e.identity(l),e.scale(l,l,[1,-1,1]),e.rotateX(l,l,this._pitch),e.rotateZ(l,l,this.angle);const c=e.perspective(new Float32Array(16),this._fov,this.width/this.height,this._nearZ,this._farZ),h=(Math.PI/2-this._pitch)*(this.height/this._fov)*this._horizonShift;c[8]=2*-i.x/this.width,c[9]=2*(i.y+h)/this.height,this.skyboxMatrix=e.multiply$1(l,c,l);const u=this.point,_=u.x,d=u.y,p=this.width%2/2,m=this.height%2/2,f=Math.cos(this.angle),g=Math.sin(this.angle),v=_-Math.round(_)+f*p+g*m,x=d-Math.round(d)+f*m+g*p,y=new Float64Array(s);if(e.translate(y,y,[v>.5?v-1:v,x>.5?x-1:x,0]),this.alignedProjMatrix=y,s=e.create(),e.scale(s,s,[this.width/2,-this.height/2,1]),e.translate(s,s,[1,-1,0]),this.labelPlaneMatrix=s,s=e.create(),e.scale(s,s,[1,-1,1]),e.translate(s,s,[-1,-1,0]),e.scale(s,s,[2/this.width,2/this.height,1]),this.glCoordMatrix=s,this.pixelMatrix=e.multiply$1(new Float64Array(16),this.labelPlaneMatrix,this.projMatrix),this._calcFogMatrices(),this._distanceTileDataCache={},s=e.invert(new Float64Array(16),this.pixelMatrix),!s)throw new Error("failed to invert matrix");this.pixelMatrixInverse=s,this._projMatrixCache={},this._alignedProjMatrixCache={},this._pixelsToTileUnitsCache={};}_calcFogMatrices(){this._fogTileMatrixCache={};const t=this.cameraWorldSize,i=this.cameraPixelsPerMeter,o=this._camera.position,r=1/this.height,n=[t,t,i];e.scale$2(n,n,r),e.scale$2(o,o,-1),e.multiply$2(o,o,n);const a=e.create();e.translate(a,a,o),e.scale(a,a,n),this.mercatorFogMatrix=a,this.worldToFogMatrix=this._camera.getWorldToCameraPosition(t,i,r);}_computeCameraPosition(e){const t=(e=e||this.pixelsPerMeter)/this.pixelsPerMeter,i=this._camera.forward(),o=this.point,r=this._mercatorZfromZoom(this._cameraZoom?this._cameraZoom:this._zoom)*t-e/this.worldSize*this._centerAltitude;return [o.x/this.worldSize-i[0]*r,o.y/this.worldSize-i[1]*r,e/this.worldSize*this._centerAltitude-i[2]*r]}_updateCameraState(){this.height&&(this._camera.setPitchBearing(this._pitch,this.angle),this._camera.position=this._computeCameraPosition());}_translateCameraConstrained(t){const i=this._maxCameraBoundsDistance()*Math.cos(this._pitch),o=t[2];let r=1;o>0&&(r=Math.min((i-this._camera.position[2])/o,1)),this._camera.position=e.scaleAndAdd([],this._camera.position,t,r),this._updateStateFromCamera();}_updateStateFromCamera(){const t=this._camera.position,i=this._camera.forward(),{pitch:o,bearing:r}=this._camera.getPitchBearing(),n=e.mercatorZfromAltitude(this._centerAltitude,this.center.lat)*this._projectionScaler,a=this._mercatorZfromZoom(this._maxZoom)*Math.cos(e.degToRad(this._maxPitch)),s=Math.max((t[2]-n)/Math.cos(o),a),l=this._zoomFromMercatorZ(s);e.scaleAndAdd(t,t,i,s),this._pitch=e.clamp(o,e.degToRad(this.minPitch),e.degToRad(this.maxPitch)),this.angle=e.wrap(r,-Math.PI,Math.PI),this._setZoom(e.clamp(l,this._minZoom,this._maxZoom)),this._terrainEnabled()&&this._updateCameraOnTerrain(),this._center=this.coordinateLocation(new e.MercatorCoordinate(t[0],t[1],t[2])),this._unmodified=!1,this._constrain(),this._calcMatrices();}_worldSizeFromZoom(e){return Math.pow(2,e)*this.tileSize}_mercatorZfromZoom(e){return this.cameraToCenterDistance/this._worldSizeFromZoom(e)}_minimumHeightOverTerrain(){const e=Math.min((null!=this._cameraZoom?this._cameraZoom:this._zoom)+2,this._maxZoom);return this._mercatorZfromZoom(e)}_zoomFromMercatorZ(e){return this.scaleZoom(this.cameraToCenterDistance/(e*this.tileSize))}_terrainEnabled(){return !(!this._elevation||!this.projection.supportsTerrain&&(e.warnOnce("Terrain is not yet supported with alternate projections. Use mercator to enable terrain."),1))}anyCornerOffEdge(t,i){const o=Math.min(t.x,i.x),r=Math.max(t.x,i.x),n=Math.min(t.y,i.y),a=Math.max(t.y,i.y);if(n<this.horizonLineFromTop(!1))return !0;if("mercator"!==this.projection.name)return !1;const s=[new e.pointGeometry(o,n),new e.pointGeometry(r,a),new e.pointGeometry(o,a),new e.pointGeometry(r,n)],l=this.renderWorldCopies?-3:0,c=this.renderWorldCopies?4:1;for(const e of s){const t=this.pointRayIntersection(e);if(t.t<0)return !0;const i=this.rayIntersectionCoordinate(t);if(i.x<l||i.y<0||i.x>c||i.y>1)return !0}return !1}isHorizonVisible(){return this.pitch+e.radToDeg(this.fovAboveCenter)>88||this.anyCornerOffEdge(new e.pointGeometry(0,0),new e.pointGeometry(this.width,this.height))}zoomDeltaToMovement(t,i){const o=e.length(e.sub([],this._camera.position,t)),r=this._zoomFromMercatorZ(o)+i;return o-this._mercatorZfromZoom(r)}getCameraPoint(){const t=Math.tan(this._pitch)*(this.cameraToCenterDistance||1);return this.centerPoint.add(new e.pointGeometry(0,t))}}function Io(e,t){let i=!1,o=null;const r=()=>{o=null,i&&(e(),o=setTimeout(r,t),i=!1);};return ()=>(i=!0,o||r(),o)}class zo{constructor(t){this._hashName=t&&encodeURIComponent(t),e.bindAll(["_getCurrentHash","_onHashChange","_updateHash"],this),this._updateHash=Io(this._updateHashUnthrottled.bind(this),300);}addTo(t){return this._map=t,e.window.addEventListener("hashchange",this._onHashChange,!1),this._map.on("moveend",this._updateHash),this}remove(){return e.window.removeEventListener("hashchange",this._onHashChange,!1),this._map.off("moveend",this._updateHash),clearTimeout(this._updateHash()),delete this._map,this}getHashString(t){const i=this._map.getCenter(),o=Math.round(100*this._map.getZoom())/100,r=Math.ceil((o*Math.LN2+Math.log(512/360/.5))/Math.LN10),n=Math.pow(10,r),a=Math.round(i.lng*n)/n,s=Math.round(i.lat*n)/n,l=this._map.getBearing(),c=this._map.getPitch();let h="";if(h+=t?`/${a}/${s}/${o}`:`${o}/${s}/${a}`,(l||c)&&(h+="/"+Math.round(10*l)/10),c&&(h+=`/${Math.round(c)}`),this._hashName){const t=this._hashName;let i=!1;const o=e.window.location.hash.slice(1).split("&").map((e=>{const o=e.split("=")[0];return o===t?(i=!0,`${o}=${h}`):e})).filter((e=>e));return i||o.push(`${t}=${h}`),`#${o.join("&")}`}return `#${h}`}_getCurrentHash(){const t=e.window.location.hash.replace("#","");if(this._hashName){let e;return t.split("&").map((e=>e.split("="))).forEach((t=>{t[0]===this._hashName&&(e=t);})),(e&&e[1]||"").split("/")}return t.split("/")}_onHashChange(){const e=this._getCurrentHash();if(e.length>=3&&!e.some((e=>isNaN(e)))){const t=this._map.dragRotate.isEnabled()&&this._map.touchZoomRotate.isEnabled()?+(e[3]||0):this._map.getBearing();return this._map.jumpTo({center:[+e[2],+e[1]],zoom:+e[0],bearing:t,pitch:+(e[4]||0)}),!0}return !1}_updateHashUnthrottled(){const t=e.window.location.href.replace(/(#.+)?$/,this.getHashString());e.window.history.replaceState(e.window.history.state,null,t);}}const Do={linearity:.3,easing:e.bezier(0,0,.3,1)},Po=e.extend({deceleration:2500,maxSpeed:1400},Do),Ao=e.extend({deceleration:20,maxSpeed:1400},Do),Lo=e.extend({deceleration:1e3,maxSpeed:360},Do),Ro=e.extend({deceleration:1e3,maxSpeed:90},Do);class ko{constructor(e){this._map=e,this.clear();}clear(){this._inertiaBuffer=[];}record(t){this._drainInertiaBuffer(),this._inertiaBuffer.push({time:e.exported.now(),settings:t});}_drainInertiaBuffer(){const t=this._inertiaBuffer,i=e.exported.now();for(;t.length>0&&i-t[0].time>160;)t.shift();}_onMoveEnd(t){if(this._drainInertiaBuffer(),this._inertiaBuffer.length<2)return;const i={zoom:0,bearing:0,pitch:0,pan:new e.pointGeometry(0,0),pinchAround:void 0,around:void 0};for(const{settings:e}of this._inertiaBuffer)i.zoom+=e.zoomDelta||0,i.bearing+=e.bearingDelta||0,i.pitch+=e.pitchDelta||0,e.panDelta&&i.pan._add(e.panDelta),e.around&&(i.around=e.around),e.pinchAround&&(i.pinchAround=e.pinchAround);const o=this._inertiaBuffer[this._inertiaBuffer.length-1].time-this._inertiaBuffer[0].time,r={};if(i.pan.mag()){const n=Bo(i.pan.mag(),o,e.extend({},Po,t||{}));r.offset=i.pan.mult(n.amount/i.pan.mag()),r.center=this._map.transform.center,Oo(r,n);}if(i.zoom){const e=Bo(i.zoom,o,Ao);r.zoom=this._map.transform.zoom+e.amount,Oo(r,e);}if(i.bearing){const t=Bo(i.bearing,o,Lo);r.bearing=this._map.transform.bearing+e.clamp(t.amount,-179,179),Oo(r,t);}if(i.pitch){const e=Bo(i.pitch,o,Ro);r.pitch=this._map.transform.pitch+e.amount,Oo(r,e);}if(r.zoom||r.bearing){const e=void 0===i.pinchAround?i.around:i.pinchAround;r.around=e?this._map.unproject(e):this._map.getCenter();}return this.clear(),e.extend(r,{noMoveStart:!0})}}function Oo(e,t){(!e.duration||e.duration<t.duration)&&(e.duration=t.duration,e.easing=t.easing);}function Bo(t,i,o){const{maxSpeed:r,linearity:n,deceleration:a}=o,s=e.clamp(t*n/(i/1e3),-r,r),l=Math.abs(s)/(a*n);return {easing:o.easing,duration:1e3*l,amount:s*(l/2)}}class Fo extends e.Event{preventDefault(){this._defaultPrevented=!0;}get defaultPrevented(){return this._defaultPrevented}constructor(t,i,o,r={}){const n=a.mousePos(i.getCanvasContainer(),o),s=i.unproject(n);super(t,e.extend({point:n,lngLat:s,originalEvent:o},r)),this._defaultPrevented=!1,this.target=i;}}class Uo extends e.Event{preventDefault(){this._defaultPrevented=!0;}get defaultPrevented(){return this._defaultPrevented}constructor(t,i,o){const r="touchend"===t?o.changedTouches:o.touches,n=a.touchPos(i.getCanvasContainer(),r),s=n.map((e=>i.unproject(e))),l=n.reduce(((e,t,i,o)=>e.add(t.div(o.length))),new e.pointGeometry(0,0));super(t,{points:n,point:l,lngLats:s,lngLat:i.unproject(l),originalEvent:o}),this._defaultPrevented=!1;}}class No extends e.Event{preventDefault(){this._defaultPrevented=!0;}get defaultPrevented(){return this._defaultPrevented}constructor(e,t,i){super(e,{originalEvent:i}),this._defaultPrevented=!1;}}class Go{constructor(e,t){this._map=e,this._clickTolerance=t.clickTolerance;}reset(){delete this._mousedownPos;}wheel(e){return this._firePreventable(new No(e.type,this._map,e))}mousedown(e,t){return this._mousedownPos=t,this._firePreventable(new Fo(e.type,this._map,e))}mouseup(e){this._map.fire(new Fo(e.type,this._map,e));}preclick(t){const i=e.extend({},t);i.type="preclick",this._map.fire(new Fo(i.type,this._map,i));}click(e,t){this._mousedownPos&&this._mousedownPos.dist(t)>=this._clickTolerance||(this.preclick(e),this._map.fire(new Fo(e.type,this._map,e)));}dblclick(e){return this._firePreventable(new Fo(e.type,this._map,e))}mouseover(e){this._map.fire(new Fo(e.type,this._map,e));}mouseout(e){this._map.fire(new Fo(e.type,this._map,e));}touchstart(e){return this._firePreventable(new Uo(e.type,this._map,e))}touchmove(e){this._map.fire(new Uo(e.type,this._map,e));}touchend(e){this._map.fire(new Uo(e.type,this._map,e));}touchcancel(e){this._map.fire(new Uo(e.type,this._map,e));}_firePreventable(e){if(this._map.fire(e),e.defaultPrevented)return {}}isEnabled(){return !0}isActive(){return !1}enable(){}disable(){}}class jo{constructor(e){this._map=e;}reset(){this._delayContextMenu=!1,delete this._contextMenuEvent;}mousemove(e){this._map.fire(new Fo(e.type,this._map,e));}mousedown(){this._delayContextMenu=!0;}mouseup(){this._delayContextMenu=!1,this._contextMenuEvent&&(this._map.fire(new Fo("contextmenu",this._map,this._contextMenuEvent)),delete this._contextMenuEvent);}contextmenu(e){this._delayContextMenu?this._contextMenuEvent=e:this._map.fire(new Fo(e.type,this._map,e)),this._map.listens("contextmenu")&&e.preventDefault();}isEnabled(){return !0}isActive(){return !1}enable(){}disable(){}}class Zo{constructor(e,t){this._map=e,this._el=e.getCanvasContainer(),this._container=e.getContainer(),this._clickTolerance=t.clickTolerance||1;}isEnabled(){return !!this._enabled}isActive(){return !!this._active}enable(){this.isEnabled()||(this._enabled=!0);}disable(){this.isEnabled()&&(this._enabled=!1);}mousedown(e,t){this.isEnabled()&&e.shiftKey&&0===e.button&&(a.disableDrag(),this._startPos=this._lastPos=t,this._active=!0);}mousemoveWindow(e,t){if(!this._active)return;const i=t;if(this._lastPos.equals(i)||!this._box&&i.dist(this._startPos)<this._clickTolerance)return;const o=this._startPos;this._lastPos=i,this._box||(this._box=a.create("div","mapboxgl-boxzoom",this._container),this._container.classList.add("mapboxgl-crosshair"),this._fireEvent("boxzoomstart",e));const r=Math.min(o.x,i.x),n=Math.max(o.x,i.x),s=Math.min(o.y,i.y),l=Math.max(o.y,i.y);this._map._requestDomTask((()=>{this._box&&(this._box.style.transform=`translate(${r}px,${s}px)`,this._box.style.width=n-r+"px",this._box.style.height=l-s+"px");}));}mouseupWindow(t,i){if(!this._active)return;if(0!==t.button)return;const o=this._startPos,r=i;if(this.reset(),a.suppressClick(),o.x!==r.x||o.y!==r.y)return this._map.fire(new e.Event("boxzoomend",{originalEvent:t})),{cameraAnimation:e=>e.fitScreenCoordinates(o,r,this._map.getBearing(),{linear:!1})};this._fireEvent("boxzoomcancel",t);}keydown(e){this._active&&27===e.keyCode&&(this.reset(),this._fireEvent("boxzoomcancel",e));}blur(){this.reset();}reset(){this._active=!1,this._container.classList.remove("mapboxgl-crosshair"),this._box&&(this._box.remove(),this._box=null),a.enableDrag(),delete this._startPos,delete this._lastPos;}_fireEvent(t,i){return this._map.fire(new e.Event(t,{originalEvent:i}))}}function Vo(e,t){const i={};for(let o=0;o<e.length;o++)i[e[o].identifier]=t[o];return i}class Wo{constructor(e){this.reset(),this.numTouches=e.numTouches;}reset(){delete this.centroid,delete this.startTime,delete this.touches,this.aborted=!1;}touchstart(t,i,o){(this.centroid||o.length>this.numTouches)&&(this.aborted=!0),this.aborted||(void 0===this.startTime&&(this.startTime=t.timeStamp),o.length===this.numTouches&&(this.centroid=function(t){const i=new e.pointGeometry(0,0);for(const e of t)i._add(e);return i.div(t.length)}(i),this.touches=Vo(o,i)));}touchmove(e,t,i){if(this.aborted||!this.centroid)return;const o=Vo(i,t);for(const e in this.touches){const t=this.touches[e],i=o[e];(!i||i.dist(t)>30)&&(this.aborted=!0);}}touchend(e,t,i){if((!this.centroid||e.timeStamp-this.startTime>500)&&(this.aborted=!0),0===i.length){const e=!this.aborted&&this.centroid;if(this.reset(),e)return e}}}class qo{constructor(e){this.singleTap=new Wo(e),this.numTaps=e.numTaps,this.reset();}reset(){this.lastTime=1/0,delete this.lastTap,this.count=0,this.singleTap.reset();}touchstart(e,t,i){this.singleTap.touchstart(e,t,i);}touchmove(e,t,i){this.singleTap.touchmove(e,t,i);}touchend(e,t,i){const o=this.singleTap.touchend(e,t,i);if(o){const t=e.timeStamp-this.lastTime<500,i=!this.lastTap||this.lastTap.dist(o)<30;if(t&&i||this.reset(),this.count++,this.lastTime=e.timeStamp,this.lastTap=o,this.count===this.numTaps)return this.reset(),o}}}class Xo{constructor(){this._zoomIn=new qo({numTouches:1,numTaps:2}),this._zoomOut=new qo({numTouches:2,numTaps:1}),this.reset();}reset(){this._active=!1,this._zoomIn.reset(),this._zoomOut.reset();}touchstart(e,t,i){this._zoomIn.touchstart(e,t,i),this._zoomOut.touchstart(e,t,i);}touchmove(e,t,i){this._zoomIn.touchmove(e,t,i),this._zoomOut.touchmove(e,t,i);}touchend(e,t,i){const o=this._zoomIn.touchend(e,t,i),r=this._zoomOut.touchend(e,t,i);return o?(this._active=!0,e.preventDefault(),setTimeout((()=>this.reset()),0),{cameraAnimation:t=>t.easeTo({duration:300,zoom:t.getZoom()+1,around:t.unproject(o)},{originalEvent:e})}):r?(this._active=!0,e.preventDefault(),setTimeout((()=>this.reset()),0),{cameraAnimation:t=>t.easeTo({duration:300,zoom:t.getZoom()-1,around:t.unproject(r)},{originalEvent:e})}):void 0}touchcancel(){this.reset();}enable(){this._enabled=!0;}disable(){this._enabled=!1,this.reset();}isEnabled(){return this._enabled}isActive(){return this._active}}const $o={0:1,2:2};class Ho{constructor(e){this.reset(),this._clickTolerance=e.clickTolerance||1;}blur(){this.reset();}reset(){this._active=!1,this._moved=!1,delete this._lastPoint,delete this._eventButton;}_correctButton(e,t){return !1}_move(e,t){return {}}mousedown(e,t){if(this._lastPoint)return;const i=a.mouseButton(e);this._correctButton(e,i)&&(this._lastPoint=t,this._eventButton=i);}mousemoveWindow(e,t){const i=this._lastPoint;if(i)if(e.preventDefault(),function(e,t){const i=$o[t];return void 0===e.buttons||(e.buttons&i)!==i}(e,this._eventButton))this.reset();else if(this._moved||!(t.dist(i)<this._clickTolerance))return this._moved=!0,this._lastPoint=t,this._move(i,t)}mouseupWindow(e){this._lastPoint&&a.mouseButton(e)===this._eventButton&&(this._moved&&a.suppressClick(),this.reset());}enable(){this._enabled=!0;}disable(){this._enabled=!1,this.reset();}isEnabled(){return this._enabled}isActive(){return this._active}}class Ko extends Ho{mousedown(e,t){super.mousedown(e,t),this._lastPoint&&(this._active=!0);}_correctButton(e,t){return 0===t&&!e.ctrlKey}_move(e,t){return {around:t,panDelta:t.sub(e)}}}class Yo extends Ho{_correctButton(e,t){return 0===t&&e.ctrlKey||2===t}_move(e,t){const i=.8*(t.x-e.x);if(i)return this._active=!0,{bearingDelta:i}}contextmenu(e){e.preventDefault();}}class Jo extends Ho{_correctButton(e,t){return 0===t&&e.ctrlKey||2===t}_move(e,t){const i=-.5*(t.y-e.y);if(i)return this._active=!0,{pitchDelta:i}}contextmenu(e){e.preventDefault();}}class Qo{constructor(t,i){this._map=t,this._el=t.getCanvasContainer(),this._minTouches=1,this._clickTolerance=i.clickTolerance||1,this.reset(),e.bindAll(["_addTouchPanBlocker","_showTouchPanBlockerAlert"],this);}reset(){this._active=!1,this._touches={},this._sum=new e.pointGeometry(0,0);}touchstart(e,t,i){return this._calculateTransform(e,t,i)}touchmove(e,t,i){if(this._active&&!(i.length<this._minTouches)){if(this._map._cooperativeGestures&&!this._map.isMoving()){if(1===i.length)return void this._showTouchPanBlockerAlert();"hidden"!==this._alertContainer.style.visibility&&(this._alertContainer.style.visibility="hidden",clearTimeout(this._alertTimer));}return e.preventDefault(),this._calculateTransform(e,t,i)}}touchend(e,t,i){this._calculateTransform(e,t,i),this._active&&i.length<this._minTouches&&this.reset();}touchcancel(){this.reset();}_calculateTransform(t,i,o){o.length>0&&(this._active=!0);const r=Vo(o,i),n=new e.pointGeometry(0,0),a=new e.pointGeometry(0,0);let s=0;for(const e in r){const t=r[e],i=this._touches[e];i&&(n._add(t),a._add(t.sub(i)),s++,r[e]=t);}if(this._touches=r,s<this._minTouches||!a.mag())return;const l=a.div(s);return this._sum._add(l),this._sum.mag()<this._clickTolerance?void 0:{around:n.div(s),panDelta:l}}enable(){this._enabled=!0,this._map._cooperativeGestures&&(this._addTouchPanBlocker(),this._el.classList.add("mapboxgl-touch-pan-blocker-override","mapboxgl-scrollable-page"));}disable(){this._enabled=!1,this._map._cooperativeGestures&&(clearTimeout(this._alertTimer),this._alertContainer.remove(),this._el.classList.remove("mapboxgl-touch-pan-blocker-override","mapboxgl-scrollable-page")),this.reset();}isEnabled(){return this._enabled}isActive(){return this._active}_addTouchPanBlocker(){this._map&&!this._alertContainer&&(this._alertContainer=a.create("div","mapboxgl-touch-pan-blocker",this._map._container),this._alertContainer.textContent=this._map._getUIString("TouchPanBlocker.Message"),this._alertContainer.style.fontSize=`${Math.max(10,Math.min(24,Math.floor(.05*this._el.clientWidth)))}px`);}_showTouchPanBlockerAlert(){"hidden"===this._alertContainer.style.visibility&&(this._alertContainer.style.visibility="visible"),this._alertContainer.classList.add("mapboxgl-touch-pan-blocker-show"),clearTimeout(this._alertTimer),this._alertTimer=setTimeout((()=>{this._alertContainer.classList.remove("mapboxgl-touch-pan-blocker-show");}),500);}}class er{constructor(){this.reset();}reset(){this._active=!1,delete this._firstTwoTouches;}_start(e){}_move(e,t,i){return {}}touchstart(e,t,i){this._firstTwoTouches||i.length<2||(this._firstTwoTouches=[i[0].identifier,i[1].identifier],this._start([t[0],t[1]]));}touchmove(e,t,i){if(!this._firstTwoTouches)return;e.preventDefault();const[o,r]=this._firstTwoTouches,n=tr(i,t,o),a=tr(i,t,r);if(!n||!a)return;const s=this._aroundCenter?null:n.add(a).div(2);return this._move([n,a],s,e)}touchend(e,t,i){if(!this._firstTwoTouches)return;const[o,r]=this._firstTwoTouches,n=tr(i,t,o),s=tr(i,t,r);n&&s||(this._active&&a.suppressClick(),this.reset());}touchcancel(){this.reset();}enable(e){this._enabled=!0,this._aroundCenter=!!e&&"center"===e.around;}disable(){this._enabled=!1,this.reset();}isEnabled(){return this._enabled}isActive(){return this._active}}function tr(e,t,i){for(let o=0;o<e.length;o++)if(e[o].identifier===i)return t[o]}function ir(e,t){return Math.log(e/t)/Math.LN2}class or extends er{reset(){super.reset(),delete this._distance,delete this._startDistance;}_start(e){this._startDistance=this._distance=e[0].dist(e[1]);}_move(e,t){const i=this._distance;if(this._distance=e[0].dist(e[1]),this._active||!(Math.abs(ir(this._distance,this._startDistance))<.1))return this._active=!0,{zoomDelta:ir(this._distance,i),pinchAround:t}}}function rr(e,t){return 180*e.angleWith(t)/Math.PI}class nr extends er{reset(){super.reset(),delete this._minDiameter,delete this._startVector,delete this._vector;}_start(e){this._startVector=this._vector=e[0].sub(e[1]),this._minDiameter=e[0].dist(e[1]);}_move(e,t){const i=this._vector;if(this._vector=e[0].sub(e[1]),this._active||!this._isBelowThreshold(this._vector))return this._active=!0,{bearingDelta:rr(this._vector,i),pinchAround:t}}_isBelowThreshold(e){this._minDiameter=Math.min(this._minDiameter,e.mag());const t=25/(Math.PI*this._minDiameter)*360,i=rr(e,this._startVector);return Math.abs(i)<t}}function ar(e){return Math.abs(e.y)>Math.abs(e.x)}class sr extends er{constructor(e){super(),this._map=e;}reset(){super.reset(),this._valid=void 0,delete this._firstMove,delete this._lastPoints;}_start(e){this._lastPoints=e,ar(e[0].sub(e[1]))&&(this._valid=!1);}_move(e,t,i){const o=e[0].sub(this._lastPoints[0]),r=e[1].sub(this._lastPoints[1]);if(!(this._map._cooperativeGestures&&i.touches.length<3)&&(this._valid=this.gestureBeginsVertically(o,r,i.timeStamp),this._valid))return this._lastPoints=e,this._active=!0,{pitchDelta:(o.y+r.y)/2*-.5}}gestureBeginsVertically(e,t,i){if(void 0!==this._valid)return this._valid;const o=e.mag()>=2,r=t.mag()>=2;if(!o&&!r)return;if(!o||!r)return void 0===this._firstMove&&(this._firstMove=i),i-this._firstMove<100&&void 0;const n=e.y>0==t.y>0;return ar(e)&&ar(t)&&n}}const lr={panStep:100,bearingStep:15,pitchStep:10};class cr{constructor(){const e=lr;this._panStep=e.panStep,this._bearingStep=e.bearingStep,this._pitchStep=e.pitchStep,this._rotationDisabled=!1;}blur(){this.reset();}reset(){this._active=!1;}keydown(e){if(e.altKey||e.ctrlKey||e.metaKey)return;let t=0,i=0,o=0,r=0,n=0;switch(e.keyCode){case 61:case 107:case 171:case 187:t=1;break;case 189:case 109:case 173:t=-1;break;case 37:e.shiftKey?i=-1:(e.preventDefault(),r=-1);break;case 39:e.shiftKey?i=1:(e.preventDefault(),r=1);break;case 38:e.shiftKey?o=1:(e.preventDefault(),n=-1);break;case 40:e.shiftKey?o=-1:(e.preventDefault(),n=1);break;default:return}return this._rotationDisabled&&(i=0,o=0),{cameraAnimation:a=>{const s=a.getZoom();a.easeTo({duration:300,easeId:"keyboardHandler",easing:hr,zoom:t?Math.round(s)+t*(e.shiftKey?2:1):s,bearing:a.getBearing()+i*this._bearingStep,pitch:a.getPitch()+o*this._pitchStep,offset:[-r*this._panStep,-n*this._panStep],center:a.getCenter()},{originalEvent:e});}}}enable(){this._enabled=!0;}disable(){this._enabled=!1,this.reset();}isEnabled(){return this._enabled}isActive(){return this._active}disableRotation(){this._rotationDisabled=!0;}enableRotation(){this._rotationDisabled=!1;}}function hr(e){return e*(2-e)}const ur=4.000244140625;class _r{constructor(t,i){this._map=t,this._el=t.getCanvasContainer(),this._handler=i,this._delta=0,this._defaultZoomRate=.01,this._wheelZoomRate=.0022222222222222222,e.bindAll(["_onTimeout","_addScrollZoomBlocker","_showBlockerAlert","_isFullscreen"],this);}setZoomRate(e){this._defaultZoomRate=e;}setWheelZoomRate(e){this._wheelZoomRate=e;}isEnabled(){return !!this._enabled}isActive(){return !!this._active||void 0!==this._finishTimeout}isZooming(){return !!this._zooming}enable(e){this.isEnabled()||(this._enabled=!0,this._aroundCenter=!!e&&"center"===e.around,this._map._cooperativeGestures&&this._addScrollZoomBlocker());}disable(){this.isEnabled()&&(this._enabled=!1,this._map._cooperativeGestures&&(clearTimeout(this._alertTimer),this._alertContainer.remove()));}wheel(t){if(!this.isEnabled())return;if(this._map._cooperativeGestures){if(!(t.ctrlKey||t.metaKey||this.isZooming()||this._isFullscreen()))return void this._showBlockerAlert();"hidden"!==this._alertContainer.style.visibility&&(this._alertContainer.style.visibility="hidden",clearTimeout(this._alertTimer));}let i=t.deltaMode===e.window.WheelEvent.DOM_DELTA_LINE?40*t.deltaY:t.deltaY;const o=e.exported.now(),r=o-(this._lastWheelEventTime||0);this._lastWheelEventTime=o,0!==i&&i%ur==0?this._type="wheel":0!==i&&Math.abs(i)<4?this._type="trackpad":r>400?(this._type=null,this._lastValue=i,this._timeout=setTimeout(this._onTimeout,40,t)):this._type||(this._type=Math.abs(r*i)<200?"trackpad":"wheel",this._timeout&&(clearTimeout(this._timeout),this._timeout=null,i+=this._lastValue)),t.shiftKey&&i&&(i/=4),this._type&&(this._lastWheelEvent=t,this._delta-=i,this._active||this._start(t)),t.preventDefault();}_onTimeout(e){this._type="wheel",this._delta-=this._lastValue,this._active||this._start(e);}_start(e){if(!this._delta)return;this._frameId&&(this._frameId=null),this._active=!0,this.isZooming()||(this._zooming=!0),this._finishTimeout&&(clearTimeout(this._finishTimeout),delete this._finishTimeout);const t=a.mousePos(this._el,e);this._aroundPoint=this._aroundCenter?this._map.transform.centerPoint:t,this._aroundCoord=this._map.transform.pointCoordinate3D(this._aroundPoint),this._targetZoom=void 0,this._frameId||(this._frameId=!0,this._handler._triggerRenderFrame());}renderFrame(){if(!this._frameId)return;if(this._frameId=null,!this.isActive())return;const t=this._map.transform,i=()=>t._terrainEnabled()&&this._aroundCoord?t.computeZoomRelativeTo(this._aroundCoord):t.zoom;if(0!==this._delta){const e="wheel"===this._type&&Math.abs(this._delta)>ur?this._wheelZoomRate:this._defaultZoomRate;let o=2/(1+Math.exp(-Math.abs(this._delta*e)));this._delta<0&&0!==o&&(o=1/o);const r=i(),n=Math.pow(2,r),a="number"==typeof this._targetZoom?t.zoomScale(this._targetZoom):n;this._targetZoom=Math.min(t.maxZoom,Math.max(t.minZoom,t.scaleZoom(a*o))),"wheel"===this._type&&(this._startZoom=i(),this._easing=this._smoothOutEasing(200)),this._delta=0;}const o="number"==typeof this._targetZoom?this._targetZoom:i(),r=this._startZoom,n=this._easing;let a,s=!1;if("wheel"===this._type&&r&&n){const t=Math.min((e.exported.now()-this._lastWheelEventTime)/200,1),i=n(t);a=e.number(r,o,i),t<1?this._frameId||(this._frameId=!0):s=!0;}else a=o,s=!0;return this._active=!0,s&&(this._active=!1,this._finishTimeout=setTimeout((()=>{this._zooming=!1,this._handler._triggerRenderFrame(),delete this._targetZoom,delete this._finishTimeout;}),200)),{noInertia:!0,needsRenderFrame:!s,zoomDelta:a-i(),around:this._aroundPoint,aroundCoord:this._aroundCoord,originalEvent:this._lastWheelEvent}}_smoothOutEasing(t){let i=e.ease;if(this._prevEase){const t=this._prevEase,o=(e.exported.now()-t.start)/t.duration,r=t.easing(o+.01)-t.easing(o),n=.27/Math.sqrt(r*r+1e-4)*.01,a=Math.sqrt(.0729-n*n);i=e.bezier(n,a,.25,1);}return this._prevEase={start:e.exported.now(),duration:t,easing:i},i}blur(){this.reset();}reset(){this._active=!1;}_addScrollZoomBlocker(){this._map&&!this._alertContainer&&(this._alertContainer=a.create("div","mapboxgl-scroll-zoom-blocker",this._map._container),this._alertContainer.textContent=/(Mac|iPad)/i.test(e.window.navigator.userAgent)?this._map._getUIString("ScrollZoomBlocker.CmdMessage"):this._map._getUIString("ScrollZoomBlocker.CtrlMessage"),this._alertContainer.style.fontSize=`${Math.max(10,Math.min(24,Math.floor(.05*this._el.clientWidth)))}px`);}_isFullscreen(){return !!e.window.document.fullscreenElement}_showBlockerAlert(){"hidden"===this._alertContainer.style.visibility&&(this._alertContainer.style.visibility="visible"),this._alertContainer.classList.add("mapboxgl-scroll-zoom-blocker-show"),clearTimeout(this._alertTimer),this._alertTimer=setTimeout((()=>{this._alertContainer.classList.remove("mapboxgl-scroll-zoom-blocker-show");}),200);}}class dr{constructor(e,t){this._clickZoom=e,this._tapZoom=t;}enable(){this._clickZoom.enable(),this._tapZoom.enable();}disable(){this._clickZoom.disable(),this._tapZoom.disable();}isEnabled(){return this._clickZoom.isEnabled()&&this._tapZoom.isEnabled()}isActive(){return this._clickZoom.isActive()||this._tapZoom.isActive()}}class pr{constructor(){this.reset();}reset(){this._active=!1;}blur(){this.reset();}dblclick(e,t){return e.preventDefault(),{cameraAnimation:i=>{i.easeTo({duration:300,zoom:i.getZoom()+(e.shiftKey?-1:1),around:i.unproject(t)},{originalEvent:e});}}}enable(){this._enabled=!0;}disable(){this._enabled=!1,this.reset();}isEnabled(){return this._enabled}isActive(){return this._active}}class mr{constructor(){this._tap=new qo({numTouches:1,numTaps:1}),this.reset();}reset(){this._active=!1,delete this._swipePoint,delete this._swipeTouch,delete this._tapTime,this._tap.reset();}touchstart(e,t,i){this._swipePoint||(this._tapTime&&e.timeStamp-this._tapTime>500&&this.reset(),this._tapTime?i.length>0&&(this._swipePoint=t[0],this._swipeTouch=i[0].identifier):this._tap.touchstart(e,t,i));}touchmove(e,t,i){if(this._tapTime){if(this._swipePoint){if(i[0].identifier!==this._swipeTouch)return;const o=t[0],r=o.y-this._swipePoint.y;return this._swipePoint=o,e.preventDefault(),this._active=!0,{zoomDelta:r/128}}}else this._tap.touchmove(e,t,i);}touchend(e,t,i){this._tapTime?this._swipePoint&&0===i.length&&this.reset():this._tap.touchend(e,t,i)&&(this._tapTime=e.timeStamp);}touchcancel(){this.reset();}enable(){this._enabled=!0;}disable(){this._enabled=!1,this.reset();}isEnabled(){return this._enabled}isActive(){return this._active}}class fr{constructor(e,t,i){this._el=e,this._mousePan=t,this._touchPan=i;}enable(e){this._inertiaOptions=e||{},this._mousePan.enable(),this._touchPan.enable(),this._el.classList.add("mapboxgl-touch-drag-pan");}disable(){this._mousePan.disable(),this._touchPan.disable(),this._el.classList.remove("mapboxgl-touch-drag-pan");}isEnabled(){return this._mousePan.isEnabled()&&this._touchPan.isEnabled()}isActive(){return this._mousePan.isActive()||this._touchPan.isActive()}}class gr{constructor(e,t,i){this._pitchWithRotate=e.pitchWithRotate,this._mouseRotate=t,this._mousePitch=i;}enable(){this._mouseRotate.enable(),this._pitchWithRotate&&this._mousePitch.enable();}disable(){this._mouseRotate.disable(),this._mousePitch.disable();}isEnabled(){return this._mouseRotate.isEnabled()&&(!this._pitchWithRotate||this._mousePitch.isEnabled())}isActive(){return this._mouseRotate.isActive()||this._mousePitch.isActive()}}class vr{constructor(e,t,i,o){this._el=e,this._touchZoom=t,this._touchRotate=i,this._tapDragZoom=o,this._rotationDisabled=!1,this._enabled=!0;}enable(e){this._touchZoom.enable(e),this._rotationDisabled||this._touchRotate.enable(e),this._tapDragZoom.enable(),this._el.classList.add("mapboxgl-touch-zoom-rotate");}disable(){this._touchZoom.disable(),this._touchRotate.disable(),this._tapDragZoom.disable(),this._el.classList.remove("mapboxgl-touch-zoom-rotate");}isEnabled(){return this._touchZoom.isEnabled()&&(this._rotationDisabled||this._touchRotate.isEnabled())&&this._tapDragZoom.isEnabled()}isActive(){return this._touchZoom.isActive()||this._touchRotate.isActive()||this._tapDragZoom.isActive()}disableRotation(){this._rotationDisabled=!0,this._touchRotate.disable();}enableRotation(){this._rotationDisabled=!1,this._touchZoom.isEnabled()&&this._touchRotate.enable();}}const xr=e=>e.zoom||e.drag||e.pitch||e.rotate;class yr extends e.Event{}class br{constructor(){this.constants=[1,1,.01],this.radius=0;}setup(t,i){const o=e.sub([],i,t);this.radius=e.length(o[2]<0?e.div([],o,this.constants):[o[0],o[1],0]);}projectRay(t){e.div(t,t,this.constants),e.normalize(t,t),e.mul$1(t,t,this.constants);const i=e.scale$2([],t,this.radius);if(i[2]>0){const t=e.scale$2([],[0,0,1],e.dot(i,[0,0,1])),o=e.scale$2([],e.normalize([],[i[0],i[1],0]),this.radius),r=e.add([],i,e.scale$2([],e.sub([],e.add([],o,t),i),2));i[0]=r[0],i[1]=r[1];}return i}}function wr(e){return e.panDelta&&e.panDelta.mag()||e.zoomDelta||e.bearingDelta||e.pitchDelta}class Tr{constructor(t,i){this._map=t,this._el=this._map.getCanvasContainer(),this._handlers=[],this._handlersById={},this._changes=[],this._inertia=new ko(t),this._bearingSnap=i.bearingSnap,this._previousActiveHandlers={},this._trackingEllipsoid=new br,this._dragOrigin=null,this._eventsInProgress={},this._addDefaultHandlers(i),e.bindAll(["handleEvent","handleWindowEvent"],this);const o=this._el;this._listeners=[[o,"touchstart",{passive:!0}],[o,"touchmove",{passive:!1}],[o,"touchend",void 0],[o,"touchcancel",void 0],[o,"mousedown",void 0],[o,"mousemove",void 0],[o,"mouseup",void 0],[e.window.document,"mousemove",{capture:!0}],[e.window.document,"mouseup",void 0],[o,"mouseover",void 0],[o,"mouseout",void 0],[o,"dblclick",void 0],[o,"click",void 0],[o,"keydown",{capture:!1}],[o,"keyup",void 0],[o,"wheel",{passive:!1}],[o,"contextmenu",void 0],[e.window,"blur",void 0]];for(const[t,i,o]of this._listeners)t.addEventListener(i,t===e.window.document?this.handleWindowEvent:this.handleEvent,o);}destroy(){for(const[t,i,o]of this._listeners)t.removeEventListener(i,t===e.window.document?this.handleWindowEvent:this.handleEvent,o);}_addDefaultHandlers(e){const t=this._map,i=t.getCanvasContainer();this._add("mapEvent",new Go(t,e));const o=t.boxZoom=new Zo(t,e);this._add("boxZoom",o);const r=new Xo,n=new pr;t.doubleClickZoom=new dr(n,r),this._add("tapZoom",r),this._add("clickZoom",n);const a=new mr;this._add("tapDragZoom",a);const s=t.touchPitch=new sr(t);this._add("touchPitch",s);const l=new Yo(e),c=new Jo(e);t.dragRotate=new gr(e,l,c),this._add("mouseRotate",l,["mousePitch"]),this._add("mousePitch",c,["mouseRotate"]);const h=new Ko(e),u=new Qo(t,e);t.dragPan=new fr(i,h,u),this._add("mousePan",h),this._add("touchPan",u,["touchZoom","touchRotate"]);const _=new nr,d=new or;t.touchZoomRotate=new vr(i,d,_,a),this._add("touchRotate",_,["touchPan","touchZoom"]),this._add("touchZoom",d,["touchPan","touchRotate"]),this._add("blockableMapEvent",new jo(t));const p=t.scrollZoom=new _r(t,this);this._add("scrollZoom",p,["mousePan"]);const m=t.keyboard=new cr;this._add("keyboard",m);for(const i of ["boxZoom","doubleClickZoom","tapDragZoom","touchPitch","dragRotate","dragPan","touchZoomRotate","scrollZoom","keyboard"])e.interactive&&e[i]&&t[i].enable(e[i]);}_add(e,t,i){this._handlers.push({handlerName:e,handler:t,allowed:i}),this._handlersById[e]=t;}stop(e){if(!this._updatingCamera){for(const{handler:e}of this._handlers)e.reset();this._inertia.clear(),this._fireEvents({},{},e),this._changes=[];}}isActive(){for(const{handler:e}of this._handlers)if(e.isActive())return !0;return !1}isZooming(){return !!this._eventsInProgress.zoom||this._map.scrollZoom.isZooming()}isRotating(){return !!this._eventsInProgress.rotate}isMoving(){return Boolean(xr(this._eventsInProgress))||this.isZooming()}_blockedByActive(e,t,i){for(const o in e)if(o!==i&&(!t||t.indexOf(o)<0))return !0;return !1}handleWindowEvent(e){this.handleEvent(e,`${e.type}Window`);}_getMapTouches(e){const t=[];for(const i of e)this._el.contains(i.target)&&t.push(i);return t}handleEvent(e,t){this._updatingCamera=!0;const i="renderFrame"===e.type,o=i?void 0:e,r={needsRenderFrame:!1},n={},s={},l=e.touches?this._getMapTouches(e.touches):void 0,c=l?a.touchPos(this._el,l):i?void 0:a.mousePos(this._el,e);for(const{handlerName:i,handler:a,allowed:h}of this._handlers){if(!a.isEnabled())continue;let u;this._blockedByActive(s,h,i)?a.reset():a[t||e.type]&&(u=a[t||e.type](e,c,l),this.mergeHandlerResult(r,n,u,i,o),u&&u.needsRenderFrame&&this._triggerRenderFrame()),(u||a.isActive())&&(s[i]=a);}const h={};for(const e in this._previousActiveHandlers)s[e]||(h[e]=o);this._previousActiveHandlers=s,(Object.keys(h).length||wr(r))&&(this._changes.push([r,n,h]),this._triggerRenderFrame()),(Object.keys(s).length||wr(r))&&this._map._stop(!0),this._updatingCamera=!1;const{cameraAnimation:u}=r;u&&(this._inertia.clear(),this._fireEvents({},{},!0),this._changes=[],u(this._map));}mergeHandlerResult(t,i,o,r,n){if(!o)return;e.extend(t,o);const a={handlerName:r,originalEvent:o.originalEvent||n};void 0!==o.zoomDelta&&(i.zoom=a),void 0!==o.panDelta&&(i.drag=a),void 0!==o.pitchDelta&&(i.pitch=a),void 0!==o.bearingDelta&&(i.rotate=a);}_applyChanges(){const t={},i={},o={};for(const[r,n,a]of this._changes)r.panDelta&&(t.panDelta=(t.panDelta||new e.pointGeometry(0,0))._add(r.panDelta)),r.zoomDelta&&(t.zoomDelta=(t.zoomDelta||0)+r.zoomDelta),r.bearingDelta&&(t.bearingDelta=(t.bearingDelta||0)+r.bearingDelta),r.pitchDelta&&(t.pitchDelta=(t.pitchDelta||0)+r.pitchDelta),void 0!==r.around&&(t.around=r.around),void 0!==r.aroundCoord&&(t.aroundCoord=r.aroundCoord),void 0!==r.pinchAround&&(t.pinchAround=r.pinchAround),r.noInertia&&(t.noInertia=r.noInertia),e.extend(i,n),e.extend(o,a);this._updateMapTransform(t,i,o),this._changes=[];}_updateMapTransform(t,i,o){const r=this._map,n=r.transform,a=e=>[e.x,e.y,e.z];if((e=>{const t=this._eventsInProgress.drag;return t&&!this._handlersById[t.handlerName].isActive()})()&&!wr(t)){const e=n.zoom;n.cameraElevationReference="sea",n.recenterOnTerrain(),n.cameraElevationReference="ground",e!==n.zoom&&this._map._update(!0);}if(!wr(t))return this._fireEvents(i,o,!0);let{panDelta:s,zoomDelta:l,bearingDelta:c,pitchDelta:h,around:u,aroundCoord:_,pinchAround:d}=t;void 0!==d&&(u=d),(e=>i.drag&&!this._eventsInProgress.drag)()&&u&&(this._dragOrigin=a(n.pointCoordinate3D(u)),this._trackingEllipsoid.setup(n._camera.position,this._dragOrigin)),n.cameraElevationReference="sea",r._stop(!0),u=u||r.transform.centerPoint,c&&(n.bearing+=c),h&&(n.pitch+=h),n._updateCameraState();const p=[0,0,0];if(s){const e=n.pointCoordinate(u),t=n.pointCoordinate(u.sub(s));e&&t&&(p[0]=t.x-e.x,p[1]=t.y-e.y);}const m=n.zoom,f=[0,0,0];if(l){const t=a(_||n.pointCoordinate3D(u)),i={dir:e.normalize([],e.sub([],t,n._camera.position))};if(i.dir[2]<0){const o=n.zoomDeltaToMovement(t,l);e.scale$2(f,i.dir,o);}}const g=e.add(p,p,f);n._translateCameraConstrained(g),l&&Math.abs(n.zoom-m)>1e-4&&n.recenterOnTerrain(),n.cameraElevationReference="ground",this._map._update(),t.noInertia||this._inertia.record(t),this._fireEvents(i,o,!0);}_fireEvents(t,i,o){const r=xr(this._eventsInProgress),n=xr(t),a={};for(const e in t){const{originalEvent:i}=t[e];this._eventsInProgress[e]||(a[`${e}start`]=i),this._eventsInProgress[e]=t[e];}!r&&n&&this._fireEvent("movestart",n.originalEvent);for(const e in a)this._fireEvent(e,a[e]);n&&this._fireEvent("move",n.originalEvent);for(const e in t){const{originalEvent:i}=t[e];this._fireEvent(e,i);}const s={};let l;for(const e in this._eventsInProgress){const{handlerName:t,originalEvent:o}=this._eventsInProgress[e];this._handlersById[t].isActive()||(delete this._eventsInProgress[e],l=i[t]||o,s[`${e}end`]=l);}for(const e in s)this._fireEvent(e,s[e]);const c=xr(this._eventsInProgress);if(o&&(r||n)&&!c){this._updatingCamera=!0;const t=this._inertia._onMoveEnd(this._map.dragPan._inertiaOptions),i=e=>0!==e&&-this._bearingSnap<e&&e<this._bearingSnap;t?(i(t.bearing||this._map.getBearing())&&(t.bearing=0),this._map.easeTo(t,{originalEvent:l})):(this._map.fire(new e.Event("moveend",{originalEvent:l})),i(this._map.getBearing())&&this._map.resetNorth()),this._updatingCamera=!1;}}_fireEvent(t,i){this._map.fire(new e.Event(t,i?{originalEvent:i}:{}));}_requestFrame(){return this._map.triggerRepaint(),this._map._renderTaskQueue.add((e=>{delete this._frameId,this.handleEvent(new yr("renderFrame",{timeStamp:e})),this._applyChanges();}))}_triggerRenderFrame(){void 0===this._frameId&&(this._frameId=this._requestFrame());}}const Er="map.setFreeCameraOptions(...) and map.getFreeCameraOptions() are not yet supported for non-mercator projections.";class Cr extends e.Evented{constructor(t,i){super(),this._moving=!1,this._zooming=!1,this.transform=t,this._bearingSnap=i.bearingSnap,e.bindAll(["_renderFrameCallback"],this);}getCenter(){return new e.LngLat(this.transform.center.lng,this.transform.center.lat)}setCenter(e,t){return this.jumpTo({center:e},t)}panBy(t,i,o){return t=e.pointGeometry.convert(t).mult(-1),this.panTo(this.transform.center,e.extend({offset:t},i),o)}panTo(t,i,o){return this.easeTo(e.extend({center:t},i),o)}getZoom(){return this.transform.zoom}setZoom(e,t){return this.jumpTo({zoom:e},t),this}zoomTo(t,i,o){return this.easeTo(e.extend({zoom:t},i),o)}zoomIn(e,t){return this.zoomTo(this.getZoom()+1,e,t),this}zoomOut(e,t){return this.zoomTo(this.getZoom()-1,e,t),this}getBearing(){return this.transform.bearing}setBearing(e,t){return this.jumpTo({bearing:e},t),this}getPadding(){return this.transform.padding}setPadding(e,t){return this.jumpTo({padding:e},t),this}rotateTo(t,i,o){return this.easeTo(e.extend({bearing:t},i),o)}resetNorth(t,i){return this.rotateTo(0,e.extend({duration:1e3},t),i),this}resetNorthPitch(t,i){return this.easeTo(e.extend({bearing:0,pitch:0,duration:1e3},t),i),this}snapToNorth(e,t){return Math.abs(this.getBearing())<this._bearingSnap?this.resetNorth(e,t):this}getPitch(){return this.transform.pitch}setPitch(e,t){return this.jumpTo({pitch:e},t),this}cameraForBounds(t,i){t=e.LngLatBounds.convert(t);const o=i&&i.bearing||0;return this._cameraForBoxAndBearing(t.getNorthWest(),t.getSouthEast(),o,i)}_extendCameraOptions(t){const i={top:0,bottom:0,right:0,left:0};if("number"==typeof(t=e.extend({padding:i,offset:[0,0],maxZoom:this.transform.maxZoom},t)).padding){const e=t.padding;t.padding={top:e,bottom:e,right:e,left:e};}return t.padding=e.extend(i,t.padding),t}_cameraForBoxAndBearing(t,i,o,r){const n=this._extendCameraOptions(r),a=this.transform,s=a.padding,l=a.project(e.LngLat.convert(t)),c=a.project(e.LngLat.convert(i)),h=l.rotate(-e.degToRad(o)),u=c.rotate(-e.degToRad(o)),_=new e.pointGeometry(Math.max(h.x,u.x),Math.max(h.y,u.y)),d=new e.pointGeometry(Math.min(h.x,u.x),Math.min(h.y,u.y)),p=_.sub(d),m=(a.width-(s.left+s.right+n.padding.left+n.padding.right))/p.x,f=(a.height-(s.top+s.bottom+n.padding.top+n.padding.bottom))/p.y;if(f<0||m<0)return void e.warnOnce("Map cannot fit within canvas with the given bounds, padding, and/or offset.");const g=Math.min(a.scaleZoom(a.scale*Math.min(m,f)),n.maxZoom),v="number"==typeof n.offset.x?new e.pointGeometry(n.offset.x,n.offset.y):e.pointGeometry.convert(n.offset),x=new e.pointGeometry((n.padding.left-n.padding.right)/2,(n.padding.top-n.padding.bottom)/2).rotate(o*Math.PI/180),y=v.add(x).mult(a.scale/a.zoomScale(g));return {center:a.unproject(l.add(c).div(2).sub(y)),zoom:g,bearing:o}}_cameraForBox(t,i,o,r,n){const a=this._extendCameraOptions(n);o=o||0,r=r||0,t=e.LngLat.convert(t),i=e.LngLat.convert(i);const s=this.transform.clone();s.padding=a.padding;const l=this.getFreeCameraOptions(),c=new e.LngLat(.5*(t.lng+i.lng),.5*(t.lat+i.lat)),h=.5*(o+r);if(s._camera.position[2]<e.mercatorZfromAltitude(h,c.lat))return void e.warnOnce("Map cannot fit within canvas with the given bounds, padding, and/or offset.");l.lookAtPoint(c),s.setFreeCameraOptions(l);const u=e.MercatorCoordinate.fromLngLat(t),_=e.MercatorCoordinate.fromLngLat(i),d=s.pointRayIntersection(s.centerPoint,h),p=[(m=s.rayIntersectionCoordinate(d)).x,m.y,m.z];var m;const f=s.screenPointToMercatorRay(s.centerPoint),g="globe"!==s.projection.name;let v,x=0;do{const t=Math.floor(s.zoom),i=1<<t,n=Math.min(i*u.x,i*_.x),a=Math.min(i*u.y,i*_.y),l=Math.max(i*u.x,i*_.x),c=Math.max(i*u.y,i*_.y),h=new e.Aabb([n,a,o],[l,c,r]),d=e.Frustum.fromInvProjectionMatrix(s.invProjMatrix,s.worldSize,t,g);if(2!==h.intersects(d)){v&&(s._camera.position=e.scaleAndAdd([],s._camera.position,f.dir,-v),s._updateStateFromCamera());break}const m=e.sub([],s._camera.position,p);v=.5*e.length(m),s._camera.position=e.scaleAndAdd([],s._camera.position,f.dir,v);try{s._updateStateFromCamera();}catch(t){return void e.warnOnce("Map cannot fit within canvas with the given bounds, padding, and/or offset.")}}while(++x<10);return {center:s.center,zoom:s.zoom,bearing:s.bearing,pitch:s.pitch}}fitBounds(e,t,i){return this._fitInternal(this.cameraForBounds(e,t),t,i)}_raycastElevationBox(t,i){const o=this.transform.elevation;if(!o)return;const r=new e.pointGeometry(t.x,i.y),n=new e.pointGeometry(i.x,t.y),a=o.pointCoordinate(t);if(!a)return;const s=o.pointCoordinate(i);if(!s)return;const l=o.pointCoordinate(r);if(!l)return;const c=o.pointCoordinate(n);if(!c)return;const h=new e.MercatorCoordinate(a[0],a[1]).toLngLat(),u=new e.MercatorCoordinate(s[0],s[1]).toLngLat(),_=new e.MercatorCoordinate(l[0],l[1]).toLngLat(),d=new e.MercatorCoordinate(c[0],c[1]).toLngLat(),p=Math.min(h.lng,Math.min(u.lng,Math.min(_.lng,d.lng))),m=Math.min(h.lat,Math.min(u.lat,Math.min(_.lat,d.lat))),f=Math.max(h.lng,Math.max(u.lng,Math.max(_.lng,d.lng))),g=Math.max(h.lat,Math.max(u.lat,Math.max(_.lat,d.lat))),v=Math.min(a[3],Math.min(s[3],Math.min(l[3],c[3]))),x=Math.max(a[3],Math.max(s[3],Math.max(l[3],c[3])));return {minLngLat:new e.LngLat(p,m),maxLngLat:new e.LngLat(f,g),minAltitude:v,maxAltitude:x}}fitScreenCoordinates(t,i,o,r,n){let a,s,l,c;const h=e.pointGeometry.convert(t),u=e.pointGeometry.convert(i),_=this._raycastElevationBox(h,u);if(_)a=_.minLngLat,s=_.maxLngLat,l=_.minAltitude,c=_.maxAltitude;else {if(this.transform.anyCornerOffEdge(h,u))return this;a=this.transform.pointLocation(h),s=this.transform.pointLocation(u);}return this._fitInternal(0===this.transform.pitch?this._cameraForBoxAndBearing(this.transform.pointLocation(e.pointGeometry.convert(t)),this.transform.pointLocation(e.pointGeometry.convert(i)),o,r):this._cameraForBox(a,s,l,c,r),r,n)}_fitInternal(t,i,o){return t?(delete(i=e.extend(t,i)).padding,i.linear?this.easeTo(i,o):this.flyTo(i,o)):this}jumpTo(t,i){this.stop();const o=t.preloadOnly?this.transform.clone():this.transform;let r=!1,n=!1,a=!1;return "zoom"in t&&o.zoom!==+t.zoom&&(r=!0,o.zoom=+t.zoom),void 0!==t.center&&(o.center=e.LngLat.convert(t.center)),"bearing"in t&&o.bearing!==+t.bearing&&(n=!0,o.bearing=+t.bearing),"pitch"in t&&o.pitch!==+t.pitch&&(a=!0,o.pitch=+t.pitch),null==t.padding||o.isPaddingEqual(t.padding)||(o.padding=t.padding),t.preloadOnly?(this._preloadTiles(o),this):(this.fire(new e.Event("movestart",i)).fire(new e.Event("move",i)),r&&this.fire(new e.Event("zoomstart",i)).fire(new e.Event("zoom",i)).fire(new e.Event("zoomend",i)),n&&this.fire(new e.Event("rotatestart",i)).fire(new e.Event("rotate",i)).fire(new e.Event("rotateend",i)),a&&this.fire(new e.Event("pitchstart",i)).fire(new e.Event("pitch",i)).fire(new e.Event("pitchend",i)),this.fire(new e.Event("moveend",i)))}getFreeCameraOptions(){return this.transform.projection.supportsFreeCamera||e.warnOnce(Er),this.transform.getFreeCameraOptions()}setFreeCameraOptions(t,i){const o=this.transform;if(!o.projection.supportsFreeCamera)return void e.warnOnce(Er);this.stop();const r=o.zoom,n=o.pitch,a=o.bearing;o.setFreeCameraOptions(t);const s=r!==o.zoom,l=n!==o.pitch,c=a!==o.bearing;return this.fire(new e.Event("movestart",i)).fire(new e.Event("move",i)),s&&this.fire(new e.Event("zoomstart",i)).fire(new e.Event("zoom",i)).fire(new e.Event("zoomend",i)),c&&this.fire(new e.Event("rotatestart",i)).fire(new e.Event("rotate",i)).fire(new e.Event("rotateend",i)),l&&this.fire(new e.Event("pitchstart",i)).fire(new e.Event("pitch",i)).fire(new e.Event("pitchend",i)),this.fire(new e.Event("moveend",i)),this}easeTo(t,i){this._stop(!1,t.easeId),(!1===(t=e.extend({offset:[0,0],duration:500,easing:e.ease},t)).animate||!t.essential&&e.exported.prefersReducedMotion)&&(t.duration=0);const o=this.transform,r=this.getZoom(),n=this.getBearing(),a=this.getPitch(),s=this.getPadding(),l="zoom"in t?+t.zoom:r,c="bearing"in t?this._normalizeBearing(t.bearing,n):n,h="pitch"in t?+t.pitch:a,u="padding"in t?t.padding:o.padding,_=e.pointGeometry.convert(t.offset);let d=o.centerPoint.add(_);const p="globe"===o.projection.name?o.pointCoordinate(d).toLngLat():o.pointLocation(d),m=e.LngLat.convert(t.center||p);this._normalizeCenter(m);const f=o.project(p),g=o.project(m).sub(f),v=o.zoomScale(l-r);let x,y;t.around&&(x=e.LngLat.convert(t.around),y=o.locationPoint(x));const b=this._zooming||l!==r,w=this._rotating||n!==c,T=this._pitching||h!==a,E=!o.isPaddingEqual(u),C=o=>p=>{if(b&&(o.zoom=e.number(r,l,p)),w&&(o.bearing=e.number(n,c,p)),T&&(o.pitch=e.number(a,h,p)),E&&(o.interpolatePadding(s,u,p),d=o.centerPoint.add(_)),x)o.setLocationAtPoint(x,y);else {const e=o.zoomScale(o.zoom-r),t=l>r?Math.min(2,v):Math.max(.5,v),i=Math.pow(t,1-p),n=o.unproject(f.add(g.mult(p*i)).mult(e));o.setLocationAtPoint(o.renderWorldCopies?n.wrap():n,d);}return t.preloadOnly||this._fireMoveEvents(i),o};if(t.preloadOnly){const e=this._emulate(C,t.duration,o);return this._preloadTiles(e),this}const M={moving:this._moving,zooming:this._zooming,rotating:this._rotating,pitching:this._pitching};return this._zooming=b,this._rotating=w,this._pitching=T,this._padding=E,this._easeId=t.easeId,this._prepareEase(i,t.noMoveStart,M),this._ease(C(o),(e=>{o.recenterOnTerrain(),this._afterEase(i,e);}),t),this}_prepareEase(t,i,o={}){this._moving=!0,this.transform.cameraElevationReference="sea",i||o.moving||this.fire(new e.Event("movestart",t)),this._zooming&&!o.zooming&&this.fire(new e.Event("zoomstart",t)),this._rotating&&!o.rotating&&this.fire(new e.Event("rotatestart",t)),this._pitching&&!o.pitching&&this.fire(new e.Event("pitchstart",t));}_fireMoveEvents(t){this.fire(new e.Event("move",t)),this._zooming&&this.fire(new e.Event("zoom",t)),this._rotating&&this.fire(new e.Event("rotate",t)),this._pitching&&this.fire(new e.Event("pitch",t));}_afterEase(t,i){if(this._easeId&&i&&this._easeId===i)return;delete this._easeId,this.transform.cameraElevationReference="ground";const o=this._zooming,r=this._rotating,n=this._pitching;this._moving=!1,this._zooming=!1,this._rotating=!1,this._pitching=!1,this._padding=!1,o&&this.fire(new e.Event("zoomend",t)),r&&this.fire(new e.Event("rotateend",t)),n&&this.fire(new e.Event("pitchend",t)),this.fire(new e.Event("moveend",t));}flyTo(t,i){if(!t.essential&&e.exported.prefersReducedMotion){const o=e.pick(t,["center","zoom","bearing","pitch","around"]);return this.jumpTo(o,i)}this.stop(),t=e.extend({offset:[0,0],speed:1.2,curve:1.42,easing:e.ease},t);const o=this.transform,r=this.getZoom(),n=this.getBearing(),a=this.getPitch(),s=this.getPadding(),l="zoom"in t?e.clamp(+t.zoom,o.minZoom,o.maxZoom):r,c="bearing"in t?this._normalizeBearing(t.bearing,n):n,h="pitch"in t?+t.pitch:a,u="padding"in t?t.padding:o.padding,_=o.zoomScale(l-r),d=e.pointGeometry.convert(t.offset);let p=o.centerPoint.add(d);const m=o.pointLocation(p),f=e.LngLat.convert(t.center||m);this._normalizeCenter(f);const g=o.project(m),v=o.project(f).sub(g);let x=t.curve;const y=Math.max(o.width,o.height),b=y/_,w=v.mag();if("minZoom"in t){const i=e.clamp(Math.min(t.minZoom,r,l),o.minZoom,o.maxZoom),n=y/o.zoomScale(i-r);x=Math.sqrt(n/w*2);}const T=x*x;function E(e){const t=(b*b-y*y+(e?-1:1)*T*T*w*w)/(2*(e?b:y)*T*w);return Math.log(Math.sqrt(t*t+1)-t)}function C(e){return (Math.exp(e)-Math.exp(-e))/2}function M(e){return (Math.exp(e)+Math.exp(-e))/2}const S=E(0);let I=function(e){return M(S)/M(S+x*e)},z=function(e){return y*((M(S)*(C(t=S+x*e)/M(t))-C(S))/T)/w;var t;},D=(E(1)-S)/x;if(Math.abs(w)<1e-6||!isFinite(D)){if(Math.abs(y-b)<1e-6)return this.easeTo(t,i);const e=b<y?-1:1;D=Math.abs(Math.log(b/y))/x,z=function(){return 0},I=function(t){return Math.exp(e*x*t)};}t.duration="duration"in t?+t.duration:1e3*D/("screenSpeed"in t?+t.screenSpeed/x:+t.speed),t.maxDuration&&t.duration>t.maxDuration&&(t.duration=0);const P=n!==c,A=h!==a,L=!o.isPaddingEqual(u),R=o=>_=>{const m=_*D,x=1/I(m);o.zoom=1===_?l:r+o.scaleZoom(x),P&&(o.bearing=e.number(n,c,_)),A&&(o.pitch=e.number(a,h,_)),L&&(o.interpolatePadding(s,u,_),p=o.centerPoint.add(d));const y=1===_?f:o.unproject(g.add(v.mult(z(m))).mult(x));return o.setLocationAtPoint(o.renderWorldCopies?y.wrap():y,p),o._updateCenterElevation(),t.preloadOnly||this._fireMoveEvents(i),o};if(t.preloadOnly){const e=this._emulate(R,t.duration,o);return this._preloadTiles(e),this}return this._zooming=!0,this._rotating=P,this._pitching=A,this._padding=L,this._prepareEase(i,!1),this._ease(R(o),(()=>this._afterEase(i)),t),this}isEasing(){return !!this._easeFrameId}stop(){return this._stop()}_stop(e,t){if(this._easeFrameId&&(this._cancelRenderFrame(this._easeFrameId),delete this._easeFrameId,delete this._onEaseFrame),this._onEaseEnd){const e=this._onEaseEnd;delete this._onEaseEnd,e.call(this,t);}if(!e){const e=this.handlers;e&&e.stop(!1);}return this}_ease(t,i,o){!1===o.animate||0===o.duration?(t(1),i()):(this._easeStart=e.exported.now(),this._easeOptions=o,this._onEaseFrame=t,this._onEaseEnd=i,this._easeFrameId=this._requestRenderFrame(this._renderFrameCallback));}_renderFrameCallback(){const t=Math.min((e.exported.now()-this._easeStart)/this._easeOptions.duration,1);this._onEaseFrame(this._easeOptions.easing(t)),t<1?this._easeFrameId=this._requestRenderFrame(this._renderFrameCallback):this.stop();}_normalizeBearing(t,i){t=e.wrap(t,-180,180);const o=Math.abs(t-i);return Math.abs(t-360-i)<o&&(t-=360),Math.abs(t+360-i)<o&&(t+=360),t}_normalizeCenter(e){const t=this.transform;if(!t.renderWorldCopies||t.maxBounds)return;const i=e.lng-t.center.lng;e.lng+=i>180?-360:i<-180?360:0;}_emulate(e,t,i){const o=Math.ceil(15*t/1e3),r=[],n=e(i.clone());for(let e=0;e<=o;e++){const t=n(e/o);r.push(t.clone());}return r}}class Mr{constructor(t={}){this.options=t,e.bindAll(["_toggleAttribution","_updateEditLink","_updateData","_updateCompact"],this);}getDefaultPosition(){return "bottom-right"}onAdd(e){const t=this.options&&this.options.compact;return this._map=e,this._container=a.create("div","mapboxgl-ctrl mapboxgl-ctrl-attrib"),this._compactButton=a.create("button","mapboxgl-ctrl-attrib-button",this._container),a.create("span","mapboxgl-ctrl-icon",this._compactButton).setAttribute("aria-hidden",!0),this._compactButton.type="button",this._compactButton.addEventListener("click",this._toggleAttribution),this._setElementTitle(this._compactButton,"ToggleAttribution"),this._innerContainer=a.create("div","mapboxgl-ctrl-attrib-inner",this._container),this._innerContainer.setAttribute("role","list"),t&&this._container.classList.add("mapboxgl-compact"),this._updateAttributions(),this._updateEditLink(),this._map.on("styledata",this._updateData),this._map.on("sourcedata",this._updateData),this._map.on("moveend",this._updateEditLink),void 0===t&&(this._map.on("resize",this._updateCompact),this._updateCompact()),this._container}onRemove(){this._container.remove(),this._map.off("styledata",this._updateData),this._map.off("sourcedata",this._updateData),this._map.off("moveend",this._updateEditLink),this._map.off("resize",this._updateCompact),this._map=void 0,this._attribHTML=void 0;}_setElementTitle(e,t){const i=this._map._getUIString(`AttributionControl.${t}`);e.setAttribute("aria-label",i),e.removeAttribute("title"),e.firstElementChild&&e.firstElementChild.setAttribute("title",i);}_toggleAttribution(){this._container.classList.contains("mapboxgl-compact-show")?(this._container.classList.remove("mapboxgl-compact-show"),this._compactButton.setAttribute("aria-expanded","false")):(this._container.classList.add("mapboxgl-compact-show"),this._compactButton.setAttribute("aria-expanded","true"));}_updateEditLink(){let t=this._editLink;t||(t=this._editLink=this._container.querySelector(".mapbox-improve-map"));const i=[{key:"owner",value:this.styleOwner},{key:"id",value:this.styleId},{key:"access_token",value:this._map._requestManager._customAccessToken||e.config.ACCESS_TOKEN}];if(t){const o=i.reduce(((e,t,o)=>(t.value&&(e+=`${t.key}=${t.value}${o<i.length-1?"&":""}`),e)),"?");t.href=`${e.config.FEEDBACK_URL}/${o}${this._map._hash?this._map._hash.getHashString(!0):""}`,t.rel="noopener nofollow",this._setElementTitle(t,"MapFeedback");}}_updateData(e){!e||"metadata"!==e.sourceDataType&&"visibility"!==e.sourceDataType&&"style"!==e.dataType||(this._updateAttributions(),this._updateEditLink());}_updateAttributions(){if(!this._map.style)return;let e=[];if(this._map.style.stylesheet){const e=this._map.style.stylesheet;this.styleOwner=e.owner,this.styleId=e.id;}const t=this._map.style._sourceCaches;for(const i in t){const o=t[i];if(o.used){const t=o.getSource();t.attribution&&e.indexOf(t.attribution)<0&&e.push(t.attribution);}}e.sort(((e,t)=>e.length-t.length)),e=e.filter(((t,i)=>{for(let o=i+1;o<e.length;o++)if(e[o].indexOf(t)>=0)return !1;return !0})),this.options.customAttribution&&(Array.isArray(this.options.customAttribution)?e=[...this.options.customAttribution,...e]:e.unshift(this.options.customAttribution));const i=e.join(" | ");i!==this._attribHTML&&(this._attribHTML=i,e.length?(this._innerContainer.innerHTML=i,this._container.classList.remove("mapboxgl-attrib-empty")):this._container.classList.add("mapboxgl-attrib-empty"),this._editLink=null);}_updateCompact(){this._map.getCanvasContainer().offsetWidth<=640?this._container.classList.add("mapboxgl-compact"):this._container.classList.remove("mapboxgl-compact","mapboxgl-compact-show");}}class Sr{constructor(){e.bindAll(["_updateLogo"],this),e.bindAll(["_updateCompact"],this);}onAdd(e){this._map=e,this._container=a.create("div","mapboxgl-ctrl");const t=a.create("a","mapboxgl-ctrl-logo");return t.target="_blank",t.rel="noopener nofollow",t.href="https://www.mapbox.com/",t.setAttribute("aria-label",this._map._getUIString("LogoControl.Title")),t.setAttribute("rel","noopener nofollow"),this._container.appendChild(t),this._container.style.display="none",this._map.on("sourcedata",this._updateLogo),this._updateLogo(),this._map.on("resize",this._updateCompact),this._updateCompact(),this._container}onRemove(){this._container.remove(),this._map.off("sourcedata",this._updateLogo),this._map.off("resize",this._updateCompact);}getDefaultPosition(){return "bottom-left"}_updateLogo(e){e&&"metadata"!==e.sourceDataType||(this._container.style.display=this._logoRequired()?"block":"none");}_logoRequired(){if(!this._map.style)return !0;const e=this._map.style._sourceCaches;if(0===Object.entries(e).length)return !0;for(const t in e){const i=e[t].getSource();if(i.hasOwnProperty("mapbox_logo")&&!i.mapbox_logo)return !1}return !0}_updateCompact(){const e=this._container.children;if(e.length){const t=e[0];this._map.getCanvasContainer().offsetWidth<250?t.classList.add("mapboxgl-compact"):t.classList.remove("mapboxgl-compact");}}}class Ir{constructor(){this._queue=[],this._id=0,this._cleared=!1,this._currentlyRunning=!1;}add(e){const t=++this._id;return this._queue.push({callback:e,id:t,cancelled:!1}),t}remove(e){const t=this._currentlyRunning,i=t?this._queue.concat(t):this._queue;for(const t of i)if(t.id===e)return void(t.cancelled=!0)}run(e=0){const t=this._currentlyRunning=this._queue;this._queue=[];for(const i of t)if(!i.cancelled&&(i.callback(e),this._cleared))break;this._cleared=!1,this._currentlyRunning=!1;}clear(){this._currentlyRunning&&(this._cleared=!0),this._queue=[];}}function zr(t,i,o){if(t=new e.LngLat(t.lng,t.lat),i){const r=new e.LngLat(t.lng-360,t.lat),n=new e.LngLat(t.lng+360,t.lat),a=360*Math.ceil(Math.abs(t.lng-o.center.lng)/360),s=o.locationPoint(t).distSqr(i),l=i.x<0||i.y<0||i.x>o.width||i.y>o.height;o.locationPoint(r).distSqr(i)<s&&(l||Math.abs(r.lng-o.center.lng)<a)?t=r:o.locationPoint(n).distSqr(i)<s&&(l||Math.abs(n.lng-o.center.lng)<a)&&(t=n);}for(;Math.abs(t.lng-o.center.lng)>180;){const e=o.locationPoint(t);if(e.x>=0&&e.y>=0&&e.x<=o.width&&e.y<=o.height)break;t.lng>o.center.lng?t.lng-=360:t.lng+=360;}return t}const Dr={center:"translate(-50%,-50%)",top:"translate(-50%,0)","top-left":"translate(0,0)","top-right":"translate(-100%,0)",bottom:"translate(-50%,-100%)","bottom-left":"translate(0,-100%)","bottom-right":"translate(-100%,-100%)",left:"translate(0,-50%)",right:"translate(-100%,-50%)"};class Pr extends e.Evented{constructor(t,i){if(super(),(t instanceof e.window.HTMLElement||i)&&(t=e.extend({element:t},i)),e.bindAll(["_update","_onMove","_onUp","_addDragHandler","_onMapClick","_onKeyPress","_clearFadeTimer"],this),this._anchor=t&&t.anchor||"center",this._color=t&&t.color||"#3FB1CE",this._scale=t&&t.scale||1,this._draggable=t&&t.draggable||!1,this._clickTolerance=t&&t.clickTolerance||0,this._isDragging=!1,this._state="inactive",this._rotation=t&&t.rotation||0,this._rotationAlignment=t&&t.rotationAlignment||"auto",this._pitchAlignment=t&&t.pitchAlignment&&"auto"!==t.pitchAlignment?t.pitchAlignment:this._rotationAlignment,this._updateMoving=()=>this._update(!0),t&&t.element)this._element=t.element,this._offset=e.pointGeometry.convert(t&&t.offset||[0,0]);else {this._defaultMarker=!0,this._element=a.create("div");const i=41,o=27,r=a.createSVG("svg",{display:"block",height:i*this._scale+"px",width:o*this._scale+"px",viewBox:`0 0 ${o} ${i}`},this._element),n=a.createSVG("radialGradient",{id:"shadowGradient"},a.createSVG("defs",{},r));a.createSVG("stop",{offset:"10%","stop-opacity":.4},n),a.createSVG("stop",{offset:"100%","stop-opacity":.05},n),a.createSVG("ellipse",{cx:13.5,cy:34.8,rx:10.5,ry:5.25,fill:"url(#shadowGradient)"},r),a.createSVG("path",{fill:this._color,d:"M27,13.5C27,19.07 20.25,27 14.75,34.5C14.02,35.5 12.98,35.5 12.25,34.5C6.75,27 0,19.22 0,13.5C0,6.04 6.04,0 13.5,0C20.96,0 27,6.04 27,13.5Z"},r),a.createSVG("path",{opacity:.25,d:"M13.5,0C6.04,0 0,6.04 0,13.5C0,19.22 6.75,27 12.25,34.5C13,35.52 14.02,35.5 14.75,34.5C20.25,27 27,19.07 27,13.5C27,6.04 20.96,0 13.5,0ZM13.5,1C20.42,1 26,6.58 26,13.5C26,15.9 24.5,19.18 22.22,22.74C19.95,26.3 16.71,30.14 13.94,33.91C13.74,34.18 13.61,34.32 13.5,34.44C13.39,34.32 13.26,34.18 13.06,33.91C10.28,30.13 7.41,26.31 5.02,22.77C2.62,19.23 1,15.95 1,13.5C1,6.58 6.58,1 13.5,1Z"},r),a.createSVG("circle",{fill:"white",cx:13.5,cy:13.5,r:5.5},r),this._offset=e.pointGeometry.convert(t&&t.offset||[0,-14]);}this._element.hasAttribute("aria-label")||this._element.setAttribute("aria-label","Map marker"),this._element.classList.add("mapboxgl-marker"),this._element.addEventListener("dragstart",(e=>{e.preventDefault();})),this._element.addEventListener("mousedown",(e=>{e.preventDefault();}));const o=this._element.classList;for(const e in Dr)o.remove(`mapboxgl-marker-anchor-${e}`);o.add(`mapboxgl-marker-anchor-${this._anchor}`),this._popup=null;}addTo(e){return e===this._map||(this.remove(),this._map=e,e.getCanvasContainer().appendChild(this._element),e.on("move",this._updateMoving),e.on("moveend",this._update),e.on("remove",this._clearFadeTimer),e._addMarker(this),this.setDraggable(this._draggable),this._update(),this._map.on("click",this._onMapClick)),this}remove(){return this._map&&(this._map.off("click",this._onMapClick),this._map.off("move",this._updateMoving),this._map.off("moveend",this._update),this._map.off("mousedown",this._addDragHandler),this._map.off("touchstart",this._addDragHandler),this._map.off("mouseup",this._onUp),this._map.off("touchend",this._onUp),this._map.off("mousemove",this._onMove),this._map.off("touchmove",this._onMove),this._map.off("remove",this._clearFadeTimer),this._map._removeMarker(this),delete this._map),this._clearFadeTimer(),this._element.remove(),this._popup&&this._popup.remove(),this}getLngLat(){return this._lngLat}setLngLat(t){return this._lngLat=e.LngLat.convert(t),this._pos=null,this._popup&&this._popup.setLngLat(this._lngLat),this._update(!0),this}getElement(){return this._element}setPopup(e){if(this._popup&&(this._popup.remove(),this._popup=null,this._element.removeAttribute("role"),this._element.removeEventListener("keypress",this._onKeyPress),this._originalTabIndex||this._element.removeAttribute("tabindex")),e){if(!("offset"in e.options)){const t=38.1,i=13.5,o=Math.sqrt(Math.pow(i,2)/2);e.options.offset=this._defaultMarker?{top:[0,0],"top-left":[0,0],"top-right":[0,0],bottom:[0,-t],"bottom-left":[o,-1*(t-i+o)],"bottom-right":[-o,-1*(t-i+o)],left:[i,-1*(t-i)],right:[-i,-1*(t-i)]}:this._offset;}this._popup=e,this._lngLat&&this._popup.setLngLat(this._lngLat),this._element.setAttribute("role","button"),this._originalTabIndex=this._element.getAttribute("tabindex"),this._originalTabIndex||this._element.setAttribute("tabindex","0"),this._element.addEventListener("keypress",this._onKeyPress),this._element.setAttribute("aria-expanded","false");}return this}_onKeyPress(e){const t=e.code,i=e.charCode||e.keyCode;"Space"!==t&&"Enter"!==t&&32!==i&&13!==i||this.togglePopup();}_onMapClick(e){const t=e.originalEvent.target,i=this._element;this._popup&&(t===i||i.contains(t))&&this.togglePopup();}getPopup(){return this._popup}togglePopup(){const e=this._popup;return e?(e.isOpen()?(e.remove(),this._element.setAttribute("aria-expanded","false")):(e.addTo(this._map),this._element.setAttribute("aria-expanded","true")),this):this}_evaluateOpacity(){const e=this._pos?this._pos.sub(this._transformedOffset()):null;if(!this._withinScreenBounds(e))return void this._clearFadeTimer();const t=this._map.unproject(e);let i=!1;if(this._map.transform._terrainEnabled()&&this._map.getTerrain()){const e=this._map.getFreeCameraOptions();if(e.position){const o=e.position.toLngLat();i=o.distanceTo(t)<.9*o.distanceTo(this._lngLat);}}const o=(1-this._map._queryFogOpacity(t))*(i?.2:1);this._element.style.opacity=`${o}`,this._popup&&this._popup._setOpacity(`${o}`),this._fadeTimer=null;}_clearFadeTimer(){this._fadeTimer&&(clearTimeout(this._fadeTimer),this._fadeTimer=null);}_withinScreenBounds(e){const t=this._map.transform;return !!e&&e.x>=0&&e.x<t.width&&e.y>=0&&e.y<t.height}_updateDOM(){const t=this._pos||new e.pointGeometry(0,0),i=this._calculatePitch(),o=this._calculateRotation();this._element.style.transform=`${Dr[this._anchor]} translate(${t.x}px, ${t.y}px) rotateX(${i}deg) rotateZ(${o}deg)`;}_calculatePitch(){return "viewport"===this._pitchAlignment||"auto"===this._pitchAlignment?0:"map"===this._pitchAlignment?this._map.getPitch():0}_calculateRotation(){return "viewport"===this._rotationAlignment||"auto"===this._rotationAlignment?this._rotation:"map"===this._rotationAlignment?this._rotation-this._map.getBearing():0}_update(t){e.window.cancelAnimationFrame(this._updateFrameId),this._map&&(this._map.transform.renderWorldCopies&&(this._lngLat=zr(this._lngLat,this._pos,this._map.transform)),this._pos=this._map.project(this._lngLat)._add(this._transformedOffset()),!0===t?this._updateFrameId=e.window.requestAnimationFrame((()=>{this._element&&this._pos&&this._anchor&&(this._pos=this._pos.round(),this._updateDOM());})):this._pos=this._pos.round(),this._map._requestDomTask((()=>{this._map&&(this._element&&this._pos&&this._anchor&&this._updateDOM(),!this._map.getTerrain()&&!this._map.getFog()||this._fadeTimer||(this._fadeTimer=setTimeout(this._evaluateOpacity.bind(this),60)));})));}_transformedOffset(){if(!this._defaultMarker)return this._offset;const e=this._map.transform,t=this._offset.mult(this._scale);return "map"===this._rotationAlignment&&t._rotate(e.angle),"map"===this._pitchAlignment&&(t.y*=Math.cos(e._pitch)),t}getOffset(){return this._offset}setOffset(t){return this._offset=e.pointGeometry.convert(t),this._update(),this}_onMove(t){if(!this._isDragging){const e=this._clickTolerance||this._map._clickTolerance;this._isDragging=t.point.dist(this._pointerdownPos)>=e;}this._isDragging&&(this._pos=t.point.sub(this._positionDelta),this._lngLat=this._map.unproject(this._pos),this.setLngLat(this._lngLat),this._element.style.pointerEvents="none","pending"===this._state&&(this._state="active",this.fire(new e.Event("dragstart"))),this.fire(new e.Event("drag")));}_onUp(){this._element.style.pointerEvents="auto",this._positionDelta=null,this._pointerdownPos=null,this._isDragging=!1,this._map.off("mousemove",this._onMove),this._map.off("touchmove",this._onMove),"active"===this._state&&this.fire(new e.Event("dragend")),this._state="inactive";}_addDragHandler(e){this._element.contains(e.originalEvent.target)&&(e.preventDefault(),this._positionDelta=e.point.sub(this._pos).add(this._transformedOffset()),this._pointerdownPos=e.point,this._state="pending",this._map.on("mousemove",this._onMove),this._map.on("touchmove",this._onMove),this._map.once("mouseup",this._onUp),this._map.once("touchend",this._onUp));}setDraggable(e){return this._draggable=!!e,this._map&&(e?(this._map.on("mousedown",this._addDragHandler),this._map.on("touchstart",this._addDragHandler)):(this._map.off("mousedown",this._addDragHandler),this._map.off("touchstart",this._addDragHandler))),this}isDraggable(){return this._draggable}setRotation(e){return this._rotation=e||0,this._update(),this}getRotation(){return this._rotation}setRotationAlignment(e){return this._rotationAlignment=e||"auto",this._update(),this}getRotationAlignment(){return this._rotationAlignment}setPitchAlignment(e){return this._pitchAlignment=e&&"auto"!==e?e:this._rotationAlignment,this._update(),this}getPitchAlignment(){return this._pitchAlignment}}class Ar{constructor(e){this.jumpTo(e);}getValue(t){if(t<=this._startTime)return this._start;if(t>=this._endTime)return this._end;const i=e.easeCubicInOut((t-this._startTime)/(this._endTime-this._startTime));return this._start*(1-i)+this._end*i}isEasing(e){return e>=this._startTime&&e<=this._endTime}jumpTo(e){this._startTime=-1/0,this._endTime=-1/0,this._start=e,this._end=e;}easeTo(e,t,i){this._start=this.getValue(t),this._end=e,this._startTime=t,this._endTime=t+i;}}const Lr={"AttributionControl.ToggleAttribution":"Toggle attribution","AttributionControl.MapFeedback":"Map feedback","FullscreenControl.Enter":"Enter fullscreen","FullscreenControl.Exit":"Exit fullscreen","GeolocateControl.FindMyLocation":"Find my location","GeolocateControl.LocationNotAvailable":"Location not available","LogoControl.Title":"Mapbox logo","NavigationControl.ResetBearing":"Reset bearing to north","NavigationControl.ZoomIn":"Zoom in","NavigationControl.ZoomOut":"Zoom out","ScaleControl.Feet":"ft","ScaleControl.Meters":"m","ScaleControl.Kilometers":"km","ScaleControl.Miles":"mi","ScaleControl.NauticalMiles":"nm","ScrollZoomBlocker.CtrlMessage":"Use ctrl + scroll to zoom the map","ScrollZoomBlocker.CmdMessage":"Use ⌘ + scroll to zoom the map","TouchPanBlocker.Message":"Use two fingers to move the map"},{HTMLImageElement:Rr,HTMLElement:kr,ImageBitmap:Or}=e.window,Br={center:[0,0],zoom:0,bearing:0,pitch:0,minZoom:-2,maxZoom:22,minPitch:0,maxPitch:85,interactive:!0,scrollZoom:!0,boxZoom:!0,dragRotate:!0,dragPan:!0,keyboard:!0,doubleClickZoom:!0,touchZoomRotate:!0,touchPitch:!0,cooperativeGestures:!1,bearingSnap:7,clickTolerance:3,pitchWithRotate:!0,hash:!1,attributionControl:!0,failIfMajorPerformanceCaveat:!1,preserveDrawingBuffer:!1,trackResize:!0,optimizeForTerrain:!0,renderWorldCopies:!0,refreshExpiredTiles:!0,maxTileCacheSize:null,localIdeographFontFamily:"sans-serif",localFontFamily:null,transformRequest:null,accessToken:null,fadeDuration:300,crossSourceCollisions:!0};function Fr(e){e.parentNode&&e.parentNode.removeChild(e);}const Ur={showCompass:!0,showZoom:!0,visualizePitch:!1};class Nr{constructor(t,i,o=!1){this._clickTolerance=10,this.element=i,this.mouseRotate=new Yo({clickTolerance:t.dragRotate._mouseRotate._clickTolerance}),this.map=t,o&&(this.mousePitch=new Jo({clickTolerance:t.dragRotate._mousePitch._clickTolerance})),e.bindAll(["mousedown","mousemove","mouseup","touchstart","touchmove","touchend","reset"],this),i.addEventListener("mousedown",this.mousedown),i.addEventListener("touchstart",this.touchstart,{passive:!1}),i.addEventListener("touchmove",this.touchmove),i.addEventListener("touchend",this.touchend),i.addEventListener("touchcancel",this.reset);}down(e,t){this.mouseRotate.mousedown(e,t),this.mousePitch&&this.mousePitch.mousedown(e,t),a.disableDrag();}move(e,t){const i=this.map,o=this.mouseRotate.mousemoveWindow(e,t);if(o&&o.bearingDelta&&i.setBearing(i.getBearing()+o.bearingDelta),this.mousePitch){const o=this.mousePitch.mousemoveWindow(e,t);o&&o.pitchDelta&&i.setPitch(i.getPitch()+o.pitchDelta);}}off(){const e=this.element;e.removeEventListener("mousedown",this.mousedown),e.removeEventListener("touchstart",this.touchstart,{passive:!1}),e.removeEventListener("touchmove",this.touchmove),e.removeEventListener("touchend",this.touchend),e.removeEventListener("touchcancel",this.reset),this.offTemp();}offTemp(){a.enableDrag(),e.window.removeEventListener("mousemove",this.mousemove),e.window.removeEventListener("mouseup",this.mouseup);}mousedown(t){this.down(e.extend({},t,{ctrlKey:!0,preventDefault:()=>t.preventDefault()}),a.mousePos(this.element,t)),e.window.addEventListener("mousemove",this.mousemove),e.window.addEventListener("mouseup",this.mouseup);}mousemove(e){this.move(e,a.mousePos(this.element,e));}mouseup(e){this.mouseRotate.mouseupWindow(e),this.mousePitch&&this.mousePitch.mouseupWindow(e),this.offTemp();}touchstart(e){1!==e.targetTouches.length?this.reset():(this._startPos=this._lastPos=a.touchPos(this.element,e.targetTouches)[0],this.down({type:"mousedown",button:0,ctrlKey:!0,preventDefault:()=>e.preventDefault()},this._startPos));}touchmove(e){1!==e.targetTouches.length?this.reset():(this._lastPos=a.touchPos(this.element,e.targetTouches)[0],this.move({preventDefault:()=>e.preventDefault()},this._lastPos));}touchend(e){0===e.targetTouches.length&&this._startPos&&this._lastPos&&this._startPos.dist(this._lastPos)<this._clickTolerance&&this.element.click(),this.reset();}reset(){this.mouseRotate.reset(),this.mousePitch&&this.mousePitch.reset(),delete this._startPos,delete this._lastPos,this.offTemp();}}const Gr={positionOptions:{enableHighAccuracy:!1,maximumAge:0,timeout:6e3},fitBoundsOptions:{maxZoom:15},trackUserLocation:!1,showAccuracyCircle:!0,showUserLocation:!0,showUserHeading:!1};let jr,Zr=0,Vr=!1;const Wr={maxWidth:100,unit:"metric"};function qr(e,t,i){const o=i&&i.maxWidth||100,r=e._containerHeight/2,n=e.unproject([0,r]),a=e.unproject([o,r]),s=n.distanceTo(a);if(i&&"imperial"===i.unit){const i=3.2808*s;i>5280?Xr(t,o,i/5280,e._getUIString("ScaleControl.Miles"),e):Xr(t,o,i,e._getUIString("ScaleControl.Feet"),e);}else i&&"nautical"===i.unit?Xr(t,o,s/1852,e._getUIString("ScaleControl.NauticalMiles"),e):s>=1e3?Xr(t,o,s/1e3,e._getUIString("ScaleControl.Kilometers"),e):Xr(t,o,s,e._getUIString("ScaleControl.Meters"),e);}function Xr(e,t,i,o,r){const n=function(e){const t=Math.pow(10,`${Math.floor(e)}`.length-1);let i=e/t;return i=i>=10?10:i>=5?5:i>=3?3:i>=2?2:i>=1?1:function(e){const t=Math.pow(10,Math.ceil(-Math.log(e)/Math.LN10));return Math.round(e*t)/t}(i),t*i}(i),a=n/i;r._requestDomTask((()=>{e.style.width=t*a+"px",e.innerHTML=`${n}&nbsp;${o}`;}));}const $r={closeButton:!0,closeOnClick:!0,focusAfterOpen:!0,className:"",maxWidth:"240px"},Hr=["a[href]","[tabindex]:not([tabindex='-1'])","[contenteditable]:not([contenteditable='false'])","button:not([disabled])","input:not([disabled])","select:not([disabled])","textarea:not([disabled])"].join(", "),Kr={version:e.version,supported:t,setRTLTextPlugin:e.setRTLTextPlugin,getRTLTextPluginStatus:e.getRTLTextPluginStatus,Map:class extends Cr{constructor(t){if(null!=(t=e.extend({},Br,t)).minZoom&&null!=t.maxZoom&&t.minZoom>t.maxZoom)throw new Error("maxZoom must be greater than or equal to minZoom");if(null!=t.minPitch&&null!=t.maxPitch&&t.minPitch>t.maxPitch)throw new Error("maxPitch must be greater than or equal to minPitch");if(null!=t.minPitch&&t.minPitch<0)throw new Error("minPitch must be greater than or equal to 0");if(null!=t.maxPitch&&t.maxPitch>85)throw new Error("maxPitch must be less than or equal to 85");if(super(new So(t.minZoom,t.maxZoom,t.minPitch,t.maxPitch,t.renderWorldCopies),t),this._interactive=t.interactive,this._minTileCacheSize=t.minTileCacheSize,this._maxTileCacheSize=t.maxTileCacheSize,this._failIfMajorPerformanceCaveat=t.failIfMajorPerformanceCaveat,this._preserveDrawingBuffer=t.preserveDrawingBuffer,this._antialias=t.antialias,this._trackResize=t.trackResize,this._bearingSnap=t.bearingSnap,this._refreshExpiredTiles=t.refreshExpiredTiles,this._fadeDuration=t.fadeDuration,this._isInitialLoad=!0,this._crossSourceCollisions=t.crossSourceCollisions,this._crossFadingFactor=1,this._collectResourceTiming=t.collectResourceTiming,this._optimizeForTerrain=t.optimizeForTerrain,this._renderTaskQueue=new Ir,this._domRenderTaskQueue=new Ir,this._controls=[],this._markers=[],this._mapId=e.uniqueId(),this._locale=e.extend({},Lr,t.locale),this._clickTolerance=t.clickTolerance,this._cooperativeGestures=t.cooperativeGestures,this._containerWidth=0,this._containerHeight=0,this._averageElevationLastSampledAt=-1/0,this._averageElevation=new Ar(0),this._requestManager=new e.RequestManager(t.transformRequest,t.accessToken,t.testMode),this._silenceAuthErrors=!!t.testMode,"string"==typeof t.container){if(this._container=e.window.document.getElementById(t.container),!this._container)throw new Error(`Container '${t.container}' not found.`)}else {if(!(t.container instanceof kr))throw new Error("Invalid type: 'container' must be a String or HTMLElement.");this._container=t.container;}if(this._container.childNodes.length>0&&e.warnOnce("The map container element should be empty, otherwise the map's interactivity will be negatively impacted. If you want to display a message when WebGL is not supported, use the Mapbox GL Supported plugin instead."),t.maxBounds&&this.setMaxBounds(t.maxBounds),e.bindAll(["_onWindowOnline","_onWindowResize","_onMapScroll","_contextLost","_contextRestored"],this),this._setupContainer(),this._setupPainter(),void 0===this.painter)throw new Error("Failed to initialize WebGL.");this.on("move",(()=>this._update(!1))),this.on("moveend",(()=>this._update(!1))),this.on("zoom",(()=>this._update(!0))),void 0!==e.window&&(e.window.addEventListener("online",this._onWindowOnline,!1),e.window.addEventListener("resize",this._onWindowResize,!1),e.window.addEventListener("orientationchange",this._onWindowResize,!1),e.window.addEventListener("webkitfullscreenchange",this._onWindowResize,!1)),this.handlers=new Tr(this,t),this._localFontFamily=t.localFontFamily,this._localIdeographFontFamily=t.localIdeographFontFamily,t.style&&this.setStyle(t.style,{localFontFamily:this._localFontFamily,localIdeographFontFamily:this._localIdeographFontFamily}),t.projection&&this.setProjection(t.projection),this._hash=t.hash&&new zo("string"==typeof t.hash&&t.hash||void 0).addTo(this),this._hash&&this._hash._onHashChange()||(this.jumpTo({center:t.center,zoom:t.zoom,bearing:t.bearing,pitch:t.pitch}),t.bounds&&(this.resize(),this.fitBounds(t.bounds,e.extend({},t.fitBoundsOptions,{duration:0})))),this.resize(),t.attributionControl&&this.addControl(new Mr({customAttribution:t.customAttribution})),this._logoControl=new Sr,this.addControl(this._logoControl,t.logoPosition),this.on("style.load",(()=>{this.transform.unmodified&&this.jumpTo(this.style.stylesheet);})),this.on("data",(t=>{this._update("style"===t.dataType),this.fire(new e.Event(`${t.dataType}data`,t));})),this.on("dataloading",(t=>{this.fire(new e.Event(`${t.dataType}dataloading`,t));}));}_getMapId(){return this._mapId}addControl(t,i){if(void 0===i&&(i=t.getDefaultPosition?t.getDefaultPosition():"top-right"),!t||!t.onAdd)return this.fire(new e.ErrorEvent(new Error("Invalid argument to map.addControl(). Argument must be a control with onAdd and onRemove methods.")));const o=t.onAdd(this);this._controls.push(t);const r=this._controlPositions[i];return -1!==i.indexOf("bottom")?r.insertBefore(o,r.firstChild):r.appendChild(o),this}removeControl(t){if(!t||!t.onRemove)return this.fire(new e.ErrorEvent(new Error("Invalid argument to map.removeControl(). Argument must be a control with onAdd and onRemove methods.")));const i=this._controls.indexOf(t);return i>-1&&this._controls.splice(i,1),t.onRemove(this),this}hasControl(e){return this._controls.indexOf(e)>-1}getContainer(){return this._container}getCanvasContainer(){return this._canvasContainer}getCanvas(){return this._canvas}resize(t){if(this._updateContainerDimensions(),this._containerWidth===this.transform.width&&this._containerHeight===this.transform.height)return this;this._resizeCanvas(this._containerWidth,this._containerHeight),this.transform.resize(this._containerWidth,this._containerHeight),this.painter.resize(Math.ceil(this._containerWidth),Math.ceil(this._containerHeight));const i=!this._moving;return i&&this.fire(new e.Event("movestart",t)).fire(new e.Event("move",t)),this.fire(new e.Event("resize",t)),i&&this.fire(new e.Event("moveend",t)),this}getBounds(){return this.transform.getBounds()}getMaxBounds(){return this.transform.getMaxBounds()||null}setMaxBounds(t){return this.transform.setMaxBounds(e.LngLatBounds.convert(t)),this._update()}setMinZoom(t){if((t=null==t?-2:t)>=-2&&t<=this.transform.maxZoom)return this.transform.minZoom=t,this._update(),this.getZoom()<t?this.setZoom(t):this.fire(new e.Event("zoomstart")).fire(new e.Event("zoom")).fire(new e.Event("zoomend")),this;throw new Error("minZoom must be between -2 and the current maxZoom, inclusive")}getMinZoom(){return this.transform.minZoom}setMaxZoom(t){if((t=null==t?22:t)>=this.transform.minZoom)return this.transform.maxZoom=t,this._update(),this.getZoom()>t?this.setZoom(t):this.fire(new e.Event("zoomstart")).fire(new e.Event("zoom")).fire(new e.Event("zoomend")),this;throw new Error("maxZoom must be greater than the current minZoom")}getMaxZoom(){return this.transform.maxZoom}setMinPitch(t){if((t=null==t?0:t)<0)throw new Error("minPitch must be greater than or equal to 0");if(t>=0&&t<=this.transform.maxPitch)return this.transform.minPitch=t,this._update(),this.getPitch()<t?this.setPitch(t):this.fire(new e.Event("pitchstart")).fire(new e.Event("pitch")).fire(new e.Event("pitchend")),this;throw new Error("minPitch must be between 0 and the current maxPitch, inclusive")}getMinPitch(){return this.transform.minPitch}setMaxPitch(t){if((t=null==t?85:t)>85)throw new Error("maxPitch must be less than or equal to 85");if(t>=this.transform.minPitch)return this.transform.maxPitch=t,this._update(),this.getPitch()>t?this.setPitch(t):this.fire(new e.Event("pitchstart")).fire(new e.Event("pitch")).fire(new e.Event("pitchend")),this;throw new Error("maxPitch must be greater than the current minPitch")}getMaxPitch(){return this.transform.maxPitch}getRenderWorldCopies(){return this.transform.renderWorldCopies}setRenderWorldCopies(e){return this.transform.renderWorldCopies=e,this._update()}getProjection(){return this.transform.getProjection()}setProjection(e){return this._lazyInitEmptyStyle(),"string"==typeof e&&(e={name:e}),this._runtimeProjection=e,this.style.updateProjection(),this._transitionFromGlobe=!1,this}project(t){return this.transform.locationPoint3D(e.LngLat.convert(t))}unproject(t){return this.transform.pointLocation3D(e.pointGeometry.convert(t))}isMoving(){return this._moving||this.handlers&&this.handlers.isMoving()}isZooming(){return this._zooming||this.handlers&&this.handlers.isZooming()}isRotating(){return this._rotating||this.handlers&&this.handlers.isRotating()}_createDelegatedListener(e,t,i){if("mouseenter"===e||"mouseover"===e){let o=!1;const r=r=>{const n=t.filter((e=>this.getLayer(e))),a=n.length?this.queryRenderedFeatures(r.point,{layers:n}):[];a.length?o||(o=!0,i.call(this,new Fo(e,this,r.originalEvent,{features:a}))):o=!1;},n=()=>{o=!1;};return {layers:new Set(t),listener:i,delegates:{mousemove:r,mouseout:n}}}if("mouseleave"===e||"mouseout"===e){let o=!1;const r=r=>{const n=t.filter((e=>this.getLayer(e)));(n.length?this.queryRenderedFeatures(r.point,{layers:n}):[]).length?o=!0:o&&(o=!1,i.call(this,new Fo(e,this,r.originalEvent)));},n=t=>{o&&(o=!1,i.call(this,new Fo(e,this,t.originalEvent)));};return {layers:new Set(t),listener:i,delegates:{mousemove:r,mouseout:n}}}{const o=e=>{const o=t.filter((e=>this.getLayer(e))),r=o.length?this.queryRenderedFeatures(e.point,{layers:o}):[];r.length&&(e.features=r,i.call(this,e),delete e.features);};return {layers:new Set(t),listener:i,delegates:{[e]:o}}}}on(e,t,i){if(void 0===i)return super.on(e,t);Array.isArray(t)||(t=[t]);const o=this._createDelegatedListener(e,t,i);this._delegatedListeners=this._delegatedListeners||{},this._delegatedListeners[e]=this._delegatedListeners[e]||[],this._delegatedListeners[e].push(o);for(const e in o.delegates)this.on(e,o.delegates[e]);return this}once(e,t,i){if(void 0===i)return super.once(e,t);Array.isArray(t)||(t=[t]);const o=this._createDelegatedListener(e,t,i);for(const e in o.delegates)this.once(e,o.delegates[e]);return this}off(e,t,i){if(void 0===i)return super.off(e,t);t=new Set(Array.isArray(t)?t:[t]);const o=(e,t)=>{if(e.size!==t.size)return !1;for(const i of e)if(!t.has(i))return !1;return !0},r=this._delegatedListeners?this._delegatedListeners[e]:void 0;return r&&(e=>{for(let r=0;r<e.length;r++){const n=e[r];if(n.listener===i&&o(n.layers,t)){for(const e in n.delegates)this.off(e,n.delegates[e]);return e.splice(r,1),this}}})(r),this}queryRenderedFeatures(t,i){return this.style?(void 0!==i||void 0===t||t instanceof e.pointGeometry||Array.isArray(t)||(i=t,t=void 0),this.style.queryRenderedFeatures(t=t||[[0,0],[this.transform.width,this.transform.height]],i=i||{},this.transform)):[]}querySourceFeatures(e,t){return this.style.querySourceFeatures(e,t)}queryTerrainElevation(t,i){const o=this.transform.elevation;return o?(i=e.extend({},{exaggerated:!0},i),o.getAtPoint(e.MercatorCoordinate.fromLngLat(t),null,i.exaggerated)):null}setStyle(t,i){return !1!==(i=e.extend({},{localIdeographFontFamily:this._localIdeographFontFamily,localFontFamily:this._localFontFamily},i)).diff&&i.localIdeographFontFamily===this._localIdeographFontFamily&&i.localFontFamily===this._localFontFamily&&this.style&&t?(this._diffStyle(t,i),this):(this._localIdeographFontFamily=i.localIdeographFontFamily,this._localFontFamily=i.localFontFamily,this._updateStyle(t,i))}_getUIString(e){const t=this._locale[e];if(null==t)throw new Error(`Missing UI string '${e}'`);return t}_updateStyle(e,t){return this.style&&(this.style.setEventedParent(null),this.style._remove(),delete this.style),e&&(this.style=new Nt(this,t||{}),this.style.setEventedParent(this,{style:this.style}),"string"==typeof e?this.style.loadURL(e):this.style.loadJSON(e)),this._updateTerrain(),this}_lazyInitEmptyStyle(){this.style||(this.style=new Nt(this,{}),this.style.setEventedParent(this,{style:this.style}),this.style.loadEmpty());}_diffStyle(t,i){if("string"==typeof t){const o=this._requestManager.normalizeStyleURL(t),r=this._requestManager.transformRequest(o,e.ResourceType.Style);e.getJSON(r,((t,o)=>{t?this.fire(new e.ErrorEvent(t)):o&&this._updateDiff(o,i);}));}else "object"==typeof t&&this._updateDiff(t,i);}_updateDiff(t,i){try{this.style.setState(t)&&this._update(!0);}catch(o){e.warnOnce(`Unable to perform style diff: ${o.message||o.error||o}.  Rebuilding the style from scratch.`),this._updateStyle(t,i);}}getStyle(){if(this.style)return this.style.serialize()}isStyleLoaded(){return this.style?this.style.loaded():e.warnOnce("There is no style added to the map.")}addSource(e,t){return this._lazyInitEmptyStyle(),this.style.addSource(e,t),this._update(!0)}isSourceLoaded(t){const i=this.style&&this.style._getSourceCaches(t);if(0!==i.length)return i.every((e=>e.loaded()));this.fire(new e.ErrorEvent(new Error(`There is no source with ID '${t}'`)));}areTilesLoaded(){const e=this.style&&this.style._sourceCaches;for(const t in e){const i=e[t]._tiles;for(const e in i){const t=i[e];if("loaded"!==t.state&&"errored"!==t.state)return !1}}return !0}addSourceType(e,t,i){return this._lazyInitEmptyStyle(),this.style.addSourceType(e,t,i)}removeSource(e){return this.style.removeSource(e),this._updateTerrain(),this._update(!0)}getSource(e){return this.style.getSource(e)}addImage(t,i,{pixelRatio:o=1,sdf:r=!1,stretchX:n,stretchY:a,content:s}={}){if(this._lazyInitEmptyStyle(),i instanceof Rr||Or&&i instanceof Or){const{width:l,height:c,data:h}=e.exported.getImageData(i);this.style.addImage(t,{data:new e.RGBAImage({width:l,height:c},h),pixelRatio:o,stretchX:n,stretchY:a,content:s,sdf:r,version:0});}else {if(void 0===i.width||void 0===i.height)return this.fire(new e.ErrorEvent(new Error("Invalid arguments to map.addImage(). The second argument must be an `HTMLImageElement`, `ImageData`, `ImageBitmap`, or object with `width`, `height`, and `data` properties with the same format as `ImageData`")));{const{width:l,height:c,data:h}=i,u=i;this.style.addImage(t,{data:new e.RGBAImage({width:l,height:c},new Uint8Array(h)),pixelRatio:o,stretchX:n,stretchY:a,content:s,sdf:r,version:0,userImage:u}),u.onAdd&&u.onAdd(this,t);}}}updateImage(t,i){const o=this.style.getImage(t);if(!o)return this.fire(new e.ErrorEvent(new Error("The map has no image with that id. If you are adding a new image use `map.addImage(...)` instead.")));const r=i instanceof Rr||Or&&i instanceof Or?e.exported.getImageData(i):i,{width:n,height:a,data:s}=r;return void 0===n||void 0===a?this.fire(new e.ErrorEvent(new Error("Invalid arguments to map.updateImage(). The second argument must be an `HTMLImageElement`, `ImageData`, `ImageBitmap`, or object with `width`, `height`, and `data` properties with the same format as `ImageData`"))):n!==o.data.width||a!==o.data.height?this.fire(new e.ErrorEvent(new Error("The width and height of the updated image must be that same as the previous version of the image"))):(o.data.replace(s,!(i instanceof Rr||Or&&i instanceof Or)),void this.style.updateImage(t,o))}hasImage(t){return t?!!this.style.getImage(t):(this.fire(new e.ErrorEvent(new Error("Missing required image id"))),!1)}removeImage(e){this.style.removeImage(e);}loadImage(t,i){e.getImage(this._requestManager.transformRequest(t,e.ResourceType.Image),((t,o)=>{i(t,o instanceof Rr?e.exported.getImageData(o):o);}));}listImages(){return this.style.listImages()}addLayer(e,t){return this._lazyInitEmptyStyle(),this.style.addLayer(e,t),this._update(!0)}moveLayer(e,t){return this.style.moveLayer(e,t),this._update(!0)}removeLayer(e){return this.style.removeLayer(e),this._update(!0)}getLayer(e){return this.style.getLayer(e)}setLayerZoomRange(e,t,i){return this.style.setLayerZoomRange(e,t,i),this._update(!0)}setFilter(e,t,i={}){return this.style.setFilter(e,t,i),this._update(!0)}getFilter(e){return this.style.getFilter(e)}setPaintProperty(e,t,i,o={}){return this.style.setPaintProperty(e,t,i,o),this._update(!0)}getPaintProperty(e,t){return this.style.getPaintProperty(e,t)}setLayoutProperty(e,t,i,o={}){return this.style.setLayoutProperty(e,t,i,o),this._update(!0)}getLayoutProperty(e,t){return this.style.getLayoutProperty(e,t)}setLight(e,t={}){return this._lazyInitEmptyStyle(),this.style.setLight(e,t),this._update(!0)}getLight(){return this.style.getLight()}setTerrain(e){return this._lazyInitEmptyStyle(),!e&&this.transform.projection.requiresDraping?this.style.setTerrainForDraping():this.style.setTerrain(e),this._averageElevationLastSampledAt=-1/0,this._update(!0)}_updateProjection(){"globe"===this.transform.projection.name&&this.transform.zoom>=e.GLOBE_ZOOM_THRESHOLD_MAX&&!this._transitionFromGlobe&&(this.setProjection({name:"mercator"}),this._transitionFromGlobe=!0);}getTerrain(){return this.style?this.style.getTerrain():null}setFog(e){return this._lazyInitEmptyStyle(),this.style.setFog(e),this._update(!0)}getFog(){return this.style?this.style.getFog():null}_queryFogOpacity(t){return this.style&&this.style.fog?this.style.fog.getOpacityAtLatLng(e.LngLat.convert(t),this.transform):0}setFeatureState(e,t){return this.style.setFeatureState(e,t),this._update()}removeFeatureState(e,t){return this.style.removeFeatureState(e,t),this._update()}getFeatureState(e){return this.style.getFeatureState(e)}_updateContainerDimensions(){if(!this._container)return;const t=this._container.getBoundingClientRect().width||400,i=this._container.getBoundingClientRect().height||300;let o,r=this._container;for(;r&&!o;){const t=e.window.getComputedStyle(r).transform;t&&"none"!==t&&(o=t.match(/matrix.*\((.+)\)/)[1].split(", ")),r=r.parentElement;}o?(this._containerWidth=o[0]&&"0"!==o[0]?Math.abs(t/o[0]):t,this._containerHeight=o[3]&&"0"!==o[3]?Math.abs(i/o[3]):i):(this._containerWidth=t,this._containerHeight=i);}_detectMissingCSS(){"rgb(250, 128, 114)"!==e.window.getComputedStyle(this._missingCSSCanary).getPropertyValue("background-color")&&e.warnOnce("This page appears to be missing CSS declarations for Mapbox GL JS, which may cause the map to display incorrectly. Please ensure your page includes mapbox-gl.css, as described in https://www.mapbox.com/mapbox-gl-js/api/.");}_setupContainer(){const e=this._container;e.classList.add("mapboxgl-map"),(this._missingCSSCanary=a.create("div","mapboxgl-canary",e)).style.visibility="hidden",this._detectMissingCSS();const t=this._canvasContainer=a.create("div","mapboxgl-canvas-container",e);this._interactive&&t.classList.add("mapboxgl-interactive"),this._canvas=a.create("canvas","mapboxgl-canvas",t),this._canvas.addEventListener("webglcontextlost",this._contextLost,!1),this._canvas.addEventListener("webglcontextrestored",this._contextRestored,!1),this._canvas.setAttribute("tabindex","0"),this._canvas.setAttribute("aria-label","Map"),this._canvas.setAttribute("role","region"),this._updateContainerDimensions(),this._resizeCanvas(this._containerWidth,this._containerHeight);const i=this._controlContainer=a.create("div","mapboxgl-control-container",e),o=this._controlPositions={};["top-left","top-right","bottom-left","bottom-right"].forEach((e=>{o[e]=a.create("div",`mapboxgl-ctrl-${e}`,i);})),this._container.addEventListener("scroll",this._onMapScroll,!1);}_resizeCanvas(t,i){const o=e.exported.devicePixelRatio||1;this._canvas.width=o*Math.ceil(t),this._canvas.height=o*Math.ceil(i),this._canvas.style.width=`${t}px`,this._canvas.style.height=`${i}px`;}_addMarker(e){this._markers.push(e);}_removeMarker(e){const t=this._markers.indexOf(e);-1!==t&&this._markers.splice(t,1);}_setupPainter(){const i=e.extend({},t.webGLContextAttributes,{failIfMajorPerformanceCaveat:this._failIfMajorPerformanceCaveat,preserveDrawingBuffer:this._preserveDrawingBuffer,antialias:this._antialias||!1}),o=this._canvas.getContext("webgl",i)||this._canvas.getContext("experimental-webgl",i);o?(e.storeAuthState(o,!0),this.painter=new _o(o,this.transform),this.on("data",(e=>{"source"===e.dataType&&this.painter.setTileLoadedFlag(!0);})),e.exported$1.testSupport(o)):this.fire(new e.ErrorEvent(new Error("Failed to initialize WebGL")));}_contextLost(t){t.preventDefault(),this._frame&&(this._frame.cancel(),this._frame=null),this.fire(new e.Event("webglcontextlost",{originalEvent:t}));}_contextRestored(t){this._setupPainter(),this.resize(),this._update(),this.fire(new e.Event("webglcontextrestored",{originalEvent:t}));}_onMapScroll(e){if(e.target===this._container)return this._container.scrollTop=0,this._container.scrollLeft=0,!1}loaded(){return !this._styleDirty&&!this._sourcesDirty&&!!this.style&&this.style.loaded()}_update(e){return this.style?(this._styleDirty=this._styleDirty||e,this._sourcesDirty=!0,this.triggerRepaint(),this):this}_requestRenderFrame(e){return this._update(),this._renderTaskQueue.add(e)}_cancelRenderFrame(e){this._renderTaskQueue.remove(e);}_requestDomTask(e){!this.loaded()||this.loaded()&&!this.isMoving()?e():this._domRenderTaskQueue.add(e);}_render(t){let i;const o=this.painter.context.extTimerQuery,r=e.exported.now();this.listens("gpu-timing-frame")&&(i=o.createQueryEXT(),o.beginQueryEXT(o.TIME_ELAPSED_EXT,i));let n=this._updateAverageElevation(r);if(this.painter.context.setDirty(),this.painter.setBaseState(),this._renderTaskQueue.run(t),this._domRenderTaskQueue.run(t),this._removed)return;this._updateProjection();let a=!1;const s=this._isInitialLoad?0:this._fadeDuration;if(this.style&&this._styleDirty){this._styleDirty=!1;const t=this.transform.zoom,i=this.transform.pitch,o=e.exported.now();this.style.zoomHistory.update(t,o);const r=new e.EvaluationParameters(t,{now:o,fadeDuration:s,pitch:i,zoomHistory:this.style.zoomHistory,transition:this.style.getTransition()}),n=r.crossFadingFactor();1===n&&n===this._crossFadingFactor||(a=!0,this._crossFadingFactor=n),this.style.update(r);}if(this.style&&this.style.fog&&this.style.fog.hasTransition()&&(this.style._markersNeedUpdate=!0,this._sourcesDirty=!0),this.style&&this._sourcesDirty&&(this._sourcesDirty=!1,this.painter._updateFog(this.style),this._updateTerrain(),this.style._updateSources(this.transform),this._forceMarkerUpdate()),this._placementDirty=this.style&&this.style._updatePlacement(this.painter.transform,this.showCollisionBoxes,s,this._crossSourceCollisions),this.style&&this.painter.render(this.style,{showTileBoundaries:this.showTileBoundaries,showTerrainWireframe:this.showTerrainWireframe,showOverdrawInspector:this._showOverdrawInspector,showQueryGeometry:!!this._showQueryGeometry,rotating:this.isRotating(),zooming:this.isZooming(),moving:this.isMoving(),fadeDuration:s,isInitialLoad:this._isInitialLoad,showPadding:this.showPadding,gpuTiming:!!this.listens("gpu-timing-layer"),speedIndexTiming:this.speedIndexTiming}),this.fire(new e.Event("render")),this.loaded()&&!this._loaded&&(this._loaded=!0,this.fire(new e.Event("load"))),this.style&&(this.style.hasTransitions()||a)&&(this._styleDirty=!0),this.style&&!this._placementDirty&&this.style._releaseSymbolFadeTiles(),this.listens("gpu-timing-frame")){const t=e.exported.now()-r;o.endQueryEXT(o.TIME_ELAPSED_EXT,i),setTimeout((()=>{const r=o.getQueryObjectEXT(i,o.QUERY_RESULT_EXT)/1e6;o.deleteQueryEXT(i),this.fire(new e.Event("gpu-timing-frame",{cpuTime:t,gpuTime:r}));}),50);}if(this.listens("gpu-timing-layer")){const t=this.painter.collectGpuTimers();setTimeout((()=>{const i=this.painter.queryGpuTimers(t);this.fire(new e.Event("gpu-timing-layer",{layerTimes:i}));}),50);}const l=this._sourcesDirty||this._styleDirty||this._placementDirty||n;if(l||this._repaint)this.triggerRepaint();else {const t=!this.isMoving()&&this.loaded();if(t&&(n=this._updateAverageElevation(r,!0)),n)this.triggerRepaint();else if(this._triggerFrame(!1),t&&(this.fire(new e.Event("idle")),this._isInitialLoad=!1,this.speedIndexTiming)){const t=this._calculateSpeedIndex();this.fire(new e.Event("speedindexcompleted",{speedIndex:t})),this.speedIndexTiming=!1;}}return !this._loaded||this._fullyLoaded||l||(this._fullyLoaded=!0,this._authenticate()),this}_forceMarkerUpdate(){for(const e of this._markers)e._update();}_updateAverageElevation(e,t=!1){const i=e=>(this.transform.averageElevation=e,this._update(!1),!0);if(!this.painter.averageElevationNeedsEasing())return 0!==this.transform.averageElevation&&i(0);if((t||e-this._averageElevationLastSampledAt>500)&&!this._averageElevation.isEasing(e)){const t=this.transform.averageElevation;let o=this.transform.sampleAverageElevation();isNaN(o)?o=0:this._averageElevationLastSampledAt=e;const r=Math.abs(t-o);if(r>1){if(this._isInitialLoad)return this._averageElevation.jumpTo(o),i(o);this._averageElevation.easeTo(o,e,300);}else if(r>1e-4)return this._averageElevation.jumpTo(o),i(o)}return !!this._averageElevation.isEasing(e)&&i(this._averageElevation.getValue(e))}_authenticate(){e.getMapSessionAPI(this._getMapId(),this._requestManager._skuToken,this._requestManager._customAccessToken,(t=>{if(t&&(t.message===e.AUTH_ERR_MSG||401===t.status)){const t=this.painter.context.gl;e.storeAuthState(t,!1),this._logoControl instanceof Sr&&this._logoControl._updateLogo(),t&&t.clear(t.DEPTH_BUFFER_BIT|t.COLOR_BUFFER_BIT|t.STENCIL_BUFFER_BIT),this._silenceAuthErrors||this.fire(new e.ErrorEvent(new Error("A valid Mapbox access token is required to use Mapbox GL JS. To create an account or a new access token, visit https://account.mapbox.com/")));}})),e.postMapLoadEvent(this._getMapId(),this._requestManager._skuToken,this._requestManager._customAccessToken,(()=>{}));}_updateTerrain(){this.painter.updateTerrain(this.style,this.isMoving()||this.isRotating()||this.isZooming());}_calculateSpeedIndex(){const e=this.painter.canvasCopy(),t=this.painter.getCanvasCopiesAndTimestamps();t.timeStamps.push(performance.now());const i=this.painter.context.gl,o=i.createFramebuffer();function r(e){i.framebufferTexture2D(i.FRAMEBUFFER,i.COLOR_ATTACHMENT0,i.TEXTURE_2D,e,0);const t=new Uint8Array(i.drawingBufferWidth*i.drawingBufferHeight*4);return i.readPixels(0,0,i.drawingBufferWidth,i.drawingBufferHeight,i.RGBA,i.UNSIGNED_BYTE,t),t}return i.bindFramebuffer(i.FRAMEBUFFER,o),this._canvasPixelComparison(r(e),t.canvasCopies.map(r),t.timeStamps)}_canvasPixelComparison(e,t,i){let o=i[1]-i[0];const r=e.length/4;for(let n=0;n<t.length;n++){const a=t[n];let s=0;for(let t=0;t<a.length;t+=4)a[t]===e[t]&&a[t+1]===e[t+1]&&a[t+2]===e[t+2]&&a[t+3]===e[t+3]&&(s+=1);o+=(i[n+2]-i[n+1])*(1-s/r);}return o}remove(){this._hash&&this._hash.remove();for(const e of this._controls)e.onRemove(this);this._controls=[],this._frame&&(this._frame.cancel(),this._frame=null),this._renderTaskQueue.clear(),this._domRenderTaskQueue.clear(),this.style&&this.style.destroy(),this.painter.destroy(),this.handlers.destroy(),delete this.handlers,this.setStyle(null),void 0!==e.window&&(e.window.removeEventListener("resize",this._onWindowResize,!1),e.window.removeEventListener("orientationchange",this._onWindowResize,!1),e.window.removeEventListener("webkitfullscreenchange",this._onWindowResize,!1),e.window.removeEventListener("online",this._onWindowOnline,!1));const t=this.painter.context.gl.getExtension("WEBGL_lose_context");t&&t.loseContext(),Fr(this._canvasContainer),Fr(this._controlContainer),Fr(this._missingCSSCanary),this._container.classList.remove("mapboxgl-map"),e.removeAuthState(this.painter.context.gl),this._removed=!0,this.fire(new e.Event("remove"));}triggerRepaint(){this._triggerFrame(!0);}_triggerFrame(t){this._renderNextFrame=this._renderNextFrame||t,this.style&&!this._frame&&(this._frame=e.exported.frame((e=>{const t=!!this._renderNextFrame;this._frame=null,this._renderNextFrame=null,t&&this._render(e);})));}_preloadTiles(t){const i=this.style&&Object.values(this.style._sourceCaches)||[];return e.asyncAll(i,((e,i)=>e._preloadTiles(t,i)),(()=>{this.triggerRepaint();})),this}_onWindowOnline(){this._update();}_onWindowResize(e){this._trackResize&&this.resize({originalEvent:e})._update();}get showTileBoundaries(){return !!this._showTileBoundaries}set showTileBoundaries(e){this._showTileBoundaries!==e&&(this._showTileBoundaries=e,this._update());}get showTerrainWireframe(){return !!this._showTerrainWireframe}set showTerrainWireframe(e){this._showTerrainWireframe!==e&&(this._showTerrainWireframe=e,this._update());}get speedIndexTiming(){return !!this._speedIndexTiming}set speedIndexTiming(e){this._speedIndexTiming!==e&&(this._speedIndexTiming=e,this._update());}get showPadding(){return !!this._showPadding}set showPadding(e){this._showPadding!==e&&(this._showPadding=e,this._update());}get showCollisionBoxes(){return !!this._showCollisionBoxes}set showCollisionBoxes(e){this._showCollisionBoxes!==e&&(this._showCollisionBoxes=e,e?this.style._generateCollisionBoxes():this._update());}get showOverdrawInspector(){return !!this._showOverdrawInspector}set showOverdrawInspector(e){this._showOverdrawInspector!==e&&(this._showOverdrawInspector=e,this._update());}get repaint(){return !!this._repaint}set repaint(e){this._repaint!==e&&(this._repaint=e,this.triggerRepaint());}get vertices(){return !!this._vertices}set vertices(e){this._vertices=e,this._update();}_setCacheLimits(t,i){e.setCacheLimits(t,i);}get version(){return e.version}},NavigationControl:class{constructor(t){this.options=e.extend({},Ur,t),this._container=a.create("div","mapboxgl-ctrl mapboxgl-ctrl-group"),this._container.addEventListener("contextmenu",(e=>e.preventDefault())),this.options.showZoom&&(e.bindAll(["_setButtonTitle","_updateZoomButtons"],this),this._zoomInButton=this._createButton("mapboxgl-ctrl-zoom-in",(e=>this._map.zoomIn({},{originalEvent:e}))),a.create("span","mapboxgl-ctrl-icon",this._zoomInButton).setAttribute("aria-hidden",!0),this._zoomOutButton=this._createButton("mapboxgl-ctrl-zoom-out",(e=>this._map.zoomOut({},{originalEvent:e}))),a.create("span","mapboxgl-ctrl-icon",this._zoomOutButton).setAttribute("aria-hidden",!0)),this.options.showCompass&&(e.bindAll(["_rotateCompassArrow"],this),this._compass=this._createButton("mapboxgl-ctrl-compass",(e=>{this.options.visualizePitch?this._map.resetNorthPitch({},{originalEvent:e}):this._map.resetNorth({},{originalEvent:e});})),this._compassIcon=a.create("span","mapboxgl-ctrl-icon",this._compass),this._compassIcon.setAttribute("aria-hidden",!0));}_updateZoomButtons(){const e=this._map.getZoom(),t=e===this._map.getMaxZoom(),i=e===this._map.getMinZoom();this._zoomInButton.disabled=t,this._zoomOutButton.disabled=i,this._zoomInButton.setAttribute("aria-disabled",t.toString()),this._zoomOutButton.setAttribute("aria-disabled",i.toString());}_rotateCompassArrow(){const e=this.options.visualizePitch?`scale(${1/Math.pow(Math.cos(this._map.transform.pitch*(Math.PI/180)),.5)}) rotateX(${this._map.transform.pitch}deg) rotateZ(${this._map.transform.angle*(180/Math.PI)}deg)`:`rotate(${this._map.transform.angle*(180/Math.PI)}deg)`;this._map._requestDomTask((()=>{this._compassIcon&&(this._compassIcon.style.transform=e);}));}onAdd(e){return this._map=e,this.options.showZoom&&(this._setButtonTitle(this._zoomInButton,"ZoomIn"),this._setButtonTitle(this._zoomOutButton,"ZoomOut"),this._map.on("zoom",this._updateZoomButtons),this._updateZoomButtons()),this.options.showCompass&&(this._setButtonTitle(this._compass,"ResetBearing"),this.options.visualizePitch&&this._map.on("pitch",this._rotateCompassArrow),this._map.on("rotate",this._rotateCompassArrow),this._rotateCompassArrow(),this._handler=new Nr(this._map,this._compass,this.options.visualizePitch)),this._container}onRemove(){this._container.remove(),this.options.showZoom&&this._map.off("zoom",this._updateZoomButtons),this.options.showCompass&&(this.options.visualizePitch&&this._map.off("pitch",this._rotateCompassArrow),this._map.off("rotate",this._rotateCompassArrow),this._handler.off(),delete this._handler),delete this._map;}_createButton(e,t){const i=a.create("button",e,this._container);return i.type="button",i.addEventListener("click",t),i}_setButtonTitle(e,t){const i=this._map._getUIString(`NavigationControl.${t}`);e.setAttribute("aria-label",i),e.firstElementChild&&e.firstElementChild.setAttribute("title",i);}},GeolocateControl:class extends e.Evented{constructor(t){super(),this.options=e.extend({},Gr,t),e.bindAll(["_onSuccess","_onError","_onZoom","_finish","_setupUI","_updateCamera","_updateMarker","_updateMarkerRotation"],this),this._onDeviceOrientationListener=this._onDeviceOrientation.bind(this),this._updateMarkerRotationThrottled=Io(this._updateMarkerRotation,20);}onAdd(t){var i;return this._map=t,this._container=a.create("div","mapboxgl-ctrl mapboxgl-ctrl-group"),i=this._setupUI,void 0!==jr?i(jr):void 0!==e.window.navigator.permissions?e.window.navigator.permissions.query({name:"geolocation"}).then((e=>{jr="denied"!==e.state,i(jr);})):(jr=!!e.window.navigator.geolocation,i(jr)),this._container}onRemove(){void 0!==this._geolocationWatchID&&(e.window.navigator.geolocation.clearWatch(this._geolocationWatchID),this._geolocationWatchID=void 0),this.options.showUserLocation&&this._userLocationDotMarker&&this._userLocationDotMarker.remove(),this.options.showAccuracyCircle&&this._accuracyCircleMarker&&this._accuracyCircleMarker.remove(),this._container.remove(),this._map.off("zoom",this._onZoom),this._map=void 0,Zr=0,Vr=!1;}_isOutOfMapMaxBounds(e){const t=this._map.getMaxBounds(),i=e.coords;return t&&(i.longitude<t.getWest()||i.longitude>t.getEast()||i.latitude<t.getSouth()||i.latitude>t.getNorth())}_setErrorState(){switch(this._watchState){case"WAITING_ACTIVE":this._watchState="ACTIVE_ERROR",this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-active"),this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-active-error");break;case"ACTIVE_LOCK":this._watchState="ACTIVE_ERROR",this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-active"),this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-active-error"),this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-waiting");break;case"BACKGROUND":this._watchState="BACKGROUND_ERROR",this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-background"),this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-background-error"),this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-waiting");}}_onSuccess(t){if(this._map){if(this._isOutOfMapMaxBounds(t))return this._setErrorState(),this.fire(new e.Event("outofmaxbounds",t)),this._updateMarker(),void this._finish();if(this.options.trackUserLocation)switch(this._lastKnownPosition=t,this._watchState){case"WAITING_ACTIVE":case"ACTIVE_LOCK":case"ACTIVE_ERROR":this._watchState="ACTIVE_LOCK",this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-active-error"),this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-active");break;case"BACKGROUND":case"BACKGROUND_ERROR":this._watchState="BACKGROUND",this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-background-error"),this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-background");}this.options.showUserLocation&&"OFF"!==this._watchState&&this._updateMarker(t),this.options.trackUserLocation&&"ACTIVE_LOCK"!==this._watchState||this._updateCamera(t),this.options.showUserLocation&&this._dotElement.classList.remove("mapboxgl-user-location-dot-stale"),this.fire(new e.Event("geolocate",t)),this._finish();}}_updateCamera(t){const i=new e.LngLat(t.coords.longitude,t.coords.latitude),o=t.coords.accuracy,r=this._map.getBearing(),n=e.extend({bearing:r},this.options.fitBoundsOptions);this._map.fitBounds(i.toBounds(o),n,{geolocateSource:!0});}_updateMarker(t){if(t){const i=new e.LngLat(t.coords.longitude,t.coords.latitude);this._accuracyCircleMarker.setLngLat(i).addTo(this._map),this._userLocationDotMarker.setLngLat(i).addTo(this._map),this._accuracy=t.coords.accuracy,this.options.showUserLocation&&this.options.showAccuracyCircle&&this._updateCircleRadius();}else this._userLocationDotMarker.remove(),this._accuracyCircleMarker.remove();}_updateCircleRadius(){const e=this._map._containerHeight/2,t=this._map.unproject([0,e]),i=this._map.unproject([100,e]),o=t.distanceTo(i)/100,r=Math.ceil(2*this._accuracy/o);this._circleElement.style.width=`${r}px`,this._circleElement.style.height=`${r}px`;}_onZoom(){this.options.showUserLocation&&this.options.showAccuracyCircle&&this._updateCircleRadius();}_updateMarkerRotation(){this._userLocationDotMarker&&"number"==typeof this._heading?(this._userLocationDotMarker.setRotation(this._heading),this._dotElement.classList.add("mapboxgl-user-location-show-heading")):(this._dotElement.classList.remove("mapboxgl-user-location-show-heading"),this._userLocationDotMarker.setRotation(0));}_onError(t){if(this._map){if(this.options.trackUserLocation)if(1===t.code){this._watchState="OFF",this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-active"),this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-active-error"),this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-background"),this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-background-error"),this._geolocateButton.disabled=!0;const e=this._map._getUIString("GeolocateControl.LocationNotAvailable");this._geolocateButton.setAttribute("aria-label",e),this._geolocateButton.firstElementChild&&this._geolocateButton.firstElementChild.setAttribute("title",e),void 0!==this._geolocationWatchID&&this._clearWatch();}else {if(3===t.code&&Vr)return;this._setErrorState();}"OFF"!==this._watchState&&this.options.showUserLocation&&this._dotElement.classList.add("mapboxgl-user-location-dot-stale"),this.fire(new e.Event("error",t)),this._finish();}}_finish(){this._timeoutId&&clearTimeout(this._timeoutId),this._timeoutId=void 0;}_setupUI(t){if(this._container.addEventListener("contextmenu",(e=>e.preventDefault())),this._geolocateButton=a.create("button","mapboxgl-ctrl-geolocate",this._container),a.create("span","mapboxgl-ctrl-icon",this._geolocateButton).setAttribute("aria-hidden",!0),this._geolocateButton.type="button",!1===t){e.warnOnce("Geolocation support is not available so the GeolocateControl will be disabled.");const t=this._map._getUIString("GeolocateControl.LocationNotAvailable");this._geolocateButton.disabled=!0,this._geolocateButton.setAttribute("aria-label",t),this._geolocateButton.firstElementChild&&this._geolocateButton.firstElementChild.setAttribute("title",t);}else {const e=this._map._getUIString("GeolocateControl.FindMyLocation");this._geolocateButton.setAttribute("aria-label",e),this._geolocateButton.firstElementChild&&this._geolocateButton.firstElementChild.setAttribute("title",e);}this.options.trackUserLocation&&(this._geolocateButton.setAttribute("aria-pressed","false"),this._watchState="OFF"),this.options.showUserLocation&&(this._dotElement=a.create("div","mapboxgl-user-location"),this._dotElement.appendChild(a.create("div","mapboxgl-user-location-dot")),this._dotElement.appendChild(a.create("div","mapboxgl-user-location-heading")),this._userLocationDotMarker=new Pr({element:this._dotElement,rotationAlignment:"map",pitchAlignment:"map"}),this._circleElement=a.create("div","mapboxgl-user-location-accuracy-circle"),this._accuracyCircleMarker=new Pr({element:this._circleElement,pitchAlignment:"map"}),this.options.trackUserLocation&&(this._watchState="OFF"),this._map.on("zoom",this._onZoom)),this._geolocateButton.addEventListener("click",this.trigger.bind(this)),this._setup=!0,this.options.trackUserLocation&&this._map.on("movestart",(t=>{t.geolocateSource||"ACTIVE_LOCK"!==this._watchState||t.originalEvent&&"resize"===t.originalEvent.type||(this._watchState="BACKGROUND",this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-background"),this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-active"),this.fire(new e.Event("trackuserlocationend")));}));}_onDeviceOrientation(e){this._userLocationDotMarker&&(e.webkitCompassHeading?this._heading=e.webkitCompassHeading:!0===e.absolute&&(this._heading=-1*e.alpha),this._updateMarkerRotationThrottled());}trigger(){if(!this._setup)return e.warnOnce("Geolocate control triggered before added to a map"),!1;if(this.options.trackUserLocation){switch(this._watchState){case"OFF":this._watchState="WAITING_ACTIVE",this.fire(new e.Event("trackuserlocationstart"));break;case"WAITING_ACTIVE":case"ACTIVE_LOCK":case"ACTIVE_ERROR":case"BACKGROUND_ERROR":Zr--,Vr=!1,this._watchState="OFF",this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-active"),this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-active-error"),this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-background"),this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-background-error"),this.fire(new e.Event("trackuserlocationend"));break;case"BACKGROUND":this._watchState="ACTIVE_LOCK",this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-background"),this._lastKnownPosition&&this._updateCamera(this._lastKnownPosition),this.fire(new e.Event("trackuserlocationstart"));}switch(this._watchState){case"WAITING_ACTIVE":this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-waiting"),this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-active");break;case"ACTIVE_LOCK":this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-active");break;case"ACTIVE_ERROR":this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-waiting"),this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-active-error");break;case"BACKGROUND":this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-background");break;case"BACKGROUND_ERROR":this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-waiting"),this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-background-error");}if("OFF"===this._watchState&&void 0!==this._geolocationWatchID)this._clearWatch();else if(void 0===this._geolocationWatchID){let t;this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-waiting"),this._geolocateButton.setAttribute("aria-pressed","true"),Zr++,Zr>1?(t={maximumAge:6e5,timeout:0},Vr=!0):(t=this.options.positionOptions,Vr=!1),this._geolocationWatchID=e.window.navigator.geolocation.watchPosition(this._onSuccess,this._onError,t),this.options.showUserHeading&&this._addDeviceOrientationListener();}}else e.window.navigator.geolocation.getCurrentPosition(this._onSuccess,this._onError,this.options.positionOptions),this._timeoutId=setTimeout(this._finish,1e4);return !0}_addDeviceOrientationListener(){const t=()=>{e.window.addEventListener("ondeviceorientationabsolute"in e.window?"deviceorientationabsolute":"deviceorientation",this._onDeviceOrientationListener);};void 0!==e.window.DeviceMotionEvent&&"function"==typeof e.window.DeviceMotionEvent.requestPermission?DeviceOrientationEvent.requestPermission().then((e=>{"granted"===e&&t();})).catch(console.error):t();}_clearWatch(){e.window.navigator.geolocation.clearWatch(this._geolocationWatchID),e.window.removeEventListener("deviceorientation",this._onDeviceOrientationListener),e.window.removeEventListener("deviceorientationabsolute",this._onDeviceOrientationListener),this._geolocationWatchID=void 0,this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-waiting"),this._geolocateButton.setAttribute("aria-pressed","false"),this.options.showUserLocation&&this._updateMarker(null);}},AttributionControl:Mr,ScaleControl:class{constructor(t){this.options=e.extend({},Wr,t),e.bindAll(["_onMove","setUnit"],this);}getDefaultPosition(){return "bottom-left"}_onMove(){qr(this._map,this._container,this.options);}onAdd(e){return this._map=e,this._container=a.create("div","mapboxgl-ctrl mapboxgl-ctrl-scale",e.getContainer()),this._map.on("move",this._onMove),this._onMove(),this._container}onRemove(){this._container.remove(),this._map.off("move",this._onMove),this._map=void 0;}setUnit(e){this.options.unit=e,qr(this._map,this._container,this.options);}},FullscreenControl:class{constructor(t){this._fullscreen=!1,t&&t.container&&(t.container instanceof e.window.HTMLElement?this._container=t.container:e.warnOnce("Full screen control 'container' must be a DOM element.")),e.bindAll(["_onClickFullscreen","_changeIcon"],this),"onfullscreenchange"in e.window.document?this._fullscreenchange="fullscreenchange":"onwebkitfullscreenchange"in e.window.document&&(this._fullscreenchange="webkitfullscreenchange");}onAdd(t){return this._map=t,this._container||(this._container=this._map.getContainer()),this._controlContainer=a.create("div","mapboxgl-ctrl mapboxgl-ctrl-group"),this._checkFullscreenSupport()?this._setupUI():(this._controlContainer.style.display="none",e.warnOnce("This device does not support fullscreen mode.")),this._controlContainer}onRemove(){this._controlContainer.remove(),this._map=null,e.window.document.removeEventListener(this._fullscreenchange,this._changeIcon);}_checkFullscreenSupport(){return !(!e.window.document.fullscreenEnabled&&!e.window.document.webkitFullscreenEnabled)}_setupUI(){const t=this._fullscreenButton=a.create("button","mapboxgl-ctrl-fullscreen",this._controlContainer);a.create("span","mapboxgl-ctrl-icon",t).setAttribute("aria-hidden",!0),t.type="button",this._updateTitle(),this._fullscreenButton.addEventListener("click",this._onClickFullscreen),e.window.document.addEventListener(this._fullscreenchange,this._changeIcon);}_updateTitle(){const e=this._getTitle();this._fullscreenButton.setAttribute("aria-label",e),this._fullscreenButton.firstElementChild&&this._fullscreenButton.firstElementChild.setAttribute("title",e);}_getTitle(){return this._map._getUIString(this._isFullscreen()?"FullscreenControl.Exit":"FullscreenControl.Enter")}_isFullscreen(){return this._fullscreen}_changeIcon(){(e.window.document.fullscreenElement||e.window.document.webkitFullscreenElement)===this._container!==this._fullscreen&&(this._fullscreen=!this._fullscreen,this._fullscreenButton.classList.toggle("mapboxgl-ctrl-shrink"),this._fullscreenButton.classList.toggle("mapboxgl-ctrl-fullscreen"),this._updateTitle());}_onClickFullscreen(){this._isFullscreen()?e.window.document.exitFullscreen?e.window.document.exitFullscreen():e.window.document.webkitCancelFullScreen&&e.window.document.webkitCancelFullScreen():this._container.requestFullscreen?this._container.requestFullscreen():this._container.webkitRequestFullscreen&&this._container.webkitRequestFullscreen();}},Popup:class extends e.Evented{constructor(t){super(),this.options=e.extend(Object.create($r),t),e.bindAll(["_update","_onClose","remove","_onMouseMove","_onMouseUp","_onDrag"],this),this._classList=new Set(t&&t.className?t.className.trim().split(/\s+/):[]);}addTo(t){return this._map&&this.remove(),this._map=t,this.options.closeOnClick&&this._map.on("preclick",this._onClose),this.options.closeOnMove&&this._map.on("move",this._onClose),this._map.on("remove",this.remove),this._update(),this._focusFirstElement(),this._trackPointer?(this._map.on("mousemove",this._onMouseMove),this._map.on("mouseup",this._onMouseUp),this._map._canvasContainer.classList.add("mapboxgl-track-pointer")):this._map.on("move",this._update),this.fire(new e.Event("open")),this}isOpen(){return !!this._map}remove(){return this._content&&this._content.remove(),this._container&&(this._container.remove(),delete this._container),this._map&&(this._map.off("move",this._update),this._map.off("move",this._onClose),this._map.off("click",this._onClose),this._map.off("remove",this.remove),this._map.off("mousemove",this._onMouseMove),this._map.off("mouseup",this._onMouseUp),this._map.off("drag",this._onDrag),delete this._map),this.fire(new e.Event("close")),this}getLngLat(){return this._lngLat}setLngLat(t){return this._lngLat=e.LngLat.convert(t),this._pos=null,this._trackPointer=!1,this._update(),this._map&&(this._map.on("move",this._update),this._map.off("mousemove",this._onMouseMove),this._map._canvasContainer.classList.remove("mapboxgl-track-pointer")),this}trackPointer(){return this._trackPointer=!0,this._pos=null,this._update(),this._map&&(this._map.off("move",this._update),this._map.on("mousemove",this._onMouseMove),this._map.on("drag",this._onDrag),this._map._canvasContainer.classList.add("mapboxgl-track-pointer")),this}getElement(){return this._container}setText(t){return this.setDOMContent(e.window.document.createTextNode(t))}setHTML(t){const i=e.window.document.createDocumentFragment(),o=e.window.document.createElement("body");let r;for(o.innerHTML=t;r=o.firstChild,r;)i.appendChild(r);return this.setDOMContent(i)}getMaxWidth(){return this._container&&this._container.style.maxWidth}setMaxWidth(e){return this.options.maxWidth=e,this._update(),this}setDOMContent(e){if(this._content)for(;this._content.hasChildNodes();)this._content.firstChild&&this._content.removeChild(this._content.firstChild);else this._content=a.create("div","mapboxgl-popup-content",this._container);return this._content.appendChild(e),this._createCloseButton(),this._update(),this._focusFirstElement(),this}addClassName(e){return this._classList.add(e),this._container&&this._updateClassList(),this}removeClassName(e){return this._classList.delete(e),this._container&&this._updateClassList(),this}setOffset(e){return this.options.offset=e,this._update(),this}toggleClassName(e){let t;return this._classList.delete(e)?t=!1:(this._classList.add(e),t=!0),this._container&&this._updateClassList(),t}_createCloseButton(){this.options.closeButton&&(this._closeButton=a.create("button","mapboxgl-popup-close-button",this._content),this._closeButton.type="button",this._closeButton.setAttribute("aria-label","Close popup"),this._closeButton.setAttribute("aria-hidden","true"),this._closeButton.innerHTML="&#215;",this._closeButton.addEventListener("click",this._onClose));}_onMouseUp(e){this._update(e.point);}_onMouseMove(e){this._update(e.point);}_onDrag(e){this._update(e.point);}_getAnchor(e){if(this.options.anchor)return this.options.anchor;const t=this._pos,i=this._container.offsetWidth,o=this._container.offsetHeight;let r;return r=t.y+e.bottom.y<o?["top"]:t.y>this._map.transform.height-o?["bottom"]:[],t.x<i/2?r.push("left"):t.x>this._map.transform.width-i/2&&r.push("right"),0===r.length?"bottom":r.join("-")}_updateClassList(){const e=[...this._classList];e.push("mapboxgl-popup"),this._anchor&&e.push(`mapboxgl-popup-anchor-${this._anchor}`),this._trackPointer&&e.push("mapboxgl-popup-track-pointer"),this._container.className=e.join(" ");}_update(t){if(this._map&&(this._lngLat||this._trackPointer)&&this._content){if(this._container||(this._container=a.create("div","mapboxgl-popup",this._map.getContainer()),this._tip=a.create("div","mapboxgl-popup-tip",this._container),this._container.appendChild(this._content)),this.options.maxWidth&&this._container.style.maxWidth!==this.options.maxWidth&&(this._container.style.maxWidth=this.options.maxWidth),this._map.transform.renderWorldCopies&&!this._trackPointer&&(this._lngLat=zr(this._lngLat,this._pos,this._map.transform)),!this._trackPointer||t){const i=this._pos=this._trackPointer&&t?t:this._map.project(this._lngLat),o=function(t){if(t||(t=new e.pointGeometry(0,0)),"number"==typeof t){const i=Math.round(Math.sqrt(.5*Math.pow(t,2)));return {center:new e.pointGeometry(0,0),top:new e.pointGeometry(0,t),"top-left":new e.pointGeometry(i,i),"top-right":new e.pointGeometry(-i,i),bottom:new e.pointGeometry(0,-t),"bottom-left":new e.pointGeometry(i,-i),"bottom-right":new e.pointGeometry(-i,-i),left:new e.pointGeometry(t,0),right:new e.pointGeometry(-t,0)}}if(t instanceof e.pointGeometry||Array.isArray(t)){const i=e.pointGeometry.convert(t);return {center:i,top:i,"top-left":i,"top-right":i,bottom:i,"bottom-left":i,"bottom-right":i,left:i,right:i}}return {center:e.pointGeometry.convert(t.center||[0,0]),top:e.pointGeometry.convert(t.top||[0,0]),"top-left":e.pointGeometry.convert(t["top-left"]||[0,0]),"top-right":e.pointGeometry.convert(t["top-right"]||[0,0]),bottom:e.pointGeometry.convert(t.bottom||[0,0]),"bottom-left":e.pointGeometry.convert(t["bottom-left"]||[0,0]),"bottom-right":e.pointGeometry.convert(t["bottom-right"]||[0,0]),left:e.pointGeometry.convert(t.left||[0,0]),right:e.pointGeometry.convert(t.right||[0,0])}}(this.options.offset),r=this._anchor=this._getAnchor(o),n=i.add(o[r]).round();this._map._requestDomTask((()=>{this._container&&r&&(this._container.style.transform=`${Dr[r]} translate(${n.x}px,${n.y}px)`);}));}this._updateClassList();}}_focusFirstElement(){if(!this.options.focusAfterOpen||!this._container)return;const e=this._container.querySelector(Hr);e&&e.focus();}_onClose(){this.remove();}_setOpacity(e){this._content&&(this._content.style.opacity=e),this._tip&&(this._tip.style.opacity=e);}},Marker:Pr,Style:Nt,LngLat:e.LngLat,LngLatBounds:e.LngLatBounds,Point:e.pointGeometry,MercatorCoordinate:e.MercatorCoordinate,FreeCameraOptions:xo,Evented:e.Evented,config:e.config,prewarm:function(){Ae().acquire(ze);},clearPrewarmedResources:function(){const e=Pe;e&&(e.isPreloaded()&&1===e.numActive()?(e.release(ze),Pe=null):console.warn("Could not clear WebWorkers since there are active Map instances that still reference it. The pre-warmed WebWorker pool can only be cleared when all map instances have been removed with map.remove()"));},get accessToken(){return e.config.ACCESS_TOKEN},set accessToken(t){e.config.ACCESS_TOKEN=t;},get baseApiUrl(){return e.config.API_URL},set baseApiUrl(t){e.config.API_URL=t;},get workerCount(){return De.workerCount},set workerCount(e){De.workerCount=e;},get maxParallelImageRequests(){return e.config.MAX_PARALLEL_IMAGE_REQUESTS},set maxParallelImageRequests(t){e.config.MAX_PARALLEL_IMAGE_REQUESTS=t;},clearStorage(t){e.clearTileCache(t);},workerUrl:"",workerClass:null,setNow:e.exported.setNow,restoreNow:e.exported.restoreNow};return Kr}));

//

var mapboxgl$1 = mapboxgl;

return mapboxgl$1;

})));
//# sourceMappingURL=mapbox-gl.js.map
